/*
 * Decompiled with CFR 0.152.
 */
package zio.interop.reactivestreams;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import zio.FiberId;
import zio.Promise;
import zio.Scope;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.interop.reactivestreams.Adapters$;
import zio.interop.reactivestreams.Adapters$DemandTrackingSubscription$State$;
import zio.stream.ZChannel;
import zio.stream.ZStream;

public final class Adapters {
    public static <O> ZStream<Object, Throwable, O> publisherToStream(Function0<Publisher<O>> function0, Function0<Object> function02, Object object) {
        return Adapters$.MODULE$.publisherToStream(function0, function02, object);
    }

    public static <R, I, L, Z> ZIO<R, Throwable, Tuple2<Subscriber<I>, ZIO<Object, Throwable, Z>>> sinkToSubscriber(Function0<ZChannel> function0, Function0<Object> function02, Object object) {
        return Adapters$.MODULE$.sinkToSubscriber(function0, function02, object);
    }

    public static <R, E extends Throwable, O> ZIO<R, Nothing$, Publisher<O>> streamToPublisher(Function0<ZStream<R, E, O>> function0, Object object) {
        return Adapters$.MODULE$.streamToPublisher(function0, object);
    }

    public static <E extends Throwable, I> ZIO<Scope, Nothing$, Tuple2<Function1<E, ZIO<Object, Nothing$, BoxedUnit>>, ZChannel>> subscriberToSink(Function0<Subscriber<I>> function0, Object object) {
        return Adapters$.MODULE$.subscriberToSink(function0, object);
    }

    private static class DemandTrackingSubscription
    implements Subscription {
        private final Subscriber<?> subscriber;
        private final Unsafe unsafe;
        public final Adapters$DemandTrackingSubscription$State$ State$lzy1;
        private final State canceled;
        private final AtomicReference<State> state;

        public DemandTrackingSubscription(Subscriber<?> subscriber, Unsafe unsafe) {
            this.subscriber = subscriber;
            this.unsafe = unsafe;
            this.State$lzy1 = new Adapters$DemandTrackingSubscription$State$(this);
            State initial = this.State().apply(0L, (Option<Tuple2<Object, Promise<BoxedUnit, Object>>>)None$.MODULE$);
            this.canceled = this.State().apply(-1L, (Option<Tuple2<Object, Promise<BoxedUnit, Object>>>)None$.MODULE$);
            this.state = new AtomicReference<State>(initial);
        }

        public Unsafe unsafe() {
            return this.unsafe;
        }

        private final Adapters$DemandTrackingSubscription$State$ State() {
            return this.State$lzy1;
        }

        private State requested(long n) {
            return this.State().apply(n, (Option<Tuple2<Object, Promise<BoxedUnit, Object>>>)None$.MODULE$);
        }

        private State awaiting(int n, Promise<BoxedUnit, Object> p) {
            return this.State().apply(0L, (Option<Tuple2<Object, Promise<BoxedUnit, Object>>>)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n), p)));
        }

        public ZIO offer(int n) {
            ObjectRef result = ObjectRef.create(null);
            this.state.updateAndGet(x$1 -> {
                State state;
                State state2 = x$1;
                State state3 = this.canceled;
                State state4 = state2;
                if (!(state3 != null ? !((Object)state3).equals(state4) : state4 != null)) {
                    ZIO zIO = ZIO$.MODULE$.fail((Function0)((JFunction0.mcV.sp & Serializable)this::offer$$anonfun$2$$anonfun$1), (Object)"zio.interop.reactivestreams.Adapters$.DemandTrackingSubscription.offer.macro(Adapters.scala:260)");
                    result$1.elem = zIO;
                    state = this.canceled;
                } else if (state2 != null) {
                    State state5 = this.State().unapply(state2);
                    long l = state5._1();
                    Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option = state5._2();
                    if (0L == l) {
                        Promise p = Promise.unsafe$.MODULE$.make((FiberId)FiberId.None$.MODULE$, this.unsafe());
                        ZIO zIO = p.await((Object)"zio.interop.reactivestreams.Adapters$.DemandTrackingSubscription.offer.macro(Adapters.scala:264)");
                        result$1.elem = zIO;
                        state = this.awaiting(n, (Promise<BoxedUnit, Object>)p);
                    } else {
                        State state6 = this.State().unapply(state2);
                        long l2 = state6._1();
                        Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option2 = state6._2();
                        long requestedCount = l2;
                        long newRequestedCount = Math.max(requestedCount - (long)n, 0L);
                        int accepted = (int)Math.min(requestedCount, (long)n);
                        ZIO zIO = ZIO$.MODULE$.succeedNow((Object)BoxesRunTime.boxToInteger((int)accepted));
                        result$1.elem = zIO;
                        state = this.requested(newRequestedCount);
                    }
                } else {
                    throw new MatchError((Object)state2);
                }
                return state;
            });
            return (ZIO)result.elem;
        }

        public boolean isCanceled() {
            return this.state.get().requestedCount() < 0L;
        }

        public void request(long n) {
            if (n <= 0L) {
                this.subscriber.onError((Throwable)new IllegalArgumentException("non-positive subscription request"));
            }
            ObjectRef notification = ObjectRef.create((JFunction0.mcV.sp & Serializable)() -> {});
            this.state.getAndUpdate(x$1 -> {
                State state;
                State state2 = x$1;
                State state3 = this.canceled;
                State state4 = state2;
                if (!(state3 != null ? !((Object)state3).equals(state4) : state4 != null)) {
                    state = this.canceled;
                    return state;
                }
                if (state2 != null) {
                    Tuple2 tuple2;
                    State state5 = this.State().unapply(state2);
                    long l = state5._1();
                    Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option = state5._2();
                    long requestedCount = l;
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        JFunction0.mcV.sp & Serializable intersect;
                        int offered = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        Promise toNotify = (Promise)tuple2._2();
                        long newRequestedCount = requestedCount + n;
                        long accepted = Math.min((long)offered, newRequestedCount);
                        long remaining = newRequestedCount - accepted;
                        notification$1.elem = intersect = (JFunction0.mcV.sp & Serializable)() -> toNotify.unsafe().done(ZIO$.MODULE$.succeedNow((Object)BoxesRunTime.boxToInteger((int)((int)accepted))), this.unsafe());
                        state = this.requested(remaining);
                        return state;
                    }
                    State state6 = this.State().unapply(state2);
                    long l2 = state6._1();
                    Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option2 = state6._2();
                    long requestedCount2 = l2;
                    if (Long.MAX_VALUE - n > requestedCount2) {
                        state = this.requested(requestedCount2 + n);
                        return state;
                    }
                }
                state = this.requested(Long.MAX_VALUE);
                return state;
            });
            ((Function0)notification.elem).apply$mcV$sp();
        }

        public void cancel() {
            this.state.getAndSet(this.canceled).toNotify().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Promise p = (Promise)tuple2._2();
                p.unsafe().done(ZIO$.MODULE$.fail((Function0)((JFunction0.mcV.sp & Serializable)this::cancel$$anonfun$2$$anonfun$1), (Object)"zio.interop.reactivestreams.Adapters$.DemandTrackingSubscription.cancel.macro(Adapters.scala:298)"), this.unsafe());
            });
        }

        private final void offer$$anonfun$2$$anonfun$1() {
        }

        private final void cancel$$anonfun$2$$anonfun$1() {
        }

        private class State
        implements Product,
        Serializable {
            private final long requestedCount;
            private final Option toNotify;
            private final DemandTrackingSubscription $outer;

            public State(DemandTrackingSubscription $outer, long requestedCount, Option<Tuple2<Object, Promise<BoxedUnit, Object>>> toNotify) {
                this.requestedCount = requestedCount;
                this.toNotify = toNotify;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.requestedCount()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.toNotify()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof State)) return false;
                if (((State)object).zio$interop$reactivestreams$Adapters$DemandTrackingSubscription$State$$$outer() != this.$outer) return false;
                State state = (State)object;
                if (this.requestedCount() != state.requestedCount()) return false;
                Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option = this.toNotify();
                Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option2 = state.toNotify();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
                if (!state.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof State;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "State";
            }

            public Object productElement(int n) {
                Option<Tuple2<Object, Promise<BoxedUnit, Object>>> option;
                int n2 = n;
                if (0 == n2) {
                    option = BoxesRunTime.boxToLong((long)this._1());
                } else if (1 == n2) {
                    option = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return option;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "requestedCount";
                } else if (1 == n2) {
                    string = "toNotify";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public long requestedCount() {
                return this.requestedCount;
            }

            public Option<Tuple2<Object, Promise<BoxedUnit, Object>>> toNotify() {
                return this.toNotify;
            }

            public State copy(long requestedCount, Option<Tuple2<Object, Promise<BoxedUnit, Object>>> toNotify) {
                return new State(this.$outer, requestedCount, toNotify);
            }

            public long copy$default$1() {
                return this.requestedCount();
            }

            public Option<Tuple2<Object, Promise<BoxedUnit, Object>>> copy$default$2() {
                return this.toNotify();
            }

            public long _1() {
                return this.requestedCount();
            }

            public Option<Tuple2<Object, Promise<BoxedUnit, Object>>> _2() {
                return this.toNotify();
            }

            public final DemandTrackingSubscription zio$interop$reactivestreams$Adapters$DemandTrackingSubscription$State$$$outer() {
                return this.$outer;
            }
        }
    }

    private static interface InterruptibleSubscriber<A>
    extends Subscriber<A> {
        public void interrupt();

        public ZIO<Object, Option<Throwable>, BoxedUnit> await();

        public boolean isDone();
    }
}

