/*
 * Decompiled with CFR 0.152.
 */
package zio.json.javatime;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.runtime.BoxedUnit;

public final class serializers$ {
    public static serializers$ MODULE$;

    static {
        new serializers$();
    }

    public String toString(Duration x) {
        StringBuilder stringBuilder;
        StringBuilder s = new StringBuilder(16);
        s.append('P').append('T');
        long totalSecs = x.getSeconds();
        int nano = x.getNano();
        if ((totalSecs | (long)nano) == 0L) {
            stringBuilder = s.append('0').append('S');
        } else {
            long effectiveTotalSecs = totalSecs;
            if (totalSecs < 0L && nano > 0) {
                ++effectiveTotalSecs;
            }
            long hours = effectiveTotalSecs / 3600L;
            int secsOfHour = (int)(effectiveTotalSecs - hours * 3600L);
            int minutes = secsOfHour / 60;
            int seconds = secsOfHour - minutes * 60;
            Object object = hours != 0L ? s.append(hours).append('H') : BoxedUnit.UNIT;
            Object object2 = minutes != 0 ? s.append(minutes).append('M') : BoxedUnit.UNIT;
            if ((seconds | nano) != 0) {
                StringBuilder stringBuilder2 = totalSecs < 0L && seconds == 0 ? s.append('-').append('0') : s.append(seconds);
                if (nano != 0) {
                    if (totalSecs < 0L) {
                        nano = 1000000000 - nano;
                    }
                    int dotPos = s.length();
                    s.append(nano + 1000000000);
                    int i = s.length() - 1;
                    while (s.charAt(i) == '0') {
                        --i;
                    }
                    s.setLength(i + 1);
                    s.setCharAt(dotPos, '.');
                }
                stringBuilder = s.append('S');
            } else {
                stringBuilder = BoxedUnit.UNIT;
            }
        }
        return s.toString();
    }

    public String toString(Instant x) {
        StringBuilder s;
        block4: {
            int year;
            int marchDayOfYear;
            s = new StringBuilder(32);
            long epochSecond = x.getEpochSecond();
            long epochDay = (epochSecond >= 0L ? epochSecond : epochSecond - 86399L) / 86400L;
            int secsOfDay = (int)(epochSecond - epochDay * 86400L);
            long marchZeroDay = epochDay + 719468L;
            int adjustYear = 0;
            if (marchZeroDay < 0L) {
                int adjust400YearCycles = this.to400YearCycle(marchZeroDay + 1L) - 1;
                adjustYear = adjust400YearCycles * 400;
                marchZeroDay -= (long)adjust400YearCycles * 146097L;
            }
            if ((marchDayOfYear = this.toMarchDayOfYear(marchZeroDay, year = this.to400YearCycle(marchZeroDay * 400L + 591L))) < 0) {
                marchDayOfYear = this.toMarchDayOfYear(marchZeroDay, --year);
            }
            int marchMonth = marchDayOfYear * 17135 + 6854 >> 19;
            year += (marchMonth * 3277 >> 15) + adjustYear;
            int month = marchMonth + (marchMonth < 10 ? 3 : -9);
            int day = marchDayOfYear - (marchMonth * 1002762 - 16383 >> 15);
            int hour = secsOfDay * 37283 >>> 27;
            int secsOfHour = secsOfDay - hour * 3600;
            int minute = secsOfHour * 17477 >> 20;
            int second = secsOfHour - minute * 60;
            this.appendYear(year, s);
            this.append2Digits(month, s.append('-'));
            this.append2Digits(day, s.append('-'));
            this.append2Digits(hour, s.append('T'));
            this.append2Digits(minute, s.append(':'));
            this.append2Digits(second, s.append(':'));
            int nano = x.getNano();
            if (nano == 0) break block4;
            s.append('.');
            int q1 = nano / 1000000;
            int r1 = nano - q1 * 1000000;
            this.append3Digits(q1, s);
            if (r1 != 0) {
                int q2 = r1 / 1000;
                int r2 = r1 - q2 * 1000;
                this.append3Digits(q2, s);
                if (r2 != 0) {
                    this.append3Digits(r2, s);
                }
            }
        }
        return s.append('Z').toString();
    }

    public String toString(LocalDate x) {
        StringBuilder s = new StringBuilder(16);
        this.appendLocalDate(x, s);
        return s.toString();
    }

    public String toString(LocalDateTime x) {
        StringBuilder s = new StringBuilder(32);
        this.appendLocalDate(x.toLocalDate(), s);
        this.appendLocalTime(x.toLocalTime(), s.append('T'));
        return s.toString();
    }

    public String toString(LocalTime x) {
        StringBuilder s = new StringBuilder(24);
        this.appendLocalTime(x, s);
        return s.toString();
    }

    public String toString(MonthDay x) {
        StringBuilder s = new StringBuilder(8);
        this.append2Digits(x.getMonthValue(), s.append('-').append('-'));
        this.append2Digits(x.getDayOfMonth(), s.append('-'));
        return s.toString();
    }

    public String toString(OffsetDateTime x) {
        StringBuilder s = new StringBuilder(48);
        this.appendLocalDate(x.toLocalDate(), s);
        this.appendLocalTime(x.toLocalTime(), s.append('T'));
        this.appendZoneOffset(x.getOffset(), s);
        return s.toString();
    }

    public String toString(OffsetTime x) {
        StringBuilder s = new StringBuilder(32);
        this.appendLocalTime(x.toLocalTime(), s);
        this.appendZoneOffset(x.getOffset(), s);
        return s.toString();
    }

    public String toString(Period x) {
        StringBuilder stringBuilder;
        StringBuilder s = new StringBuilder(16);
        s.append('P');
        if (x.isZero()) {
            stringBuilder = s.append('0').append('D');
        } else {
            int years = x.getYears();
            int months = x.getMonths();
            int days = x.getDays();
            Object object = years != 0 ? s.append(years).append('Y') : BoxedUnit.UNIT;
            Object object2 = months != 0 ? s.append(months).append('M') : BoxedUnit.UNIT;
            stringBuilder = days != 0 ? s.append(days).append('D') : BoxedUnit.UNIT;
        }
        return s.toString();
    }

    public String toString(Year x) {
        StringBuilder s = new StringBuilder(16);
        this.appendYear(x.getValue(), s);
        return s.toString();
    }

    public String toString(YearMonth x) {
        StringBuilder s = new StringBuilder(16);
        this.appendYear(x.getYear(), s);
        this.append2Digits(x.getMonthValue(), s.append('-'));
        return s.toString();
    }

    public String toString(ZonedDateTime x) {
        StringBuilder s = new StringBuilder(48);
        this.appendLocalDate(x.toLocalDate(), s);
        this.appendLocalTime(x.toLocalTime(), s.append('T'));
        this.appendZoneOffset(x.getOffset(), s);
        ZoneId zone = x.getZone();
        Object object = !(zone instanceof ZoneOffset) ? s.append('[').append(zone.getId()).append(']') : BoxedUnit.UNIT;
        return s.toString();
    }

    public String toString(ZoneId x) {
        return x.getId();
    }

    public String toString(ZoneOffset x) {
        StringBuilder s = new StringBuilder(16);
        this.appendZoneOffset(x, s);
        return s.toString();
    }

    private void appendLocalDate(LocalDate x, StringBuilder s) {
        this.appendYear(x.getYear(), s);
        this.append2Digits(x.getMonthValue(), s.append('-'));
        this.append2Digits(x.getDayOfMonth(), s.append('-'));
    }

    private void appendLocalTime(LocalTime x, StringBuilder s) {
        block1: {
            this.append2Digits(x.getHour(), s);
            this.append2Digits(x.getMinute(), s.append(':'));
            this.append2Digits(x.getSecond(), s.append(':'));
            int nano = x.getNano();
            if (nano == 0) break block1;
            int dotPos = s.length();
            s.append(nano + 1000000000);
            int i = s.length() - 1;
            while (s.charAt(i) == '0') {
                --i;
            }
            s.setLength(i + 1);
            s.setCharAt(dotPos, '.');
        }
    }

    private void appendZoneOffset(ZoneOffset x, StringBuilder s) {
        block3: {
            int n;
            int totalSeconds;
            block2: {
                totalSeconds = x.getTotalSeconds();
                if (totalSeconds != 0) break block2;
                s.append('Z');
                break block3;
            }
            if (totalSeconds > 0) {
                s.append('+');
                n = totalSeconds;
            } else {
                s.append('-');
                n = -totalSeconds;
            }
            int q0 = n;
            int q1 = q0 * 37283 >>> 27;
            int r1 = q0 - q1 * 3600;
            this.append2Digits(q1, s);
            s.append(':');
            int q2 = r1 * 17477 >> 20;
            int r2 = r1 - q2 * 60;
            this.append2Digits(q2, s);
            if (r2 == 0) break block3;
            this.append2Digits(r2, s.append(':'));
        }
    }

    private void appendYear(int x, StringBuilder s) {
        if (x >= 0) {
            if (x < 10000) {
                this.append4Digits(x, s);
            } else {
                s.append('+').append(x);
            }
        } else if (x > -10000) {
            this.append4Digits(-x, s.append('-'));
        } else {
            s.append(x);
        }
    }

    private void append4Digits(int x, StringBuilder s) {
        int q = x * 5243 >> 19;
        this.append2Digits(q, s);
        this.append2Digits(x - q * 100, s);
    }

    private void append3Digits(int x, StringBuilder s) {
        int q = x * 1311 >> 17;
        this.append2Digits(x - q * 100, s.append((char)(q + 48)));
    }

    private void append2Digits(int x, StringBuilder s) {
        int q = x * 103 >> 10;
        s.append((char)(q + 48)).append((char)(x + 48 - q * 10));
    }

    private int to400YearCycle(long day) {
        return (int)(day / 146097L);
    }

    private int toMarchDayOfYear(long marchZeroDay, int year) {
        int century = year / 100;
        return (int)(marchZeroDay - (long)year * 365L) - (year >> 2) + century - (century >> 2);
    }

    private serializers$() {
        MODULE$ = this;
    }
}

