/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.collection.immutable.List;
import zio.json.JsonDecoder;
import zio.json.JsonError;
import zio.json.internal.EscapedString;
import zio.json.internal.FastStringBuilder;
import zio.json.internal.OneCharReader;
import zio.json.internal.RetractReader;
import zio.json.internal.StringMatrix;
import zio.json.internal.UnsafeNumbers$;
import zio.json.internal.UnsafeNumbers$UnsafeNumber$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Lexer$ {
    public static Lexer$ MODULE$;
    private final int NumberMaxBits;
    private final char[] ull;
    private final char[] alse;
    private final char[] rue;

    static {
        new Lexer$();
    }

    public int NumberMaxBits() {
        return this.NumberMaxBits;
    }

    public boolean firstField(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case '\"': {
                in.retract();
                return true;
            }
            case '}': {
                return false;
            }
        }
        JsonError.Message message = new JsonError.Message(new StringBuilder(29).append("expected string or '}' got '").append(c).append("'").toString());
        throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public boolean nextField(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case ',': {
                return true;
            }
            case '}': {
                return false;
            }
        }
        JsonError.Message message = new JsonError.Message(new StringBuilder(26).append("expected ',' or '}' got '").append(c).append("'").toString());
        throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public boolean firstArrayElement(RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case ']': {
                return false;
            }
        }
        in.retract();
        return true;
    }

    public boolean nextArrayElement(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case ',': {
                return true;
            }
            case ']': {
                return false;
            }
        }
        JsonError.Message message = new JsonError.Message(new StringBuilder(26).append("expected ',' or ']' got '").append(c).append("'").toString());
        throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public int field(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        int f = this.enumeration(trace, in, matrix);
        this.char(trace, in, ':');
        return f;
    }

    public int enumeration(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        Reader stream = this.streamingString(trace, in);
        int i = 0;
        long bs = matrix.initial();
        int c = -1;
        while ((c = stream.read()) != -1) {
            bs = matrix.update(bs, i, c);
            ++i;
        }
        bs = matrix.exact(bs, i);
        return matrix.first(bs);
    }

    public void skipValue(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case 'n': {
                this.readChars(trace, in, this.ull, "null");
                return;
            }
            case 'f': {
                this.readChars(trace, in, this.alse, "false");
                return;
            }
            case 't': {
                this.readChars(trace, in, this.rue, "true");
                return;
            }
            case '{': {
                if (this.firstField(trace, in)) {
                    do {
                        this.char(trace, in, '\"');
                        this.skipString(trace, in);
                        this.char(trace, in, ':');
                        this.skipValue(trace, in);
                    } while (this.nextField(trace, in));
                    return;
                }
                return;
            }
            case '[': {
                if (this.firstArrayElement(in)) {
                    do {
                        this.skipValue(trace, in);
                    } while (this.nextArrayElement(trace, in));
                    return;
                }
                return;
            }
            case '\"': {
                this.skipString(trace, in);
                return;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipNumber(in);
                return;
            }
        }
        JsonError.Message message = new JsonError.Message(new StringBuilder(13).append("unexpected '").append(c).append("'").toString());
        throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public void skipNumber(RetractReader in) {
        while (this.isNumber(in.readChar())) {
        }
        in.retract();
    }

    public void skipString(List<JsonError> trace, OneCharReader in) {
        EscapedString stream = new EscapedString(trace, in);
        int i = 0;
        while ((i = stream.read()) != -1) {
        }
    }

    public Reader streamingString(List<JsonError> trace, OneCharReader in) {
        this.char(trace, in, '\"');
        return new EscapedString(trace, in);
    }

    public CharSequence string(List<JsonError> trace, OneCharReader in) {
        this.char(trace, in, '\"');
        EscapedString stream = new EscapedString(trace, in);
        FastStringBuilder sb = new FastStringBuilder(64);
        int c;
        while ((c = stream.read()) != -1) {
            sb.append((char)c);
        }
        return sb.buffer();
    }

    public boolean boolean(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case 't': {
                this.readChars(trace, in, this.rue, "true");
                return true;
            }
            case 'f': {
                this.readChars(trace, in, this.alse, "false");
                return false;
            }
        }
        JsonError.Message message = new JsonError.Message(new StringBuilder(31).append("expected 'true' or 'false' got ").append(c).toString());
        throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public byte byte(List<JsonError> trace, RetractReader in) {
        byte by;
        this.checkNumber(trace, in);
        try {
            byte i = UnsafeNumbers$.MODULE$.byte_((Reader)((Object)in), false);
            in.retract();
            by = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message("expected a Byte");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return by;
    }

    public short short(List<JsonError> trace, RetractReader in) {
        short s;
        this.checkNumber(trace, in);
        try {
            short i = UnsafeNumbers$.MODULE$.short_((Reader)((Object)in), false);
            in.retract();
            s = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message("expected a Short");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return s;
    }

    public int int(List<JsonError> trace, RetractReader in) {
        int n;
        this.checkNumber(trace, in);
        try {
            int i = UnsafeNumbers$.MODULE$.int_((Reader)((Object)in), false);
            in.retract();
            n = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message("expected an Int");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return n;
    }

    public long long(List<JsonError> trace, RetractReader in) {
        long l;
        this.checkNumber(trace, in);
        try {
            long i = UnsafeNumbers$.MODULE$.long_((Reader)((Object)in), false);
            in.retract();
            l = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message("expected a Long");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return l;
    }

    public BigInteger bigInteger(List<JsonError> trace, RetractReader in) {
        BigInteger bigInteger;
        this.checkNumber(trace, in);
        try {
            BigInteger i = UnsafeNumbers$.MODULE$.bigInteger_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            bigInteger = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message(new StringBuilder(26).append("expected a ").append(this.NumberMaxBits()).append(" bit BigInteger").toString());
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return bigInteger;
    }

    public float float(List<JsonError> trace, RetractReader in) {
        float f;
        this.checkNumber(trace, in);
        try {
            float i = UnsafeNumbers$.MODULE$.float_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            f = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message("expected a Float");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return f;
    }

    public double double(List<JsonError> trace, RetractReader in) {
        double d;
        this.checkNumber(trace, in);
        try {
            double i = UnsafeNumbers$.MODULE$.double_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            d = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message("expected a Double");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return d;
    }

    public BigDecimal bigDecimal(List<JsonError> trace, RetractReader in) {
        BigDecimal bigDecimal;
        this.checkNumber(trace, in);
        try {
            BigDecimal i = UnsafeNumbers$.MODULE$.bigDecimal_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            bigDecimal = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonError.Message message = new JsonError.Message(new StringBuilder(22).append("expected a ").append(this.NumberMaxBits()).append(" BigDecimal").toString());
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return bigDecimal;
    }

    private void checkNumber(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                JsonError.Message message = new JsonError.Message(new StringBuilder(23).append("expected a number, got ").append(c).toString());
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }
        }
        in.retract();
    }

    public void char(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.nextNonWhitespace();
        if (got != c) {
            JsonError.Message message = new JsonError.Message(new StringBuilder(18).append("expected '").append(c).append("' got '").append(got).append("'").toString());
            throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
        }
    }

    public void charOnly(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.readChar();
        if (got != c) {
            JsonError.Message message = new JsonError.Message(new StringBuilder(18).append("expected '").append(c).append("' got '").append(got).append("'").toString());
            throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
        }
    }

    private boolean isNumber(char c) {
        char c2 = c;
        switch (c2) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    public void readChars(List<JsonError> trace, OneCharReader in, char[] expect, String errMsg) {
        for (int i = 0; i < expect.length; ++i) {
            if (in.readChar() == expect[i]) continue;
            JsonError.Message message = new JsonError.Message(new StringBuilder(11).append("expected '").append(errMsg).append("'").toString());
            throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
        }
    }

    private Lexer$() {
        MODULE$ = this;
        this.NumberMaxBits = 128;
        this.ull = "ull".toCharArray();
        this.alse = "alse".toCharArray();
        this.rue = "rue".toCharArray();
    }
}

