/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.util.Arrays;
import scala.Array$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import zio.json.internal.OneCharReader;
import zio.json.internal.PlaybackReader;
import zio.json.internal.RecordingReader;
import zio.json.internal.RetractReader;
import zio.json.internal.RewindTwice;
import zio.json.internal.UnexpectedEnd;

@ScalaSignature(bytes="\u0006\u0001E3Qa\u0004\t\u0003)YA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!1q\u0007\u0001Q!\naBaA\u0010\u0001!B\u0013a\u0003BB \u0001A\u0003&A\u0006\u0003\u0004A\u0001\u0001\u0006K\u0001\f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\r\u0002!\te\u0012\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006\u0015\u0002!\tA\u0011\u0005\u0006\u0017\u0002!\tA\u0011\u0005\u0006\u0019\u0002!\ta\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0002\u0014/&$\bNU3d_J$\u0017N\\4SK\u0006$WM\u001d\u0006\u0003#I\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003'Q\tAA[:p]*\tQ#A\u0002{S>\u001cB\u0001A\f GA\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0003S>T\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t1!+Z1eKJ\u0004\"\u0001I\u0011\u000e\u0003AI!A\t\t\u0003\u001fI+7m\u001c:eS:<'+Z1eKJ\u0004\"\u0001\t\u0013\n\u0005\u0015\u0002\"A\u0004)mCf\u0014\u0017mY6SK\u0006$WM]\u0001\u0003S:\u001c\u0001\u0001\u0005\u0002!S%\u0011!\u0006\u0005\u0002\u000e\u001f:,7\t[1s%\u0016\fG-\u001a:\u0002\u000f%t\u0017\u000e^5bYB\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r!TG\u000e\t\u0003A\u0001AQAJ\u0002A\u0002!BQaK\u0002A\u00021\nA\u0001^1qKB\u0019Q&O\u001e\n\u0005ir#!B!se\u0006L\bCA\u0017=\u0013\tidF\u0001\u0003DQ\u0006\u0014\u0018aA3pE\u00069qO]5uS:<\u0017a\u0002:fC\u0012LgnZ\u0001\u0006G2|7/\u001a\u000b\u0002\u0007B\u0011Q\u0006R\u0005\u0003\u000b:\u0012A!\u00168ji\u0006!!/Z1e)\u0005a\u0013\u0001\u0003:fC\u0012\u001c\u0005.\u0019:\u0015\u0003m\naA]3xS:$\u0017a\u0002:fiJ\f7\r^\u0001\u0007_\u001a47/\u001a;\u0002\u000f!L7\u000f^8ssR\u00111h\u0014\u0005\u0006!:\u0001\r\u0001L\u0001\u0004S\u0012D\b")
public final class WithRecordingReader
extends Reader
implements RecordingReader,
PlaybackReader {
    private final OneCharReader in;
    private char[] tape;
    private int eob;
    private int writing;
    private int reading;

    @Override
    public int read(char[] cbuf, int off, int len) {
        return OneCharReader.read$(this, cbuf, off, len);
    }

    @Override
    public char nextNonWhitespace() {
        return OneCharReader.nextNonWhitespace$(this);
    }

    @Override
    public boolean isWhitespace(char c) {
        return OneCharReader.isWhitespace$(this, c);
    }

    @Override
    public void close() {
        ((Reader)((Object)this.in)).close();
    }

    @Override
    public int read() {
        int n;
        try {
            n = this.readChar();
        }
        catch (UnexpectedEnd unexpectedEnd) {
            this.eob = this.reading;
            n = -1;
        }
        return n;
    }

    @Override
    public char readChar() {
        char v;
        block4: {
            if (this.reading != -1) {
                if (this.reading == this.eob) {
                    throw new UnexpectedEnd();
                }
                char v2 = this.tape[this.reading];
                ++this.reading;
                if (this.reading >= this.writing) {
                    this.reading = -1;
                    this.writing = -1;
                }
                return v2;
            }
            v = this.in.readChar();
            if (this.writing == -1) break block4;
            this.tape[this.writing] = v;
            ++this.writing;
            if (this.writing == this.tape.length) {
                this.tape = Arrays.copyOf(this.tape, this.tape.length * 2);
            }
        }
        return v;
    }

    @Override
    public void rewind() {
        if (this.writing != -1) {
            this.reading = 0;
            return;
        }
        throw new RewindTwice();
    }

    @Override
    public void retract() {
        if (this.reading == -1) {
            OneCharReader oneCharReader = this.in;
            if (oneCharReader instanceof RetractReader) {
                RetractReader retractReader = (RetractReader)oneCharReader;
                retractReader.retract();
                if (this.writing != -1) {
                    --this.writing;
                    return;
                }
                return;
            }
            this.reading = this.writing - 1;
            return;
        }
        --this.reading;
    }

    @Override
    public int offset() {
        if (this.reading == -1) {
            return this.writing;
        }
        return this.reading;
    }

    @Override
    public char history(int idx) {
        return this.tape[idx];
    }

    public WithRecordingReader(OneCharReader in, int initial) {
        this.in = in;
        OneCharReader.$init$(this);
        this.tape = (char[])Array$.MODULE$.ofDim(Math.max(initial, 1), ClassTag$.MODULE$.Char());
        this.eob = -1;
        this.writing = 0;
        this.reading = -1;
    }
}

