/*
 * Decompiled with CFR 0.152.
 */
package zio.json.ast;

import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.package$;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.json.JsonCodec;
import zio.json.JsonDecoder;
import zio.json.JsonDecoderPlatformSpecific;
import zio.json.JsonEncoder;
import zio.json.JsonEncoderPlatformSpecific;
import zio.json.JsonError;
import zio.json.JsonStreamDelimiter;
import zio.json.ast.Json;
import zio.json.ast.Json$Arr$;
import zio.json.ast.Json$Bool$;
import zio.json.ast.Json$Null$;
import zio.json.ast.Json$Num$;
import zio.json.ast.Json$Obj$;
import zio.json.ast.Json$Str$;
import zio.json.internal.RetractReader;
import zio.json.internal.Write;
import zio.stream.ZPipeline;
import zio.stream.ZStream;

public final class Json$ {
    public static Json$ MODULE$;
    private final JsonDecoder<Json> decoder;
    private final JsonEncoder<Json> encoder;
    private final JsonCodec<Json> codec;

    static {
        new Json$();
    }

    public JsonDecoder<Json> decoder() {
        return this.decoder;
    }

    public JsonEncoder<Json> encoder() {
        return this.encoder;
    }

    public JsonCodec<Json> codec() {
        return this.codec;
    }

    public Json apply(Seq<Tuple2<String, Json>> fields) {
        return new Json.Obj((Chunk<Tuple2<String, Json>>)Chunk$.MODULE$.apply(fields));
    }

    private Json$() {
        MODULE$ = this;
        this.decoder = new JsonDecoder<Json>(){

            public final <A1> JsonDecoder<A1> $less$greater(Function0<JsonDecoder<A1>> that) {
                return JsonDecoder.$less$greater$(this, that);
            }

            public final <B> JsonDecoder<Either<Json, B>> $less$plus$greater(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.$less$plus$greater$(this, that);
            }

            public final <B> JsonDecoder<Tuple2<Json, B>> $less$times$greater(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.$less$times$greater$(this, that);
            }

            public final <B> JsonDecoder<B> $times$greater(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.$times$greater$(this, that);
            }

            public final <B> JsonDecoder<Json> $less$times(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.$less$times$(this, that);
            }

            public final Either<String, Json> decodeJson(CharSequence str) {
                return JsonDecoder.decodeJson$(this, str);
            }

            public final <B> JsonDecoder<B> widen() {
                return JsonDecoder.widen$(this);
            }

            public final <A1> JsonDecoder<A1> orElse(Function0<JsonDecoder<A1>> that) {
                return JsonDecoder.orElse$(this, that);
            }

            public final <B> JsonDecoder<Either<Json, B>> orElseEither(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.orElseEither$(this, that);
            }

            public final <B> JsonDecoder<B> map(Function1<Json, B> f) {
                return JsonDecoder.map$(this, f);
            }

            public final <B> JsonDecoder<B> mapOrFail(Function1<Json, Either<String, B>> f) {
                return JsonDecoder.mapOrFail$(this, f);
            }

            public final <B> JsonDecoder<Tuple2<Json, B>> zip(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.zip$(this, that);
            }

            public final <B> JsonDecoder<Json> zipLeft(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.zipLeft$(this, that);
            }

            public final <B> JsonDecoder<B> zipRight(Function0<JsonDecoder<B>> that) {
                return JsonDecoder.zipRight$(this, that);
            }

            public final <B, C> JsonDecoder<C> zipWith(Function0<JsonDecoder<B>> that, Function2<Json, B, C> f) {
                return JsonDecoder.zipWith$(this, that, f);
            }

            public Object unsafeDecodeMissing(List trace) {
                return JsonDecoder.unsafeDecodeMissing$(this, trace);
            }

            public final Either<String, Json> fromJsonAST(Json json) {
                return JsonDecoder.fromJsonAST$(this, json);
            }

            public final <R> ZIO<R, Throwable, Json> decodeJsonStreamInput(ZStream<R, Throwable, Object> stream, Charset charset) {
                return JsonDecoderPlatformSpecific.decodeJsonStreamInput$(this, stream, charset);
            }

            public final <R> Charset decodeJsonStreamInput$default$2() {
                return JsonDecoderPlatformSpecific.decodeJsonStreamInput$default$2$(this);
            }

            public final <R> ZIO<R, Throwable, Json> decodeJsonStream(ZStream<R, Throwable, Object> stream) {
                return JsonDecoderPlatformSpecific.decodeJsonStream$(this, stream);
            }

            public final ZPipeline<Object, Throwable, Object, Json> decodeJsonPipeline(JsonStreamDelimiter delimiter) {
                return JsonDecoderPlatformSpecific.decodeJsonPipeline$(this, delimiter);
            }

            public final JsonStreamDelimiter decodeJsonPipeline$default$1() {
                return JsonDecoderPlatformSpecific.decodeJsonPipeline$default$1$(this);
            }

            public Json unsafeDecode(List<JsonError> trace, RetractReader in) {
                char c = in.nextNonWhitespace();
                in.retract();
                char c2 = c;
                switch (c2) {
                    case 'n': {
                        return Json$Null$.MODULE$.decoder().unsafeDecode(trace, in);
                    }
                    case 'f': 
                    case 't': {
                        return Json$Bool$.MODULE$.decoder().unsafeDecode(trace, in);
                    }
                    case '{': {
                        return Json$Obj$.MODULE$.decoder().unsafeDecode(trace, in);
                    }
                    case '[': {
                        return Json$Arr$.MODULE$.decoder().unsafeDecode(trace, in);
                    }
                    case '\"': {
                        return Json$Str$.MODULE$.decoder().unsafeDecode(trace, in);
                    }
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return Json$Num$.MODULE$.decoder().unsafeDecode(trace, in);
                    }
                }
                JsonError.Message message = new JsonError.Message(new StringBuilder(13).append("unexpected '").append(c2).append("'").toString());
                throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
            }

            public final Json unsafeFromJsonAST(List<JsonError> trace, Json json) {
                return json;
            }
            {
                JsonDecoderPlatformSpecific.$init$(this);
                JsonDecoder.$init$(this);
            }
        };
        this.encoder = new JsonEncoder<Json>(){
            private final ZPipeline<Object, Throwable, Json, Object> encodeJsonLinesPipeline;
            private final ZPipeline<Object, Throwable, Json, Object> encodeJsonArrayPipeline;

            public final <B> JsonEncoder<B> contramap(Function1<B, Json> f) {
                return JsonEncoder.contramap$(this, f);
            }

            public final <B> JsonEncoder<Either<Json, B>> either(Function0<JsonEncoder<B>> that) {
                return JsonEncoder.either$(this, that);
            }

            public final <B> JsonEncoder<Either<Json, B>> orElseEither(Function0<JsonEncoder<B>> that) {
                return JsonEncoder.orElseEither$(this, that);
            }

            public final <B, C> JsonEncoder<C> eitherWith(Function0<JsonEncoder<B>> that, Function1<C, Either<Json, B>> f) {
                return JsonEncoder.eitherWith$(this, that, f);
            }

            public final CharSequence encodeJson(Object a, Option indent) {
                return JsonEncoder.encodeJson$(this, a, indent);
            }

            public final Option<Object> encodeJson$default$2() {
                return JsonEncoder.encodeJson$default$2$(this);
            }

            public boolean isNothing(Object a) {
                return JsonEncoder.isNothing$(this, a);
            }

            public final <B extends Json> JsonEncoder<B> narrow() {
                return JsonEncoder.narrow$(this);
            }

            public final <B> JsonEncoder<Tuple2<Json, B>> zip(Function0<JsonEncoder<B>> that) {
                return JsonEncoder.zip$(this, that);
            }

            public final <B, C> JsonEncoder<C> zipWith(Function0<JsonEncoder<B>> that, Function1<C, Tuple2<Json, B>> f) {
                return JsonEncoder.zipWith$(this, that, f);
            }

            public final ZStream encodeJsonStream(Object a) {
                return JsonEncoderPlatformSpecific.encodeJsonStream$(this, a);
            }

            public final ZPipeline<Object, Throwable, Json, Object> encodeJsonLinesPipeline() {
                return this.encodeJsonLinesPipeline;
            }

            public final ZPipeline<Object, Throwable, Json, Object> encodeJsonArrayPipeline() {
                return this.encodeJsonArrayPipeline;
            }

            public final void zio$json$JsonEncoderPlatformSpecific$_setter_$encodeJsonLinesPipeline_$eq(ZPipeline<Object, Throwable, Json, Object> x$1) {
                this.encodeJsonLinesPipeline = x$1;
            }

            public final void zio$json$JsonEncoderPlatformSpecific$_setter_$encodeJsonArrayPipeline_$eq(ZPipeline<Object, Throwable, Json, Object> x$1) {
                this.encodeJsonArrayPipeline = x$1;
            }

            public void unsafeEncode(Json a, Option<Object> indent, Write out) {
                Json json = a;
                if (json instanceof Json.Obj) {
                    Json.Obj obj = (Json.Obj)json;
                    Json$Obj$.MODULE$.encoder().unsafeEncode(obj, indent, out);
                    return;
                }
                if (json instanceof Json.Arr) {
                    Json.Arr arr = (Json.Arr)json;
                    Json$Arr$.MODULE$.encoder().unsafeEncode(arr, indent, out);
                    return;
                }
                if (json instanceof Json.Bool) {
                    Json.Bool bool = (Json.Bool)json;
                    Json$Bool$.MODULE$.encoder().unsafeEncode(bool, indent, out);
                    return;
                }
                if (json instanceof Json.Str) {
                    Json.Str str = (Json.Str)json;
                    Json$Str$.MODULE$.encoder().unsafeEncode(str, indent, out);
                    return;
                }
                if (json instanceof Json.Num) {
                    Json.Num num = (Json.Num)json;
                    Json$Num$.MODULE$.encoder().unsafeEncode(num, indent, out);
                    return;
                }
                if (((Object)Json$Null$.MODULE$).equals(json)) {
                    Json$Null$.MODULE$.encoder().unsafeEncode(Json$Null$.MODULE$, indent, out);
                    return;
                }
                throw new MatchError((Object)json);
            }

            public final Either<String, Json> toJsonAST(Json a) {
                return package$.MODULE$.Right().apply((Object)a);
            }
            {
                JsonEncoderPlatformSpecific.$init$(this);
                JsonEncoder.$init$(this);
            }
        };
        this.codec = new JsonCodec<Json>(this.encoder(), this.decoder());
    }
}

