/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.util.Arrays;
import scala.reflect.ScalaSignature;
import zio.json.internal.OneCharReader;
import zio.json.internal.PlaybackReader;
import zio.json.internal.RecordingReader;
import zio.json.internal.RetractReader;
import zio.json.internal.RewindTwice;

@ScalaSignature(bytes="\u0006\u0001E3Qa\u0004\t\u0003)YA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!1q\u0007\u0001Q!\n1Ba\u0001\u000f\u0001!B\u0013I\u0004BB \u0001A\u0003&A\u0006\u0003\u0004A\u0001\u0001\u0006K\u0001\f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\r\u0002!\te\u0012\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006\u0015\u0002!\tA\u0011\u0005\u0006\u0017\u0002!\tA\u0011\u0005\u0006\u0019\u0002!\ta\u0012\u0005\u0006\u001b\u0002!\tA\u0014\u0002\u0014/&$\bNU3d_J$\u0017N\\4SK\u0006$WM\u001d\u0006\u0003#I\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003'Q\tAA[:p]*\tQ#A\u0002{S>\u001cB\u0001A\f GA\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0003S>T\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t1!+Z1eKJ\u0004\"\u0001I\u0011\u000e\u0003AI!A\t\t\u0003\u001fI+7m\u001c:eS:<'+Z1eKJ\u0004\"\u0001\t\u0013\n\u0005\u0015\u0002\"A\u0004)mCf\u0014\u0017mY6SK\u0006$WM]\u0001\u0003S:\u001c\u0001\u0001\u0005\u0002!S%\u0011!\u0006\u0005\u0002\u000e\u001f:,7\t[1s%\u0016\fG-\u001a:\u0002\u000f%t\u0017\u000e^5bYB\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r!TG\u000e\t\u0003A\u0001AQAJ\u0002A\u0002!BQaK\u0002A\u00021\nQa\u001d;bi\u0016\fA\u0001^1qKB\u0019QF\u000f\u001f\n\u0005mr#!B!se\u0006L\bCA\u0017>\u0013\tqdF\u0001\u0003DQ\u0006\u0014\u0018a\u0002:fC\u0012LgnZ\u0001\boJLG/\u001b8h\u0003\u0015\u0019Gn\\:f)\u0005\u0019\u0005CA\u0017E\u0013\t)eF\u0001\u0003V]&$\u0018\u0001\u0002:fC\u0012$\u0012\u0001L\u0001\te\u0016\fGm\u00115beR\tA(\u0001\u0004sK^Lg\u000eZ\u0001\be\u0016$(/Y2u\u0003\u0019ygMZ:fi\u00069\u0001.[:u_JLHC\u0001\u001fP\u0011\u0015\u0001f\u00021\u0001-\u0003\rIG\r\u001f")
public final class WithRecordingReader
extends Reader
implements RecordingReader,
PlaybackReader {
    private final OneCharReader in;
    private int state;
    private char[] tape;
    private int reading;
    private int writing;

    @Override
    public int read(char[] cbuf, int off, int len) {
        return OneCharReader.read$(this, cbuf, off, len);
    }

    @Override
    public char nextNonWhitespace() {
        return OneCharReader.nextNonWhitespace$(this);
    }

    @Override
    public boolean isWhitespace(char c) {
        return OneCharReader.isWhitespace$(this, c);
    }

    @Override
    public void close() {
        ((Reader)((Object)this.in)).close();
    }

    @Override
    public int read() {
        int c;
        block4: {
            if (this.state < 0) {
                return this.in.read();
            }
            if (this.state > 0) {
                int reading = this.reading;
                char c2 = this.tape[reading];
                this.reading = ++reading;
                if (reading == this.writing) {
                    this.state = -1;
                }
                return c2;
            }
            int writing = this.writing;
            if (writing == this.tape.length) {
                this.tape = Arrays.copyOf(this.tape, writing << 1);
            }
            if ((c = this.in.read()) < 0) break block4;
            this.tape[writing] = (char)c;
            this.writing = writing + 1;
        }
        return c;
    }

    @Override
    public char readChar() {
        char c;
        if (this.state < 0) {
            return this.in.readChar();
        }
        if (this.state > 0) {
            int reading = this.reading;
            char c2 = this.tape[reading];
            this.reading = ++reading;
            if (reading == this.writing) {
                this.state = -1;
            }
            return c2;
        }
        int writing = this.writing;
        if (writing == this.tape.length) {
            this.tape = Arrays.copyOf(this.tape, writing << 1);
        }
        this.tape[writing] = c = this.in.readChar();
        this.writing = writing + 1;
        return c;
    }

    @Override
    public void rewind() {
        if (this.state == 0) {
            this.state = 1;
            return;
        }
        throw new RewindTwice();
    }

    @Override
    public void retract() {
        if (this.state > 0) {
            --this.reading;
            return;
        }
        OneCharReader oneCharReader = this.in;
        if (oneCharReader instanceof RetractReader) {
            RetractReader retractReader = (RetractReader)oneCharReader;
            retractReader.retract();
            if (this.state == 0) {
                --this.writing;
                return;
            }
            return;
        }
        throw new UnsupportedOperationException("underlying reader does not support retract");
    }

    @Override
    public int offset() {
        if (this.state > 0) {
            return this.reading;
        }
        return this.writing;
    }

    @Override
    public char history(int idx) {
        return this.tape[idx];
    }

    public WithRecordingReader(OneCharReader in, int initial) {
        this.in = in;
        OneCharReader.$init$(this);
        this.state = 0;
        this.tape = new char[Math.max(initial, 1)];
        this.reading = 0;
        this.writing = 0;
    }
}

