/*
 * Decompiled with CFR 0.152.
 */
package zio.json.uuid;

import java.io.Serializable;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class UUIDParser$ {
    public static final UUIDParser$ MODULE$;
    private static final byte[] CharToNumeric;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new UUIDParser$();
        byte[] ns = (byte[])Array$.MODULE$.fill(256, (Function0)(JFunction0.mcB.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Byte());
        ns[48] = 0;
        ns[49] = 1;
        ns[50] = 2;
        ns[51] = 3;
        ns[52] = 4;
        ns[53] = 5;
        ns[54] = 6;
        ns[55] = 7;
        ns[56] = 8;
        ns[57] = 9;
        ns[65] = 10;
        ns[66] = 11;
        ns[67] = 12;
        ns[68] = 13;
        ns[69] = 14;
        ns[70] = 15;
        ns[97] = 10;
        ns[98] = 11;
        ns[99] = 12;
        ns[100] = 13;
        ns[101] = 14;
        ns[102] = 15;
        CharToNumeric = var0;
    }

    public UUID unsafeParse(String input) {
        long lsb4;
        long lsb3;
        long lsb2;
        long lsb1;
        long msb4;
        long msb3;
        long msb2;
        block3: {
            block2: {
                if (input.length() != 36) break block2;
                char ch1 = input.charAt(8);
                char ch2 = input.charAt(13);
                char ch3 = input.charAt(18);
                char ch4 = input.charAt(23);
                if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-') break block3;
            }
            return this.unsafeParseExtended(input);
        }
        byte[] ch2n = CharToNumeric;
        long msb1 = this.parseNibbles(ch2n, input, 0);
        Object object = (msb1 | (msb2 = this.parseNibbles(ch2n, input, 4)) | (msb3 = this.parseNibbles(ch2n, input, 9)) | (msb4 = this.parseNibbles(ch2n, input, 14)) | (lsb1 = this.parseNibbles(ch2n, input, 19)) | (lsb2 = this.parseNibbles(ch2n, input, 24)) | (lsb3 = this.parseNibbles(ch2n, input, 28)) | (lsb4 = this.parseNibbles(ch2n, input, 32))) < 0L ? this.invalidUUIDError(input) : BoxedUnit.UNIT;
        return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
    }

    private long parseNibbles(byte[] ch2n, String input, int position) {
        char ch4;
        char ch3;
        char ch2;
        char ch1 = input.charAt(position);
        if (((char)(ch1 | (ch2 = input.charAt(position + 1))) | (ch3 = input.charAt(position + 2)) | (ch4 = input.charAt(position + 3))) > 255) {
            return -1L;
        }
        return ch2n[ch1] << 12 | ch2n[ch2] << 8 | ch2n[ch3] << 4 | ch2n[ch4];
    }

    private UUID unsafeParseExtended(String input) {
        int len = input.length();
        if (len > 36) {
            throw new IllegalArgumentException("UUID string too large");
        }
        int dash1 = input.indexOf(45, 0);
        int dash2 = input.indexOf(45, dash1 + 1);
        int dash3 = input.indexOf(45, dash2 + 1);
        int dash4 = input.indexOf(45, dash3 + 1);
        int dash5 = input.indexOf(45, dash4 + 1);
        IllegalArgumentException illegalArgumentException = dash4 < 0 || dash5 >= 0 ? this.invalidUUIDError(input) : BoxedUnit.UNIT;
        byte[] ch2n = CharToNumeric;
        long section1 = this.parseSection(ch2n, input, 0, dash1, 0xFFFFFFF00000000L);
        long section2 = this.parseSection(ch2n, input, dash1 + 1, dash2, 0xFFFFFFFFFFF0000L);
        long section3 = this.parseSection(ch2n, input, dash2 + 1, dash3, 0xFFFFFFFFFFF0000L);
        long section4 = this.parseSection(ch2n, input, dash3 + 1, dash4, 0xFFFFFFFFFFF0000L);
        long section5 = this.parseSection(ch2n, input, dash4 + 1, len, 0xFFF000000000000L);
        return new UUID(section1 << 32 | section2 << 16 | section3, section4 << 48 | section5);
    }

    private long parseSection(byte[] ch2n, String input, int beginIndex, int endIndex, long zeroMask) {
        IllegalArgumentException illegalArgumentException = beginIndex >= endIndex || beginIndex + 16 < endIndex ? this.invalidUUIDError(input) : BoxedUnit.UNIT;
        long result = 0L;
        for (int i = beginIndex; i < endIndex; ++i) {
            result = result << 4 | (long)ch2n[input.charAt(i)];
        }
        Object object = (result & zeroMask) != 0L ? this.invalidUUIDError(input) : BoxedUnit.UNIT;
        return result;
    }

    private IllegalArgumentException invalidUUIDError(String input) {
        throw new IllegalArgumentException(input);
    }

    private UUIDParser$() {
    }
}

