/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import zio.json.JsonDecoder;
import zio.json.JsonError;
import zio.json.internal.OneCharReader;
import zio.json.internal.UnexpectedEnd;

@ScalaSignature(bytes="\u0006\u0005M3A!\u0003\u0006\u0007#!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u00059\u0001\t\u0005\t\u0015!\u0003\u001b\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0019!\u0005\u0001)Q\u0005\u000b\")\u0001\n\u0001C!\u0013\")Q\n\u0001C\u0001\u001d\")!\u000b\u0001C\u0001\u0013\niQi]2ba\u0016$7\u000b\u001e:j]\u001eT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\t)\u001cxN\u001c\u0006\u0002\u001f\u0005\u0019!0[8\u0004\u0001M\u0019\u0001A\u0005\u000e\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012AA5p\u0015\u00059\u0012\u0001\u00026bm\u0006L!!\u0007\u000b\u0003\rI+\u0017\rZ3s!\tYB$D\u0001\u000b\u0013\ti\"BA\u0007P]\u0016\u001c\u0005.\u0019:SK\u0006$WM]\u0001\u0006iJ\f7-\u001a\t\u0004A)jcBA\u0011(\u001d\t\u0011S%D\u0001$\u0015\t!\u0003#\u0001\u0004=e>|GOP\u0005\u0002M\u0005)1oY1mC&\u0011\u0001&K\u0001\ba\u0006\u001c7.Y4f\u0015\u00051\u0013BA\u0016-\u0005\u0011a\u0015n\u001d;\u000b\u0005!J\u0003C\u0001\u00186\u001d\ty3G\u0004\u00021e9\u0011!%M\u0005\u0002\u001f%\u0011QBD\u0005\u0003i1\t1BS:p]\u0012+7m\u001c3fe&\u0011ag\u000e\u0002\n\u0015N|g.\u0012:s_JT!\u0001\u000e\u0007\u0002\u0005%t\u0017A\u0002\u001fj]&$h\bF\u0002<yu\u0002\"a\u0007\u0001\t\u000by\u0019\u0001\u0019A\u0010\t\u000ba\u001a\u0001\u0019\u0001\u000e\u0002\u000b\rdwn]3\u0015\u0003\u0001\u0003\"!\u0011\"\u000e\u0003%J!aQ\u0015\u0003\tUs\u0017\u000e^\u0001\bKN\u001c\u0017\r]3e!\t\te)\u0003\u0002HS\t9!i\\8mK\u0006t\u0017\u0001\u0002:fC\u0012$\u0012A\u0013\t\u0003\u0003.K!\u0001T\u0015\u0003\u0007%sG/\u0001\u0005sK\u0006$7\t[1s)\u0005y\u0005CA!Q\u0013\t\t\u0016F\u0001\u0003DQ\u0006\u0014\u0018\u0001\u00038fqRDU\r\u001f\u001b")
public final class EscapedString
extends Reader
implements OneCharReader {
    private final List<JsonError> trace;
    private final OneCharReader in;
    private boolean escaped;

    @Override
    public int read(char[] cbuf, int off, int len) {
        return OneCharReader.read$(this, cbuf, off, len);
    }

    @Override
    public char nextNonWhitespace() {
        return OneCharReader.nextNonWhitespace$(this);
    }

    @Override
    public boolean isWhitespace(char c) {
        return OneCharReader.isWhitespace$(this, c);
    }

    @Override
    public void close() {
        ((Reader)((Object)this.in)).close();
    }

    @Override
    public int read() {
        char c;
        while (true) {
            c = this.in.readChar();
            if (this.escaped) {
                this.escaped = false;
                char c2 = c;
                switch (c2) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        return c;
                    }
                    case 'b': {
                        return 8;
                    }
                    case 'f': {
                        return 12;
                    }
                    case 'n': {
                        return 10;
                    }
                    case 'r': {
                        return 13;
                    }
                    case 't': {
                        return 9;
                    }
                    case 'u': {
                        return this.nextHex4();
                    }
                }
                JsonError.Message message = new JsonError.Message(new StringBuilder(21).append("invalid '\\").append(c).append("' in string").toString());
                throw new JsonDecoder.UnsafeJson((List<JsonError>)this.trace.$colon$colon((Object)message));
            }
            if (c != '\\') break;
            this.escaped = true;
        }
        if (c == '\"') {
            return -1;
        }
        if (c < ' ') {
            JsonError.Message message = new JsonError.Message("invalid control in string");
            throw new JsonDecoder.UnsafeJson((List<JsonError>)this.trace.$colon$colon((Object)message));
        }
        return c;
    }

    @Override
    public char readChar() {
        int v = this.read();
        if (v == -1) {
            throw new UnexpectedEnd();
        }
        return (char)v;
    }

    public int nextHex4() {
        int accum = 0;
        for (int i = 0; i < 4; ++i) {
            int n;
            int c = this.in.read();
            if (c == -1) {
                JsonError.Message message = new JsonError.Message("unexpected EOB in string");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)this.trace.$colon$colon((Object)message));
            }
            if (48 <= c && c <= 57) {
                n = c - 48;
            } else if (65 <= c && c <= 70) {
                n = c - 65 + 10;
            } else if (97 <= c && c <= 102) {
                n = c - 97 + 10;
            } else {
                JsonError.Message message = new JsonError.Message("invalid charcode in string");
                throw new JsonDecoder.UnsafeJson((List<JsonError>)this.trace.$colon$colon((Object)message));
            }
            c = n;
            accum = accum * 16 + c;
        }
        return accum;
    }

    public EscapedString(List<JsonError> trace, OneCharReader in) {
        this.trace = trace;
        this.in = in;
        OneCharReader.$init$(this);
        this.escaped = false;
    }
}

