/*
 * Decompiled with CFR 0.152.
 */
package zio.json.javatime;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.runtime.BoxedUnit;

public final class serializers$ {
    public static final serializers$ MODULE$ = new serializers$();

    public String toString(Duration x2) {
        StringBuilder stringBuilder;
        StringBuilder s = new StringBuilder(16);
        s.append('P').append('T');
        long totalSecs = x2.getSeconds();
        int nano = x2.getNano();
        if ((totalSecs | (long)nano) == 0L) {
            stringBuilder = s.append('0').append('S');
        } else {
            long effectiveTotalSecs = totalSecs;
            if (totalSecs < 0L && nano > 0) {
                ++effectiveTotalSecs;
            }
            long hours = effectiveTotalSecs / 3600L;
            int secsOfHour = (int)(effectiveTotalSecs - hours * 3600L);
            int minutes = secsOfHour / 60;
            int seconds = secsOfHour - minutes * 60;
            Object object = hours != 0L ? s.append(hours).append('H') : BoxedUnit.UNIT;
            Object object2 = minutes != 0 ? s.append(minutes).append('M') : BoxedUnit.UNIT;
            if ((seconds | nano) != 0) {
                StringBuilder stringBuilder2 = totalSecs < 0L && seconds == 0 ? s.append('-').append('0') : s.append(seconds);
                if (nano != 0) {
                    if (totalSecs < 0L) {
                        nano = 1000000000 - nano;
                    }
                    int dotPos = s.length();
                    s.append(nano + 1000000000);
                    int i = s.length() - 1;
                    while (s.charAt(i) == '0') {
                        --i;
                    }
                    s.setLength(i + 1);
                    s.setCharAt(dotPos, '.');
                }
                stringBuilder = s.append('S');
            } else {
                stringBuilder = BoxedUnit.UNIT;
            }
        }
        return s.toString();
    }

    public String toString(Instant x2) {
        StringBuilder s;
        block4: {
            int year;
            int marchDayOfYear;
            s = new StringBuilder(32);
            long epochSecond = x2.getEpochSecond();
            long epochDay = (epochSecond >= 0L ? epochSecond : epochSecond - 86399L) / 86400L;
            int secsOfDay = (int)(epochSecond - epochDay * 86400L);
            long marchZeroDay = epochDay + 719468L;
            int adjustYear = 0;
            if (marchZeroDay < 0L) {
                int adjust400YearCycles = this.to400YearCycle(marchZeroDay + 1L) - 1;
                adjustYear = adjust400YearCycles * 400;
                marchZeroDay -= (long)adjust400YearCycles * 146097L;
            }
            if ((marchDayOfYear = this.toMarchDayOfYear(marchZeroDay, year = this.to400YearCycle(marchZeroDay * 400L + 591L))) < 0) {
                marchDayOfYear = this.toMarchDayOfYear(marchZeroDay, --year);
            }
            int marchMonth = marchDayOfYear * 17135 + 6854 >> 19;
            year += (marchMonth * 3277 >> 15) + adjustYear;
            int month = marchMonth + (marchMonth < 10 ? 3 : -9);
            int day = marchDayOfYear - (marchMonth * 1002762 - 16383 >> 15);
            int hour = secsOfDay * 37283 >>> 27;
            int secsOfHour = secsOfDay - hour * 3600;
            int minute = secsOfHour * 17477 >> 20;
            int second = secsOfHour - minute * 60;
            this.appendYear(year, s);
            this.append2Digits(month, s.append('-'));
            this.append2Digits(day, s.append('-'));
            this.append2Digits(hour, s.append('T'));
            this.append2Digits(minute, s.append(':'));
            this.append2Digits(second, s.append(':'));
            int nano = x2.getNano();
            if (nano == 0) break block4;
            s.append('.');
            int q1 = nano / 1000000;
            int r1 = nano - q1 * 1000000;
            this.append3Digits(q1, s);
            if (r1 != 0) {
                int q2 = r1 / 1000;
                int r2 = r1 - q2 * 1000;
                this.append3Digits(q2, s);
                if (r2 != 0) {
                    this.append3Digits(r2, s);
                }
            }
        }
        return s.append('Z').toString();
    }

    public String toString(LocalDate x2) {
        StringBuilder s = new StringBuilder(16);
        this.appendLocalDate(x2, s);
        return s.toString();
    }

    public String toString(LocalDateTime x2) {
        StringBuilder s = new StringBuilder(32);
        this.appendLocalDate(x2.toLocalDate(), s);
        this.appendLocalTime(x2.toLocalTime(), s.append('T'));
        return s.toString();
    }

    public String toString(LocalTime x2) {
        StringBuilder s = new StringBuilder(24);
        this.appendLocalTime(x2, s);
        return s.toString();
    }

    public String toString(MonthDay x2) {
        StringBuilder s = new StringBuilder(8);
        this.append2Digits(x2.getMonthValue(), s.append('-').append('-'));
        this.append2Digits(x2.getDayOfMonth(), s.append('-'));
        return s.toString();
    }

    public String toString(OffsetDateTime x2) {
        StringBuilder s = new StringBuilder(48);
        this.appendLocalDate(x2.toLocalDate(), s);
        this.appendLocalTime(x2.toLocalTime(), s.append('T'));
        this.appendZoneOffset(x2.getOffset(), s);
        return s.toString();
    }

    public String toString(OffsetTime x2) {
        StringBuilder s = new StringBuilder(32);
        this.appendLocalTime(x2.toLocalTime(), s);
        this.appendZoneOffset(x2.getOffset(), s);
        return s.toString();
    }

    public String toString(Period x2) {
        StringBuilder stringBuilder;
        StringBuilder s = new StringBuilder(16);
        s.append('P');
        if (x2.isZero()) {
            stringBuilder = s.append('0').append('D');
        } else {
            int years = x2.getYears();
            int months = x2.getMonths();
            int days = x2.getDays();
            Object object = years != 0 ? s.append(years).append('Y') : BoxedUnit.UNIT;
            Object object2 = months != 0 ? s.append(months).append('M') : BoxedUnit.UNIT;
            stringBuilder = days != 0 ? s.append(days).append('D') : BoxedUnit.UNIT;
        }
        return s.toString();
    }

    public String toString(Year x2) {
        StringBuilder s = new StringBuilder(16);
        this.appendYear(x2.getValue(), s);
        return s.toString();
    }

    public String toString(YearMonth x2) {
        StringBuilder s = new StringBuilder(16);
        this.appendYear(x2.getYear(), s);
        this.append2Digits(x2.getMonthValue(), s.append('-'));
        return s.toString();
    }

    public String toString(ZonedDateTime x2) {
        StringBuilder s = new StringBuilder(48);
        this.appendLocalDate(x2.toLocalDate(), s);
        this.appendLocalTime(x2.toLocalTime(), s.append('T'));
        this.appendZoneOffset(x2.getOffset(), s);
        ZoneId zone = x2.getZone();
        Object object = !(zone instanceof ZoneOffset) ? s.append('[').append(zone.getId()).append(']') : BoxedUnit.UNIT;
        return s.toString();
    }

    public String toString(ZoneId x2) {
        return x2.getId();
    }

    public String toString(ZoneOffset x2) {
        StringBuilder s = new StringBuilder(16);
        this.appendZoneOffset(x2, s);
        return s.toString();
    }

    private void appendLocalDate(LocalDate x2, StringBuilder s) {
        this.appendYear(x2.getYear(), s);
        this.append2Digits(x2.getMonthValue(), s.append('-'));
        this.append2Digits(x2.getDayOfMonth(), s.append('-'));
    }

    private void appendLocalTime(LocalTime x2, StringBuilder s) {
        this.append2Digits(x2.getHour(), s);
        this.append2Digits(x2.getMinute(), s.append(':'));
        this.append2Digits(x2.getSecond(), s.append(':'));
        int nano = x2.getNano();
        if (nano != 0) {
            int dotPos = s.length();
            s.append(nano + 1000000000);
            int i = s.length() - 1;
            while (s.charAt(i) == '0') {
                --i;
            }
            s.setLength(i + 1);
            s.setCharAt(dotPos, '.');
            return;
        }
    }

    private void appendZoneOffset(ZoneOffset x2, StringBuilder s) {
        int n;
        int totalSeconds = x2.getTotalSeconds();
        if (totalSeconds == 0) {
            s.append('Z');
            return;
        }
        if (totalSeconds > 0) {
            s.append('+');
            n = totalSeconds;
        } else {
            s.append('-');
            n = -totalSeconds;
        }
        int q0 = n;
        int q1 = q0 * 37283 >>> 27;
        int r1 = q0 - q1 * 3600;
        this.append2Digits(q1, s);
        s.append(':');
        int q2 = r1 * 17477 >> 20;
        int r2 = r1 - q2 * 60;
        this.append2Digits(q2, s);
        if (r2 != 0) {
            this.append2Digits(r2, s.append(':'));
            return;
        }
    }

    private void appendYear(int x2, StringBuilder s) {
        if (x2 >= 0) {
            if (x2 < 10000) {
                this.append4Digits(x2, s);
                return;
            }
            s.append('+').append(x2);
            return;
        }
        if (x2 > -10000) {
            this.append4Digits(-x2, s.append('-'));
            return;
        }
        s.append(x2);
    }

    private void append4Digits(int x2, StringBuilder s) {
        int q = x2 * 5243 >> 19;
        this.append2Digits(q, s);
        this.append2Digits(x2 - q * 100, s);
    }

    private void append3Digits(int x2, StringBuilder s) {
        int q = x2 * 1311 >> 17;
        this.append2Digits(x2 - q * 100, s.append((char)(q + 48)));
    }

    private void append2Digits(int x2, StringBuilder s) {
        int q = x2 * 103 >> 10;
        s.append((char)(q + 48)).append((char)(x2 + 48 - q * 10));
    }

    private int to400YearCycle(long day) {
        return (int)(day / 146097L);
    }

    private int toMarchDayOfYear(long marchZeroDay, int year) {
        int century = year / 100;
        return (int)(marchZeroDay - (long)year * 365L) - (year >> 2) + century - (century >> 2);
    }

    private serializers$() {
    }
}

