/*
 * Decompiled with CFR 0.152.
 */
package zio.json;

import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.json.JsonError;
import zio.json.JsonFieldDecoder;
import zio.json.LowPriorityJsonFieldDecoder;
import zio.json.internal.Lexer$;
import zio.json.uuid.UUIDParser$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JsonFieldDecoder$
implements LowPriorityJsonFieldDecoder {
    public static final JsonFieldDecoder$ MODULE$ = new JsonFieldDecoder$();
    private static final JsonFieldDecoder<String> string = new JsonFieldDecoder<String>(){

        public final <B> JsonFieldDecoder<B> map(Function1<String, B> f) {
            return JsonFieldDecoder.map$(this, f);
        }

        public final <B> JsonFieldDecoder<B> mapOrFail(Function1<String, Either<String, B>> f) {
            return JsonFieldDecoder.mapOrFail$(this, f);
        }

        public String unsafeDecodeField(List<JsonError> trace, String in) {
            return in;
        }
        {
            JsonFieldDecoder.$init$(this);
        }
    };
    private static final JsonFieldDecoder<Object> int = new JsonFieldDecoder<Object>(){

        public final <B> JsonFieldDecoder<B> map(Function1<Object, B> f) {
            return JsonFieldDecoder.map$(this, f);
        }

        public final <B> JsonFieldDecoder<B> mapOrFail(Function1<Object, Either<String, B>> f) {
            return JsonFieldDecoder.mapOrFail$(this, f);
        }

        public int unsafeDecodeField(List<JsonError> trace, String in) {
            int n;
            try {
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(in));
            }
            catch (NumberFormatException numberFormatException) {
                throw Lexer$.MODULE$.error(new StringBuilder(13).append("Invalid Int: ").append(JsonFieldDecoder$.MODULE$.strip(in, JsonFieldDecoder$.MODULE$.strip$default$2())).toString(), trace);
            }
            return n;
        }
        {
            JsonFieldDecoder.$init$(this);
        }
    };
    private static final JsonFieldDecoder<Object> long = new JsonFieldDecoder<Object>(){

        public final <B> JsonFieldDecoder<B> map(Function1<Object, B> f) {
            return JsonFieldDecoder.map$(this, f);
        }

        public final <B> JsonFieldDecoder<B> mapOrFail(Function1<Object, Either<String, B>> f) {
            return JsonFieldDecoder.mapOrFail$(this, f);
        }

        public long unsafeDecodeField(List<JsonError> trace, String in) {
            long l;
            try {
                l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(in));
            }
            catch (NumberFormatException numberFormatException) {
                throw Lexer$.MODULE$.error(new StringBuilder(14).append("Invalid Long: ").append(JsonFieldDecoder$.MODULE$.strip(in, JsonFieldDecoder$.MODULE$.strip$default$2())).toString(), trace);
            }
            return l;
        }
        {
            JsonFieldDecoder.$init$(this);
        }
    };
    private static final JsonFieldDecoder<UUID> uuid = new JsonFieldDecoder<UUID>(){

        public final <B> JsonFieldDecoder<B> map(Function1<UUID, B> f) {
            return JsonFieldDecoder.map$(this, f);
        }

        public final <B> JsonFieldDecoder<B> mapOrFail(Function1<UUID, Either<String, B>> f) {
            return JsonFieldDecoder.mapOrFail$(this, f);
        }

        public UUID unsafeDecodeField(List<JsonError> trace, String in) {
            UUID uUID;
            try {
                uUID = UUIDParser$.MODULE$.unsafeParse(in);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Lexer$.MODULE$.error("expected a UUID", trace);
            }
            return uUID;
        }
        {
            JsonFieldDecoder.$init$(this);
        }
    };

    public <A> JsonFieldDecoder<A> apply(JsonFieldDecoder<A> a) {
        return a;
    }

    public JsonFieldDecoder<String> string() {
        return string;
    }

    public JsonFieldDecoder<Object> int() {
        return int;
    }

    public JsonFieldDecoder<Object> long() {
        return long;
    }

    public JsonFieldDecoder<UUID> uuid() {
        return uuid;
    }

    public <A> JsonFieldDecoder<A> mapStringOrFail(Function1<String, Either<String, A>> f) {
        return new JsonFieldDecoder<A>(f){
            private final Function1 f$3;

            public final <B> JsonFieldDecoder<B> map(Function1<A, B> f) {
                return JsonFieldDecoder.map$(this, f);
            }

            public final <B> JsonFieldDecoder<B> mapOrFail(Function1<A, Either<String, B>> f) {
                return JsonFieldDecoder.mapOrFail$(this, f);
            }

            public A unsafeDecodeField(List<JsonError> trace, String in) {
                Either either = (Either)this.f$3.apply((Object)JsonFieldDecoder$.MODULE$.string().unsafeDecodeField(trace, in));
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String err = (String)left.value();
                    throw Lexer$.MODULE$.error(err, trace);
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Object value = right.value();
                    return (A)value;
                }
                throw new MatchError((Object)either);
            }
            {
                this.f$3 = f$3;
                JsonFieldDecoder.$init$(this);
            }
        };
    }

    public String strip(String s, int len) {
        if (s.length() <= len) {
            return s;
        }
        return new StringBuilder(3).append(s.substring(0, len)).append("...").toString();
    }

    public int strip$default$2() {
        return 50;
    }

    private JsonFieldDecoder$() {
    }
}

