/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.json.JsonDecoder;
import zio.json.JsonError;
import zio.json.internal.OneCharReader;
import zio.json.internal.RetractReader;
import zio.json.internal.StringMatrix;
import zio.json.internal.StringMatrix$;
import zio.json.internal.UnexpectedEnd;
import zio.json.internal.UnsafeNumbers$;
import zio.json.internal.UnsafeNumbers$UnsafeNumber$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Lexer$ {
    public static final Lexer$ MODULE$;
    private static final int NumberMaxBits;
    private static final ThreadLocal<char[]> charArrays;
    private static final byte[] hexDigits;
    private static final ZoneOffset[] zoneOffsets;
    private static final ConcurrentHashMap<String, ZoneId> zoneIds;
    private static final StringMatrix dayOfWeekMatrix;
    private static final StringMatrix monthMatrix;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new Lexer$();
        NumberMaxBits = 256;
        charArrays = new ThreadLocal<char[]>(){

            public char[] initialValue() {
                return new char[1024];
            }
        };
        byte[] ns = new byte[256];
        Arrays.fill(ns, (byte)-1);
        ns[48] = 0;
        ns[49] = 1;
        ns[50] = 2;
        ns[51] = 3;
        ns[52] = 4;
        ns[53] = 5;
        ns[54] = 6;
        ns[55] = 7;
        ns[56] = 8;
        ns[57] = 9;
        ns[65] = 10;
        ns[66] = 11;
        ns[67] = 12;
        ns[68] = 13;
        ns[69] = 14;
        ns[70] = 15;
        ns[97] = 10;
        ns[98] = 11;
        ns[99] = 12;
        ns[100] = 13;
        ns[101] = 14;
        ns[102] = 15;
        hexDigits = var0;
        zoneOffsets = new ZoneOffset[145];
        zoneIds = new ConcurrentHashMap(256);
        dayOfWeekMatrix = new StringMatrix((String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])DayOfWeek.values()), (Function1 & Serializable)x$1 -> x$1.toString(), ClassTag$.MODULE$.apply(String.class)), StringMatrix$.MODULE$.$lessinit$greater$default$2());
        monthMatrix = new StringMatrix((String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Month.values()), (Function1 & Serializable)x$2 -> x$2.toString(), ClassTag$.MODULE$.apply(String.class)), StringMatrix$.MODULE$.$lessinit$greater$default$2());
    }

    public int NumberMaxBits() {
        return NumberMaxBits;
    }

    public Nothing$ error(String msg, List<JsonError> trace) {
        JsonError.Message message = new JsonError.Message(msg);
        throw new JsonDecoder.UnsafeJson((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public Nothing$ error(String expected, char got, List<JsonError> trace) {
        return this.error(new StringBuilder(16).append("expected ").append(expected).append(" got '").append(got).append("'").toString(), trace);
    }

    public Nothing$ error(char c, List<JsonError> trace) {
        return this.error(new StringBuilder(21).append("invalid '\\").append(c).append("' in string").toString(), trace);
    }

    public boolean firstField(List<JsonError> trace, RetractReader in) {
        if (in.nextNonWhitespace() != '}') {
            in.retract();
            return true;
        }
        return false;
    }

    public boolean nextField(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == ',') {
            return true;
        }
        if (c == '}') {
            return false;
        }
        throw this.error("',' or '}'", c, trace);
    }

    public boolean firstArrayElement(RetractReader in) {
        if (in.nextNonWhitespace() != ']') {
            in.retract();
            return true;
        }
        return false;
    }

    public boolean nextArrayElement(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == ',') {
            return true;
        }
        if (c == ']') {
            return false;
        }
        throw this.error("',' or ']'", c, trace);
    }

    public int field(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        int f = this.enumeration(trace, in, matrix);
        char c = in.nextNonWhitespace();
        if (c == ':') {
            return f;
        }
        throw this.error("':'", c, trace);
    }

    public int enumeration(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        char c = in.nextNonWhitespace();
        if (c != '\"') {
            throw this.error("'\"'", c, trace);
        }
        long bs = matrix.initial();
        int i = 0;
        while ((c = in.readChar()) != '\"') {
            if (c == '\\') {
                c = this.nextEscaped(trace, in);
            } else if (c < ' ') {
                throw this.error("invalid control in string", trace);
            }
            bs = matrix.update(bs, i, c);
            ++i;
        }
        return matrix.first(matrix.exact(bs, i));
    }

    public void skipValue(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case 'n': 
            case 't': {
                this.skipFixedChars(in, 3);
                return;
            }
            case 'f': {
                this.skipFixedChars(in, 4);
                return;
            }
            case '{': {
                this.skipObject(in, 0);
                return;
            }
            case '[': {
                this.skipArray(in, 0);
                return;
            }
            case '\"': {
                this.skipString(in, true);
                return;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipNumber(in);
                return;
            }
        }
        throw this.error(new StringBuilder(13).append("unexpected '").append(c).append("'").toString(), trace);
    }

    public void skipNumber(RetractReader in) {
        while (this.isNumber(in.readChar())) {
        }
        in.retract();
    }

    public void skipString(List<JsonError> trace, OneCharReader in) {
        this.skipString(in, true);
    }

    private void skipFixedChars(OneCharReader in, int n) {
        while (n > 0) {
            in.readChar();
            --n;
        }
    }

    private void skipString(OneCharReader in, boolean evenBackSlashes) {
        while (true) {
            char ch = in.readChar();
            if (evenBackSlashes) {
                if (ch != '\"') {
                    evenBackSlashes = ch != '\\';
                    continue;
                }
                break;
            }
            evenBackSlashes = true;
        }
    }

    private void skipObject(OneCharReader in, int level) {
        while (true) {
            char ch;
            if ((ch = in.readChar()) == '\"') {
                this.skipString(in, true);
                continue;
            }
            if (ch == '{') {
                ++level;
                continue;
            }
            if (ch != '}') continue;
            if (level == 0) break;
            --level;
        }
    }

    private void skipArray(OneCharReader in, int level) {
        while (true) {
            char b;
            if ((b = in.readChar()) == '\"') {
                this.skipString(in, true);
                continue;
            }
            if (b == '[') {
                ++level;
                continue;
            }
            if (b != ']') continue;
            if (level == 0) break;
            --level;
        }
    }

    public boolean boolean(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == 't' && in.readChar() == 'r' && in.readChar() == 'u' && in.readChar() == 'e') {
            return true;
        }
        if (c == 'f' && in.readChar() == 'a' && in.readChar() == 'l' && in.readChar() == 's' && in.readChar() == 'e') {
            return false;
        }
        throw this.error("expected a Boolean", c, trace);
    }

    public byte byte(List<JsonError> trace, RetractReader in) {
        byte by;
        try {
            byte i = UnsafeNumbers$.MODULE$.byte_(in, false);
            in.retract();
            by = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error("expected a Byte", trace);
            }
            throw throwable;
        }
        return by;
    }

    public short short(List<JsonError> trace, RetractReader in) {
        short s;
        try {
            short i = UnsafeNumbers$.MODULE$.short_(in, false);
            in.retract();
            s = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error("expected a Short", trace);
            }
            throw throwable;
        }
        return s;
    }

    public int int(List<JsonError> trace, RetractReader in) {
        int n;
        try {
            int i = UnsafeNumbers$.MODULE$.int_(in, false);
            in.retract();
            n = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error("expected an Int", trace);
            }
            throw throwable;
        }
        return n;
    }

    public long long(List<JsonError> trace, RetractReader in) {
        long l;
        try {
            long i = UnsafeNumbers$.MODULE$.long_(in, false);
            in.retract();
            l = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error("expected a Long", trace);
            }
            throw throwable;
        }
        return l;
    }

    public BigInteger bigInteger(List<JsonError> trace, RetractReader in) {
        BigInteger bigInteger;
        try {
            BigInteger i = UnsafeNumbers$.MODULE$.bigInteger_(in, false, this.NumberMaxBits());
            in.retract();
            bigInteger = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error(new StringBuilder(26).append("expected a ").append(this.NumberMaxBits()).append("-bit BigInteger").toString(), trace);
            }
            throw throwable;
        }
        return bigInteger;
    }

    public BigInt bigInt(List<JsonError> trace, RetractReader in) {
        BigInt bigInt;
        try {
            BigInt i = UnsafeNumbers$.MODULE$.bigInt_(in, false, this.NumberMaxBits());
            in.retract();
            bigInt = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error(new StringBuilder(22).append("expected a ").append(this.NumberMaxBits()).append("-bit BigInt").toString(), trace);
            }
            throw throwable;
        }
        return bigInt;
    }

    public float float(List<JsonError> trace, RetractReader in) {
        float f;
        try {
            float i = UnsafeNumbers$.MODULE$.float_(in, false, this.NumberMaxBits());
            in.retract();
            f = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error("expected a Float", trace);
            }
            throw throwable;
        }
        return f;
    }

    public double double(List<JsonError> trace, RetractReader in) {
        double d;
        try {
            double i = UnsafeNumbers$.MODULE$.double_(in, false, this.NumberMaxBits());
            in.retract();
            d = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error("expected a Double", trace);
            }
            throw throwable;
        }
        return d;
    }

    public BigDecimal bigDecimal(List<JsonError> trace, RetractReader in) {
        BigDecimal bigDecimal;
        try {
            BigDecimal i = UnsafeNumbers$.MODULE$.bigDecimal_(in, false, this.NumberMaxBits());
            in.retract();
            bigDecimal = i;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                throw this.error(new StringBuilder(40).append("expected a BigDecimal with ").append(this.NumberMaxBits()).append("-bit mantissa").toString(), trace);
            }
            throw throwable;
        }
        return bigDecimal;
    }

    public Reader streamingString(List<JsonError> trace, OneCharReader in) {
        this.char(trace, in, '\"');
        return new OneCharReader(in, trace){
            private boolean escaped;
            private final OneCharReader in$1;
            private final List trace$1;

            public int read(char[] cbuf, int off, int len) {
                return OneCharReader.read$(this, cbuf, off, len);
            }

            public char nextNonWhitespace() {
                return OneCharReader.nextNonWhitespace$(this);
            }

            public boolean isWhitespace(char c) {
                return OneCharReader.isWhitespace$(this, c);
            }

            public void close() {
                ((Reader)((Object)this.in$1)).close();
            }

            public int read() {
                char c;
                while (true) {
                    c = this.in$1.readChar();
                    if (this.escaped) {
                        int n;
                        this.escaped = false;
                        char c2 = c;
                        switch (c2) {
                            case '\"': 
                            case '/': 
                            case '\\': {
                                n = c;
                                break;
                            }
                            case 'b': {
                                n = 8;
                                break;
                            }
                            case 'f': {
                                n = 12;
                                break;
                            }
                            case 'n': {
                                n = 10;
                                break;
                            }
                            case 'r': {
                                n = 13;
                                break;
                            }
                            case 't': {
                                n = 9;
                                break;
                            }
                            case 'u': {
                                n = Lexer$.MODULE$.zio$json$internal$Lexer$$nextHex4((List<JsonError>)this.trace$1, this.in$1);
                                break;
                            }
                            default: {
                                throw Lexer$.MODULE$.error(c2, (List<JsonError>)this.trace$1);
                            }
                        }
                        return n;
                    }
                    if (c != '\\') break;
                    this.escaped = true;
                }
                if (c == '\"') {
                    return -1;
                }
                if (c < ' ') {
                    throw Lexer$.MODULE$.error("invalid control in string", (List<JsonError>)this.trace$1);
                }
                return c;
            }

            public char readChar() {
                int v = this.read();
                if (v == -1) {
                    throw new UnexpectedEnd();
                }
                return (char)v;
            }
            {
                this.in$1 = in$1;
                this.trace$1 = trace$1;
                OneCharReader.$init$(this);
                this.escaped = false;
            }
        };
    }

    public CharSequence string(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == '\"') {
            char[] cs = charArrays.get();
            int i = 0;
            while ((c = in.readChar()) != '\"') {
                if (c == '\\') {
                    c = this.nextEscaped(trace, in);
                } else if (c < ' ') {
                    throw this.error("invalid control in string", trace);
                }
                if (i == cs.length) {
                    cs = Arrays.copyOf(cs, i << 1);
                }
                cs[i] = c;
                ++i;
            }
            return new String(cs, 0, i);
        }
        throw this.error("expected string", trace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UUID uuid(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c != '\"') throw this.uuidError(trace);
        char[] cs = charArrays.get();
        int i = 0;
        while ((c = in.readChar()) != '\"') {
            if (c == '\\') {
                c = this.nextEscaped(trace, in);
            }
            if (i == 36 || c > '\u00ff') {
                throw this.uuidError(trace);
            }
            cs[i] = c;
            ++i;
        }
        if (i == 36) {
            char c1 = cs[8];
            char c2 = cs[13];
            char c3 = cs[18];
            char c4 = cs[23];
            if (c1 == '-' && c2 == '-' && c3 == '-' && c4 == '-') {
                byte[] ds = hexDigits;
                long msb1 = (long)ds[cs[0]] << 28 | (long)(ds[cs[1]] << 24 | ds[cs[2]] << 20 | ds[cs[3]] << 16 | ds[cs[4]] << 12 | ds[cs[5]] << 8 | ds[cs[6]] << 4 | ds[cs[7]]);
                long msb2 = ds[cs[9]] << 12 | ds[cs[10]] << 8 | ds[cs[11]] << 4 | ds[cs[12]];
                long msb3 = ds[cs[14]] << 12 | ds[cs[15]] << 8 | ds[cs[16]] << 4 | ds[cs[17]];
                long lsb1 = ds[cs[19]] << 12 | ds[cs[20]] << 8 | ds[cs[21]] << 4 | ds[cs[22]];
                long lsb2 = (long)(ds[cs[24]] << 16 | ds[cs[25]] << 12 | ds[cs[26]] << 8 | ds[cs[27]] << 4 | ds[cs[28]]) << 28 | (long)(ds[cs[29]] << 24 | ds[cs[30]] << 20 | ds[cs[31]] << 16 | ds[cs[32]] << 12 | ds[cs[33]] << 8 | ds[cs[34]] << 4 | ds[cs[35]]);
                if ((msb1 | msb2 | msb3 | lsb1 | lsb2) < 0L) throw this.uuidError(trace);
                return new UUID(msb1 << 32 | msb2 << 16 | msb3, lsb1 << 48 | lsb2);
            }
        }
        if (i > 36) throw this.uuidError(trace);
        return this.uuidExtended(trace, cs, i);
    }

    private UUID uuidExtended(List<JsonError> trace, char[] cs, int len) {
        int dash1 = this.indexOfDash(cs, 1, len);
        int dash2 = this.indexOfDash(cs, dash1 + 2, len);
        int dash3 = this.indexOfDash(cs, dash2 + 2, len);
        int dash4 = this.indexOfDash(cs, dash3 + 2, len);
        if (dash4 >= 0) {
            byte[] ds = hexDigits;
            long section1 = this.uuidSection(trace, ds, cs, 0, dash1, -4294967296L);
            long section2 = this.uuidSection(trace, ds, cs, dash1 + 1, dash2, -65536L);
            long section3 = this.uuidSection(trace, ds, cs, dash2 + 1, dash3, -65536L);
            long section4 = this.uuidSection(trace, ds, cs, dash3 + 1, dash4, -65536L);
            long section5 = this.uuidSection(trace, ds, cs, dash4 + 1, len, -281474976710656L);
            return new UUID(section1 << 32 | section2 << 16 | section3, section4 << 48 | section5);
        }
        throw this.uuidError(trace);
    }

    private int indexOfDash(char[] cs, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (cs[i] != '-') continue;
            return i;
        }
        return -1;
    }

    private long uuidSection(List<JsonError> trace, byte[] ds, char[] cs, int from, int to, long mask) {
        if (from < to && from + 16 >= to) {
            long result = 0L;
            for (int i = from; i < to; ++i) {
                result = result << 4 | (long)ds[cs[i]];
            }
            if ((result & mask) == 0L) {
                return result;
            }
        }
        throw this.uuidError(trace);
    }

    public Duration duration(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == '\"') {
            boolean isNeg;
            char[] cs = charArrays.get();
            int i = 0;
            while ((c = in.readChar()) != '\"') {
                if (c == '\\') {
                    c = this.nextEscaped(trace, in);
                }
                cs[i] = c;
                ++i;
            }
            int pos = 0;
            long seconds = 0L;
            int nanos = 0;
            int state = 0;
            if (pos >= i) {
                throw this.durationError(trace);
            }
            char ch = cs[pos];
            ++pos;
            boolean bl = isNeg = ch == '-';
            if (isNeg) {
                if (pos >= i) {
                    throw this.durationError(trace);
                }
                ch = cs[pos];
                ++pos;
            }
            if (ch != 'P' || pos >= i) {
                throw this.durationError(trace);
            }
            ch = cs[pos];
            ++pos;
            do {
                boolean isNegX;
                if (state == 0) {
                    if (ch == 'T') {
                        if (pos >= i) {
                            throw this.durationError(trace);
                        }
                        ch = cs[pos];
                        ++pos;
                        state = 1;
                    }
                } else if (state == 1) {
                    if (ch != 'T' || pos >= i) {
                        throw this.durationError(trace);
                    }
                    ch = cs[pos];
                    ++pos;
                } else if (state == 4 && pos >= i) {
                    throw this.durationError(trace);
                }
                boolean bl2 = isNegX = ch == '-';
                if (isNegX) {
                    if (pos >= i) {
                        throw this.durationError(trace);
                    }
                    ch = cs[pos];
                    ++pos;
                }
                if (ch < '0' || ch > '9') {
                    throw this.durationError(trace);
                }
                long x = 48 - ch;
                while (pos < i && (ch = cs[pos]) >= '0' && ch <= '9') {
                    if (x < -922337203685477580L || (x = x * 10L + (long)(48 - ch)) > 0L) {
                        throw this.durationError(trace);
                    }
                    ++pos;
                }
                if (!(isNeg ^ isNegX)) {
                    if (x == Long.MIN_VALUE) {
                        throw this.durationError(trace);
                    }
                    x = -x;
                }
                if (ch == 'D' && state <= 0) {
                    if (x < -106751991167300L || x > 106751991167300L) {
                        throw this.durationError(trace);
                    }
                    seconds = x * 86400L;
                    state = 1;
                } else if (ch == 'H' && state <= 1) {
                    if (x < -2562047788015215L || x > 2562047788015215L) {
                        throw this.durationError(trace);
                    }
                    seconds = this.sumSeconds(x * 3600L, seconds, trace);
                    state = 2;
                } else if (ch == 'M' && state <= 2) {
                    if (x < -153722867280912930L || x > 0x222222222222222L) {
                        throw this.durationError(trace);
                    }
                    seconds = this.sumSeconds(x * 60L, seconds, trace);
                    state = 3;
                } else if (ch == '.') {
                    ++pos;
                    seconds = this.sumSeconds(x, seconds, trace);
                    int nanoDigitWeight = 100000000;
                    while (pos < i && (ch = cs[pos]) >= '0' && ch <= '9' && nanoDigitWeight != 0) {
                        nanos += (ch - 48) * nanoDigitWeight;
                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                        ++pos;
                    }
                    if (ch != 'S') {
                        throw this.durationError(trace);
                    }
                    if (isNeg ^ isNegX) {
                        nanos = -nanos;
                    }
                    state = 4;
                } else if (ch == 'S') {
                    seconds = this.sumSeconds(x, seconds, trace);
                    state = 4;
                } else {
                    throw this.durationError(trace);
                }
                if (++pos >= i) break;
                ch = cs[pos];
                ++pos;
            } while (true);
            return Duration.ofSeconds(seconds, nanos);
        }
        throw this.durationError(trace);
    }

    public Instant instant(List<JsonError> trace, OneCharReader in) {
        block39: {
            int offsetTotal;
            int nano;
            int epochSecond;
            long epochDay;
            int pos;
            int i;
            block49: {
                boolean offsetNeg;
                block52: {
                    block55: {
                        int ch;
                        char[] cs;
                        block54: {
                            block53: {
                                block51: {
                                    block50: {
                                        boolean bl;
                                        block46: {
                                            block48: {
                                                block47: {
                                                    block45: {
                                                        block44: {
                                                            int day;
                                                            int month;
                                                            int year;
                                                            block43: {
                                                                block40: {
                                                                    block42: {
                                                                        boolean yearNeg;
                                                                        boolean bl2;
                                                                        char ch4;
                                                                        char ch3;
                                                                        char ch2;
                                                                        char ch1;
                                                                        char ch0;
                                                                        block41: {
                                                                            char c = in.nextNonWhitespace();
                                                                            if (c != '\"') break block39;
                                                                            cs = charArrays.get();
                                                                            i = 0;
                                                                            while ((c = in.readChar()) != '\"') {
                                                                                if (c == '\\') {
                                                                                    c = this.nextEscaped(trace, in);
                                                                                }
                                                                                cs[i] = c;
                                                                                ++i;
                                                                            }
                                                                            pos = 0;
                                                                            year = 0;
                                                                            month = 0;
                                                                            day = 0;
                                                                            if (pos + 4 >= i) break block40;
                                                                            ch0 = cs[pos];
                                                                            ch1 = cs[pos + 1];
                                                                            ch2 = cs[pos + 2];
                                                                            ch3 = cs[pos + 3];
                                                                            ch4 = cs[pos + 4];
                                                                            pos += 5;
                                                                            if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block40;
                                                                            if (ch0 < '0' || ch0 > '9') break block41;
                                                                            year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                                                                            if (ch4 != '-') break block40;
                                                                            break block42;
                                                                        }
                                                                        year = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
                                                                        if (ch0 == '-') {
                                                                            bl2 = true;
                                                                        } else {
                                                                            if (ch0 != '+') {
                                                                                throw this.instantError(trace);
                                                                            }
                                                                            bl2 = yearNeg = false;
                                                                        }
                                                                        if (ch4 < '0' || ch4 > '9') break block40;
                                                                        int yearDigits = 4;
                                                                        int ch5 = 48;
                                                                        while (pos < i) {
                                                                            ch5 = cs[pos];
                                                                            ++pos;
                                                                            if (ch5 < 48 || ch5 > 57 || yearDigits >= 10) break;
                                                                            year = year > 100000000 ? Integer.MAX_VALUE : year * 10 + (ch5 - 48);
                                                                            ++yearDigits;
                                                                        }
                                                                        if (yearDigits == 10 && year > 1000000000 || yearNeg && (year = -year) == 0 || ch5 != 45) break block40;
                                                                    }
                                                                    if (pos + 5 >= i) break block40;
                                                                    char ch0 = cs[pos];
                                                                    char ch1 = cs[pos + 1];
                                                                    char ch2 = cs[pos + 2];
                                                                    char ch3 = cs[pos + 3];
                                                                    char ch4 = cs[pos + 4];
                                                                    char ch5 = cs[pos + 5];
                                                                    pos += 6;
                                                                    month = ch0 * 10 + ch1 - 528;
                                                                    day = ch3 * 10 + ch4 - 528;
                                                                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == '-' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch5 == 'T' && month >= 1 && month <= 12 && day != 0 && (day <= 28 || day <= this.maxDayForYearMonth(year, month))) break block43;
                                                                }
                                                                throw this.instantError(trace);
                                                            }
                                                            epochDay = this.epochDayForYear(year) + (long)(this.dayOfYearForYearMonth(year, month) + day - 719529);
                                                            epochSecond = 0;
                                                            if (pos + 4 >= i) break block44;
                                                            char ch0 = cs[pos];
                                                            char ch1 = cs[pos + 1];
                                                            char ch2 = cs[pos + 2];
                                                            char ch3 = cs[pos + 3];
                                                            char ch4 = cs[pos + 4];
                                                            pos += 5;
                                                            int hour = ch0 * 10 + ch1 - 528;
                                                            epochSecond = hour * 3600 + (ch3 * 10 + ch4 - 528) * 60;
                                                            if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == ':' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch3 <= '5' && hour <= 23) break block45;
                                                        }
                                                        throw this.instantError(trace);
                                                    }
                                                    nano = 0;
                                                    ch = 48;
                                                    if (pos >= i) break block46;
                                                    ch = cs[pos];
                                                    ++pos;
                                                    if (ch != 58) break block46;
                                                    if (pos + 1 >= i) break block47;
                                                    char ch0 = cs[pos];
                                                    char ch1 = cs[pos + 1];
                                                    pos += 2;
                                                    epochSecond += ch0 * 10 + ch1 - 528;
                                                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block48;
                                                }
                                                throw this.instantError(trace);
                                            }
                                            if (pos < i) {
                                                ch = cs[pos];
                                                ++pos;
                                                if (ch == 46) {
                                                    int nanoDigitWeight = 100000000;
                                                    while (pos < i) {
                                                        ch = cs[pos];
                                                        ++pos;
                                                        if (ch < 48 || ch > 57 || nanoDigitWeight == 0) break;
                                                        nano += (ch - 48) * nanoDigitWeight;
                                                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                                                    }
                                                }
                                            }
                                        }
                                        offsetTotal = 0;
                                        if (ch == 90) break block49;
                                        if (ch == 45) {
                                            bl = true;
                                        } else {
                                            if (ch != 43) {
                                                throw this.instantError(trace);
                                            }
                                            bl = offsetNeg = false;
                                        }
                                        if (pos + 1 >= i) break block50;
                                        char ch0 = cs[pos];
                                        char ch1 = cs[pos + 1];
                                        pos += 2;
                                        offsetTotal = (ch0 * 10 + ch1 - 528) * 3600;
                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9') break block51;
                                    }
                                    throw this.instantError(trace);
                                }
                                if (pos >= i) break block52;
                                ch = cs[pos];
                                ++pos;
                                if (ch != 58) break block52;
                                if (pos + 1 >= i) break block53;
                                char ch0 = cs[pos];
                                char ch1 = cs[pos + 1];
                                pos += 2;
                                offsetTotal += (ch0 * 10 + ch1 - 528) * 60;
                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block54;
                            }
                            throw this.instantError(trace);
                        }
                        if (pos >= i) break block52;
                        ch = cs[pos];
                        ++pos;
                        if (ch != 58) break block52;
                        if (pos + 1 >= i) break block55;
                        char ch0 = cs[pos];
                        char ch1 = cs[pos + 1];
                        pos += 2;
                        offsetTotal += ch0 * 10 + ch1 - 528;
                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block52;
                    }
                    throw this.instantError(trace);
                }
                if (offsetTotal > 64800) {
                    throw this.instantError(trace);
                }
                if (offsetNeg) {
                    offsetTotal = -offsetTotal;
                }
            }
            if (pos == i) {
                return Instant.ofEpochSecond(epochDay * 86400L + (long)(epochSecond - offsetTotal), nano);
            }
        }
        throw this.instantError(trace);
    }

    public LocalDate localDate(List<JsonError> trace, OneCharReader in) {
        block10: {
            int day;
            int month;
            int year;
            block14: {
                block11: {
                    int pos;
                    int i;
                    char[] cs;
                    block13: {
                        boolean yearNeg;
                        boolean bl;
                        char ch4;
                        char ch3;
                        char ch2;
                        char ch1;
                        char ch0;
                        block12: {
                            char c = in.nextNonWhitespace();
                            if (c != '\"') break block10;
                            cs = charArrays.get();
                            i = 0;
                            while ((c = in.readChar()) != '\"') {
                                if (c == '\\') {
                                    c = this.nextEscaped(trace, in);
                                }
                                cs[i] = c;
                                ++i;
                            }
                            pos = 0;
                            year = 0;
                            month = 0;
                            day = 0;
                            if (pos + 4 >= i) break block11;
                            ch0 = cs[pos];
                            ch1 = cs[pos + 1];
                            ch2 = cs[pos + 2];
                            ch3 = cs[pos + 3];
                            ch4 = cs[pos + 4];
                            pos += 5;
                            if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block11;
                            if (ch0 < '0' || ch0 > '9') break block12;
                            year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                            if (ch4 != '-') break block11;
                            break block13;
                        }
                        year = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
                        if (ch0 == '-') {
                            bl = true;
                        } else {
                            if (ch0 != '+') {
                                throw this.localDateError(trace);
                            }
                            bl = yearNeg = false;
                        }
                        if (ch4 < '0' || ch4 > '9') break block11;
                        int yearDigits = 4;
                        int ch = 48;
                        while (pos < i) {
                            ch = cs[pos];
                            ++pos;
                            if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                            year = year * 10 + (ch - 48);
                            ++yearDigits;
                        }
                        if (yearNeg && (year = -year) == 0 || ch != 45) break block11;
                    }
                    if (pos + 5 != i) break block11;
                    char ch0 = cs[pos];
                    char ch1 = cs[pos + 1];
                    char ch2 = cs[pos + 2];
                    char ch3 = cs[pos + 3];
                    char ch4 = cs[pos + 4];
                    pos += 5;
                    month = ch0 * 10 + ch1 - 528;
                    day = ch3 * 10 + ch4 - 528;
                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == '-' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && month >= 1 && month <= 12 && day != 0 && (day <= 28 || day <= this.maxDayForYearMonth(year, month))) break block14;
                }
                throw this.localDateError(trace);
            }
            return LocalDate.of(year, month, day);
        }
        throw this.localDateError(trace);
    }

    public LocalDateTime localDateTime(List<JsonError> trace, OneCharReader in) {
        block23: {
            int nano;
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            block30: {
                block33: {
                    int pos;
                    int i;
                    char[] cs;
                    block32: {
                        block31: {
                            block29: {
                                block28: {
                                    block27: {
                                        block24: {
                                            block26: {
                                                boolean yearNeg;
                                                boolean bl;
                                                char ch4;
                                                char ch3;
                                                char ch2;
                                                char ch1;
                                                char ch0;
                                                block25: {
                                                    char c = in.nextNonWhitespace();
                                                    if (c != '\"') break block23;
                                                    cs = charArrays.get();
                                                    i = 0;
                                                    while ((c = in.readChar()) != '\"') {
                                                        if (c == '\\') {
                                                            c = this.nextEscaped(trace, in);
                                                        }
                                                        cs[i] = c;
                                                        ++i;
                                                    }
                                                    pos = 0;
                                                    year = 0;
                                                    month = 0;
                                                    day = 0;
                                                    if (pos + 4 >= i) break block24;
                                                    ch0 = cs[pos];
                                                    ch1 = cs[pos + 1];
                                                    ch2 = cs[pos + 2];
                                                    ch3 = cs[pos + 3];
                                                    ch4 = cs[pos + 4];
                                                    pos += 5;
                                                    if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block24;
                                                    if (ch0 < '0' || ch0 > '9') break block25;
                                                    year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                                                    if (ch4 != '-') break block24;
                                                    break block26;
                                                }
                                                year = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
                                                if (ch0 == '-') {
                                                    bl = true;
                                                } else {
                                                    if (ch0 != '+') {
                                                        throw this.localDateTimeError(trace);
                                                    }
                                                    bl = yearNeg = false;
                                                }
                                                if (ch4 < '0' || ch4 > '9') break block24;
                                                int yearDigits = 4;
                                                int ch = 48;
                                                while (pos < i) {
                                                    ch = cs[pos];
                                                    ++pos;
                                                    if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                                                    year = year * 10 + (ch - 48);
                                                    ++yearDigits;
                                                }
                                                if (yearNeg && (year = -year) == 0 || ch != 45) break block24;
                                            }
                                            if (pos + 5 >= i) break block24;
                                            char ch0 = cs[pos];
                                            char ch1 = cs[pos + 1];
                                            char ch2 = cs[pos + 2];
                                            char ch3 = cs[pos + 3];
                                            char ch4 = cs[pos + 4];
                                            char ch5 = cs[pos + 5];
                                            pos += 6;
                                            month = ch0 * 10 + ch1 - 528;
                                            day = ch3 * 10 + ch4 - 528;
                                            if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == '-' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch5 == 'T' && day != 0 && month >= 1 && month <= 12 && (day <= 28 || day <= this.maxDayForYearMonth(year, month))) break block27;
                                        }
                                        throw this.localDateTimeError(trace);
                                    }
                                    hour = 0;
                                    minute = 0;
                                    if (pos + 4 >= i) break block28;
                                    char ch0 = cs[pos];
                                    char ch1 = cs[pos + 1];
                                    char ch2 = cs[pos + 2];
                                    char ch3 = cs[pos + 3];
                                    char ch4 = cs[pos + 4];
                                    pos += 5;
                                    hour = ch0 * 10 + ch1 - 528;
                                    minute = ch3 * 10 + ch4 - 528;
                                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == ':' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch3 <= '5' && hour <= 23) break block29;
                                }
                                throw this.localDateTimeError(trace);
                            }
                            second = 0;
                            nano = 0;
                            if (pos >= i) break block30;
                            if (cs[pos] != ':' || ++pos + 1 >= i) break block31;
                            char ch0 = cs[pos];
                            char ch1 = cs[pos + 1];
                            pos += 2;
                            second = ch0 * 10 + ch1 - 528;
                            if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block32;
                        }
                        throw this.localDateTimeError(trace);
                    }
                    if (pos >= i) break block30;
                    if (cs[pos] != '.') break block33;
                    ++pos;
                    int nanoDigitWeight = 100000000;
                    int ch = 48;
                    while (pos < i && (ch = cs[pos]) >= 48 && ch <= 57 && nanoDigitWeight != 0) {
                        nano += (ch - 48) * nanoDigitWeight;
                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                        ++pos;
                    }
                    if (pos == i) break block30;
                }
                throw this.localDateTimeError(trace);
            }
            return LocalDateTime.of(year, month, day, hour, minute, second, nano);
        }
        throw this.localDateTimeError(trace);
    }

    public LocalTime localTime(List<JsonError> trace, OneCharReader in) {
        block12: {
            int nano;
            int second;
            int minute;
            int hour;
            block15: {
                block18: {
                    int pos;
                    int i;
                    char[] cs;
                    block17: {
                        block16: {
                            block14: {
                                block13: {
                                    char c = in.nextNonWhitespace();
                                    if (c != '\"') break block12;
                                    cs = charArrays.get();
                                    i = 0;
                                    while ((c = in.readChar()) != '\"') {
                                        if (c == '\\') {
                                            c = this.nextEscaped(trace, in);
                                        }
                                        cs[i] = c;
                                        ++i;
                                    }
                                    pos = 0;
                                    hour = 0;
                                    minute = 0;
                                    if (pos + 4 >= i) break block13;
                                    char ch0 = cs[pos];
                                    char ch1 = cs[pos + 1];
                                    char ch2 = cs[pos + 2];
                                    char ch3 = cs[pos + 3];
                                    char ch4 = cs[pos + 4];
                                    pos += 5;
                                    hour = ch0 * 10 + ch1 - 528;
                                    minute = ch3 * 10 + ch4 - 528;
                                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == ':' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch3 <= '5' && hour <= 23) break block14;
                                }
                                throw this.localTimeError(trace);
                            }
                            second = 0;
                            nano = 0;
                            if (pos >= i) break block15;
                            if (cs[pos] != ':' || ++pos + 1 >= i) break block16;
                            char ch0 = cs[pos];
                            char ch1 = cs[pos + 1];
                            pos += 2;
                            second = ch0 * 10 + ch1 - 528;
                            if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block17;
                        }
                        throw this.localTimeError(trace);
                    }
                    if (pos >= i) break block15;
                    if (cs[pos] != '.') break block18;
                    ++pos;
                    int nanoDigitWeight = 100000000;
                    int ch = 48;
                    while (pos < i && (ch = cs[pos]) >= 48 && ch <= 57 && nanoDigitWeight != 0) {
                        nano += (ch - 48) * nanoDigitWeight;
                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                        ++pos;
                    }
                    if (pos == i) break block15;
                }
                throw this.localTimeError(trace);
            }
            return LocalTime.of(hour, minute, second, nano);
        }
        throw this.localTimeError(trace);
    }

    public MonthDay monthDay(List<JsonError> trace, OneCharReader in) {
        block5: {
            int day;
            int month;
            block7: {
                block6: {
                    char c = in.nextNonWhitespace();
                    if (c != '\"') break block5;
                    char[] cs = charArrays.get();
                    int i = 0;
                    while ((c = in.readChar()) != '\"') {
                        if (c == '\\') {
                            c = this.nextEscaped(trace, in);
                        }
                        cs[i] = c;
                        ++i;
                    }
                    month = 0;
                    day = 0;
                    if (i != 7) break block6;
                    char ch0 = cs[0];
                    char ch1 = cs[1];
                    char ch2 = cs[2];
                    char ch3 = cs[3];
                    char ch4 = cs[4];
                    char ch5 = cs[5];
                    char ch6 = cs[6];
                    month = ch2 * 10 + ch3 - 528;
                    day = ch5 * 10 + ch6 - 528;
                    if (ch0 == '-' && ch1 == '-' && ch2 >= '0' && ch2 <= '9' && ch3 >= '0' && ch3 <= '9' && ch4 == '-' && ch5 >= '0' && ch5 <= '9' && ch6 >= '0' && ch6 <= '9' && month >= 1 && month <= 12 && day != 0 && (day <= 28 || day <= this.maxDayForMonth(month))) break block7;
                }
                throw this.monthDayError(trace);
            }
            return MonthDay.of(month, day);
        }
        throw this.monthDayError(trace);
    }

    public OffsetDateTime offsetDateTime(List<JsonError> trace, OneCharReader in) {
        block38: {
            ZoneOffset zoneOffset;
            int nano;
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            int pos;
            int i;
            block49: {
                int offsetTotal;
                boolean offsetNeg;
                ZoneOffset zoneOffset2;
                block52: {
                    block55: {
                        char[] cs;
                        block54: {
                            block53: {
                                block51: {
                                    block50: {
                                        boolean bl;
                                        char ch;
                                        block48: {
                                            block45: {
                                                block47: {
                                                    block46: {
                                                        block44: {
                                                            block43: {
                                                                block42: {
                                                                    block39: {
                                                                        block41: {
                                                                            boolean yearNeg;
                                                                            boolean bl2;
                                                                            char ch4;
                                                                            char ch3;
                                                                            char ch2;
                                                                            char ch1;
                                                                            char ch0;
                                                                            block40: {
                                                                                char c = in.nextNonWhitespace();
                                                                                if (c != '\"') break block38;
                                                                                cs = charArrays.get();
                                                                                i = 0;
                                                                                while ((c = in.readChar()) != '\"') {
                                                                                    if (c == '\\') {
                                                                                        c = this.nextEscaped(trace, in);
                                                                                    }
                                                                                    cs[i] = c;
                                                                                    ++i;
                                                                                }
                                                                                pos = 0;
                                                                                year = 0;
                                                                                month = 0;
                                                                                day = 0;
                                                                                if (pos + 4 >= i) break block39;
                                                                                ch0 = cs[pos];
                                                                                ch1 = cs[pos + 1];
                                                                                ch2 = cs[pos + 2];
                                                                                ch3 = cs[pos + 3];
                                                                                ch4 = cs[pos + 4];
                                                                                pos += 5;
                                                                                if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block39;
                                                                                if (ch0 < '0' || ch0 > '9') break block40;
                                                                                year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                                                                                if (ch4 != '-') break block39;
                                                                                break block41;
                                                                            }
                                                                            year = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
                                                                            if (ch0 == '-') {
                                                                                bl2 = true;
                                                                            } else {
                                                                                if (ch0 != '+') {
                                                                                    throw this.offsetDateTimeError(trace);
                                                                                }
                                                                                bl2 = yearNeg = false;
                                                                            }
                                                                            if (ch4 < '0' || ch4 > '9') break block39;
                                                                            int yearDigits = 4;
                                                                            int ch5 = 48;
                                                                            while (pos < i) {
                                                                                ch5 = cs[pos];
                                                                                ++pos;
                                                                                if (ch5 < 48 || ch5 > 57 || yearDigits >= 9) break;
                                                                                year = year * 10 + (ch5 - 48);
                                                                                ++yearDigits;
                                                                            }
                                                                            if (yearNeg && (year = -year) == 0 || ch5 != 45) break block39;
                                                                        }
                                                                        if (pos + 5 >= i) break block39;
                                                                        char ch0 = cs[pos];
                                                                        char ch1 = cs[pos + 1];
                                                                        char ch2 = cs[pos + 2];
                                                                        char ch3 = cs[pos + 3];
                                                                        char ch4 = cs[pos + 4];
                                                                        char ch5 = cs[pos + 5];
                                                                        pos += 6;
                                                                        month = ch0 * 10 + ch1 - 528;
                                                                        day = ch3 * 10 + ch4 - 528;
                                                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == '-' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch5 == 'T' && month >= 1 && month <= 12 && day != 0 && (day <= 28 || day <= this.maxDayForYearMonth(year, month))) break block42;
                                                                    }
                                                                    throw this.offsetDateTimeError(trace);
                                                                }
                                                                hour = 0;
                                                                minute = 0;
                                                                if (pos + 4 >= i) break block43;
                                                                char ch0 = cs[pos];
                                                                char ch1 = cs[pos + 1];
                                                                char ch2 = cs[pos + 2];
                                                                char ch3 = cs[pos + 3];
                                                                char ch4 = cs[pos + 4];
                                                                hour = ch0 * 10 + ch1 - 528;
                                                                minute = ch3 * 10 + ch4 - 528;
                                                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == ':' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch3 <= '5' && hour <= 23 && (pos += 5) < i) break block44;
                                                            }
                                                            throw this.offsetDateTimeError(trace);
                                                        }
                                                        second = 0;
                                                        nano = 0;
                                                        ch = cs[pos];
                                                        ++pos;
                                                        if (ch != ':') break block45;
                                                        if (pos + 1 >= i) break block46;
                                                        char ch0 = cs[pos];
                                                        char ch1 = cs[pos + 1];
                                                        second = ch0 * 10 + ch1 - 528;
                                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5' && (pos += 2) < i) break block47;
                                                    }
                                                    throw this.offsetDateTimeError(trace);
                                                }
                                                ch = cs[pos];
                                                ++pos;
                                                if (ch == '.') {
                                                    int nanoDigitWeight = 100000000;
                                                    while (true) {
                                                        if (pos >= i) {
                                                            throw this.offsetDateTimeError(trace);
                                                        }
                                                        ch = cs[pos];
                                                        ++pos;
                                                        if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                                                        nano += (ch - 48) * nanoDigitWeight;
                                                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                                                    }
                                                }
                                            }
                                            if (ch != 'Z') break block48;
                                            zoneOffset2 = ZoneOffset.UTC;
                                            break block49;
                                        }
                                        if (ch == '-') {
                                            bl = true;
                                        } else {
                                            if (ch != '+') {
                                                throw this.offsetDateTimeError(trace);
                                            }
                                            bl = false;
                                        }
                                        offsetNeg = bl;
                                        offsetTotal = 0;
                                        if (pos + 1 >= i) break block50;
                                        char ch0 = cs[pos];
                                        char ch1 = cs[pos + 1];
                                        pos += 2;
                                        offsetTotal = (ch0 * 10 + ch1 - 528) * 3600;
                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9') break block51;
                                    }
                                    throw this.offsetDateTimeError(trace);
                                }
                                if (pos >= i) break block52;
                                if (cs[pos] != ':' || ++pos + 1 >= i) break block53;
                                char ch0 = cs[pos];
                                char ch1 = cs[pos + 1];
                                pos += 2;
                                offsetTotal += (ch0 * 10 + ch1 - 528) * 60;
                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block54;
                            }
                            throw this.offsetDateTimeError(trace);
                        }
                        if (pos >= i) break block52;
                        if (cs[pos] != ':' || ++pos + 1 >= i) break block55;
                        char ch0 = cs[pos];
                        char ch1 = cs[pos + 1];
                        pos += 2;
                        offsetTotal += ch0 * 10 + ch1 - 528;
                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block52;
                    }
                    throw this.offsetDateTimeError(trace);
                }
                if (offsetTotal > 64800) {
                    throw this.offsetDateTimeError(trace);
                }
                zoneOffset2 = zoneOffset = this.toZoneOffset(offsetNeg, offsetTotal);
            }
            if (pos == i) {
                return OffsetDateTime.of(year, month, day, hour, minute, second, nano, zoneOffset);
            }
        }
        throw this.offsetDateTimeError(trace);
    }

    public OffsetTime offsetTime(List<JsonError> trace, OneCharReader in) {
        block30: {
            ZoneOffset zoneOffset;
            int nano;
            int second;
            int minute;
            int hour;
            int pos;
            int i;
            block37: {
                int offsetTotal;
                boolean offsetNeg;
                ZoneOffset zoneOffset2;
                block40: {
                    block43: {
                        char[] cs;
                        block42: {
                            block41: {
                                block39: {
                                    block38: {
                                        boolean bl;
                                        char ch;
                                        block36: {
                                            block33: {
                                                block35: {
                                                    block34: {
                                                        block32: {
                                                            block31: {
                                                                char c = in.nextNonWhitespace();
                                                                if (c != '\"') break block30;
                                                                cs = charArrays.get();
                                                                i = 0;
                                                                while ((c = in.readChar()) != '\"') {
                                                                    if (c == '\\') {
                                                                        c = this.nextEscaped(trace, in);
                                                                    }
                                                                    cs[i] = c;
                                                                    ++i;
                                                                }
                                                                pos = 0;
                                                                hour = 0;
                                                                minute = 0;
                                                                if (pos + 4 >= i) break block31;
                                                                char ch0 = cs[pos];
                                                                char ch1 = cs[pos + 1];
                                                                char ch2 = cs[pos + 2];
                                                                char ch3 = cs[pos + 3];
                                                                char ch4 = cs[pos + 4];
                                                                hour = ch0 * 10 + ch1 - 528;
                                                                minute = ch3 * 10 + ch4 - 528;
                                                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == ':' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch3 <= '5' && hour <= 23 && (pos += 5) < i) break block32;
                                                            }
                                                            throw this.offsetTimeError(trace);
                                                        }
                                                        second = 0;
                                                        nano = 0;
                                                        ch = cs[pos];
                                                        ++pos;
                                                        if (ch != ':') break block33;
                                                        if (pos + 1 >= i) break block34;
                                                        char ch0 = cs[pos];
                                                        char ch1 = cs[pos + 1];
                                                        second = ch0 * 10 + ch1 - 528;
                                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5' && (pos += 2) < i) break block35;
                                                    }
                                                    throw this.offsetTimeError(trace);
                                                }
                                                ch = cs[pos];
                                                ++pos;
                                                if (ch == '.') {
                                                    int nanoDigitWeight = 100000000;
                                                    while (true) {
                                                        if (pos >= i) {
                                                            throw this.offsetTimeError(trace);
                                                        }
                                                        ch = cs[pos];
                                                        ++pos;
                                                        if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                                                        nano += (ch - 48) * nanoDigitWeight;
                                                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                                                    }
                                                }
                                            }
                                            if (ch != 'Z') break block36;
                                            zoneOffset2 = ZoneOffset.UTC;
                                            break block37;
                                        }
                                        if (ch == '-') {
                                            bl = true;
                                        } else {
                                            if (ch != '+') {
                                                throw this.offsetTimeError(trace);
                                            }
                                            bl = false;
                                        }
                                        offsetNeg = bl;
                                        offsetTotal = 0;
                                        if (pos + 1 >= i) break block38;
                                        char ch0 = cs[pos];
                                        char ch1 = cs[pos + 1];
                                        pos += 2;
                                        offsetTotal = (ch0 * 10 + ch1 - 528) * 3600;
                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9') break block39;
                                    }
                                    throw this.offsetTimeError(trace);
                                }
                                if (pos >= i) break block40;
                                if (cs[pos] != ':' || ++pos + 1 >= i) break block41;
                                char ch0 = cs[pos];
                                char ch1 = cs[pos + 1];
                                pos += 2;
                                offsetTotal += (ch0 * 10 + ch1 - 528) * 60;
                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block42;
                            }
                            throw this.offsetTimeError(trace);
                        }
                        if (pos >= i) break block40;
                        if (cs[pos] != ':' || ++pos + 1 >= i) break block43;
                        char ch0 = cs[pos];
                        char ch1 = cs[pos + 1];
                        pos += 2;
                        offsetTotal += ch0 * 10 + ch1 - 528;
                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block40;
                    }
                    throw this.offsetTimeError(trace);
                }
                if (offsetTotal > 64800) {
                    throw this.offsetTimeError(trace);
                }
                zoneOffset2 = zoneOffset = this.toZoneOffset(offsetNeg, offsetTotal);
            }
            if (pos == i) {
                return OffsetTime.of(hour, minute, second, nano, zoneOffset);
            }
        }
        throw this.offsetTimeError(trace);
    }

    public Period period(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == '\"') {
            boolean isNeg;
            char[] cs = charArrays.get();
            int i = 0;
            while ((c = in.readChar()) != '\"') {
                if (c == '\\') {
                    c = this.nextEscaped(trace, in);
                }
                cs[i] = c;
                ++i;
            }
            int pos = 0;
            int state = 0;
            int years = 0;
            int months = 0;
            int days = 0;
            if (pos >= i) {
                throw this.periodError(trace);
            }
            char ch = cs[pos];
            ++pos;
            boolean bl = isNeg = ch == '-';
            if (isNeg) {
                if (pos >= i) {
                    throw this.periodError(trace);
                }
                ch = cs[pos];
                ++pos;
            }
            if (ch != 'P' || pos >= i) {
                throw this.periodError(trace);
            }
            ch = cs[pos];
            ++pos;
            do {
                boolean isNegX;
                if (state == 4 && pos >= i) {
                    throw this.periodError(trace);
                }
                boolean bl2 = isNegX = ch == '-';
                if (isNegX) {
                    if (pos >= i) {
                        throw this.periodError(trace);
                    }
                    ch = cs[pos];
                    ++pos;
                }
                if (ch < '0' || ch > '9') {
                    throw this.periodError(trace);
                }
                int x = 48 - ch;
                while (pos < i && (ch = cs[pos]) >= '0' && ch <= '9') {
                    if (x < -214748364 || (x = x * 10 + (48 - ch)) > 0) {
                        throw this.periodError(trace);
                    }
                    ++pos;
                }
                if (!(isNeg ^ isNegX)) {
                    if (x == Integer.MIN_VALUE) {
                        throw this.periodError(trace);
                    }
                    x = -x;
                }
                if (ch == 'Y' && state <= 0) {
                    years = x;
                    state = 1;
                } else if (ch == 'M' && state <= 1) {
                    months = x;
                    state = 2;
                } else if (ch == 'W' && state <= 2) {
                    if (x < -306783378 || x > 306783378) {
                        throw this.periodError(trace);
                    }
                    days = x * 7;
                    state = 3;
                } else if (ch == 'D') {
                    long ds = (long)x + (long)days;
                    if (ds != (long)((int)ds)) {
                        throw this.periodError(trace);
                    }
                    days = (int)ds;
                    state = 4;
                } else {
                    throw this.periodError(trace);
                }
                if (++pos >= i) break;
                ch = cs[pos];
                ++pos;
            } while (true);
            return Period.of(years, months, days);
        }
        throw this.periodError(trace);
    }

    public Year year(List<JsonError> trace, OneCharReader in) {
        block10: {
            int year;
            block13: {
                block11: {
                    boolean bl;
                    char ch3;
                    char ch2;
                    char ch1;
                    char ch0;
                    int pos;
                    int i;
                    char[] cs;
                    block12: {
                        char c = in.nextNonWhitespace();
                        if (c != '\"') break block10;
                        cs = charArrays.get();
                        i = 0;
                        while ((c = in.readChar()) != '\"') {
                            if (c == '\\') {
                                c = this.nextEscaped(trace, in);
                            }
                            cs[i] = c;
                            ++i;
                        }
                        pos = 0;
                        year = 0;
                        if (pos + 3 >= i) break block11;
                        ch0 = cs[pos];
                        ch1 = cs[pos + 1];
                        ch2 = cs[pos + 2];
                        ch3 = cs[pos + 3];
                        pos += 4;
                        if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block11;
                        if (ch0 < '0' || ch0 > '9') break block12;
                        year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                        if (pos != i) break block11;
                        break block13;
                    }
                    if (ch0 == '-') {
                        bl = true;
                    } else {
                        if (ch0 != '+') {
                            throw this.yearError(trace);
                        }
                        bl = false;
                    }
                    boolean yearNeg = bl;
                    year = ch1 * 100 + ch2 * 10 + ch3 - 5328;
                    int ch = 48;
                    for (int yearDigits = 3; pos < i && (ch = cs[pos]) >= 48 && ch <= 57 && yearDigits < 9; ++yearDigits, ++pos) {
                        year = year * 10 + (ch - 48);
                    }
                    if ((!yearNeg || (year = -year) != 0) && pos == i) break block13;
                }
                throw this.yearError(trace);
            }
            return Year.of(year);
        }
        throw this.yearError(trace);
    }

    public YearMonth yearMonth(List<JsonError> trace, OneCharReader in) {
        block11: {
            int month;
            int year;
            block15: {
                block12: {
                    int pos;
                    int i;
                    char[] cs;
                    block14: {
                        boolean bl;
                        char ch4;
                        char ch3;
                        char ch2;
                        char ch1;
                        char ch0;
                        block13: {
                            char c = in.nextNonWhitespace();
                            if (c != '\"') break block11;
                            cs = charArrays.get();
                            i = 0;
                            while ((c = in.readChar()) != '\"') {
                                if (c == '\\') {
                                    c = this.nextEscaped(trace, in);
                                }
                                cs[i] = c;
                                ++i;
                            }
                            pos = 0;
                            year = 0;
                            month = 0;
                            if (pos + 4 >= i) break block12;
                            ch0 = cs[pos];
                            ch1 = cs[pos + 1];
                            ch2 = cs[pos + 2];
                            ch3 = cs[pos + 3];
                            ch4 = cs[pos + 4];
                            pos += 5;
                            if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block12;
                            if (ch0 < '0' || ch0 > '9') break block13;
                            year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                            if (ch4 != '-') break block12;
                            break block14;
                        }
                        if (ch0 == '-') {
                            bl = true;
                        } else {
                            if (ch0 != '+') {
                                throw this.yearMonthError(trace);
                            }
                            bl = false;
                        }
                        boolean yearNeg = bl;
                        year = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
                        if (ch4 < '0' || ch4 > '9') break block12;
                        int yearDigits = 4;
                        int ch = 48;
                        while (true) {
                            if (pos >= i) {
                                throw this.yearMonthError(trace);
                            }
                            ch = cs[pos];
                            ++pos;
                            if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                            year = year * 10 + (ch - 48);
                            ++yearDigits;
                        }
                        if (yearNeg && (year = -year) == 0 || ch != 45) break block12;
                    }
                    if (pos + 2 != i) break block12;
                    char ch0 = cs[pos];
                    char ch1 = cs[pos + 1];
                    pos += 2;
                    month = ch0 * 10 + ch1 - 528;
                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && month >= 1 && month <= 12) break block15;
                }
                throw this.yearMonthError(trace);
            }
            return YearMonth.of(year, month);
        }
        throw this.yearMonthError(trace);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ZonedDateTime zonedDateTime(List<JsonError> trace, OneCharReader in) {
        block48: {
            block67: {
                block57: {
                    block60: {
                        block66: {
                            block65: {
                                block64: {
                                    block63: {
                                        block62: {
                                            block61: {
                                                block59: {
                                                    block58: {
                                                        block56: {
                                                            block53: {
                                                                block55: {
                                                                    block54: {
                                                                        block52: {
                                                                            block49: {
                                                                                block51: {
                                                                                    block50: {
                                                                                        c = in.nextNonWhitespace();
                                                                                        if (c != '\"') break block48;
                                                                                        cs = Lexer$.charArrays.get();
                                                                                        i = 0;
                                                                                        while ((c = in.readChar()) != '\"') {
                                                                                            if (c == '\\') {
                                                                                                c = this.nextEscaped(trace, in);
                                                                                            }
                                                                                            cs[i] = c;
                                                                                            ++i;
                                                                                        }
                                                                                        pos = 0;
                                                                                        year = 0;
                                                                                        month = 0;
                                                                                        day = 0;
                                                                                        hour = 0;
                                                                                        minute = 0;
                                                                                        if (pos + 4 >= i) break block49;
                                                                                        ch0 = cs[pos];
                                                                                        ch1 = cs[pos + 1];
                                                                                        ch2 = cs[pos + 2];
                                                                                        ch3 = cs[pos + 3];
                                                                                        ch4 = cs[pos + 4];
                                                                                        pos += 5;
                                                                                        if (ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9' || ch3 < '0' || ch3 > '9') break block49;
                                                                                        if (ch0 < '0' || ch0 > '9') break block50;
                                                                                        year = ch0 * 1000 + ch1 * 100 + ch2 * 10 + ch3 - 53328;
                                                                                        if (ch4 != '-') break block49;
                                                                                        break block51;
                                                                                    }
                                                                                    if (ch0 == '-') {
                                                                                        v0 = true;
                                                                                    } else {
                                                                                        if (ch0 != '+') {
                                                                                            throw this.zonedDateTimeError(trace);
                                                                                        }
                                                                                        v0 = false;
                                                                                    }
                                                                                    yearNeg = v0;
                                                                                    year = ch1 * 1000 + ch2 * 100 + ch3 * 10 + ch4 - 53328;
                                                                                    if (ch4 < '0' || ch4 > '9') break block49;
                                                                                    yearDigits = 4;
                                                                                    ch = 48;
                                                                                    while (true) {
                                                                                        if (pos >= i) {
                                                                                            throw this.zonedDateTimeError(trace);
                                                                                        }
                                                                                        ch = cs[pos];
                                                                                        ++pos;
                                                                                        if (ch < 48 || ch > 57 || yearDigits >= 9) break;
                                                                                        year = year * 10 + (ch - 48);
                                                                                        ++yearDigits;
                                                                                    }
                                                                                    if (yearNeg && (year = -year) == 0 || ch != 45) break block49;
                                                                                }
                                                                                if (pos + 5 >= i) break block49;
                                                                                ch0 = cs[pos];
                                                                                ch1 = cs[pos + 1];
                                                                                ch2 = cs[pos + 2];
                                                                                ch3 = cs[pos + 3];
                                                                                ch4 = cs[pos + 4];
                                                                                ch5 = cs[pos + 5];
                                                                                month = ch0 * 10 + ch1 - 528;
                                                                                day = ch3 * 10 + ch4 - 528;
                                                                                if (ch0 < '0' || ch0 > '9' || ch1 < '0' || ch1 > '9' || ch2 != '-' || ch3 < '0' || ch3 > '9' || ch4 < '0' || ch4 > '9' || ch5 != 'T' || month < 1 || month > 12 || day == 0 || day > 28 && day > this.maxDayForYearMonth(year, month) || (pos += 6) + 4 >= i) break block49;
                                                                                ch0 = cs[pos];
                                                                                ch1 = cs[pos + 1];
                                                                                ch2 = cs[pos + 2];
                                                                                ch3 = cs[pos + 3];
                                                                                ch4 = cs[pos + 4];
                                                                                hour = ch0 * 10 + ch1 - 528;
                                                                                minute = ch3 * 10 + ch4 - 528;
                                                                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch2 == ':' && ch3 >= '0' && ch3 <= '9' && ch4 >= '0' && ch4 <= '9' && ch3 <= '5' && hour <= 23 && (pos += 5) < i) break block52;
                                                                            }
                                                                            throw this.zonedDateTimeError(trace);
                                                                        }
                                                                        second = 0;
                                                                        nano = 0;
                                                                        ch = cs[pos];
                                                                        ++pos;
                                                                        if (ch != ':') break block53;
                                                                        if (pos + 1 >= i) break block54;
                                                                        ch0 = cs[pos];
                                                                        ch1 = cs[pos + 1];
                                                                        second = ch0 * 10 + ch1 - 528;
                                                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5' && (pos += 2) < i) break block55;
                                                                    }
                                                                    throw this.zonedDateTimeError(trace);
                                                                }
                                                                ch = cs[pos];
                                                                ++pos;
                                                                if (ch == '.') {
                                                                    nanoDigitWeight = 100000000;
                                                                    while (true) {
                                                                        if (pos >= i) {
                                                                            throw this.zonedDateTimeError(trace);
                                                                        }
                                                                        ch = cs[pos];
                                                                        ++pos;
                                                                        if (ch < '0' || ch > '9' || nanoDigitWeight == 0) break;
                                                                        nano += (ch - 48) * nanoDigitWeight;
                                                                        nanoDigitWeight = (int)((long)nanoDigitWeight * 0xCCCCCCCDL >> 35);
                                                                    }
                                                                }
                                                            }
                                                            localDateTime = LocalDateTime.of(year, month, day, hour, minute, second, nano);
                                                            if (ch != 'Z') break block56;
                                                            if (pos < i) {
                                                                ch = cs[pos];
                                                                if (ch != '[') {
                                                                    throw this.zonedDateTimeError(trace);
                                                                }
                                                                ++pos;
                                                            }
                                                            v1 = ZoneOffset.UTC;
                                                            break block57;
                                                        }
                                                        if (ch == '-') {
                                                            v2 = true;
                                                        } else {
                                                            if (ch != '+') {
                                                                throw this.zonedDateTimeError(trace);
                                                            }
                                                            v2 = false;
                                                        }
                                                        offsetNeg = v2;
                                                        offsetTotal = 0;
                                                        if (pos + 1 >= i) break block58;
                                                        ch0 = cs[pos];
                                                        ch1 = cs[pos + 1];
                                                        pos += 2;
                                                        offsetTotal = (ch0 * 10 + ch1 - 528) * 3600;
                                                        if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9') break block59;
                                                    }
                                                    throw this.zonedDateTimeError(trace);
                                                }
                                                if (pos >= i) break block60;
                                                ch = cs[pos];
                                                ++pos;
                                                if (ch == ':') break block61;
                                                if (ch != '[') {
                                                    throw this.zonedDateTimeError(trace);
                                                }
                                                break block60;
                                            }
                                            if (pos + 1 >= i) break block62;
                                            ch0 = cs[pos];
                                            ch1 = cs[pos + 1];
                                            pos += 2;
                                            offsetTotal += (ch0 * 10 + ch1 - 528) * 60;
                                            if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block63;
                                        }
                                        throw this.zonedDateTimeError(trace);
                                    }
                                    if (pos >= i) break block60;
                                    ch = cs[pos];
                                    ++pos;
                                    if (ch == ':') break block64;
                                    if (ch != '[') {
                                        throw this.zonedDateTimeError(trace);
                                    }
                                    break block60;
                                }
                                if (pos + 1 >= i) break block65;
                                ch0 = cs[pos];
                                ch1 = cs[pos + 1];
                                pos += 2;
                                offsetTotal += ch0 * 10 + ch1 - 528;
                                if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block66;
                            }
                            throw this.zonedDateTimeError(trace);
                        }
                        if (pos < i) {
                            ch = cs[pos];
                            if (ch != '[') {
                                throw this.zonedDateTimeError(trace);
                            }
                            ++pos;
                        }
                    }
                    if (offsetTotal > 64800) {
                        throw this.zonedDateTimeError(trace);
                    }
                    v1 = zoneOffset = this.toZoneOffset(offsetNeg, offsetTotal);
                }
                if (ch != '[') break block67;
                zoneId = null;
                from = pos;
                while (true) {
                    if (pos >= i) {
                        throw this.zonedDateTimeError(trace);
                    }
                    ch = cs[pos];
                    if (ch == ']') break;
                    ++pos;
                }
                key = new String(cs, from, pos - from);
                zoneId = Lexer$.zoneIds.get(key);
                if (zoneId != null) ** GOTO lbl-1000
                try {
                    zoneId = ZoneId.of(key);
                }
                catch (DateTimeException v3) {
                    throw this.zonedDateTimeError(trace);
                }
                if (!(zoneId instanceof ZoneOffset) || ((ZoneOffset)zoneId).getTotalSeconds() % 900 == 0) {
                    v4 /* !! */  = Lexer$.zoneIds.put(key, zoneId);
                } else lbl-1000:
                // 2 sources

                {
                    v4 /* !! */  = BoxedUnit.UNIT;
                }
                if (pos + 1 == i) {
                    return ZonedDateTime.ofInstant(localDateTime, zoneOffset, zoneId);
                }
                break block48;
            }
            if (pos == i) {
                return ZonedDateTime.ofLocal(localDateTime, zoneOffset, null);
            }
        }
        throw this.zonedDateTimeError(trace);
    }

    public ZoneOffset zoneOffset(List<JsonError> trace, OneCharReader in) {
        block20: {
            int offsetTotal;
            boolean offsetNeg;
            int pos;
            int i;
            block24: {
                block27: {
                    char[] cs;
                    block26: {
                        block25: {
                            block23: {
                                block22: {
                                    boolean bl;
                                    char ch;
                                    block21: {
                                        char c = in.nextNonWhitespace();
                                        if (c != '\"') break block20;
                                        cs = charArrays.get();
                                        i = 0;
                                        while ((c = in.readChar()) != '\"') {
                                            if (c == '\\') {
                                                c = this.nextEscaped(trace, in);
                                            }
                                            cs[i] = c;
                                            ++i;
                                        }
                                        pos = 0;
                                        if (pos >= i) {
                                            throw this.zoneOffsetError(trace);
                                        }
                                        ch = cs[pos];
                                        ++pos;
                                        if (ch != 'Z') break block21;
                                        if (pos == i) {
                                            return ZoneOffset.UTC;
                                        }
                                        break block20;
                                    }
                                    if (ch == '-') {
                                        bl = true;
                                    } else {
                                        if (ch != '+') {
                                            throw this.zoneOffsetError(trace);
                                        }
                                        bl = false;
                                    }
                                    offsetNeg = bl;
                                    offsetTotal = 0;
                                    if (pos + 1 >= i) break block22;
                                    char ch0 = cs[pos];
                                    char ch1 = cs[pos + 1];
                                    offsetTotal = (ch0 * 10 + ch1 - 528) * 3600;
                                    pos += 2;
                                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9') break block23;
                                }
                                throw this.zoneOffsetError(trace);
                            }
                            if (pos >= i) break block24;
                            if (cs[pos] != ':' || ++pos + 1 >= i) break block25;
                            char ch0 = cs[pos];
                            char ch1 = cs[pos + 1];
                            pos += 2;
                            offsetTotal += (ch0 * 10 + ch1 - 528) * 60;
                            if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block26;
                        }
                        throw this.zoneOffsetError(trace);
                    }
                    if (pos >= i) break block24;
                    if (cs[pos] != ':' || ++pos + 1 >= i) break block27;
                    char ch0 = cs[pos];
                    char ch1 = cs[pos + 1];
                    pos += 2;
                    offsetTotal += ch0 * 10 + ch1 - 528;
                    if (ch0 >= '0' && ch0 <= '9' && ch1 >= '0' && ch1 <= '9' && ch0 <= '5') break block24;
                }
                throw this.zoneOffsetError(trace);
            }
            if (offsetTotal <= 64800 && pos == i) {
                return this.toZoneOffset(offsetNeg, offsetTotal);
            }
        }
        throw this.zoneOffsetError(trace);
    }

    private ZoneOffset toZoneOffset(boolean offsetNeg, int offsetTotal) {
        int qp = offsetTotal * 37283;
        if ((qp & 0x1FF8000) == 0) {
            ZoneOffset zoneOffset;
            qp >>>= 25;
            if (offsetNeg) {
                qp = -qp;
            }
            if ((zoneOffset = zoneOffsets[qp + 72]) != null) {
                return zoneOffset;
            }
            Lexer$.zoneOffsets[qp + 72] = zoneOffset = ZoneOffset.ofTotalSeconds(offsetNeg ? -offsetTotal : offsetTotal);
            return zoneOffset;
        }
        return ZoneOffset.ofTotalSeconds(offsetNeg ? -offsetTotal : offsetTotal);
    }

    private long sumSeconds(long s1, long s2, List<JsonError> trace) {
        long s = s1 + s2;
        if (((s1 ^ s) & (s2 ^ s)) < 0L) {
            throw this.durationError(trace);
        }
        return s;
    }

    private long epochDayForYear(int year) {
        long cp = (long)year * 1374389535L;
        return (long)year * 365L + (long)((year + 3 >> 2) - (int)(year < 0 ? (cp >> 37) - (cp >> 39) : (cp + 136064563965L >> 37) - (cp + 548381424465L >> 39)));
    }

    private int dayOfYearForYearMonth(int year, int month) {
        return (month * 1002277 - 988622 >> 15) - (month <= 2 ? 0 : (this.isLeap(year) ? 1 : 2));
    }

    private int maxDayForMonth(int month) {
        if (month != 2) {
            return (month >> 3 ^ month & 1) + 30;
        }
        return 29;
    }

    private int maxDayForYearMonth(int year, int month) {
        if (month != 2) {
            return (month >> 3 ^ month & 1) + 30;
        }
        if (this.isLeap(year)) {
            return 29;
        }
        return 28;
    }

    private boolean isLeap(int year) {
        int cc;
        long cp;
        return (year & 3) == 0 && ((((cp = (long)year * 1374389535L) ^ (long)(cc = year >> 31)) & 0x1FC0000000L) != 0L || ((int)(cp >> 37) - cc & 3) == 0);
    }

    private Nothing$ uuidError(List<JsonError> trace) {
        return this.error("expected a UUID", trace);
    }

    private Nothing$ durationError(List<JsonError> trace) {
        return this.error("expected a Duration", trace);
    }

    private Nothing$ instantError(List<JsonError> trace) {
        return this.error("expected an Instant", trace);
    }

    private Nothing$ localDateError(List<JsonError> trace) {
        return this.error("expected a LocalDate", trace);
    }

    private Nothing$ localDateTimeError(List<JsonError> trace) {
        return this.error("expected a LocalDateTime", trace);
    }

    private Nothing$ localTimeError(List<JsonError> trace) {
        return this.error("expected a LocalTime", trace);
    }

    private Nothing$ monthDayError(List<JsonError> trace) {
        return this.error("expected a MonthDay", trace);
    }

    private Nothing$ offsetDateTimeError(List<JsonError> trace) {
        return this.error("expected an OffsetDateTime", trace);
    }

    private Nothing$ offsetTimeError(List<JsonError> trace) {
        return this.error("expected an OffsetTime", trace);
    }

    private Nothing$ periodError(List<JsonError> trace) {
        return this.error("expected a Period", trace);
    }

    private Nothing$ yearError(List<JsonError> trace) {
        return this.error("expected a Year", trace);
    }

    private Nothing$ yearMonthError(List<JsonError> trace) {
        return this.error("expected a YearMonth", trace);
    }

    private Nothing$ zonedDateTimeError(List<JsonError> trace) {
        return this.error("expected a ZonedDateTime", trace);
    }

    private Nothing$ zoneIdError(List<JsonError> trace) {
        return this.error("expected a ZoneId", trace);
    }

    private Nothing$ zoneOffsetError(List<JsonError> trace) {
        return this.error("expected a ZoneOffset", trace);
    }

    public char char(List<JsonError> trace, OneCharReader in) {
        char c;
        block8: {
            block7: {
                c = in.nextNonWhitespace();
                if (c != '\"') {
                    throw this.error("'\"'", c, trace);
                }
                c = in.readChar();
                if (c == '\"') break block7;
                if (c == '\\') {
                    c = this.nextEscaped(trace, in);
                } else if (c < ' ') {
                    throw this.error("invalid control in string", trace);
                }
                if (in.readChar() == '\"') break block8;
            }
            throw this.error("expected single character string", trace);
        }
        return c;
    }

    private char nextEscaped(List<JsonError> trace, OneCharReader in) {
        char c = in.readChar();
        switch (c) {
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                return this.zio$json$internal$Lexer$$nextHex4(trace, in);
            }
        }
        throw this.error(c, trace);
    }

    public char zio$json$internal$Lexer$$nextHex4(List<JsonError> trace, OneCharReader in) {
        int accum = 0;
        for (int i = 0; i < 4; ++i) {
            int c = in.readChar() | 0x20;
            accum = (accum << 4) + c;
            if (48 <= c && c <= 57) {
                accum -= 48;
                continue;
            }
            if (97 <= c && c <= 102) {
                accum -= 87;
                continue;
            }
            throw this.error("invalid charcode in string", trace);
        }
        return (char)accum;
    }

    public DayOfWeek dayOfWeek(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == '\"') {
            long bs = dayOfWeekMatrix.initial();
            int i = 0;
            while ((c = in.readChar()) != '\"') {
                if (c == '\\') {
                    c = this.nextEscaped(trace, in);
                }
                bs = dayOfWeekMatrix.update(bs, i, (char)(c & 0xFFDF));
                ++i;
            }
            int dayOfWeek = dayOfWeekMatrix.first(dayOfWeekMatrix.exact(bs, i)) + 1;
            if (dayOfWeek > 0) {
                return DayOfWeek.of(dayOfWeek);
            }
        }
        throw this.error("expected a DayOfWeek", trace);
    }

    public Month month(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (c == '\"') {
            long bs = monthMatrix.initial();
            int i = 0;
            while ((c = in.readChar()) != '\"') {
                if (c == '\\') {
                    c = this.nextEscaped(trace, in);
                }
                bs = monthMatrix.update(bs, i, (char)(c & 0xFFDF));
                ++i;
            }
            int month = monthMatrix.first(monthMatrix.exact(bs, i)) + 1;
            if (month > 0) {
                return Month.of(month);
            }
        }
        throw this.error("expected a Month", trace);
    }

    public void char(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.nextNonWhitespace();
        if (got != c) {
            throw this.error(new StringBuilder(2).append("'").append(c).append("'").toString(), got, trace);
        }
    }

    public void charOnly(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.readChar();
        if (got != c) {
            throw this.error(new StringBuilder(2).append("'").append(c).append("'").toString(), got, trace);
        }
    }

    private boolean isNumber(char c) {
        char c2 = c;
        switch (c2) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    public void readChars(List<JsonError> trace, OneCharReader in, char[] expect, String errMsg) {
        for (int i = 0; i < expect.length; ++i) {
            if (in.readChar() == expect[i]) continue;
            throw this.error(new StringBuilder(11).append("expected '").append(errMsg).append("'").toString(), trace);
        }
    }

    private Lexer$() {
    }
}

