/*
 * Decompiled with CFR 0.152.
 */
package zio.json.uuid;

import java.util.Arrays;
import java.util.UUID;
import scala.runtime.Nothing$;
import scala.util.control.NoStackTrace;

public final class UUIDParser$ {
    public static final UUIDParser$ MODULE$;
    private static final byte[] hexDigits;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new UUIDParser$();
        byte[] ns = new byte[256];
        Arrays.fill(ns, (byte)-1);
        ns[48] = 0;
        ns[49] = 1;
        ns[50] = 2;
        ns[51] = 3;
        ns[52] = 4;
        ns[53] = 5;
        ns[54] = 6;
        ns[55] = 7;
        ns[56] = 8;
        ns[57] = 9;
        ns[65] = 10;
        ns[66] = 11;
        ns[67] = 12;
        ns[68] = 13;
        ns[69] = 14;
        ns[70] = 15;
        ns[97] = 10;
        ns[98] = 11;
        ns[99] = 12;
        ns[100] = 13;
        ns[101] = 14;
        ns[102] = 15;
        hexDigits = var0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UUID unsafeParse(String input) {
        if (input.length() == 36) {
            char ch1 = input.charAt(8);
            char ch2 = input.charAt(13);
            char ch3 = input.charAt(18);
            char ch4 = input.charAt(23);
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-') {
                int lsb4;
                int lsb3;
                int lsb2;
                int lsb1;
                int msb4;
                int msb3;
                int msb2;
                byte[] ds = hexDigits;
                int msb1 = this.uuidNibble(ds, input, 0);
                if ((msb1 | (msb2 = this.uuidNibble(ds, input, 4)) | (msb3 = this.uuidNibble(ds, input, 9)) | (msb4 = this.uuidNibble(ds, input, 14)) | (lsb1 = this.uuidNibble(ds, input, 19)) | (lsb2 = this.uuidNibble(ds, input, 24)) | (lsb3 = this.uuidNibble(ds, input, 28)) | (lsb4 = this.uuidNibble(ds, input, 32))) < 0) throw this.uuidError();
                return new UUID((long)msb1 << 48 | (long)msb2 << 32 | (long)msb3 << 16 | (long)msb4, (long)lsb1 << 48 | (long)lsb2 << 32 | (long)lsb3 << 16 | (long)lsb4);
            }
        }
        if (input.length() > 36) throw this.uuidError();
        return this.uuidExtended(input);
    }

    private int uuidNibble(byte[] ds, String input, int offset) {
        char ch4;
        char ch3;
        char ch2;
        char ch1 = input.charAt(offset);
        if ((ch1 | (ch2 = input.charAt(offset + 1)) | (ch3 = input.charAt(offset + 2)) | (ch4 = input.charAt(offset + 3))) > 255) {
            return -1;
        }
        return ds[ch1] << 12 | ds[ch2] << 8 | ds[ch3] << 4 | ds[ch4];
    }

    private UUID uuidExtended(String input) {
        int dash1 = input.indexOf(45, 1);
        int dash2 = input.indexOf(45, dash1 + 2);
        int dash3 = input.indexOf(45, dash2 + 2);
        int dash4 = input.indexOf(45, dash3 + 2);
        if (dash4 >= 0) {
            byte[] ds = hexDigits;
            long section1 = this.uuidSection(ds, input, 0, dash1, -4294967296L);
            long section2 = this.uuidSection(ds, input, dash1 + 1, dash2, -65536L);
            long section3 = this.uuidSection(ds, input, dash2 + 1, dash3, -65536L);
            long section4 = this.uuidSection(ds, input, dash3 + 1, dash4, -65536L);
            long section5 = this.uuidSection(ds, input, dash4 + 1, input.length(), -281474976710656L);
            return new UUID(section1 << 32 | section2 << 16 | section3, section4 << 48 | section5);
        }
        throw this.uuidError();
    }

    private long uuidSection(byte[] ds, String input, int from, int to, long mask) {
        if (from < to && from + 16 >= to) {
            long result = 0L;
            for (int i = from; i < to; ++i) {
                char c = input.charAt(i);
                if (c > '\u00ff') {
                    throw this.uuidError();
                }
                result = result << 4 | (long)ds[c];
            }
            if ((result & mask) == 0L) {
                return result;
            }
        }
        throw this.uuidError();
    }

    private Nothing$ uuidError() {
        throw new NoStackTrace(){

            public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }

            public Throwable fillInStackTrace() {
                return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
            }
            {
                NoStackTrace.$init$((NoStackTrace)this);
            }
        };
    }

    private UUIDParser$() {
    }
}

