/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.nio.CharBuffer;
import java.util.Arrays;
import scala.Predef$;
import zio.json.internal.Write;

public final class FastStringWrite
implements Write {
    private char[] chars;
    private int count;

    public FastStringWrite(int initial) {
        Predef$.MODULE$.require(initial >= 8);
        this.chars = new char[initial];
        this.count = 0;
    }

    public void reset() {
        this.count = 0;
    }

    @Override
    public void write(String s) {
        char[] cs;
        int i = this.count;
        int l = s.length();
        if (i + l >= (cs = this.chars).length) {
            this.chars = cs = Arrays.copyOf(cs, Math.max(cs.length << 1, i + l));
        }
        s.getChars(0, l, cs, i);
        this.count = i + l;
    }

    @Override
    public void write(char c) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 1 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = c;
        this.count = i + 1;
    }

    @Override
    public void write(char[] cs, int from, int to) {
        int from_ = this.count;
        int len = to - from;
        char[] cs_ = this.chars;
        if (from_ + len >= cs_.length) {
            this.chars = cs_ = Arrays.copyOf(cs_, Math.max(cs_.length << 1, from_ + len));
        }
        for (int i = 0; i < len; ++i) {
            cs_[from_ + i] = cs[from + i];
        }
        this.count = from_ + len;
    }

    @Override
    public void write(char c1, char c2) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 1 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = c1;
        cs[i + 1] = c2;
        this.count = i + 2;
    }

    @Override
    public void write(char c1, char c2, char c3) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 2 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = c1;
        cs[i + 1] = c2;
        cs[i + 2] = c3;
        this.count = i + 3;
    }

    @Override
    public void write(char c1, char c2, char c3, char c4) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 3 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = c1;
        cs[i + 1] = c2;
        cs[i + 2] = c3;
        cs[i + 3] = c4;
        this.count = i + 4;
    }

    @Override
    public void write(char c1, char c2, char c3, char c4, char c5) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 4 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = c1;
        cs[i + 1] = c2;
        cs[i + 2] = c3;
        cs[i + 3] = c4;
        cs[i + 4] = c5;
        this.count = i + 5;
    }

    @Override
    public void write(short s) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 1 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = (char)(s & 0xFF);
        cs[i + 1] = (char)(s >> 8);
        this.count = i + 2;
    }

    @Override
    public void write(short s1, short s2) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 3 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = (char)(s1 & 0xFF);
        cs[i + 1] = (char)(s1 >> 8);
        cs[i + 2] = (char)(s2 & 0xFF);
        cs[i + 3] = (char)(s2 >> 8);
        this.count = i + 4;
    }

    @Override
    public void write(short s1, short s2, short s3) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 5 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = (char)(s1 & 0xFF);
        cs[i + 1] = (char)(s1 >> 8);
        cs[i + 2] = (char)(s2 & 0xFF);
        cs[i + 3] = (char)(s2 >> 8);
        cs[i + 4] = (char)(s3 & 0xFF);
        cs[i + 5] = (char)(s3 >> 8);
        this.count = i + 6;
    }

    @Override
    public void write(short s1, short s2, short s3, short s4) {
        int i = this.count;
        char[] cs = this.chars;
        if (i + 7 >= cs.length) {
            this.chars = cs = Arrays.copyOf(cs, cs.length << 1);
        }
        cs[i] = (char)(s1 & 0xFF);
        cs[i + 1] = (char)(s1 >> 8);
        cs[i + 2] = (char)(s2 & 0xFF);
        cs[i + 3] = (char)(s2 >> 8);
        cs[i + 4] = (char)(s3 & 0xFF);
        cs[i + 5] = (char)(s3 >> 8);
        cs[i + 6] = (char)(s4 & 0xFF);
        cs[i + 7] = (char)(s4 >> 8);
        this.count = i + 8;
    }

    public CharSequence buffer() {
        return CharBuffer.wrap(this.chars, 0, this.count);
    }

    public String toString() {
        return new String(this.chars, 0, this.count);
    }
}

