/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import scala.Predef$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import zio.json.internal.StringMatrix$;

public final class StringMatrix {
    private final int namesLen;
    private final int width;
    private final long initial;
    private final int[] lengths;
    private final int height;
    private final char[] matrix;
    private final byte[] resolvers;

    public static Tuple2<String, Object>[] $lessinit$greater$default$2() {
        return StringMatrix$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * WARNING - void declaration
     */
    public StringMatrix(String[] names, Tuple2<String, Object>[] aliases) {
        int string;
        void var3_3;
        int string2;
        this.namesLen = names.length;
        this.width = this.namesLen() + aliases.length;
        this.initial = -1L >>> 64 - this.width;
        Predef$.MODULE$.require(this.namesLen() > 0 && this.width <= 64);
        int[] ls = new int[this.width];
        for (string2 = 0; string2 < this.namesLen(); ++string2) {
            int l = names[string2].length();
            if (l == 0) {
                Predef$.MODULE$.require(false);
            }
            ls[string2] = l;
        }
        while (string2 < ls.length) {
            int l = ((String)aliases[string2 - this.namesLen()]._1()).length();
            if (l == 0) {
                Predef$.MODULE$.require(false);
            }
            ls[string2] = l;
            ++string2;
        }
        this.lengths = var3_3;
        this.height = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(this.lengths).max((Ordering)Ordering.Int$.MODULE$));
        int w = this.width;
        char[] m = new char[this.height * w];
        for (int string3 = 0; string3 < w; ++string3) {
            String s = string3 < this.namesLen() ? names[string3] : (String)aliases[string3 - this.namesLen()]._1();
            int len = s.length();
            int base = 0;
            for (int i = 0; i < len; ++i) {
                m[base + string3] = s.charAt(i);
                base += w;
            }
        }
        this.matrix = m;
        byte[] rs = new byte[this.width];
        for (string = 0; string < this.namesLen(); ++string) {
            rs[string] = (byte)string;
        }
        while (string < rs.length) {
            int x = BoxesRunTime.unboxToInt((Object)aliases[string - this.namesLen()]._2());
            if (x < 0 || x > this.namesLen()) {
                Predef$.MODULE$.require(false);
            }
            rs[string] = (byte)x;
            ++string;
        }
        this.resolvers = rs;
    }

    public int namesLen() {
        return this.namesLen;
    }

    public long initial() {
        return this.initial;
    }

    public long update(long bitset, int n, char c) {
        if (n < this.height) {
            int w = this.width;
            char[] m = this.matrix;
            int base = n * w;
            long latest = bitset;
            if (this.initial() == bitset) {
                for (int string = 0; string < w; ++string) {
                    if (m[base + string] == c) continue;
                    latest ^= 1L << string;
                }
            } else {
                long remaining = bitset;
                while (remaining != 0L) {
                    int string = Long.numberOfTrailingZeros(remaining);
                    long bit = 1L << string;
                    remaining ^= bit;
                    if (m[base + string] == c) continue;
                    latest ^= bit;
                }
            }
            return latest;
        }
        return 0L;
    }

    public long exact(long bitset, int length) {
        if (length <= this.height) {
            long remaining = bitset;
            long latest = bitset;
            int[] ls = this.lengths;
            while (remaining != 0L) {
                int string = Long.numberOfTrailingZeros(remaining);
                long bit = 1L << string;
                remaining ^= bit;
                if (ls[string] == length) continue;
                latest ^= bit;
            }
            return latest;
        }
        return 0L;
    }

    public int first(long bitset) {
        if (bitset != 0L) {
            return this.resolvers[Long.numberOfTrailingZeros(bitset)];
        }
        return -1;
    }
}

