/*
 * Decompiled with CFR 0.152.
 */
package zio.json;

import java.io.Serializable;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.json.JsonError;
import zio.json.JsonFieldDecoder;
import zio.json.LowPriorityJsonFieldDecoder;
import zio.json.internal.Lexer$;
import zio.json.uuid.UUIDParser$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JsonFieldDecoder$
implements LowPriorityJsonFieldDecoder,
Serializable {
    private static final JsonFieldDecoder string;
    private static final JsonFieldDecoder int;
    private static final JsonFieldDecoder long;
    private static final JsonFieldDecoder uuid;
    public static final JsonFieldDecoder$ MODULE$;

    private JsonFieldDecoder$() {
    }

    static {
        MODULE$ = new JsonFieldDecoder$();
        string = new JsonFieldDecoder<String>(){

            public String unsafeDecodeField(List trace, String in) {
                return in;
            }
        };
        int = new JsonFieldDecoder<Object>(){

            public int unsafeDecodeField(List trace, String in) {
                int n;
                try {
                    n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(in));
                }
                catch (NumberFormatException numberFormatException) {
                    throw Lexer$.MODULE$.error(new StringBuilder(13).append("Invalid Int: ").append(JsonFieldDecoder$.MODULE$.strip(in, JsonFieldDecoder$.MODULE$.strip$default$2())).toString(), (List<JsonError>)trace);
                }
                return n;
            }
        };
        long = new JsonFieldDecoder<Object>(){

            public long unsafeDecodeField(List trace, String in) {
                long l;
                try {
                    l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(in));
                }
                catch (NumberFormatException numberFormatException) {
                    throw Lexer$.MODULE$.error(new StringBuilder(14).append("Invalid Long: ").append(JsonFieldDecoder$.MODULE$.strip(in, JsonFieldDecoder$.MODULE$.strip$default$2())).toString(), (List<JsonError>)trace);
                }
                return l;
            }
        };
        uuid = new JsonFieldDecoder<UUID>(){

            public UUID unsafeDecodeField(List trace, String in) {
                UUID uUID;
                try {
                    uUID = UUIDParser$.MODULE$.unsafeParse(in);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw Lexer$.MODULE$.error("expected a UUID", (List<JsonError>)trace);
                }
                return uUID;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonFieldDecoder$.class);
    }

    public <A> JsonFieldDecoder<A> apply(JsonFieldDecoder<A> a) {
        return a;
    }

    public JsonFieldDecoder<String> string() {
        return string;
    }

    public JsonFieldDecoder<Object> int() {
        return int;
    }

    public JsonFieldDecoder<Object> long() {
        return long;
    }

    public JsonFieldDecoder<UUID> uuid() {
        return uuid;
    }

    public <A> JsonFieldDecoder<A> mapStringOrFail(Function1<String, Either<String, A>> f) {
        return new JsonFieldDecoder<A>(f){
            private final Function1 f$3;
            {
                this.f$3 = f$6;
            }

            public Object unsafeDecodeField(List trace, String in) {
                Either either = (Either)this.f$3.apply((Object)JsonFieldDecoder$.MODULE$.string().unsafeDecodeField((List<JsonError>)trace, in));
                if (either instanceof Left) {
                    String err = (String)((Left)either).value();
                    throw Lexer$.MODULE$.error(err, (List<JsonError>)trace);
                }
                if (either instanceof Right) {
                    Object value = ((Right)either).value();
                    return value;
                }
                throw new MatchError((Object)either);
            }
        };
    }

    public String strip(String s, int len) {
        if (s.length() <= len) {
            return s;
        }
        return new StringBuilder(3).append(s.substring(0, len)).append("...").toString();
    }

    public int strip$default$2() {
        return 50;
    }
}

