/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.testkit;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Exit;
import zio.Runtime$;
import zio.Schedule;
import zio.Scope;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.kafka.admin.AdminClient;
import zio.kafka.admin.AdminClient$;
import zio.kafka.admin.AdminClientSettings;
import zio.kafka.admin.AdminClientSettings$;
import zio.kafka.consumer.Consumer;
import zio.kafka.consumer.Consumer$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.ConsumerSettings$;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.RebalanceListener$;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.diagnostics.Diagnostics;
import zio.kafka.diagnostics.Diagnostics$;
import zio.kafka.producer.Producer;
import zio.kafka.producer.Producer$;
import zio.kafka.producer.ProducerSettings;
import zio.kafka.producer.ProducerSettings$;
import zio.kafka.producer.TransactionalProducer;
import zio.kafka.producer.TransactionalProducer$;
import zio.kafka.producer.TransactionalProducerSettings;
import zio.kafka.producer.TransactionalProducerSettings$;
import zio.kafka.serde.Deserializer;
import zio.kafka.serde.Deserializer$;
import zio.kafka.serde.Serde$;
import zio.kafka.serde.Serializer;
import zio.kafka.testkit.Kafka;
import zio.package;
import zio.package$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class KafkaTestUtils$ {
    public static final KafkaTestUtils$ MODULE$ = new KafkaTestUtils$();
    private static File trustStoreFile;
    private static File keyStoreFile;
    private static final ZIO<Kafka, Nothing$, ProducerSettings> producerSettings;
    private static final ZIO<Scope, Throwable, Producer> makeProducer;
    private static final ZLayer<Kafka, Throwable, Producer> producer;
    private static final ZIO<Kafka, Nothing$, TransactionalProducerSettings> transactionalProducerSettings;
    private static final ZLayer<Kafka, Throwable, TransactionalProducer> transactionalProducer;
    private static final ZIO<Kafka, Nothing$, AdminClientSettings> adminSettings;
    private static final ZIO<Kafka, Nothing$, AdminClientSettings> sslAdminSettings;
    private static volatile byte bitmap$0;

    static {
        producerSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$1 -> x$1.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.producerSettings(KafkaTestUtils.scala:30)").map((Function1 & Serializable)x$2 -> ProducerSettings$.MODULE$.apply(x$2), (Object)"zio.kafka.testkit.KafkaTestUtils.producerSettings(KafkaTestUtils.scala:31)");
        makeProducer = MODULE$.producerSettings().flatMap((Function1 & Serializable)settings -> Producer$.MODULE$.make(settings), (Object)"zio.kafka.testkit.KafkaTestUtils.makeProducer(KafkaTestUtils.scala:37)");
        producer = ZLayer.ScopedPartiallyApplied$.MODULE$.apply$extension(ZLayer$.MODULE$.scoped(), (Function0 & Serializable)() -> MODULE$.makeProducer(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Producer.class, LightTypeTag$.MODULE$.parse(-517180796, "\u0004\u0000\u0001\u001bzio.kafka.producer.Producer\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.producer(KafkaTestUtils.scala:45)");
        transactionalProducerSettings = MODULE$.transactionalProducerSettings("test-transaction");
        transactionalProducer = MODULE$.transactionalProducer("test-transaction");
        adminSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$9 -> x$9.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.adminSettings(KafkaTestUtils.scala:430)").map((Function1 & Serializable)bootstrapServers -> AdminClientSettings$.MODULE$.apply(bootstrapServers), (Object)"zio.kafka.testkit.KafkaTestUtils.adminSettings(KafkaTestUtils.scala:430)");
        sslAdminSettings = ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$11 -> x$11.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.sslAdminSettings(KafkaTestUtils.scala:451)").map((Function1 & Serializable)bootstrapServers -> AdminClientSettings$.MODULE$.apply(bootstrapServers).withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.protocol"), (Object)"SSL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.location"), (Object)MODULE$.trustStoreFile().getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.password"), (Object)"123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)MODULE$.keyStoreFile().getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.key.password"), (Object)"123456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.2,TLSv1.3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.type"), (Object)"JKS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"JKS")})), (Object)"zio.kafka.testkit.KafkaTestUtils.sslAdminSettings(KafkaTestUtils.scala:452)");
    }

    public ZIO<Kafka, Nothing$, ProducerSettings> producerSettings() {
        return producerSettings;
    }

    public ZIO<Scope, Throwable, Producer> makeProducer() {
        return makeProducer;
    }

    public ZLayer<Kafka, Throwable, Producer> producer() {
        return producer;
    }

    public ZIO<Kafka, Nothing$, TransactionalProducerSettings> transactionalProducerSettings(String transactionalId) {
        return ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$3 -> x$3.bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducerSettings(KafkaTestUtils.scala:60)").map((Function1 & Serializable)x$4 -> TransactionalProducerSettings$.MODULE$.apply(x$4, transactionalId), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducerSettings(KafkaTestUtils.scala:61)");
    }

    public ZIO<Kafka, Nothing$, TransactionalProducerSettings> transactionalProducerSettings() {
        return transactionalProducerSettings;
    }

    public ZIO<Scope, Throwable, TransactionalProducer> makeTransactionalProducer(String transactionalId, Consumer consumer) {
        return this.transactionalProducerSettings(transactionalId).flatMap((Function1 & Serializable)x$5 -> TransactionalProducer$.MODULE$.make(x$5, consumer), (Object)"zio.kafka.testkit.KafkaTestUtils.makeTransactionalProducer(KafkaTestUtils.scala:81)");
    }

    public ZLayer<Kafka, Throwable, TransactionalProducer> transactionalProducer() {
        return transactionalProducer;
    }

    public ZLayer<Kafka, Throwable, TransactionalProducer> transactionalProducer(String transactionalId) {
        return ZLayer.ScopedPartiallyApplied$.MODULE$.apply$extension(ZLayer$.MODULE$.scoped(), (Function0 & Serializable)() -> ZIO.ServiceWithZIOPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWithZIO(), (Function1 & Serializable)x$6 -> MODULE$.makeTransactionalProducer(transactionalId, (Consumer)x$6), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Consumer.class, LightTypeTag$.MODULE$.parse(-1641819519, "\u0004\u0000\u0001\u001bzio.kafka.consumer.Consumer\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducer(KafkaTestUtils.scala:103)"), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(TransactionalProducer.class, LightTypeTag$.MODULE$.parse(2115187678, "\u0004\u0000\u0001(zio.kafka.producer.TransactionalProducer\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalProducer(KafkaTestUtils.scala:102)");
    }

    public ZIO<Object, Throwable, RecordMetadata> produceOne(Producer producer, String topic, String key, String message) {
        return producer.produce(new ProducerRecord(topic, (Object)key, (Object)message), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public ZIO<Object, Throwable, RecordMetadata> produceOne(Producer producer, String topic, int partition, String key, String message) {
        return producer.produce(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)key, (Object)message), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public ZIO<Object, Throwable, Chunk<RecordMetadata>> produceMany(Producer producer, String topic, int partition, Iterable<Tuple2<String, String>> kvs) {
        return producer.produceChunk(Chunk$.MODULE$.fromIterable((Iterable)kvs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), null, (Object)k, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        })), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public ZIO<Object, Throwable, Chunk<RecordMetadata>> produceMany(Producer producer, String topic, Iterable<Tuple2<String, String>> kvs) {
        return producer.produceChunk(Chunk$.MODULE$.fromIterable((Iterable)kvs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new ProducerRecord(topic, (Object)k, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        })), (Serializer)Serde$.MODULE$.string(), (Serializer)Serde$.MODULE$.string());
    }

    public <R> ZStream<R, Throwable, RecordMetadata> scheduledProduce(Producer producer, String topic, Schedule<R, Object, Object> schedule) {
        return ZStream$.MODULE$.fromSchedule((Function0 & Serializable)() -> schedule, (Object)"zio.kafka.testkit.KafkaTestUtils.scheduledProduce(KafkaTestUtils.scala:181)").mapZIO((Function1 & Serializable)i -> KafkaTestUtils$.MODULE$.produceOne(producer, topic, new StringBuilder(3).append("key").append(BoxesRunTime.unboxToLong((Object)i)).toString(), new StringBuilder(3).append("msg").append(BoxesRunTime.unboxToLong((Object)i)).toString()), (Object)"zio.kafka.testkit.KafkaTestUtils.scheduledProduce(KafkaTestUtils.scala:182)");
    }

    public ZIO<Kafka, Nothing$, ConsumerSettings> consumerSettings(String clientId, Option<String> groupId, Option<String> clientInstanceId, boolean allowAutoCreateTopics, Consumer.OffsetRetrieval offsetRetrieval, boolean rebalanceSafeCommits, Duration maxRebalanceDuration, Duration maxPollInterval, int max$u002Epoll$u002Erecords, Duration commitTimeout, Diagnostics<DiagnosticEvent> diagnostics, Map<String, String> properties) {
        return ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)kafka -> {
            ConsumerSettings settings = ConsumerSettings$.MODULE$.apply(kafka.bootstrapServers()).withClientId(clientId).withCloseTimeout(DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(5))).withPollTimeout(DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationInt(100))).withMaxPollInterval(maxPollInterval).withMaxPollRecords(max$u002Epoll$u002Erecords).withCommitTimeout(commitTimeout).withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"session.timeout.ms"), (Object)"3000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"heartbeat.interval.ms"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allow.auto.create.topics"), (Object)Boolean.toString(allowAutoCreateTopics))})).withOffsetRetrieval(offsetRetrieval).withRebalanceSafeCommits(rebalanceSafeCommits).withMaxRebalanceDuration(maxRebalanceDuration).withDiagnostics(diagnostics).withProperties(properties);
            ConsumerSettings withClientInstanceId = (ConsumerSettings)clientInstanceId.fold((Function0 & Serializable)() -> settings, (Function1 & Serializable)groupInstanceId -> settings.withGroupInstanceId(groupInstanceId));
            return (ConsumerSettings)groupId.fold((Function0 & Serializable)() -> withClientInstanceId, (Function1 & Serializable)groupId -> withClientInstanceId.withGroupId(groupId));
        }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(1661891183, "\u0004\u0000\u0001\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumerSettings(KafkaTestUtils.scala:209)");
    }

    public ZIO<Scope, Throwable, Consumer> makeConsumer(String clientId, Option<String> groupId, Option<String> clientInstanceId, Consumer.OffsetRetrieval offsetRetrieval, boolean allowAutoCreateTopics, Diagnostics<DiagnosticEvent> diagnostics, boolean rebalanceSafeCommits, Duration maxRebalanceDuration, Duration commitTimeout, Map<String, String> properties) {
        String x$1 = clientId;
        Option<String> x$2 = groupId;
        Option<String> x$3 = clientInstanceId;
        boolean x$4 = allowAutoCreateTopics;
        Consumer.OffsetRetrieval x$5 = offsetRetrieval;
        boolean x$6 = rebalanceSafeCommits;
        Duration x$7 = maxRebalanceDuration;
        Map<String, String> x$8 = properties;
        Duration x$9 = commitTimeout;
        Diagnostics<DiagnosticEvent> x$10 = diagnostics;
        Duration x$11 = this.consumerSettings$default$8();
        int x$12 = this.consumerSettings$default$9();
        return this.consumerSettings(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$11, x$12, x$9, x$10, x$8).flatMap((Function1 & Serializable)settings -> Consumer$.MODULE$.make(settings), (Object)"zio.kafka.testkit.KafkaTestUtils.makeConsumer(KafkaTestUtils.scala:249)");
    }

    public Option<String> makeConsumer$default$2() {
        return None$.MODULE$;
    }

    public Option<String> makeConsumer$default$3() {
        return None$.MODULE$;
    }

    public Consumer.OffsetRetrieval makeConsumer$default$4() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean makeConsumer$default$5() {
        return true;
    }

    public Diagnostics<DiagnosticEvent> makeConsumer$default$6() {
        return Diagnostics$.MODULE$.NoOp();
    }

    public boolean makeConsumer$default$7() {
        return false;
    }

    public Duration makeConsumer$default$8() {
        return DurationSyntax$.MODULE$.minutes$extension(package$.MODULE$.durationInt(3));
    }

    public Duration makeConsumer$default$9() {
        return ConsumerSettings$.MODULE$.defaultCommitTimeout();
    }

    public Map<String, String> makeConsumer$default$10() {
        return Predef$.MODULE$.Map().empty();
    }

    public ZLayer<ConsumerSettings, Throwable, Consumer> minimalConsumer() {
        return Consumer$.MODULE$.live();
    }

    public ZLayer<Kafka, Throwable, Consumer> consumer(String clientId, Option<String> groupId, Option<String> clientInstanceId, Consumer.OffsetRetrieval offsetRetrieval, boolean allowAutoCreateTopics, Diagnostics<DiagnosticEvent> diagnostics, boolean rebalanceSafeCommits, Duration maxRebalanceDuration, Duration commitTimeout, Map<String, String> properties) {
        return ZLayer.ScopedPartiallyApplied$.MODULE$.apply$extension(ZLayer$.MODULE$.scoped(), (Function0 & Serializable)() -> MODULE$.makeConsumer(clientId, groupId, clientInstanceId, offsetRetrieval, allowAutoCreateTopics, diagnostics, rebalanceSafeCommits, maxRebalanceDuration, commitTimeout, properties), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Consumer.class, LightTypeTag$.MODULE$.parse(-1641819519, "\u0004\u0000\u0001\u001bzio.kafka.consumer.Consumer\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumer(KafkaTestUtils.scala:292)");
    }

    public Option<String> consumerSettings$default$2() {
        return None$.MODULE$;
    }

    public Option<String> consumerSettings$default$3() {
        return None$.MODULE$;
    }

    public boolean consumerSettings$default$4() {
        return true;
    }

    public Consumer.OffsetRetrieval consumerSettings$default$5() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean consumerSettings$default$6() {
        return false;
    }

    public Duration consumerSettings$default$7() {
        return DurationSyntax$.MODULE$.minutes$extension(package$.MODULE$.durationInt(3));
    }

    public Duration consumerSettings$default$8() {
        return DurationSyntax$.MODULE$.minutes$extension(package$.MODULE$.durationInt(5));
    }

    public int consumerSettings$default$9() {
        return 100;
    }

    public Duration consumerSettings$default$10() {
        return ConsumerSettings$.MODULE$.defaultCommitTimeout();
    }

    public Diagnostics<DiagnosticEvent> consumerSettings$default$11() {
        return Diagnostics$.MODULE$.NoOp();
    }

    public Map<String, String> consumerSettings$default$12() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> consumer$default$2() {
        return None$.MODULE$;
    }

    public Option<String> consumer$default$3() {
        return None$.MODULE$;
    }

    public Consumer.OffsetRetrieval consumer$default$4() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean consumer$default$5() {
        return true;
    }

    public Diagnostics<DiagnosticEvent> consumer$default$6() {
        return Diagnostics$.MODULE$.NoOp();
    }

    public boolean consumer$default$7() {
        return false;
    }

    public Duration consumer$default$8() {
        return DurationSyntax$.MODULE$.minutes$extension(package$.MODULE$.durationInt(3));
    }

    public Duration consumer$default$9() {
        return ConsumerSettings$.MODULE$.defaultCommitTimeout();
    }

    public Map<String, String> consumer$default$10() {
        return Predef$.MODULE$.Map().empty();
    }

    public ZIO<Kafka, Nothing$, ConsumerSettings> transactionalConsumerSettings(String groupId, String clientId, Option<String> clientInstanceId, boolean allowAutoCreateTopics, Consumer.OffsetRetrieval offsetRetrieval, boolean rebalanceSafeCommits, Diagnostics<DiagnosticEvent> diagnostics, Map<String, String> properties) {
        String x$1 = clientId;
        Some x$2 = new Some((Object)groupId);
        Option<String> x$3 = clientInstanceId;
        boolean x$4 = allowAutoCreateTopics;
        Consumer.OffsetRetrieval x$5 = offsetRetrieval;
        boolean x$6 = rebalanceSafeCommits;
        Diagnostics<DiagnosticEvent> x$72 = diagnostics;
        Map<String, String> x$8 = properties;
        Duration x$9 = this.consumerSettings$default$7();
        Duration x$10 = this.consumerSettings$default$8();
        int x$11 = this.consumerSettings$default$9();
        Duration x$12 = this.consumerSettings$default$10();
        return this.consumerSettings(x$1, (Option<String>)x$2, x$3, x$4, x$5, x$6, x$9, x$10, x$11, x$12, x$72, x$8).map((Function1 & Serializable)x$7 -> x$7.withReadCommitted(x$7.withReadCommitted$default$1()), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumerSettings(KafkaTestUtils.scala:336)");
    }

    public ZIO<Scope, Throwable, Consumer> makeTransactionalConsumer(String clientId, String groupId, Option<String> clientInstanceId, Consumer.OffsetRetrieval offsetRetrieval, boolean allowAutoCreateTopics, Diagnostics<DiagnosticEvent> diagnostics, boolean rebalanceSafeCommits, Map<String, String> properties, RebalanceListener rebalanceListener) {
        return this.transactionalConsumerSettings(groupId, clientId, clientInstanceId, allowAutoCreateTopics, offsetRetrieval, rebalanceSafeCommits, diagnostics, properties).map((Function1 & Serializable)x$8 -> x$8.withRebalanceListener(rebalanceListener), (Object)"zio.kafka.testkit.KafkaTestUtils.makeTransactionalConsumer(KafkaTestUtils.scala:362)").flatMap((Function1 & Serializable)settings -> Consumer$.MODULE$.make(settings), (Object)"zio.kafka.testkit.KafkaTestUtils.makeTransactionalConsumer(KafkaTestUtils.scala:353)");
    }

    public Option<String> makeTransactionalConsumer$default$3() {
        return None$.MODULE$;
    }

    public Consumer.OffsetRetrieval makeTransactionalConsumer$default$4() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean makeTransactionalConsumer$default$5() {
        return true;
    }

    public Diagnostics<DiagnosticEvent> makeTransactionalConsumer$default$6() {
        return Diagnostics$.MODULE$.NoOp();
    }

    public boolean makeTransactionalConsumer$default$7() {
        return false;
    }

    public Map<String, String> makeTransactionalConsumer$default$8() {
        return Predef$.MODULE$.Map().empty();
    }

    public RebalanceListener makeTransactionalConsumer$default$9() {
        return RebalanceListener$.MODULE$.noop();
    }

    public ZLayer<Kafka, Throwable, Consumer> transactionalConsumer(String clientId, String groupId, Option<String> clientInstanceId, Consumer.OffsetRetrieval offsetRetrieval, boolean allowAutoCreateTopics, Diagnostics<DiagnosticEvent> diagnostics, boolean rebalanceSafeCommits, Map<String, String> properties, RebalanceListener rebalanceListener) {
        return ZLayer.ScopedPartiallyApplied$.MODULE$.apply$extension(ZLayer$.MODULE$.scoped(), (Function0 & Serializable)() -> MODULE$.makeTransactionalConsumer(clientId, groupId, clientInstanceId, offsetRetrieval, allowAutoCreateTopics, diagnostics, rebalanceSafeCommits, properties, rebalanceListener), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Consumer.class, LightTypeTag$.MODULE$.parse(-1641819519, "\u0004\u0000\u0001\u001bzio.kafka.consumer.Consumer\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.transactionalConsumer(KafkaTestUtils.scala:383)");
    }

    public Option<String> transactionalConsumerSettings$default$3() {
        return None$.MODULE$;
    }

    public boolean transactionalConsumerSettings$default$4() {
        return true;
    }

    public Consumer.OffsetRetrieval transactionalConsumerSettings$default$5() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean transactionalConsumerSettings$default$6() {
        return false;
    }

    public Diagnostics<DiagnosticEvent> transactionalConsumerSettings$default$7() {
        return Diagnostics$.MODULE$.NoOp();
    }

    public Map<String, String> transactionalConsumerSettings$default$8() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> transactionalConsumer$default$3() {
        return None$.MODULE$;
    }

    public Consumer.OffsetRetrieval transactionalConsumer$default$4() {
        return new Consumer.OffsetRetrieval$.Auto((Consumer.AutoOffsetStrategy)Consumer.AutoOffsetStrategy$.Earliest$.MODULE$);
    }

    public boolean transactionalConsumer$default$5() {
        return true;
    }

    public Diagnostics<DiagnosticEvent> transactionalConsumer$default$6() {
        return Diagnostics$.MODULE$.NoOp();
    }

    public boolean transactionalConsumer$default$7() {
        return false;
    }

    public Map<String, String> transactionalConsumer$default$8() {
        return Predef$.MODULE$.Map().empty();
    }

    public RebalanceListener transactionalConsumer$default$9() {
        return RebalanceListener$.MODULE$.noop();
    }

    public ZIO<Kafka, Throwable, BoxedUnit> consumeWithStrings(String clientId, Option<String> groupId, Subscription subscription, Function1<ConsumerRecord<String, String>, ZIO<Object, Nothing$, BoxedUnit>> r) {
        return this.consumerSettings(clientId, groupId, (Option<String>)None$.MODULE$, this.consumerSettings$default$4(), this.consumerSettings$default$5(), this.consumerSettings$default$6(), this.consumerSettings$default$7(), this.consumerSettings$default$8(), this.consumerSettings$default$9(), this.consumerSettings$default$10(), this.consumerSettings$default$11(), this.consumerSettings$default$12()).flatMap((Function1 & Serializable)settings -> Consumer$.MODULE$.consumeWith(settings, subscription, (Deserializer)Deserializer$.MODULE$.string(), (Deserializer)Deserializer$.MODULE$.string(), Consumer$.MODULE$.consumeWith$default$5(), r, Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(-85095185, "\u0004\u0000\u0001\tscala.Any\u0001\u0001", "\u0000\u0000\u0000", 30)), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(-85095185, "\u0004\u0000\u0001\tscala.Any\u0001\u0001", "\u0000\u0000\u0000", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.consumeWithStrings(KafkaTestUtils.scala:411)");
    }

    public Option<String> consumeWithStrings$default$2() {
        return None$.MODULE$;
    }

    public ZIO<Kafka, Nothing$, AdminClientSettings> adminSettings() {
        return adminSettings;
    }

    public ZIO<Kafka.Sasl, Nothing$, AdminClientSettings> saslAdminSettings(String username, String password) {
        return ZIO.ServiceWithPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.serviceWith(), (Function1 & Serializable)x$10 -> ((Kafka.Sasl)x$10).value().bootstrapServers(), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(Kafka.class, LightTypeTag$.MODULE$.parse(606355400, "\u0004\u0000\u0001\u001czio.kafka.testkit.Kafka.Sasl\u0001\u0002\u0003\u0000\u0000\u0017zio.kafka.testkit.Kafka\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001czio.kafka.testkit.Kafka.Sasl\u0001\u0002\u0003\u0000\u0000\u0017zio.kafka.testkit.Kafka\u0001\u0001\u0004\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30))), (Object)"zio.kafka.testkit.KafkaTestUtils.saslAdminSettings(KafkaTestUtils.scala:437)").map((Function1 & Serializable)bootstrapServers -> AdminClientSettings$.MODULE$.apply(bootstrapServers).withProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.mechanism"), (Object)"PLAIN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.protocol"), (Object)"SASL_PLAINTEXT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)new StringBuilder(89).append("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"").append(username).append("\" password=\"").append(password).append("\";").toString())})), (Object)"zio.kafka.testkit.KafkaTestUtils.saslAdminSettings(KafkaTestUtils.scala:438)");
    }

    public ZIO<Kafka, Nothing$, AdminClientSettings> sslAdminSettings() {
        return sslAdminSettings;
    }

    public ZIO<Scope, Throwable, AdminClient> makeAdminClient() {
        return this.adminSettings().flatMap((Function1 & Serializable)settings -> AdminClient$.MODULE$.make(settings), (Object)"zio.kafka.testkit.KafkaTestUtils.makeAdminClient(KafkaTestUtils.scala:470)");
    }

    public ZIO<Kafka.Sasl, Throwable, AdminClient> makeSaslAdminClient(String username, String password) {
        return this.saslAdminSettings(username, password).flatMap((Function1 & Serializable)settings -> AdminClient$.MODULE$.make(settings), (Object)"zio.kafka.testkit.KafkaTestUtils.makeSaslAdminClient(KafkaTestUtils.scala:479)");
    }

    public String makeSaslAdminClient$default$1() {
        return "admin";
    }

    public String makeSaslAdminClient$default$2() {
        return "admin-secret";
    }

    public ZIO<Scope, Throwable, AdminClient> makeSslAdminClient() {
        return this.sslAdminSettings().flatMap((Function1 & Serializable)settings -> AdminClient$.MODULE$.make(settings), (Object)"zio.kafka.testkit.KafkaTestUtils.makeSslAdminClient(KafkaTestUtils.scala:485)");
    }

    public ZIO<Kafka, Throwable, BoxedUnit> createCustomTopic(String topic, int partitionCount) {
        return ZIO.ScopedPartiallyApplied$.MODULE$.apply$extension(ZIO$.MODULE$.scoped(), (Function0 & Serializable)() -> MODULE$.makeAdminClient().flatMap((Function1 & Serializable)adminClient -> adminClient.createTopic(new AdminClient.NewTopic(topic, partitionCount, 1, AdminClient.NewTopic$.MODULE$.apply$default$4()), adminClient.createTopic$default$2()), (Object)"zio.kafka.testkit.KafkaTestUtils.createCustomTopic(KafkaTestUtils.scala:499)"), (Object)"zio.kafka.testkit.KafkaTestUtils.createCustomTopic(KafkaTestUtils.scala:497)");
    }

    public int createCustomTopic$default$2() {
        return 1;
    }

    private File readResourceFile(String file, String tmpFileName, String tmpFileSuffix) {
        File file2;
        try {
            Path tmpFile = Files.createTempFile(tmpFileName, tmpFileSuffix, new FileAttribute[0]);
            Files.copy(this.getClass().getClassLoader().getResourceAsStream(file), tmpFile, StandardCopyOption.REPLACE_EXISTING);
            File result = tmpFile.toFile();
            result.deleteOnExit();
            file2 = result;
        }
        catch (Throwable e) {
            Exit exit = (Exit)Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> Runtime$.MODULE$.default().unsafe().run(ZIO$.MODULE$.logErrorCause((Function0 & Serializable)() -> "Failed to read resource file", (Function0 & Serializable)() -> Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), (Object)"zio.kafka.testkit.KafkaTestUtils.readResourceFile.x$13(KafkaTestUtils.scala:514)"), (Object)"zio.kafka.testkit.KafkaTestUtils.readResourceFile.x$13(KafkaTestUtils.scala:514)", u));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            throw e;
        }
        return file2;
    }

    private File trustStoreFile$lzycompute() {
        KafkaTestUtils$ kafkaTestUtils$ = this;
        synchronized (kafkaTestUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                trustStoreFile = this.readResourceFile("truststore/kafka.truststore.jks", "truststore", ".jks");
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return trustStoreFile;
    }

    public File trustStoreFile() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.trustStoreFile$lzycompute();
        }
        return trustStoreFile;
    }

    private File keyStoreFile$lzycompute() {
        KafkaTestUtils$ kafkaTestUtils$ = this;
        synchronized (kafkaTestUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                keyStoreFile = this.readResourceFile("keystore/kafka.keystore.jks", "keystore", ".jks");
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return keyStoreFile;
    }

    public File keyStoreFile() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.keyStoreFile$lzycompute();
        }
        return keyStoreFile;
    }

    private KafkaTestUtils$() {
    }
}

