/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.IsSubtypeOfOutput$;
import zio.LogAnnotation;
import zio.Promise;
import zio.Queue;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.PartitionStreamControl$;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!B\f\u0019\u0005a\u0001\u0003\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011A\u0015\t\u0011U\u0002!\u0011!Q\u0001\n)B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!A!\u0002\u0013y\u0007\"B;\u0001\t\u00131\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0007Aq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u001b\u0002A\u0011AA%\u0011%\ty\u0005\u0001b\u0001\n\u0003\t\t\u0006\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA*\u000f!\tY\u0006\u0007E\u00011\u0005ucaB\f\u0019\u0011\u0003A\u0012q\f\u0005\u0007kR!\t!!\u0019\t\u000f\u0005\rD\u0003\"\u0001\u0002f\t1\u0002+\u0019:uSRLwN\\*ue\u0016\fWnQ8oiJ|GN\u0003\u0002\u001a5\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001c9\u0005A1m\u001c8tk6,'O\u0003\u0002\u001e=\u0005)1.\u00194lC*\tq$A\u0002{S>\u001c\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\t!\bo\u0001\u0001\u0016\u0003)\u0002\"aK\u001a\u000e\u00031R!!\f\u0018\u0002\r\r|W.\\8o\u0015\tirF\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b-\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003\u0019\u0019HO]3b[B)\u0001H\u000f\u001f@\u00176\t\u0011H\u0003\u00027=%\u00111(\u000f\u0002\b5N#(/Z1n!\t\u0011S(\u0003\u0002?G\t\u0019\u0011I\\=\u0011\u0005\u0001CeBA!G\u001d\t\u0011U)D\u0001D\u0015\t!\u0005&\u0001\u0004=e>|GOP\u0005\u0002I%\u0011qiI\u0001\ba\u0006\u001c7.Y4f\u0013\tI%JA\u0005UQJ|w/\u00192mK*\u0011qi\t\t\u0003\u0019^s!!T+\u000f\u00059#fBA(T\u001d\t\u0001&K\u0004\u0002C#&\tq$\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI!A\u0016\r\u0002\u000fI+h\u000e\\8pa&\u0011\u0001,\u0017\u0002\u001b\u0005f$X-\u0011:sCf\u001cu.\\7jiR\f'\r\\3SK\u000e|'\u000f\u001a\u0006\u0003-b\t\u0011\u0002Z1uCF+X-^3\u0011\u0007qkv,D\u0001\u001f\u0013\tqfDA\u0003Rk\u0016,X\r\u0005\u00039A~Z\u0015BA1:\u0005\u0011!\u0016m[3\u0002'%tG/\u001a:skB$\u0018n\u001c8Qe>l\u0017n]3\u0011\tq#wHZ\u0005\u0003Kz\u0011q\u0001\u0015:p[&\u001cX\r\u0005\u0002#O&\u0011\u0001n\t\u0002\u0005+:LG/\u0001\td_6\u0004H.\u001a;fIB\u0013x.\\5tKB!A\fZ6g!\t\u0011C.\u0003\u0002nG\t9aj\u001c;iS:<\u0017\u0001D9vKV,7+\u001b>f%\u00164\u0007c\u0001/qe&\u0011\u0011O\b\u0002\u0004%\u00164\u0007C\u0001\u0012t\u0013\t!8EA\u0002J]R\fa\u0001P5oSRtDcB<zundXP \t\u0003q\u0002i\u0011\u0001\u0007\u0005\u0006O!\u0001\rA\u000b\u0005\u0006m!\u0001\ra\u000e\u0005\u00065\"\u0001\ra\u0017\u0005\u0006E\"\u0001\ra\u0019\u0005\u0006S\"\u0001\rA\u001b\u0005\u0006]\"\u0001\ra\\\u0001\fY><\u0017I\u001c8pi\u0006$X-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001d\ra\u0016qA\u0005\u0004\u0003\u0013q\u0012a\u0001.J\u001f&!\u0011QBA\b\u0005-aunZ!o]>$\u0018\r^3\u000b\u0007\u0005%a$\u0001\u0007m_\u001e\feN\\8uCR,\u0007%\u0001\u0007pM\u001a,'OU3d_J$7\u000f\u0006\u0003\u0002\u0018\u0005u\u0001C\u0002/\u0002\u001aqZg-C\u0002\u0002\u001cy\u00111AW%P\u0011\u001d\tyb\u0003a\u0001\u0003C\tA\u0001Z1uCB!A,a\tL\u0013\r\t)C\b\u0002\u0006\u0007\",hn[\u0001\ncV,W/Z*ju\u0016,\"!a\u000b\u0011\u000b\u00055\u0012\u0011\u0007:\u000f\u0007A\u000by#\u0003\u0002H=%!\u00111GA\u001b\u0005\r)\u0016j\u0014\u0006\u0003\u000fz\tA\u0001\\8tiR\u0011\u00111\b\t\u0007\u0003[\t\t$!\u0010\u0011\u0007\t\ny$C\u0002\u0002B\r\u0012qAQ8pY\u0016\fg.A\u0002f]\u0012$\"!a\u0006\u0002\u0017%\u001c8i\\7qY\u0016$X\rZ\u000b\u0003\u0003\u0017\u0002r\u0001XA\ry-\fi$A\u0005jgJ+hN\\5oO\u0006AA\u000f]*ue\u0016\fW.\u0006\u0002\u0002TA)!%!\u0016+o%\u0019\u0011qK\u0012\u0003\rQ+\b\u000f\\33\u0003%!\bo\u0015;sK\u0006l\u0007%\u0001\fQCJ$\u0018\u000e^5p]N#(/Z1n\u0007>tGO]8m!\tAHc\u0005\u0002\u0015CQ\u0011\u0011QL\u0001\u0013]\u0016<\b+\u0019:uSRLwN\\*ue\u0016\fW\u000e\u0006\u0005\u0002h\u0005%\u00141NA<!\u0015\ti#!\rx\u0011\u00159c\u00031\u0001+\u0011\u001d\tiG\u0006a\u0001\u0003_\nAbY8n[\u0006tG-U;fk\u0016\u0004B\u0001X/\u0002rA\u0019\u00010a\u001d\n\u0007\u0005U\u0004D\u0001\bSk:dwn\u001c9D_6l\u0017M\u001c3\t\u000f\u0005ed\u00031\u0001\u0002|\u0005YA-[1h]>\u001cH/[2t!\u0011\ti(!!\u000e\u0005\u0005}$bAA=5%!\u00111QA@\u0005-!\u0015.Y4o_N$\u0018nY:")
public final class PartitionStreamControl {
    private final TopicPartition tp;
    private final Queue<Take<Throwable, CommittableRecord<byte[], byte[]>>> dataQueue;
    private final Promise<Throwable, BoxedUnit> interruptionPromise;
    private final Promise<Nothing$, BoxedUnit> completedPromise;
    private final Ref<Object> queueSizeRef;
    private final ZIO.LogAnnotate logAnnotate;
    private final Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>> tpStream;

    public static ZIO<Object, Nothing$, PartitionStreamControl> newPartitionStream(TopicPartition topicPartition, Queue<RunloopCommand> queue, Diagnostics diagnostics) {
        return PartitionStreamControl$.MODULE$.newPartitionStream(topicPartition, queue, diagnostics);
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private ZIO.LogAnnotate logAnnotate() {
        return this.logAnnotate;
    }

    public ZIO<Object, Nothing$, BoxedUnit> offerRecords(Chunk<CommittableRecord<byte[], byte[]>> data) {
        return this.queueSizeRef.update((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> x$1 + data.size(), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)").$times$greater((Function0 & Serializable & scala.Serializable)() -> $this.dataQueue.offer((Object)new Take(Take$.MODULE$.chunk(data)), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)").unit((Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)"), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)");
    }

    public ZIO<Object, Nothing$, Object> queueSize() {
        return this.queueSizeRef.get((Object)"zio.kafka.consumer.internal.PartitionStreamControl.queueSize(PartitionStreamControl.scala:27)");
    }

    public ZIO<Object, Nothing$, Object> lost() {
        return this.interruptionPromise.fail((Object)new RuntimeException(new StringBuilder(19).append("Partition ").append(this.tp().toString()).append(" was lost").toString()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.lost(PartitionStreamControl.scala:31)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> end() {
        return this.logAnnotate().apply(ZIO$.MODULE$.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Partition ").append(this.tp().toString()).append(" ending").toString(), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:36)").$times$greater((Function0 & Serializable & scala.Serializable)() -> $this.dataQueue.offer((Object)new Take(Take$.MODULE$.end()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:37)").unit((Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:37)"), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:36)"), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:35)");
    }

    public ZIO<Object, Nothing$, Object> isCompleted() {
        return this.completedPromise.isDone((Object)"zio.kafka.consumer.internal.PartitionStreamControl.isCompleted(PartitionStreamControl.scala:42)");
    }

    public ZIO<Object, Nothing$, Object> isRunning() {
        return this.isCompleted().negate(IsSubtypeOfOutput$.MODULE$.impl(Predef$.MODULE$.$conforms()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.isRunning(PartitionStreamControl.scala:46)");
    }

    public Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>> tpStream() {
        return this.tpStream;
    }

    public PartitionStreamControl(TopicPartition tp, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>> stream, Queue<Take<Throwable, CommittableRecord<byte[], byte[]>>> dataQueue, Promise<Throwable, BoxedUnit> interruptionPromise, Promise<Nothing$, BoxedUnit> completedPromise, Ref<Object> queueSizeRef) {
        this.tp = tp;
        this.dataQueue = dataQueue;
        this.interruptionPromise = interruptionPromise;
        this.completedPromise = completedPromise;
        this.queueSizeRef = queueSizeRef;
        this.logAnnotate = ZIO$.MODULE$.logAnnotate((Function0 & Serializable & scala.Serializable)() -> new LogAnnotation("topic", this.tp().topic()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogAnnotation[]{new LogAnnotation("partition", Integer.toString(tp.partition()))}));
        this.tpStream = new Tuple2((Object)tp, stream);
    }
}

