/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Exit$;
import zio.IsSubtypeOfError$;
import zio.IsSubtypeOfOutput$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Ref;
import zio.Runtime;
import zio.Scope;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.Consumer$CommitTimeout$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.Committer$CommitOffsets$;
import zio.kafka.consumer.internal.ConsumerMetrics;
import zio.kafka.consumer.internal.LiveCommitter$;
import zio.kafka.diagnostics.Diagnostics;
import zio.package$;

@ScalaSignature(bytes="\u0006\u0005\r-c!B\u001d;\u0005q\u0012\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011I\u0004!\u0011!Q\u0001\nMD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q!q\u0011\u0001\u0003\u0002\u0003\u0006IA!#\t\u0015\tu\u0005A!A!\u0002\u0013\u0011y\n\u0003\u0004d\u0001\u0011\u0005!1\u0017\u0005\n\u0005\u0007\u0004!\u0019!C!\u0005\u000bD\u0001Ba5\u0001A\u0003%!q\u0019\u0005\n\u0005+\u0004!\u0019!C!\u0005\u000bD\u0001Ba6\u0001A\u0003%!q\u0019\u0005\b\u00053\u0004A\u0011\tBn\u0011%\u0011\t\u0010AI\u0001\n\u0003\u0011\u0019\u0010C\u0004\u0003x\u0002!IA!?\t\u000f\t}\b\u0001\"\u0003\u0004\u0002!911\u0004\u0001\u0005\n\ru\u0001bBB\u0015\u0001\u0011\u000531\u0006\u0005\b\u0007_\u0001A\u0011IB\u0016\u0011\u001d\u0019\t\u0004\u0001C!\u0007gAqaa\u000e\u0001\t\u0003\u001aI\u0004C\u0004\u0004<\u0001!\te!\u0010\t\u000f\r%\u0003\u0001\"\u0011\u00044\u001d1\u0001M\u000fE\u0001u\u00054a!\u000f\u001e\t\u0002i\u0012\u0007\"B2\u001a\t\u0003!\u0007\"B3\u001a\t\u00031gaBA\u00133\tS\u0014q\u0005\u0005\u000b\u0003\u007fa\"Q3A\u0005\u0002\u0005\u0005\u0003BCA(9\tE\t\u0015!\u0003\u0002D!Q\u0011\u0011\u000b\u000f\u0003\u0016\u0004%\t!a\u0015\t\u0015\u0005%ED!E!\u0002\u0013\t)\u0006\u0003\u0006\u0002\fr\u0011)\u001a!C\u0001\u0003\u001bC!\"a'\u001d\u0005#\u0005\u000b\u0011BAH\u0011\u0019\u0019G\u0004\"\u0001\u0002\u001e\"9\u0011\u0011\u0016\u000f\u0005\u0002\u0005-\u0006\"CA_9\u0005\u0005I\u0011AA`\u0011%\t9\rHI\u0001\n\u0003\tI\rC\u0005\u0002`r\t\n\u0011\"\u0001\u0002b\"I\u0011Q\u001d\u000f\u0012\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003Wd\u0012\u0011!C!\u0003[D\u0011\"a@\u001d\u0003\u0003%\tA!\u0001\t\u0013\t%A$!A\u0005\u0002\t-\u0001\"\u0003B\f9\u0005\u0005I\u0011\tB\r\u0011%\u00119\u0003HA\u0001\n\u0003\u0011I\u0003C\u0005\u0003.q\t\t\u0011\"\u0011\u00030!I!1\u0007\u000f\u0002\u0002\u0013\u0005#Q\u0007\u0005\n\u0005oa\u0012\u0011!C!\u0005sA\u0011Ba\u000f\u001d\u0003\u0003%\tE!\u0010\b\u0015\t\u0005\u0013$!A\t\u0002i\u0012\u0019E\u0002\u0006\u0002&e\t\t\u0011#\u0001;\u0005\u000bBaaY\u001a\u0005\u0002\tu\u0003\"\u0003B\u001cg\u0005\u0005IQ\tB\u001d\u0011%\u0011yfMA\u0001\n\u0003\u0013\t\u0007C\u0005\u0003jM\n\t\u0011\"!\u0003l!I!QP\u001a\u0002\u0002\u0013%!q\u0010\u0002\u000e\u0019&4XmQ8n[&$H/\u001a:\u000b\u0005mb\u0014\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005ur\u0014\u0001C2p]N,X.\u001a:\u000b\u0005}\u0002\u0015!B6bM.\f'\"A!\u0002\u0007iLwnE\u0002\u0001\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0007C\u0001&L\u001b\u0005Q\u0014B\u0001';\u0005%\u0019u.\\7jiR,'/A\u0006d_6l\u0017\u000e^)vKV,7\u0001\u0001\t\u0004!F\u001bV\"\u0001!\n\u0005I\u0003%!B)vKV,\u0007C\u0001+\u001d\u001d\t)\u0006D\u0004\u0002W?:\u0011qK\u0018\b\u00031vs!!\u0017/\u000e\u0003iS!a\u0017(\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015BA A\u0013\tid(\u0003\u0002<y\u0005iA*\u001b<f\u0007>lW.\u001b;uKJ\u0004\"AS\r\u0014\u0005e\u0019\u0015A\u0002\u001fj]&$h\bF\u0001b\u0003\u0011i\u0017m[3\u0015\u000f\u001d\f80!\u0003\u0002\u0014A)\u0001\u000b\u001b6na&\u0011\u0011\u000e\u0011\u0002\u00045&{\u0005C\u0001)l\u0013\ta\u0007IA\u0003TG>\u0004X\r\u0005\u0002E]&\u0011q.\u0012\u0002\b\u001d>$\b.\u001b8h!\tQ\u0005\u0001C\u0003s7\u0001\u00071/A\u0007d_6l\u0017\u000e\u001e+j[\u0016|W\u000f\u001e\t\u0003i^t!\u0001W;\n\u0005Y\u0004\u0015a\u00029bG.\fw-Z\u0005\u0003qf\u0014\u0001\u0002R;sCRLwN\\\u0005\u0003u\u0002\u0013a\u0002R;sCRLwN\\'pIVdW\rC\u0003}7\u0001\u0007Q0A\u0006eS\u0006<gn\\:uS\u000e\u001c\bc\u0001@\u0002\u00049\u0011ak`\u0005\u0004\u0003\u0003a\u0014\u0001C\"p]N,X.\u001a:\n\t\u0005\u0015\u0011q\u0001\u0002\u0014\u0007>t7/^7fe\u0012K\u0017m\u001a8pgRL7m\u001d\u0006\u0004\u0003\u0003a\u0004bBA\u00067\u0001\u0007\u0011QB\u0001\u0010G>t7/^7fe6+GO]5dgB\u0019!*a\u0004\n\u0007\u0005E!HA\bD_:\u001cX/\\3s\u001b\u0016$(/[2t\u0011\u001d\t)b\u0007a\u0001\u0003/\t\u0011c\u001c8D_6l\u0017\u000e^!wC&d\u0017M\u00197f!\u0015!\u0018\u0011DA\u0010\u0013\u0011\tY\"!\b\u0003\u0007UKuJ\u0003\u0002w\u0001B\u0019A)!\t\n\u0007\u0005\rRI\u0001\u0003V]&$(AB\"p[6LGo\u0005\u0004\u001d\u0007\u0006%\u0012q\u0006\t\u0004\t\u0006-\u0012bAA\u0017\u000b\n9\u0001K]8ek\u000e$\b\u0003BA\u0019\u0003sqA!a\r\u000289\u0019\u0011,!\u000e\n\u0003\u0019K!A^#\n\t\u0005m\u0012Q\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003m\u0016\u000b\u0011b\u0019:fCR,G-\u0011;\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u0013r1ASA$\u0013\t1((\u0003\u0003\u0002L\u00055#\u0001\u0003(b]>$\u0016.\\3\u000b\u0005YT\u0014AC2sK\u0006$X\rZ!uA\u00059qN\u001a4tKR\u001cXCAA+!!\t9&a\u0018\u0002f\u0005md\u0002BA-\u00037\u0002\"!W#\n\u0007\u0005uS)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019GA\u0002NCBT1!!\u0018F!\u0011\t9'a\u001e\u000e\u0005\u0005%$\u0002BA6\u0003[\naaY8n[>t'bA \u0002p)!\u0011\u0011OA:\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QO\u0001\u0004_J<\u0017\u0002BA=\u0003S\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002~\u0005\u0015UBAA@\u0015\ri\u0014\u0011\u0011\u0006\u0005\u0003\u0007\u000bi'A\u0004dY&,g\u000e^:\n\t\u0005\u001d\u0015q\u0010\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0017\u0001C8gMN,Go\u001d\u0011\u0002\t\r|g\u000e^\u000b\u0003\u0003\u001f\u0003r\u0001UAI\u0003+\u000by\"C\u0002\u0002\u0014\u0002\u0013q\u0001\u0015:p[&\u001cX\r\u0005\u0003\u00022\u0005]\u0015\u0002BAM\u0003{\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0002\u000b\r|g\u000e\u001e\u0011\u0015\u0011\u0005}\u00151UAS\u0003O\u00032!!)\u001d\u001b\u0005I\u0002bBA G\u0001\u0007\u00111\t\u0005\b\u0003#\u001a\u0003\u0019AA+\u0011\u001d\tYi\ta\u0001\u0003\u001f\u000b\u0011\"[:QK:$\u0017N\\4\u0016\u0005\u00055\u0006#\u0002;\u0002\u001a\u0005=\u0006c\u0001#\u00022&\u0019\u00111W#\u0003\u000f\t{w\u000e\\3b]\"\u001aA%a.\u0011\u0007\u0011\u000bI,C\u0002\u0002<\u0016\u0013a!\u001b8mS:,\u0017\u0001B2paf$\u0002\"a(\u0002B\u0006\r\u0017Q\u0019\u0005\n\u0003\u007f)\u0003\u0013!a\u0001\u0003\u0007B\u0011\"!\u0015&!\u0003\u0005\r!!\u0016\t\u0013\u0005-U\u0005%AA\u0002\u0005=\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017TC!a\u0011\u0002N.\u0012\u0011q\u001a\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003%)hn\u00195fG.,GMC\u0002\u0002Z\u0016\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti.a5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r(\u0006BA+\u0003\u001b\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002j*\"\u0011qRAg\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001e\t\u0005\u0003c\fY0\u0004\u0002\u0002t*!\u0011Q_A|\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0018\u0001\u00026bm\u0006LA!!@\u0002t\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0001\u0011\u0007\u0011\u0013)!C\u0002\u0003\b\u0015\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0004\u0003\u0014A\u0019AIa\u0004\n\u0007\tEQIA\u0002B]fD\u0011B!\u0006,\u0003\u0003\u0005\rAa\u0001\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0002\u0005\u0004\u0003\u001e\t\r\"QB\u0007\u0003\u0005?Q1A!\tF\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005K\u0011yB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAX\u0005WA\u0011B!\u0006.\u0003\u0003\u0005\rA!\u0004\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003_\u0014\t\u0004C\u0005\u0003\u00169\n\t\u00111\u0001\u0003\u0004\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u0004\u0005AAo\\*ue&tw\r\u0006\u0002\u0002p\u00061Q-];bYN$B!a,\u0003@!I!QC\u0019\u0002\u0002\u0003\u0007!QB\u0001\u0007\u0007>lW.\u001b;\u0011\u0007\u0005\u00056gE\u00034\u0005\u000f\u0012\u0019\u0006\u0005\u0007\u0003J\t=\u00131IA+\u0003\u001f\u000by*\u0004\u0002\u0003L)\u0019!QJ#\u0002\u000fI,h\u000e^5nK&!!\u0011\u000bB&\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005+\u0012Y&\u0004\u0002\u0003X)!!\u0011LA|\u0003\tIw.\u0003\u0003\u0002<\t]CC\u0001B\"\u0003\u0015\t\u0007\u000f\u001d7z)!\tyJa\u0019\u0003f\t\u001d\u0004bBA m\u0001\u0007\u00111\t\u0005\b\u0003#2\u0004\u0019AA+\u0011\u001d\tYI\u000ea\u0001\u0003\u001f\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003n\te\u0004#\u0002#\u0003p\tM\u0014b\u0001B9\u000b\n1q\n\u001d;j_:\u0004\u0012\u0002\u0012B;\u0003\u0007\n)&a$\n\u0007\t]TI\u0001\u0004UkBdWm\r\u0005\n\u0005w:\u0014\u0011!a\u0001\u0003?\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\t\u0005\u0003\u0002r\n\r\u0015\u0002\u0002BC\u0003g\u0014aa\u00142kK\u000e$\u0018aE2p[6LG\u000f^3e\u001f\u001a47/\u001a;t%\u00164\u0007#\u0002)\u0003\f\n=\u0015b\u0001BG\u0001\n\u0019!+\u001a4\u0011\t\tE%q\u0013\b\u0004+\nM\u0015b\u0001BKu\u0005I1i\\7nSR$XM]\u0005\u0005\u00053\u0013YJA\u0007D_6l\u0017\u000e^(gMN,Go\u001d\u0006\u0004\u0005+S\u0014A\u00049f]\u0012LgnZ\"p[6LGo\u001d\t\u0007\u0005C\u00139K!,\u000f\u0007A\u0013\u0019+C\u0002\u0003&\u0002\u000b1AU3g\u0013\u0011\u0011IKa+\u0003\u0019MKhn\u00195s_:L'0\u001a3\u000b\u0007\t\u0015\u0006\t\u0005\u0003Q\u0005_\u001b\u0016b\u0001BY\u0001\n)1\t[;oWRy\u0001O!.\u00038\ne&1\u0018B_\u0005\u007f\u0013\t\rC\u0003N\u0011\u0001\u0007q\nC\u0003s\u0011\u0001\u00071\u000fC\u0003}\u0011\u0001\u0007Q\u0010C\u0004\u0002\f!\u0001\r!!\u0004\t\u000f\u0005U\u0001\u00021\u0001\u0002\u0018!9!q\u0011\u0005A\u0002\t%\u0005b\u0002BO\u0011\u0001\u0007!qT\u0001\u0018e\u0016<\u0017n\u001d;fe\u0016CH/\u001a:oC2\u001cu.\\7jiN,\"Aa2\u0011\u000f\u0011\u0013I-!\u0016\u0003N&\u0019!1Z#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#\u0002;\u0003P\u0006}\u0011\u0002\u0002Bi\u0003;\u0011A\u0001V1tW\u0006A\"/Z4jgR,'/\u0012=uKJt\u0017\r\\\"p[6LGo\u001d\u0011\u0002\r\r|W.\\5u\u0003\u001d\u0019w.\\7ji\u0002\nA\u0003\u001d:pG\u0016\u001c8/U;fk\u0016$7i\\7nSR\u001cHC\u0002Bg\u0005;\u0014i\u000f\u0003\u0004>\u001b\u0001\u0007!q\u001c\t\u0005\u0005C\u00149OD\u0002V\u0005GL1A!:;\u00039\u0019uN\\:v[\u0016\u0014\u0018iY2fgNLAA!;\u0003l\n1\")\u001f;f\u0003J\u0014\u0018-_&bM.\f7i\u001c8tk6,'OC\u0002\u0003fjB\u0011Ba<\u000e!\u0003\u0005\r!a,\u0002\u001d\u0015DXmY;uK>sW)\u001c9us\u0006q\u0002O]8dKN\u001c\u0018+^3vK\u0012\u001cu.\\7jiN$C-\u001a4bk2$HEM\u000b\u0003\u0005kTC!a,\u0002N\u0006\u0011R.\u001a:hK\u000e{W.\\5u\u001f\u001a47/\u001a;t)\u0011\t)Fa?\t\u000f\tux\u00021\u0001\u0003.\u000691m\\7nSR\u001c\u0018A\u00065b]\u0012dWmQ8n[&$8i\\7qY\u0016$\u0018n\u001c8\u0015\u0015\u0005]11AB\u0003\u0007\u000f\u0019Y\u0001C\u0004\u0003~B\u0001\rA!,\t\u000f\u0005E\u0003\u00031\u0001\u0002V!91\u0011\u0002\tA\u0002\u0005\r\u0013!C:uCJ$H+[7f\u0011\u001d\u0019i\u0001\u0005a\u0001\u0007\u001f\tQbY8n[&$(+Z:vYR\u001c\b\u0003CA\u0019\u0007#\u0019)\"!\u0016\n\t\rM\u0011Q\b\u0002\u0007\u000b&$\b.\u001a:\u0011\t\u0005E2qC\u0005\u0005\u00073\tiDA\u0005Fq\u000e,\u0007\u000f^5p]\u0006q1m\\7nSR\f5/\u001f8d5&{E\u0003\u0003Bg\u0007?\u0019\tca\t\t\ru\n\u0002\u0019\u0001Bp\u0011\u001d\t\t&\u0005a\u0001\u0003+Bqa!\n\u0012\u0001\u0004\u00199#\u0001\u0007e_>s7i\\7qY\u0016$X\rE\u0004E\u0005\u0013\u001cy!a\u0006\u0002\u0013E,X-^3TSj,WCAB\u0017!\u0015!\u0018\u0011\u0004B\u0002\u0003I\u0001XM\u001c3j]\u001e\u001cu.\\7ji\u000e{WO\u001c;\u0002#\u001d,G\u000fU3oI&twmQ8n[&$8/\u0006\u0002\u00046A)A/!\u0007\u0003\u0010\u0006)2\r\\3b]V\u0004\b+\u001a8eS:<7i\\7nSR\u001cXCAA\f\u0003aYW-\u001a9D_6l\u0017\u000e^:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003/\u0019y\u0004C\u0004\u0004BY\u0001\raa\u0011\u0002%\u0005\u001c8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0003/\u001a)%!\u001a\n\t\r\u001d\u00131\r\u0002\u0004'\u0016$\u0018aE4fi\u000e{W.\\5ui\u0016$wJ\u001a4tKR\u001c\b")
public final class LiveCommitter
implements Committer {
    private final Queue<Commit> commitQueue;
    private final Duration commitTimeout;
    private final Diagnostics<DiagnosticEvent> diagnostics;
    private final ConsumerMetrics consumerMetrics;
    private final ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable;
    private final Ref<Committer.CommitOffsets> committedOffsetsRef;
    private final Ref.Synchronized<Chunk<Commit>> pendingCommits;
    private final Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> registerExternalCommits;
    private final Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commit;

    public static ZIO<Scope, Nothing$, LiveCommitter> make(Duration commitTimeout, Diagnostics<DiagnosticEvent> diagnostics, ConsumerMetrics consumerMetrics, ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable) {
        return LiveCommitter$.MODULE$.make(commitTimeout, diagnostics, consumerMetrics, onCommitAvailable);
    }

    @Override
    public Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> registerExternalCommits() {
        return this.registerExternalCommits;
    }

    @Override
    public Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commit() {
        return this.commit;
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> processQueuedCommits(Consumer<byte[], byte[]> consumer, boolean executeOnEmpty) {
        return this.commitQueue.takeAll((Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:58)").flatMap((Function1 & Serializable)commits -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(19).append("Processing ").append(commits.size()).append(" commits").toString(), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:59)").flatMap((Function1 & Serializable)x$15 -> {
            BoxedUnit boxedUnit = x$15;
            return ZIO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> commits.nonEmpty() || executeOnEmpty, (Function0 & Serializable)() -> {
                scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets = this.mergeCommitOffsets((Chunk<Commit>)commits);
                scala.collection.immutable.Map offsetsWithMetaData = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndMetadata(offset.offset() + 1L, offset.leaderEpoch(), offset.metadata()));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return $this.pendingCommits.update((Function1 & Serializable)x$9 -> x$9.$plus$plus(commits), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:67)").flatMap((Function1 & Serializable)x$13 -> {
                    BoxedUnit boxedUnit = x$13;
                    return ZIO$.MODULE$.clockWith((Function1 & Serializable)x$10 -> x$10.nanoTime((Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:68)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:68)").flatMap((Function1 & Serializable)startTime -> this.commitAsyncZIO((Consumer<byte[], byte[]>)consumer, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData, (Function1<Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>)(Function1 & Serializable)x$11 -> $this.handleCommitCompletion((Chunk<Commit>)commits$1, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$1, startTime, (Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)x$11)), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:68)");
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:67)");
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:60)").map((Function1 & Serializable)x$14 -> {
                option = x$14;
                return BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:60)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:59)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:58)");
    }

    @Override
    public boolean processQueuedCommits$default$2() {
        return false;
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> mergeCommitOffsets(Chunk<Commit> commits) {
        return ((IterableOnceOps)commits.foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.mutable.Map acc = (scala.collection.mutable.Map)tuple2._1();
                Commit commit = (Commit)tuple2._2();
                commit.offsets().foreach((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                        return (scala.collection.mutable.Map)acc.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), acc.get((Object)tp).map((Function1 & Serializable)current -> {
                            if (current.offset() > offset.offset()) {
                                return current;
                            }
                            return offset;
                        }).getOrElse((Function0 & Serializable)() -> offset)));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return acc;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ZIO<Object, Nothing$, BoxedUnit> handleCommitCompletion(Chunk<Commit> commits, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, long startTime, Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> commitResults) {
        return ZIO$.MODULE$.from((Function0 & Serializable)() -> commitResults, ZIO.ZIOConstructor$.MODULE$.EitherConstructor(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:99)").zipLeft((Function0 & Serializable)() -> ZIO$.MODULE$.clockWith((Function1 & Serializable)x$16 -> x$16.nanoTime((Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:102)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:102)").flatMap((Function1 & Serializable)endTime -> LiveCommitter.$anonfun$handleCommitCompletion$4(this, startTime, commits, BoxesRunTime.unboxToLong((Object)endTime)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:102)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:100)").zipLeft((Function0 & Serializable)() -> ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> commits, (Function1 & Serializable)x$20 -> x$20.cont().done(Exit$.MODULE$.unit(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:108)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:108)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:108)").tap((Function1 & Serializable)offsetsWithMetaData -> $this.diagnostics.emit((Function0<DiagnosticEvent>)(Function0 & Serializable)() -> new DiagnosticEvent.Commit.Success((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:109)").catchAllCause((Function1 & Serializable)x0$1 -> {
            Cause.Fail fail;
            Cause cause = x0$1;
            if (cause instanceof Cause.Fail && (fail = (Cause.Fail)cause).value() instanceof RebalanceInProgressException) {
                return ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(58).append("Rebalance in progress, commit for offsets ").append(offsets).append(" will be retried").toString(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:113)").flatMap((Function1 & Serializable)x$23 -> {
                    BoxedUnit boxedUnit = x$23;
                    return $this.commitQueue.offerAll((Iterable)commits, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:114)").flatMap((Function1 & Serializable)x$22 -> {
                        Chunk chunk = x$22;
                        return $this.onCommitAvailable.map((Function1 & Serializable)x$21 -> {
                            boxedUnit = x$21;
                            return BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:115)");
                    }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:114)");
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:113)");
            }
            return ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> commits, (Function1 & Serializable)x$24 -> x$24.cont().done(Exit$.MODULE$.fail((Object)cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()))), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:118)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:118)").$less$times((Function0 & Serializable)() -> $this.diagnostics.emit((Function0<DiagnosticEvent>)(Function0 & Serializable)() -> new DiagnosticEvent.Commit.Failure(offsets, cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())))), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:118)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:110)").ignore((Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:122)");
    }

    private ZIO<Object, Throwable, BoxedUnit> commitAsyncZIO(Consumer<byte[], byte[]> consumer, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>, ZIO<Object, Nothing$, BoxedUnit>> doOnComplete) {
        return ZIO$.MODULE$.runtime((Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:136)").flatMap((Function1 & Serializable)runtime -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava(), new OffsetCommitCallback(null, (Runtime)runtime, (Function1)doOnComplete){
            private final Runtime runtime$1;
            private final Function1 doOnComplete$1;

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                Unsafe$.MODULE$.unsafe((Function1 & Serializable)unsafe -> {
                    $anon$1.$anonfun$onComplete$1(this, exception, offsets, unsafe);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onComplete$1($anon$1 $this, Exception exception$1, java.util.Map offsets$5, Unsafe unsafe) {
                $this.runtime$1.unsafe().run(exception$1 == null ? (ZIO)$this.doOnComplete$1.apply((Object)new Right((Object)CollectionConverters$.MODULE$.MapHasAsScala(offsets$5).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))) : (ZIO)$this.doOnComplete$1.apply((Object)new Left((Object)exception$1)), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO.$anon.onComplete(LiveCommitter.scala:146)", unsafe).getOrThrowFiberFailure(unsafe);
            }
            {
                this.runtime$1 = runtime$1;
                this.doOnComplete$1 = doOnComplete$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1$adapted(zio.kafka.consumer.internal.LiveCommitter$$anon$1 java.lang.Exception java.util.Map zio.Unsafe )}, serializedLambda);
            }
        }), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:137)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:136)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> queueSize() {
        return this.commitQueue.size((Object)"zio.kafka.consumer.internal.LiveCommitter.queueSize(LiveCommitter.scala:156)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> pendingCommitCount() {
        return this.pendingCommits.get((Object)"zio.kafka.consumer.internal.LiveCommitter.pendingCommitCount(LiveCommitter.scala:158)").map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToInteger((int)x$26.size()), (Object)"zio.kafka.consumer.internal.LiveCommitter.pendingCommitCount(LiveCommitter.scala:158)");
    }

    @Override
    public ZIO<Object, Nothing$, Committer.CommitOffsets> getPendingCommits() {
        return this.pendingCommits.get((Object)"zio.kafka.consumer.internal.LiveCommitter.getPendingCommits(LiveCommitter.scala:161)").map((Function1 & Serializable)x$27 -> (Committer.CommitOffsets)Committer$CommitOffsets$.MODULE$.empty().addCommits((Chunk<Commit>)x$27)._2(), (Object)"zio.kafka.consumer.internal.LiveCommitter.getPendingCommits(LiveCommitter.scala:161)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> cleanupPendingCommits() {
        return this.pendingCommits.updateZIO((Function1 & Serializable)x$28 -> x$28.filterZIO((Function1 & Serializable)x$29 -> x$29.isPending(), (Object)"zio.kafka.consumer.internal.LiveCommitter.cleanupPendingCommits(LiveCommitter.scala:164)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.cleanupPendingCommits(LiveCommitter.scala:164)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> keepCommitsForPartitions(Set<TopicPartition> assignedPartitions) {
        return this.committedOffsetsRef.update((Function1 & Serializable)x$30 -> x$30.keepPartitions(assignedPartitions), (Object)"zio.kafka.consumer.internal.LiveCommitter.keepCommitsForPartitions(LiveCommitter.scala:167)");
    }

    @Override
    public ZIO<Object, Nothing$, Committer.CommitOffsets> getCommittedOffsets() {
        return this.committedOffsetsRef.get((Object)"zio.kafka.consumer.internal.LiveCommitter.getCommittedOffsets(LiveCommitter.scala:169)");
    }

    public static final /* synthetic */ ZIO $anonfun$commit$3(LiveCommitter $this, scala.collection.immutable.Map offsets$2, Promise p$1, long startTime$1, boolean x$7) {
        boolean bl = x$7;
        return $this.onCommitAvailable.flatMap((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            return $this.diagnostics.emit((Function0<DiagnosticEvent>)(Function0 & Serializable)() -> new DiagnosticEvent.Commit.Started((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$2)).flatMap((Function1 & Serializable)x$5 -> {
                BoxedUnit boxedUnit = x$5;
                return p$1.await((Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:44)").timeoutFail((Function0 & Serializable)() -> Consumer$CommitTimeout$.MODULE$, (Function0 & Serializable)() -> $this.commitTimeout, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:44)").flatMap((Function1 & Serializable)x$2 -> {
                    long endTime = System.nanoTime();
                    Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(package$.MODULE$.durationLong(endTime - startTime$1));
                    return $this.consumerMetrics.observeCommit(latency);
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:44)");
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:43)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:42)");
    }

    public static final /* synthetic */ ZIO $anonfun$handleCommitCompletion$6(LiveCommitter $this, Duration latency$1, Chunk commits$2, long offsetIncrease) {
        return $this.consumerMetrics.observeAggregatedCommit(latency$1, offsetIncrease).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> commits$2.nonEmpty(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:105)").map((Function1 & Serializable)x$18 -> {
            option = x$18;
            return BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:105)");
    }

    public static final /* synthetic */ ZIO $anonfun$handleCommitCompletion$4(LiveCommitter $this, long startTime$3, Chunk commits$2, long endTime) {
        Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(package$.MODULE$.durationLong(endTime - startTime$3));
        return $this.committedOffsetsRef.modify((Function1 & Serializable)x$17 -> x$17.addCommits((Chunk<Commit>)commits$2), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:104)").flatMap((Function1 & Serializable)offsetIncrease -> LiveCommitter.$anonfun$handleCommitCompletion$6($this, latency, commits$2, BoxesRunTime.unboxToLong((Object)offsetIncrease)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:104)");
    }

    public LiveCommitter(Queue<Commit> commitQueue, Duration commitTimeout, Diagnostics<DiagnosticEvent> diagnostics, ConsumerMetrics consumerMetrics, ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable, Ref<Committer.CommitOffsets> committedOffsetsRef, Ref.Synchronized<Chunk<Commit>> pendingCommits) {
        this.commitQueue = commitQueue;
        this.commitTimeout = commitTimeout;
        this.diagnostics = diagnostics;
        this.consumerMetrics = consumerMetrics;
        this.onCommitAvailable = onCommitAvailable;
        this.committedOffsetsRef = committedOffsetsRef;
        this.pendingCommits = pendingCommits;
        this.registerExternalCommits = (Function1 & Serializable)offsets -> $this.committedOffsetsRef.modify((Function1 & Serializable)x$1 -> x$1.addCommits((Chunk<Commit>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Commit[]{new Commit(System.nanoTime(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, null)}))), (Object)"zio.kafka.consumer.internal.LiveCommitter.registerExternalCommits(LiveCommitter.scala:30)").unit((Object)"zio.kafka.consumer.internal.LiveCommitter.registerExternalCommits(LiveCommitter.scala:33)");
        this.commit = (Function1 & Serializable)offsets -> Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:39)").flatMap((Function1 & Serializable)p -> {
            long startTime = System.nanoTime();
            return $this.commitQueue.offer((Object)new Commit(startTime, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, (Promise<Throwable, BoxedUnit>)p), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:41)").flatMap((Function1 & Serializable)x$7 -> LiveCommitter.$anonfun$commit$3(this, offsets, p, startTime, BoxesRunTime.unboxToBoolean((Object)x$7)), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:41)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:39)");
    }

    public static final class Commit
    implements Product,
    Serializable {
        private final long createdAt;
        private final scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets;
        private final Promise<Throwable, BoxedUnit> cont;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long createdAt() {
            return this.createdAt;
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets() {
            return this.offsets;
        }

        public Promise<Throwable, BoxedUnit> cont() {
            return this.cont;
        }

        public ZIO<Object, Nothing$, Object> isPending() {
            return this.cont().isDone((Object)"zio.kafka.consumer.internal.LiveCommitter.Commit.isPending(LiveCommitter.scala:197)").negate(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.internal.LiveCommitter.Commit.isPending(LiveCommitter.scala:197)");
        }

        public Commit copy(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            return new Commit(createdAt, offsets, cont);
        }

        public long copy$default$1() {
            return this.createdAt();
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> copy$default$2() {
            return this.offsets();
        }

        public Promise<Throwable, BoxedUnit> copy$default$3() {
            return this.cont();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.createdAt());
                }
                case 1: {
                    return this.offsets();
                }
                case 2: {
                    return this.cont();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "createdAt";
                }
                case 1: {
                    return "offsets";
                }
                case 2: {
                    return "cont";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.createdAt()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offsets()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cont()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit = (Commit)x$1;
            if (this.createdAt() != commit.createdAt()) return false;
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = this.offsets();
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map2 = commit.offsets();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Promise<Throwable, BoxedUnit> promise = this.cont();
            Promise<Throwable, BoxedUnit> promise2 = commit.cont();
            if (promise == null) {
                if (promise2 == null) return true;
                return false;
            } else {
                if (!promise.equals(promise2)) return false;
                return true;
            }
        }

        public Commit(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            this.createdAt = createdAt;
            this.offsets = offsets;
            this.cont = cont;
            Product.$init$((Product)this);
        }
    }
}

