/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetCommitPending$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetCommitted$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetNotCommitted$;
import zio.kafka.consumer.internal.RebalanceCoordinator$RebalanceEvent$;
import zio.kafka.consumer.internal.package$;
import zio.stream.ZStream$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001de!CA\u0017\u0003_\u0001\u0011qFA \u0011)\ti\u0005\u0001B\u0001B\u0003%\u0011\u0011\u000b\u0005\u000b\u0007W\u0004!\u0011!Q\u0001\n\r5\bBCA\u001b\u0001\t\u0005\t\u0015!\u0003\u0004v\"Q11 \u0001\u0003\u0002\u0003\u0006Ia!@\t\u0015\u0011-\u0001A!A!\u0002\u0013!i\u0001\u0003\u0006\u0005\u0016\u0001\u0011\t\u0011)A\u0005\t/Aq!a!\u0001\t\u0003!i\u0002C\u0005\u0005.\u0001\u0011\r\u0011\"\u0003\u00050!AA\u0011\u0007\u0001!\u0002\u0013\u0011\t\u0007C\u0005\u00054\u0001\u0011\r\u0011\"\u0003\u0003T!AAQ\u0007\u0001!\u0002\u0013\t)\u0010C\u0005\u00058\u0001\u0011\r\u0011\"\u0003\u0003T!AA\u0011\b\u0001!\u0002\u0013\t)\u0010C\u0005\u0005<\u0001\u0011\r\u0011\"\u0003\u0005>!AAq\b\u0001!\u0002\u0013\u0019i\u0010C\u0005\u0005B\u0001\u0011\r\u0011\"\u0003\u0005D!AA\u0011\n\u0001!\u0002\u0013!)\u0005C\u0004\u0005L\u0001!\t\u0001\"\u0014\t\u000f\u0011E\u0003\u0001\"\u0003\u0005T!9Aq\f\u0001\u0005\n\u0011\u0005\u0004b\u0002C?\u0001\u0011\u0005AqP\u0004\u000b\u0003w\ny\u0003#\u0001\u00020\u0005udACA\u0017\u0003_A\t!a\f\u0002\u0002\"9\u00111Q\f\u0005\u0002\u0005\u0015e!CAD/A\u0005\u0019\u0013FAE\u000f\u001d\u0011Yc\u0006EE\u0005C1qAa\u0007\u0018\u0011\u0013\u0013i\u0002C\u0004\u0002\u0004n!\tAa\b\t\u000f\u0005E6\u0004\"\u0011\u00024\"I\u0011QY\u000e\u0002\u0002\u0013\u0005\u0013q\u0019\u0005\n\u0003\u0013\\\u0012\u0011!C\u0001\u0003\u0017D\u0011\"a5\u001c\u0003\u0003%\tAa\t\t\u0013\u0005\u00058$!A\u0005B\u0005\r\b\"CAy7\u0005\u0005I\u0011\u0001B\u0014\u0011%\tipGA\u0001\n\u0003\ny\u0010C\u0005\u0003\u0002m\t\t\u0011\"\u0003\u0003\u0004\u001d9!QF\f\t\n\u0006=faBAG/!%\u0015q\u0012\u0005\b\u0003\u00073C\u0011AAW\u0011\u001d\t\tL\nC!\u0003gC\u0011\"!2'\u0003\u0003%\t%a2\t\u0013\u0005%g%!A\u0005\u0002\u0005-\u0007\"CAjM\u0005\u0005I\u0011AAk\u0011%\t\tOJA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002r\u001a\n\t\u0011\"\u0001\u0002t\"I\u0011Q \u0014\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005\u00031\u0013\u0011!C\u0005\u0005\u00079qAa\f\u0018\u0011\u0013\u0013\tBB\u0004\u0003\f]AII!\u0004\t\u000f\u0005\r\u0015\u0007\"\u0001\u0003\u0010!9\u0011\u0011W\u0019\u0005B\u0005M\u0006\"CAcc\u0005\u0005I\u0011IAd\u0011%\tI-MA\u0001\n\u0003\tY\rC\u0005\u0002TF\n\t\u0011\"\u0001\u0003\u0014!I\u0011\u0011]\u0019\u0002\u0002\u0013\u0005\u00131\u001d\u0005\n\u0003c\f\u0014\u0011!C\u0001\u0005/A\u0011\"!@2\u0003\u0003%\t%a@\t\u0013\t\u0005\u0011'!A\u0005\n\t\raA\u0002B\u0019/\u0019\u0013\u0019\u0004\u0003\u0006\u00036m\u0012)\u001a!C\u0001\u0005oA!Ba\u0014<\u0005#\u0005\u000b\u0011\u0002B\u001d\u0011)\u0011\tf\u000fBK\u0002\u0013\u0005!1\u000b\u0005\u000b\u0005+Z$\u0011#Q\u0001\n\u0005U\bB\u0003B,w\tU\r\u0011\"\u0001\u0003Z!Q!qM\u001e\u0003\u0012\u0003\u0006IAa\u0017\t\u0015\t%4H!f\u0001\n\u0003\u0011I\u0006\u0003\u0006\u0003lm\u0012\t\u0012)A\u0005\u00057B!B!\u001c<\u0005+\u0007I\u0011\u0001B8\u0011)\u0011\th\u000fB\tB\u0003%\u0011\u0011\u0013\u0005\b\u0003\u0007[D\u0011\u0001B:\u0011\u001d\t\tl\u000fC!\u0005\u0003C\u0011B!%<\u0003\u0003%\tAa%\t\u0013\t}5(%A\u0005\u0002\t\u0005\u0006\"\u0003B\\wE\u0005I\u0011\u0001B]\u0011%\u0011ilOI\u0001\n\u0003\u0011y\fC\u0005\u0003Dn\n\n\u0011\"\u0001\u0003@\"I!QY\u001e\u0012\u0002\u0013\u0005!q\u0019\u0005\n\u0003\u000b\\\u0014\u0011!C!\u0003\u000fD\u0011\"!3<\u0003\u0003%\t!a3\t\u0013\u0005M7(!A\u0005\u0002\t-\u0007\"CAqw\u0005\u0005I\u0011IAr\u0011%\t\tpOA\u0001\n\u0003\u0011y\rC\u0005\u0003Tn\n\t\u0011\"\u0011\u0003V\"I\u0011Q`\u001e\u0002\u0002\u0013\u0005\u0013q \u0005\n\u00053\\\u0014\u0011!C!\u00057<\u0011Ba8\u0018\u0003\u0003EIA!9\u0007\u0013\tEr#!A\t\n\t\r\bbBAB/\u0012\u0005!1 \u0005\n\u0003c;\u0016\u0011!C#\u0003gC\u0011B!@X\u0003\u0003%\tIa@\t\u0013\r-q+!A\u0005\u0002\u000e5\u0001\"\u0003B\u0001/\u0006\u0005I\u0011\u0002B\u0002\r\u0019\u0019Yb\u0006\"\u0004\u001e!Q1qD/\u0003\u0016\u0004%\ta!\t\t\u0015\r%RL!E!\u0002\u0013\u0019\u0019\u0003\u0003\u0006\u0004,u\u0013)\u001a!C\u0001\u0007CA!b!\f^\u0005#\u0005\u000b\u0011BB\u0012\u0011)\u0019y#\u0018BK\u0002\u0013\u00051\u0011\u0005\u0005\u000b\u0007ci&\u0011#Q\u0001\n\r\r\u0002BCB\u001a;\nU\r\u0011\"\u0001\u00046!Q11I/\u0003\u0012\u0003\u0006Iaa\u000e\t\u000f\u0005\rU\f\"\u0001\u0004F!91\u0011K/\u0005\u0002\rM\u0003\"\u0003BI;\u0006\u0005I\u0011AB-\u0011%\u0011y*XI\u0001\n\u0003\u0019\u0019\u0007C\u0005\u00038v\u000b\n\u0011\"\u0001\u0004d!I!QX/\u0012\u0002\u0013\u000511\r\u0005\n\u0005\u0007l\u0016\u0013!C\u0001\u0007OB\u0011\"!2^\u0003\u0003%\t%a2\t\u0013\u0005%W,!A\u0005\u0002\u0005-\u0007\"CAj;\u0006\u0005I\u0011AB6\u0011%\t\t/XA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002rv\u000b\t\u0011\"\u0001\u0004p!I!1[/\u0002\u0002\u0013\u000531\u000f\u0005\n\u0003{l\u0016\u0011!C!\u0003\u007fD\u0011\"!-^\u0003\u0003%\t%a-\t\u0013\teW,!A\u0005B\r]t!CB>/\u0005\u0005\t\u0012AB?\r%\u0019YbFA\u0001\u0012\u0003\u0019y\bC\u0004\u0002\u0004^$\taa\"\t\u0013\u0005Ev/!A\u0005F\u0005M\u0006\"\u0003B\u007fo\u0006\u0005I\u0011QBE\u0011%\u0019Ya^A\u0001\n\u0003\u001b\u0019\nC\u0005\u0003\u0002]\f\t\u0011\"\u0003\u0003\u0004\u001911qT\fC\u0007CC!ba)~\u0005+\u0007I\u0011ABS\u0011)\u0019I+ B\tB\u0003%1q\u0015\u0005\b\u0003\u0007kH\u0011ABV\u0011\u001d\u0019\t, C\u0001\u0005'Bqaa-~\t\u0003\u0019)\fC\u0005\u0003\u0012v\f\t\u0011\"\u0001\u0004<\"I!qT?\u0012\u0002\u0013\u00051q\u0018\u0005\n\u0003\u000bl\u0018\u0011!C!\u0003\u000fD\u0011\"!3~\u0003\u0003%\t!a3\t\u0013\u0005MW0!A\u0005\u0002\r\r\u0007\"CAq{\u0006\u0005I\u0011IAr\u0011%\t\t0`A\u0001\n\u0003\u00199\rC\u0005\u0003Tv\f\t\u0011\"\u0011\u0004L\"I\u0011Q`?\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0003ck\u0018\u0011!C!\u0003gC\u0011B!7~\u0003\u0003%\tea4\b\u000f\rMw\u0003#\u0001\u0004V\u001a91qT\f\t\u0002\r]\u0007\u0002CAB\u0003?!\ta!7\t\u0015\rm\u0017q\u0004b\u0001\n\u0003\u0019i\u000eC\u0005\u0004`\u0006}\u0001\u0015!\u0003\u0004.\"Q!Q`A\u0010\u0003\u0003%\ti!9\t\u0015\r-\u0011qDA\u0001\n\u0003\u001b)\u000f\u0003\u0006\u0003\u0002\u0005}\u0011\u0011!C\u0005\u0005\u0007\u0011ACU3cC2\fgnY3D_>\u0014H-\u001b8bi>\u0014(\u0002BA\u0019\u0003g\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0005\u0003k\t9$\u0001\u0005d_:\u001cX/\\3s\u0015\u0011\tI$a\u000f\u0002\u000b-\fgm[1\u000b\u0005\u0005u\u0012a\u0001>j_N\u0019\u0001!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR!!a\u0012\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005-\u0013Q\t\u0002\u0007\u0003:L(+\u001a4\u0002%1\f7\u000f\u001e*fE\u0006d\u0017M\\2f\u000bZ,g\u000e^\u0002\u0001!\u0019\t\u0019&a\u0017\u0002b9!\u0011QKA,\u001b\t\tY$\u0003\u0003\u0002Z\u0005m\u0012a\u0001*fM&!\u0011QLA0\u00051\u0019\u0016P\\2ie>t\u0017N_3e\u0015\u0011\tI&a\u000f\u0011\u0007\u0005\rTPD\u0002\u0002fYqA!a\u001a\u0002z9!\u0011\u0011NA<\u001d\u0011\tY'!\u001e\u000f\t\u00055\u00141O\u0007\u0003\u0003_RA!!\u001d\u0002P\u00051AH]8pizJ!!!\u0010\n\t\u0005e\u00121H\u0005\u0005\u0003k\t9$\u0003\u0003\u00022\u0005M\u0012\u0001\u0006*fE\u0006d\u0017M\\2f\u0007>|'\u000fZ5oCR|'\u000fE\u0002\u0002\u0000]i!!a\f\u0014\u0007]\t\t%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003{\u0012Q#\u00128e\u001f\u001a47/\u001a;D_6l\u0017\u000e^*uCR,8oE\u0002\u001a\u0003\u0003JC!\u0007\u001427\t1RI\u001c3PM\u001a\u001cX\r^\"p[6LG\u000fU3oI&twmE\u0005'\u0003\u0003\n\t*!&\u0002\u001cB\u0019\u00111S\r\u000e\u0003]\u0001B!a\u0011\u0002\u0018&!\u0011\u0011TA#\u0005\u001d\u0001&o\u001c3vGR\u0004B!!(\u0002(:!\u0011qTAR\u001d\u0011\ti'!)\n\u0005\u0005\u001d\u0013\u0002BAS\u0003\u000b\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\u0006-&\u0001D*fe&\fG.\u001b>bE2,'\u0002BAS\u0003\u000b\"\"!a,\u0011\u0007\u0005Me%\u0001\u0005u_N#(/\u001b8h)\t\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\u000bAA[1wC&!\u00111YA]\u0005\u0019\u0019FO]5oO\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!.\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0007\u0003BA\"\u0003\u001fLA!!5\u0002F\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q[Ao!\u0011\t\u0019%!7\n\t\u0005m\u0017Q\t\u0002\u0004\u0003:L\b\"CApW\u0005\u0005\t\u0019AAg\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001d\t\u0007\u0003O\fi/a6\u000e\u0005\u0005%(\u0002BAv\u0003\u000b\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty/!;\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\fY\u0010\u0005\u0003\u0002D\u0005]\u0018\u0002BA}\u0003\u000b\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002`6\n\t\u00111\u0001\u0002X\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002N\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u0001\t\u0005\u0003o\u00139!\u0003\u0003\u0003\n\u0005e&AB(cU\u0016\u001cGO\u0001\nF]\u0012|eMZ:fi\u000e{W.\\5ui\u0016$7#C\u0019\u0002B\u0005E\u0015QSAN)\t\u0011\t\u0002E\u0002\u0002\u0014F\"B!a6\u0003\u0016!I\u0011q\u001c\u001c\u0002\u0002\u0003\u0007\u0011Q\u001a\u000b\u0005\u0003k\u0014I\u0002C\u0005\u0002`b\n\t\u00111\u0001\u0002X\n)RI\u001c3PM\u001a\u001cX\r\u001e(pi\u000e{W.\\5ui\u0016$7#C\u000e\u0002B\u0005E\u0015QSAN)\t\u0011\t\u0003E\u0002\u0002\u0014n!B!a6\u0003&!I\u0011q\u001c\u0011\u0002\u0002\u0003\u0007\u0011Q\u001a\u000b\u0005\u0003k\u0014I\u0003C\u0005\u0002`\n\n\t\u00111\u0001\u0002X\u0006)RI\u001c3PM\u001a\u001cX\r\u001e(pi\u000e{W.\\5ui\u0016$\u0017AF#oI>3gm]3u\u0007>lW.\u001b;QK:$\u0017N\\4\u0002%\u0015sGm\u00144gg\u0016$8i\\7nSR$X\r\u001a\u0002\u0017'R\u0014X-Y7D_6\u0004H.\u001a;j_:\u001cF/\u0019;vgN91(!\u0011\u0002\u0016\u0006m\u0015A\u0001;q+\t\u0011I\u0004\u0005\u0003\u0003<\t-SB\u0001B\u001f\u0015\u0011\u0011yD!\u0011\u0002\r\r|W.\\8o\u0015\u0011\tIDa\u0011\u000b\t\t\u0015#qI\u0001\u0007CB\f7\r[3\u000b\u0005\t%\u0013aA8sO&!!Q\nB\u001f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003-\u0019HO]3b[\u0016sG-\u001a3\u0016\u0005\u0005U\u0018\u0001D:ue\u0016\fW.\u00128eK\u0012\u0004\u0013\u0001\u00057bgR\u0004V\u000f\u001c7fI>3gm]3u+\t\u0011Y\u0006\u0005\u0004\u0002D\tu#\u0011M\u0005\u0005\u0005?\n)E\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\u0012\u0019'\u0003\u0003\u0003f\u0005\u0015#\u0001\u0002'p]\u001e\f\u0011\u0003\\1tiB+H\u000e\\3e\u001f\u001a47/\u001a;!\u0003Ma\u0017m\u001d;D_6l\u0017\u000e\u001e;fI>3gm]3u\u0003Qa\u0017m\u001d;D_6l\u0017\u000e\u001e;fI>3gm]3uA\u0005)RM\u001c3PM\u001a\u001cX\r^\"p[6LGo\u0015;biV\u001cXCAAI\u0003Y)g\u000eZ(gMN,GoQ8n[&$8\u000b^1ukN\u0004C\u0003\u0004B;\u0005o\u0012IHa\u001f\u0003~\t}\u0004cAAJw!9!Q\u0007$A\u0002\te\u0002b\u0002B)\r\u0002\u0007\u0011Q\u001f\u0005\b\u0005/2\u0005\u0019\u0001B.\u0011\u001d\u0011IG\u0012a\u0001\u00057BqA!\u001cG\u0001\u0004\t\t\n\u0006\u0002\u0003\u0004B!!Q\u0011BG\u001d\u0011\u00119I!#\u0011\t\u00055\u0014QI\u0005\u0005\u0005\u0017\u000b)%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\u0014yI\u0003\u0003\u0003\f\u0006\u0015\u0013\u0001B2paf$BB!\u001e\u0003\u0016\n]%\u0011\u0014BN\u0005;C\u0011B!\u000eI!\u0003\u0005\rA!\u000f\t\u0013\tE\u0003\n%AA\u0002\u0005U\b\"\u0003B,\u0011B\u0005\t\u0019\u0001B.\u0011%\u0011I\u0007\u0013I\u0001\u0002\u0004\u0011Y\u0006C\u0005\u0003n!\u0003\n\u00111\u0001\u0002\u0012\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BRU\u0011\u0011ID!*,\u0005\t\u001d\u0006\u0003\u0002BU\u0005gk!Aa+\u000b\t\t5&qV\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!-\u0002F\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU&1\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005wSC!!>\u0003&\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001BaU\u0011\u0011YF!*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001BeU\u0011\t\tJ!*\u0015\t\u0005]'Q\u001a\u0005\n\u0003?\u0004\u0016\u0011!a\u0001\u0003\u001b$B!!>\u0003R\"I\u0011q\u001c*\u0002\u0002\u0003\u0007\u0011q[\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u00026\n]\u0007\"CAp'\u0006\u0005\t\u0019AAg\u0003\u0019)\u0017/^1mgR!\u0011Q\u001fBo\u0011%\ty.VA\u0001\u0002\u0004\t9.\u0001\fTiJ,\u0017-\\\"p[BdW\r^5p]N#\u0018\r^;t!\r\t\u0019jV\n\u0006/\n\u0015(\u0011\u001f\t\u0011\u0005O\u0014iO!\u000f\u0002v\nm#1LAI\u0005kj!A!;\u000b\t\t-\u0018QI\u0001\beVtG/[7f\u0013\u0011\u0011yO!;\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0005\u0003\u0003t\neXB\u0001B{\u0015\u0011\u001190!0\u0002\u0005%|\u0017\u0002BAU\u0005k$\"A!9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\tU4\u0011AB\u0002\u0007\u000b\u00199a!\u0003\t\u000f\tU\"\f1\u0001\u0003:!9!\u0011\u000b.A\u0002\u0005U\bb\u0002B,5\u0002\u0007!1\f\u0005\b\u0005SR\u0006\u0019\u0001B.\u0011\u001d\u0011iG\u0017a\u0001\u0003#\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0010\r]\u0001CBA\"\u0005;\u001a\t\u0002\u0005\b\u0002D\rM!\u0011HA{\u00057\u0012Y&!%\n\t\rU\u0011Q\t\u0002\u0007)V\u0004H.Z\u001b\t\u0013\re1,!AA\u0002\tU\u0014a\u0001=%a\t\t\"+\u001a2bY\u0006t7-Z\"bY2\u0014\u0017mY6\u0014\u000fu\u000b\t%!&\u0002\u001c\u0006Y\u0011m]:jO:,G\r\u00169t+\t\u0019\u0019\u0003\u0005\u0004\u0003\u0006\u000e\u0015\"\u0011H\u0005\u0005\u0007O\u0011yIA\u0002TKR\fA\"Y:tS\u001etW\r\u001a+qg\u0002\n!B]3w_.,G\r\u00169t\u0003-\u0011XM^8lK\u0012$\u0006o\u001d\u0011\u0002\u000f1|7\u000f\u001e+qg\u0006AAn\\:u)B\u001c\b%\u0001\u0007f]\u0012,Gm\u0015;sK\u0006l7/\u0006\u0002\u00048A1\u0011QKB\u001d\u0007{IAaa\u000f\u0002<\t)1\t[;oWB!\u0011qPB \u0013\u0011\u0019\t%a\f\u0003-A\u000b'\u000f^5uS>t7\u000b\u001e:fC6\u001cuN\u001c;s_2\fQ\"\u001a8eK\u0012\u001cFO]3b[N\u0004CCCB$\u0007\u0013\u001aYe!\u0014\u0004PA\u0019\u00111S/\t\u000f\r}a\r1\u0001\u0004$!911\u00064A\u0002\r\r\u0002bBB\u0018M\u0002\u000711\u0005\u0005\b\u0007g1\u0007\u0019AB\u001c\u0003\u0019\t\u0007\u000f]3oIR!1qIB+\u0011\u001d\u00199f\u001aa\u0001\u0007\u000f\nQa\u001c;iKJ$\"ba\u0012\u0004\\\ru3qLB1\u0011%\u0019y\u0002\u001bI\u0001\u0002\u0004\u0019\u0019\u0003C\u0005\u0004,!\u0004\n\u00111\u0001\u0004$!I1q\u00065\u0011\u0002\u0003\u000711\u0005\u0005\n\u0007gA\u0007\u0013!a\u0001\u0007o)\"a!\u001a+\t\r\r\"QU\u000b\u0003\u0007SRCaa\u000e\u0003&R!\u0011q[B7\u0011%\tyn\\A\u0001\u0002\u0004\ti\r\u0006\u0003\u0002v\u000eE\u0004\"CApc\u0006\u0005\t\u0019AAl)\u0011\t)l!\u001e\t\u0013\u0005}'/!AA\u0002\u00055G\u0003BA{\u0007sB\u0011\"a8v\u0003\u0003\u0005\r!a6\u0002#I+'-\u00197b]\u000e,7)\u00197mE\u0006\u001c7\u000eE\u0002\u0002\u0014^\u001cRa^BA\u0005c\u0004bBa:\u0004\u0004\u000e\r21EB\u0012\u0007o\u00199%\u0003\u0003\u0004\u0006\n%(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u00111Q\u0010\u000b\u000b\u0007\u000f\u001aYi!$\u0004\u0010\u000eE\u0005bBB\u0010u\u0002\u000711\u0005\u0005\b\u0007WQ\b\u0019AB\u0012\u0011\u001d\u0019yC\u001fa\u0001\u0007GAqaa\r{\u0001\u0004\u00199\u0004\u0006\u0003\u0004\u0016\u000eu\u0005CBA\"\u0005;\u001a9\n\u0005\u0007\u0002D\re51EB\u0012\u0007G\u00199$\u0003\u0003\u0004\u001c\u0006\u0015#A\u0002+va2,G\u0007C\u0005\u0004\u001am\f\t\u00111\u0001\u0004H\tq!+\u001a2bY\u0006t7-Z#wK:$8cB?\u0002B\u0005U\u00151T\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016\u001c\u0015\r\u001c7cC\u000e\\7/\u0006\u0002\u0004(B1\u0011QKB\u001d\u0007\u000f\n1C]3cC2\fgnY3DC2d'-Y2lg\u0002\"Ba!,\u00040B\u0019\u00111S?\t\u0011\r\r\u0016\u0011\u0001a\u0001\u0007O\u000b!b^1t\u0013:4xn[3e\u0003-\tG\rZ\"bY2\u0014\u0017mY6\u0015\t\r56q\u0017\u0005\t\u0007s\u000b)\u00011\u0001\u0004H\u0005A1-\u00197mE\u0006\u001c7\u000e\u0006\u0003\u0004.\u000eu\u0006BCBR\u0003\u000f\u0001\n\u00111\u0001\u0004(V\u00111\u0011\u0019\u0016\u0005\u0007O\u0013)\u000b\u0006\u0003\u0002X\u000e\u0015\u0007BCAp\u0003\u001f\t\t\u00111\u0001\u0002NR!\u0011Q_Be\u0011)\ty.a\u0005\u0002\u0002\u0003\u0007\u0011q\u001b\u000b\u0005\u0003k\u001bi\r\u0003\u0006\u0002`\u0006U\u0011\u0011!a\u0001\u0003\u001b$B!!>\u0004R\"Q\u0011q\\A\u000e\u0003\u0003\u0005\r!a6\u0002\u001dI+'-\u00197b]\u000e,WI^3oiB!\u00111SA\u0010'\u0019\ty\"!\u0011\u0003rR\u00111Q[\u0001\u0005\u001d>tW-\u0006\u0002\u0004.\u0006)aj\u001c8fAQ!1QVBr\u0011!\u0019\u0019+a\nA\u0002\r\u001dF\u0003BBt\u0007S\u0004b!a\u0011\u0003^\r\u001d\u0006BCB\r\u0003S\t\t\u00111\u0001\u0004.\u0006A1/\u001a;uS:<7\u000f\u0005\u0003\u0004p\u000eEXBAA\u001a\u0013\u0011\u0019\u00190a\r\u0003!\r{gn];nKJ\u001cV\r\u001e;j]\u001e\u001c\b\u0003BA@\u0007oLAa!?\u00020\tq1i\u001c8tk6,'/Q2dKN\u001c\u0018\u0001F7bqJ+'-\u00197b]\u000e,G)\u001e:bi&|g\u000e\u0005\u0003\u0004\u0000\u0012\ra\u0002BA6\t\u0003IA!!*\u0002<%!AQ\u0001C\u0004\u0005!!UO]1uS>t\u0017\u0002\u0002C\u0005\u0003w\u0011a\u0002R;sCRLwN\\'pIVdW-A\rhKR\u001cUO\u001d:f]R\f5o]5h]\u0016$7\u000b\u001e:fC6\u001c\bCBB\u0000\t\u001f\u00199$\u0003\u0003\u0005\u0012\u0011M!aA+J\u001f*!\u0011QUA\u001e\u0003%\u0019w.\\7jiR,'\u000f\u0005\u0003\u0002\u0000\u0011e\u0011\u0002\u0002C\u000e\u0003_\u0011\u0011bQ8n[&$H/\u001a:\u0015\u001d\u0011}A\u0011\u0005C\u0012\tK!9\u0003\"\u000b\u0005,A\u0019\u0011q\u0010\u0001\t\u000f\u00055s\u00011\u0001\u0002R!911^\u0004A\u0002\r5\bbBA\u001b\u000f\u0001\u00071Q\u001f\u0005\b\u0007w<\u0001\u0019AB\u007f\u0011\u001d!Ya\u0002a\u0001\t\u001bAq\u0001\"\u0006\b\u0001\u0004!9\"\u0001\nd_6l\u0017\u000e\u001e+j[\u0016|W\u000f\u001e(b]>\u001cXC\u0001B1\u0003M\u0019w.\\7jiRKW.Z8vi:\u000bgn\\:!\u0003m\u0011Xm\u001d;beR\u001cFO]3b[N|eNU3cC2\fgnY5oO\u0006a\"/Z:uCJ$8\u000b\u001e:fC6\u001cxJ\u001c*fE\u0006d\u0017M\\2j]\u001e\u0004\u0013\u0001\u0006:fE\u0006d\u0017M\\2f'\u00064WmQ8n[&$8/A\u000bsK\n\fG.\u00198dKN\u000bg-Z\"p[6LGo\u001d\u0011\u0002\u001b\r|W.\\5u)&lWm\\;u+\t\u0019i0\u0001\bd_6l\u0017\u000e\u001e+j[\u0016|W\u000f\u001e\u0011\u0002/\r|W.\\5u#V,W/\u001a)pY2Le\u000e^3sm\u0006dWC\u0001C#!\u0011!9\u0005b\u0001\u000f\t\u0005UC\u0011A\u0001\u0019G>lW.\u001b;Rk\u0016,X\rU8mY&sG/\u001a:wC2\u0004\u0013\u0001F4fi\u0006sGMU3tKRd\u0015m\u001d;Fm\u0016tG/\u0006\u0002\u0005PA11q C\b\u0003C\n!\"\u001a8e'R\u0014X-Y7t)\u0011!)\u0006b\u0017\u0011\r\r}HqKAl\u0013\u0011!I\u0006b\u0005\u0003\tQ\u000b7o\u001b\u0005\b\t;\u001a\u0002\u0019AB\u001c\u00031\u0019HO]3b[N$v.\u00128e\u0003Q!w.Q<bSR\u001cFO]3b[\u000e{W.\\5ugR1A1\rC6\tw\u0002baa@\u0005X\u0011\u0015\u0004\u0003BA\"\tOJA\u0001\"\u001b\u0002F\t!QK\\5u\u0011\u001d\t)\u0004\u0006a\u0001\t[\u0002B\u0001b\u001c\u0005v9!\u0011Q\rC9\u0013\u0011!\u0019(a\f\u0002\u001d\r{gn];nKJ\f5mY3tg&!Aq\u000fC=\u0005Y\u0011\u0015\u0010^3BeJ\f\u0017pS1gW\u0006\u001cuN\\:v[\u0016\u0014(\u0002\u0002C:\u0003_Aq\u0001\"\u0018\u0015\u0001\u0004\u00199$A\nu_J+'-\u00197b]\u000e,G*[:uK:,'/\u0006\u0002\u0005\u0002B!1q\u001eCB\u0013\u0011!))a\r\u0003#I+'-\u00197b]\u000e,G*[:uK:,'\u000f")
public class RebalanceCoordinator {
    private final Ref.Synchronized<RebalanceEvent> lastRebalanceEvent;
    private final ConsumerAccess consumer;
    private final Duration maxRebalanceDuration;
    private final ZIO<Object, Nothing$, Chunk<PartitionStreamControl>> getCurrentAssignedStreams;
    private final Committer committer;
    private final long commitTimeoutNanos;
    private final boolean restartStreamsOnRebalancing;
    private final boolean rebalanceSafeCommits;
    private final Duration commitTimeout;
    private final Duration commitQueuePollInterval;

    private long commitTimeoutNanos() {
        return this.commitTimeoutNanos;
    }

    private boolean restartStreamsOnRebalancing() {
        return this.restartStreamsOnRebalancing;
    }

    private boolean rebalanceSafeCommits() {
        return this.rebalanceSafeCommits;
    }

    private Duration commitTimeout() {
        return this.commitTimeout;
    }

    private Duration commitQueuePollInterval() {
        return this.commitQueuePollInterval;
    }

    public ZIO<Object, Nothing$, RebalanceEvent> getAndResetLastEvent() {
        return this.lastRebalanceEvent.getAndSet((Object)RebalanceCoordinator$RebalanceEvent$.MODULE$.None(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.getAndResetLastEvent(RebalanceCoordinator.scala:42)");
    }

    private ZIO<Object, Throwable, Object> endStreams(Chunk<PartitionStreamControl> streamsToEnd) {
        return ZIO$.MODULE$.unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> streamsToEnd.isEmpty(), (Function0 & Serializable)() -> ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> streamsToEnd, (Function1 & Serializable)x$1 -> x$1.end(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:49)").flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            return $this.consumer.rebalanceListenerAccess((Function1 & Serializable)x$2 -> this.doAwaitStreamCommits((Consumer<byte[], byte[]>)x$2, streamsToEnd)).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.rebalanceSafeCommits(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:50)").map((Function1 & Serializable)x$3 -> {
                option = x$3;
                return BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:50)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:49)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:47)");
    }

    private ZIO<Object, Throwable, BoxedUnit> doAwaitStreamCommits(Consumer<byte[], byte[]> consumer, Chunk<PartitionStreamControl> streamsToEnd) {
        long deadline = System.nanoTime() + this.maxRebalanceDuration.toNanos() - this.commitTimeoutNanos();
        return this.logInitialStreamCompletionStatuses$1(streamsToEnd, deadline).flatMap((Function1 & Serializable)x$20 -> {
            BoxedUnit boxedUnit = x$20;
            return ZStream$.MODULE$.fromZIO((Function0 & Serializable)() -> package$.MODULE$.blockingSleep(this.commitQueuePollInterval()), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:156)").forever((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:157)").tap((Function1 & Serializable)x$13 -> $this.committer.processQueuedCommits(consumer, true), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:161)").takeWhile((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$22(deadline, x$14)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:162)").mapZIO((Function1 & Serializable)x$15 -> this.endingStreamsCompletedAndCommitsExist$1(streamsToEnd, deadline), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:163)").takeUntil((Function1 & Serializable)completed -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)completed)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:164)").runLast((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:165)").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$25(x$16)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:166)").flatMap((Function1 & Serializable)completed -> RebalanceCoordinator.$anonfun$doAwaitStreamCommits$27(this, streamsToEnd, consumer, BoxesRunTime.unboxToBoolean((Object)completed)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:154)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:153)");
    }

    public RebalanceListener toRebalanceListener() {
        return new RebalanceListener((Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)assignedTps -> $this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> {
            String sameRebalance = rebalanceEvent.wasInvoked() ? " in same rebalance" : "";
            return new StringBuilder(24).append(assignedTps.size()).append(" partitions are assigned").append(sameRebalance).toString();
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:191)").flatMap((Function1 & Serializable)x$24 -> {
            BoxedUnit boxedUnit = x$24;
            return $this.getCurrentAssignedStreams.flatMap((Function1 & Serializable)assignedStreams -> {
                Chunk streamsToEnd = this.restartStreamsOnRebalancing() && !rebalanceEvent.wasInvoked() ? assignedStreams : Chunk$.MODULE$.empty();
                return this.endStreams((Chunk<PartitionStreamControl>)streamsToEnd).flatMap((Function1 & Serializable)x$22 -> {
                    Object object = x$22;
                    return ZIO$.MODULE$.logTrace((Function0 & Serializable)() -> "onAssigned done", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:199)").map((Function1 & Serializable)x$21 -> {
                        BoxedUnit boxedUnit = x$21;
                        return rebalanceEvent.addCallback(new RebalanceCallback((Set<TopicPartition>)assignedTps, (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Chunk<PartitionStreamControl>)streamsToEnd));
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:199)");
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:198)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:195)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:191)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:189)"), (Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)revokedTps -> $this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> {
            String sameRebalance = rebalanceEvent.wasInvoked() ? " in same rebalance" : "";
            return new StringBuilder(23).append(revokedTps.size()).append(" partitions are revoked").append(sameRebalance).toString();
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:205)").flatMap((Function1 & Serializable)x$28 -> {
            BoxedUnit boxedUnit = x$28;
            return $this.getCurrentAssignedStreams.flatMap((Function1 & Serializable)assignedStreams -> {
                Chunk streamsToEnd = this.restartStreamsOnRebalancing() && !rebalanceEvent.wasInvoked() ? assignedStreams : assignedStreams.filter((Function1 & Serializable)control -> BoxesRunTime.boxToBoolean((boolean)revokedTps.contains((Object)control.tp())));
                return this.endStreams((Chunk<PartitionStreamControl>)streamsToEnd).flatMap((Function1 & Serializable)x$26 -> {
                    Object object = x$26;
                    return ZIO$.MODULE$.logTrace((Function0 & Serializable)() -> "onRevoked done", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:213)").map((Function1 & Serializable)x$25 -> {
                        BoxedUnit boxedUnit = x$25;
                        return rebalanceEvent.addCallback(new RebalanceCallback((Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)revokedTps, (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Chunk<PartitionStreamControl>)streamsToEnd));
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:213)");
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:212)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:209)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:205)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:203)"), (Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)lostTps -> $this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(20).append(lostTps.size()).append(" partitions are lost").toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:219)").flatMap((Function1 & Serializable)x$33 -> {
            BoxedUnit boxedUnit = x$33;
            return $this.getCurrentAssignedStreams.flatMap((Function1 & Serializable)assignedStreams -> {
                Chunk lostStreams = assignedStreams.filter((Function1 & Serializable)control -> BoxesRunTime.boxToBoolean((boolean)lostTps.contains((Object)control.tp())));
                return ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> lostStreams, (Function1 & Serializable)x$29 -> x$29.lost(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:222)").flatMap((Function1 & Serializable)x$31 -> {
                    BoxedUnit boxedUnit = x$31;
                    return ZIO$.MODULE$.logTrace((Function0 & Serializable)() -> "onLost done", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:223)").map((Function1 & Serializable)x$30 -> {
                        BoxedUnit boxedUnit = x$30;
                        return rebalanceEvent.addCallback(new RebalanceCallback((Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)lostTps, (Chunk<PartitionStreamControl>)lostStreams));
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:223)");
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:222)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:220)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:219)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:217)"));
    }

    private static final long timeToDeadlineMillis$1(long deadline$1) {
        return (deadline$1 - System.nanoTime()) / 1000000L;
    }

    private static final String completionStatusesAsString$1(Chunk completionStatuses) {
        return new StringBuilder(20).append("Revoked partitions: ").append(completionStatuses.map((Function1 & Serializable)x$5 -> x$5.toString()).mkString("; ")).toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ StreamCompletionStatus $anonfun$doAwaitStreamCommits$8(Committer.CommitOffsets committedOffsets$1, PartitionStreamControl stream$1, Map latestPendingCommitOffsets$1, boolean isDone$1, Option lastPulledOffset$1, Option endOffset) {
        block3: {
            block2: {
                var8_6 = false;
                var9_7 = null;
                var10_8 = endOffset;
                if (!(var10_8 instanceof Some)) break block2;
                var8_6 = true;
                var9_7 = (Some)var10_8;
                endOffset = (Offset)var9_7.value();
                if (!committedOffsets$1.contains(stream$1.tp(), endOffset.offset())) break block2;
                v0 /* !! */  = RebalanceCoordinator$EndOffsetCommitted$.MODULE$;
                break block3;
            }
            if (!var8_6) ** GOTO lbl-1000
            endOffset = (Offset)var9_7.value();
            if (latestPendingCommitOffsets$1.get((Object)stream$1.tp()).contains((Object)BoxesRunTime.boxToLong((long)endOffset.offset()))) {
                v0 /* !! */  = RebalanceCoordinator$EndOffsetCommitPending$.MODULE$;
            } else lbl-1000:
            // 2 sources

            {
                v0 /* !! */  = RebalanceCoordinator$EndOffsetNotCommitted$.MODULE$;
            }
        }
        endOffsetCommitStatus = v0 /* !! */ ;
        return new StreamCompletionStatus(stream$1.tp(), isDone$1, (Option<Object>)lastPulledOffset$1.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$doAwaitStreamCommits$9$adapted(zio.kafka.consumer.Offset ), (Lzio/kafka/consumer/Offset;)Ljava/lang/Object;)()), committedOffsets$1.get(stream$1.tp()), endOffsetCommitStatus);
    }

    public static final /* synthetic */ ZIO $anonfun$doAwaitStreamCommits$6(PartitionStreamControl stream$1, Committer.CommitOffsets committedOffsets$1, Map latestPendingCommitOffsets$1, boolean isDone) {
        return stream$1.lastPulledOffset().flatMap((Function1 & Serializable)lastPulledOffset -> (isDone ? stream$1.completedPromise().await((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:74)") : ZIO$.MODULE$.none()).map(arg_0 -> RebalanceCoordinator.$anonfun$doAwaitStreamCommits$8(committedOffsets$1, stream$1, latestPendingCommitOffsets$1, isDone, lastPulledOffset, arg_0), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:74)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:73)");
    }

    private final ZIO getStreamCompletionStatuses$1(Chunk streamsToEnd$2) {
        return this.committer.getCommittedOffsets().flatMap((Function1 & Serializable)committedOffsets -> $this.committer.getPendingCommits().map((Function1 & Serializable)x$6 -> x$6.offsets(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:68)").flatMap((Function1 & Serializable)latestPendingCommitOffsets -> ZIO$.MODULE$.foreach((Iterable)streamsToEnd$2, (Function1 & Serializable)stream -> stream.completedPromise().isDone((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:72)").flatMap((Function1 & Serializable)isDone -> RebalanceCoordinator.$anonfun$doAwaitStreamCommits$6(stream, committedOffsets, latestPendingCommitOffsets, BoxesRunTime.unboxToBoolean((Object)isDone)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:72)"), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:70)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:68)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:67)");
    }

    private static final ZIO logStreamCompletionStatuses$1(Chunk completionStatuses, Chunk streamsToEnd$2, long deadline$1) {
        String statusStrings = RebalanceCoordinator.completionStatusesAsString$1(completionStatuses);
        return ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(131).append("Delaying rebalance until ").append(streamsToEnd$2.size()).append(" streams (of revoked partitions) have committed ").append("the offsets of the records they consumed. Deadline in ").append(RebalanceCoordinator.timeToDeadlineMillis$1(deadline$1)).append("ms. ").append(statusStrings).toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logStreamCompletionStatuses(RebalanceCoordinator.scala:97)");
    }

    private final ZIO logInitialStreamCompletionStatuses$1(Chunk streamsToEnd$2, long deadline$1) {
        return this.getStreamCompletionStatuses$1(streamsToEnd$2).flatMap((Function1 & Serializable)completionStatuses -> RebalanceCoordinator.logStreamCompletionStatuses$1(completionStatuses, streamsToEnd$2, deadline$1), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logInitialStreamCompletionStatuses(RebalanceCoordinator.scala:105)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$14(StreamCompletionStatus status) {
        if (status.lastPulledOffset().isEmpty()) return true;
        if (!status.streamEnded()) return false;
        EndOffsetCommitStatus endOffsetCommitStatus = status.endOffsetCommitStatus();
        RebalanceCoordinator$EndOffsetNotCommitted$ rebalanceCoordinator$EndOffsetNotCommitted$ = RebalanceCoordinator$EndOffsetNotCommitted$.MODULE$;
        if (endOffsetCommitStatus == null) {
            if (rebalanceCoordinator$EndOffsetNotCommitted$ == null) return false;
            return true;
        } else if (endOffsetCommitStatus.equals(rebalanceCoordinator$EndOffsetNotCommitted$)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$13(Chunk completionStatuses$1, BoxedUnit x$10) {
        BoxedUnit boxedUnit = x$10;
        return completionStatuses$1.forall((Function1 & Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$14(status)));
    }

    private final ZIO endingStreamsCompletedAndCommitsExist$1(Chunk streamsToEnd$2, long deadline$1) {
        return this.getStreamCompletionStatuses$1(streamsToEnd$2).flatMap((Function1 & Serializable)completionStatuses -> RebalanceCoordinator.logStreamCompletionStatuses$1(completionStatuses, streamsToEnd$2, deadline$1).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$13(completionStatuses, x$10)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(RebalanceCoordinator.scala:112)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(RebalanceCoordinator.scala:111)");
    }

    private final ZIO logFinalStreamCompletionStatuses$1(boolean completed, Chunk streamsToEnd$2) {
        if (completed) {
            return ZIO$.MODULE$.logInfo((Function0 & Serializable)() -> "Continuing rebalance, all offsets of consumed records in the revoked partitions were committed.", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:120)");
        }
        return this.getStreamCompletionStatuses$1(streamsToEnd$2).flatMap((Function1 & Serializable)completionStatuses -> {
            String statusStrings = RebalanceCoordinator.completionStatusesAsString$1(completionStatuses);
            return ZIO$.MODULE$.logWarning((Function0 & Serializable)() -> new StringBuilder(208).append("Exceeded deadline waiting for streams (of revoked partitions) to commit the offsets of the records they consumed; the rebalance will continue. ").append("This might cause another consumer to process some records again. ").append(statusStrings).toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:126)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:123)");
    }

    private final ZIO commitSync$1(Consumer consumer$1) {
        return ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> consumer$1.commitSync(Collections.emptyMap(), this.commitTimeout()), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.commitSync(RebalanceCoordinator.scala:134)");
    }

    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$22(long deadline$1, BoxedUnit x$14) {
        return System.nanoTime() <= deadline$1;
    }

    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$25(Option x$16) {
        return BoxesRunTime.unboxToBoolean((Object)x$16.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public static final /* synthetic */ ZIO $anonfun$doAwaitStreamCommits$27(RebalanceCoordinator $this, Chunk streamsToEnd$2, Consumer consumer$1, boolean completed) {
        return $this.logFinalStreamCompletionStatuses$1(completed, streamsToEnd$2).flatMap((Function1 & Serializable)x$19 -> {
            BoxedUnit boxedUnit = x$19;
            return $this.commitSync$1(consumer$1).flatMap((Function1 & Serializable)x$18 -> {
                BoxedUnit boxedUnit = x$18;
                return ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(32).append("Done waiting for ").append(streamsToEnd$2.size()).append(" streams to end").toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:169)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:168)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:167)");
    }

    public RebalanceCoordinator(Ref.Synchronized<RebalanceEvent> lastRebalanceEvent, ConsumerSettings settings, ConsumerAccess consumer, Duration maxRebalanceDuration, ZIO<Object, Nothing$, Chunk<PartitionStreamControl>> getCurrentAssignedStreams, Committer committer) {
        this.lastRebalanceEvent = lastRebalanceEvent;
        this.consumer = consumer;
        this.maxRebalanceDuration = maxRebalanceDuration;
        this.getCurrentAssignedStreams = getCurrentAssignedStreams;
        this.committer = committer;
        this.commitTimeoutNanos = settings.commitTimeout().toNanos();
        this.restartStreamsOnRebalancing = settings.restartStreamOnRebalancing();
        this.rebalanceSafeCommits = settings.rebalanceSafeCommits();
        this.commitTimeout = settings.commitTimeout();
        this.commitQueuePollInterval = DurationSyntax$.MODULE$.millis$extension(zio.package$.MODULE$.durationInt(100));
    }

    public static final /* synthetic */ Object $anonfun$doAwaitStreamCommits$9$adapted(Offset x$7) {
        return BoxesRunTime.boxToLong((long)x$7.offset());
    }

    private static interface EndOffsetCommitStatus {
    }

    public static final class RebalanceCallback
    implements Product,
    Serializable {
        private final Set<TopicPartition> assignedTps;
        private final Set<TopicPartition> revokedTps;
        private final Set<TopicPartition> lostTps;
        private final Chunk<PartitionStreamControl> endedStreams;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Set<TopicPartition> assignedTps() {
            return this.assignedTps;
        }

        public Set<TopicPartition> revokedTps() {
            return this.revokedTps;
        }

        public Set<TopicPartition> lostTps() {
            return this.lostTps;
        }

        public Chunk<PartitionStreamControl> endedStreams() {
            return this.endedStreams;
        }

        public RebalanceCallback append(RebalanceCallback other) {
            return new RebalanceCallback((Set<TopicPartition>)((Set)((SetOps)this.assignedTps().$plus$plus(other.assignedTps())).$minus$minus(other.revokedTps()).$minus$minus(other.lostTps())), (Set<TopicPartition>)((Set)this.revokedTps().$plus$plus(other.revokedTps())), (Set<TopicPartition>)((Set)this.lostTps().$plus$plus(other.lostTps())), (Chunk<PartitionStreamControl>)this.endedStreams().$plus$plus(other.endedStreams()));
        }

        public RebalanceCallback copy(Set<TopicPartition> assignedTps, Set<TopicPartition> revokedTps, Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            return new RebalanceCallback(assignedTps, revokedTps, lostTps, endedStreams);
        }

        public Set<TopicPartition> copy$default$1() {
            return this.assignedTps();
        }

        public Set<TopicPartition> copy$default$2() {
            return this.revokedTps();
        }

        public Set<TopicPartition> copy$default$3() {
            return this.lostTps();
        }

        public Chunk<PartitionStreamControl> copy$default$4() {
            return this.endedStreams();
        }

        public String productPrefix() {
            return "RebalanceCallback";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.assignedTps();
                }
                case 1: {
                    return this.revokedTps();
                }
                case 2: {
                    return this.lostTps();
                }
                case 3: {
                    return this.endedStreams();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RebalanceCallback;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "assignedTps";
                }
                case 1: {
                    return "revokedTps";
                }
                case 2: {
                    return "lostTps";
                }
                case 3: {
                    return "endedStreams";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RebalanceCallback)) return false;
            boolean bl = true;
            if (!bl) return false;
            RebalanceCallback rebalanceCallback = (RebalanceCallback)x$1;
            Set<TopicPartition> set = this.assignedTps();
            Set<TopicPartition> set2 = rebalanceCallback.assignedTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<TopicPartition> set3 = this.revokedTps();
            Set<TopicPartition> set4 = rebalanceCallback.revokedTps();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            Set<TopicPartition> set5 = this.lostTps();
            Set<TopicPartition> set6 = rebalanceCallback.lostTps();
            if (set5 == null) {
                if (set6 != null) {
                    return false;
                }
            } else if (!set5.equals(set6)) return false;
            Chunk<PartitionStreamControl> chunk = this.endedStreams();
            Chunk<PartitionStreamControl> chunk2 = rebalanceCallback.endedStreams();
            if (chunk == null) {
                if (chunk2 == null) return true;
                return false;
            } else {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
        }

        public RebalanceCallback(Set<TopicPartition> assignedTps, Set<TopicPartition> revokedTps, Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            this.assignedTps = assignedTps;
            this.revokedTps = revokedTps;
            this.lostTps = lostTps;
            this.endedStreams = endedStreams;
            Product.$init$((Product)this);
        }
    }

    public static final class RebalanceEvent
    implements Product,
    Serializable {
        private final Chunk<RebalanceCallback> rebalanceCallbacks;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Chunk<RebalanceCallback> rebalanceCallbacks() {
            return this.rebalanceCallbacks;
        }

        public boolean wasInvoked() {
            return this.rebalanceCallbacks().nonEmpty();
        }

        public RebalanceEvent addCallback(RebalanceCallback callback) {
            return this.copy((Chunk<RebalanceCallback>)((Chunk)this.rebalanceCallbacks().$colon$plus((Object)callback)));
        }

        public RebalanceEvent copy(Chunk<RebalanceCallback> rebalanceCallbacks) {
            return new RebalanceEvent(rebalanceCallbacks);
        }

        public Chunk<RebalanceCallback> copy$default$1() {
            return this.rebalanceCallbacks();
        }

        public String productPrefix() {
            return "RebalanceEvent";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.rebalanceCallbacks();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RebalanceEvent;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "rebalanceCallbacks";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RebalanceEvent)) return false;
            boolean bl = true;
            if (!bl) return false;
            RebalanceEvent rebalanceEvent = (RebalanceEvent)x$1;
            Chunk<RebalanceCallback> chunk = this.rebalanceCallbacks();
            Chunk<RebalanceCallback> chunk2 = rebalanceEvent.rebalanceCallbacks();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public RebalanceEvent(Chunk<RebalanceCallback> rebalanceCallbacks) {
            this.rebalanceCallbacks = rebalanceCallbacks;
            Product.$init$((Product)this);
        }
    }

    private static final class StreamCompletionStatus
    implements Product,
    Serializable {
        private final TopicPartition tp;
        private final boolean streamEnded;
        private final Option<Object> lastPulledOffset;
        private final Option<Object> lastCommittedOffset;
        private final EndOffsetCommitStatus endOffsetCommitStatus;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public TopicPartition tp() {
            return this.tp;
        }

        public boolean streamEnded() {
            return this.streamEnded;
        }

        public Option<Object> lastPulledOffset() {
            return this.lastPulledOffset;
        }

        public Option<Object> lastCommittedOffset() {
            return this.lastCommittedOffset;
        }

        public EndOffsetCommitStatus endOffsetCommitStatus() {
            return this.endOffsetCommitStatus;
        }

        public String toString() {
            return new StringBuilder(49).append(this.tp()).append(": ").append((Object)(this.streamEnded() ? "stream ended" : "stream is running")).append(", ").append("last pulled offset=").append(this.lastPulledOffset().getOrElse((Function0 & Serializable)() -> "none")).append(", ").append("last committed offset=").append(this.lastCommittedOffset().getOrElse((Function0 & Serializable)() -> "none")).append(", ").append(this.endOffsetCommitStatus()).toString();
        }

        public StreamCompletionStatus copy(TopicPartition tp, boolean streamEnded, Option<Object> lastPulledOffset, Option<Object> lastCommittedOffset, EndOffsetCommitStatus endOffsetCommitStatus) {
            return new StreamCompletionStatus(tp, streamEnded, lastPulledOffset, lastCommittedOffset, endOffsetCommitStatus);
        }

        public TopicPartition copy$default$1() {
            return this.tp();
        }

        public boolean copy$default$2() {
            return this.streamEnded();
        }

        public Option<Object> copy$default$3() {
            return this.lastPulledOffset();
        }

        public Option<Object> copy$default$4() {
            return this.lastCommittedOffset();
        }

        public EndOffsetCommitStatus copy$default$5() {
            return this.endOffsetCommitStatus();
        }

        public String productPrefix() {
            return "StreamCompletionStatus";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.tp();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.streamEnded());
                }
                case 2: {
                    return this.lastPulledOffset();
                }
                case 3: {
                    return this.lastCommittedOffset();
                }
                case 4: {
                    return this.endOffsetCommitStatus();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StreamCompletionStatus;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "tp";
                }
                case 1: {
                    return "streamEnded";
                }
                case 2: {
                    return "lastPulledOffset";
                }
                case 3: {
                    return "lastCommittedOffset";
                }
                case 4: {
                    return "endOffsetCommitStatus";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tp()));
            n = Statics.mix((int)n, (int)(this.streamEnded() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastPulledOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastCommittedOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.endOffsetCommitStatus()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StreamCompletionStatus)) return false;
            boolean bl = true;
            if (!bl) return false;
            StreamCompletionStatus streamCompletionStatus = (StreamCompletionStatus)x$1;
            if (this.streamEnded() != streamCompletionStatus.streamEnded()) return false;
            TopicPartition topicPartition = this.tp();
            TopicPartition topicPartition2 = streamCompletionStatus.tp();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            Option<Object> option = this.lastPulledOffset();
            Option<Object> option2 = streamCompletionStatus.lastPulledOffset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.lastCommittedOffset();
            Option<Object> option4 = streamCompletionStatus.lastCommittedOffset();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            EndOffsetCommitStatus endOffsetCommitStatus = this.endOffsetCommitStatus();
            EndOffsetCommitStatus endOffsetCommitStatus2 = streamCompletionStatus.endOffsetCommitStatus();
            if (endOffsetCommitStatus == null) {
                if (endOffsetCommitStatus2 == null) return true;
                return false;
            } else {
                if (!endOffsetCommitStatus.equals(endOffsetCommitStatus2)) return false;
                return true;
            }
        }

        public StreamCompletionStatus(TopicPartition tp, boolean streamEnded, Option<Object> lastPulledOffset, Option<Object> lastCommittedOffset, EndOffsetCommitStatus endOffsetCommitStatus) {
            this.tp = tp;
            this.streamEnded = streamEnded;
            this.lastPulledOffset = lastPulledOffset;
            this.lastCommittedOffset = lastCommittedOffset;
            this.endOffsetCommitStatus = endOffsetCommitStatus;
            Product.$init$((Product)this);
        }
    }
}

