/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetCommitPending$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetCommitted$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetNotCommitted$;
import zio.kafka.consumer.internal.RebalanceCoordinator$RebalanceEvent$;
import zio.kafka.consumer.internal.package$;
import zio.stream.ZStream$;

@ScalaSignature(bytes="\u0006\u0005\u0011}d!CA\u0015\u0003W\u0001\u00111FA\u001e\u0011)\tI\u0005\u0001B\u0001B\u0003%\u0011Q\n\u0005\u000b\u0007O\u0004!\u0011!Q\u0001\n\r%\bBCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0004r\"Q1q\u001f\u0001\u0003\u0002\u0003\u0006Ia!?\t\u0015\u0011\u001d\u0001A!A!\u0002\u0013!I\u0001\u0003\u0006\u0005\u0012\u0001\u0011\t\u0011)A\u0005\t'Aq!a \u0001\t\u0003!I\u0002C\u0005\u0005*\u0001\u0011\r\u0011\"\u0003\u0005,!AAQ\u0006\u0001!\u0002\u0013\u0011i\u0006C\u0005\u00050\u0001\u0011\r\u0011\"\u0003\u0003P!AA\u0011\u0007\u0001!\u0002\u0013\t\t\u0010C\u0005\u00054\u0001\u0011\r\u0011\"\u0003\u00056!AAq\u0007\u0001!\u0002\u0013\u0019I\u0010C\u0005\u0005:\u0001\u0011\r\u0011\"\u0003\u0005<!AA\u0011\t\u0001!\u0002\u0013!i\u0004C\u0004\u0005D\u0001!\t\u0001\"\u0012\t\u000f\u0011%\u0003\u0001\"\u0003\u0005L!9Aq\u000b\u0001\u0005\n\u0011e\u0003b\u0002C;\u0001\u0011\u0005AqO\u0004\u000b\u0003o\nY\u0003#\u0001\u0002,\u0005edACA\u0015\u0003WA\t!a\u000b\u0002~!9\u0011qP\u000b\u0005\u0002\u0005\u0005e!CAB+A\u0005\u0019\u0013FAC\u000f\u001d\u00119#\u0006EE\u0005;1qAa\u0006\u0016\u0011\u0013\u0013I\u0002C\u0004\u0002\u0000e!\tAa\u0007\t\u000f\u00055\u0016\u0004\"\u0011\u00020\"I\u0011\u0011Y\r\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003\u000bL\u0012\u0011!C\u0001\u0003\u000fD\u0011\"a4\u001a\u0003\u0003%\tAa\b\t\u0013\u0005u\u0017$!A\u0005B\u0005}\u0007\"CAw3\u0005\u0005I\u0011\u0001B\u0012\u0011%\tI0GA\u0001\n\u0003\nY\u0010C\u0005\u0002~f\t\t\u0011\"\u0003\u0002\u0000\u001e9!\u0011F\u000b\t\n\u0006-faBAE+!%\u00151\u0012\u0005\b\u0003\u007f\"C\u0011AAU\u0011\u001d\ti\u000b\nC!\u0003_C\u0011\"!1%\u0003\u0003%\t%a1\t\u0013\u0005\u0015G%!A\u0005\u0002\u0005\u001d\u0007\"CAhI\u0005\u0005I\u0011AAi\u0011%\ti\u000eJA\u0001\n\u0003\ny\u000eC\u0005\u0002n\u0012\n\t\u0011\"\u0001\u0002p\"I\u0011\u0011 \u0013\u0002\u0002\u0013\u0005\u00131 \u0005\n\u0003{$\u0013\u0011!C\u0005\u0003\u007f<qAa\u000b\u0016\u0011\u0013\u0013iAB\u0004\u0003\bUAII!\u0003\t\u000f\u0005}t\u0006\"\u0001\u0003\f!9\u0011QV\u0018\u0005B\u0005=\u0006\"CAa_\u0005\u0005I\u0011IAb\u0011%\t)mLA\u0001\n\u0003\t9\rC\u0005\u0002P>\n\t\u0011\"\u0001\u0003\u0010!I\u0011Q\\\u0018\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003[|\u0013\u0011!C\u0001\u0005'A\u0011\"!?0\u0003\u0003%\t%a?\t\u0013\u0005ux&!A\u0005\n\u0005}hA\u0002B\u0017+\u0019\u0013y\u0003\u0003\u0006\u00032e\u0012)\u001a!C\u0001\u0005gA!Ba\u0013:\u0005#\u0005\u000b\u0011\u0002B\u001b\u0011)\u0011i%\u000fBK\u0002\u0013\u0005!q\n\u0005\u000b\u0005#J$\u0011#Q\u0001\n\u0005E\bB\u0003B*s\tU\r\u0011\"\u0001\u0003V!Q!1M\u001d\u0003\u0012\u0003\u0006IAa\u0016\t\u0015\t\u0015\u0014H!f\u0001\n\u0003\u0011)\u0006\u0003\u0006\u0003he\u0012\t\u0012)A\u0005\u0005/B!B!\u001b:\u0005+\u0007I\u0011\u0001B6\u0011)\u0011i'\u000fB\tB\u0003%\u0011Q\u0012\u0005\b\u0003\u007fJD\u0011\u0001B8\u0011\u001d\ti+\u000fC!\u0005{B\u0011B!$:\u0003\u0003%\tAa$\t\u0013\tm\u0015(%A\u0005\u0002\tu\u0005\"\u0003BZsE\u0005I\u0011\u0001B[\u0011%\u0011I,OI\u0001\n\u0003\u0011Y\fC\u0005\u0003@f\n\n\u0011\"\u0001\u0003<\"I!\u0011Y\u001d\u0012\u0002\u0013\u0005!1\u0019\u0005\n\u0003\u0003L\u0014\u0011!C!\u0003\u0007D\u0011\"!2:\u0003\u0003%\t!a2\t\u0013\u0005=\u0017(!A\u0005\u0002\t\u001d\u0007\"CAos\u0005\u0005I\u0011IAp\u0011%\ti/OA\u0001\n\u0003\u0011Y\rC\u0005\u0003Pf\n\t\u0011\"\u0011\u0003R\"I\u0011\u0011`\u001d\u0002\u0002\u0013\u0005\u00131 \u0005\n\u0005+L\u0014\u0011!C!\u0005/<\u0011Ba7\u0016\u0003\u0003EIA!8\u0007\u0013\t5R#!A\t\n\t}\u0007bBA@+\u0012\u0005!q\u001f\u0005\n\u0003[+\u0016\u0011!C#\u0003_C\u0011B!?V\u0003\u0003%\tIa?\t\u0013\r\u001dQ+!A\u0005\u0002\u000e%\u0001\"CA\u007f+\u0006\u0005I\u0011BA\u0000\r\u0019\u00199\"\u0006\"\u0004\u001a!Q11D.\u0003\u0016\u0004%\ta!\b\t\u0015\r\u00152L!E!\u0002\u0013\u0019y\u0002\u0003\u0006\u0004(m\u0013)\u001a!C\u0001\u0007;A!b!\u000b\\\u0005#\u0005\u000b\u0011BB\u0010\u0011)\u0019Yc\u0017BK\u0002\u0013\u00051Q\u0004\u0005\u000b\u0007[Y&\u0011#Q\u0001\n\r}\u0001BCB\u00187\nU\r\u0011\"\u0001\u00042!Q1qH.\u0003\u0012\u0003\u0006Iaa\r\t\u000f\u0005}4\f\"\u0001\u0004B!91QJ.\u0005\u0002\r=\u0003\"\u0003BG7\u0006\u0005I\u0011AB+\u0011%\u0011YjWI\u0001\n\u0003\u0019y\u0006C\u0005\u00034n\u000b\n\u0011\"\u0001\u0004`!I!\u0011X.\u0012\u0002\u0013\u00051q\f\u0005\n\u0005\u007f[\u0016\u0013!C\u0001\u0007GB\u0011\"!1\\\u0003\u0003%\t%a1\t\u0013\u0005\u00157,!A\u0005\u0002\u0005\u001d\u0007\"CAh7\u0006\u0005I\u0011AB4\u0011%\tinWA\u0001\n\u0003\ny\u000eC\u0005\u0002nn\u000b\t\u0011\"\u0001\u0004l!I!qZ.\u0002\u0002\u0013\u00053q\u000e\u0005\n\u0003s\\\u0016\u0011!C!\u0003wD\u0011\"!,\\\u0003\u0003%\t%a,\t\u0013\tU7,!A\u0005B\rMt!CB<+\u0005\u0005\t\u0012AB=\r%\u00199\"FA\u0001\u0012\u0003\u0019Y\bC\u0004\u0002\u0000U$\taa!\t\u0013\u00055V/!A\u0005F\u0005=\u0006\"\u0003B}k\u0006\u0005I\u0011QBC\u0011%\u00199!^A\u0001\n\u0003\u001by\tC\u0005\u0002~V\f\t\u0011\"\u0003\u0002\u0000\u001a111T\u000bC\u0007;C!ba(|\u0005+\u0007I\u0011ABQ\u0011)\u0019)k\u001fB\tB\u0003%11\u0015\u0005\b\u0003\u007fZH\u0011ABT\u0011\u001d\u0019ik\u001fC\u0001\u0005\u001fBqaa,|\t\u0003\u0019\t\fC\u0005\u0003\u000en\f\t\u0011\"\u0001\u00048\"I!1T>\u0012\u0002\u0013\u000511\u0018\u0005\n\u0003\u0003\\\u0018\u0011!C!\u0003\u0007D\u0011\"!2|\u0003\u0003%\t!a2\t\u0013\u0005=70!A\u0005\u0002\r}\u0006\"CAow\u0006\u0005I\u0011IAp\u0011%\tio_A\u0001\n\u0003\u0019\u0019\rC\u0005\u0003Pn\f\t\u0011\"\u0011\u0004H\"I\u0011\u0011`>\u0002\u0002\u0013\u0005\u00131 \u0005\n\u0003[[\u0018\u0011!C!\u0003_C\u0011B!6|\u0003\u0003%\tea3\b\u000f\r=W\u0003#\u0001\u0004R\u001a911T\u000b\t\u0002\rM\u0007\u0002CA@\u00037!\ta!6\t\u0015\r]\u00171\u0004b\u0001\n\u0003\u0019I\u000eC\u0005\u0004\\\u0006m\u0001\u0015!\u0003\u0004*\"Q!\u0011`A\u000e\u0003\u0003%\ti!8\t\u0015\r\u001d\u00111DA\u0001\n\u0003\u001b\t\u000f\u0003\u0006\u0002~\u0006m\u0011\u0011!C\u0005\u0003\u007f\u0014ACU3cC2\fgnY3D_>\u0014H-\u001b8bi>\u0014(\u0002BA\u0017\u0003_\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0005\u0003c\t\u0019$\u0001\u0005d_:\u001cX/\\3s\u0015\u0011\t)$a\u000e\u0002\u000b-\fgm[1\u000b\u0005\u0005e\u0012a\u0001>j_N\u0019\u0001!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R!!a\u0011\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0013\u0011\t\u0002\u0007\u0003:L(+\u001a4\u0002%1\f7\u000f\u001e*fE\u0006d\u0017M\\2f\u000bZ,g\u000e^\u0002\u0001!\u0019\ty%a\u0016\u0002^9!\u0011\u0011KA*\u001b\t\t9$\u0003\u0003\u0002V\u0005]\u0012a\u0001*fM&!\u0011\u0011LA.\u00051\u0019\u0016P\\2ie>t\u0017N_3e\u0015\u0011\t)&a\u000e\u0011\u0007\u0005}3PD\u0002\u0002bQqA!a\u0019\u0002v9!\u0011QMA:\u001d\u0011\t9'!\u001d\u000f\t\u0005%\u0014qN\u0007\u0003\u0003WRA!!\u001c\u0002L\u00051AH]8pizJ!!!\u000f\n\t\u0005U\u0012qG\u0005\u0005\u0003c\t\u0019$\u0003\u0003\u0002.\u0005=\u0012\u0001\u0006*fE\u0006d\u0017M\\2f\u0007>|'\u000fZ5oCR|'\u000fE\u0002\u0002|Ui!!a\u000b\u0014\u0007U\ti$\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003s\u0012Q#\u00128e\u001f\u001a47/\u001a;D_6l\u0017\u000e^*uCR,8oE\u0002\u0018\u0003{ICa\u0006\u001303\t1RI\u001c3PM\u001a\u001cX\r^\"p[6LG\u000fU3oI&twmE\u0005%\u0003{\ti)!%\u0002\u0018B\u0019\u0011qR\f\u000e\u0003U\u0001B!a\u0010\u0002\u0014&!\u0011QSA!\u0005\u001d\u0001&o\u001c3vGR\u0004B!!'\u0002$:!\u00111TAP\u001d\u0011\tI'!(\n\u0005\u0005\r\u0013\u0002BAQ\u0003\u0003\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0006\u001d&\u0001D*fe&\fG.\u001b>bE2,'\u0002BAQ\u0003\u0003\"\"!a+\u0011\u0007\u0005=E%\u0001\u0005u_N#(/\u001b8h)\t\t\t\f\u0005\u0003\u00024\u0006uVBAA[\u0015\u0011\t9,!/\u0002\t1\fgn\u001a\u0006\u0003\u0003w\u000bAA[1wC&!\u0011qXA[\u0005\u0019\u0019FO]5oO\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!-\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0007\u0003BA \u0003\u0017LA!!4\u0002B\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111[Am!\u0011\ty$!6\n\t\u0005]\u0017\u0011\t\u0002\u0004\u0003:L\b\"CAnS\u0005\u0005\t\u0019AAe\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001d\t\u0007\u0003G\fI/a5\u000e\u0005\u0005\u0015(\u0002BAt\u0003\u0003\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY/!:\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003c\f9\u0010\u0005\u0003\u0002@\u0005M\u0018\u0002BA{\u0003\u0003\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\\.\n\t\u00111\u0001\u0002T\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002J\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0001\t\u0005\u0003g\u0013\u0019!\u0003\u0003\u0003\u0006\u0005U&AB(cU\u0016\u001cGO\u0001\nF]\u0012|eMZ:fi\u000e{W.\\5ui\u0016$7#C\u0018\u0002>\u00055\u0015\u0011SAL)\t\u0011i\u0001E\u0002\u0002\u0010>\"B!a5\u0003\u0012!I\u00111\u001c\u001b\u0002\u0002\u0003\u0007\u0011\u0011\u001a\u000b\u0005\u0003c\u0014)\u0002C\u0005\u0002\\Z\n\t\u00111\u0001\u0002T\n)RI\u001c3PM\u001a\u001cX\r\u001e(pi\u000e{W.\\5ui\u0016$7#C\r\u0002>\u00055\u0015\u0011SAL)\t\u0011i\u0002E\u0002\u0002\u0010f!B!a5\u0003\"!I\u00111\u001c\u0010\u0002\u0002\u0003\u0007\u0011\u0011\u001a\u000b\u0005\u0003c\u0014)\u0003C\u0005\u0002\\\u0002\n\t\u00111\u0001\u0002T\u0006)RI\u001c3PM\u001a\u001cX\r\u001e(pi\u000e{W.\\5ui\u0016$\u0017AF#oI>3gm]3u\u0007>lW.\u001b;QK:$\u0017N\\4\u0002%\u0015sGm\u00144gg\u0016$8i\\7nSR$X\r\u001a\u0002\u0017'R\u0014X-Y7D_6\u0004H.\u001a;j_:\u001cF/\u0019;vgN9\u0011(!\u0010\u0002\u0012\u0006]\u0015A\u0001;q+\t\u0011)\u0004\u0005\u0003\u00038\t\u001dSB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\r\r|W.\\8o\u0015\u0011\t)Da\u0010\u000b\t\t\u0005#1I\u0001\u0007CB\f7\r[3\u000b\u0005\t\u0015\u0013aA8sO&!!\u0011\nB\u001d\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003-\u0019HO]3b[\u0016sG-\u001a3\u0016\u0005\u0005E\u0018\u0001D:ue\u0016\fW.\u00128eK\u0012\u0004\u0013\u0001\u00057bgR\u0004V\u000f\u001c7fI>3gm]3u+\t\u00119\u0006\u0005\u0004\u0002@\te#QL\u0005\u0005\u00057\n\tE\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u007f\u0011y&\u0003\u0003\u0003b\u0005\u0005#\u0001\u0002'p]\u001e\f\u0011\u0003\\1tiB+H\u000e\\3e\u001f\u001a47/\u001a;!\u0003Ma\u0017m\u001d;D_6l\u0017\u000e\u001e;fI>3gm]3u\u0003Qa\u0017m\u001d;D_6l\u0017\u000e\u001e;fI>3gm]3uA\u0005)RM\u001c3PM\u001a\u001cX\r^\"p[6LGo\u0015;biV\u001cXCAAG\u0003Y)g\u000eZ(gMN,GoQ8n[&$8\u000b^1ukN\u0004C\u0003\u0004B9\u0005g\u0012)Ha\u001e\u0003z\tm\u0004cAAHs!9!\u0011\u0007#A\u0002\tU\u0002b\u0002B'\t\u0002\u0007\u0011\u0011\u001f\u0005\b\u0005'\"\u0005\u0019\u0001B,\u0011\u001d\u0011)\u0007\u0012a\u0001\u0005/BqA!\u001bE\u0001\u0004\ti\t\u0006\u0002\u0003\u0000A!!\u0011\u0011BE\u001d\u0011\u0011\u0019I!\"\u0011\t\u0005%\u0014\u0011I\u0005\u0005\u0005\u000f\u000b\t%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\u0013YI\u0003\u0003\u0003\b\u0006\u0005\u0013\u0001B2paf$BB!\u001d\u0003\u0012\nM%Q\u0013BL\u00053C\u0011B!\rG!\u0003\u0005\rA!\u000e\t\u0013\t5c\t%AA\u0002\u0005E\b\"\u0003B*\rB\u0005\t\u0019\u0001B,\u0011%\u0011)G\u0012I\u0001\u0002\u0004\u00119\u0006C\u0005\u0003j\u0019\u0003\n\u00111\u0001\u0002\u000e\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BPU\u0011\u0011)D!),\u0005\t\r\u0006\u0003\u0002BS\u0005_k!Aa*\u000b\t\t%&1V\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!,\u0002B\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE&q\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005oSC!!=\u0003\"\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B_U\u0011\u00119F!)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001BcU\u0011\tiI!)\u0015\t\u0005M'\u0011\u001a\u0005\n\u00037t\u0015\u0011!a\u0001\u0003\u0013$B!!=\u0003N\"I\u00111\u001c)\u0002\u0002\u0003\u0007\u00111[\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u00022\nM\u0007\"CAn#\u0006\u0005\t\u0019AAe\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u001fBm\u0011%\tYnUA\u0001\u0002\u0004\t\u0019.\u0001\fTiJ,\u0017-\\\"p[BdW\r^5p]N#\u0018\r^;t!\r\ty)V\n\u0006+\n\u0005(Q\u001e\t\u0011\u0005G\u0014IO!\u000e\u0002r\n]#qKAG\u0005cj!A!:\u000b\t\t\u001d\u0018\u0011I\u0001\beVtG/[7f\u0013\u0011\u0011YO!:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0005\u0003\u0003p\nUXB\u0001By\u0015\u0011\u0011\u00190!/\u0002\u0005%|\u0017\u0002BAS\u0005c$\"A!8\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\tE$Q B\u0000\u0007\u0003\u0019\u0019a!\u0002\t\u000f\tE\u0002\f1\u0001\u00036!9!Q\n-A\u0002\u0005E\bb\u0002B*1\u0002\u0007!q\u000b\u0005\b\u0005KB\u0006\u0019\u0001B,\u0011\u001d\u0011I\u0007\u0017a\u0001\u0003\u001b\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\f\rM\u0001CBA \u00053\u001ai\u0001\u0005\b\u0002@\r=!QGAy\u0005/\u00129&!$\n\t\rE\u0011\u0011\t\u0002\u0007)V\u0004H.Z\u001b\t\u0013\rU\u0011,!AA\u0002\tE\u0014a\u0001=%a\t\t\"+\u001a2bY\u0006t7-Z\"bY2\u0014\u0017mY6\u0014\u000fm\u000bi$!%\u0002\u0018\u0006Y\u0011m]:jO:,G\r\u00169t+\t\u0019y\u0002\u0005\u0004\u0003\u0002\u000e\u0005\"QG\u0005\u0005\u0007G\u0011YIA\u0002TKR\fA\"Y:tS\u001etW\r\u001a+qg\u0002\n!B]3w_.,G\r\u00169t\u0003-\u0011XM^8lK\u0012$\u0006o\u001d\u0011\u0002\u000f1|7\u000f\u001e+qg\u0006AAn\\:u)B\u001c\b%\u0001\u0007f]\u0012,Gm\u0015;sK\u0006l7/\u0006\u0002\u00044A1\u0011\u0011KB\u001b\u0007sIAaa\u000e\u00028\t)1\t[;oWB!\u00111PB\u001e\u0013\u0011\u0019i$a\u000b\u0003-A\u000b'\u000f^5uS>t7\u000b\u001e:fC6\u001cuN\u001c;s_2\fQ\"\u001a8eK\u0012\u001cFO]3b[N\u0004CCCB\"\u0007\u000b\u001a9e!\u0013\u0004LA\u0019\u0011qR.\t\u000f\rmA\r1\u0001\u0004 !91q\u00053A\u0002\r}\u0001bBB\u0016I\u0002\u00071q\u0004\u0005\b\u0007_!\u0007\u0019AB\u001a\u0003\u0019\t\u0007\u000f]3oIR!11IB)\u0011\u001d\u0019\u0019&\u001aa\u0001\u0007\u0007\nQa\u001c;iKJ$\"ba\u0011\u0004X\re31LB/\u0011%\u0019YB\u001aI\u0001\u0002\u0004\u0019y\u0002C\u0005\u0004(\u0019\u0004\n\u00111\u0001\u0004 !I11\u00064\u0011\u0002\u0003\u00071q\u0004\u0005\n\u0007_1\u0007\u0013!a\u0001\u0007g)\"a!\u0019+\t\r}!\u0011U\u000b\u0003\u0007KRCaa\r\u0003\"R!\u00111[B5\u0011%\tY.\\A\u0001\u0002\u0004\tI\r\u0006\u0003\u0002r\u000e5\u0004\"CAn_\u0006\u0005\t\u0019AAj)\u0011\t\tl!\u001d\t\u0013\u0005m\u0007/!AA\u0002\u0005%G\u0003BAy\u0007kB\u0011\"a7t\u0003\u0003\u0005\r!a5\u0002#I+'-\u00197b]\u000e,7)\u00197mE\u0006\u001c7\u000eE\u0002\u0002\u0010V\u001cR!^B?\u0005[\u0004bBa9\u0004\u0000\r}1qDB\u0010\u0007g\u0019\u0019%\u0003\u0003\u0004\u0002\n\u0015(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u00111\u0011\u0010\u000b\u000b\u0007\u0007\u001a9i!#\u0004\f\u000e5\u0005bBB\u000eq\u0002\u00071q\u0004\u0005\b\u0007OA\b\u0019AB\u0010\u0011\u001d\u0019Y\u0003\u001fa\u0001\u0007?Aqaa\fy\u0001\u0004\u0019\u0019\u0004\u0006\u0003\u0004\u0012\u000ee\u0005CBA \u00053\u001a\u0019\n\u0005\u0007\u0002@\rU5qDB\u0010\u0007?\u0019\u0019$\u0003\u0003\u0004\u0018\u0006\u0005#A\u0002+va2,G\u0007C\u0005\u0004\u0016e\f\t\u00111\u0001\u0004D\tq!+\u001a2bY\u0006t7-Z#wK:$8cB>\u0002>\u0005E\u0015qS\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016\u001c\u0015\r\u001c7cC\u000e\\7/\u0006\u0002\u0004$B1\u0011\u0011KB\u001b\u0007\u0007\n1C]3cC2\fgnY3DC2d'-Y2lg\u0002\"Ba!+\u0004,B\u0019\u0011qR>\t\u000f\r}e\u00101\u0001\u0004$\u0006Qq/Y:J]Z|7.\u001a3\u0002\u0017\u0005$GmQ1mY\n\f7m\u001b\u000b\u0005\u0007S\u001b\u0019\f\u0003\u0005\u00046\u0006\u0005\u0001\u0019AB\"\u0003!\u0019\u0017\r\u001c7cC\u000e\\G\u0003BBU\u0007sC!ba(\u0002\u0004A\u0005\t\u0019ABR+\t\u0019iL\u000b\u0003\u0004$\n\u0005F\u0003BAj\u0007\u0003D!\"a7\u0002\f\u0005\u0005\t\u0019AAe)\u0011\t\tp!2\t\u0015\u0005m\u0017qBA\u0001\u0002\u0004\t\u0019\u000e\u0006\u0003\u00022\u000e%\u0007BCAn\u0003#\t\t\u00111\u0001\u0002JR!\u0011\u0011_Bg\u0011)\tY.a\u0006\u0002\u0002\u0003\u0007\u00111[\u0001\u000f%\u0016\u0014\u0017\r\\1oG\u0016,e/\u001a8u!\u0011\ty)a\u0007\u0014\r\u0005m\u0011Q\bBw)\t\u0019\t.\u0001\u0003O_:,WCABU\u0003\u0015quN\\3!)\u0011\u0019Ika8\t\u0011\r}\u00151\u0005a\u0001\u0007G#Baa9\u0004fB1\u0011q\bB-\u0007GC!b!\u0006\u0002&\u0005\u0005\t\u0019ABU\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003BBv\u0007[l!!a\f\n\t\r=\u0018q\u0006\u0002\u0011\u0007>t7/^7feN+G\u000f^5oON\u0004B!a\u001f\u0004t&!1Q_A\u0016\u00059\u0019uN\\:v[\u0016\u0014\u0018iY2fgN\fA#\\1y%\u0016\u0014\u0017\r\\1oG\u0016$UO]1uS>t\u0007\u0003BB~\u0007\u007ftA!a\u001a\u0004~&!\u0011\u0011UA\u001c\u0013\u0011!\t\u0001b\u0001\u0003\u0011\u0011+(/\u0019;j_:LA\u0001\"\u0002\u00028\tqA)\u001e:bi&|g.T8ek2,\u0017!G4fi\u000e+(O]3oi\u0006\u001b8/[4oK\u0012\u001cFO]3b[N\u0004baa?\u0005\f\rM\u0012\u0002\u0002C\u0007\t\u001f\u00111!V%P\u0015\u0011\t\t+a\u000e\u0002\u0013\r|W.\\5ui\u0016\u0014\b\u0003BA>\t+IA\u0001b\u0006\u0002,\tI1i\\7nSR$XM\u001d\u000b\u000f\t7!i\u0002b\b\u0005\"\u0011\rBQ\u0005C\u0014!\r\tY\b\u0001\u0005\b\u0003\u0013:\u0001\u0019AA'\u0011\u001d\u00199o\u0002a\u0001\u0007SDq!!\r\b\u0001\u0004\u0019\t\u0010C\u0004\u0004x\u001e\u0001\ra!?\t\u000f\u0011\u001dq\u00011\u0001\u0005\n!9A\u0011C\u0004A\u0002\u0011M\u0011AE2p[6LG\u000fV5nK>,HOT1o_N,\"A!\u0018\u0002'\r|W.\\5u)&lWm\\;u\u001d\u0006twn\u001d\u0011\u0002)I,'-\u00197b]\u000e,7+\u00194f\u0007>lW.\u001b;t\u0003U\u0011XMY1mC:\u001cWmU1gK\u000e{W.\\5ug\u0002\nQbY8n[&$H+[7f_V$XCAB}\u00039\u0019w.\\7jiRKW.Z8vi\u0002\nqcY8n[&$\u0018+^3vKB{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0005\u0011u\u0002\u0003\u0002C \u0007\u007ftA!!\u0015\u0004~\u0006A2m\\7nSR\fV/Z;f!>dG.\u00138uKJ4\u0018\r\u001c\u0011\u0002)\u001d,G/\u00118e%\u0016\u001cX\r\u001e'bgR,e/\u001a8u+\t!9\u0005\u0005\u0004\u0004|\u0012-\u0011QL\u0001\u000bK:$7\u000b\u001e:fC6\u001cH\u0003\u0002C'\t'\u0002baa?\u0005P\u0005M\u0017\u0002\u0002C)\t\u001f\u0011A\u0001V1tW\"9AQK\tA\u0002\rM\u0012\u0001D:ue\u0016\fWn\u001d+p\u000b:$\u0017\u0001\u00063p\u0003^\f\u0017\u000e^*ue\u0016\fWnQ8n[&$8\u000f\u0006\u0004\u0005\\\u0011\rD1\u000f\t\u0007\u0007w$y\u0005\"\u0018\u0011\t\u0005}BqL\u0005\u0005\tC\n\tE\u0001\u0003V]&$\bbBA\u0019%\u0001\u0007AQ\r\t\u0005\tO\"iG\u0004\u0003\u0002b\u0011%\u0014\u0002\u0002C6\u0003W\tabQ8ogVlWM]!dG\u0016\u001c8/\u0003\u0003\u0005p\u0011E$A\u0006\"zi\u0016\f%O]1z\u0017\u000647.Y\"p]N,X.\u001a:\u000b\t\u0011-\u00141\u0006\u0005\b\t+\u0012\u0002\u0019AB\u001a\u0003M!xNU3cC2\fgnY3MSN$XM\\3s+\t!I\b\u0005\u0003\u0004l\u0012m\u0014\u0002\u0002C?\u0003_\u0011\u0011CU3cC2\fgnY3MSN$XM\\3s\u0001")
public class RebalanceCoordinator {
    private final Ref.Synchronized<RebalanceEvent> lastRebalanceEvent;
    private final ConsumerAccess consumer;
    private final Duration maxRebalanceDuration;
    private final ZIO<Object, Nothing$, Chunk<PartitionStreamControl>> getCurrentAssignedStreams;
    private final Committer committer;
    private final long commitTimeoutNanos;
    private final boolean rebalanceSafeCommits;
    private final Duration commitTimeout;
    private final Duration commitQueuePollInterval;

    private long commitTimeoutNanos() {
        return this.commitTimeoutNanos;
    }

    private boolean rebalanceSafeCommits() {
        return this.rebalanceSafeCommits;
    }

    private Duration commitTimeout() {
        return this.commitTimeout;
    }

    private Duration commitQueuePollInterval() {
        return this.commitQueuePollInterval;
    }

    public ZIO<Object, Nothing$, RebalanceEvent> getAndResetLastEvent() {
        return this.lastRebalanceEvent.getAndSet((Object)RebalanceCoordinator$RebalanceEvent$.MODULE$.None(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.getAndResetLastEvent(RebalanceCoordinator.scala:41)");
    }

    private ZIO<Object, Throwable, Object> endStreams(Chunk<PartitionStreamControl> streamsToEnd) {
        return ZIO$.MODULE$.unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> streamsToEnd.isEmpty(), (Function0 & Serializable)() -> ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> streamsToEnd, (Function1 & Serializable)x$1 -> x$1.end(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:48)").flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            return $this.consumer.rebalanceListenerAccess((Function1 & Serializable)x$2 -> this.doAwaitStreamCommits((Consumer<byte[], byte[]>)x$2, streamsToEnd)).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.rebalanceSafeCommits(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:49)").map((Function1 & Serializable)x$3 -> {
                option = x$3;
                return BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:49)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:48)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:46)");
    }

    private ZIO<Object, Throwable, BoxedUnit> doAwaitStreamCommits(Consumer<byte[], byte[]> consumer, Chunk<PartitionStreamControl> streamsToEnd) {
        long deadline = System.nanoTime() + this.maxRebalanceDuration.toNanos() - this.commitTimeoutNanos();
        return this.logInitialStreamCompletionStatuses$1(streamsToEnd, deadline).flatMap((Function1 & Serializable)x$20 -> {
            BoxedUnit boxedUnit = x$20;
            return ZStream$.MODULE$.fromZIO((Function0 & Serializable)() -> package$.MODULE$.blockingSleep(this.commitQueuePollInterval()), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:155)").forever((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:156)").tap((Function1 & Serializable)x$13 -> $this.committer.processQueuedCommits(consumer, true), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:160)").takeWhile((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$22(deadline, x$14)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:161)").mapZIO((Function1 & Serializable)x$15 -> this.endingStreamsCompletedAndCommitsExist$1(streamsToEnd, deadline), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:162)").takeUntil((Function1 & Serializable)completed -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)completed)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:163)").runLast((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:164)").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$25(x$16)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:165)").flatMap((Function1 & Serializable)completed -> RebalanceCoordinator.$anonfun$doAwaitStreamCommits$27(this, streamsToEnd, consumer, BoxesRunTime.unboxToBoolean((Object)completed)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:153)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:152)");
    }

    public RebalanceListener toRebalanceListener() {
        return new RebalanceListener((Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)assignedTps -> $this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> {
            String sameRebalance = rebalanceEvent.wasInvoked() ? " in same rebalance" : "";
            return new StringBuilder(24).append(assignedTps.size()).append(" partitions are assigned").append(sameRebalance).toString();
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:189)").as((Function0 & Serializable)() -> rebalanceEvent.addCallback(new RebalanceCallback((Set<TopicPartition>)assignedTps, (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Chunk<PartitionStreamControl>)Chunk$.MODULE$.empty())), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:192)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:188)"), (Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)revokedTps -> $this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> {
            String sameRebalance = rebalanceEvent.wasInvoked() ? " in same rebalance" : "";
            return new StringBuilder(23).append(revokedTps.size()).append(" partitions are revoked").append(sameRebalance).toString();
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:199)").flatMap((Function1 & Serializable)x$24 -> {
            BoxedUnit boxedUnit = x$24;
            return $this.getCurrentAssignedStreams.flatMap((Function1 & Serializable)assignedStreams -> {
                Chunk streamsToEnd = assignedStreams.filter((Function1 & Serializable)control -> BoxesRunTime.boxToBoolean((boolean)revokedTps.contains((Object)control.tp())));
                return this.endStreams((Chunk<PartitionStreamControl>)streamsToEnd).flatMap((Function1 & Serializable)x$22 -> {
                    Object object = x$22;
                    return ZIO$.MODULE$.logTrace((Function0 & Serializable)() -> "onRevoked done", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:206)").map((Function1 & Serializable)x$21 -> {
                        BoxedUnit boxedUnit = x$21;
                        return rebalanceEvent.addCallback(new RebalanceCallback((Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)revokedTps, (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Chunk<PartitionStreamControl>)streamsToEnd));
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:206)");
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:205)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:203)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:199)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:197)"), (Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)lostTps -> $this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(20).append(lostTps.size()).append(" partitions are lost").toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:212)").flatMap((Function1 & Serializable)x$29 -> {
            BoxedUnit boxedUnit = x$29;
            return $this.getCurrentAssignedStreams.flatMap((Function1 & Serializable)assignedStreams -> {
                Chunk lostStreams = assignedStreams.filter((Function1 & Serializable)control -> BoxesRunTime.boxToBoolean((boolean)lostTps.contains((Object)control.tp())));
                return ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> lostStreams, (Function1 & Serializable)x$25 -> x$25.end(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:215)").flatMap((Function1 & Serializable)x$27 -> {
                    BoxedUnit boxedUnit = x$27;
                    return ZIO$.MODULE$.logTrace((Function0 & Serializable)() -> "onLost done", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:216)").map((Function1 & Serializable)x$26 -> {
                        BoxedUnit boxedUnit = x$26;
                        return rebalanceEvent.addCallback(new RebalanceCallback((Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)lostTps, (Chunk<PartitionStreamControl>)lostStreams));
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:216)");
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:215)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:213)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:212)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:210)"));
    }

    private static final long timeToDeadlineMillis$1(long deadline$1) {
        return (deadline$1 - System.nanoTime()) / 1000000L;
    }

    private static final String completionStatusesAsString$1(Chunk completionStatuses) {
        return new StringBuilder(20).append("Revoked partitions: ").append(completionStatuses.map((Function1 & Serializable)x$5 -> x$5.toString()).mkString("; ")).toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ StreamCompletionStatus $anonfun$doAwaitStreamCommits$8(Committer.CommitOffsets committedOffsets$1, PartitionStreamControl stream$1, Map latestPendingCommitOffsets$1, boolean isDone$1, Option lastPulledOffset$1, Option endOffset) {
        block3: {
            block2: {
                var8_6 = false;
                var9_7 = null;
                var10_8 = endOffset;
                if (!(var10_8 instanceof Some)) break block2;
                var8_6 = true;
                var9_7 = (Some)var10_8;
                endOffset = (Offset)var9_7.value();
                if (!committedOffsets$1.contains(stream$1.tp(), endOffset.offset())) break block2;
                v0 /* !! */  = RebalanceCoordinator$EndOffsetCommitted$.MODULE$;
                break block3;
            }
            if (!var8_6) ** GOTO lbl-1000
            endOffset = (Offset)var9_7.value();
            if (latestPendingCommitOffsets$1.get((Object)stream$1.tp()).contains((Object)BoxesRunTime.boxToLong((long)endOffset.offset()))) {
                v0 /* !! */  = RebalanceCoordinator$EndOffsetCommitPending$.MODULE$;
            } else lbl-1000:
            // 2 sources

            {
                v0 /* !! */  = RebalanceCoordinator$EndOffsetNotCommitted$.MODULE$;
            }
        }
        endOffsetCommitStatus = v0 /* !! */ ;
        return new StreamCompletionStatus(stream$1.tp(), isDone$1, (Option<Object>)lastPulledOffset$1.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$doAwaitStreamCommits$9$adapted(zio.kafka.consumer.Offset ), (Lzio/kafka/consumer/Offset;)Ljava/lang/Object;)()), committedOffsets$1.get(stream$1.tp()), endOffsetCommitStatus);
    }

    public static final /* synthetic */ ZIO $anonfun$doAwaitStreamCommits$6(PartitionStreamControl stream$1, Committer.CommitOffsets committedOffsets$1, Map latestPendingCommitOffsets$1, boolean isDone) {
        return stream$1.lastPulledOffset().flatMap((Function1 & Serializable)lastPulledOffset -> (isDone ? stream$1.completedPromise().await((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:73)") : ZIO$.MODULE$.none()).map(arg_0 -> RebalanceCoordinator.$anonfun$doAwaitStreamCommits$8(committedOffsets$1, stream$1, latestPendingCommitOffsets$1, isDone, lastPulledOffset, arg_0), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:73)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:72)");
    }

    private final ZIO getStreamCompletionStatuses$1(Chunk streamsToEnd$2) {
        return this.committer.getCommittedOffsets().flatMap((Function1 & Serializable)committedOffsets -> $this.committer.getPendingCommits().map((Function1 & Serializable)x$6 -> x$6.offsets(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:67)").flatMap((Function1 & Serializable)latestPendingCommitOffsets -> ZIO$.MODULE$.foreach((Iterable)streamsToEnd$2, (Function1 & Serializable)stream -> stream.completedPromise().isDone((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:71)").flatMap((Function1 & Serializable)isDone -> RebalanceCoordinator.$anonfun$doAwaitStreamCommits$6(stream, committedOffsets, latestPendingCommitOffsets, BoxesRunTime.unboxToBoolean((Object)isDone)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:71)"), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:69)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:67)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:66)");
    }

    private static final ZIO logStreamCompletionStatuses$1(Chunk completionStatuses, Chunk streamsToEnd$2, long deadline$1) {
        String statusStrings = RebalanceCoordinator.completionStatusesAsString$1(completionStatuses);
        return ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(131).append("Delaying rebalance until ").append(streamsToEnd$2.size()).append(" streams (of revoked partitions) have committed ").append("the offsets of the records they consumed. Deadline in ").append(RebalanceCoordinator.timeToDeadlineMillis$1(deadline$1)).append("ms. ").append(statusStrings).toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logStreamCompletionStatuses(RebalanceCoordinator.scala:96)");
    }

    private final ZIO logInitialStreamCompletionStatuses$1(Chunk streamsToEnd$2, long deadline$1) {
        return this.getStreamCompletionStatuses$1(streamsToEnd$2).flatMap((Function1 & Serializable)completionStatuses -> RebalanceCoordinator.logStreamCompletionStatuses$1(completionStatuses, streamsToEnd$2, deadline$1), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logInitialStreamCompletionStatuses(RebalanceCoordinator.scala:104)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$14(StreamCompletionStatus status) {
        if (status.lastPulledOffset().isEmpty()) return true;
        if (!status.streamEnded()) return false;
        EndOffsetCommitStatus endOffsetCommitStatus = status.endOffsetCommitStatus();
        RebalanceCoordinator$EndOffsetNotCommitted$ rebalanceCoordinator$EndOffsetNotCommitted$ = RebalanceCoordinator$EndOffsetNotCommitted$.MODULE$;
        if (endOffsetCommitStatus == null) {
            if (rebalanceCoordinator$EndOffsetNotCommitted$ == null) return false;
            return true;
        } else if (endOffsetCommitStatus.equals(rebalanceCoordinator$EndOffsetNotCommitted$)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$13(Chunk completionStatuses$1, BoxedUnit x$10) {
        BoxedUnit boxedUnit = x$10;
        return completionStatuses$1.forall((Function1 & Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$14(status)));
    }

    private final ZIO endingStreamsCompletedAndCommitsExist$1(Chunk streamsToEnd$2, long deadline$1) {
        return this.getStreamCompletionStatuses$1(streamsToEnd$2).flatMap((Function1 & Serializable)completionStatuses -> RebalanceCoordinator.logStreamCompletionStatuses$1(completionStatuses, streamsToEnd$2, deadline$1).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)RebalanceCoordinator.$anonfun$doAwaitStreamCommits$13(completionStatuses, x$10)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(RebalanceCoordinator.scala:111)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(RebalanceCoordinator.scala:110)");
    }

    private final ZIO logFinalStreamCompletionStatuses$1(boolean completed, Chunk streamsToEnd$2) {
        if (completed) {
            return ZIO$.MODULE$.logInfo((Function0 & Serializable)() -> "Continuing rebalance, all offsets of consumed records in the revoked partitions were committed.", (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:119)");
        }
        return this.getStreamCompletionStatuses$1(streamsToEnd$2).flatMap((Function1 & Serializable)completionStatuses -> {
            String statusStrings = RebalanceCoordinator.completionStatusesAsString$1(completionStatuses);
            return ZIO$.MODULE$.logWarning((Function0 & Serializable)() -> new StringBuilder(208).append("Exceeded deadline waiting for streams (of revoked partitions) to commit the offsets of the records they consumed; the rebalance will continue. ").append("This might cause another consumer to process some records again. ").append(statusStrings).toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:125)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:122)");
    }

    private final ZIO commitSync$1(Consumer consumer$1) {
        return ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> consumer$1.commitSync(Collections.emptyMap(), this.commitTimeout()), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.commitSync(RebalanceCoordinator.scala:133)");
    }

    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$22(long deadline$1, BoxedUnit x$14) {
        return System.nanoTime() <= deadline$1;
    }

    public static final /* synthetic */ boolean $anonfun$doAwaitStreamCommits$25(Option x$16) {
        return BoxesRunTime.unboxToBoolean((Object)x$16.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public static final /* synthetic */ ZIO $anonfun$doAwaitStreamCommits$27(RebalanceCoordinator $this, Chunk streamsToEnd$2, Consumer consumer$1, boolean completed) {
        return $this.logFinalStreamCompletionStatuses$1(completed, streamsToEnd$2).flatMap((Function1 & Serializable)x$19 -> {
            BoxedUnit boxedUnit = x$19;
            return $this.commitSync$1(consumer$1).flatMap((Function1 & Serializable)x$18 -> {
                BoxedUnit boxedUnit = x$18;
                return ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(32).append("Done waiting for ").append(streamsToEnd$2.size()).append(" streams to end").toString(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:168)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:167)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:166)");
    }

    public RebalanceCoordinator(Ref.Synchronized<RebalanceEvent> lastRebalanceEvent, ConsumerSettings settings, ConsumerAccess consumer, Duration maxRebalanceDuration, ZIO<Object, Nothing$, Chunk<PartitionStreamControl>> getCurrentAssignedStreams, Committer committer) {
        this.lastRebalanceEvent = lastRebalanceEvent;
        this.consumer = consumer;
        this.maxRebalanceDuration = maxRebalanceDuration;
        this.getCurrentAssignedStreams = getCurrentAssignedStreams;
        this.committer = committer;
        this.commitTimeoutNanos = settings.commitTimeout().toNanos();
        this.rebalanceSafeCommits = settings.rebalanceSafeCommits();
        this.commitTimeout = settings.commitTimeout();
        this.commitQueuePollInterval = DurationSyntax$.MODULE$.millis$extension(zio.package$.MODULE$.durationInt(100));
    }

    public static final /* synthetic */ Object $anonfun$doAwaitStreamCommits$9$adapted(Offset x$7) {
        return BoxesRunTime.boxToLong((long)x$7.offset());
    }

    private static interface EndOffsetCommitStatus {
    }

    public static final class RebalanceCallback
    implements Product,
    Serializable {
        private final Set<TopicPartition> assignedTps;
        private final Set<TopicPartition> revokedTps;
        private final Set<TopicPartition> lostTps;
        private final Chunk<PartitionStreamControl> endedStreams;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Set<TopicPartition> assignedTps() {
            return this.assignedTps;
        }

        public Set<TopicPartition> revokedTps() {
            return this.revokedTps;
        }

        public Set<TopicPartition> lostTps() {
            return this.lostTps;
        }

        public Chunk<PartitionStreamControl> endedStreams() {
            return this.endedStreams;
        }

        public RebalanceCallback append(RebalanceCallback other) {
            return new RebalanceCallback((Set<TopicPartition>)((Set)((SetOps)this.assignedTps().$plus$plus(other.assignedTps())).$minus$minus(other.revokedTps()).$minus$minus(other.lostTps())), (Set<TopicPartition>)((Set)this.revokedTps().$plus$plus(other.revokedTps())), (Set<TopicPartition>)((Set)this.lostTps().$plus$plus(other.lostTps())), (Chunk<PartitionStreamControl>)this.endedStreams().$plus$plus(other.endedStreams()));
        }

        public RebalanceCallback copy(Set<TopicPartition> assignedTps, Set<TopicPartition> revokedTps, Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            return new RebalanceCallback(assignedTps, revokedTps, lostTps, endedStreams);
        }

        public Set<TopicPartition> copy$default$1() {
            return this.assignedTps();
        }

        public Set<TopicPartition> copy$default$2() {
            return this.revokedTps();
        }

        public Set<TopicPartition> copy$default$3() {
            return this.lostTps();
        }

        public Chunk<PartitionStreamControl> copy$default$4() {
            return this.endedStreams();
        }

        public String productPrefix() {
            return "RebalanceCallback";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.assignedTps();
                }
                case 1: {
                    return this.revokedTps();
                }
                case 2: {
                    return this.lostTps();
                }
                case 3: {
                    return this.endedStreams();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RebalanceCallback;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "assignedTps";
                }
                case 1: {
                    return "revokedTps";
                }
                case 2: {
                    return "lostTps";
                }
                case 3: {
                    return "endedStreams";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RebalanceCallback)) return false;
            boolean bl = true;
            if (!bl) return false;
            RebalanceCallback rebalanceCallback = (RebalanceCallback)x$1;
            Set<TopicPartition> set = this.assignedTps();
            Set<TopicPartition> set2 = rebalanceCallback.assignedTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<TopicPartition> set3 = this.revokedTps();
            Set<TopicPartition> set4 = rebalanceCallback.revokedTps();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            Set<TopicPartition> set5 = this.lostTps();
            Set<TopicPartition> set6 = rebalanceCallback.lostTps();
            if (set5 == null) {
                if (set6 != null) {
                    return false;
                }
            } else if (!set5.equals(set6)) return false;
            Chunk<PartitionStreamControl> chunk = this.endedStreams();
            Chunk<PartitionStreamControl> chunk2 = rebalanceCallback.endedStreams();
            if (chunk == null) {
                if (chunk2 == null) return true;
                return false;
            } else {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
        }

        public RebalanceCallback(Set<TopicPartition> assignedTps, Set<TopicPartition> revokedTps, Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            this.assignedTps = assignedTps;
            this.revokedTps = revokedTps;
            this.lostTps = lostTps;
            this.endedStreams = endedStreams;
            Product.$init$((Product)this);
        }
    }

    public static final class RebalanceEvent
    implements Product,
    Serializable {
        private final Chunk<RebalanceCallback> rebalanceCallbacks;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Chunk<RebalanceCallback> rebalanceCallbacks() {
            return this.rebalanceCallbacks;
        }

        public boolean wasInvoked() {
            return this.rebalanceCallbacks().nonEmpty();
        }

        public RebalanceEvent addCallback(RebalanceCallback callback) {
            return this.copy((Chunk<RebalanceCallback>)((Chunk)this.rebalanceCallbacks().$colon$plus((Object)callback)));
        }

        public RebalanceEvent copy(Chunk<RebalanceCallback> rebalanceCallbacks) {
            return new RebalanceEvent(rebalanceCallbacks);
        }

        public Chunk<RebalanceCallback> copy$default$1() {
            return this.rebalanceCallbacks();
        }

        public String productPrefix() {
            return "RebalanceEvent";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.rebalanceCallbacks();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RebalanceEvent;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "rebalanceCallbacks";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RebalanceEvent)) return false;
            boolean bl = true;
            if (!bl) return false;
            RebalanceEvent rebalanceEvent = (RebalanceEvent)x$1;
            Chunk<RebalanceCallback> chunk = this.rebalanceCallbacks();
            Chunk<RebalanceCallback> chunk2 = rebalanceEvent.rebalanceCallbacks();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public RebalanceEvent(Chunk<RebalanceCallback> rebalanceCallbacks) {
            this.rebalanceCallbacks = rebalanceCallbacks;
            Product.$init$((Product)this);
        }
    }

    private static final class StreamCompletionStatus
    implements Product,
    Serializable {
        private final TopicPartition tp;
        private final boolean streamEnded;
        private final Option<Object> lastPulledOffset;
        private final Option<Object> lastCommittedOffset;
        private final EndOffsetCommitStatus endOffsetCommitStatus;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public TopicPartition tp() {
            return this.tp;
        }

        public boolean streamEnded() {
            return this.streamEnded;
        }

        public Option<Object> lastPulledOffset() {
            return this.lastPulledOffset;
        }

        public Option<Object> lastCommittedOffset() {
            return this.lastCommittedOffset;
        }

        public EndOffsetCommitStatus endOffsetCommitStatus() {
            return this.endOffsetCommitStatus;
        }

        public String toString() {
            return new StringBuilder(49).append(this.tp()).append(": ").append((Object)(this.streamEnded() ? "stream ended" : "stream is running")).append(", ").append("last pulled offset=").append(this.lastPulledOffset().getOrElse((Function0 & Serializable)() -> "none")).append(", ").append("last committed offset=").append(this.lastCommittedOffset().getOrElse((Function0 & Serializable)() -> "none")).append(", ").append(this.endOffsetCommitStatus()).toString();
        }

        public StreamCompletionStatus copy(TopicPartition tp, boolean streamEnded, Option<Object> lastPulledOffset, Option<Object> lastCommittedOffset, EndOffsetCommitStatus endOffsetCommitStatus) {
            return new StreamCompletionStatus(tp, streamEnded, lastPulledOffset, lastCommittedOffset, endOffsetCommitStatus);
        }

        public TopicPartition copy$default$1() {
            return this.tp();
        }

        public boolean copy$default$2() {
            return this.streamEnded();
        }

        public Option<Object> copy$default$3() {
            return this.lastPulledOffset();
        }

        public Option<Object> copy$default$4() {
            return this.lastCommittedOffset();
        }

        public EndOffsetCommitStatus copy$default$5() {
            return this.endOffsetCommitStatus();
        }

        public String productPrefix() {
            return "StreamCompletionStatus";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.tp();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.streamEnded());
                }
                case 2: {
                    return this.lastPulledOffset();
                }
                case 3: {
                    return this.lastCommittedOffset();
                }
                case 4: {
                    return this.endOffsetCommitStatus();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StreamCompletionStatus;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "tp";
                }
                case 1: {
                    return "streamEnded";
                }
                case 2: {
                    return "lastPulledOffset";
                }
                case 3: {
                    return "lastCommittedOffset";
                }
                case 4: {
                    return "endOffsetCommitStatus";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tp()));
            n = Statics.mix((int)n, (int)(this.streamEnded() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastPulledOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastCommittedOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.endOffsetCommitStatus()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StreamCompletionStatus)) return false;
            boolean bl = true;
            if (!bl) return false;
            StreamCompletionStatus streamCompletionStatus = (StreamCompletionStatus)x$1;
            if (this.streamEnded() != streamCompletionStatus.streamEnded()) return false;
            TopicPartition topicPartition = this.tp();
            TopicPartition topicPartition2 = streamCompletionStatus.tp();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            Option<Object> option = this.lastPulledOffset();
            Option<Object> option2 = streamCompletionStatus.lastPulledOffset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.lastCommittedOffset();
            Option<Object> option4 = streamCompletionStatus.lastCommittedOffset();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            EndOffsetCommitStatus endOffsetCommitStatus = this.endOffsetCommitStatus();
            EndOffsetCommitStatus endOffsetCommitStatus2 = streamCompletionStatus.endOffsetCommitStatus();
            if (endOffsetCommitStatus == null) {
                if (endOffsetCommitStatus2 == null) return true;
                return false;
            } else {
                if (!endOffsetCommitStatus.equals(endOffsetCommitStatus2)) return false;
                return true;
            }
        }

        public StreamCompletionStatus(TopicPartition tp, boolean streamEnded, Option<Object> lastPulledOffset, Option<Object> lastCommittedOffset, EndOffsetCommitStatus endOffsetCommitStatus) {
            this.tp = tp;
            this.streamEnded = streamEnded;
            this.lastPulledOffset = lastPulledOffset;
            this.lastCommittedOffset = lastCommittedOffset;
            this.endOffsetCommitStatus = endOffsetCommitStatus;
            Product.$init$((Product)this);
        }
    }
}

