/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.utils;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestHeader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.DurationSyntax$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.utils.SslHelper;
import zio.kafka.utils.SslHelper$ZIOTypeOps$;
import zio.package$;

public final class SslHelper$ {
    public static final SslHelper$ MODULE$ = new SslHelper$();

    public ZIO<Object, KafkaException, BoxedUnit> validateEndpoint(Map<String, Object> props) {
        return this.doValidateEndpoint((Function1<InetSocketAddress, SocketChannel>)(Function1 & Serializable)x$1 -> SocketChannel.open(x$1), props);
    }

    public ZIO<Object, KafkaException, BoxedUnit> doValidateEndpoint(Function1<InetSocketAddress, SocketChannel> unsafeOpenSocket, Map<String, Object> props) {
        List list;
        Option option = props.get((Object)"bootstrap.servers");
        if (option instanceof Some) {
            Some some = (Some)option;
            Object config = some.value();
            list = Predef$.MODULE$.wrapRefArray((Object[])config.toString().split(",")).toList();
        } else if (None$.MODULE$.equals(option)) {
            list = scala.package$.MODULE$.List().empty();
        } else {
            throw new MatchError((Object)option);
        }
        List bootstrapServers = list;
        if (bootstrapServers.isEmpty()) {
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> MODULE$.kafkaException(new IllegalArgumentException("Empty bootstrapServers list")), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:64)");
        }
        return ZIO$.MODULE$.unless((Function0)(JFunction0.mcZ.sp & Serializable)() -> props.get((Object)"security.protocol").exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SslHelper$.$anonfun$doValidateEndpoint$3(x0$1))), (Function0 & Serializable)() -> ZIO$.MODULE$.blocking((Function0 & Serializable)() -> ZIO$.MODULE$.attempt((Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala(ClientUtils.parseAndValidateAddresses((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bootstrapServers).asJava(), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS)).asScala().toList(), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:77)").flatMap((Function1 & Serializable)addresses -> {
            Duration duration = SslHelper$.request$u002Etimeout$u002Ems$1(props);
            return SslHelper$ZIOTypeOps$.MODULE$.collectAllFailuresPar$extension(MODULE$.ZIOTypeOps(ZIO$.MODULE$), addresses.map((Function1 & Serializable)address -> MODULE$.validateSslConfigOf(unsafeOpenSocket, duration, (InetSocketAddress)address)), BuildFrom$.MODULE$.buildFromIterableOps(), "zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:83)").flatMap((Function1 & Serializable)errors -> {
                List list;
                List list2;
                boolean atLeastOneBootstrapServerIsUp = errors.size() < addresses.size();
                Tuple2 tuple2 = errors.partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SslHelper$.$anonfun$doValidateEndpoint$10(x$1)));
                if (tuple2 != null && (list2 = (List)tuple2._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    Throwable head = (Throwable)colon2.head();
                    return ZIO$.MODULE$.fail((Function0 & Serializable)() -> head, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:89)");
                }
                if (tuple2 != null) {
                    List list3 = (List)tuple2._1();
                    List list4 = (List)tuple2._2();
                    if (Nil$.MODULE$.equals(list3) && Nil$.MODULE$.equals(list4)) {
                        return ZIO$.MODULE$.unit();
                    }
                }
                if (atLeastOneBootstrapServerIsUp) {
                    return ZIO$.MODULE$.unit();
                }
                if (tuple2 != null && (list = (List)tuple2._1()) instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list;
                    Throwable head = (Throwable)colon3.head();
                    return ZIO$.MODULE$.fail((Function0 & Serializable)() -> ((SslHelper.ConnectionError)head).cause(), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:95)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:83)");
        }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:77)"), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:75)"), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:74)").unit((Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:100)").mapError((Function1 & Serializable)e -> MODULE$.kafkaException((Throwable)e), CanFail$.MODULE$.canFail(), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:101)");
    }

    private KafkaException kafkaException(Throwable e) {
        return new KafkaException("Failed to create new KafkaAdminClient", e);
    }

    private ZIO<Object, Throwable, BoxedUnit> validateSslConfigOf(Function1<InetSocketAddress, SocketChannel> unsafeOpenSocket, Duration socketTimeout, InetSocketAddress address) {
        return ZIO$.MODULE$.attemptBlockingInterrupt((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            boolean bl;
            SocketChannel socketChannel;
            try {
                socketChannel = (SocketChannel)unsafeOpenSocket.apply((Object)address);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw new SslHelper.ConnectionError(throwable2);
                }
                throw throwable;
            }
            try (SocketChannel channel = socketChannel;){
                MODULE$.unsafeSendTestRequest(channel);
                ByteBuffer buffer = MODULE$.unsafeReadAnswerFromTestRequest(channel);
                bl = MODULE$.isTls(buffer);
            }
            return bl;
        }, (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf(SslHelper.scala:180)").timeoutFail((Function0 & Serializable)() -> SslHelper$.timeoutException$1(address), (Function0 & Serializable)() -> socketTimeout, (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf(SslHelper.scala:198)").flatMap((Function1 & Serializable)isTLS -> SslHelper$.$anonfun$validateSslConfigOf$5(BoxesRunTime.unboxToBoolean((Object)isTLS)), (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf(SslHelper.scala:199)");
    }

    private void unsafeSendTestRequest(SocketChannel channel) {
        TransferableChannel transferableChannel = new TransferableChannel(channel){
            private final SocketChannel channel$1;

            public boolean hasPendingWrites() {
                return false;
            }

            public long transferFrom(FileChannel fileChannel, long position, long count) {
                throw new UnsupportedOperationException();
            }

            public long write(ByteBuffer[] srcs, int offset, int length) {
                return this.channel$1.write(srcs, offset, length);
            }

            public long write(ByteBuffer[] srcs) {
                return this.channel$1.write(srcs);
            }

            public int write(ByteBuffer src) {
                return this.channel$1.write(src);
            }

            public boolean isOpen() {
                return this.channel$1.isOpen();
            }

            public void close() {
                this.channel$1.close();
            }
            {
                this.channel$1 = channel$1;
            }
        };
        Send send = new ApiVersionsRequest.Builder().build(ApiKeys.API_VERSIONS.latestVersion()).toSend(new RequestHeader(ApiKeys.API_VERSIONS, ApiKeys.API_VERSIONS.latestVersion(), null, 0));
        send.writeTo(transferableChannel);
    }

    private ByteBuffer unsafeReadAnswerFromTestRequest(SocketChannel channel) {
        ByteBuffer buf = ByteBuffer.allocate(5);
        channel.read(buf);
        buf.position(0);
        return buf;
    }

    private boolean isTls(ByteBuffer buf) {
        byte tlsMessageType;
        byte by = tlsMessageType = buf.get();
        switch (by) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 255: {
                return true;
            }
        }
        return tlsMessageType >= 128;
    }

    private final ZIO$ ZIOTypeOps(ZIO$ dummy) {
        return dummy;
    }

    private static final Duration request$u002Etimeout$u002Ems$1(Map props$1) {
        Duration defaultValue = DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(30));
        Option option = props$1.get((Object)"request.timeout.ms");
        if (None$.MODULE$.equals(option)) {
            return defaultValue;
        }
        if (option instanceof Some) {
            Duration duration;
            Some some = (Some)option;
            Object raw = some.value();
            try {
                long v = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(raw.toString()));
                duration = v <= 0L ? defaultValue : DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationLong(v));
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    duration = defaultValue;
                }
                throw throwable;
            }
            return duration;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$doValidateEndpoint$3(Object x0$1) {
        String string;
        Object object = x0$1;
        return object instanceof String && (string = (String)object).toUpperCase().contains("SSL");
    }

    public static final /* synthetic */ boolean $anonfun$doValidateEndpoint$10(Throwable x$1) {
        return x$1 instanceof SslHelper.ConnectionError;
    }

    private static final ZIO unexpectedSslPacketError$1() {
        return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new IllegalArgumentException("Received an unexpected SSL packet from the server. Please ensure the client is properly configured with SSL enabled"), (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf.unexpectedSslPacketError(SslHelper.scala:171)");
    }

    private static final SslHelper.ConnectionError timeoutException$1(InetSocketAddress address$1) {
        return new SslHelper.ConnectionError(new TimeoutException(new StringBuilder(18).append("Failed to contact ").append(address$1).toString()));
    }

    public static final /* synthetic */ ZIO $anonfun$validateSslConfigOf$5(boolean isTLS) {
        if (isTLS) {
            return SslHelper$.unexpectedSslPacketError$1();
        }
        return ZIO$.MODULE$.unit();
    }

    private SslHelper$() {
    }
}

