/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Exit$;
import zio.IsSubtypeOfError$;
import zio.IsSubtypeOfOutput$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Ref;
import zio.Runtime;
import zio.Scope;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.Consumer$CommitTimeout$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.Committer$CommitOffsets$;
import zio.kafka.consumer.internal.ConsumerMetrics;
import zio.kafka.consumer.internal.LiveCommitter$;
import zio.kafka.diagnostics.Diagnostics;
import zio.package$;

@ScalaSignature(bytes="\u0006\u0005\r\u001dc!B\u001c9\u0005i\u0002\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\n\u0005%\u0001BCA\t\u0001\t\u0005\t\u0015!\u0003\u0002\u0014!Q!1\u0011\u0001\u0003\u0002\u0003\u0006IA!\"\t\u0015\te\u0005A!A!\u0002\u0013\u0011Y\n\u0003\u0004b\u0001\u0011\u0005!q\u0016\u0005\b\u0005\u007f\u0003A\u0011\tBa\u0011\u001d\u0011Y\r\u0001C!\u0005\u001bDqA!5\u0001\t\u0003\u0012\u0019\u000eC\u0005\u0003j\u0002\t\n\u0011\"\u0001\u0003l\"9!q\u001e\u0001\u0005\n\tE\bb\u0002B|\u0001\u0011%!\u0011 \u0005\b\u0007'\u0001A\u0011BB\u000b\u0011\u001d\u0019)\u0003\u0001C!\u0007OAqaa\u000b\u0001\t\u0003\u001a9\u0003C\u0004\u0004.\u0001!\tea\f\t\u000f\rM\u0002\u0001\"\u0011\u00046!91q\u0007\u0001\u0005B\re\u0002bBB#\u0001\u0011\u00053qF\u0004\u0007=bB\t\u0001O0\u0007\r]B\u0004\u0012\u0001\u001da\u0011\u0015\tw\u0003\"\u0001c\u0011\u0015\u0019w\u0003\"\u0001e\r\u001d\t\tc\u0006\"9\u0003GA!\"a\u000f\u001b\u0005+\u0007I\u0011AA\u001f\u0011)\tYE\u0007B\tB\u0003%\u0011q\b\u0005\u000b\u0003\u001bR\"Q3A\u0005\u0002\u0005=\u0003BCAC5\tE\t\u0015!\u0003\u0002R!Q\u0011q\u0011\u000e\u0003\u0016\u0004%\t!!#\t\u0015\u0005]%D!E!\u0002\u0013\tY\t\u0003\u0004b5\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003KSB\u0011AAT\u0011%\tILGA\u0001\n\u0003\tY\fC\u0005\u0002Dj\t\n\u0011\"\u0001\u0002F\"I\u00111\u001c\u000e\u0012\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003CT\u0012\u0013!C\u0001\u0003GD\u0011\"a:\u001b\u0003\u0003%\t%!;\t\u0013\u0005m($!A\u0005\u0002\u0005u\b\"\u0003B\u00035\u0005\u0005I\u0011\u0001B\u0004\u0011%\u0011\u0019BGA\u0001\n\u0003\u0012)\u0002C\u0005\u0003$i\t\t\u0011\"\u0001\u0003&!I!\u0011\u0006\u000e\u0002\u0002\u0013\u0005#1\u0006\u0005\n\u0005_Q\u0012\u0011!C!\u0005cA\u0011Ba\r\u001b\u0003\u0003%\tE!\u000e\t\u0013\t]\"$!A\u0005B\terA\u0003B\u001f/\u0005\u0005\t\u0012\u0001\u001d\u0003@\u0019Q\u0011\u0011E\f\u0002\u0002#\u0005\u0001H!\u0011\t\r\u0005\fD\u0011\u0001B-\u0011%\u0011\u0019$MA\u0001\n\u000b\u0012)\u0004C\u0005\u0003\\E\n\t\u0011\"!\u0003^!I!QM\u0019\u0002\u0002\u0013\u0005%q\r\u0005\n\u0005s\n\u0014\u0011!C\u0005\u0005w\u0012Q\u0002T5wK\u000e{W.\\5ui\u0016\u0014(BA\u001d;\u0003!Ig\u000e^3s]\u0006d'BA\u001e=\u0003!\u0019wN\\:v[\u0016\u0014(BA\u001f?\u0003\u0015Y\u0017MZ6b\u0015\u0005y\u0014a\u0001>j_N\u0019\u0001!Q$\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\r\u0005s\u0017PU3g!\tA\u0015*D\u00019\u0013\tQ\u0005HA\u0005D_6l\u0017\u000e\u001e;fe\u0006Y1m\\7nSR\fV/Z;f\u0007\u0001\u00012AT(R\u001b\u0005q\u0014B\u0001)?\u0005\u0015\tV/Z;f!\t\u0011&D\u0004\u0002T-9\u0011A+\u0018\b\u0003+rs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005ec\u0015A\u0002\u001fs_>$h(C\u0001@\u0013\tid(\u0003\u0002<y%\u0011\u0011HO\u0001\u000e\u0019&4XmQ8n[&$H/\u001a:\u0011\u0005!;2CA\fB\u0003\u0019a\u0014N\\5u}Q\tq,\u0001\u0003nC.,GcB3ps\u0006\u0015\u0011q\u0002\t\u0006\u001d\u001aD7N\\\u0005\u0003Oz\u00121AW%P!\tq\u0015.\u0003\u0002k}\t)1kY8qKB\u0011!\t\\\u0005\u0003[\u000e\u0013qAT8uQ&tw\r\u0005\u0002I\u0001!)\u0001/\u0007a\u0001c\u0006i1m\\7nSR$\u0016.\\3pkR\u0004\"A];\u000f\u0005Y\u001b\u0018B\u0001;?\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0011\u0011+(/\u0019;j_:L!\u0001\u001f \u0003\u001d\u0011+(/\u0019;j_:lu\u000eZ;mK\")!0\u0007a\u0001w\u0006YA-[1h]>\u001cH/[2t!\taxP\u0004\u0002U{&\u0011aPO\u0001\t\u0007>t7/^7fe&!\u0011\u0011AA\u0002\u0005M\u0019uN\\:v[\u0016\u0014H)[1h]>\u001cH/[2t\u0015\tq(\bC\u0004\u0002\be\u0001\r!!\u0003\u0002\u001f\r|gn];nKJlU\r\u001e:jGN\u00042\u0001SA\u0006\u0013\r\ti\u0001\u000f\u0002\u0010\u0007>t7/^7fe6+GO]5dg\"9\u0011\u0011C\rA\u0002\u0005M\u0011!E8o\u0007>lW.\u001b;Bm\u0006LG.\u00192mKB)!/!\u0006\u0002\u001c%!\u0011qCA\r\u0005\r)\u0016j\u0014\u0006\u0003iz\u00022AQA\u000f\u0013\r\tyb\u0011\u0002\u0005+:LGO\u0001\u0004D_6l\u0017\u000e^\n\u00075\u0005\u000b)#a\u000b\u0011\u0007\t\u000b9#C\u0002\u0002*\r\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003gq1aVA\u0019\u0013\u0005!\u0015B\u0001;D\u0013\u0011\t9$!\u000f\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005Q\u001c\u0015!C2sK\u0006$X\rZ!u+\t\ty\u0004\u0005\u0003\u0002B\u0005\u0015cb\u0001%\u0002D%\u0011A\u000fO\u0005\u0005\u0003\u000f\nIE\u0001\u0005OC:|G+[7f\u0015\t!\b(\u0001\u0006de\u0016\fG/\u001a3Bi\u0002\nqa\u001c4gg\u0016$8/\u0006\u0002\u0002RAA\u00111KA.\u0003C\n9H\u0004\u0003\u0002V\u0005]\u0003CA,D\u0013\r\tIfQ\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0013q\f\u0002\u0004\u001b\u0006\u0004(bAA-\u0007B!\u00111MA:\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014AB2p[6|gNC\u0002>\u0003WRA!!\u001c\u0002p\u00051\u0011\r]1dQ\u0016T!!!\u001d\u0002\u0007=\u0014x-\u0003\u0003\u0002v\u0005\u0015$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003s\n\t)\u0004\u0002\u0002|)\u00191(! \u000b\t\u0005}\u0014\u0011N\u0001\bG2LWM\u001c;t\u0013\u0011\t\u0019)a\u001f\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018-\u0001\u0005pM\u001a\u001cX\r^:!\u0003\u0011\u0019wN\u001c;\u0016\u0005\u0005-\u0005c\u0002(\u0002\u000e\u0006E\u00151D\u0005\u0004\u0003\u001fs$a\u0002)s_6L7/\u001a\t\u0005\u0003[\t\u0019*\u0003\u0003\u0002\u0016\u0006e\"!\u0003+ie><\u0018M\u00197f\u0003\u0015\u0019wN\u001c;!)!\tY*a(\u0002\"\u0006\r\u0006cAAO55\tq\u0003C\u0004\u0002<\u0005\u0002\r!a\u0010\t\u000f\u00055\u0013\u00051\u0001\u0002R!9\u0011qQ\u0011A\u0002\u0005-\u0015!C5t!\u0016tG-\u001b8h+\t\tI\u000bE\u0003s\u0003+\tY\u000bE\u0002C\u0003[K1!a,D\u0005\u001d\u0011un\u001c7fC:D3AIAZ!\r\u0011\u0015QW\u0005\u0004\u0003o\u001b%AB5oY&tW-\u0001\u0003d_BLH\u0003CAN\u0003{\u000by,!1\t\u0013\u0005m2\u0005%AA\u0002\u0005}\u0002\"CA'GA\u0005\t\u0019AA)\u0011%\t9i\tI\u0001\u0002\u0004\tY)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d'\u0006BA \u0003\u0013\\#!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+\u001c\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011\\Ah\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyN\u000b\u0003\u0002R\u0005%\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003KTC!a#\u0002J\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a;\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006!A.\u00198h\u0015\t\t)0\u0001\u0003kCZ\f\u0017\u0002BA}\u0003_\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0000!\r\u0011%\u0011A\u0005\u0004\u0005\u0007\u0019%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0005\u0005\u001f\u00012A\u0011B\u0006\u0013\r\u0011ia\u0011\u0002\u0004\u0003:L\b\"\u0003B\tS\u0005\u0005\t\u0019AA\u0000\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0003\t\u0007\u00053\u0011yB!\u0003\u000e\u0005\tm!b\u0001B\u000f\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0005\"1\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002,\n\u001d\u0002\"\u0003B\tW\u0005\u0005\t\u0019\u0001B\u0005\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005-(Q\u0006\u0005\n\u0005#a\u0013\u0011!a\u0001\u0003\u007f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u007f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003W\fa!Z9vC2\u001cH\u0003BAV\u0005wA\u0011B!\u00050\u0003\u0003\u0005\rA!\u0003\u0002\r\r{W.\\5u!\r\ti*M\n\u0006c\t\r#q\n\t\r\u0005\u000b\u0012Y%a\u0010\u0002R\u0005-\u00151T\u0007\u0003\u0005\u000fR1A!\u0013D\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0014\u0003H\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\tE#qK\u0007\u0003\u0005'RAA!\u0016\u0002t\u0006\u0011\u0011n\\\u0005\u0005\u0003o\u0011\u0019\u0006\u0006\u0002\u0003@\u0005)\u0011\r\u001d9msRA\u00111\u0014B0\u0005C\u0012\u0019\u0007C\u0004\u0002<Q\u0002\r!a\u0010\t\u000f\u00055C\u00071\u0001\u0002R!9\u0011q\u0011\u001bA\u0002\u0005-\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005S\u0012)\bE\u0003C\u0005W\u0012y'C\u0002\u0003n\r\u0013aa\u00149uS>t\u0007#\u0003\"\u0003r\u0005}\u0012\u0011KAF\u0013\r\u0011\u0019h\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t]T'!AA\u0002\u0005m\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u0010\t\u0005\u0003[\u0014y(\u0003\u0003\u0003\u0002\u0006=(AB(cU\u0016\u001cG/A\nd_6l\u0017\u000e\u001e;fI>3gm]3ugJ+g\rE\u0003O\u0005\u000f\u0013Y)C\u0002\u0003\nz\u00121AU3g!\u0011\u0011iIa%\u000f\u0007M\u0013y)C\u0002\u0003\u0012b\n\u0011bQ8n[&$H/\u001a:\n\t\tU%q\u0013\u0002\u000e\u0007>lW.\u001b;PM\u001a\u001cX\r^:\u000b\u0007\tE\u0005(\u0001\bqK:$\u0017N\\4D_6l\u0017\u000e^:\u0011\r\tu%1\u0015BU\u001d\rq%qT\u0005\u0004\u0005Cs\u0014a\u0001*fM&!!Q\u0015BT\u00051\u0019\u0016P\\2ie>t\u0017N_3e\u0015\r\u0011\tK\u0010\t\u0005\u001d\n-\u0016+C\u0002\u0003.z\u0012Qa\u00115v].$rB\u001cBY\u0005g\u0013)La.\u0003:\nm&Q\u0018\u0005\u0006\u0017\"\u0001\r!\u0014\u0005\u0006a\"\u0001\r!\u001d\u0005\u0006u\"\u0001\ra\u001f\u0005\b\u0003\u000fA\u0001\u0019AA\u0005\u0011\u001d\t\t\u0002\u0003a\u0001\u0003'AqAa!\t\u0001\u0004\u0011)\tC\u0004\u0003\u001a\"\u0001\rAa'\u0002/I,w-[:uKJ,\u0005\u0010^3s]\u0006d7i\\7nSR\u001cH\u0003\u0002Bb\u0005\u0013\u0004RA\u001dBc\u00037IAAa2\u0002\u001a\t!A+Y:l\u0011\u001d\ti%\u0003a\u0001\u0003#\naaY8n[&$H\u0003\u0002Bb\u0005\u001fDq!!\u0014\u000b\u0001\u0004\t\t&\u0001\u000bqe>\u001cWm]:Rk\u0016,X\rZ\"p[6LGo\u001d\u000b\u0007\u0005\u0007\u0014)N!:\t\rmZ\u0001\u0019\u0001Bl!\u0011\u0011INa8\u000f\u0007M\u0013Y.C\u0002\u0003^b\nabQ8ogVlWM]!dG\u0016\u001c8/\u0003\u0003\u0003b\n\r(A\u0006\"zi\u0016\f%O]1z\u0017\u000647.Y\"p]N,X.\u001a:\u000b\u0007\tu\u0007\bC\u0005\u0003h.\u0001\n\u00111\u0001\u0002,\u0006qQ\r_3dkR,wJ\\#naRL\u0018A\b9s_\u000e,7o])vKV,GmQ8n[&$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iO\u000b\u0003\u0002,\u0006%\u0017AE7fe\u001e,7i\\7nSR|eMZ:fiN$B!!\u0015\u0003t\"9!Q_\u0007A\u0002\t%\u0016aB2p[6LGo]\u0001\u0017Q\u0006tG\r\\3D_6l\u0017\u000e^\"p[BdW\r^5p]RQ\u00111\u0003B~\u0005{\u0014ypa\u0001\t\u000f\tUh\u00021\u0001\u0003*\"9\u0011Q\n\bA\u0002\u0005E\u0003bBB\u0001\u001d\u0001\u0007\u0011qH\u0001\ngR\f'\u000f\u001e+j[\u0016Dqa!\u0002\u000f\u0001\u0004\u00199!A\u0007d_6l\u0017\u000e\u001e*fgVdGo\u001d\t\t\u0003[\u0019Ia!\u0004\u0002R%!11BA\u001d\u0005\u0019)\u0015\u000e\u001e5feB!\u0011QFB\b\u0013\u0011\u0019\t\"!\u000f\u0003\u0013\u0015C8-\u001a9uS>t\u0017AD2p[6LG/Q:z]\u000eT\u0016j\u0014\u000b\t\u0005\u0007\u001c9b!\u0007\u0004\u001c!11h\u0004a\u0001\u0005/Dq!!\u0014\u0010\u0001\u0004\t\t\u0006C\u0004\u0004\u001e=\u0001\raa\b\u0002\u0019\u0011|wJ\\\"p[BdW\r^3\u0011\u000f\t\u001b\tca\u0002\u0002\u0014%\u001911E\"\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!C9vKV,7+\u001b>f+\t\u0019I\u0003E\u0003s\u0003+\ty0\u0001\nqK:$\u0017N\\4D_6l\u0017\u000e^\"pk:$\u0018!E4fiB+g\u000eZ5oO\u000e{W.\\5ugV\u00111\u0011\u0007\t\u0006e\u0006U!1R\u0001\u0016G2,\u0017M\\;q!\u0016tG-\u001b8h\u0007>lW.\u001b;t+\t\t\u0019\"\u0001\rlK\u0016\u00048i\\7nSR\u001chi\u001c:QCJ$\u0018\u000e^5p]N$B!a\u0005\u0004<!91Q\b\u000bA\u0002\r}\u0012AE1tg&<g.\u001a3QCJ$\u0018\u000e^5p]N\u0004b!a\u0015\u0004B\u0005\u0005\u0014\u0002BB\"\u0003?\u00121aU3u\u0003M9W\r^\"p[6LG\u000f^3e\u001f\u001a47/\u001a;t\u0001")
public final class LiveCommitter
implements Committer {
    private final Queue<Commit> commitQueue;
    private final Duration commitTimeout;
    private final Diagnostics<DiagnosticEvent> diagnostics;
    private final ConsumerMetrics consumerMetrics;
    private final ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable;
    private final Ref<Committer.CommitOffsets> committedOffsetsRef;
    private final Ref.Synchronized<Chunk<Commit>> pendingCommits;

    public static ZIO<Scope, Nothing$, LiveCommitter> make(Duration commitTimeout, Diagnostics<DiagnosticEvent> diagnostics, ConsumerMetrics consumerMetrics, ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable) {
        return LiveCommitter$.MODULE$.make(commitTimeout, diagnostics, consumerMetrics, onCommitAvailable);
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> registerExternalCommits(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return this.committedOffsetsRef.modify((Function1 & Serializable)x$1 -> x$1.addCommits((Chunk<Commit>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Commit[]{new Commit(System.nanoTime(), offsets, null)}))), (Object)"zio.kafka.consumer.internal.LiveCommitter.registerExternalCommits(LiveCommitter.scala:27)").unit((Object)"zio.kafka.consumer.internal.LiveCommitter.registerExternalCommits(LiveCommitter.scala:30)");
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> commit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:35)").flatMap((Function1 & Serializable)p -> {
            long startTime = System.nanoTime();
            return $this.commitQueue.offer((Object)new Commit(startTime, offsets, (Promise<Throwable, BoxedUnit>)p), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:37)").flatMap((Function1 & Serializable)x$7 -> LiveCommitter.$anonfun$commit$2(this, offsets, p, startTime, BoxesRunTime.unboxToBoolean((Object)x$7)), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:37)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:35)");
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> processQueuedCommits(Consumer<byte[], byte[]> consumer, boolean executeOnEmpty) {
        return this.commitQueue.takeAll((Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:54)").flatMap((Function1 & Serializable)commits -> ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(19).append("Processing ").append(commits.size()).append(" commits").toString(), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:55)").flatMap((Function1 & Serializable)x$15 -> {
            BoxedUnit boxedUnit = x$15;
            return ZIO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> commits.nonEmpty() || executeOnEmpty, (Function0 & Serializable)() -> {
                scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets = this.mergeCommitOffsets((Chunk<Commit>)commits);
                scala.collection.immutable.Map offsetsWithMetaData = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndMetadata(offset.offset() + 1L, offset.leaderEpoch(), offset.metadata()));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return $this.pendingCommits.update((Function1 & Serializable)x$9 -> x$9.$plus$plus(commits), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:63)").flatMap((Function1 & Serializable)x$13 -> {
                    BoxedUnit boxedUnit = x$13;
                    return ZIO$.MODULE$.clockWith((Function1 & Serializable)x$10 -> x$10.nanoTime((Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:64)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:64)").flatMap((Function1 & Serializable)startTime -> this.commitAsyncZIO((Consumer<byte[], byte[]>)consumer, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData, (Function1<Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>)(Function1 & Serializable)x$11 -> $this.handleCommitCompletion((Chunk<Commit>)commits$1, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$1, startTime, (Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)x$11)), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:64)");
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:63)");
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:56)").map((Function1 & Serializable)x$14 -> {
                option = x$14;
                return BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:56)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:55)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:54)");
    }

    @Override
    public boolean processQueuedCommits$default$2() {
        return false;
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> mergeCommitOffsets(Chunk<Commit> commits) {
        return ((IterableOnceOps)commits.foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.mutable.Map acc = (scala.collection.mutable.Map)tuple2._1();
                Commit commit = (Commit)tuple2._2();
                commit.offsets().foreach((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                        return (scala.collection.mutable.Map)acc.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), acc.get((Object)tp).map((Function1 & Serializable)current -> {
                            if (current.offset() > offset.offset()) {
                                return current;
                            }
                            return offset;
                        }).getOrElse((Function0 & Serializable)() -> offset)));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return acc;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ZIO<Object, Nothing$, BoxedUnit> handleCommitCompletion(Chunk<Commit> commits, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, long startTime, Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> commitResults) {
        return ZIO$.MODULE$.from((Function0 & Serializable)() -> commitResults, ZIO.ZIOConstructor$.MODULE$.EitherConstructor(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:95)").zipLeft((Function0 & Serializable)() -> ZIO$.MODULE$.clockWith((Function1 & Serializable)x$16 -> x$16.nanoTime((Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:98)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:98)").flatMap((Function1 & Serializable)endTime -> LiveCommitter.$anonfun$handleCommitCompletion$4(this, startTime, commits, BoxesRunTime.unboxToLong((Object)endTime)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:98)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:96)").zipLeft((Function0 & Serializable)() -> ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> commits, (Function1 & Serializable)x$20 -> x$20.cont().done(Exit$.MODULE$.unit(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:104)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:104)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:104)").tap((Function1 & Serializable)offsetsWithMetaData -> $this.diagnostics.emit((Function0<DiagnosticEvent>)(Function0 & Serializable)() -> new DiagnosticEvent.Commit.Success((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:105)").catchAllCause((Function1 & Serializable)x0$1 -> {
            Cause.Fail fail;
            Cause cause = x0$1;
            if (cause instanceof Cause.Fail && (fail = (Cause.Fail)cause).value() instanceof RebalanceInProgressException) {
                return ZIO$.MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(58).append("Rebalance in progress, commit for offsets ").append(offsets).append(" will be retried").toString(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:109)").flatMap((Function1 & Serializable)x$23 -> {
                    BoxedUnit boxedUnit = x$23;
                    return $this.commitQueue.offerAll((Iterable)commits, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:110)").flatMap((Function1 & Serializable)x$22 -> {
                        Chunk chunk = x$22;
                        return $this.onCommitAvailable.map((Function1 & Serializable)x$21 -> {
                            boxedUnit = x$21;
                            return BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:111)");
                    }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:110)");
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:109)");
            }
            return ZIO$.MODULE$.foreachDiscard((Function0 & Serializable)() -> commits, (Function1 & Serializable)x$24 -> x$24.cont().done(Exit$.MODULE$.fail((Object)cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()))), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:114)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:114)").$less$times((Function0 & Serializable)() -> $this.diagnostics.emit((Function0<DiagnosticEvent>)(Function0 & Serializable)() -> new DiagnosticEvent.Commit.Failure(offsets, cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())))), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:114)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:106)").ignore((Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:118)");
    }

    private ZIO<Object, Throwable, BoxedUnit> commitAsyncZIO(Consumer<byte[], byte[]> consumer, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>, ZIO<Object, Nothing$, BoxedUnit>> doOnComplete) {
        return ZIO$.MODULE$.runtime((Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:132)").flatMap((Function1 & Serializable)runtime -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava(), new OffsetCommitCallback(null, (Runtime)runtime, (Function1)doOnComplete){
            private final Runtime runtime$1;
            private final Function1 doOnComplete$1;

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                Unsafe$.MODULE$.unsafe((Function1 & Serializable)unsafe -> {
                    $anon$1.$anonfun$onComplete$1(this, exception, offsets, unsafe);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onComplete$1($anon$1 $this, Exception exception$1, java.util.Map offsets$5, Unsafe unsafe) {
                $this.runtime$1.unsafe().run(exception$1 == null ? (ZIO)$this.doOnComplete$1.apply((Object)new Right((Object)CollectionConverters$.MODULE$.MapHasAsScala(offsets$5).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))) : (ZIO)$this.doOnComplete$1.apply((Object)new Left((Object)exception$1)), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO.$anon.onComplete(LiveCommitter.scala:142)", unsafe).getOrThrowFiberFailure(unsafe);
            }
            {
                this.runtime$1 = runtime$1;
                this.doOnComplete$1 = doOnComplete$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1$adapted(zio.kafka.consumer.internal.LiveCommitter$$anon$1 java.lang.Exception java.util.Map zio.Unsafe )}, serializedLambda);
            }
        }), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:133)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:132)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> queueSize() {
        return this.commitQueue.size((Object)"zio.kafka.consumer.internal.LiveCommitter.queueSize(LiveCommitter.scala:152)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> pendingCommitCount() {
        return this.pendingCommits.get((Object)"zio.kafka.consumer.internal.LiveCommitter.pendingCommitCount(LiveCommitter.scala:154)").map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToInteger((int)x$26.size()), (Object)"zio.kafka.consumer.internal.LiveCommitter.pendingCommitCount(LiveCommitter.scala:154)");
    }

    @Override
    public ZIO<Object, Nothing$, Committer.CommitOffsets> getPendingCommits() {
        return this.pendingCommits.get((Object)"zio.kafka.consumer.internal.LiveCommitter.getPendingCommits(LiveCommitter.scala:157)").map((Function1 & Serializable)x$27 -> (Committer.CommitOffsets)Committer$CommitOffsets$.MODULE$.empty().addCommits((Chunk<Commit>)x$27)._2(), (Object)"zio.kafka.consumer.internal.LiveCommitter.getPendingCommits(LiveCommitter.scala:157)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> cleanupPendingCommits() {
        return this.pendingCommits.updateZIO((Function1 & Serializable)x$28 -> x$28.filterZIO((Function1 & Serializable)x$29 -> x$29.isPending(), (Object)"zio.kafka.consumer.internal.LiveCommitter.cleanupPendingCommits(LiveCommitter.scala:160)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.cleanupPendingCommits(LiveCommitter.scala:160)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> keepCommitsForPartitions(Set<TopicPartition> assignedPartitions) {
        return this.committedOffsetsRef.update((Function1 & Serializable)x$30 -> x$30.keepPartitions(assignedPartitions), (Object)"zio.kafka.consumer.internal.LiveCommitter.keepCommitsForPartitions(LiveCommitter.scala:163)");
    }

    @Override
    public ZIO<Object, Nothing$, Committer.CommitOffsets> getCommittedOffsets() {
        return this.committedOffsetsRef.get((Object)"zio.kafka.consumer.internal.LiveCommitter.getCommittedOffsets(LiveCommitter.scala:165)");
    }

    public static final /* synthetic */ ZIO $anonfun$commit$2(LiveCommitter $this, scala.collection.immutable.Map offsets$2, Promise p$1, long startTime$1, boolean x$7) {
        boolean bl = x$7;
        return $this.onCommitAvailable.flatMap((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            return $this.diagnostics.emit((Function0<DiagnosticEvent>)(Function0 & Serializable)() -> new DiagnosticEvent.Commit.Started((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$2)).flatMap((Function1 & Serializable)x$5 -> {
                BoxedUnit boxedUnit = x$5;
                return p$1.await((Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:40)").timeoutFail((Function0 & Serializable)() -> Consumer$CommitTimeout$.MODULE$, (Function0 & Serializable)() -> $this.commitTimeout, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:40)").flatMap((Function1 & Serializable)x$2 -> {
                    long endTime = System.nanoTime();
                    Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(package$.MODULE$.durationLong(endTime - startTime$1));
                    return $this.consumerMetrics.observeCommit(latency);
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:40)");
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:39)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:38)");
    }

    public static final /* synthetic */ ZIO $anonfun$handleCommitCompletion$6(LiveCommitter $this, Duration latency$1, Chunk commits$2, long offsetIncrease) {
        return $this.consumerMetrics.observeAggregatedCommit(latency$1, offsetIncrease).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> commits$2.nonEmpty(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:101)").map((Function1 & Serializable)x$18 -> {
            option = x$18;
            return BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:101)");
    }

    public static final /* synthetic */ ZIO $anonfun$handleCommitCompletion$4(LiveCommitter $this, long startTime$3, Chunk commits$2, long endTime) {
        Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(package$.MODULE$.durationLong(endTime - startTime$3));
        return $this.committedOffsetsRef.modify((Function1 & Serializable)x$17 -> x$17.addCommits((Chunk<Commit>)commits$2), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:100)").flatMap((Function1 & Serializable)offsetIncrease -> LiveCommitter.$anonfun$handleCommitCompletion$6($this, latency, commits$2, BoxesRunTime.unboxToLong((Object)offsetIncrease)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:100)");
    }

    public LiveCommitter(Queue<Commit> commitQueue, Duration commitTimeout, Diagnostics<DiagnosticEvent> diagnostics, ConsumerMetrics consumerMetrics, ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable, Ref<Committer.CommitOffsets> committedOffsetsRef, Ref.Synchronized<Chunk<Commit>> pendingCommits) {
        this.commitQueue = commitQueue;
        this.commitTimeout = commitTimeout;
        this.diagnostics = diagnostics;
        this.consumerMetrics = consumerMetrics;
        this.onCommitAvailable = onCommitAvailable;
        this.committedOffsetsRef = committedOffsetsRef;
        this.pendingCommits = pendingCommits;
    }

    public static final class Commit
    implements Product,
    Serializable {
        private final long createdAt;
        private final scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets;
        private final Promise<Throwable, BoxedUnit> cont;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long createdAt() {
            return this.createdAt;
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets() {
            return this.offsets;
        }

        public Promise<Throwable, BoxedUnit> cont() {
            return this.cont;
        }

        public ZIO<Object, Nothing$, Object> isPending() {
            return this.cont().isDone((Object)"zio.kafka.consumer.internal.LiveCommitter.Commit.isPending(LiveCommitter.scala:193)").negate(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.internal.LiveCommitter.Commit.isPending(LiveCommitter.scala:193)");
        }

        public Commit copy(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            return new Commit(createdAt, offsets, cont);
        }

        public long copy$default$1() {
            return this.createdAt();
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> copy$default$2() {
            return this.offsets();
        }

        public Promise<Throwable, BoxedUnit> copy$default$3() {
            return this.cont();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.createdAt());
                }
                case 1: {
                    return this.offsets();
                }
                case 2: {
                    return this.cont();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "createdAt";
                }
                case 1: {
                    return "offsets";
                }
                case 2: {
                    return "cont";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2024019287);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.createdAt()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offsets()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cont()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit = (Commit)x$1;
            if (this.createdAt() != commit.createdAt()) return false;
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = this.offsets();
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map2 = commit.offsets();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Promise<Throwable, BoxedUnit> promise = this.cont();
            Promise<Throwable, BoxedUnit> promise2 = commit.cont();
            if (promise == null) {
                if (promise2 == null) return true;
                return false;
            } else {
                if (!promise.equals(promise2)) return false;
                return true;
            }
        }

        public Commit(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            this.createdAt = createdAt;
            this.offsets = offsets;
            this.cont = cont;
            Product.$init$((Product)this);
        }
    }
}

