/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer;

import java.io.Serializable;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.ZIO;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.OffsetBatch;
import zio.kafka.consumer.OffsetBatchImpl$;

public final class OffsetBatchImpl
implements OffsetBatch,
Product,
Serializable {
    private final Map offsets;
    private final Function1 commitHandle;
    private final Option consumerGroupMetadata;

    public static OffsetBatchImpl apply(Map<TopicPartition, OffsetAndMetadata> map, Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> function1, Option<ConsumerGroupMetadata> option) {
        return OffsetBatchImpl$.MODULE$.apply(map, function1, option);
    }

    public static OffsetBatchImpl fromProduct(Product product) {
        return OffsetBatchImpl$.MODULE$.fromProduct(product);
    }

    public static OffsetBatchImpl unapply(OffsetBatchImpl offsetBatchImpl) {
        return OffsetBatchImpl$.MODULE$.unapply(offsetBatchImpl);
    }

    public OffsetBatchImpl(Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commitHandle, Option<ConsumerGroupMetadata> consumerGroupMetadata) {
        this.offsets = offsets;
        this.commitHandle = commitHandle;
        this.consumerGroupMetadata = consumerGroupMetadata;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OffsetBatchImpl)) return false;
        OffsetBatchImpl offsetBatchImpl = (OffsetBatchImpl)object;
        Map<TopicPartition, OffsetAndMetadata> map = this.offsets();
        Map<TopicPartition, OffsetAndMetadata> map2 = offsetBatchImpl.offsets();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> function1 = this.commitHandle();
        Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> function12 = offsetBatchImpl.commitHandle();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Option<ConsumerGroupMetadata> option = this.consumerGroupMetadata();
        Option<ConsumerGroupMetadata> option2 = offsetBatchImpl.consumerGroupMetadata();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof OffsetBatchImpl;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "OffsetBatchImpl";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "offsets";
            }
            case 1: {
                return "commitHandle";
            }
            case 2: {
                return "consumerGroupMetadata";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> offsets() {
        return this.offsets;
    }

    public Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commitHandle() {
        return this.commitHandle;
    }

    @Override
    public Option<ConsumerGroupMetadata> consumerGroupMetadata() {
        return this.consumerGroupMetadata;
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> commit() {
        return (ZIO)this.commitHandle().apply(this.offsets());
    }

    @Override
    public OffsetBatch add(Offset offset) {
        OffsetAndMetadata existing;
        Option option = this.offsets().get((Object)offset.topicPartition());
        OffsetAndMetadata maxOffsetAndMetadata = option instanceof Some && (existing = (OffsetAndMetadata)((Some)option).value()).offset() > offset.offset() ? existing : offset.asJavaOffsetAndMetadata();
        TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)offset.topicPartition());
        return this.copy((Map<TopicPartition, OffsetAndMetadata>)((Map)this.offsets().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)maxOffsetAndMetadata))), this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public OffsetBatch merge(Offset offset) {
        return this.add(offset);
    }

    @Override
    public OffsetBatch merge(OffsetBatch otherOffsets) {
        Builder newOffsets = Predef$.MODULE$.Map().newBuilder();
        newOffsets.$plus$plus$eq(this.offsets());
        otherOffsets.offsets().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                OffsetAndMetadata offsetAndMetadata;
                TopicPartition tp = (TopicPartition)tuple2._1();
                OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                Option option = this.offsets().get((Object)tp);
                if (option instanceof Some) {
                    OffsetAndMetadata existing = (OffsetAndMetadata)((Some)option).value();
                    offsetAndMetadata = existing.offset() < offset.offset() ? offset : existing;
                } else if (None$.MODULE$.equals(option)) {
                    offsetAndMetadata = offset;
                } else {
                    throw new MatchError((Object)option);
                }
                OffsetAndMetadata laterOffset = offsetAndMetadata;
                TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                return (Builder)newOffsets.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)laterOffset));
            }
            throw new MatchError((Object)tuple2);
        });
        return this.copy((Map<TopicPartition, OffsetAndMetadata>)((Map)newOffsets.result()), this.copy$default$2(), this.copy$default$3());
    }

    public OffsetBatchImpl copy(Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commitHandle, Option<ConsumerGroupMetadata> consumerGroupMetadata) {
        return new OffsetBatchImpl(offsets, commitHandle, consumerGroupMetadata);
    }

    public Map<TopicPartition, OffsetAndMetadata> copy$default$1() {
        return this.offsets();
    }

    public Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> copy$default$2() {
        return this.commitHandle();
    }

    public Option<ConsumerGroupMetadata> copy$default$3() {
        return this.consumerGroupMetadata();
    }

    public Map<TopicPartition, OffsetAndMetadata> _1() {
        return this.offsets();
    }

    public Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> _2() {
        return this.commitHandle();
    }

    public Option<ConsumerGroupMetadata> _3() {
        return this.consumerGroupMetadata();
    }
}

