/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Exit$;
import zio.IsSubtypeOfError$;
import zio.IsSubtypeOfOutput$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Ref;
import zio.Runtime;
import zio.Scope;
import zio.StackTrace;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.Consumer$CommitTimeout$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Failure$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Started$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Success$;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.Committer$CommitOffsets$;
import zio.kafka.consumer.internal.ConsumerMetrics;
import zio.kafka.consumer.internal.LiveCommitter$;
import zio.kafka.consumer.internal.LiveCommitter$Commit$;
import zio.package$;

public final class LiveCommitter
implements Committer {
    private final Queue<Commit> commitQueue;
    private final Duration commitTimeout;
    private final Diagnostics diagnostics;
    private final ConsumerMetrics consumerMetrics;
    private final ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable;
    private final Ref<Committer.CommitOffsets> committedOffsetsRef;
    private final Ref.Synchronized<Chunk<Commit>> pendingCommits;
    private final Function1 registerExternalCommits;
    private final Function1 commit;

    public static ZIO<Scope, Nothing$, LiveCommitter> make(Duration duration, Diagnostics diagnostics, ConsumerMetrics consumerMetrics, ZIO<Object, Nothing$, BoxedUnit> zIO) {
        return LiveCommitter$.MODULE$.make(duration, diagnostics, consumerMetrics, zIO);
    }

    public LiveCommitter(Queue<Commit> commitQueue, Duration commitTimeout, Diagnostics diagnostics, ConsumerMetrics consumerMetrics, ZIO<Object, Nothing$, BoxedUnit> onCommitAvailable, Ref<Committer.CommitOffsets> committedOffsetsRef, Ref.Synchronized<Chunk<Commit>> pendingCommits) {
        this.commitQueue = commitQueue;
        this.commitTimeout = commitTimeout;
        this.diagnostics = diagnostics;
        this.consumerMetrics = consumerMetrics;
        this.onCommitAvailable = onCommitAvailable;
        this.committedOffsetsRef = committedOffsetsRef;
        this.pendingCommits = pendingCommits;
        this.registerExternalCommits = (Function1 & Serializable)offsets -> committedOffsetsRef.modify((Function1 & Serializable)_$1 -> _$1.addCommits((Chunk<Commit>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Commit[]{LiveCommitter$Commit$.MODULE$.apply(System.nanoTime(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, null)}))), (Object)"zio.kafka.consumer.internal.LiveCommitter.registerExternalCommits(LiveCommitter.scala:33)").unit((Object)"zio.kafka.consumer.internal.LiveCommitter.registerExternalCommits(LiveCommitter.scala:33)");
        this.commit = (Function1 & Serializable)offsets -> Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:39)").map((Function1 & Serializable)p -> {
            long startTime = System.nanoTime();
            return Tuple2$.MODULE$.apply(p, (Object)BoxesRunTime.boxToLong((long)startTime));
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:40)").flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Promise p = (Promise)tuple2._1();
                long startTime = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return commitQueue.offer((Object)LiveCommitter$Commit$.MODULE$.apply(startTime, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, (Promise<Throwable, BoxedUnit>)p), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:41)").flatMap((Function1 & Serializable)x$1 -> LiveCommitter.$init$$$anonfun$2$$anonfun$2$$anonfun$1(onCommitAvailable, diagnostics, offsets, p, commitTimeout, startTime, consumerMetrics, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:48)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:48)");
    }

    @Override
    public Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> registerExternalCommits() {
        return this.registerExternalCommits;
    }

    @Override
    public Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commit() {
        return this.commit;
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> processQueuedCommits(Consumer<byte[], byte[]> consumer, boolean executeOnEmpty) {
        return this.commitQueue.takeAll((Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:58)").flatMap((Function1 & Serializable)commits -> ZIO$.MODULE$.logDebug(() -> LiveCommitter.processQueuedCommits$$anonfun$1$$anonfun$1(commits), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:59)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ZIO$.MODULE$.when(() -> LiveCommitter.processQueuedCommits$$anonfun$1$$anonfun$2$$anonfun$1(commits, executeOnEmpty), () -> this.processQueuedCommits$$anonfun$1$$anonfun$2$$anonfun$2(commits, consumer), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:76)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Option option = x$1;
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:77)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:77)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:77)");
    }

    @Override
    public boolean processQueuedCommits$default$2() {
        return false;
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> mergeCommitOffsets(Chunk<Commit> commits) {
        return ((IterableOnceOps)commits.foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(x$12, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                scala.collection.mutable.Map acc = (scala.collection.mutable.Map)tuple2._1();
                Commit commit = (Commit)tuple2._2();
                commit.offsets().foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                        TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                        return (scala.collection.mutable.Map)acc.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, acc.get((Object)tp).map((Function1 & Serializable)current -> {
                            if (current.offset() > offset.offset()) {
                                return current;
                            }
                            return offset;
                        }).getOrElse(() -> LiveCommitter.mergeCommitOffsets$$anonfun$1$$anonfun$1$$anonfun$2(offset))));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return acc;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ZIO<Object, Nothing$, BoxedUnit> handleCommitCompletion(Chunk<Commit> commits, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, long startTime, Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> commitResults) {
        return ZIO$.MODULE$.from(() -> LiveCommitter.handleCommitCompletion$$anonfun$1(commitResults), ZIO.ZIOConstructor$.MODULE$.EitherConstructor(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:99)").zipLeft(() -> this.handleCommitCompletion$$anonfun$2(startTime, commits), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:107)").zipLeft(() -> LiveCommitter.handleCommitCompletion$$anonfun$3(commits), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:108)").tap((Function1 & Serializable)offsetsWithMetaData -> this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> LiveCommitter.handleCommitCompletion$$anonfun$4$$anonfun$1(offsetsWithMetaData))), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:109)").catchAllCause((Function1 & Serializable)x$12 -> {
            Cause cause = x$12;
            if (cause instanceof Cause.Fail) {
                Cause.Fail fail = Cause.Fail$.MODULE$.unapply((Cause.Fail)cause);
                Exception exception = (Exception)fail._1();
                StackTrace stackTrace = fail._2();
                if (exception instanceof RebalanceInProgressException) {
                    return ZIO$.MODULE$.logDebug(() -> LiveCommitter.handleCommitCompletion$$anonfun$5$$anonfun$1(offsets), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:113)").flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.commitQueue.offerAll((Iterable)commits, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:114)").flatMap((Function1 & Serializable)x$12 -> {
                            Chunk chunk = x$12;
                            return this.onCommitAvailable.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:116)");
                        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:116)");
                    }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:116)");
                }
            }
            Cause c = cause;
            return ZIO$.MODULE$.foreachDiscard(() -> LiveCommitter.handleCommitCompletion$$anonfun$5$$anonfun$3(commits), (Function1 & Serializable)_$8 -> _$8.cont().done(Exit$.MODULE$.fail((Object)c.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()))), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:118)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:118)").$less$times(() -> this.handleCommitCompletion$$anonfun$5$$anonfun$5(offsets, c), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:120)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:121)").ignore((Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:122)");
    }

    private ZIO<Object, Throwable, BoxedUnit> commitAsyncZIO(Consumer<byte[], byte[]> consumer, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>, ZIO<Object, Nothing$, BoxedUnit>> doOnComplete) {
        return ZIO$.MODULE$.runtime((Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:136)").flatMap((Function1 & Serializable)runtime -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava(), new OffsetCommitCallback((Runtime)runtime, (Function1)doOnComplete){
            private final Runtime runtime$2;
            private final Function1 doOnComplete$3;
            {
                this.runtime$2 = runtime$3;
                this.doOnComplete$3 = doOnComplete$4;
            }

            public void onComplete(java.util.Map offsets, Exception exception) {
                Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)unsafe -> this.runtime$2.unsafe().run(exception == null ? (ZIO)this.doOnComplete$3.apply((Object)scala.package$.MODULE$.Right().apply((Object)CollectionConverters$.MODULE$.MapHasAsScala(offsets).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))) : (ZIO)this.doOnComplete$3.apply((Object)scala.package$.MODULE$.Left().apply((Object)exception)), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO.$anon.onComplete(LiveCommitter.scala:149)", unsafe).getOrThrowFiberFailure(unsafe));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onComplete$$anonfun$1(java.lang.Exception java.util.Map zio.Unsafe )}, serializedLambda);
            }
        }), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:153)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:154)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.commitAsyncZIO(LiveCommitter.scala:154)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> queueSize() {
        return this.commitQueue.size((Object)"zio.kafka.consumer.internal.LiveCommitter.queueSize(LiveCommitter.scala:156)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> pendingCommitCount() {
        return this.pendingCommits.get((Object)"zio.kafka.consumer.internal.LiveCommitter.pendingCommitCount(LiveCommitter.scala:158)").map((Function1 & Serializable)_$9 -> _$9.size(), (Object)"zio.kafka.consumer.internal.LiveCommitter.pendingCommitCount(LiveCommitter.scala:158)");
    }

    @Override
    public ZIO<Object, Nothing$, Committer.CommitOffsets> getPendingCommits() {
        return this.pendingCommits.get((Object)"zio.kafka.consumer.internal.LiveCommitter.getPendingCommits(LiveCommitter.scala:161)").map((Function1 & Serializable)_$10 -> (Committer.CommitOffsets)Committer$CommitOffsets$.MODULE$.empty().addCommits((Chunk<Commit>)_$10)._2(), (Object)"zio.kafka.consumer.internal.LiveCommitter.getPendingCommits(LiveCommitter.scala:161)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> cleanupPendingCommits() {
        return this.pendingCommits.updateZIO((Function1 & Serializable)_$11 -> _$11.filterZIO((Function1 & Serializable)_$12 -> _$12.isPending(), (Object)"zio.kafka.consumer.internal.LiveCommitter.cleanupPendingCommits(LiveCommitter.scala:164)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.cleanupPendingCommits(LiveCommitter.scala:164)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> keepCommitsForPartitions(Set<TopicPartition> assignedPartitions) {
        return this.committedOffsetsRef.update((Function1 & Serializable)_$13 -> _$13.keepPartitions(assignedPartitions), (Object)"zio.kafka.consumer.internal.LiveCommitter.keepCommitsForPartitions(LiveCommitter.scala:167)");
    }

    @Override
    public ZIO<Object, Nothing$, Committer.CommitOffsets> getCommittedOffsets() {
        return this.committedOffsetsRef.get((Object)"zio.kafka.consumer.internal.LiveCommitter.getCommittedOffsets(LiveCommitter.scala:169)");
    }

    private static final DiagnosticEvent $init$$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.immutable.Map offsets$5) {
        return DiagnosticEvent$Commit$Started$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$5);
    }

    private static final Throwable $init$$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        return Consumer$CommitTimeout$.MODULE$;
    }

    private static final Duration $init$$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Duration commitTimeout$6) {
        return commitTimeout$6;
    }

    private static final /* synthetic */ ZIO $init$$$anonfun$2$$anonfun$2$$anonfun$1(ZIO onCommitAvailable$3, Diagnostics diagnostics$3, scala.collection.immutable.Map offsets$3, Promise p$1, Duration commitTimeout$3, long startTime$1, ConsumerMetrics consumerMetrics$3, boolean x$12) {
        boolean bl = x$12;
        return onCommitAvailable$3.flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return diagnostics$3.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> LiveCommitter.$init$$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(offsets$3))).flatMap((Function1 & Serializable)x$13 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return p$1.await((Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:44)").timeoutFail(LiveCommitter::$init$$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1, () -> LiveCommitter.$init$$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(commitTimeout$3), (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:44)").map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit;
                    BoxedUnit $1$ = boxedUnit = BoxedUnit.UNIT;
                    long endTime = System.nanoTime();
                    Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(package$.MODULE$.durationLong(endTime - startTime$1));
                    return Tuple3$.MODULE$.apply((Object)$1$, (Object)BoxesRunTime.boxToLong((long)endTime), (Object)latency);
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:46)").flatMap((Function1 & Serializable)x$12 -> {
                    Tuple3 tuple3 = x$12;
                    if (tuple3 != null) {
                        long endTime = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        Duration latency = (Duration)tuple3._3();
                        return consumerMetrics$3.observeCommit(latency).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:48)");
                    }
                    throw new MatchError((Object)tuple3);
                }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:48)");
            }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:48)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.commit(LiveCommitter.scala:48)");
    }

    private static final String processQueuedCommits$$anonfun$1$$anonfun$1(Chunk commits$1) {
        return new StringBuilder(19).append("Processing ").append(commits$1.size()).append(" commits").toString();
    }

    private static final boolean processQueuedCommits$$anonfun$1$$anonfun$2$$anonfun$1(Chunk commits$3, boolean executeOnEmpty$2) {
        return commits$3.nonEmpty() || executeOnEmpty$2;
    }

    private final /* synthetic */ ZIO processQueuedCommits$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(Consumer consumer$5, scala.collection.immutable.Map offsetsWithMetaData$2, Chunk commits$7, long startTime) {
        return this.commitAsyncZIO((Consumer<byte[], byte[]>)consumer$5, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$2, (Function1<Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>)(Function1 & Serializable)_$4 -> this.handleCommitCompletion((Chunk<Commit>)commits$7, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$2, startTime, (Either<Exception, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)_$4)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:75)");
    }

    private final ZIO processQueuedCommits$$anonfun$1$$anonfun$2$$anonfun$2(Chunk commits$4, Consumer consumer$3) {
        scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets = this.mergeCommitOffsets((Chunk<Commit>)commits$4);
        scala.collection.immutable.Map offsetsWithMetaData = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)new OffsetAndMetadata(offset.offset() + 1L, offset.leaderEpoch(), offset.metadata()));
            }
            throw new MatchError((Object)tuple2);
        });
        return this.pendingCommits.update((Function1 & Serializable)_$2 -> _$2.$plus$plus(commits$4), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:67)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ZIO$.MODULE$.clockWith((Function1 & Serializable)_$3 -> _$3.nanoTime((Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:68)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:68)").flatMap((Function1 & Serializable)startTime -> this.processQueuedCommits$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(consumer$3, offsetsWithMetaData, commits$4, BoxesRunTime.unboxToLong((Object)startTime)), (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:75)");
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.processQueuedCommits(LiveCommitter.scala:75)");
    }

    private static final OffsetAndMetadata mergeCommitOffsets$$anonfun$1$$anonfun$1$$anonfun$2(OffsetAndMetadata offset$2) {
        return offset$2;
    }

    private static final Either handleCommitCompletion$$anonfun$1(Either commitResults$1) {
        return commitResults$1;
    }

    private static final /* synthetic */ Tuple2 handleCommitCompletion$$anonfun$2$$anonfun$2(long startTime$7, long endTime) {
        Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(package$.MODULE$.durationLong(endTime - startTime$7));
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)endTime), (Object)latency);
    }

    private static final boolean handleCommitCompletion$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(Chunk commits$13) {
        return commits$13.nonEmpty();
    }

    private final /* synthetic */ ZIO handleCommitCompletion$$anonfun$2$$anonfun$3$$anonfun$2(Duration latency$1, Chunk commits$12, long offsetIncrease) {
        return this.consumerMetrics.observeAggregatedCommit(latency$1, offsetIncrease).when(() -> LiveCommitter.handleCommitCompletion$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(commits$12), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:105)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Option option = x$1;
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:106)");
    }

    private final ZIO handleCommitCompletion$$anonfun$2(long startTime$6, Chunk commits$9) {
        return ZIO$.MODULE$.clockWith((Function1 & Serializable)_$5 -> _$5.nanoTime((Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:102)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:102)").map((Function1 & Serializable)endTime -> LiveCommitter.handleCommitCompletion$$anonfun$2$$anonfun$2(startTime$6, BoxesRunTime.unboxToLong((Object)endTime)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:103)").flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long endTime = BoxesRunTime.unboxToLong((Object)tuple2._1());
                Duration latency = (Duration)tuple2._2();
                return this.committedOffsetsRef.modify((Function1 & Serializable)_$6 -> _$6.addCommits((Chunk<Commit>)commits$9), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:104)").flatMap((Function1 & Serializable)offsetIncrease -> this.handleCommitCompletion$$anonfun$2$$anonfun$3$$anonfun$2(latency, commits$9, BoxesRunTime.unboxToLong((Object)offsetIncrease)), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:106)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:106)");
    }

    private static final Iterable handleCommitCompletion$$anonfun$3$$anonfun$1(Chunk commits$15) {
        return commits$15;
    }

    private static final ZIO handleCommitCompletion$$anonfun$3(Chunk commits$14) {
        return ZIO$.MODULE$.foreachDiscard(() -> LiveCommitter.handleCommitCompletion$$anonfun$3$$anonfun$1(commits$14), (Function1 & Serializable)_$7 -> _$7.cont().done(Exit$.MODULE$.unit(), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:108)"), (Object)"zio.kafka.consumer.internal.LiveCommitter.handleCommitCompletion(LiveCommitter.scala:108)");
    }

    private static final DiagnosticEvent handleCommitCompletion$$anonfun$4$$anonfun$1(scala.collection.immutable.Map offsetsWithMetaData$4) {
        return DiagnosticEvent$Commit$Success$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$4);
    }

    private static final String handleCommitCompletion$$anonfun$5$$anonfun$1(scala.collection.immutable.Map offsets$7) {
        return new StringBuilder(58).append("Rebalance in progress, commit for offsets ").append(offsets$7).append(" will be retried").toString();
    }

    private static final Iterable handleCommitCompletion$$anonfun$5$$anonfun$3(Chunk commits$18) {
        return commits$18;
    }

    private static final DiagnosticEvent handleCommitCompletion$$anonfun$5$$anonfun$5$$anonfun$1(scala.collection.immutable.Map offsets$9, Cause c$3) {
        return DiagnosticEvent$Commit$Failure$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$9, c$3.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private final ZIO handleCommitCompletion$$anonfun$5$$anonfun$5(scala.collection.immutable.Map offsets$8, Cause c$2) {
        return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> LiveCommitter.handleCommitCompletion$$anonfun$5$$anonfun$5$$anonfun$1(offsets$8, c$2)));
    }

    public static final class Commit
    implements Product,
    Serializable {
        private final long createdAt;
        private final scala.collection.immutable.Map offsets;
        private final Promise cont;

        public static Commit apply(long l, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map, Promise<Throwable, BoxedUnit> promise) {
            return LiveCommitter$Commit$.MODULE$.apply(l, map, promise);
        }

        public static Commit fromProduct(Product product) {
            return LiveCommitter$Commit$.MODULE$.fromProduct(product);
        }

        public static Commit unapply(Commit commit) {
            return LiveCommitter$Commit$.MODULE$.unapply(commit);
        }

        public Commit(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            this.createdAt = createdAt;
            this.offsets = offsets;
            this.cont = cont;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.createdAt()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offsets()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cont()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Commit)) return false;
            Commit commit = (Commit)object;
            if (this.createdAt() != commit.createdAt()) return false;
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = this.offsets();
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map2 = commit.offsets();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Promise<Throwable, BoxedUnit> promise = this.cont();
            Promise<Throwable, BoxedUnit> promise2 = commit.cont();
            if (promise == null) {
                if (promise2 == null) return true;
                return false;
            } else {
                if (!promise.equals(promise2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Commit;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Commit";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "createdAt";
                }
                case 1: {
                    return "offsets";
                }
                case 2: {
                    return "cont";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long createdAt() {
            return this.createdAt;
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets() {
            return this.offsets;
        }

        public Promise<Throwable, BoxedUnit> cont() {
            return this.cont;
        }

        public ZIO<Object, Nothing$, Object> isPending() {
            return this.cont().isDone((Object)"zio.kafka.consumer.internal.LiveCommitter.Commit.isPending(LiveCommitter.scala:197)").negate(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.internal.LiveCommitter.Commit.isPending(LiveCommitter.scala:197)");
        }

        public Commit copy(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            return new Commit(createdAt, offsets, cont);
        }

        public long copy$default$1() {
            return this.createdAt();
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> copy$default$2() {
            return this.offsets();
        }

        public Promise<Throwable, BoxedUnit> copy$default$3() {
            return this.cont();
        }

        public long _1() {
            return this.createdAt();
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> _2() {
            return this.offsets();
        }

        public Promise<Throwable, BoxedUnit> _3() {
            return this.cont();
        }
    }
}

