/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.NotGiven$;
import scala.util.matching.Regex;
import zio.CanFail$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.Clock$;
import zio.Dequeue;
import zio.Executor;
import zio.Hub;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Ref;
import zio.Runtime;
import zio.Schedule;
import zio.Schedule$;
import zio.Scope;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.Zippable$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.CommittableRecord$;
import zio.kafka.consumer.Consumer;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Auto$;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Manual$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.InvalidSubscriptionUnion;
import zio.kafka.consumer.InvalidSubscriptionUnion$;
import zio.kafka.consumer.OffsetBatch;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.RebalanceListener$;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.Subscription$;
import zio.kafka.consumer.Subscription$Manual$;
import zio.kafka.consumer.Subscription$Pattern$;
import zio.kafka.consumer.Subscription$Topics$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Poll$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Rebalance$;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.ConsumerMetrics;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.PartitionStreamControl$;
import zio.kafka.consumer.internal.RebalanceCoordinator;
import zio.kafka.consumer.internal.RebalanceCoordinator$RebalanceCallback$;
import zio.kafka.consumer.internal.RebalanceCoordinator$RebalanceEvent$;
import zio.kafka.consumer.internal.Runloop$;
import zio.kafka.consumer.internal.Runloop$FulfillResult$;
import zio.kafka.consumer.internal.Runloop$PollResult$;
import zio.kafka.consumer.internal.Runloop$RevokeResult$;
import zio.kafka.consumer.internal.Runloop$State$;
import zio.kafka.consumer.internal.Runloop$StreamOps$;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.kafka.consumer.internal.RunloopCommand$AddSubscription$;
import zio.kafka.consumer.internal.RunloopCommand$Poll$;
import zio.kafka.consumer.internal.RunloopCommand$RemoveAllSubscriptions$;
import zio.kafka.consumer.internal.RunloopCommand$RemoveSubscription$;
import zio.kafka.consumer.internal.RunloopCommand$Request$;
import zio.kafka.consumer.internal.RunloopCommand$StopAllStreams$;
import zio.kafka.consumer.internal.RunloopCommand$StopRunloop$;
import zio.kafka.consumer.internal.SubscriptionState;
import zio.kafka.consumer.internal.SubscriptionState$NotSubscribed$;
import zio.kafka.consumer.internal.SubscriptionState$Subscribed$;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Runloop {
    private final ConsumerSettings settings;
    private final Executor topLevelExecutor;
    private final Runtime<Object> sameThreadRuntime;
    private final ConsumerAccess consumer;
    private final Queue<RunloopCommand> commandQueue;
    private final Hub<Take<Throwable, Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>>>> partitionsHub;
    private final Diagnostics diagnostics;
    private final Duration maxStreamPullInterval;
    private final Ref<State> currentStateRef;
    private final RebalanceCoordinator rebalanceCoordinator;
    private final ConsumerMetrics consumerMetrics;
    private final Committer committer;
    private final Ref<Option<ConsumerGroupMetadata>> groupMetadataRef;
    private final ZIO<Object, Nothing$, Option<ConsumerGroupMetadata>> getConsumerGroupMetadataIfAny;

    public static ZIO<Scope, Nothing$, Runloop> make(ConsumerSettings consumerSettings, Duration duration, Duration duration2, Diagnostics diagnostics, ConsumerAccess consumerAccess, Hub<Take<Throwable, Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>>>> hub) {
        return Runloop$.MODULE$.make(consumerSettings, duration, duration2, diagnostics, consumerAccess, hub);
    }

    public Runloop(ConsumerSettings settings, Executor topLevelExecutor, Runtime<Object> sameThreadRuntime, ConsumerAccess consumer, Queue<RunloopCommand> commandQueue, Hub<Take<Throwable, Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>>>> partitionsHub, Diagnostics diagnostics, Duration maxStreamPullInterval, Ref<State> currentStateRef, RebalanceCoordinator rebalanceCoordinator, ConsumerMetrics consumerMetrics, Committer committer, Ref<Option<ConsumerGroupMetadata>> groupMetadataRef) {
        ZIO zIO;
        this.settings = settings;
        this.topLevelExecutor = topLevelExecutor;
        this.sameThreadRuntime = sameThreadRuntime;
        this.consumer = consumer;
        this.commandQueue = commandQueue;
        this.partitionsHub = partitionsHub;
        this.diagnostics = diagnostics;
        this.maxStreamPullInterval = maxStreamPullInterval;
        this.currentStateRef = currentStateRef;
        this.rebalanceCoordinator = rebalanceCoordinator;
        this.consumerMetrics = consumerMetrics;
        this.committer = committer;
        this.groupMetadataRef = groupMetadataRef;
        if (settings.hasGroupId()) {
            zIO = groupMetadataRef.get((Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:164)").flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (None$.MODULE$.equals(option)) {
                    return consumer.runloopAccess((Function1 & Serializable)c -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$2 -> c.groupMetadata(), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:167)")).fold((Function1 & Serializable)_$2 -> None$.MODULE$, (Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:168)").tap((Function1 & Serializable)metadata -> groupMetadataRef.set(metadata, (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:169)"), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:169)");
                }
                Option metadata2 = option;
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:171)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return metadata2;
                });
            }, (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:172)");
        } else {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            zIO = ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:173)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return None$.MODULE$;
            });
        }
        this.getConsumerGroupMetadataIfAny = zIO;
    }

    private ZIO<Object, Nothing$, PartitionStreamControl> newPartitionStream(TopicPartition tp) {
        return PartitionStreamControl$.MODULE$.newPartitionStream(tp, (ZIO<Object, Nothing$, BoxedUnit>)this.commandQueue.offer((Object)RunloopCommand$Request$.MODULE$.apply(tp), (Object)"zio.kafka.consumer.internal.Runloop.newPartitionStream(Runloop.scala:38)").unit((Object)"zio.kafka.consumer.internal.Runloop.newPartitionStream(Runloop.scala:38)"), this.diagnostics, this.maxStreamPullInterval);
    }

    public ZIO<Object, Nothing$, BoxedUnit> stopConsumption() {
        return ZIO$.MODULE$.logDebug(Runloop::stopConsumption$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:44)").$times$greater(this::stopConsumption$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:45)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> shutdown() {
        return ZIO$.MODULE$.logDebug(Runloop::shutdown$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:48)").$times$greater(this::shutdown$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:57)");
    }

    public ZIO<Object, InvalidSubscriptionUnion, BoxedUnit> addSubscription(Subscription subscription) {
        return ZIO$.MODULE$.logDebug(() -> Runloop.addSubscription$$anonfun$1(subscription), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:61)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:62)").flatMap((Function1 & Serializable)promise -> this.commandQueue.offer((Object)RunloopCommand$AddSubscription$.MODULE$.apply(subscription, (Promise<InvalidSubscriptionUnion, BoxedUnit>)promise), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:63)").flatMap((Function1 & Serializable)x$1 -> Runloop.addSubscription$$anonfun$2$$anonfun$1$$anonfun$1(subscription, promise, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)"), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> removeSubscription(Subscription subscription) {
        return this.commandQueue.offer((Object)RunloopCommand$RemoveSubscription$.MODULE$.apply(subscription), (Object)"zio.kafka.consumer.internal.Runloop.removeSubscription(Runloop.scala:70)").unit((Object)"zio.kafka.consumer.internal.Runloop.removeSubscription(Runloop.scala:70)");
    }

    private ConsumerRebalanceListener makeRebalanceListener() {
        RebalanceListener rebalanceListener = this.settings.rebalanceListener();
        RebalanceListener rebalanceListener2 = RebalanceListener$.MODULE$.noop();
        RebalanceListener rebalanceListener3 = rebalanceListener;
        RebalanceListener userRebalanceListener = !(rebalanceListener2 != null ? !((Object)rebalanceListener2).equals(rebalanceListener3) : rebalanceListener3 != null) ? RebalanceListener$.MODULE$.noop() : this.settings.rebalanceListener().runOnExecutor(this.topLevelExecutor);
        return RebalanceListener$.MODULE$.toKafka(this.rebalanceCoordinator.toRebalanceListener().$plus$plus(userRebalanceListener), this.sameThreadRuntime);
    }

    private ZIO<Object, Nothing$, RevokeResult> endRevokedPartitions(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, Function1<TopicPartition, Object> isRevoked) {
        Tuple2 tuple2 = assignedStreams.partition((Function1 & Serializable)control -> BoxesRunTime.unboxToBoolean((Object)isRevoked.apply((Object)control.tp())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Chunk revokedStreams = (Chunk)tuple2._1();
        Chunk newAssignedStreams = (Chunk)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)revokedStreams, (Object)newAssignedStreams);
        Chunk revokedStreams2 = (Chunk)tuple22._1();
        Chunk newAssignedStreams2 = (Chunk)tuple22._2();
        return ZIO$.MODULE$.foreachDiscard(() -> Runloop.endRevokedPartitions$$anonfun$1(revokedStreams2), (Function1 & Serializable)_$1 -> _$1.end(), (Object)"zio.kafka.consumer.internal.Runloop.endRevokedPartitions(Runloop.scala:98)").as(() -> Runloop.endRevokedPartitions$$anonfun$3(pendingRequests, isRevoked, newAssignedStreams2), (Object)"zio.kafka.consumer.internal.Runloop.endRevokedPartitions(Runloop.scala:104)");
    }

    private ZIO<Object, Nothing$, FulfillResult> offerRecordsToStreams(Chunk<PartitionStreamControl> partitionStreams, Chunk<RunloopCommand.Request> pendingRequests, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, ConsumerRecords<byte[], byte[]> polledRecords) {
        Chunk streams;
        scala.collection.immutable.Set tps = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(polledRecords.partitions()).asScala().toSet().$minus$minus(ignoreRecordsForTps);
        FulfillResult fulfillResult = Runloop$FulfillResult$.MODULE$.apply((Chunk<RunloopCommand.Request>)pendingRequests.filter((Function1 & Serializable)req -> !tps.contains((Object)req.tp())));
        Chunk chunk = streams = tps.isEmpty() ? Chunk$.MODULE$.empty() : partitionStreams.filter((Function1 & Serializable)streamControl -> tps.contains((Object)streamControl.tp()));
        if (streams.isEmpty()) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:129)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return fulfillResult;
            });
        }
        return this.getConsumerGroupMetadataIfAny.flatMap((Function1 & Serializable)consumerGroupMetadata -> ZIO$.MODULE$.foreachParDiscard(() -> Runloop.offerRecordsToStreams$$anonfun$2$$anonfun$1(streams), (Function1 & Serializable)streamControl -> {
            TopicPartition tp = streamControl.tp();
            List records = polledRecords.records(tp);
            if (records.isEmpty()) {
                return streamControl.offerRecords((Chunk<CommittableRecord<byte[], byte[]>>)Chunk$.MODULE$.empty());
            }
            ChunkBuilder builder = ChunkBuilder$.MODULE$.make(records.size());
            for (ConsumerRecord consumerRecord : records) {
                builder.$plus$eq(CommittableRecord$.MODULE$.apply(consumerRecord, this.committer.commit(), (Option<ConsumerGroupMetadata>)consumerGroupMetadata));
            }
            return streamControl.offerRecords((Chunk<CommittableRecord<byte[], byte[]>>)((Chunk)builder.result()));
        }, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:152)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return fulfillResult;
        }, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:153)"), (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:153)");
    }

    private ZIO<Object, Throwable, scala.collection.immutable.Set<TopicPartition>> doSeekForNewPartitions(Consumer<byte[], byte[]> c, scala.collection.immutable.Set<TopicPartition> tps) {
        Consumer.OffsetRetrieval offsetRetrieval = this.settings.offsetRetrieval();
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Auto) {
            Consumer.OffsetRetrieval.Auto auto = Consumer$OffsetRetrieval$Auto$.MODULE$.unapply((Consumer.OffsetRetrieval.Auto)offsetRetrieval);
            Consumer.AutoOffsetStrategy autoOffsetStrategy = auto._1();
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:178)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return Predef$.MODULE$.Set().empty();
            });
        }
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Manual) {
            Consumer.OffsetRetrieval.Manual manual = Consumer$OffsetRetrieval$Manual$.MODULE$.unapply((Consumer.OffsetRetrieval.Manual)offsetRetrieval);
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, Map<TopicPartition, Object>>> function1 = manual._1();
            Consumer.AutoOffsetStrategy autoOffsetStrategy = manual._2();
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, Map<TopicPartition, Object>>> getOffsets = function1;
            if (tps.isEmpty()) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:180)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return Predef$.MODULE$.Set().empty();
                });
            }
            return ((ZIO)getOffsets.apply(tps)).flatMap((Function1 & Serializable)offsets -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$7 -> offsets.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    c.seek(tp, offset);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:184)").as(() -> Runloop.doSeekForNewPartitions$$anonfun$3$$anonfun$2(offsets), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:185)"), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:186)");
        }
        throw new MatchError((Object)offsetRetrieval);
    }

    private ZIO<Object, Throwable, Tuple2<Object, Object>> resumeAndPausePartitions(Consumer<byte[], byte[]> c, scala.collection.immutable.Set<TopicPartition> requestedPartitions) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$8 -> {
            scala.collection.immutable.Set assignment = CollectionConverters$.MODULE$.SetHasAsScala(c.assignment()).asScala().toSet();
            scala.collection.immutable.Set toResume = (scala.collection.immutable.Set)assignment.intersect((Set)requestedPartitions);
            scala.collection.immutable.Set toPause = (scala.collection.immutable.Set)assignment.$minus$minus((IterableOnce)requestedPartitions);
            if (toResume.nonEmpty()) {
                c.resume((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)toResume).asJava());
            }
            if (toPause.nonEmpty()) {
                c.pause((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)toPause).asJava());
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)toResume.size()), (Object)BoxesRunTime.boxToInteger((int)toPause.size()));
        }, (Object)"zio.kafka.consumer.internal.Runloop.resumeAndPausePartitions(Runloop.scala:204)");
    }

    private ZIO<Object, Throwable, ConsumerRecords<byte[], byte[]>> doPoll(Consumer<byte[], byte[]> c) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$9 -> {
            ConsumerRecords recordsOrNull = c.poll(this.settings.pollTimeout());
            if (recordsOrNull == null) {
                return ConsumerRecords.empty();
            }
            return recordsOrNull;
        }, (Object)"zio.kafka.consumer.internal.Runloop.doPoll(Runloop.scala:211)").retry(this::doPoll$$anonfun$2, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.doPoll(Runloop.scala:220)");
    }

    private ZIO<Object, Throwable, State> handlePoll(State state) {
        return this.settings.fetchStrategy().selectPartitionsToFetch(state.assignedStreams()).flatMap((Function1 & Serializable)partitionsToFetch -> this.committer.pendingCommitCount().flatMap((Function1 & Serializable)pendingCommitCount -> this.handlePoll$$anonfun$1$$anonfun$1(state, (scala.collection.immutable.Set)partitionsToFetch, BoxesRunTime.unboxToInt((Object)pendingCommitCount)), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)");
    }

    private ZIO<Object, Nothing$, BoxedUnit> checkStreamPullInterval(Chunk<PartitionStreamControl> streams) {
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:376)").flatMap((Function1 & Serializable)now -> this.checkStreamPullInterval$$anonfun$1(streams, BoxesRunTime.unboxToLong((Object)now)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:385)");
    }

    private ZIO<Object, Throwable, State> handleCommand(State state, RunloopCommand.StreamCommand cmd) {
        RunloopCommand.StreamCommand streamCommand = cmd;
        if (streamCommand instanceof RunloopCommand.Request) {
            RunloopCommand.Request req = (RunloopCommand.Request)streamCommand;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:416)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                if (state.assignedStreams().exists((Function1 & Serializable)_$17 -> {
                    TopicPartition topicPartition = _$17.tp();
                    TopicPartition topicPartition2 = req.tp();
                    return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
                })) {
                    return state.addRequest(req);
                }
                return state;
            });
        }
        if (streamCommand instanceof RunloopCommand.AddSubscription) {
            RunloopCommand.AddSubscription addSubscription = (RunloopCommand.AddSubscription)streamCommand;
            RunloopCommand.AddSubscription addSubscription2 = RunloopCommand$AddSubscription$.MODULE$.unapply(addSubscription);
            Subscription subscription = addSubscription2._1();
            Promise<InvalidSubscriptionUnion, BoxedUnit> promise = addSubscription2._2();
            Subscription newSubscription = subscription;
            RunloopCommand.AddSubscription cmd2 = addSubscription;
            SubscriptionState subscriptionState = state.subscriptionState();
            if (SubscriptionState$NotSubscribed$.MODULE$.equals(subscriptionState)) {
                SubscriptionState.Subscribed newSubState = SubscriptionState$Subscribed$.MODULE$.apply((scala.collection.immutable.Set<Subscription>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscription[]{newSubscription}))), newSubscription);
                return cmd2.succeed().$times$greater(() -> this.handleCommand$$anonfun$2(newSubState, state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:422)");
            }
            if (subscriptionState instanceof SubscriptionState.Subscribed) {
                SubscriptionState.Subscribed subscribed = SubscriptionState$Subscribed$.MODULE$.unapply((SubscriptionState.Subscribed)subscriptionState);
                scala.collection.immutable.Set<Subscription> set = subscribed._1();
                Subscription subscription2 = subscribed._2();
                scala.collection.immutable.Set<Subscription> existingSubscriptions = set;
                NonEmptyChunk subs2 = NonEmptyChunk$.MODULE$.fromIterable((Object)newSubscription, existingSubscriptions);
                Option<Subscription> option = Subscription$.MODULE$.unionAll((NonEmptyChunk<Subscription>)subs2);
                if (None$.MODULE$.equals(option)) {
                    return cmd2.fail(InvalidSubscriptionUnion$.MODULE$.apply((Chunk<Subscription>)NonEmptyChunk$.MODULE$.toChunk(subs2))).as(() -> Runloop.handleCommand$$anonfun$3(state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:427)");
                }
                if (option instanceof Some) {
                    Subscription union = (Subscription)((Some)option).value();
                    SubscriptionState.Subscribed newSubState = SubscriptionState$Subscribed$.MODULE$.apply((scala.collection.immutable.Set<Subscription>)((scala.collection.immutable.Set)existingSubscriptions.$plus((Object)newSubscription)), union);
                    return cmd2.succeed().$times$greater(() -> this.handleCommand$$anonfun$4(newSubState, state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:434)");
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)subscriptionState);
        }
        if (streamCommand instanceof RunloopCommand.RemoveSubscription) {
            Subscription subscription;
            RunloopCommand.RemoveSubscription removeSubscription = RunloopCommand$RemoveSubscription$.MODULE$.unapply((RunloopCommand.RemoveSubscription)streamCommand);
            Subscription subscription3 = subscription = removeSubscription._1();
            SubscriptionState subscriptionState = state.subscriptionState();
            if (SubscriptionState$NotSubscribed$.MODULE$.equals(subscriptionState)) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:439)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return state;
                });
            }
            if (subscriptionState instanceof SubscriptionState.Subscribed) {
                Tuple2 tuple2;
                SubscriptionState.Subscribed subscribed = SubscriptionState$Subscribed$.MODULE$.unapply((SubscriptionState.Subscribed)subscriptionState);
                scala.collection.immutable.Set<Subscription> set = subscribed._1();
                Subscription subscription4 = subscribed._2();
                scala.collection.immutable.Set<Subscription> existingSubscriptions = set;
                Option newUnion = NonEmptyChunk$.MODULE$.fromIterableOption((Iterable)existingSubscriptions.$minus((Object)subscription3)).flatMap((Function1 & Serializable)subs -> Subscription$.MODULE$.unionAll((NonEmptyChunk<Subscription>)subs).map((Function1 & Serializable)_$18 -> {
                    Subscription subscription = (Subscription)Predef$.MODULE$.ArrowAssoc(_$18);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)subscription, subs);
                }));
                Option option = newUnion;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Subscription union = (Subscription)tuple2._1();
                    NonEmptyChunk newSubscriptions = (NonEmptyChunk)tuple2._2();
                    SubscriptionState.Subscribed newSubState = SubscriptionState$Subscribed$.MODULE$.apply((scala.collection.immutable.Set<Subscription>)NonEmptyChunk$.MODULE$.toChunk(newSubscriptions).toSet(), union);
                    return this.doChangeSubscription$1(state, newSubState);
                }
                if (None$.MODULE$.equals(option)) {
                    return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$6, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:452)").$times$greater(() -> this.handleCommand$$anonfun$7(state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:453)");
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)subscriptionState);
        }
        if (RunloopCommand$RemoveAllSubscriptions$.MODULE$.equals(streamCommand)) {
            return this.doChangeSubscription$1(state, SubscriptionState$NotSubscribed$.MODULE$);
        }
        if (RunloopCommand$StopAllStreams$.MODULE$.equals(streamCommand)) {
            return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$8, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:459)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.foreachDiscard(() -> Runloop.handleCommand$$anonfun$9$$anonfun$1(state), (Function1 & Serializable)_$19 -> _$19.end(), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:460)").flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.partitionsHub.publish((Object)new Take(Take$.MODULE$.end()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:461)").flatMap((Function1 & Serializable)x$1 -> Runloop.handleCommand$$anonfun$9$$anonfun$3$$anonfun$1(state, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:463)");
                }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:463)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:463)");
        }
        throw new MatchError((Object)streamCommand);
    }

    private ZIO<Object, Throwable, Chunk<PartitionStreamControl>> applyNewSubscriptionState(SubscriptionState newSubscriptionState) {
        return this.consumer.runloopAccess((Function1 & Serializable)c -> {
            SubscriptionState subscriptionState = newSubscriptionState;
            if (SubscriptionState$NotSubscribed$.MODULE$.equals(subscriptionState)) {
                return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$15 -> c.unsubscribe(), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:474)").as(Runloop::applyNewSubscriptionState$$anonfun$1$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:475)");
            }
            if (subscriptionState instanceof SubscriptionState.Subscribed) {
                SubscriptionState.Subscribed subscribed = SubscriptionState$Subscribed$.MODULE$.unapply((SubscriptionState.Subscribed)subscriptionState);
                scala.collection.immutable.Set<Subscription> set = subscribed._1();
                Subscription subscription = subscribed._2();
                if (subscription instanceof Subscription.Pattern) {
                    Regex regex;
                    Subscription.Pattern pattern = Subscription$Pattern$.MODULE$.unapply((Subscription.Pattern)subscription);
                    Regex pattern2 = regex = pattern._1();
                    ConsumerRebalanceListener rebalanceListener = this.makeRebalanceListener();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$16 -> c.subscribe(pattern2.pattern(), rebalanceListener), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:479)").as(Runloop::applyNewSubscriptionState$$anonfun$1$$anonfun$4, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:480)");
                }
                if (subscription instanceof Subscription.Topics) {
                    scala.collection.immutable.Set<String> set2;
                    Subscription.Topics topics = Subscription$Topics$.MODULE$.unapply((Subscription.Topics)subscription);
                    scala.collection.immutable.Set<String> topics2 = set2 = topics._1();
                    ConsumerRebalanceListener rebalanceListener = this.makeRebalanceListener();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$17 -> c.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topics2).asJava(), rebalanceListener), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:484)").as(Runloop::applyNewSubscriptionState$$anonfun$1$$anonfun$6, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:485)");
                }
                if (subscription instanceof Subscription.Manual) {
                    scala.collection.immutable.Set<TopicPartition> set3;
                    Subscription.Manual manual = Subscription$Manual$.MODULE$.unapply((Subscription.Manual)subscription);
                    scala.collection.immutable.Set<TopicPartition> topicPartitions = set3 = manual._1();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$18 -> c.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topicPartitions).asJava()), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:489)").flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.doSeekForNewPartitions((Consumer<byte[], byte[]>)c, topicPartitions).flatMap((Function1 & Serializable)x$1 -> {
                            scala.collection.immutable.Set set = x$1;
                            return ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable((Iterable)topicPartitions), (Function1 & Serializable)tp -> this.newPartitionStream((TopicPartition)tp), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:491)").flatMap((Function1 & Serializable)partitionStreams -> this.partitionsHub.publish((Object)new Take(Take$.MODULE$.chunk(partitionStreams.map((Function1 & Serializable)_$20 -> _$20.tpStream()))), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:492)").map((Function1 & Serializable)x$1 -> Runloop.applyNewSubscriptionState$$anonfun$1$$anonfun$8$$anonfun$1$$anonfun$2$$anonfun$2(partitionStreams, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:493)"), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:493)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:493)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:493)");
                }
            }
            throw new MatchError((Object)subscriptionState);
        });
    }

    public ZIO<Scope, Throwable, Object> zio$kafka$consumer$internal$Runloop$$run(State initialState) {
        ZStream zStream = Runloop$.MODULE$.zio$kafka$consumer$internal$Runloop$$$StreamOps(ZStream$.MODULE$.fromQueue(this::run$$anonfun$1, Runloop::run$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:515)").takeWhile((Function1 & Serializable)_$21 -> {
            RunloopCommand runloopCommand = _$21;
            RunloopCommand$StopRunloop$ runloopCommand$StopRunloop$ = RunloopCommand$StopRunloop$.MODULE$;
            return runloopCommand == null ? runloopCommand$StopRunloop$ != null : !runloopCommand.equals(runloopCommand$StopRunloop$);
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:516)"));
        return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(zStream, initialState, (Function2 & Serializable)(state, commands) -> ZIO$.MODULE$.logDebug(() -> Runloop.run$$anonfun$4$$anonfun$1(commands), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:519)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.consumer.runloopAccess((Function1 & Serializable)_$22 -> this.committer.processQueuedCommits((Consumer<byte[], byte[]>)_$22, this.committer.processQueuedCommits$default$2())).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit;
                BoxedUnit $7$ = boxedUnit = BoxedUnit.UNIT;
                Chunk streamCommands = commands.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(RunloopCommand x) {
                        RunloopCommand runloopCommand = x;
                        if (runloopCommand instanceof RunloopCommand.StreamCommand) {
                            RunloopCommand.StreamCommand cmd = (RunloopCommand.StreamCommand)runloopCommand;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(RunloopCommand x, Function1 function1) {
                        RunloopCommand runloopCommand = x;
                        if (runloopCommand instanceof RunloopCommand.StreamCommand) {
                            RunloopCommand.StreamCommand cmd = (RunloopCommand.StreamCommand)runloopCommand;
                            return cmd;
                        }
                        return function1.apply((Object)x);
                    }
                });
                return Tuple2$.MODULE$.apply((Object)$7$, (Object)streamCommands);
            }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:521)").flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Chunk streamCommands = (Chunk)tuple2._2();
                    return ZIO$.MODULE$.foldLeft(() -> Runloop.run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$1(streamCommands), () -> Runloop.run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$2(state), (Function2 & Serializable)(state, cmd) -> this.handleCommand((State)state, (RunloopCommand.StreamCommand)cmd), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:522)").flatMap((Function1 & Serializable)stateAfterCommands -> this.shouldPoll((State)stateAfterCommands).flatMap((Function1 & Serializable)x$1 -> this.run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$1((State)stateAfterCommands, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:527)").flatMap((Function1 & Serializable)updatedStateAfterPoll -> {
                        Function0 function0 = ZIO$.MODULE$.whenZIO(() -> this.run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$1(updatedStateAfterPoll));
                        return ZIO.WhenZIO$.MODULE$.apply$extension(function0, this::run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:529)").flatMap((Function1 & Serializable)x$12 -> {
                            Option option = x$12;
                            return this.currentStateRef.set(updatedStateAfterPoll, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:531)").map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return updatedStateAfterPoll;
                            }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:532)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:532)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:532)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:532)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:532)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:532)")).tapErrorCause((Function1 & Serializable)cause -> ZIO$.MODULE$.logErrorCause(Runloop::run$$anonfun$5$$anonfun$1, () -> Runloop.run$$anonfun$5$$anonfun$2(cause), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:534)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:534)").onError((Function1 & Serializable)cause -> this.partitionsHub.offer((Object)new Take(Take$.MODULE$.failCause(cause)), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:535)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:535)");
    }

    public ZIO<Object, Nothing$, Object> shouldPoll(State state) {
        return this.committer.pendingCommitCount().map((Function1)(JFunction1.mcZI.sp & Serializable)pendingCommitCount -> state.subscriptionState().isSubscribed() && (state.pendingRequests().nonEmpty() || pendingCommitCount > 0 || state.assignedStreams().isEmpty()), (Object)"zio.kafka.consumer.internal.Runloop.shouldPoll(Runloop.scala:541)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> zio$kafka$consumer$internal$Runloop$$observeRunloopMetrics(Schedule<Object, BoxedUnit, Object> runloopMetricsSchedule) {
        ZIO observe = this.currentStateRef.get((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:545)").flatMap((Function1 & Serializable)currentState -> this.commandQueue.size((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:546)").flatMap((Function1 & Serializable)commandQueueSize -> this.$anonfun$10$$anonfun$1((State)currentState, BoxesRunTime.unboxToInt((Object)commandQueueSize)), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:551)"), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:551)");
        return observe.repeat(() -> Runloop.observeRunloopMetrics$$anonfun$1(runloopMetricsSchedule), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics(Runloop.scala:554)").unit((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics(Runloop.scala:555)");
    }

    public ZIO<Object, Throwable, BoxedUnit> registerExternalCommits(OffsetBatch offsetBatch) {
        return (ZIO)this.committer.registerExternalCommits().apply(offsetBatch.offsets());
    }

    private static final String stopConsumption$$anonfun$1() {
        return "stopConsumption called";
    }

    private final ZIO stopConsumption$$anonfun$2() {
        return this.commandQueue.offer((Object)RunloopCommand$StopAllStreams$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:45)").unit((Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:45)");
    }

    private static final String shutdown$$anonfun$1() {
        return "Shutting down runloop initiated";
    }

    private final ZIO shutdown$$anonfun$2() {
        return this.commandQueue.offerAll((Iterable)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RunloopCommand[]{RunloopCommand$RemoveAllSubscriptions$.MODULE$, RunloopCommand$StopAllStreams$.MODULE$, RunloopCommand$StopRunloop$.MODULE$})), (Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:56)").unit((Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:57)");
    }

    private static final String addSubscription$$anonfun$1(Subscription subscription$1) {
        return new StringBuilder(17).append("Add subscription ").append(subscription$1).toString();
    }

    private static final String addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Subscription subscription$5) {
        return new StringBuilder(25).append("Waiting for subscription ").append(subscription$5).toString();
    }

    private static final String addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Subscription subscription$8) {
        return new StringBuilder(22).append("Done for subscription ").append(subscription$8).toString();
    }

    private static final /* synthetic */ ZIO addSubscription$$anonfun$2$$anonfun$1$$anonfun$1(Subscription subscription$4, Promise promise$1, boolean x$12) {
        boolean bl = x$12;
        return ZIO$.MODULE$.logDebug(() -> Runloop.addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(subscription$4), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:64)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return promise$1.await((Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:65)").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.logDebug(() -> Runloop.addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(subscription$4), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:66)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)");
    }

    private static final Iterable endRevokedPartitions$$anonfun$1(Chunk revokedStreams$1) {
        return revokedStreams$1;
    }

    private static final RevokeResult endRevokedPartitions$$anonfun$3(Chunk pendingRequests$2, Function1 isRevoked$2, Chunk newAssignedStreams$1) {
        return Runloop$RevokeResult$.MODULE$.apply((Chunk<RunloopCommand.Request>)pendingRequests$2.filter((Function1 & Serializable)req -> !BoxesRunTime.unboxToBoolean((Object)isRevoked$2.apply((Object)req.tp()))), (Chunk<PartitionStreamControl>)newAssignedStreams$1);
    }

    private static final Iterable offerRecordsToStreams$$anonfun$2$$anonfun$1(Chunk streams$2) {
        return streams$2;
    }

    private static final scala.collection.immutable.Set doSeekForNewPartitions$$anonfun$3$$anonfun$2(Map offsets$2) {
        return offsets$2.keySet();
    }

    private static final boolean doPoll$$anonfun$2$$anonfun$1$$anonfun$1() {
        return true;
    }

    private final Schedule doPoll$$anonfun$2() {
        return Schedule$.MODULE$.recurWhileZIO((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof AuthorizationException || throwable instanceof AuthenticationException) {
                return this.consumerMetrics.observePollAuthError().as(Runloop::doPoll$$anonfun$2$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.doPoll(Runloop.scala:216)");
            }
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.doPoll(Runloop.scala:217)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return false;
            });
        }).$amp$amp(this.settings.authErrorRetrySchedule(), Zippable$.MODULE$.Zippable2());
    }

    private static final String handlePoll$$anonfun$1$$anonfun$1$$anonfun$1(State state$3, int pendingCommitCount$1, scala.collection.immutable.Set partitionsToFetch$2) {
        return new StringBuilder(40).append("Starting poll with ").append(state$3.pendingRequests().size()).append(" pending requests and").append(new StringBuilder(18).append(" ").append(pendingCommitCount$1).append(" pending commits,").toString()).append(new StringBuilder(21).append(" resuming ").append(partitionsToFetch$2).append(" partitions").toString()).toString();
    }

    private static final DiagnosticEvent handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(ConsumerRecords polledRecords$4, State state$10) {
        scala.collection.immutable.Set providedTps = CollectionConverters$.MODULE$.SetHasAsScala(polledRecords$4.partitions()).asScala().toSet();
        scala.collection.immutable.Set requestedPartitions = state$10.pendingRequests().map((Function1 & Serializable)_$4 -> _$4.tp()).toSet();
        return DiagnosticEvent$Poll$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)requestedPartitions, (scala.collection.immutable.Set<TopicPartition>)providedTps, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)requestedPartitions.$minus$minus((IterableOnce)providedTps)));
    }

    private final ZIO handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(ConsumerRecords polledRecords$3, State state$9) {
        return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(polledRecords$3, state$9)));
    }

    private static final String handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(scala.collection.immutable.Set startingTps$2) {
        return new StringBuilder(30).append("Offering partition assignment ").append(startingTps$2).toString();
    }

    private final ZIO handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(Chunk newStreams$1) {
        return this.partitionsHub.publish((Object)new Take(Take$.MODULE$.chunk(newStreams$1.map((Function1 & Serializable)_$8 -> _$8.tpStream()))), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:293)");
    }

    private static final DiagnosticEvent handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(scala.collection.immutable.Set revokedTps$8, scala.collection.immutable.Set assignedTps$7, scala.collection.immutable.Set lostTps$8, Chunk endedStreams$8) {
        return DiagnosticEvent$Rebalance$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)revokedTps$8, (scala.collection.immutable.Set<TopicPartition>)assignedTps$7, (scala.collection.immutable.Set<TopicPartition>)lostTps$8, (scala.collection.immutable.Set<TopicPartition>)endedStreams$8.map((Function1 & Serializable)_$11 -> _$11.tp()).toSet());
    }

    private static final String handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(scala.collection.immutable.Set currentAssigned$8, Chunk updatedAssignedStreams$4) {
        return new StringBuilder(87).append("Not all assigned partitions have a (single) stream or vice versa. Assigned: ").append(currentAssigned$8.mkString(",")).append(", streams: ").append(updatedAssignedStreams$4.map((Function1 & Serializable)_$12 -> _$12.tp()).mkString(",")).toString();
    }

    private static final boolean handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(scala.collection.immutable.Set currentAssigned$9, Chunk updatedAssignedStreams$5) {
        scala.collection.immutable.Set set = currentAssigned$9;
        scala.collection.immutable.Set set2 = updatedAssignedStreams$5.map((Function1 & Serializable)_$13 -> _$13.tp()).toSet();
        return (set != null ? !set.equals(set2) : set2 != null) || currentAssigned$9.size() != updatedAssignedStreams$5.size();
    }

    private final /* synthetic */ ZIO handlePoll$$anonfun$1$$anonfun$1(State state$2, scala.collection.immutable.Set partitionsToFetch$1, int pendingCommitCount) {
        return ZIO$.MODULE$.logDebug(() -> Runloop.handlePoll$$anonfun$1$$anonfun$1$$anonfun$1(state$2, pendingCommitCount, partitionsToFetch$1), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:230)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.currentStateRef.set((Object)state$2, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:231)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.consumer.runloopAccess((Function1 & Serializable)c -> this.resumeAndPausePartitions((Consumer<byte[], byte[]>)c, (scala.collection.immutable.Set<TopicPartition>)partitionsToFetch$1).map((Function1 & Serializable)resumeAndPauseCounts -> {
                    Tuple2 tuple2 = resumeAndPauseCounts;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int toResumeCount = tuple2._1$mcI$sp();
                    int toPauseCount = tuple2._2$mcI$sp();
                    Tuple2 $2$ = tuple2;
                    Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$2$, (Object)BoxesRunTime.boxToInteger((int)toResumeCount), (Object)BoxesRunTime.boxToInteger((int)toPauseCount));
                    Tuple2 $2$2 = (Tuple2)tuple3._1();
                    int toResumeCount2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    int toPauseCount2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                    return Tuple2$.MODULE$.apply(resumeAndPauseCounts, (Object)$2$2);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:236)").flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Tuple2 resumeAndPauseCounts = (Tuple2)tuple2._1();
                        if (tuple22 != null) {
                            int toResumeCount = tuple22._1$mcI$sp();
                            int toPauseCount = tuple22._2$mcI$sp();
                            return this.doPoll((Consumer<byte[], byte[]>)c).timed((Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:238)").map((Function1 & Serializable)pullDurationAndRecords -> {
                                Tuple2 tuple2 = pullDurationAndRecords;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Duration pollDuration = (Duration)tuple2._1();
                                ConsumerRecords polledRecords = (ConsumerRecords)tuple2._2();
                                Tuple2 $4$ = tuple2;
                                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$4$, (Object)pollDuration, (Object)polledRecords);
                                Tuple2 $4$2 = (Tuple2)tuple3._1();
                                Duration pollDuration2 = (Duration)tuple3._2();
                                ConsumerRecords polledRecords2 = (ConsumerRecords)tuple3._3();
                                return Tuple2$.MODULE$.apply(pullDurationAndRecords, (Object)$4$2);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:239)").flatMap((Function1 & Serializable)x$12 -> {
                                Tuple2 tuple2 = x$12;
                                if (tuple2 != null) {
                                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                                    Tuple2 pullDurationAndRecords = (Tuple2)tuple2._1();
                                    if (tuple22 != null) {
                                        Duration pollDuration = (Duration)tuple22._1();
                                        ConsumerRecords polledRecords = (ConsumerRecords)tuple22._2();
                                        return this.consumerMetrics.observePoll(toResumeCount, toPauseCount, pollDuration, polledRecords.count()).$times$greater(() -> this.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(polledRecords, state$2), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:251)").flatMap((Function1 & Serializable)x$1 -> {
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return this.rebalanceCoordinator.getAndResetLastEvent().flatMap((Function1 & Serializable)x$12 -> {
                                                RebalanceCoordinator.RebalanceEvent rebalanceEvent = x$12;
                                                if (rebalanceEvent != null) {
                                                    RebalanceCoordinator.RebalanceEvent rebalanceEvent2 = RebalanceCoordinator$RebalanceEvent$.MODULE$.unapply(rebalanceEvent);
                                                    Chunk<RebalanceCoordinator.RebalanceCallback> chunk = rebalanceEvent2._1();
                                                    Chunk<RebalanceCoordinator.RebalanceCallback> rebalanceCallbacks = chunk;
                                                    if (rebalanceCallbacks.isEmpty()) {
                                                        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                                                        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:263)", (Function0 & Serializable)() -> {
                                                            Unsafe$ unsafe$ = Unsafe$.MODULE$;
                                                            return Runloop$PollResult$.MODULE$.apply((ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), state$2.pendingRequests(), state$2.assignedStreams());
                                                        });
                                                    }
                                                    Chunk<RebalanceCoordinator.RebalanceCallback> rebalanceCallbacks2 = chunk;
                                                    RebalanceCoordinator.RebalanceCallback rebalanceCallback = (RebalanceCoordinator.RebalanceCallback)rebalanceCallbacks2.reduce((Function2 & Serializable)(_$5, _$6) -> _$5.append((RebalanceCoordinator.RebalanceCallback)_$6));
                                                    if (rebalanceCallback == null) {
                                                        throw new MatchError((Object)rebalanceCallback);
                                                    }
                                                    RebalanceCoordinator.RebalanceCallback rebalanceCallback2 = RebalanceCoordinator$RebalanceCallback$.MODULE$.unapply(rebalanceCallback);
                                                    scala.collection.immutable.Set<TopicPartition> set = rebalanceCallback2._1();
                                                    scala.collection.immutable.Set<TopicPartition> set2 = rebalanceCallback2._2();
                                                    scala.collection.immutable.Set<TopicPartition> set3 = rebalanceCallback2._3();
                                                    Chunk<PartitionStreamControl> chunk2 = rebalanceCallback2._4();
                                                    scala.collection.immutable.Set<TopicPartition> assignedTps = set;
                                                    scala.collection.immutable.Set<TopicPartition> revokedTps = set2;
                                                    scala.collection.immutable.Set<TopicPartition> lostTps = set3;
                                                    Chunk<PartitionStreamControl> endedStreams = chunk2;
                                                    Tuple4 tuple4 = Tuple4$.MODULE$.apply(assignedTps, revokedTps, lostTps, endedStreams);
                                                    scala.collection.immutable.Set assignedTps2 = (scala.collection.immutable.Set)tuple4._1();
                                                    scala.collection.immutable.Set revokedTps2 = (scala.collection.immutable.Set)tuple4._2();
                                                    scala.collection.immutable.Set lostTps2 = (scala.collection.immutable.Set)tuple4._3();
                                                    Chunk endedStreams2 = (Chunk)tuple4._4();
                                                    scala.collection.immutable.Set currentAssigned = CollectionConverters$.MODULE$.SetHasAsScala(c.assignment()).asScala().toSet();
                                                    scala.collection.immutable.Set endedTps = endedStreams2.map((Function1 & Serializable)_$7 -> _$7.tp()).toSet();
                                                    return this.groupMetadataRef.set((Object)None$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:278)").flatMap((Function1 & Serializable)x$1 -> {
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        return this.doSeekForNewPartitions((Consumer<byte[], byte[]>)c, (scala.collection.immutable.Set<TopicPartition>)assignedTps2).map((Function1 & Serializable)ignoreRecordsForTps -> {
                                                            scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)assignedTps2.$plus$plus((IterableOnce)currentAssigned.intersect((Set)endedTps));
                                                            return Tuple2$.MODULE$.apply(ignoreRecordsForTps, (Object)startingTps);
                                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:286)").flatMap((Function1 & Serializable)x$12 -> {
                                                            Tuple2 tuple2 = x$12;
                                                            if (tuple2 != null) {
                                                                scala.collection.immutable.Set ignoreRecordsForTps = (scala.collection.immutable.Set)tuple2._1();
                                                                scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)tuple2._2();
                                                                return ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable((Iterable)startingTps), (Function1 & Serializable)tp -> this.newPartitionStream((TopicPartition)tp), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:289)").tap((Function1 & Serializable)newStreams -> ZIO$.MODULE$.logDebug(() -> Runloop.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(startingTps), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:290)").$times$greater(() -> this.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(newStreams), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:293)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:294)").map((Function1 & Serializable)startingStreams -> {
                                                                    Chunk updatedAssignedStreams = state$2.assignedStreams().filter((Function1 & Serializable)s -> !endedTps.contains((Object)s.tp())).$plus$plus(startingStreams);
                                                                    Chunk updatedPendingRequests = state$2.pendingRequests().filter((Function1 & Serializable)pendingRequest -> {
                                                                        TopicPartition tp = pendingRequest.tp();
                                                                        return !lostTps2.contains((Object)tp) && !revokedTps2.contains((Object)tp) && !endedStreams2.exists((Function1 & Serializable)_$9 -> {
                                                                            TopicPartition topicPartition = _$9.tp();
                                                                            TopicPartition topicPartition2 = tp;
                                                                            return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
                                                                        });
                                                                    });
                                                                    return Tuple3$.MODULE$.apply(startingStreams, (Object)updatedAssignedStreams, (Object)updatedPendingRequests);
                                                                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:308)").flatMap((Function1 & Serializable)x$1 -> {
                                                                    Tuple3 tuple3 = x$1;
                                                                    if (tuple3 != null) {
                                                                        Chunk startingStreams = (Chunk)tuple3._1();
                                                                        Chunk updatedAssignedStreams = (Chunk)tuple3._2();
                                                                        Chunk updatedPendingRequests = (Chunk)tuple3._3();
                                                                        return this.committer.keepCommitsForPartitions((scala.collection.immutable.Set<TopicPartition>)updatedAssignedStreams.map((Function1 & Serializable)_$10 -> _$10.tp()).toSet()).flatMap((Function1 & Serializable)x$12 -> {
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            return this.consumerMetrics.observeRebalance(currentAssigned.size(), assignedTps2.size(), revokedTps2.size(), lostTps2.size()).flatMap((Function1 & Serializable)x$1 -> {
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(revokedTps2, assignedTps2, lostTps2, endedStreams2))).flatMap((Function1 & Serializable)x$12 -> {
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    return ZIO$.MODULE$.logWarning(() -> Runloop.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(currentAssigned, updatedAssignedStreams), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:334)").when(() -> Runloop.handlePoll$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(currentAssigned, updatedAssignedStreams), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:339)").map((Function1 & Serializable)x$1 -> {
                                                                                        Option option = x$1;
                                                                                        return Runloop$PollResult$.MODULE$.apply((ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)ignoreRecordsForTps, (Chunk<RunloopCommand.Request>)updatedPendingRequests, (Chunk<PartitionStreamControl>)updatedAssignedStreams);
                                                                                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                                                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                                    }
                                                                    throw new MatchError((Object)tuple3);
                                                                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                            }
                                                            throw new MatchError((Object)tuple2);
                                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
                                                }
                                                throw new MatchError((Object)rebalanceEvent);
                                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:346)").map((Function1 & Serializable)pollresult -> pollresult, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:347)");
                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:347)");
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:347)");
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:347)")).flatMap((Function1 & Serializable)pollResult -> this.offerRecordsToStreams(pollResult.assignedStreams(), pollResult.pendingRequests(), pollResult.ignoreRecordsForTps(), pollResult.records()).flatMap((Function1 & Serializable)fulfillResult -> this.committer.cleanupPendingCommits().flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.checkStreamPullInterval(pollResult.assignedStreams()).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return state$2.copy(fulfillResult.pendingRequests(), pollResult.assignedStreams(), state$2.copy$default$3());
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)");
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:360)");
    }

    private final String logShutdown$1$$anonfun$1(PartitionStreamControl stream$1) {
        return new StringBuilder(212).append("Stream for ").append(stream$1.tp()).append(" has not pulled chunks for more than ").append(this.maxStreamPullInterval).append(", shutting down. ").append("Use ConsumerSettings.withMaxPollInterval or .withMaxStreamPullInterval to set a longer interval when ").append("processing a batch of records needs more time.").toString();
    }

    private final ZIO logShutdown$1(PartitionStreamControl stream) {
        return ZIO$.MODULE$.logError(() -> this.logShutdown$1$$anonfun$1(stream), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval.logShutdown(Runloop.scala:373)");
    }

    private static final Iterable checkStreamPullInterval$$anonfun$1$$anonfun$1(Chunk streams$4) {
        return streams$4;
    }

    private static final boolean checkStreamPullInterval$$anonfun$1$$anonfun$2() {
        return false;
    }

    private static final boolean checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(boolean _$14$1) {
        return _$14$1;
    }

    private final ZIO checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$2(PartitionStreamControl stream$3) {
        return this.logShutdown$1(stream$3);
    }

    private final /* synthetic */ ZIO checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$1(PartitionStreamControl stream$2, boolean _$14) {
        return ZIO$.MODULE$.when(() -> Runloop.checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(_$14), () -> this.checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$2(stream$2), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:380)");
    }

    private static final /* synthetic */ ZIO checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$2(PartitionStreamControl stream$4, boolean exceeded) {
        if (exceeded) {
            return stream$4.halt();
        }
        return ZIO$.MODULE$.unit();
    }

    private static final /* synthetic */ boolean checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$3(boolean acc$1, boolean _$15) {
        return acc$1 || _$15;
    }

    private final /* synthetic */ ZIO checkStreamPullInterval$$anonfun$1$$anonfun$3(long now$1, boolean x$1, PartitionStreamControl x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)x$1), (Object)x$2);
        if (tuple2 != null) {
            boolean acc = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
            PartitionStreamControl stream = (PartitionStreamControl)tuple2._2();
            return stream.maxStreamPullIntervalExceeded(now$1).tap((Function1 & Serializable)_$14 -> this.checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$1(stream, BoxesRunTime.unboxToBoolean((Object)_$14)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:380)").tap((Function1 & Serializable)exceeded -> Runloop.checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$2(stream, BoxesRunTime.unboxToBoolean((Object)exceeded)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:381)").map((Function1 & Serializable)_$15 -> Runloop.checkStreamPullInterval$$anonfun$1$$anonfun$3$$anonfun$3(acc, BoxesRunTime.unboxToBoolean((Object)_$15)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:382)");
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean checkStreamPullInterval$$anonfun$1$$anonfun$4$$anonfun$1(boolean anyExceeded$1) {
        return anyExceeded$1;
    }

    private final /* synthetic */ ZIO checkStreamPullInterval$$anonfun$1$$anonfun$4(boolean anyExceeded) {
        return this.shutdown().when(() -> Runloop.checkStreamPullInterval$$anonfun$1$$anonfun$4$$anonfun$1(anyExceeded), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:384)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Option option = x$1;
        }, (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:385)");
    }

    private final /* synthetic */ ZIO checkStreamPullInterval$$anonfun$1(Chunk streams$3, long now) {
        return ZIO$.MODULE$.foldLeft(() -> Runloop.checkStreamPullInterval$$anonfun$1$$anonfun$1(streams$3), Runloop::checkStreamPullInterval$$anonfun$1$$anonfun$2, (Function2 & Serializable)(x$1, x$2) -> this.checkStreamPullInterval$$anonfun$1$$anonfun$3(now, BoxesRunTime.unboxToBoolean((Object)x$1), (PartitionStreamControl)x$2), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:383)").flatMap((Function1 & Serializable)anyExceeded -> this.checkStreamPullInterval$$anonfun$1$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)anyExceeded)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPullInterval(Runloop.scala:385)");
    }

    private final ZIO doChangeSubscription$1(State state$21, SubscriptionState newSubscriptionState) {
        return this.applyNewSubscriptionState(newSubscriptionState).flatMap((Function1 & Serializable)newAssignedStreams -> {
            Chunk chunk = state$21.assignedStreams().$plus$plus(newAssignedStreams);
            Chunk<RunloopCommand.Request> chunk2 = state$21.copy$default$1();
            State newState = state$21.copy(chunk2, (Chunk<PartitionStreamControl>)chunk, newSubscriptionState);
            if (newSubscriptionState.isSubscribed()) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.handleCommand.doChangeSubscription(Runloop.scala:395)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return newState;
                });
            }
            return this.endRevokedPartitions(newState.pendingRequests(), newState.assignedStreams(), (Function1<TopicPartition, Object>)(Function1 & Serializable)_$16 -> true).map((Function1 & Serializable)revokeResult -> newState.copy(revokeResult.pendingRequests(), revokeResult.assignedStreams(), newState.copy$default$3()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand.doChangeSubscription(Runloop.scala:407)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand.doChangeSubscription(Runloop.scala:408)");
    }

    private final ZIO handleCommand$$anonfun$2(SubscriptionState.Subscribed newSubState$1, State state$24) {
        return this.doChangeSubscription$1(state$24, newSubState$1);
    }

    private static final State handleCommand$$anonfun$3(State state$25) {
        return state$25;
    }

    private final ZIO handleCommand$$anonfun$4(SubscriptionState.Subscribed newSubState$2, State state$26) {
        return this.doChangeSubscription$1(state$26, newSubState$2);
    }

    private static final String handleCommand$$anonfun$6() {
        return "Unsubscribing kafka consumer";
    }

    private final ZIO handleCommand$$anonfun$7(State state$38) {
        return this.doChangeSubscription$1(state$38, SubscriptionState$NotSubscribed$.MODULE$);
    }

    private static final String handleCommand$$anonfun$8() {
        return "Stop all streams initiated";
    }

    private static final Iterable handleCommand$$anonfun$9$$anonfun$1(State state$29) {
        return state$29.assignedStreams();
    }

    private static final String handleCommand$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1() {
        return "Stop all streams done";
    }

    private static final /* synthetic */ ZIO handleCommand$$anonfun$9$$anonfun$3$$anonfun$1(State state$31, boolean x$12) {
        boolean bl = x$12;
        return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:462)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return state$31.copy((Chunk<RunloopCommand.Request>)Chunk$.MODULE$.empty(), state$31.copy$default$2(), state$31.copy$default$3());
        }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:463)");
    }

    private static final Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$2() {
        return Chunk$.MODULE$.empty();
    }

    private static final Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$4() {
        return Chunk$.MODULE$.empty();
    }

    private static final Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$6() {
        return Chunk$.MODULE$.empty();
    }

    private static final /* synthetic */ Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$8$$anonfun$1$$anonfun$2$$anonfun$2(Chunk partitionStreams$1, boolean x$1) {
        boolean bl = x$1;
        return partitionStreams$1;
    }

    private final Dequeue run$$anonfun$1() {
        return this.commandQueue;
    }

    private static final int run$$anonfun$2() {
        return ZStream$.MODULE$.fromQueue$default$2();
    }

    private static final String run$$anonfun$4$$anonfun$1(Chunk commands$1) {
        return new StringBuilder(22).append("Processing ").append(commands$1.size()).append(" commands: ").append(commands$1.mkString(",")).toString();
    }

    private static final Iterable run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$1(Chunk streamCommands$1) {
        return streamCommands$1;
    }

    private static final State run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$2(State state$35) {
        return state$35;
    }

    private final /* synthetic */ ZIO run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$1(State stateAfterCommands$1, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            return this.handlePoll(stateAfterCommands$1);
        }
        if (!bl) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:526)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return stateAfterCommands$1;
            });
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final ZIO run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$1(State updatedStateAfterPoll$1) {
        return this.shouldPoll(updatedStateAfterPoll$1);
    }

    private final ZIO run$$anonfun$4$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$2() {
        return this.commandQueue.offer((Object)RunloopCommand$Poll$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:529)");
    }

    private static final String run$$anonfun$5$$anonfun$1() {
        return "Error in Runloop";
    }

    private static final Cause run$$anonfun$5$$anonfun$2(Cause cause$1) {
        return cause$1;
    }

    private final /* synthetic */ ZIO $anonfun$10$$anonfun$1$$anonfun$1$$anonfun$1(State currentState$3, int commandQueueSize$2, int commitQueueSize$1, int pendingCommitCount) {
        return this.consumerMetrics.observeRunloopMetrics(currentState$3, commandQueueSize$2, commitQueueSize$1, pendingCommitCount).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:551)");
    }

    private final /* synthetic */ ZIO $anonfun$10$$anonfun$1$$anonfun$1(State currentState$2, int commandQueueSize$1, int commitQueueSize) {
        return this.committer.pendingCommitCount().flatMap((Function1 & Serializable)pendingCommitCount -> this.$anonfun$10$$anonfun$1$$anonfun$1$$anonfun$1(currentState$2, commandQueueSize$1, commitQueueSize, BoxesRunTime.unboxToInt((Object)pendingCommitCount)), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:551)");
    }

    private final /* synthetic */ ZIO $anonfun$10$$anonfun$1(State currentState$1, int commandQueueSize) {
        return this.committer.queueSize().flatMap((Function1 & Serializable)commitQueueSize -> this.$anonfun$10$$anonfun$1$$anonfun$1(currentState$1, commandQueueSize, BoxesRunTime.unboxToInt((Object)commitQueueSize)), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:551)");
    }

    private static final Schedule observeRunloopMetrics$$anonfun$1(Schedule runloopMetricsSchedule$1) {
        return runloopMetricsSchedule$1;
    }

    public static final class FulfillResult
    implements Product,
    Serializable {
        private final Chunk pendingRequests;

        public static FulfillResult apply(Chunk<RunloopCommand.Request> chunk) {
            return Runloop$FulfillResult$.MODULE$.apply(chunk);
        }

        public static FulfillResult fromProduct(Product product) {
            return Runloop$FulfillResult$.MODULE$.fromProduct(product);
        }

        public static FulfillResult unapply(FulfillResult fulfillResult) {
            return Runloop$FulfillResult$.MODULE$.unapply(fulfillResult);
        }

        public FulfillResult(Chunk<RunloopCommand.Request> pendingRequests) {
            this.pendingRequests = pendingRequests;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FulfillResult)) return false;
            FulfillResult fulfillResult = (FulfillResult)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = fulfillResult.pendingRequests();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FulfillResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FulfillResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public FulfillResult copy(Chunk<RunloopCommand.Request> pendingRequests) {
            return new FulfillResult(pendingRequests);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }
    }

    public static final class PollResult
    implements Product,
    Serializable {
        private final ConsumerRecords records;
        private final scala.collection.immutable.Set ignoreRecordsForTps;
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;

        public static PollResult apply(ConsumerRecords<byte[], byte[]> consumerRecords, scala.collection.immutable.Set<TopicPartition> set, Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2) {
            return Runloop$PollResult$.MODULE$.apply(consumerRecords, set, chunk, chunk2);
        }

        public static PollResult fromProduct(Product product) {
            return Runloop$PollResult$.MODULE$.fromProduct(product);
        }

        public static PollResult unapply(PollResult pollResult) {
            return Runloop$PollResult$.MODULE$.unapply(pollResult);
        }

        public PollResult(ConsumerRecords<byte[], byte[]> records, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            this.records = records;
            this.ignoreRecordsForTps = ignoreRecordsForTps;
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PollResult)) return false;
            PollResult pollResult = (PollResult)object;
            ConsumerRecords<byte[], byte[]> consumerRecords = this.records();
            ConsumerRecords<byte[], byte[]> consumerRecords2 = pollResult.records();
            if (consumerRecords == null) {
                if (consumerRecords2 != null) {
                    return false;
                }
            } else if (!consumerRecords.equals(consumerRecords2)) return false;
            scala.collection.immutable.Set<TopicPartition> set = this.ignoreRecordsForTps();
            scala.collection.immutable.Set<TopicPartition> set2 = pollResult.ignoreRecordsForTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = pollResult.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = pollResult.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 == null) return true;
                return false;
            } else {
                if (!chunk3.equals(chunk4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PollResult;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PollResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "records";
                }
                case 1: {
                    return "ignoreRecordsForTps";
                }
                case 2: {
                    return "pendingRequests";
                }
                case 3: {
                    return "assignedStreams";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ConsumerRecords<byte[], byte[]> records() {
            return this.records;
        }

        public scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps() {
            return this.ignoreRecordsForTps;
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public PollResult copy(ConsumerRecords<byte[], byte[]> records, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            return new PollResult(records, ignoreRecordsForTps, pendingRequests, assignedStreams);
        }

        public ConsumerRecords<byte[], byte[]> copy$default$1() {
            return this.records();
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$2() {
            return this.ignoreRecordsForTps();
        }

        public Chunk<RunloopCommand.Request> copy$default$3() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$4() {
            return this.assignedStreams();
        }

        public ConsumerRecords<byte[], byte[]> _1() {
            return this.records();
        }

        public scala.collection.immutable.Set<TopicPartition> _2() {
            return this.ignoreRecordsForTps();
        }

        public Chunk<RunloopCommand.Request> _3() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _4() {
            return this.assignedStreams();
        }
    }

    public static final class RevokeResult
    implements Product,
    Serializable {
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;

        public static RevokeResult apply(Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2) {
            return Runloop$RevokeResult$.MODULE$.apply(chunk, chunk2);
        }

        public static RevokeResult fromProduct(Product product) {
            return Runloop$RevokeResult$.MODULE$.fromProduct(product);
        }

        public static RevokeResult unapply(RevokeResult revokeResult) {
            return Runloop$RevokeResult$.MODULE$.unapply(revokeResult);
        }

        public RevokeResult(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokeResult)) return false;
            RevokeResult revokeResult = (RevokeResult)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = revokeResult.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = revokeResult.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 == null) return true;
                return false;
            } else {
                if (!chunk3.equals(chunk4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokeResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokeResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            if (1 == n2) {
                return "assignedStreams";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public RevokeResult copy(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            return new RevokeResult(pendingRequests, assignedStreams);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$2() {
            return this.assignedStreams();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _2() {
            return this.assignedStreams();
        }
    }

    public static final class State
    implements Product,
    Serializable {
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;
        private final SubscriptionState subscriptionState;

        public static State apply(Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2, SubscriptionState subscriptionState) {
            return Runloop$State$.MODULE$.apply(chunk, chunk2, subscriptionState);
        }

        public static State fromProduct(Product product) {
            return Runloop$State$.MODULE$.fromProduct(product);
        }

        public static State initial() {
            return Runloop$State$.MODULE$.initial();
        }

        public static State unapply(State state) {
            return Runloop$State$.MODULE$.unapply(state);
        }

        public State(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, SubscriptionState subscriptionState) {
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
            this.subscriptionState = subscriptionState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = state.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = state.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 != null) {
                    return false;
                }
            } else if (!chunk3.equals(chunk4)) return false;
            SubscriptionState subscriptionState = this.subscriptionState();
            SubscriptionState subscriptionState2 = state.subscriptionState();
            if (subscriptionState == null) {
                if (subscriptionState2 == null) return true;
                return false;
            } else {
                if (!subscriptionState.equals(subscriptionState2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pendingRequests";
                }
                case 1: {
                    return "assignedStreams";
                }
                case 2: {
                    return "subscriptionState";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public SubscriptionState subscriptionState() {
            return this.subscriptionState;
        }

        public State addRequest(RunloopCommand.Request r) {
            return this.copy((Chunk<RunloopCommand.Request>)((Chunk)this.pendingRequests().$colon$plus((Object)r)), this.copy$default$2(), this.copy$default$3());
        }

        public State copy(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, SubscriptionState subscriptionState) {
            return new State(pendingRequests, assignedStreams, subscriptionState);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$2() {
            return this.assignedStreams();
        }

        public SubscriptionState copy$default$3() {
            return this.subscriptionState();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _2() {
            return this.assignedStreams();
        }

        public SubscriptionState _3() {
            return this.subscriptionState();
        }
    }

    public static final class StreamOps<R, E, A> {
        private final ZStream stream;

        public static <R, E, A> boolean equals$extension(ZStream zStream, Object object) {
            return Runloop$StreamOps$.MODULE$.equals$extension(zStream, object);
        }

        public static <R, E, A> int hashCode$extension(ZStream zStream) {
            return Runloop$StreamOps$.MODULE$.hashCode$extension(zStream);
        }

        public static <R1 extends R, E1, S, R, E, A> ZIO<R1, E1, BoxedUnit> runFoldChunksDiscardZIO$extension(ZStream zStream, S s, Function2<S, Chunk<A>, ZIO<R1, E1, S>> function2) {
            return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(zStream, s, function2);
        }

        public StreamOps(ZStream<R, E, A> stream) {
            this.stream = stream;
        }

        public int hashCode() {
            return Runloop$StreamOps$.MODULE$.hashCode$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream());
        }

        public boolean equals(Object x$0) {
            return Runloop$StreamOps$.MODULE$.equals$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream(), x$0);
        }

        public ZStream<R, E, A> zio$kafka$consumer$internal$Runloop$StreamOps$$stream() {
            return this.stream;
        }

        public <R1 extends R, E1, S> ZIO<R1, E1, BoxedUnit> runFoldChunksDiscardZIO(S s, Function2<S, Chunk<A>, ZIO<R1, E1, S>> f) {
            return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream(), s, f);
        }
    }
}

