/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Dequeue;
import zio.Exit;
import zio.IsSubtypeOfOutput$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Runtime;
import zio.Schedule;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.producer.Producer;
import zio.kafka.producer.Producer$PublishOmittedException$;
import zio.kafka.producer.ProducerSettings;
import zio.kafka.serde.Serializer;
import zio.stream.ZStream$;

public final class ProducerLive
implements Producer {
    private final ProducerSettings settings;
    private final org.apache.kafka.clients.producer.Producer p;
    private final Runtime<Object> runtime;
    private final Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Function1<Chunk<Either<Throwable, RecordMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>>> sendQueue;
    private final Left<Producer$PublishOmittedException$, Nothing$> leftPublishOmitted;
    private final Throwable retryAfterAuthException;
    private final ZIO sendFromQueue;

    public ProducerLive(ProducerSettings settings, org.apache.kafka.clients.producer.Producer<byte[], byte[]> p, Runtime<Object> runtime, Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Function1<Chunk<Either<Throwable, RecordMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>>> sendQueue) {
        this.settings = settings;
        this.p = p;
        this.runtime = runtime;
        this.sendQueue = sendQueue;
        this.leftPublishOmitted = package$.MODULE$.Left().apply((Object)Producer$PublishOmittedException$.MODULE$);
        this.retryAfterAuthException = new NoStackTrace(){
            {
                NoStackTrace.$init$((NoStackTrace)this);
            }

            public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }
        };
        this.sendFromQueue = ZStream$.MODULE$.fromQueueWithShutdown(() -> ProducerLive.$init$$$anonfun$4(sendQueue), ProducerLive::$init$$$anonfun$5, (Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:655)").mapZIO((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Chunk serializedRecords = (Chunk)tuple2._1();
                Function1 continuation = (Function1)tuple2._2();
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:715)", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    int recordsLength = serializedRecords.length();
                    AtomicInteger sentRecordsCounter = new AtomicInteger(0);
                    Iterator recordsIterator = serializedRecords.iterator().zipWithIndex();
                    Either[] sentResults = new Either[recordsLength];
                    VolatileBooleanRef previousSendCallsSucceed = VolatileBooleanRef.create((boolean)true);
                    recordsIterator.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            ProducerRecord producerRecord = (ProducerRecord)tuple2._1();
                            int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            if (producerRecord != null) {
                                ProducerRecord record = producerRecord;
                                if (true) {
                                    int recordIndex = n;
                                    if (previousSendCallsSucceed$1.elem) {
                                        try {
                                            Future future = p.send(record, (metadata, err) -> {
                                                Right right;
                                                if (err == null) {
                                                    right = package$.MODULE$.Right().apply((Object)metadata);
                                                } else {
                                                    previousSendCallsSucceed$2.elem = false;
                                                    right = package$.MODULE$.Left().apply((Object)err);
                                                }
                                                Right sendResult = right;
                                                ProducerLive.insertSentResult$1(sentResults, sentRecordsCounter, recordsLength, runtime, continuation, recordIndex, (Either)sendResult);
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            Option option;
                                            Throwable throwable2 = throwable;
                                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                                Throwable throwable3;
                                                Throwable err2 = throwable3 = (Throwable)option.get();
                                                previousSendCallsSucceed$1.elem = false;
                                                ProducerLive.insertSentResult$1(sentResults, sentRecordsCounter, recordsLength, runtime, continuation, recordIndex, (Either)package$.MODULE$.Left().apply((Object)err2));
                                            }
                                            throw throwable;
                                        }
                                        return;
                                    }
                                    ProducerLive.insertSentResult$1(sentResults, sentRecordsCounter, recordsLength, runtime, continuation, recordIndex, (Either)package$.MODULE$.Left().apply((Object)Producer$PublishOmittedException$.MODULE$));
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    });
                });
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:716)").runDrain((Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:717)");
    }

    public org.apache.kafka.clients.producer.Producer<byte[], byte[]> p() {
        return this.p;
    }

    @Override
    public ZIO<Object, Throwable, RecordMetadata> produce(ProducerRecord<byte[], byte[]> record) {
        return this.produceAsync(record).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produce(Producer.scala:460)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(ProducerRecord<K, V> record, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produceAsync(record, keySerializer, valueSerializer).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produce(Producer.scala:467)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produce(new ProducerRecord(topic, key, value), keySerializer, valueSerializer);
    }

    @Override
    public ZIO<Object, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(ProducerRecord<byte[], byte[]> record) {
        return ZIO$.MODULE$.suspendSucceed(() -> this.produceAsync$$anonfun$4(record), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:509)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(ProducerRecord<K, V> record2, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.serialize(record2, keySerializer, valueSerializer).flatMap((Function1 & Serializable)record -> this.produceAsync((ProducerRecord<byte[], byte[]>)record), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:516)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produceAsync(new ProducerRecord(topic, key, value), keySerializer, valueSerializer);
    }

    @Override
    public ZIO<Object, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<byte[], byte[]>> records) {
        return this.produceChunkAsync(records).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produceChunk(Producer.scala:528)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<K, V>> records, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produceChunkAsync(records, keySerializer, valueSerializer).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produceChunk(Producer.scala:535)");
    }

    @Override
    public ZIO<Object, Throwable, ZIO<Object, Throwable, Chunk<RecordMetadata>>> produceChunkAsync(Chunk<ProducerRecord<byte[], byte[]>> records) {
        return this.produceChunkAsyncWithFailures(records).map((Function1 & Serializable)_$17 -> _$17.flatMap((Function1 & Serializable)chunkResults -> {
            Tuple2 tuple2 = chunkResults.partitionMap((Function1 & Serializable)x -> (Either)Predef$.MODULE$.identity(x));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Chunk errors = (Chunk)tuple2._1();
            Chunk success = (Chunk)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)errors, (Object)success);
            Chunk errors2 = (Chunk)tuple22._1();
            Chunk success2 = (Chunk)tuple22._2();
            Option option = errors2.headOption();
            if (option instanceof Some) {
                Throwable error = (Throwable)((Some)option).value();
                return ZIO$.MODULE$.fail(() -> ProducerLive.produceChunkAsync$$anonfun$3$$anonfun$1$$anonfun$1(error), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:544)");
            }
            if (None$.MODULE$.equals(option)) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:545)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return success2;
                });
            }
            throw new MatchError((Object)option);
        }, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:547)"), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:547)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, Chunk<RecordMetadata>>> produceChunkAsync(Chunk<ProducerRecord<K, V>> records2, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return ZIO$.MODULE$.foreach(records2, (Function1 & Serializable)_$18 -> this.serialize((ProducerRecord)_$18, keySerializer, valueSerializer), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:555)").flatMap((Function1 & Serializable)records -> this.produceChunkAsync((Chunk<ProducerRecord<byte[], byte[]>>)records), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:556)");
    }

    @Override
    public ZIO<Object, Nothing$, ZIO<Object, Nothing$, Chunk<Either<Throwable, RecordMetadata>>>> produceChunkAsyncWithFailures(Chunk<ProducerRecord<byte[], byte[]>> records) {
        if (records.isEmpty()) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:562)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:562)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return Chunk$.MODULE$.empty();
                });
            });
        }
        LazyRef lazyRef = new LazyRef();
        int totalRecordCount = records.size();
        return ZIO$.MODULE$.suspendSucceed(() -> this.produceChunkAsyncWithFailures$$anonfun$3(totalRecordCount, records, lazyRef), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:639)");
    }

    @Override
    public ZIO<Object, Throwable, Chunk<PartitionInfo>> partitionsFor(String topic) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$6 -> Chunk$.MODULE$.fromJavaIterable((java.lang.Iterable)this.p().partitionsFor(topic)), (Object)"zio.kafka.producer.ProducerLive.partitionsFor(Producer.scala:643)");
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> flush() {
        return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$7 -> this.p().flush(), (Object)"zio.kafka.producer.ProducerLive.flush(Producer.scala:645)");
    }

    @Override
    public ZIO<Object, Throwable, Map<MetricName, Metric>> metrics() {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$8 -> CollectionConverters$.MODULE$.MapHasAsScala(this.p().metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.metrics(Producer.scala:647)");
    }

    public ZIO<Object, Nothing$, Object> sendFromQueue() {
        return this.sendFromQueue;
    }

    private <R, K, V> ZIO<R, Throwable, ProducerRecord<byte[], byte[]>> serialize(ProducerRecord<K, V> r, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return keySerializer.serialize(r.topic(), r.headers(), r.key()).flatMap((Function1 & Serializable)key -> valueSerializer.serialize(r.topic(), r.headers(), r.value()).map((Function1 & Serializable)value -> new ProducerRecord(r.topic(), r.partition(), r.timestamp(), key, value, (java.lang.Iterable)r.headers()), (Object)"zio.kafka.producer.ProducerLive.serialize(Producer.scala:727)"), (Object)"zio.kafka.producer.ProducerLive.serialize(Producer.scala:727)");
    }

    private static final Dequeue $init$$$anonfun$4(Queue sendQueue$1) {
        return sendQueue$1;
    }

    private static final int $init$$$anonfun$5() {
        return ZStream$.MODULE$.fromQueueWithShutdown$default$2();
    }

    private static final void insertSentResult$1(Either[] sentResults$1, AtomicInteger sentRecordsCounter$1, int recordsLength$1, Runtime runtime$3, Function1 continuation$2, int resultIndex, Either sentResult) {
        sentResults$1[resultIndex] = sentResult;
        if (sentRecordsCounter$1.incrementAndGet() == recordsLength$1) {
            Chunk sentResultsChunk = Chunk$.MODULE$.fromArray((Object)sentResults$1);
            Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> {
                Exit exit = runtime$3.unsafe().run((ZIO)continuation$2.apply((Object)sentResultsChunk), (Object)"zio.kafka.producer.ProducerLive.sendFromQueue.insertSentResult(Producer.scala:675)", u);
            });
            return;
        }
    }

    private final ZIO loop$1(ProducerRecord record$8, Promise done, Schedule.Driver driver) {
        Function1 & Serializable continuation = (Function1 & Serializable)results -> {
            Either either = (Either)results.head();
            if (either instanceof Right) {
                RecordMetadata recordMetaData = (RecordMetadata)((Right)either).value();
                return done.succeed((Object)recordMetaData, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:489)").unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:489)");
            }
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (throwable instanceof AuthorizationException || throwable instanceof AuthenticationException) {
                    ApiException error = (ApiException)throwable;
                    return ((ZIO)driver.next().apply((Object)this.retryAfterAuthException)).foldZIO((Function1 & Serializable)_$15 -> done.fail((Object)error, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:494)").unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:494)"), (Function1 & Serializable)_$16 -> this.loop$1(record$8, done, driver).unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:495)"), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:496)");
                }
                Throwable error = throwable;
                return done.fail((Object)error, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:498)").unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:498)");
            }
            throw new MatchError((Object)either);
        };
        Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc((Object)Chunk$.MODULE$.single((Object)record$8));
        return this.sendQueue.offer((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, (Object)continuation), (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop(Producer.scala:502)");
    }

    private final ZIO produceAsync$$anonfun$4(ProducerRecord record$7) {
        return Promise$.MODULE$.make((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:506)").flatMap((Function1 & Serializable)done -> this.settings.authErrorRetrySchedule().driver((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:507)").flatMap((Function1 & Serializable)d -> this.loop$1(record$7, (Promise)done, (Schedule.Driver)d), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:507)").map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            return done.await((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:508)");
        }, (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:508)"), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:508)");
    }

    private static final Throwable produceChunkAsync$$anonfun$3$$anonfun$1$$anonfun$1(Throwable error$2) {
        return error$2;
    }

    private final Either finalResults$lzyINIT1$1$$anonfun$1() {
        return this.leftPublishOmitted;
    }

    private final Either[] finalResults$lzyINIT1$1(LazyRef finalResults$lzy1$1, int totalRecordCount$1) {
        Either[] eitherArray;
        LazyRef lazyRef = finalResults$lzy1$1;
        synchronized (lazyRef) {
            eitherArray = (Either[])(finalResults$lzy1$1.initialized() ? finalResults$lzy1$1.value() : finalResults$lzy1$1.initialize((Object)((Either[])Array$.MODULE$.fill(totalRecordCount$1, this::finalResults$lzyINIT1$1$$anonfun$1, ClassTag$.MODULE$.apply(Either.class)))));
        }
        return eitherArray;
    }

    private final Either[] finalResults$1(LazyRef finalResults$lzy1$2, int totalRecordCount$2) {
        return finalResults$lzy1$2.initialized() ? finalResults$lzy1$2.value() : this.finalResults$lzyINIT1$1(finalResults$lzy1$2, totalRecordCount$2);
    }

    private final /* synthetic */ void storeResults$1$$anonfun$1(LazyRef finalResults$lzy1$13, int totalRecordCount$13, int x$1, Either x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            Either result;
            int index = BoxesRunTime.unboxToInt((Object)tuple2._1());
            this.finalResults$1((LazyRef)finalResults$lzy1$13, (int)totalRecordCount$13)[index] = result = (Either)tuple2._2();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final void storeResults$1(LazyRef finalResults$lzy1$12, int totalRecordCount$12, Seq recordIndices, Chunk results) {
        recordIndices.lazyZip((Iterable)results).foreach((Function2 & Serializable)(v1, v2) -> {
            this.storeResults$1$$anonfun$1(finalResults$lzy1$12, totalRecordCount$12, BoxesRunTime.unboxToInt((Object)v1), (Either)v2);
            return BoxedUnit.UNIT;
        });
    }

    private final ZIO complete$1(LazyRef finalResults$lzy1$15, int totalRecordCount$15, Promise done) {
        return done.succeed((Object)Chunk$.MODULE$.fromArray((Object)this.finalResults$1(finalResults$lzy1$15, totalRecordCount$15)), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.complete(Producer.scala:573)").unit((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.complete(Producer.scala:573)");
    }

    private static final /* synthetic */ Iterable $anonfun$3(int x$1, ProducerRecord x$2, Either x$3) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2, (Object)x$3);
        if (tuple3 != null) {
            Either either = (Either)tuple3._3();
            if (either instanceof Right) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            ProducerRecord record = (ProducerRecord)tuple3._2();
            if (either instanceof Left) {
                return (Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)record), (List)Nil$.MODULE$));
            }
        }
        throw new MatchError((Object)tuple3);
    }

    private static final String retryFailedRecords$1$$anonfun$1(Seq retryRecords$1, Chunk records$7) {
        return new StringBuilder(84).append("Retrying publish ").append(retryRecords$1.size()).append(" (of ").append(records$7.size()).append(") records after AuthorizationException/AuthenticationException").toString();
    }

    private final ZIO retryFailedRecords$1$$anonfun$2(Seq retryIndices$1, Seq retryRecords$2, Promise done$7, Schedule.Driver driver$4, int totalRecordCount$4, LazyRef finalResults$lzy1$4) {
        return this.loop$2(totalRecordCount$4, finalResults$lzy1$4, retryIndices$1, Chunk$.MODULE$.from((IterableOnce)retryRecords$2), done$7, driver$4).unit((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.retryFailedRecords(Producer.scala:593)");
    }

    private final ZIO retryFailedRecords$1(Seq recordIndices$1, Chunk records$6, Promise done$6, Schedule.Driver driver$3, int totalRecordCount$3, LazyRef finalResults$lzy1$3, Chunk results) {
        Seq toRetry = (Seq)recordIndices$1.lazyZip((Iterable)records$6).lazyZip((Iterable)results).flatMap((Function3 & Serializable)(x$1, x$2, x$3) -> ProducerLive.$anonfun$3(BoxesRunTime.unboxToInt((Object)x$1), (ProducerRecord)x$2, (Either)x$3), BuildFrom$.MODULE$.buildFromIterableOps());
        Tuple2 tuple2 = toRetry.unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq retryIndices = (Seq)tuple2._1();
        Seq retryRecords = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)retryIndices, (Object)retryRecords);
        Seq retryIndices2 = (Seq)tuple22._1();
        Seq retryRecords2 = (Seq)tuple22._2();
        return ZIO$.MODULE$.logInfo(() -> ProducerLive.retryFailedRecords$1$$anonfun$1(retryRecords2, records$6), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.retryFailedRecords(Producer.scala:592)").$times$greater(() -> this.retryFailedRecords$1$$anonfun$2(retryIndices2, retryRecords2, done$6, driver$3, totalRecordCount$3, finalResults$lzy1$3), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.retryFailedRecords(Producer.scala:593)");
    }

    private final ZIO loop$2(int totalRecordCount$7, LazyRef finalResults$lzy1$7, Seq recordIndices, Chunk records, Promise done, Schedule.Driver driver) {
        Function1 & Serializable continuation = (Function1 & Serializable)results -> {
            if (results.forall((Function1 & Serializable)_$19 -> _$19.isRight())) {
                if (recordIndices.size() == totalRecordCount$7) {
                    return done.succeed(results, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:601)").unit((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:601)");
                }
                this.storeResults$1(finalResults$lzy1$7, totalRecordCount$7, recordIndices, (Chunk)results);
                return this.complete$1(finalResults$lzy1$7, totalRecordCount$7, done);
            }
            this.storeResults$1(finalResults$lzy1$7, totalRecordCount$7, recordIndices, (Chunk)results);
            boolean hasFatalError = results.exists((Function1 & Serializable)x$1 -> {
                Throwable throwable;
                Either either = x$1;
                return !(either instanceof Right) && (!(either instanceof Left) || !((throwable = (Throwable)((Left)either).value()) instanceof AuthorizationException) && !(throwable instanceof AuthenticationException) && !Producer$PublishOmittedException$.MODULE$.equals(throwable));
                {
                }
            });
            if (hasFatalError) {
                return this.complete$1(finalResults$lzy1$7, totalRecordCount$7, done);
            }
            return ((ZIO)driver.next().apply((Object)this.retryAfterAuthException)).foldZIO((Function1 & Serializable)_$20 -> this.complete$1(finalResults$lzy1$7, totalRecordCount$7, done), (Function1 & Serializable)_$21 -> this.retryFailedRecords$1(recordIndices, records, done, driver, totalRecordCount$7, finalResults$lzy1$7, (Chunk)results), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:627)");
        };
        Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc((Object)records);
        return this.sendQueue.offer((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, (Object)continuation), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop(Producer.scala:632)");
    }

    private final ZIO produceChunkAsyncWithFailures$$anonfun$3(int totalRecordCount$6, Chunk records$9, LazyRef finalResults$lzy1$6) {
        return Promise$.MODULE$.make((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:636)").flatMap((Function1 & Serializable)done -> this.settings.authErrorRetrySchedule().driver((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:637)").flatMap((Function1 & Serializable)d -> this.loop$2(totalRecordCount$6, finalResults$lzy1$6, (Seq)records$9.indices(), records$9, (Promise)done, (Schedule.Driver)d), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:637)").map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            return done.await((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:638)");
        }, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:638)"), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:638)");
    }
}

