/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Cause;
import zio.Exit;
import zio.IsSubtypeOfError$;
import zio.Ref;
import zio.Ref$;
import zio.Scope;
import zio.Semaphore;
import zio.StackTrace;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.kafka.consumer.OffsetBatch;
import zio.kafka.producer.ProducerLive;
import zio.kafka.producer.Transaction;
import zio.kafka.producer.TransactionImpl;
import zio.kafka.producer.TransactionalProducer$;
import zio.kafka.producer.TransactionalProducer$TransactionLeaked$;
import zio.kafka.producer.TransactionalProducer$UserInitiatedAbort$;
import zio.kafka.producer.TransactionalProducerSettings;

public interface TransactionalProducer {
    public static ZLayer<TransactionalProducerSettings, Throwable, TransactionalProducer> live() {
        return TransactionalProducer$.MODULE$.live();
    }

    public static ZIO<Scope, Throwable, TransactionalProducer> make(TransactionalProducerSettings transactionalProducerSettings) {
        return TransactionalProducer$.MODULE$.make(transactionalProducerSettings);
    }

    public ZIO<Scope, Throwable, Transaction> createTransaction();

    public static final class LiveTransactionalProducer
    implements TransactionalProducer {
        private final ProducerLive live;
        private final Semaphore semaphore;
        private final ZIO<Object, Throwable, BoxedUnit> abortTransaction;

        public LiveTransactionalProducer(ProducerLive live, Semaphore semaphore) {
            this.live = live;
            this.semaphore = semaphore;
            this.abortTransaction = ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$1 -> live.p().abortTransaction(), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.abortTransaction(TransactionalProducer.scala:30)");
        }

        private ZIO<Object, Throwable, BoxedUnit> commitTransactionWithOffsets(OffsetBatch offsetBatch) {
            ZIO sendOffsetsToTransaction = ZIO$.MODULE$.suspend(() -> this.$anonfun$1(offsetBatch), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets.sendOffsetsToTransaction(TransactionalProducer.scala:52)");
            return sendOffsetsToTransaction.when(() -> TransactionalProducer$.zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$commitTransactionWithOffsets$$anonfun$1(offsetBatch), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:54)").$times$greater(this::commitTransactionWithOffsets$$anonfun$2, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:54)");
        }

        private ZIO<Object, Nothing$, BoxedUnit> commitOrAbort(TransactionImpl transaction, Exit<Object, Object> exit) {
            Exit<Object, Object> exit2 = exit;
            if (exit2 instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit2);
                Object object = success._1();
                return transaction.offsetBatchRef().get((Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:60)").flatMap((Function1 & Serializable)offsetBatch -> this.commitTransactionWithOffsets((OffsetBatch)offsetBatch).retryN(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$commitOrAbort$$anonfun$1$$anonfun$1, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:61)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:61)"), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:61)");
            }
            if (exit2 instanceof Exit.Failure) {
                Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit2);
                Cause cause = failure._1();
                if (cause instanceof Cause.Fail) {
                    Cause.Fail fail = Cause.Fail$.MODULE$.unapply((Cause.Fail)cause);
                    Object object = fail._1();
                    StackTrace stackTrace = fail._2();
                    if (TransactionalProducer$UserInitiatedAbort$.MODULE$.equals(object)) {
                        return this.abortTransaction.retryN(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$commitOrAbort$$anonfun$2, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:62)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:62)");
                    }
                }
                return this.abortTransaction.retryN(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$commitOrAbort$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:63)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:63)");
            }
            throw new MatchError(exit2);
        }

        @Override
        public ZIO<Scope, Throwable, Transaction> createTransaction() {
            return this.semaphore.withPermitScoped((Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:67)").$times$greater(this::createTransaction$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:74)");
        }

        private final ZIO invalidGroupIdException$1() {
            return ZIO$.MODULE$.fail(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$invalidGroupIdException$1$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets.sendOffsetsToTransaction.invalidGroupIdException(TransactionalProducer.scala:40)");
        }

        private final ZIO $anonfun$1(OffsetBatch offsetBatch$1) {
            Option<ConsumerGroupMetadata> option = offsetBatch$1.consumerGroupMetadata();
            if (None$.MODULE$.equals(option)) {
                return this.invalidGroupIdException$1();
            }
            if (option instanceof Some) {
                ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)((Some)option).value();
                java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)offsetBatch$1.offsets().map(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$_$$anonfun$2)).asJava();
                return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$2 -> this.live.p().sendOffsetsToTransaction(offsets, consumerGroupMetadata), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets.sendOffsetsToTransaction(TransactionalProducer.scala:50)");
            }
            throw new MatchError(option);
        }

        private final ZIO commitTransactionWithOffsets$$anonfun$2() {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$3 -> this.live.p().commitTransaction(), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:54)");
        }

        private final ZIO createTransaction$$anonfun$1$$anonfun$1() {
            return Ref$.MODULE$.make(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$createTransaction$$anonfun$1$$anonfun$1$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:70)").flatMap((Function1 & Serializable)offsetBatchRef -> Ref$.MODULE$.make(TransactionalProducer$::zio$kafka$producer$TransactionalProducer$LiveTransactionalProducer$$_$createTransaction$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:71)").flatMap((Function1 & Serializable)closedRef -> ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$4 -> this.live.p().beginTransaction(), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:72)").map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return new TransactionImpl(this.live, (Ref<OffsetBatch>)offsetBatchRef, (Ref<Object>)closedRef);
            }, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:73)"), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:73)"), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:73)");
        }

        private final ZIO createTransaction$$anonfun$1$$anonfun$2$$anonfun$1(TransactionImpl transaction$1, Exit exit$1) {
            return this.commitOrAbort(transaction$1, (Exit<Object, Object>)exit$1);
        }

        private final ZIO createTransaction$$anonfun$1() {
            return ZIO$.MODULE$.acquireReleaseExit(this::createTransaction$$anonfun$1$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
                TransactionImpl transactionImpl;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null && (transactionImpl = (TransactionImpl)tuple2._1()) != null) {
                    TransactionImpl transaction = transactionImpl;
                    Exit exit = (Exit)tuple2._2();
                    return transaction.markAsClosed().$times$greater(() -> this.createTransaction$$anonfun$1$$anonfun$2$$anonfun$1(transaction, exit), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:74)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:74)");
        }
    }

    public static final class TransactionLeaked
    extends RuntimeException
    implements Product {
        private final OffsetBatch offsetBatch;

        public static TransactionLeaked apply(OffsetBatch offsetBatch) {
            return TransactionalProducer$TransactionLeaked$.MODULE$.apply(offsetBatch);
        }

        public static TransactionLeaked fromProduct(Product product) {
            return TransactionalProducer$TransactionLeaked$.MODULE$.fromProduct(product);
        }

        public static TransactionLeaked unapply(TransactionLeaked transactionLeaked) {
            return TransactionalProducer$TransactionLeaked$.MODULE$.unapply(transactionLeaked);
        }

        public TransactionLeaked(OffsetBatch offsetBatch) {
            this.offsetBatch = offsetBatch;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TransactionLeaked)) return false;
            TransactionLeaked transactionLeaked = (TransactionLeaked)object;
            OffsetBatch offsetBatch = this.offsetBatch();
            OffsetBatch offsetBatch2 = transactionLeaked.offsetBatch();
            if (offsetBatch != null) {
                if (!offsetBatch.equals(offsetBatch2)) return false;
                return true;
            }
            if (offsetBatch2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof TransactionLeaked;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TransactionLeaked";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offsetBatch";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OffsetBatch offsetBatch() {
            return this.offsetBatch;
        }

        public TransactionLeaked copy(OffsetBatch offsetBatch) {
            return new TransactionLeaked(offsetBatch);
        }

        public OffsetBatch copy$default$1() {
            return this.offsetBatch();
        }

        public OffsetBatch _1() {
            return this.offsetBatch();
        }
    }
}

