/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer;

import izumi.reflect.Tag;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Duration$;
import zio.DurationOps$;
import zio.DurationSyntax$;
import zio.Exit;
import zio.Hub;
import zio.IsSubtypeOfError$;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Ref;
import zio.Schedule;
import zio.Schedule$;
import zio.Scope;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.Zippable$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.Consumer$;
import zio.kafka.consumer.Consumer$AutoOffsetStrategy$;
import zio.kafka.consumer.Consumer$AutoOffsetStrategy$Earliest$;
import zio.kafka.consumer.Consumer$AutoOffsetStrategy$Latest$;
import zio.kafka.consumer.Consumer$AutoOffsetStrategy$None$;
import zio.kafka.consumer.Consumer$OffsetRetrieval$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.InvalidSubscriptionUnion;
import zio.kafka.consumer.InvalidSubscriptionUnion$;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.Subscription$;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.Runloop;
import zio.kafka.serde.Deserializer;
import zio.kafka.serde.Serde$;
import zio.package$;
import zio.stream.Take;
import zio.stream.ZChannel;
import zio.stream.ZSink;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface Consumer {
    public static ZLayer<ConsumerSettings, Throwable, Consumer> live() {
        return Consumer$.MODULE$.live();
    }

    public static ZIO<Scope, Throwable, Consumer> make(ConsumerSettings consumerSettings, Diagnostics diagnostics) {
        return Consumer$.MODULE$.make(consumerSettings, diagnostics);
    }

    public static ZChannel offsetBatches() {
        return Consumer$.MODULE$.offsetBatches();
    }

    public static Diagnostics make$default$2() {
        return Consumer$.MODULE$.make$default$2();
    }

    public static <R, R1, K, V> Schedule<Object, Object, Object> consumeWith$default$5() {
        return Consumer$.MODULE$.consumeWith$default$5();
    }

    public ZIO<Object, Throwable, scala.collection.immutable.Set<TopicPartition>> assignment();

    public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>> beginningOffsets(scala.collection.immutable.Set<TopicPartition> var1, Duration var2);

    public static Duration beginningOffsets$default$2$(Consumer $this) {
        return $this.beginningOffsets$default$2();
    }

    default public Duration beginningOffsets$default$2() {
        return Duration$.MODULE$.Infinity();
    }

    public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Option<OffsetAndMetadata>>> committed(scala.collection.immutable.Set<TopicPartition> var1, Duration var2);

    public static Duration committed$default$2$(Consumer $this) {
        return $this.committed$default$2();
    }

    default public Duration committed$default$2() {
        return Duration$.MODULE$.Infinity();
    }

    public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>> endOffsets(scala.collection.immutable.Set<TopicPartition> var1, Duration var2);

    public static Duration endOffsets$default$2$(Consumer $this) {
        return $this.endOffsets$default$2();
    }

    default public Duration endOffsets$default$2() {
        return Duration$.MODULE$.Infinity();
    }

    public ZIO<Object, Throwable, scala.collection.immutable.Map<String, List<PartitionInfo>>> listTopics(Duration var1);

    public static Duration listTopics$default$1$(Consumer $this) {
        return $this.listTopics$default$1();
    }

    default public Duration listTopics$default$1() {
        return Duration$.MODULE$.Infinity();
    }

    public <R, K, V> ZStream<Object, Throwable, Chunk<Tuple2<TopicPartition, ZStream<R, Throwable, CommittableRecord<K, V>>>>> partitionedAssignmentStream(Subscription var1, Deserializer<R, K> var2, Deserializer<R, V> var3);

    public <R, K, V> ZStream<Object, Throwable, Tuple2<TopicPartition, ZStream<R, Throwable, CommittableRecord<K, V>>>> partitionedStream(Subscription var1, Deserializer<R, K> var2, Deserializer<R, V> var3);

    public <R, K, V> ZStream<R, Throwable, CommittableRecord<K, V>> plainStream(Subscription var1, Deserializer<R, K> var2, Deserializer<R, V> var3, int var4);

    public static int plainStream$default$4$(Consumer $this) {
        return $this.plainStream$default$4();
    }

    default public int plainStream$default$4() {
        return 4;
    }

    public ZIO<Object, Nothing$, BoxedUnit> stopConsumption();

    public <R, R1, K, V> ZIO<R, Throwable, BoxedUnit> consumeWith(Subscription var1, Deserializer<R, K> var2, Deserializer<R, V> var3, Schedule<Object, Object, Object> var4, Function1<ConsumerRecord<K, V>, ZIO<R1, Nothing$, BoxedUnit>> var5, Tag<R> var6, Tag<R1> var7);

    public static Schedule consumeWith$default$4$(Consumer $this) {
        return $this.consumeWith$default$4();
    }

    default public <R, R1, K, V> Schedule<Object, Object, Object> consumeWith$default$4() {
        return Schedule$.MODULE$.exponential(DurationSyntax$.MODULE$.second$extension(package$.MODULE$.durationInt(1)), Schedule$.MODULE$.exponential$default$2(), (Object)"zio.kafka.consumer.Consumer.consumeWith$default$4(Consumer.scala:128)").$amp$amp(Schedule$.MODULE$.recurs(3, (Object)"zio.kafka.consumer.Consumer.consumeWith$default$4(Consumer.scala:128)"), Zippable$.MODULE$.Zippable2());
    }

    public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, OffsetAndTimestamp>> offsetsForTimes(scala.collection.immutable.Map<TopicPartition, Object> var1, Duration var2);

    public static Duration offsetsForTimes$default$2$(Consumer $this) {
        return $this.offsetsForTimes$default$2();
    }

    default public Duration offsetsForTimes$default$2() {
        return Duration$.MODULE$.Infinity();
    }

    public ZIO<Object, Throwable, List<PartitionInfo>> partitionsFor(String var1, Duration var2);

    public static Duration partitionsFor$default$2$(Consumer $this) {
        return $this.partitionsFor$default$2();
    }

    default public Duration partitionsFor$default$2() {
        return Duration$.MODULE$.Infinity();
    }

    public ZIO<Object, Throwable, Object> position(TopicPartition var1, Duration var2);

    public static Duration position$default$2$(Consumer $this) {
        return $this.position$default$2();
    }

    default public Duration position$default$2() {
        return Duration$.MODULE$.Infinity();
    }

    public ZIO<Object, Throwable, scala.collection.immutable.Set<String>> subscription();

    public ZIO<Object, Throwable, scala.collection.immutable.Map<MetricName, Metric>> metrics();

    public static interface AutoOffsetStrategy {
        public static int ordinal(AutoOffsetStrategy autoOffsetStrategy) {
            return Consumer$AutoOffsetStrategy$.MODULE$.ordinal(autoOffsetStrategy);
        }

        public static String toConfig$(AutoOffsetStrategy $this) {
            return $this.toConfig();
        }

        default public String toConfig() {
            AutoOffsetStrategy autoOffsetStrategy = this;
            if (Consumer$AutoOffsetStrategy$Earliest$.MODULE$.equals(autoOffsetStrategy)) {
                return "earliest";
            }
            if (Consumer$AutoOffsetStrategy$Latest$.MODULE$.equals(autoOffsetStrategy)) {
                return "latest";
            }
            if (Consumer$AutoOffsetStrategy$None$.MODULE$.equals(autoOffsetStrategy)) {
                return "none";
            }
            throw new MatchError((Object)autoOffsetStrategy);
        }
    }

    public static final class Live
    implements Consumer {
        private final ConsumerAccess consumer;
        private final Runloop runloop;
        private final Ref.Synchronized subscriptions;
        private final Hub partitionAssignments;

        public Live(ConsumerAccess consumer, Runloop runloop, Ref.Synchronized<scala.collection.immutable.Set<Subscription>> subscriptions, Hub<Exit> partitionAssignments) {
            this.consumer = consumer;
            this.runloop = runloop;
            this.subscriptions = subscriptions;
            this.partitionAssignments = partitionAssignments;
        }

        private ConsumerAccess consumer() {
            return this.consumer;
        }

        private Runloop runloop() {
            return this.runloop;
        }

        private Ref.Synchronized<scala.collection.immutable.Set<Subscription>> subscriptions() {
            return this.subscriptions;
        }

        private Hub<Exit> partitionAssignments() {
            return this.partitionAssignments;
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Set<TopicPartition>> assignment() {
            return this.consumer().withConsumer((Function1 & Serializable)_$1 -> CollectionConverters$.MODULE$.SetHasAsScala(_$1.assignment()).asScala().toSet());
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>> beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions, Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)_$2 -> CollectionConverters$.MODULE$.MapHasAsScala(_$2.beginningOffsets((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions).asJava(), DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout)))).asScala().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Long l = (Long)tuple2._2();
                    TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)l));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        @Override
        public Duration beginningOffsets$default$2() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Option<OffsetAndMetadata>>> committed(scala.collection.immutable.Set<TopicPartition> partitions, Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)_$3 -> CollectionConverters$.MODULE$.MapHasAsScala(_$3.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions).asJava(), DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout)))).asScala().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition k = (TopicPartition)tuple2._1();
                    OffsetAndMetadata v = (OffsetAndMetadata)tuple2._2();
                    TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)Option$.MODULE$.apply((Object)v));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        @Override
        public Duration committed$default$2() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>> endOffsets(scala.collection.immutable.Set<TopicPartition> partitions, Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)eo -> {
                java.util.Map offs = eo.endOffsets((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)partitions).asJava(), DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout)));
                return CollectionConverters$.MODULE$.MapHasAsScala(offs).asScala().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicPartition k = (TopicPartition)tuple2._1();
                        Long v = (Long)tuple2._2();
                        TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)k);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)v));
                    }
                    throw new MatchError((Object)tuple2);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            });
        }

        @Override
        public Duration endOffsets$default$2() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> stopConsumption() {
            return this.runloop().stopConsumption();
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Map<String, List<PartitionInfo>>> listTopics(Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)_$4 -> CollectionConverters$.MODULE$.MapHasAsScala(_$4.listTopics(DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout)))).asScala().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    java.util.List v = (java.util.List)tuple2._2();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)CollectionConverters$.MODULE$.ListHasAsScala(v).asScala().toList());
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        @Override
        public Duration listTopics$default$1() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, OffsetAndTimestamp>> offsetsForTimes(scala.collection.immutable.Map<TopicPartition, Object> timestamps, Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)_$5 -> (scala.collection.immutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(_$5.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)timestamps.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition k = (TopicPartition)tuple2._1();
                    long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)v));
                }
                throw new MatchError((Object)tuple2);
            })).asJava(), DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout)))).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)_$6 -> _$6._2() != null));
        }

        @Override
        public Duration offsetsForTimes$default$2() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public <R, K, V> ZStream<Object, Throwable, Chunk<Tuple2<TopicPartition, ZStream<R, Throwable, CommittableRecord<K, V>>>>> partitionedAssignmentStream(Subscription subscription, Deserializer<R, K> keyDeserializer, Deserializer<R, V> valueDeserializer) {
            boolean onlyByteArraySerdes = keyDeserializer == Serde$.MODULE$.byteArray() && valueDeserializer == Serde$.MODULE$.byteArray();
            boolean bl = ZStream$.MODULE$.unwrapScoped();
            return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.partitionedAssignmentStream$$anonfun$1(subscription, keyDeserializer, valueDeserializer, onlyByteArraySerdes), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:267)");
        }

        @Override
        public <R, K, V> ZStream<Object, Throwable, Tuple2<TopicPartition, ZStream<R, Throwable, CommittableRecord<K, V>>>> partitionedStream(Subscription subscription, Deserializer<R, K> keyDeserializer, Deserializer<R, V> valueDeserializer) {
            return this.partitionedAssignmentStream(subscription, keyDeserializer, valueDeserializer).flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.kafka.consumer.Consumer.Live.partitionedStream(Consumer.scala:275)");
        }

        @Override
        public ZIO<Object, Throwable, List<PartitionInfo>> partitionsFor(String topic, Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)c -> {
                java.util.List partitions = c.partitionsFor(topic, DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout)));
                if (partitions == null) {
                    return scala.package$.MODULE$.List().empty();
                }
                return CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().toList();
            });
        }

        @Override
        public Duration partitionsFor$default$2() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public ZIO<Object, Throwable, Object> position(TopicPartition partition, Duration timeout) {
            return this.consumer().withConsumer((Function1 & Serializable)_$13 -> _$13.position(partition, DurationOps$.MODULE$.asJava$extension(package$.MODULE$.duration2DurationOps(timeout))));
        }

        @Override
        public Duration position$default$2() {
            return Duration$.MODULE$.Infinity();
        }

        @Override
        public <R, K, V> ZStream<R, Throwable, CommittableRecord<K, V>> plainStream(Subscription subscription, Deserializer<R, K> keyDeserializer, Deserializer<R, V> valueDeserializer, int bufferSize) {
            return this.partitionedStream(subscription, keyDeserializer, valueDeserializer).flatMapPar(this::plainStream$$anonfun$1, () -> this.plainStream$$anonfun$2(bufferSize), (Function1 & Serializable)_$14 -> (ZStream)_$14._2(), (Object)"zio.kafka.consumer.Consumer.Live.plainStream(Consumer.scala:298)");
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Set<String>> subscription() {
            return this.consumer().withConsumer((Function1 & Serializable)_$15 -> CollectionConverters$.MODULE$.SetHasAsScala(_$15.subscription()).asScala().toSet());
        }

        @Override
        public <R, R1, K, V> ZIO<R, Throwable, BoxedUnit> consumeWith(Subscription subscription, Deserializer<R, K> keyDeserializer, Deserializer<R, V> valueDeserializer, Schedule<Object, Object, Object> commitRetryPolicy, Function1<ConsumerRecord<K, V>, ZIO<R1, Nothing$, BoxedUnit>> f, Tag<R> evidence$5, Tag<R1> evidence$6) {
            return ZIO$.MODULE$.environment((Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:312)").flatMap((Function1 & Serializable)r -> {
                ZStream zStream = this.partitionedStream(subscription, keyDeserializer, valueDeserializer);
                return zStream.flatMapPar(this::consumeWith$$anonfun$1$$anonfun$1, () -> this.consumeWith$$anonfun$1$$anonfun$2(zStream), (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        ZStream partitionStream = (ZStream)tuple2._2();
                        return partitionStream.mapChunksZIO((Function1 & Serializable)_$16 -> _$16.mapZIO((Function1 & Serializable)c -> ((ZIO)f.apply(c.record())).as(() -> this.consumeWith$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(c), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:315)"), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:315)"), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:315)");
                    }
                    throw new MatchError((Object)tuple2);
                }, (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:316)").provideEnvironment(() -> this.consumeWith$$anonfun$1$$anonfun$4(r), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:317)").aggregateAsync((Function0 & Serializable)() -> new ZSink(this.consumeWith$$anonfun$1$$anonfun$5()), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:318)").mapZIO((Function1 & Serializable)_$17 -> _$17.commitOrRetry(commitRetryPolicy), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:319)").runDrain((Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:320)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:321)");
            }, (Object)"zio.kafka.consumer.Consumer.Live.consumeWith(Consumer.scala:321)");
        }

        @Override
        public <R, R1, K, V> Schedule<Object, Object, Object> consumeWith$default$4() {
            return Schedule$.MODULE$.exponential(DurationSyntax$.MODULE$.second$extension(package$.MODULE$.durationInt(1)), Schedule$.MODULE$.exponential$default$2(), (Object)"zio.kafka.consumer.Consumer.Live.consumeWith$default$4(Consumer.scala:307)").$amp$amp(Schedule$.MODULE$.recurs(3, (Object)"zio.kafka.consumer.Consumer.Live.consumeWith$default$4(Consumer.scala:307)"), Zippable$.MODULE$.Zippable2());
        }

        private ZIO<Object, Throwable, BoxedUnit> subscribe(Subscription subscription) {
            return this.runloop().changeSubscription((Option<Subscription>)Some$.MODULE$.apply((Object)subscription));
        }

        private ZIO<Object, Throwable, BoxedUnit> unsubscribe() {
            return this.runloop().changeSubscription((Option<Subscription>)None$.MODULE$);
        }

        @Override
        public ZIO<Object, Throwable, scala.collection.immutable.Map<MetricName, Metric>> metrics() {
            return this.consumer().withConsumer((Function1 & Serializable)_$18 -> CollectionConverters$.MODULE$.MapHasAsScala(_$18.metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        private final InvalidSubscriptionUnion extendSubscriptions$1$$anonfun$1$$anonfun$1(NonEmptyChunk newSubscriptions$1) {
            return InvalidSubscriptionUnion$.MODULE$.apply((Chunk<Subscription>)NonEmptyChunk$.MODULE$.toChunk(newSubscriptions$1));
        }

        private final String extendSubscriptions$1$$anonfun$1$$anonfun$2(Subscription union$1) {
            return new StringBuilder(31).append("Changing kafka subscription to ").append(union$1).toString();
        }

        private final scala.collection.immutable.Set extendSubscriptions$1$$anonfun$1$$anonfun$3$$anonfun$1(NonEmptyChunk newSubscriptions$3) {
            return NonEmptyChunk$.MODULE$.toChunk(newSubscriptions$3).toSet();
        }

        private final ZIO extendSubscriptions$1$$anonfun$1$$anonfun$3(NonEmptyChunk newSubscriptions$2, Subscription union$2) {
            return this.subscribe(union$2).as(() -> this.extendSubscriptions$1$$anonfun$1$$anonfun$3$$anonfun$1(newSubscriptions$2), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.extendSubscriptions(Consumer.scala:231)");
        }

        private final ZIO extendSubscriptions$1(Subscription subscription$1) {
            return this.subscriptions().updateZIO((Function1 & Serializable)existingSubscriptions -> {
                NonEmptyChunk newSubscriptions = NonEmptyChunk$.MODULE$.fromIterable((Object)subscription$1, (Iterable)existingSubscriptions);
                Option<Subscription> option = Subscription$.MODULE$.unionAll((NonEmptyChunk<Subscription>)newSubscriptions);
                if (None$.MODULE$.equals(option)) {
                    return ZIO$.MODULE$.fail(() -> this.extendSubscriptions$1$$anonfun$1$$anonfun$1(newSubscriptions), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.extendSubscriptions(Consumer.scala:228)");
                }
                if (option instanceof Some) {
                    Subscription union = (Subscription)((Some)option).value();
                    return ZIO$.MODULE$.logDebug(() -> this.extendSubscriptions$1$$anonfun$1$$anonfun$2(union), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.extendSubscriptions(Consumer.scala:230)").$times$greater(() -> this.extendSubscriptions$1$$anonfun$1$$anonfun$3(newSubscriptions, union), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.extendSubscriptions(Consumer.scala:231)");
                }
                throw new MatchError(option);
            }, (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.extendSubscriptions(Consumer.scala:233)").uninterruptible((Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.extendSubscriptions(Consumer.scala:233)");
        }

        private final String reduceSubscriptions$1$$anonfun$1$$anonfun$1(Subscription union$3) {
            return new StringBuilder(31).append("Reducing kafka subscription to ").append(union$3).toString();
        }

        private final ZIO reduceSubscriptions$1$$anonfun$1$$anonfun$2(Subscription union$4) {
            return this.subscribe(union$4);
        }

        private final String reduceSubscriptions$1$$anonfun$1$$anonfun$3() {
            return "Unsubscribing kafka consumer";
        }

        private final ZIO reduceSubscriptions$1$$anonfun$1$$anonfun$4() {
            return this.unsubscribe();
        }

        private final scala.collection.immutable.Set reduceSubscriptions$1$$anonfun$1$$anonfun$5$$anonfun$1() {
            return Predef$.MODULE$.Set().empty();
        }

        private final scala.collection.immutable.Set reduceSubscriptions$1$$anonfun$1$$anonfun$5(Option newSubscriptions$4) {
            return (scala.collection.immutable.Set)newSubscriptions$4.fold(this::reduceSubscriptions$1$$anonfun$1$$anonfun$5$$anonfun$1, (Function1 & Serializable)_$7 -> NonEmptyChunk$.MODULE$.toChunk(_$7).toSet());
        }

        private final ZIO reduceSubscriptions$1(Subscription subscription$3) {
            return this.subscriptions().updateZIO((Function1 & Serializable)existingSubscriptions -> {
                ZIO zIO;
                Option newSubscriptions = NonEmptyChunk$.MODULE$.fromIterableOption((Iterable)existingSubscriptions.$minus((Object)subscription$3));
                Option newUnion = newSubscriptions.flatMap((Function1 & Serializable)subscriptions -> Subscription$.MODULE$.unionAll((NonEmptyChunk<Subscription>)subscriptions));
                Option option = newUnion;
                if (option instanceof Some) {
                    Subscription union = (Subscription)((Some)option).value();
                    zIO = ZIO$.MODULE$.logDebug(() -> this.reduceSubscriptions$1$$anonfun$1$$anonfun$1(union), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:241)").$times$greater(() -> this.reduceSubscriptions$1$$anonfun$1$$anonfun$2(union), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:241)");
                } else if (None$.MODULE$.equals(option)) {
                    zIO = ZIO$.MODULE$.logDebug(this::reduceSubscriptions$1$$anonfun$1$$anonfun$3, (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:243)").$times$greater(this::reduceSubscriptions$1$$anonfun$1$$anonfun$4, (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:243)");
                } else {
                    throw new MatchError((Object)option);
                }
                return zIO.as(() -> this.reduceSubscriptions$1$$anonfun$1$$anonfun$5(newSubscriptions), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:244)");
            }, (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:245)").uninterruptible((Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.reduceSubscriptions(Consumer.scala:245)");
        }

        private final Hub partitionedAssignmentStream$$anonfun$1$$anonfun$1() {
            return this.partitionAssignments();
        }

        private final int partitionedAssignmentStream$$anonfun$1$$anonfun$2() {
            return ZStream$.MODULE$.fromHubScoped$default$2();
        }

        private final /* synthetic */ Exit partitionedAssignmentStream$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(Exit _$9) {
            return _$9;
        }

        private final ZIO partitionedAssignmentStream$$anonfun$1(Subscription subscription$6, Deserializer keyDeserializer$2, Deserializer valueDeserializer$2, boolean onlyByteArraySerdes$2) {
            return ZStream$.MODULE$.fromHubScoped(this::partitionedAssignmentStream$$anonfun$1$$anonfun$1, this::partitionedAssignmentStream$$anonfun$1$$anonfun$2, (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:251)").flatMap((Function1 & Serializable)stream -> this.extendSubscriptions$1(subscription$6).withFinalizer((Function1 & Serializable)_$8 -> this.reduceSubscriptions$1(subscription$6).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:252)"), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:252)").map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return stream.map((Function1 & Serializable)_$9 -> this.partitionedAssignmentStream$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(_$9 == null ? null : ((Take)_$9).exit()), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:254)").flattenExitOption((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:255)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:256)").map((Function1 & Serializable)_$10 -> _$10.collect((PartialFunction)new Serializable(subscription$6, keyDeserializer$2, valueDeserializer$2, onlyByteArraySerdes$2){
                    private final Subscription subscription$9;
                    private final Deserializer keyDeserializer$5;
                    private final Deserializer valueDeserializer$5;
                    private final boolean onlyByteArraySerdes$5;
                    {
                        this.subscription$9 = subscription$17;
                        this.keyDeserializer$5 = keyDeserializer$12;
                        this.valueDeserializer$5 = valueDeserializer$12;
                        this.onlyByteArraySerdes$5 = onlyByteArraySerdes$6;
                    }

                    public final boolean isDefinedAt(Tuple2 x) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            ZStream partitionStream = (ZStream)tuple2._2();
                            if (Subscription$.MODULE$.subscriptionMatches(this.subscription$9, tp)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            ZStream partitionStream = (ZStream)tuple2._2();
                            if (Subscription$.MODULE$.subscriptionMatches(this.subscription$9, tp)) {
                                ZStream stream = this.onlyByteArraySerdes$5 ? partitionStream : partitionStream.mapChunksZIO((Function1 & Serializable)_$11 -> _$11.mapZIO((Function1 & Serializable)_$12 -> _$12.deserializeWith(this.keyDeserializer$5, this.valueDeserializer$5, $less$colon$less$.MODULE$.refl(), $less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.stream(Consumer.scala:262)"), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream.stream(Consumer.scala:262)");
                                TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)stream);
                            }
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$2(zio.Chunk ), $anonfun$2$$anonfun$1(zio.kafka.consumer.CommittableRecord )}, serializedLambda);
                    }
                }), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:266)");
            }, (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:266)"), (Object)"zio.kafka.consumer.Consumer.Live.partitionedAssignmentStream(Consumer.scala:266)");
        }

        private final int plainStream$$anonfun$1() {
            return Integer.MAX_VALUE;
        }

        private final int plainStream$$anonfun$2(int bufferSize$1) {
            return bufferSize$1;
        }

        private final int consumeWith$$anonfun$1$$anonfun$1() {
            return Integer.MAX_VALUE;
        }

        private final int consumeWith$$anonfun$1$$anonfun$2(ZStream $1$$1) {
            return $1$$1.flatMapPar$default$2();
        }

        private final Offset consumeWith$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(CommittableRecord c$1) {
            return c$1.offset();
        }

        private final ZEnvironment consumeWith$$anonfun$1$$anonfun$4(ZEnvironment r$1) {
            return r$1;
        }

        private final ZChannel consumeWith$$anonfun$1$$anonfun$5() {
            return Consumer$.MODULE$.offsetBatches();
        }
    }

    public static interface OffsetRetrieval {
        public static int ordinal(OffsetRetrieval offsetRetrieval) {
            return Consumer$OffsetRetrieval$.MODULE$.ordinal(offsetRetrieval);
        }
    }
}

