/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Exit;
import zio.IsSubtypeOfOutput$;
import zio.LogAnnotation;
import zio.LogAnnotation$;
import zio.Promise;
import zio.Queue;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.PartitionStreamControl$;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;

public final class PartitionStreamControl {
    private final TopicPartition tp;
    private final Queue<Exit> dataQueue;
    private final Promise<Throwable, BoxedUnit> interruptionPromise;
    private final Promise<Nothing$, BoxedUnit> completedPromise;
    private final Ref<Object> queueSizeRef;
    private final ZIO.LogAnnotate logAnnotate;
    private final Tuple2 tpStream;

    public static ZIO<Object, Nothing$, PartitionStreamControl> newPartitionStream(TopicPartition topicPartition, Queue<RunloopCommand> queue, Diagnostics diagnostics) {
        return PartitionStreamControl$.MODULE$.newPartitionStream(topicPartition, queue, diagnostics);
    }

    public PartitionStreamControl(TopicPartition tp, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>> stream, Queue<Exit> dataQueue, Promise<Throwable, BoxedUnit> interruptionPromise, Promise<Nothing$, BoxedUnit> completedPromise, Ref<Object> queueSizeRef) {
        this.tp = tp;
        this.dataQueue = dataQueue;
        this.interruptionPromise = interruptionPromise;
        this.completedPromise = completedPromise;
        this.queueSizeRef = queueSizeRef;
        this.logAnnotate = ZIO$.MODULE$.logAnnotate(() -> PartitionStreamControl.$init$$$anonfun$1(tp), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogAnnotation[]{LogAnnotation$.MODULE$.apply("partition", BoxesRunTime.boxToInteger((int)tp.partition()).toString())}));
        this.tpStream = Tuple2$.MODULE$.apply((Object)tp, stream);
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public ZIO<Object, Nothing$, BoxedUnit> offerRecords(Chunk<CommittableRecord<byte[], byte[]>> data) {
        return this.queueSizeRef.update((Function1)(JFunction1.mcII.sp & Serializable)_$1 -> _$1 + data.size(), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)").$times$greater(() -> this.offerRecords$$anonfun$2(data), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)");
    }

    public ZIO<Object, Nothing$, Object> queueSize() {
        return this.queueSizeRef.get((Object)"zio.kafka.consumer.internal.PartitionStreamControl.queueSize(PartitionStreamControl.scala:27)");
    }

    public ZIO<Object, Nothing$, Object> lost() {
        return this.interruptionPromise.fail((Object)new RuntimeException(new StringBuilder(19).append("Partition ").append(this.tp().toString()).append(" was lost").toString()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.lost(PartitionStreamControl.scala:31)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> end() {
        return this.logAnnotate.apply(ZIO$.MODULE$.logDebug(this::end$$anonfun$1, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:36)").$times$greater(this::end$$anonfun$2, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:37)"), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:38)");
    }

    public ZIO<Object, Nothing$, Object> isCompleted() {
        return this.completedPromise.isDone((Object)"zio.kafka.consumer.internal.PartitionStreamControl.isCompleted(PartitionStreamControl.scala:42)");
    }

    public ZIO<Object, Nothing$, Object> isRunning() {
        return this.isCompleted().negate(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.isRunning(PartitionStreamControl.scala:46)");
    }

    public Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>> tpStream() {
        return this.tpStream;
    }

    private static final LogAnnotation $init$$$anonfun$1(TopicPartition tp$1) {
        return LogAnnotation$.MODULE$.apply("topic", tp$1.topic());
    }

    private final ZIO offerRecords$$anonfun$2(Chunk data$2) {
        return this.dataQueue.offer((Object)new Take(Take$.MODULE$.chunk(data$2)), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)").unit((Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:25)");
    }

    private final String end$$anonfun$1() {
        return new StringBuilder(17).append("Partition ").append(this.tp().toString()).append(" ending").toString();
    }

    private final ZIO end$$anonfun$2() {
        return this.dataQueue.offer((Object)new Take(Take$.MODULE$.end()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:37)").unit((Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:37)");
    }
}

