/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import scala.util.matching.Regex;
import zio.CanFail$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.Dequeue;
import zio.Exit;
import zio.Exit$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Ref;
import zio.Runtime;
import zio.Scope;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.CommittableRecord$;
import zio.kafka.consumer.Consumer;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Auto$;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Manual$;
import zio.kafka.consumer.Consumer$RunloopTimeout$;
import zio.kafka.consumer.RebalanceConsumer;
import zio.kafka.consumer.RebalanceConsumer$Live$;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.RebalanceListener$;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.Subscription$Manual$;
import zio.kafka.consumer.Subscription$Pattern$;
import zio.kafka.consumer.Subscription$Topics$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Failure$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Started$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Success$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Poll$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Rebalance$Assigned$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Rebalance$Lost$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Rebalance$Revoked$;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.PartitionStreamControl$;
import zio.kafka.consumer.internal.Runloop;
import zio.kafka.consumer.internal.Runloop$;
import zio.kafka.consumer.internal.Runloop$FulfillResult$;
import zio.kafka.consumer.internal.Runloop$PollResult$;
import zio.kafka.consumer.internal.Runloop$RebalanceEvent$;
import zio.kafka.consumer.internal.Runloop$RebalanceEvent$Assigned$;
import zio.kafka.consumer.internal.Runloop$RebalanceEvent$Revoked$;
import zio.kafka.consumer.internal.Runloop$RebalanceEvent$RevokedAndAssigned$;
import zio.kafka.consumer.internal.Runloop$RevokeResult$;
import zio.kafka.consumer.internal.Runloop$StreamOps$;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.kafka.consumer.internal.RunloopCommand$ChangeSubscription$;
import zio.kafka.consumer.internal.RunloopCommand$Commit$;
import zio.kafka.consumer.internal.RunloopCommand$Poll$;
import zio.kafka.consumer.internal.RunloopCommand$StopAllStreams$;
import zio.kafka.consumer.internal.RunloopCommand$StopRunloop$;
import zio.kafka.consumer.internal.State;
import zio.kafka.consumer.internal.State$;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Runloop {
    public final Runtime<Object> zio$kafka$consumer$internal$Runloop$$runtime;
    private final ConsumerAccess consumer;
    private final Duration pollTimeout;
    private final Duration runloopTimeout;
    private final Queue<RunloopCommand> commandQueue;
    private final Ref.Synchronized<Option<RebalanceEvent>> lastRebalanceEvent;
    private final Queue partitionsQueue;
    private final Diagnostics diagnostics;
    private final Consumer.OffsetRetrieval offsetRetrieval;
    private final Ref<State> currentStateRef;
    private final int maxPartitionQueueSize;
    private final RebalanceListener rebalanceListener;
    private final Function1<scala.collection.immutable.Map<TopicPartition, Object>, ZIO<Object, Throwable, BoxedUnit>> commit;
    private final ZIO<Object, Nothing$, Option<ConsumerGroupMetadata>> getConsumerGroupMetadataIfAny;

    public static ZIO<Scope, Throwable, Runloop> make(boolean bl, ConsumerAccess consumerAccess, Duration duration, Diagnostics diagnostics, Consumer.OffsetRetrieval offsetRetrieval, RebalanceListener rebalanceListener, boolean bl2, Duration duration2, int n) {
        return Runloop$.MODULE$.make(bl, consumerAccess, duration, diagnostics, offsetRetrieval, rebalanceListener, bl2, duration2, n);
    }

    public Runloop(Runtime<Object> runtime, boolean hasGroupId, ConsumerAccess consumer, Duration pollTimeout, Duration runloopTimeout, Queue<RunloopCommand> commandQueue, Ref.Synchronized<Option<RebalanceEvent>> lastRebalanceEvent, Queue<Exit> partitionsQueue, Diagnostics diagnostics, Consumer.OffsetRetrieval offsetRetrieval, RebalanceListener userRebalanceListener, boolean restartStreamsOnRebalancing, Ref<State> currentStateRef, int maxPartitionQueueSize) {
        this.zio$kafka$consumer$internal$Runloop$$runtime = runtime;
        this.consumer = consumer;
        this.pollTimeout = pollTimeout;
        this.runloopTimeout = runloopTimeout;
        this.commandQueue = commandQueue;
        this.lastRebalanceEvent = lastRebalanceEvent;
        this.partitionsQueue = partitionsQueue;
        this.diagnostics = diagnostics;
        this.offsetRetrieval = offsetRetrieval;
        this.currentStateRef = currentStateRef;
        this.maxPartitionQueueSize = maxPartitionQueueSize;
        RebalanceListener emitDiagnostics = RebalanceListener$.MODULE$.apply((Function2<scala.collection.immutable.Set<TopicPartition>, RebalanceConsumer, ZIO<Object, Throwable, BoxedUnit>>)(Function2 & Serializable)(assigned, _$1) -> diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$1$$anonfun$1(assigned))), (Function2<scala.collection.immutable.Set<TopicPartition>, RebalanceConsumer, ZIO<Object, Throwable, BoxedUnit>>)(Function2 & Serializable)(revoked, _$2) -> diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$2$$anonfun$1(revoked))), (Function2<scala.collection.immutable.Set<TopicPartition>, RebalanceConsumer, ZIO<Object, Throwable, BoxedUnit>>)(Function2 & Serializable)(lost, _$3) -> diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$3$$anonfun$1(lost))));
        this.rebalanceListener = restartStreamsOnRebalancing ? emitDiagnostics.$plus$plus(this.restartStreamsRebalancingListener$1(lastRebalanceEvent, currentStateRef)).$plus$plus(userRebalanceListener) : emitDiagnostics.$plus$plus(userRebalanceListener);
        this.commit = (Function1 & Serializable)offsets -> Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:106)").flatMap((Function1 & Serializable)p -> commandQueue.offer((Object)RunloopCommand$Commit$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, Object>)offsets, (Promise<Throwable, BoxedUnit>)p), (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:107)").unit((Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:107)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$init$$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(offsets))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return p.await((Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:109)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:110)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:110)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:110)"), (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:110)");
        this.getConsumerGroupMetadataIfAny = hasGroupId ? consumer.runloopAccess((Function1 & Serializable)c -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$3 -> c.groupMetadata(), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:214)")).fold((Function1 & Serializable)_$9 -> None$.MODULE$, (Function1 & Serializable)_$10 -> Some$.MODULE$.apply(_$10), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:214)") : ZIO$.MODULE$.none();
    }

    public Queue<Exit> partitionsQueue() {
        return this.partitionsQueue;
    }

    private ZIO<Object, Nothing$, PartitionStreamControl> newPartitionStream(TopicPartition tp) {
        return PartitionStreamControl$.MODULE$.newPartitionStream(tp, this.commandQueue, this.diagnostics);
    }

    public ZIO<Object, Nothing$, BoxedUnit> stopConsumption() {
        return this.commandQueue.offer((Object)RunloopCommand$StopAllStreams$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:41)").unit((Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:41)");
    }

    public ZIO<Object, Throwable, BoxedUnit> changeSubscription(Option<Subscription> subscription) {
        return Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:47)").flatMap((Function1 & Serializable)cont -> this.commandQueue.offer((Object)RunloopCommand$ChangeSubscription$.MODULE$.apply(subscription, (Promise<Throwable, BoxedUnit>)cont), (Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:49)").$times$greater(() -> Runloop.changeSubscription$$anonfun$1$$anonfun$1(cont), (Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:50)"), (Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:51)").unit((Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:52)").uninterruptible((Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:53)");
    }

    private ZIO<Object, Nothing$, BoxedUnit> doCommit(RunloopCommand.Commit cmd) {
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)cmd.offsets().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = BoxesRunTime.unboxToLong((Object)tuple2._2());
                TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)new OffsetAndMetadata(offset + 1L));
            }
            throw new MatchError((Object)tuple2);
        });
        Function1 & Serializable cont = (Function1 & Serializable)e -> cmd.cont().done(e, (Object)"zio.kafka.consumer.internal.Runloop.doCommit.cont(Runloop.scala:114)");
        ZIO onSuccess = ((ZIO)cont.apply((Object)Exit$.MODULE$.unit())).$less$times(() -> this.$anonfun$6(offsets), (Object)"zio.kafka.consumer.internal.Runloop.doCommit.onSuccess(Runloop.scala:115)");
        Function1 & Serializable onFailure = (Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof RebalanceInProgressException) {
                return ZIO$.MODULE$.logDebug(() -> Runloop.$anonfun$7$$anonfun$1(offsets), (Object)"zio.kafka.consumer.internal.Runloop.doCommit.onFailure(Runloop.scala:118)").$times$greater(() -> this.$anonfun$7$$anonfun$2(cmd), (Object)"zio.kafka.consumer.internal.Runloop.doCommit.onFailure(Runloop.scala:119)");
            }
            Throwable err = throwable;
            return ((ZIO)cont.apply((Object)Exit$.MODULE$.fail((Object)err))).$less$times(() -> this.$anonfun$7$$anonfun$3(offsets, err), (Object)"zio.kafka.consumer.internal.Runloop.doCommit.onFailure(Runloop.scala:121)");
        };
        OffsetCommitCallback callback = new OffsetCommitCallback(onSuccess, onFailure, this){
            private final ZIO onSuccess$1;
            private final Function1 onFailure$1;
            private final /* synthetic */ Runloop $outer;
            {
                this.onSuccess$1 = onSuccess$2;
                this.onFailure$1 = onFailure$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onComplete(java.util.Map offsets, Exception exception) {
                Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> this.$outer.zio$kafka$consumer$internal$Runloop$$runtime.unsafe().run(exception == null ? this.onSuccess$1 : (ZIO)this.onFailure$1.apply((Object)exception), (Object)"zio.kafka.consumer.internal.Runloop.doCommit.callback.$anon.onComplete(Runloop.scala:127)", u).getOrThrowFiberFailure(u));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onComplete$$anonfun$1(java.lang.Exception zio.Unsafe )}, serializedLambda);
            }
        };
        return this.consumer.runloopAccess((Function1 & Serializable)c -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> c.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava(), callback), (Object)"zio.kafka.consumer.internal.Runloop.doCommit(Runloop.scala:135)").catchAll(onFailure, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.doCommit(Runloop.scala:136)"));
    }

    private ZIO<Object, Nothing$, RevokeResult> endRevokedPartitions(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, Function1<TopicPartition, Object> isRevoked) {
        Tuple2 tuple2 = assignedStreams.partition((Function1 & Serializable)control -> BoxesRunTime.unboxToBoolean((Object)isRevoked.apply((Object)control.tp())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Chunk revokedStreams = (Chunk)tuple2._1();
        Chunk newAssignedStreams = (Chunk)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)revokedStreams, (Object)newAssignedStreams);
        Chunk revokedStreams2 = (Chunk)tuple22._1();
        Chunk newAssignedStreams2 = (Chunk)tuple22._2();
        return ZIO$.MODULE$.foreachDiscard(() -> Runloop.endRevokedPartitions$$anonfun$1(revokedStreams2), (Function1 & Serializable)_$8 -> _$8.end(), (Object)"zio.kafka.consumer.internal.Runloop.endRevokedPartitions(Runloop.scala:155)").as(() -> Runloop.endRevokedPartitions$$anonfun$3(pendingRequests, isRevoked, newAssignedStreams2), (Object)"zio.kafka.consumer.internal.Runloop.endRevokedPartitions(Runloop.scala:161)");
    }

    private ZIO<Object, Nothing$, FulfillResult> offerRecordsToStreams(Chunk<PartitionStreamControl> partitionStreams, Chunk<RunloopCommand.Request> pendingRequests, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, ConsumerRecords<byte[], byte[]> polledRecords) {
        Chunk streams;
        scala.collection.immutable.Set tps = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(polledRecords.partitions()).asScala().toSet().$minus$minus(ignoreRecordsForTps);
        FulfillResult fulfillResult = Runloop$FulfillResult$.MODULE$.apply((Chunk<RunloopCommand.Request>)pendingRequests.filter((Function1 & Serializable)req -> !tps.contains((Object)req.tp())));
        Chunk chunk = streams = tps.isEmpty() ? Chunk$.MODULE$.empty() : partitionStreams.filter((Function1 & Serializable)streamControl -> tps.contains((Object)streamControl.tp()));
        if (streams.isEmpty()) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> fulfillResult, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:186)");
        }
        return this.getConsumerGroupMetadataIfAny.flatMap((Function1 & Serializable)consumerGroupMetadata -> ZIO$.MODULE$.foreachParDiscard(() -> Runloop.offerRecordsToStreams$$anonfun$2$$anonfun$1(streams), (Function1 & Serializable)streamControl -> {
            TopicPartition tp = streamControl.tp();
            List records = polledRecords.records(tp);
            if (records.isEmpty()) {
                return ZIO$.MODULE$.unit();
            }
            ChunkBuilder builder = ChunkBuilder$.MODULE$.make(records.size());
            for (ConsumerRecord consumerRecord : records) {
                builder.$plus$eq(CommittableRecord$.MODULE$.apply(consumerRecord, this.commit, (Option<ConsumerGroupMetadata>)consumerGroupMetadata));
            }
            return streamControl.offerRecords((Chunk<CommittableRecord<byte[], byte[]>>)((Chunk)builder.result()));
        }, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:208)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return fulfillResult;
        }, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:209)"), (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:209)");
    }

    private ZIO<Object, Throwable, scala.collection.immutable.Set<TopicPartition>> doSeekForNewPartitions(Consumer<byte[], byte[]> c, scala.collection.immutable.Set<TopicPartition> tps) {
        Consumer.OffsetRetrieval offsetRetrieval = this.offsetRetrieval;
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Auto) {
            Consumer.OffsetRetrieval.Auto auto = Consumer$OffsetRetrieval$Auto$.MODULE$.unapply((Consumer.OffsetRetrieval.Auto)offsetRetrieval);
            Consumer.AutoOffsetStrategy autoOffsetStrategy = auto._1();
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> Predef$.MODULE$.Set().empty(), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:219)");
        }
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Manual) {
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>>> function1;
            Consumer.OffsetRetrieval.Manual manual = Consumer$OffsetRetrieval$Manual$.MODULE$.unapply((Consumer.OffsetRetrieval.Manual)offsetRetrieval);
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>>> getOffsets = function1 = manual._1();
            if (tps.isEmpty()) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> Predef$.MODULE$.Set().empty(), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:221)");
            }
            return ((ZIO)getOffsets.apply(tps)).tap((Function1 & Serializable)offsets -> ZIO$.MODULE$.foreachDiscard(() -> Runloop.doSeekForNewPartitions$$anonfun$3$$anonfun$1(offsets), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$6 -> c.seek(tp, offset), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:224)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:224)"), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:224)").as(() -> Runloop.doSeekForNewPartitions$$anonfun$4(tps), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:225)");
        }
        throw new MatchError((Object)offsetRetrieval);
    }

    private void resumeAndPausePartitions(Consumer<byte[], byte[]> c, scala.collection.immutable.Set<TopicPartition> assignment, scala.collection.immutable.Set<TopicPartition> requestedPartitions) {
        scala.collection.immutable.Set toResume = (scala.collection.immutable.Set)assignment.intersect(requestedPartitions);
        scala.collection.immutable.Set toPause = (scala.collection.immutable.Set)assignment.$minus$minus(requestedPartitions);
        if (toResume.nonEmpty()) {
            c.resume((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)toResume).asJava());
        }
        if (toPause.nonEmpty()) {
            c.pause((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)toPause).asJava());
            return;
        }
    }

    private ZIO<Object, Throwable, State> handlePoll(State state) {
        return ZIO$.MODULE$.logDebug(() -> Runloop.handlePoll$$anonfun$1(state), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:246)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.currentStateRef.set((Object)state, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:247)").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.foldLeft(() -> Runloop.handlePoll$$anonfun$2$$anonfun$1$$anonfun$1(state), Runloop::handlePoll$$anonfun$2$$anonfun$1$$anonfun$2, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        ListBuffer acc = (ListBuffer)tuple2._1();
                        PartitionStreamControl stream = (PartitionStreamControl)tuple2._2();
                        return stream.queueSize().map((Function1 & Serializable)queueSize -> this.handlePoll$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(acc, stream, BoxesRunTime.unboxToInt((Object)queueSize)), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:256)");
                    }
                    throw new MatchError((Object)tuple2);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:257)").map((Function1 & Serializable)_$11 -> _$11.toSet(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:258)").flatMap((Function1 & Serializable)partitionsToFetch -> this.consumer.runloopAccess((Function1 & Serializable)c -> ZIO$.MODULE$.suspend(() -> this.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1(state, partitionsToFetch, c), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:336)")).flatMap((Function1 & Serializable)pollResult -> (pollResult.startingTps().isEmpty() ? ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> Chunk$.MODULE$.empty(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:339)") : ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable(pollResult.startingTps()), (Function1 & Serializable)tp -> this.newPartitionStream((TopicPartition)tp), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:342)").tap((Function1 & Serializable)newStreams -> ZIO$.MODULE$.logDebug(() -> Runloop.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1(pollResult), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:344)").$times$greater(() -> this.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$2(newStreams), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:346)")).flatMap((Function1 & Serializable)startingStreams -> ZIO$.MODULE$.filter(pollResult.assignedStreams(), (Function1 & Serializable)_$15 -> _$15.isRunning(), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:348)").map((Function1 & Serializable)runningStreams -> {
                    Chunk updatedStreams = runningStreams.$plus$plus(startingStreams);
                    return Tuple2$.MODULE$.apply(runningStreams, (Object)updatedStreams);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:349)").flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Chunk runningStreams = (Chunk)tuple2._1();
                        Chunk updatedStreams = (Chunk)tuple2._2();
                        return this.offerRecordsToStreams((Chunk<PartitionStreamControl>)updatedStreams, pollResult.pendingRequests(), pollResult.ignoreRecordsForTps(), pollResult.records()).flatMap((Function1 & Serializable)fulfillResult -> ZIO$.MODULE$.filter(state.pendingCommits(), (Function1 & Serializable)_$16 -> _$16.isPending(), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:356)").map((Function1 & Serializable)updatedPendingCommits -> state.copy(fulfillResult.pendingRequests(), (Chunk<RunloopCommand.Commit>)updatedPendingCommits, (Chunk<PartitionStreamControl>)updatedStreams, state.copy$default$4()), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)");
                    }
                    throw new MatchError((Object)tuple2);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:361)");
    }

    private ZIO<Object, Throwable, State> handleCommand(State state, RunloopCommand.StreamCommand cmd) {
        RunloopCommand.StreamCommand streamCommand = cmd;
        if (streamCommand instanceof RunloopCommand.Request) {
            RunloopCommand.Request req = (RunloopCommand.Request)streamCommand;
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$10 -> state.addRequest(req), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:365)");
        }
        if (streamCommand instanceof RunloopCommand.Commit) {
            RunloopCommand.Commit cmd2 = (RunloopCommand.Commit)streamCommand;
            return this.doCommit(cmd2).as(() -> Runloop.handleCommand$$anonfun$2(state, cmd2), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:366)");
        }
        if (streamCommand instanceof RunloopCommand.ChangeSubscription) {
            RunloopCommand.ChangeSubscription changeSubscription = (RunloopCommand.ChangeSubscription)streamCommand;
            RunloopCommand.ChangeSubscription changeSubscription2 = RunloopCommand$ChangeSubscription$.MODULE$.unapply(changeSubscription);
            Option<Subscription> option = changeSubscription2._1();
            Promise<Throwable, BoxedUnit> promise = changeSubscription2._2();
            Option<Subscription> subscription = option;
            RunloopCommand.ChangeSubscription cmd3 = changeSubscription;
            return this.handleChangeSubscription(subscription).flatMap((Function1 & Serializable)newAssignedStreams -> {
                Chunk chunk = state.assignedStreams().$plus$plus(newAssignedStreams);
                Chunk<RunloopCommand.Request> chunk2 = state.copy$default$1();
                Chunk<RunloopCommand.Commit> chunk3 = state.copy$default$2();
                State newState = state.copy(chunk2, chunk3, (Chunk<PartitionStreamControl>)chunk, subscription);
                if (subscription.isDefined()) {
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> newState, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:373)");
                }
                return this.endRevokedPartitions(newState.pendingRequests(), newState.assignedStreams(), (Function1<TopicPartition, Object>)(Function1 & Serializable)_$17 -> true).map((Function1 & Serializable)revokeResult -> newState.copy(revokeResult.pendingRequests(), newState.copy$default$2(), revokeResult.assignedStreams(), newState.copy$default$4()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:385)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:387)").tapBoth((Function1 & Serializable)e -> cmd3.fail((Throwable)e), (Function1 & Serializable)_$18 -> cmd3.succeed(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:388)").uninterruptible((Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:389)");
        }
        if (RunloopCommand$StopAllStreams$.MODULE$.equals(streamCommand)) {
            return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$6, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:392)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.foreachDiscard(() -> Runloop.handleCommand$$anonfun$7$$anonfun$1(state), (Function1 & Serializable)_$19 -> _$19.end(), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:393)").flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.partitionsQueue().offer((Object)new Take(Take$.MODULE$.end()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:394)").flatMap((Function1 & Serializable)x$1 -> Runloop.handleCommand$$anonfun$7$$anonfun$3$$anonfun$1(state, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:396)");
                }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:396)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:396)");
        }
        throw new MatchError((Object)streamCommand);
    }

    private ZIO<Object, Throwable, Chunk<PartitionStreamControl>> handleChangeSubscription(Option<Subscription> newSubscription) {
        return this.consumer.runloopAccess((Function1 & Serializable)c -> {
            Option option = newSubscription;
            if (None$.MODULE$.equals(option)) {
                return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$12 -> c.unsubscribe(), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:406)").as(Runloop::handleChangeSubscription$$anonfun$1$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:407)");
            }
            if (option instanceof Some) {
                Subscription subscription = (Subscription)((Some)option).value();
                if (subscription instanceof Subscription.Pattern) {
                    Regex regex;
                    Subscription.Pattern pattern = Subscription$Pattern$.MODULE$.unapply((Subscription.Pattern)subscription);
                    Regex pattern2 = regex = pattern._1();
                    RebalanceConsumer.Live rc = RebalanceConsumer$Live$.MODULE$.apply((Consumer<byte[], byte[]>)c);
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$13 -> c.subscribe(pattern2.pattern(), this.rebalanceListener.toKafka(this.zio$kafka$consumer$internal$Runloop$$runtime, rc)), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:411)").as(Runloop::handleChangeSubscription$$anonfun$1$$anonfun$4, (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:412)");
                }
                if (subscription instanceof Subscription.Topics) {
                    scala.collection.immutable.Set<String> set;
                    Subscription.Topics topics = Subscription$Topics$.MODULE$.unapply((Subscription.Topics)subscription);
                    scala.collection.immutable.Set<String> topics2 = set = topics._1();
                    RebalanceConsumer.Live rc = RebalanceConsumer$Live$.MODULE$.apply((Consumer<byte[], byte[]>)c);
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$14 -> c.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topics2).asJava(), this.rebalanceListener.toKafka(this.zio$kafka$consumer$internal$Runloop$$runtime, rc)), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:416)").as(Runloop::handleChangeSubscription$$anonfun$1$$anonfun$6, (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:417)");
                }
                if (subscription instanceof Subscription.Manual) {
                    scala.collection.immutable.Set<TopicPartition> set;
                    Subscription.Manual manual = Subscription$Manual$.MODULE$.unapply((Subscription.Manual)subscription);
                    scala.collection.immutable.Set<TopicPartition> topicPartitions = set = manual._1();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$15 -> c.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topicPartitions).asJava()), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:421)").flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.doSeekForNewPartitions((Consumer<byte[], byte[]>)c, topicPartitions).flatMap((Function1 & Serializable)x$1 -> {
                            scala.collection.immutable.Set set = x$1;
                            return ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable((Iterable)topicPartitions), (Function1 & Serializable)tp -> this.newPartitionStream((TopicPartition)tp), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:423)").flatMap((Function1 & Serializable)partitionStreams -> this.partitionsQueue().offer((Object)new Take(Take$.MODULE$.chunk(partitionStreams.map((Function1 & Serializable)_$20 -> _$20.tpStream()))), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:424)").map((Function1 & Serializable)x$1 -> Runloop.handleChangeSubscription$$anonfun$1$$anonfun$8$$anonfun$1$$anonfun$2$$anonfun$2(partitionStreams, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:425)"), (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:425)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:425)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handleChangeSubscription(Runloop.scala:425)");
                }
            }
            throw new MatchError((Object)option);
        });
    }

    public ZIO<Scope, Throwable, Object> run() {
        ZStream zStream = Runloop$.MODULE$.zio$kafka$consumer$internal$Runloop$$$StreamOps(ZStream$.MODULE$.fromQueue(this::run$$anonfun$1, Runloop::run$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:445)").timeoutFail(Runloop::run$$anonfun$3, this.runloopTimeout, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:446)").takeWhile((Function1 & Serializable)_$21 -> {
            RunloopCommand runloopCommand = _$21;
            RunloopCommand$StopRunloop$ runloopCommand$StopRunloop$ = RunloopCommand$StopRunloop$.MODULE$;
            return runloopCommand == null ? runloopCommand$StopRunloop$ != null : !runloopCommand.equals(runloopCommand$StopRunloop$);
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:447)"));
        return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(zStream, State$.MODULE$.initial(), (Function2 & Serializable)(state, commands) -> ZIO$.MODULE$.logDebug(() -> Runloop.run$$anonfun$5$$anonfun$1(commands), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:450)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
            Chunk streamCommands = commands.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(RunloopCommand x) {
                    RunloopCommand runloopCommand = x;
                    if (runloopCommand instanceof RunloopCommand.StreamCommand) {
                        RunloopCommand.StreamCommand cmd = (RunloopCommand.StreamCommand)runloopCommand;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(RunloopCommand x, Function1 function1) {
                    RunloopCommand runloopCommand = x;
                    if (runloopCommand instanceof RunloopCommand.StreamCommand) {
                        RunloopCommand.StreamCommand cmd = (RunloopCommand.StreamCommand)runloopCommand;
                        return cmd;
                    }
                    return function1.apply((Object)x);
                }
            });
            return Tuple2$.MODULE$.apply((Object)$2$, (Object)streamCommands);
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:451)").flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Chunk streamCommands = (Chunk)tuple2._2();
                return ZIO$.MODULE$.foldLeft(() -> Runloop.run$$anonfun$5$$anonfun$3$$anonfun$1(streamCommands), () -> Runloop.run$$anonfun$5$$anonfun$3$$anonfun$2(state), (Function2 & Serializable)(state, cmd) -> this.handleCommand((State)state, (RunloopCommand.StreamCommand)cmd), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:452)").flatMap((Function1 & Serializable)stateAfterCommands -> (stateAfterCommands.shouldPoll() ? this.handlePoll((State)stateAfterCommands) : ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$16 -> stateAfterCommands, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:455)")).flatMap((Function1 & Serializable)updatedStateAfterPoll -> (updatedStateAfterPoll.shouldPoll() ? this.commandQueue.offer((Object)RunloopCommand$Poll$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:457)") : ZIO$.MODULE$.unit()).map((Function1 & Serializable)x$1 -> {
                    Object object = x$1;
                    return updatedStateAfterPoll;
                }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:458)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:458)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:458)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:458)")).tapErrorCause((Function1 & Serializable)cause -> ZIO$.MODULE$.logErrorCause(Runloop::run$$anonfun$6$$anonfun$1, () -> Runloop.run$$anonfun$6$$anonfun$2(cause), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:460)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:460)").onError((Function1 & Serializable)cause -> this.partitionsQueue().offer((Object)new Take(Take$.MODULE$.failCause(cause)), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:461)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:461)");
    }

    private static final DiagnosticEvent $anonfun$1$$anonfun$1(scala.collection.immutable.Set assigned$1) {
        return DiagnosticEvent$Rebalance$Assigned$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)assigned$1);
    }

    private static final DiagnosticEvent $anonfun$2$$anonfun$1(scala.collection.immutable.Set revoked$1) {
        return DiagnosticEvent$Rebalance$Revoked$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)revoked$1);
    }

    private static final DiagnosticEvent $anonfun$3$$anonfun$1(scala.collection.immutable.Set lost$1) {
        return DiagnosticEvent$Rebalance$Lost$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)lost$1);
    }

    private static final String restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$1() {
        return "Rebalancing completed";
    }

    private static final RebalanceEvent.Assigned restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(scala.collection.immutable.Set assigned$4) {
        return Runloop$RebalanceEvent$Assigned$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)assigned$4);
    }

    private static final RebalanceEvent.RevokedAndAssigned restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(scala.collection.immutable.Set assigned$5, RevokeResult revokeResult$1) {
        return Runloop$RebalanceEvent$RevokedAndAssigned$.MODULE$.apply(revokeResult$1, (scala.collection.immutable.Set<TopicPartition>)assigned$5);
    }

    private static final IllegalStateException restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3() {
        return new IllegalStateException("Multiple onAssigned calls on rebalance listener");
    }

    private static final ZIO restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2(Ref.Synchronized lastRebalanceEvent$3, scala.collection.immutable.Set assigned$2) {
        return lastRebalanceEvent$3.updateZIO((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return ZIO$.MODULE$.some(() -> Runloop.restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(assigned$2), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:67)");
            }
            if (option instanceof Some) {
                RebalanceEvent rebalanceEvent = (RebalanceEvent)((Some)option).value();
                if (rebalanceEvent instanceof RebalanceEvent.Revoked) {
                    RevokeResult revokeResult;
                    RebalanceEvent.Revoked revoked = Runloop$RebalanceEvent$Revoked$.MODULE$.unapply((RebalanceEvent.Revoked)rebalanceEvent);
                    RevokeResult revokeResult2 = revokeResult = revoked._1();
                    return ZIO$.MODULE$.some(() -> Runloop.restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(assigned$2, revokeResult2), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:69)");
                }
                return ZIO$.MODULE$.fail(Runloop::restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3, (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:71)");
            }
            throw new MatchError((Object)option);
        }, (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:72)");
    }

    private static final String restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$1() {
        return "Rebalancing started";
    }

    private static final RebalanceEvent.Revoked restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(RevokeResult result$2) {
        return Runloop$RebalanceEvent$Revoked$.MODULE$.apply(result$2);
    }

    private static final IllegalStateException restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2() {
        return new IllegalStateException("onRevoked called on rebalance listener with pending assigned event");
    }

    private final ZIO restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$2(Ref.Synchronized lastRebalanceEvent$5, Ref currentStateRef$3) {
        return currentStateRef$3.get((Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:75)").flatMap((Function1 & Serializable)state -> this.endRevokedPartitions(state.pendingRequests(), state.assignedStreams(), (Function1<TopicPartition, Object>)(Function1 & Serializable)_$7 -> true).flatMap((Function1 & Serializable)result -> lastRebalanceEvent$5.updateZIO((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return ZIO$.MODULE$.some(() -> Runloop.restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(result), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:84)");
            }
            return ZIO$.MODULE$.fail(Runloop::restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:90)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:91)"), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:92)"), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:93)");
    }

    private final RebalanceListener restartStreamsRebalancingListener$1(Ref.Synchronized lastRebalanceEvent$1, Ref currentStateRef$1) {
        return RebalanceListener$.MODULE$.apply((Function2<scala.collection.immutable.Set<TopicPartition>, RebalanceConsumer, ZIO<Object, Throwable, BoxedUnit>>)(Function2 & Serializable)(assigned, _$4) -> ZIO$.MODULE$.logDebug(Runloop::restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:64)").$times$greater(() -> Runloop.restartStreamsRebalancingListener$1$$anonfun$1$$anonfun$2(lastRebalanceEvent$1, assigned), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:72)"), (Function2<scala.collection.immutable.Set<TopicPartition>, RebalanceConsumer, ZIO<Object, Throwable, BoxedUnit>>)(Function2 & Serializable)(_$5, _$6) -> ZIO$.MODULE$.logDebug(Runloop::restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:74)").$times$greater(() -> this.restartStreamsRebalancingListener$1$$anonfun$2$$anonfun$2(lastRebalanceEvent$1, currentStateRef$1), (Object)"zio.kafka.consumer.internal.Runloop.rebalanceListener.restartStreamsRebalancingListener(Runloop.scala:93)"));
    }

    private static final DiagnosticEvent $init$$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.immutable.Map offsets$3) {
        return DiagnosticEvent$Commit$Started$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, Object>)offsets$3);
    }

    private static final ZIO changeSubscription$$anonfun$1$$anonfun$1(Promise cont$1) {
        return cont$1.await((Object)"zio.kafka.consumer.internal.Runloop.changeSubscription(Runloop.scala:50)");
    }

    private static final DiagnosticEvent $anonfun$6$$anonfun$1(scala.collection.immutable.Map offsets$5) {
        return DiagnosticEvent$Commit$Success$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$5);
    }

    private final ZIO $anonfun$6(scala.collection.immutable.Map offsets$4) {
        return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$6$$anonfun$1(offsets$4)));
    }

    private static final String $anonfun$7$$anonfun$1(scala.collection.immutable.Map offsets$7) {
        return new StringBuilder(51).append("Rebalance in progress, retrying commit for offsets ").append(offsets$7).toString();
    }

    private final ZIO $anonfun$7$$anonfun$2(RunloopCommand.Commit cmd$3) {
        return this.commandQueue.offer((Object)cmd$3, (Object)"zio.kafka.consumer.internal.Runloop.doCommit.onFailure(Runloop.scala:119)").unit((Object)"zio.kafka.consumer.internal.Runloop.doCommit.onFailure(Runloop.scala:119)");
    }

    private static final DiagnosticEvent $anonfun$7$$anonfun$3$$anonfun$1(scala.collection.immutable.Map offsets$9, Throwable err$2) {
        return DiagnosticEvent$Commit$Failure$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$9, err$2);
    }

    private final ZIO $anonfun$7$$anonfun$3(scala.collection.immutable.Map offsets$8, Throwable err$1) {
        return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$7$$anonfun$3$$anonfun$1(offsets$8, err$1)));
    }

    private static final Iterable endRevokedPartitions$$anonfun$1(Chunk revokedStreams$1) {
        return revokedStreams$1;
    }

    private static final RevokeResult endRevokedPartitions$$anonfun$3(Chunk pendingRequests$3, Function1 isRevoked$2, Chunk newAssignedStreams$1) {
        return Runloop$RevokeResult$.MODULE$.apply((Chunk<RunloopCommand.Request>)pendingRequests$3.filter((Function1 & Serializable)req -> !BoxesRunTime.unboxToBoolean((Object)isRevoked$2.apply((Object)req.tp()))), (Chunk<PartitionStreamControl>)newAssignedStreams$1);
    }

    private static final Iterable offerRecordsToStreams$$anonfun$2$$anonfun$1(Chunk streams$2) {
        return streams$2;
    }

    private static final Iterable doSeekForNewPartitions$$anonfun$3$$anonfun$1(scala.collection.immutable.Map offsets$12) {
        return offsets$12;
    }

    private static final scala.collection.immutable.Set doSeekForNewPartitions$$anonfun$4(scala.collection.immutable.Set tps$3) {
        return tps$3;
    }

    private static final String handlePoll$$anonfun$1(State state$1) {
        return new StringBuilder(57).append("Starting poll with ").append(state$1.pendingRequests().size()).append(" pending requests and ").append(state$1.pendingCommits().size()).append(" pending commits").toString();
    }

    private static final Iterable handlePoll$$anonfun$2$$anonfun$1$$anonfun$1(State state$4) {
        return state$4.assignedStreams();
    }

    private static final ListBuffer handlePoll$$anonfun$2$$anonfun$1$$anonfun$2() {
        return ListBuffer$.MODULE$.empty();
    }

    private final /* synthetic */ ListBuffer handlePoll$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(ListBuffer acc$1, PartitionStreamControl stream$1, int queueSize) {
        if (queueSize < this.maxPartitionQueueSize) {
            acc$1.append((Object)stream$1.tp());
        }
        return acc$1;
    }

    private static final DiagnosticEvent handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$6$$anonfun$1(scala.collection.immutable.Set requestedPartitions$4, ConsumerRecords polledRecords$6) {
        scala.collection.immutable.Set providedTps = CollectionConverters$.MODULE$.SetHasAsScala(polledRecords$6.partitions()).asScala().toSet();
        return DiagnosticEvent$Poll$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)requestedPartitions$4, (scala.collection.immutable.Set<TopicPartition>)providedTps, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)requestedPartitions$4.$minus$minus((IterableOnce)providedTps)));
    }

    private final ZIO handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1(State state$5, scala.collection.immutable.Set partitionsToFetch$1, Consumer c$6) {
        scala.collection.immutable.Set prevAssigned = CollectionConverters$.MODULE$.SetHasAsScala(c$6.assignment()).asScala().toSet();
        scala.collection.immutable.Set requestedPartitions = state$5.pendingRequests().map((Function1 & Serializable)_$12 -> _$12.tp()).toSet();
        this.resumeAndPausePartitions((Consumer<byte[], byte[]>)c$6, (scala.collection.immutable.Set<TopicPartition>)prevAssigned, (scala.collection.immutable.Set<TopicPartition>)partitionsToFetch$1);
        ConsumerRecords records = c$6.poll(this.pollTimeout);
        ConsumerRecords polledRecords = records == null ? ConsumerRecords.empty() : records;
        scala.collection.immutable.Set currentAssigned = CollectionConverters$.MODULE$.SetHasAsScala(c$6.assignment()).asScala().toSet();
        scala.collection.immutable.Set newlyAssigned = (scala.collection.immutable.Set)currentAssigned.$minus$minus((IterableOnce)prevAssigned);
        return this.doSeekForNewPartitions((Consumer<byte[], byte[]>)c$6, (scala.collection.immutable.Set<TopicPartition>)newlyAssigned).flatMap((Function1 & Serializable)ignoreRecordsForTps -> this.lastRebalanceEvent.getAndSet((Object)None$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:278)").flatMap((Function1 & Serializable)rebalanceEvent -> {
            ZIO<Object, Nothing$, RevokeResult> zIO;
            Option option = rebalanceEvent;
            if (option instanceof Some) {
                RebalanceEvent rebalanceEvent2 = (RebalanceEvent)((Some)option).value();
                if (rebalanceEvent2 instanceof RebalanceEvent.Revoked) {
                    RevokeResult revokeResult2;
                    RebalanceEvent.Revoked revoked = Runloop$RebalanceEvent$Revoked$.MODULE$.unapply((RebalanceEvent.Revoked)rebalanceEvent2);
                    RevokeResult result = revokeResult2 = revoked._1();
                    zIO = ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> result, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:284)");
                    return zIO.map((Function1 & Serializable)revokeResult -> {
                        scala.collection.immutable.Set set;
                        Option option = rebalanceEvent;
                        if (option instanceof Some) {
                            set = currentAssigned;
                        } else if (None$.MODULE$.equals(option)) {
                            set = newlyAssigned;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        scala.collection.immutable.Set startingTps = set;
                        return Tuple2$.MODULE$.apply(revokeResult, (Object)startingTps);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:318)").flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 != null) {
                            RevokeResult revokeResult = (RevokeResult)tuple2._1();
                            scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)tuple2._2();
                            return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$6$$anonfun$1(requestedPartitions, polledRecords))).map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return Runloop$PollResult$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)startingTps, revokeResult.pendingRequests(), revokeResult.assignedStreams(), (ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)ignoreRecordsForTps);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                        }
                        throw new MatchError((Object)tuple2);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                }
                if (rebalanceEvent2 instanceof RebalanceEvent.RevokedAndAssigned) {
                    RebalanceEvent.RevokedAndAssigned revokedAndAssigned = Runloop$RebalanceEvent$RevokedAndAssigned$.MODULE$.unapply((RebalanceEvent.RevokedAndAssigned)rebalanceEvent2);
                    RevokeResult revokeResult3 = revokedAndAssigned._1();
                    scala.collection.immutable.Set<TopicPartition> set = revokedAndAssigned._2();
                    RevokeResult result = revokeResult3;
                    zIO = ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> result, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:288)");
                    return zIO.map((Function1 & Serializable)revokeResult -> {
                        scala.collection.immutable.Set set;
                        Option option = rebalanceEvent;
                        if (option instanceof Some) {
                            set = currentAssigned;
                        } else if (None$.MODULE$.equals(option)) {
                            set = newlyAssigned;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        scala.collection.immutable.Set startingTps = set;
                        return Tuple2$.MODULE$.apply(revokeResult, (Object)startingTps);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:318)").flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 != null) {
                            RevokeResult revokeResult = (RevokeResult)tuple2._1();
                            scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)tuple2._2();
                            return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$6$$anonfun$1(requestedPartitions, polledRecords))).map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return Runloop$PollResult$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)startingTps, revokeResult.pendingRequests(), revokeResult.assignedStreams(), (ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)ignoreRecordsForTps);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                        }
                        throw new MatchError((Object)tuple2);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                }
                if (rebalanceEvent2 instanceof RebalanceEvent.Assigned) {
                    RebalanceEvent.Assigned assigned = Runloop$RebalanceEvent$Assigned$.MODULE$.unapply((RebalanceEvent.Assigned)rebalanceEvent2);
                    scala.collection.immutable.Set<TopicPartition> set = assigned._1();
                    zIO = this.endRevokedPartitions(state$5.pendingRequests(), state$5.assignedStreams(), (Function1<TopicPartition, Object>)(Function1 & Serializable)_$13 -> true);
                    return zIO.map((Function1 & Serializable)revokeResult -> {
                        scala.collection.immutable.Set set;
                        Option option = rebalanceEvent;
                        if (option instanceof Some) {
                            set = currentAssigned;
                        } else if (None$.MODULE$.equals(option)) {
                            set = newlyAssigned;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        scala.collection.immutable.Set startingTps = set;
                        return Tuple2$.MODULE$.apply(revokeResult, (Object)startingTps);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:318)").flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 != null) {
                            RevokeResult revokeResult = (RevokeResult)tuple2._1();
                            scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)tuple2._2();
                            return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$6$$anonfun$1(requestedPartitions, polledRecords))).map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return Runloop$PollResult$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)startingTps, revokeResult.pendingRequests(), revokeResult.assignedStreams(), (ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)ignoreRecordsForTps);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                        }
                        throw new MatchError((Object)tuple2);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                }
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            zIO = this.endRevokedPartitions(state$5.pendingRequests(), state$5.assignedStreams(), (Function1<TopicPartition, Object>)(Function1 & Serializable)tp -> !currentAssigned.contains(tp));
            return zIO.map((Function1 & Serializable)revokeResult -> {
                scala.collection.immutable.Set set;
                Option option = rebalanceEvent;
                if (option instanceof Some) {
                    set = currentAssigned;
                } else if (None$.MODULE$.equals(option)) {
                    set = newlyAssigned;
                } else {
                    throw new MatchError((Object)option);
                }
                scala.collection.immutable.Set startingTps = set;
                return Tuple2$.MODULE$.apply(revokeResult, (Object)startingTps);
            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:318)").flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    RevokeResult revokeResult = (RevokeResult)tuple2._1();
                    scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)tuple2._2();
                    return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$6$$anonfun$1(requestedPartitions, polledRecords))).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Runloop$PollResult$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)startingTps, revokeResult.pendingRequests(), revokeResult.assignedStreams(), (ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)ignoreRecordsForTps);
                    }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:335)");
    }

    private static final String handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1(PollResult pollResult$2) {
        return new StringBuilder(30).append("Offering partition assignment ").append(pollResult$2.startingTps()).toString();
    }

    private final ZIO handlePoll$$anonfun$2$$anonfun$1$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$2(Chunk newStreams$1) {
        return this.partitionsQueue().offer((Object)new Take(Take$.MODULE$.chunk(Chunk$.MODULE$.fromIterable((Iterable)newStreams$1.map((Function1 & Serializable)_$14 -> _$14.tpStream())))), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:345)");
    }

    private static final State handleCommand$$anonfun$2(State state$16, RunloopCommand.Commit cmd$4) {
        return state$16.addCommit(cmd$4);
    }

    private static final String handleCommand$$anonfun$6() {
        return "Stop all streams initiated";
    }

    private static final Iterable handleCommand$$anonfun$7$$anonfun$1(State state$19) {
        return state$19.assignedStreams();
    }

    private static final String handleCommand$$anonfun$7$$anonfun$3$$anonfun$1$$anonfun$1() {
        return "Stop all streams done";
    }

    private static final /* synthetic */ ZIO handleCommand$$anonfun$7$$anonfun$3$$anonfun$1(State state$21, boolean x$12) {
        boolean bl = x$12;
        return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$7$$anonfun$3$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:395)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return state$21.copy((Chunk<RunloopCommand.Request>)Chunk$.MODULE$.empty(), state$21.copy$default$2(), state$21.copy$default$3(), state$21.copy$default$4());
        }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:396)");
    }

    private static final Chunk handleChangeSubscription$$anonfun$1$$anonfun$2() {
        return Chunk$.MODULE$.empty();
    }

    private static final Chunk handleChangeSubscription$$anonfun$1$$anonfun$4() {
        return Chunk$.MODULE$.empty();
    }

    private static final Chunk handleChangeSubscription$$anonfun$1$$anonfun$6() {
        return Chunk$.MODULE$.empty();
    }

    private static final /* synthetic */ Chunk handleChangeSubscription$$anonfun$1$$anonfun$8$$anonfun$1$$anonfun$2$$anonfun$2(Chunk partitionStreams$1, boolean x$1) {
        boolean bl = x$1;
        return partitionStreams$1;
    }

    private final Dequeue run$$anonfun$1() {
        return this.commandQueue;
    }

    private static final int run$$anonfun$2() {
        return ZStream$.MODULE$.fromQueue$default$2();
    }

    private static final Throwable run$$anonfun$3() {
        return Consumer$RunloopTimeout$.MODULE$;
    }

    private static final String run$$anonfun$5$$anonfun$1(Chunk commands$1) {
        return new StringBuilder(22).append("Processing ").append(commands$1.size()).append(" commands: ").append(commands$1.mkString(",")).toString();
    }

    private static final Iterable run$$anonfun$5$$anonfun$3$$anonfun$1(Chunk streamCommands$1) {
        return streamCommands$1;
    }

    private static final State run$$anonfun$5$$anonfun$3$$anonfun$2(State state$24) {
        return state$24;
    }

    private static final String run$$anonfun$6$$anonfun$1() {
        return "Error in Runloop";
    }

    private static final Cause run$$anonfun$6$$anonfun$2(Cause cause$1) {
        return cause$1;
    }

    public static final class FulfillResult
    implements Product,
    Serializable {
        private final Chunk pendingRequests;

        public static FulfillResult apply(Chunk<RunloopCommand.Request> chunk) {
            return Runloop$FulfillResult$.MODULE$.apply(chunk);
        }

        public static FulfillResult fromProduct(Product product) {
            return Runloop$FulfillResult$.MODULE$.fromProduct(product);
        }

        public static FulfillResult unapply(FulfillResult fulfillResult) {
            return Runloop$FulfillResult$.MODULE$.unapply(fulfillResult);
        }

        public FulfillResult(Chunk<RunloopCommand.Request> pendingRequests) {
            this.pendingRequests = pendingRequests;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FulfillResult)) return false;
            FulfillResult fulfillResult = (FulfillResult)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = fulfillResult.pendingRequests();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FulfillResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FulfillResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public FulfillResult copy(Chunk<RunloopCommand.Request> pendingRequests) {
            return new FulfillResult(pendingRequests);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }
    }

    public static final class PollResult
    implements Product,
    Serializable {
        private final scala.collection.immutable.Set startingTps;
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;
        private final ConsumerRecords records;
        private final scala.collection.immutable.Set ignoreRecordsForTps;

        public static PollResult apply(scala.collection.immutable.Set<TopicPartition> set, Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2, ConsumerRecords<byte[], byte[]> consumerRecords, scala.collection.immutable.Set<TopicPartition> set2) {
            return Runloop$PollResult$.MODULE$.apply(set, chunk, chunk2, consumerRecords, set2);
        }

        public static PollResult fromProduct(Product product) {
            return Runloop$PollResult$.MODULE$.fromProduct(product);
        }

        public static PollResult unapply(PollResult pollResult) {
            return Runloop$PollResult$.MODULE$.unapply(pollResult);
        }

        public PollResult(scala.collection.immutable.Set<TopicPartition> startingTps, Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, ConsumerRecords<byte[], byte[]> records, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps) {
            this.startingTps = startingTps;
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
            this.records = records;
            this.ignoreRecordsForTps = ignoreRecordsForTps;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PollResult)) return false;
            PollResult pollResult = (PollResult)object;
            scala.collection.immutable.Set<TopicPartition> set = this.startingTps();
            scala.collection.immutable.Set<TopicPartition> set2 = pollResult.startingTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = pollResult.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = pollResult.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 != null) {
                    return false;
                }
            } else if (!chunk3.equals(chunk4)) return false;
            ConsumerRecords<byte[], byte[]> consumerRecords = this.records();
            ConsumerRecords<byte[], byte[]> consumerRecords2 = pollResult.records();
            if (consumerRecords == null) {
                if (consumerRecords2 != null) {
                    return false;
                }
            } else if (!consumerRecords.equals(consumerRecords2)) return false;
            scala.collection.immutable.Set<TopicPartition> set3 = this.ignoreRecordsForTps();
            scala.collection.immutable.Set<TopicPartition> set4 = pollResult.ignoreRecordsForTps();
            if (set3 == null) {
                if (set4 == null) return true;
                return false;
            } else {
                if (!set3.equals(set4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PollResult;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "PollResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "startingTps";
                }
                case 1: {
                    return "pendingRequests";
                }
                case 2: {
                    return "assignedStreams";
                }
                case 3: {
                    return "records";
                }
                case 4: {
                    return "ignoreRecordsForTps";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Set<TopicPartition> startingTps() {
            return this.startingTps;
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public ConsumerRecords<byte[], byte[]> records() {
            return this.records;
        }

        public scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps() {
            return this.ignoreRecordsForTps;
        }

        public PollResult copy(scala.collection.immutable.Set<TopicPartition> startingTps, Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, ConsumerRecords<byte[], byte[]> records, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps) {
            return new PollResult(startingTps, pendingRequests, assignedStreams, records, ignoreRecordsForTps);
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$1() {
            return this.startingTps();
        }

        public Chunk<RunloopCommand.Request> copy$default$2() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$3() {
            return this.assignedStreams();
        }

        public ConsumerRecords<byte[], byte[]> copy$default$4() {
            return this.records();
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$5() {
            return this.ignoreRecordsForTps();
        }

        public scala.collection.immutable.Set<TopicPartition> _1() {
            return this.startingTps();
        }

        public Chunk<RunloopCommand.Request> _2() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _3() {
            return this.assignedStreams();
        }

        public ConsumerRecords<byte[], byte[]> _4() {
            return this.records();
        }

        public scala.collection.immutable.Set<TopicPartition> _5() {
            return this.ignoreRecordsForTps();
        }
    }

    public static interface RebalanceEvent {
        public static int ordinal(RebalanceEvent rebalanceEvent) {
            return Runloop$RebalanceEvent$.MODULE$.ordinal(rebalanceEvent);
        }
    }

    public static final class RevokeResult
    implements Product,
    Serializable {
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;

        public static RevokeResult apply(Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2) {
            return Runloop$RevokeResult$.MODULE$.apply(chunk, chunk2);
        }

        public static RevokeResult fromProduct(Product product) {
            return Runloop$RevokeResult$.MODULE$.fromProduct(product);
        }

        public static RevokeResult unapply(RevokeResult revokeResult) {
            return Runloop$RevokeResult$.MODULE$.unapply(revokeResult);
        }

        public RevokeResult(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokeResult)) return false;
            RevokeResult revokeResult = (RevokeResult)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = revokeResult.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = revokeResult.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 == null) return true;
                return false;
            } else {
                if (!chunk3.equals(chunk4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokeResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokeResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            if (1 == n2) {
                return "assignedStreams";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public RevokeResult copy(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            return new RevokeResult(pendingRequests, assignedStreams);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$2() {
            return this.assignedStreams();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _2() {
            return this.assignedStreams();
        }
    }

    public static final class StreamOps<R, E, A> {
        private final ZStream stream;

        public static <R, E, A> boolean equals$extension(ZStream zStream, Object object) {
            return Runloop$StreamOps$.MODULE$.equals$extension(zStream, object);
        }

        public static <R, E, A> int hashCode$extension(ZStream zStream) {
            return Runloop$StreamOps$.MODULE$.hashCode$extension(zStream);
        }

        public static <R1 extends R, E1, S, R, E, A> ZIO<R1, E1, BoxedUnit> runFoldChunksDiscardZIO$extension(ZStream zStream, S s, Function2<S, Chunk<A>, ZIO<R1, E1, S>> function2) {
            return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(zStream, s, function2);
        }

        public StreamOps(ZStream<R, E, A> stream) {
            this.stream = stream;
        }

        public int hashCode() {
            return Runloop$StreamOps$.MODULE$.hashCode$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream());
        }

        public boolean equals(Object x$0) {
            return Runloop$StreamOps$.MODULE$.equals$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream(), x$0);
        }

        public ZStream<R, E, A> zio$kafka$consumer$internal$Runloop$StreamOps$$stream() {
            return this.stream;
        }

        public <R1 extends R, E1, S> ZIO<R1, E1, BoxedUnit> runFoldChunksDiscardZIO(S s, Function2<S, Chunk<A>, ZIO<R1, E1, S>> f) {
            return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream(), s, f);
        }
    }
}

