/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.kafka.consumer.internal.State$;

public final class State
implements Product,
Serializable {
    private final Chunk pendingRequests;
    private final Chunk pendingCommits;
    private final Chunk assignedStreams;
    private final Option subscription;

    public static State apply(Chunk<RunloopCommand.Request> chunk, Chunk<RunloopCommand.Commit> chunk2, Chunk<PartitionStreamControl> chunk3, Option<Subscription> option) {
        return State$.MODULE$.apply(chunk, chunk2, chunk3, option);
    }

    public static State fromProduct(Product product) {
        return State$.MODULE$.fromProduct(product);
    }

    public static State initial() {
        return State$.MODULE$.initial();
    }

    public static State unapply(State state) {
        return State$.MODULE$.unapply(state);
    }

    public State(Chunk<RunloopCommand.Request> pendingRequests, Chunk<RunloopCommand.Commit> pendingCommits, Chunk<PartitionStreamControl> assignedStreams, Option<Subscription> subscription) {
        this.pendingRequests = pendingRequests;
        this.pendingCommits = pendingCommits;
        this.assignedStreams = assignedStreams;
        this.subscription = subscription;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof State)) return false;
        State state = (State)object;
        Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
        Chunk<RunloopCommand.Request> chunk2 = state.pendingRequests();
        if (chunk == null) {
            if (chunk2 != null) {
                return false;
            }
        } else if (!chunk.equals(chunk2)) return false;
        Chunk<RunloopCommand.Commit> chunk3 = this.pendingCommits();
        Chunk<RunloopCommand.Commit> chunk4 = state.pendingCommits();
        if (chunk3 == null) {
            if (chunk4 != null) {
                return false;
            }
        } else if (!chunk3.equals(chunk4)) return false;
        Chunk<PartitionStreamControl> chunk5 = this.assignedStreams();
        Chunk<PartitionStreamControl> chunk6 = state.assignedStreams();
        if (chunk5 == null) {
            if (chunk6 != null) {
                return false;
            }
        } else if (!chunk5.equals(chunk6)) return false;
        Option<Subscription> option = this.subscription();
        Option<Subscription> option2 = state.subscription();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof State;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "State";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "pendingRequests";
            }
            case 1: {
                return "pendingCommits";
            }
            case 2: {
                return "assignedStreams";
            }
            case 3: {
                return "subscription";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Chunk<RunloopCommand.Request> pendingRequests() {
        return this.pendingRequests;
    }

    public Chunk<RunloopCommand.Commit> pendingCommits() {
        return this.pendingCommits;
    }

    public Chunk<PartitionStreamControl> assignedStreams() {
        return this.assignedStreams;
    }

    public Option<Subscription> subscription() {
        return this.subscription;
    }

    public State addCommit(RunloopCommand.Commit c) {
        Chunk chunk = (Chunk)this.pendingCommits().$colon$plus((Object)c);
        Chunk<RunloopCommand.Request> chunk2 = this.copy$default$1();
        Chunk<PartitionStreamControl> chunk3 = this.copy$default$3();
        Option<Subscription> option = this.copy$default$4();
        return this.copy(chunk2, (Chunk<RunloopCommand.Commit>)chunk, chunk3, option);
    }

    public State addRequest(RunloopCommand.Request r) {
        return this.copy((Chunk<RunloopCommand.Request>)((Chunk)this.pendingRequests().$colon$plus((Object)r)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public boolean isSubscribed() {
        return this.subscription().isDefined();
    }

    public boolean shouldPoll() {
        return this.isSubscribed() && (this.pendingRequests().nonEmpty() || this.pendingCommits().nonEmpty() || this.assignedStreams().isEmpty());
    }

    public State copy(Chunk<RunloopCommand.Request> pendingRequests, Chunk<RunloopCommand.Commit> pendingCommits, Chunk<PartitionStreamControl> assignedStreams, Option<Subscription> subscription) {
        return new State(pendingRequests, pendingCommits, assignedStreams, subscription);
    }

    public Chunk<RunloopCommand.Request> copy$default$1() {
        return this.pendingRequests();
    }

    public Chunk<RunloopCommand.Commit> copy$default$2() {
        return this.pendingCommits();
    }

    public Chunk<PartitionStreamControl> copy$default$3() {
        return this.assignedStreams();
    }

    public Option<Subscription> copy$default$4() {
        return this.subscription();
    }

    public Chunk<RunloopCommand.Request> _1() {
        return this.pendingRequests();
    }

    public Chunk<RunloopCommand.Commit> _2() {
        return this.pendingCommits();
    }

    public Chunk<PartitionStreamControl> _3() {
        return this.assignedStreams();
    }

    public Option<Subscription> _4() {
        return this.subscription();
    }
}

