/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Dequeue;
import zio.IsSubtypeOfError$;
import zio.IsSubtypeOfOutput$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Runtime;
import zio.Scope;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.kafka.producer.Producer$;
import zio.kafka.producer.Producer$Live$;
import zio.kafka.producer.ProducerSettings;
import zio.kafka.serde.Serializer;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;
import zio.stream.ZStream$;

public interface Producer {
    public static ZLayer<ProducerSettings, Throwable, Producer> live() {
        return Producer$.MODULE$.live();
    }

    public static ZIO<Scope, Throwable, Producer> make(ProducerSettings producerSettings) {
        return Producer$.MODULE$.make(producerSettings);
    }

    public static <R, A> ZIO<R, Throwable, A> withProducerService(Function1<Producer, ZIO<R, Throwable, A>> function1) {
        return Producer$.MODULE$.withProducerService(function1);
    }

    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(ProducerRecord<K, V> var1, Serializer<R, K> var2, Serializer<R, V> var3);

    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(String var1, K var2, V var3, Serializer<R, K> var4, Serializer<R, V> var5);

    public static ZPipeline produceAll$(Producer $this, Serializer keySerializer, Serializer valueSerializer) {
        return $this.produceAll(keySerializer, valueSerializer);
    }

    default public <R, K, V> ZPipeline<R, Throwable, ProducerRecord<K, V>, RecordMetadata> produceAll(Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return ZPipeline$.MODULE$.mapChunksZIO((Function1 & Serializable)records -> this.produceChunk((Chunk)records, keySerializer, valueSerializer), (Object)"zio.kafka.producer.Producer.produceAll(Producer.scala:45)");
    }

    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(ProducerRecord<K, V> var1, Serializer<R, K> var2, Serializer<R, V> var3);

    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(String var1, K var2, V var3, Serializer<R, K> var4, Serializer<R, V> var5);

    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, Chunk<RecordMetadata>>> produceChunkAsync(Chunk<ProducerRecord<K, V>> var1, Serializer<R, K> var2, Serializer<R, V> var3);

    public <R, K, V> ZIO<R, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<K, V>> var1, Serializer<R, K> var2, Serializer<R, V> var3);

    public ZIO<Object, Throwable, BoxedUnit> flush();

    public ZIO<Object, Throwable, Map<MetricName, Metric>> metrics();

    public static final class Live
    implements Producer,
    Product,
    Serializable {
        private final org.apache.kafka.clients.producer.Producer p;
        private final ProducerSettings producerSettings;
        private final Runtime runtime;
        private final Queue sendQueue;
        private final ZIO sendFromQueue;

        public static Live apply(org.apache.kafka.clients.producer.Producer<byte[], byte[]> producer, ProducerSettings producerSettings, Runtime<Object> runtime, Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> queue) {
            return Producer$Live$.MODULE$.apply(producer, producerSettings, runtime, queue);
        }

        public static Live fromProduct(Product product) {
            return Producer$Live$.MODULE$.fromProduct(product);
        }

        public static Live unapply(Live live) {
            return Producer$Live$.MODULE$.unapply(live);
        }

        public Live(org.apache.kafka.clients.producer.Producer<byte[], byte[]> p, ProducerSettings producerSettings, Runtime<Object> runtime, Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> sendQueue) {
            this.p = p;
            this.producerSettings = producerSettings;
            this.runtime = runtime;
            this.sendQueue = sendQueue;
            this.sendFromQueue = ZStream$.MODULE$.fromQueueWithShutdown(() -> this.$init$$$anonfun$4(sendQueue), this::$init$$$anonfun$5, (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:159)").mapZIO((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Chunk serializedRecords = (Chunk)tuple2._1();
                    Promise done = (Promise)tuple2._2();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$3 -> {
                        Iterator it = serializedRecords.iterator().zipWithIndex();
                        RecordMetadata[] res = new RecordMetadata[serializedRecords.length()];
                        AtomicLong count = new AtomicLong();
                        int length = serializedRecords.length();
                        while (it.hasNext()) {
                            Tuple2 tuple2 = (Tuple2)it.next();
                            if (!(tuple2 instanceof Tuple2)) {
                                throw new MatchError((Object)tuple2);
                            }
                            Tuple2 tuple22 = tuple2;
                            ProducerRecord rec = (ProducerRecord)tuple22._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple22._2());
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)rec, (Object)BoxesRunTime.boxToInteger((int)idx));
                            ProducerRecord rec2 = (ProducerRecord)tuple23._1();
                            int idx2 = BoxesRunTime.unboxToInt((Object)tuple23._2());
                            p.send(rec2, (metadata, err) -> Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> Producer$.MODULE$.zio$kafka$producer$Producer$$$exec((Function0 & Serializable)() -> {
                                this.$init$$$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(runtime, done, res, count, length, idx2, metadata, err, (Unsafe)u);
                                return BoxedUnit.UNIT;
                            })));
                        }
                    }, (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:191)").foldCauseZIO((Function1 & Serializable)e -> done.failCause(e, (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:192)"), (Function1 & Serializable)_$3 -> ZIO$.MODULE$.unit(), (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:192)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:193)").runDrain((Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:194)");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Live)) return false;
            Live live = (Live)object;
            org.apache.kafka.clients.producer.Producer<byte[], byte[]> producer = this.p();
            org.apache.kafka.clients.producer.Producer<byte[], byte[]> producer2 = live.p();
            if (producer == null) {
                if (producer2 != null) {
                    return false;
                }
            } else if (!producer.equals(producer2)) return false;
            ProducerSettings producerSettings = this.producerSettings();
            ProducerSettings producerSettings2 = live.producerSettings();
            if (producerSettings == null) {
                if (producerSettings2 != null) {
                    return false;
                }
            } else if (!((Object)producerSettings).equals(producerSettings2)) return false;
            Runtime<Object> runtime = this.runtime();
            Runtime<Object> runtime2 = live.runtime();
            if (runtime == null) {
                if (runtime2 != null) {
                    return false;
                }
            } else if (!runtime.equals(runtime2)) return false;
            Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> queue = this.sendQueue();
            Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> queue2 = live.sendQueue();
            if (queue == null) {
                if (queue2 == null) return true;
                return false;
            } else {
                if (!queue.equals(queue2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Live;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Live";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "p";
                }
                case 1: {
                    return "producerSettings";
                }
                case 2: {
                    return "runtime";
                }
                case 3: {
                    return "sendQueue";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public org.apache.kafka.clients.producer.Producer<byte[], byte[]> p() {
            return this.p;
        }

        public ProducerSettings producerSettings() {
            return this.producerSettings;
        }

        public Runtime<Object> runtime() {
            return this.runtime;
        }

        public Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> sendQueue() {
            return this.sendQueue;
        }

        @Override
        public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(ProducerRecord<K, V> record, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            return Promise$.MODULE$.make((Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:134)").flatMap((Function1 & Serializable)done -> this.serialize(record, keySerializer, valueSerializer).flatMap((Function1 & Serializable)serializedRecord -> this.sendQueue().offer((Object)Tuple2$.MODULE$.apply((Object)Chunk$.MODULE$.single(serializedRecord), done), (Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:136)").map((Function1 & Serializable)x$1 -> this.produceAsync$$anonfun$1$$anonfun$1$$anonfun$1((Promise)done, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:137)"), (Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:137)"), (Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:137)");
        }

        @Override
        public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, Chunk<RecordMetadata>>> produceChunkAsync(Chunk<ProducerRecord<K, V>> records, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            if (records.isEmpty()) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> Chunk$.MODULE$.empty(), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:144)"), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:144)");
            }
            return Promise$.MODULE$.make((Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:147)").flatMap((Function1 & Serializable)done -> ZIO$.MODULE$.foreach((Iterable)records, (Function1 & Serializable)_$2 -> this.serialize((ProducerRecord)_$2, keySerializer, valueSerializer), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:148)").flatMap((Function1 & Serializable)serializedRecords -> this.sendQueue().offer((Object)Tuple2$.MODULE$.apply(serializedRecords, done), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:149)").map((Function1 & Serializable)x$1 -> this.produceChunkAsync$$anonfun$2$$anonfun$2$$anonfun$1((Promise)done, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:150)"), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:150)"), (Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:150)");
        }

        public ZIO<Object, Nothing$, Object> sendFromQueue() {
            return this.sendFromQueue;
        }

        @Override
        public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(ProducerRecord<K, V> record, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            return this.produceAsync(record, keySerializer, valueSerializer).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.Producer.Live.produce(Producer.scala:201)");
        }

        @Override
        public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            return this.produce(new ProducerRecord(topic, key, value), keySerializer, valueSerializer);
        }

        @Override
        public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            return this.produceAsync(new ProducerRecord(topic, key, value), keySerializer, valueSerializer);
        }

        @Override
        public <R, K, V> ZIO<R, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<K, V>> records, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            return this.produceChunkAsync(records, keySerializer, valueSerializer).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.Producer.Live.produceChunk(Producer.scala:226)");
        }

        @Override
        public ZIO<Object, Throwable, BoxedUnit> flush() {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$4 -> this.p().flush(), (Object)"zio.kafka.producer.Producer.Live.flush(Producer.scala:228)");
        }

        @Override
        public ZIO<Object, Throwable, Map<MetricName, Metric>> metrics() {
            return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$5 -> CollectionConverters$.MODULE$.MapHasAsScala(this.p().metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.Producer.Live.metrics(Producer.scala:230)");
        }

        private <R, K, V> ZIO<R, Throwable, ProducerRecord<byte[], byte[]>> serialize(ProducerRecord<K, V> r, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
            return keySerializer.serialize(r.topic(), r.headers(), r.key()).flatMap((Function1 & Serializable)key -> valueSerializer.serialize(r.topic(), r.headers(), r.value()).map((Function1 & Serializable)value -> new ProducerRecord(r.topic(), r.partition(), r.timestamp(), key, value, (java.lang.Iterable)r.headers()), (Object)"zio.kafka.producer.Producer.Live.serialize(Producer.scala:240)"), (Object)"zio.kafka.producer.Producer.Live.serialize(Producer.scala:240)");
        }

        public ZIO<Object, Nothing$, BoxedUnit> close() {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$6 -> this.p().close(this.producerSettings().closeTimeout()), (Object)"zio.kafka.producer.Producer.Live.close(Producer.scala:242)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.Producer.Live.close(Producer.scala:242)");
        }

        public Live copy(org.apache.kafka.clients.producer.Producer<byte[], byte[]> p, ProducerSettings producerSettings, Runtime<Object> runtime, Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> sendQueue) {
            return new Live(p, producerSettings, runtime, sendQueue);
        }

        public org.apache.kafka.clients.producer.Producer<byte[], byte[]> copy$default$1() {
            return this.p();
        }

        public ProducerSettings copy$default$2() {
            return this.producerSettings();
        }

        public Runtime<Object> copy$default$3() {
            return this.runtime();
        }

        public Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> copy$default$4() {
            return this.sendQueue();
        }

        public org.apache.kafka.clients.producer.Producer<byte[], byte[]> _1() {
            return this.p();
        }

        public ProducerSettings _2() {
            return this.producerSettings();
        }

        public Runtime<Object> _3() {
            return this.runtime();
        }

        public Queue<Tuple2<Chunk<ProducerRecord<byte[], byte[]>>, Promise<Throwable, Chunk<RecordMetadata>>>> _4() {
            return this.sendQueue();
        }

        private final Dequeue $init$$$anonfun$4(Queue sendQueue$1) {
            return sendQueue$1;
        }

        private final int $init$$$anonfun$5() {
            return ZStream$.MODULE$.fromQueueWithShutdown$default$2();
        }

        private final boolean $init$$$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Runtime runtime$6, Promise done$5, Exception err$3, Unsafe u$2) {
            return BoxesRunTime.unboxToBoolean((Object)runtime$6.unsafe().run(done$5.fail((Object)err$3, (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:177)"), (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:177)", u$2).getOrThrowFiberFailure(u$2));
        }

        private final boolean $init$$$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(Runtime runtime$7, Promise done$6, RecordMetadata[] res$4, Unsafe u$3) {
            return BoxesRunTime.unboxToBoolean((Object)runtime$7.unsafe().run(done$6.succeed((Object)Chunk$.MODULE$.fromArray((Object)res$4), (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:183)"), (Object)"zio.kafka.producer.Producer.Live.sendFromQueue(Producer.scala:183)", u$3).getOrThrowFiberFailure(u$3));
        }

        private final void $init$$$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Runtime runtime$4, Promise done$3, RecordMetadata[] res$2, AtomicLong count$2, int length$2, int idx$2, RecordMetadata metadata$2, Exception err$2, Unsafe u$1) {
            if (err$2 != null) {
                Producer$.MODULE$.zio$kafka$producer$Producer$$$exec(() -> this.$init$$$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(runtime$4, done$3, err$2, u$1));
                return;
            }
            res$2[idx$2] = metadata$2;
            if (count$2.incrementAndGet() == (long)length$2) {
                Producer$.MODULE$.zio$kafka$producer$Producer$$$exec(() -> this.$init$$$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(runtime$4, done$3, res$2, u$1));
                return;
            }
        }

        private final /* synthetic */ ZIO produceAsync$$anonfun$1$$anonfun$1$$anonfun$1(Promise done$9, boolean x$1) {
            boolean bl = x$1;
            return done$9.await((Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:137)").map((Function1 & Serializable)_$1 -> (RecordMetadata)_$1.head(), (Object)"zio.kafka.producer.Producer.Live.produceAsync(Producer.scala:137)");
        }

        private final /* synthetic */ ZIO produceChunkAsync$$anonfun$2$$anonfun$2$$anonfun$1(Promise done$11, boolean x$1) {
            boolean bl = x$1;
            return done$11.await((Object)"zio.kafka.producer.Producer.Live.produceChunkAsync(Producer.scala:150)");
        }
    }
}

