/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.OffsetBatch;
import zio.kafka.producer.Producer;
import zio.kafka.producer.Transaction;
import zio.kafka.producer.TransactionalProducer;
import zio.kafka.producer.TransactionalProducer$TransactionLeaked$;
import zio.kafka.producer.TransactionalProducer$UserInitiatedAbort$;
import zio.kafka.serde.Serializer;

public final class TransactionImpl
implements Transaction {
    private final Producer producer;
    private final Ref offsetBatchRef;
    private final Ref closed;

    public TransactionImpl(Producer producer, Ref<OffsetBatch> offsetBatchRef, Ref<Object> closed) {
        this.producer = producer;
        this.offsetBatchRef = offsetBatchRef;
        this.closed = closed;
    }

    private Producer producer() {
        return this.producer;
    }

    public Ref<OffsetBatch> offsetBatchRef() {
        return this.offsetBatchRef;
    }

    private Ref<Object> closed() {
        return this.closed;
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer, Option<Offset> offset) {
        return this.produce(new ProducerRecord(topic, key, value), keySerializer, valueSerializer, offset);
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(ProducerRecord<K, V> producerRecord, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer, Option<Offset> offset) {
        return this.haltIfClosed().$times$greater(() -> this.produce$$anonfun$1(offset), (Object)"zio.kafka.producer.TransactionImpl.produce(Transaction.scala:65)").$times$greater(() -> this.produce$$anonfun$2(producerRecord, keySerializer, valueSerializer), (Object)"zio.kafka.producer.TransactionImpl.produce(Transaction.scala:66)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<K, V>> records, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer, Option<Offset> offset) {
        return this.haltIfClosed().$times$greater(() -> this.produceChunk$$anonfun$1(offset), (Object)"zio.kafka.producer.TransactionImpl.produceChunk(Transaction.scala:75)").$times$greater(() -> this.produceChunk$$anonfun$2(records, keySerializer, valueSerializer), (Object)"zio.kafka.producer.TransactionImpl.produceChunk(Transaction.scala:76)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, Chunk<RecordMetadata>> produceChunkBatch(Chunk<ProducerRecord<K, V>> records, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer, OffsetBatch offsets) {
        return this.haltIfClosed().$times$greater(() -> this.produceChunkBatch$$anonfun$1(offsets), (Object)"zio.kafka.producer.TransactionImpl.produceChunkBatch(Transaction.scala:85)").$times$greater(() -> this.produceChunkBatch$$anonfun$2(records, keySerializer, valueSerializer), (Object)"zio.kafka.producer.TransactionImpl.produceChunkBatch(Transaction.scala:86)");
    }

    @Override
    public ZIO<Object, TransactionalProducer$UserInitiatedAbort$, Nothing$> abort() {
        return ZIO$.MODULE$.fail(TransactionImpl::abort$$anonfun$1, (Object)"zio.kafka.producer.TransactionImpl.abort(Transaction.scala:89)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> markAsClosed() {
        return this.closed().set((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"zio.kafka.producer.TransactionImpl.markAsClosed(Transaction.scala:91)");
    }

    private ZIO<Object, TransactionalProducer.TransactionLeaked, BoxedUnit> haltIfClosed() {
        return this.offsetBatchRef().get((Object)"zio.kafka.producer.TransactionImpl.haltIfClosed(Transaction.scala:94)").flatMap((Function1 & Serializable)offsetBatch -> ZIO$.MODULE$.fail(() -> TransactionImpl.haltIfClosed$$anonfun$1$$anonfun$1(offsetBatch), (Object)"zio.kafka.producer.TransactionImpl.haltIfClosed(Transaction.scala:95)"), (Object)"zio.kafka.producer.TransactionImpl.haltIfClosed(Transaction.scala:95)").whenZIO(this::haltIfClosed$$anonfun$2, (Object)"zio.kafka.producer.TransactionImpl.haltIfClosed(Transaction.scala:96)").unit((Object)"zio.kafka.producer.TransactionImpl.haltIfClosed(Transaction.scala:97)");
    }

    private static final Option produce$$anonfun$1$$anonfun$1(Option offset$2) {
        return offset$2;
    }

    public static final /* synthetic */ OffsetBatch zio$kafka$producer$TransactionImpl$$anon$1$$_$applyOrElse$$anonfun$1(Offset offset$3, OffsetBatch _$1) {
        return _$1.add(offset$3);
    }

    private final ZIO produce$$anonfun$1(Option offset$1) {
        return ZIO$.MODULE$.whenCase(() -> TransactionImpl.produce$$anonfun$1$$anonfun$1(offset$1), (PartialFunction)new Serializable(this){
            private final /* synthetic */ TransactionImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    Offset offset = (Offset)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    Offset offset = (Offset)((Some)option).value();
                    return this.$outer.offsetBatchRef().update(arg_0 -> TransactionImpl.zio$kafka$producer$TransactionImpl$$anon$1$$_$applyOrElse$$anonfun$1(offset, arg_0), (Object)"zio.kafka.producer.TransactionImpl.produce(Transaction.scala:65)");
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$kafka$producer$TransactionImpl$$anon$1$$_$applyOrElse$$anonfun$1(zio.kafka.consumer.Offset zio.kafka.consumer.OffsetBatch )}, serializedLambda);
            }
        }, (Object)"zio.kafka.producer.TransactionImpl.produce(Transaction.scala:65)");
    }

    private final ZIO produce$$anonfun$2(ProducerRecord producerRecord$1, Serializer keySerializer$1, Serializer valueSerializer$1) {
        return this.producer().produce(producerRecord$1, keySerializer$1, valueSerializer$1);
    }

    private static final Option produceChunk$$anonfun$1$$anonfun$1(Option offset$5) {
        return offset$5;
    }

    public static final /* synthetic */ OffsetBatch zio$kafka$producer$TransactionImpl$$anon$2$$_$applyOrElse$$anonfun$2(Offset offset$6, OffsetBatch _$2) {
        return _$2.add(offset$6);
    }

    private final ZIO produceChunk$$anonfun$1(Option offset$4) {
        return ZIO$.MODULE$.whenCase(() -> TransactionImpl.produceChunk$$anonfun$1$$anonfun$1(offset$4), (PartialFunction)new Serializable(this){
            private final /* synthetic */ TransactionImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    Offset offset = (Offset)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    Offset offset = (Offset)((Some)option).value();
                    return this.$outer.offsetBatchRef().update(arg_0 -> TransactionImpl.zio$kafka$producer$TransactionImpl$$anon$2$$_$applyOrElse$$anonfun$2(offset, arg_0), (Object)"zio.kafka.producer.TransactionImpl.produceChunk(Transaction.scala:75)");
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$kafka$producer$TransactionImpl$$anon$2$$_$applyOrElse$$anonfun$2(zio.kafka.consumer.Offset zio.kafka.consumer.OffsetBatch )}, serializedLambda);
            }
        }, (Object)"zio.kafka.producer.TransactionImpl.produceChunk(Transaction.scala:75)");
    }

    private final ZIO produceChunk$$anonfun$2(Chunk records$1, Serializer keySerializer$2, Serializer valueSerializer$2) {
        return this.producer().produceChunk(records$1, keySerializer$2, valueSerializer$2);
    }

    private final ZIO produceChunkBatch$$anonfun$1(OffsetBatch offsets$1) {
        return this.offsetBatchRef().update((Function1 & Serializable)_$3 -> _$3.merge(offsets$1), (Object)"zio.kafka.producer.TransactionImpl.produceChunkBatch(Transaction.scala:85)");
    }

    private final ZIO produceChunkBatch$$anonfun$2(Chunk records$2, Serializer keySerializer$3, Serializer valueSerializer$3) {
        return this.producer().produceChunk(records$2, keySerializer$3, valueSerializer$3);
    }

    private static final TransactionalProducer$UserInitiatedAbort$ abort$$anonfun$1() {
        return TransactionalProducer$UserInitiatedAbort$.MODULE$;
    }

    private static final TransactionalProducer.TransactionLeaked haltIfClosed$$anonfun$1$$anonfun$1(OffsetBatch offsetBatch$1) {
        return TransactionalProducer$TransactionLeaked$.MODULE$.apply(offsetBatch$1);
    }

    private final ZIO haltIfClosed$$anonfun$2() {
        return this.closed().get((Object)"zio.kafka.producer.TransactionImpl.haltIfClosed(Transaction.scala:96)");
    }
}

