/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Cause;
import zio.Exit;
import zio.IsSubtypeOfError$;
import zio.Ref;
import zio.Ref$;
import zio.Scope;
import zio.Semaphore;
import zio.StackTrace;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.kafka.consumer.OffsetBatch;
import zio.kafka.consumer.OffsetBatch$;
import zio.kafka.producer.Producer;
import zio.kafka.producer.Transaction;
import zio.kafka.producer.TransactionImpl;
import zio.kafka.producer.TransactionalProducer$;
import zio.kafka.producer.TransactionalProducer$LiveTransactionalProducer$;
import zio.kafka.producer.TransactionalProducer$TransactionLeaked$;
import zio.kafka.producer.TransactionalProducer$UserInitiatedAbort$;
import zio.kafka.producer.TransactionalProducerSettings;

public interface TransactionalProducer {
    public static ZLayer<TransactionalProducerSettings, Throwable, TransactionalProducer> live() {
        return TransactionalProducer$.MODULE$.live();
    }

    public static ZIO<Scope, Throwable, TransactionalProducer> make(TransactionalProducerSettings transactionalProducerSettings) {
        return TransactionalProducer$.MODULE$.make(transactionalProducerSettings);
    }

    public ZIO<Scope, Throwable, Transaction> createTransaction();

    public static final class LiveTransactionalProducer
    implements TransactionalProducer,
    Product,
    Serializable {
        private final Producer.Live live;
        private final Semaphore semaphore;
        private final ZIO abortTransaction;

        public static LiveTransactionalProducer apply(Producer.Live live, Semaphore semaphore) {
            return TransactionalProducer$LiveTransactionalProducer$.MODULE$.apply(live, semaphore);
        }

        public static LiveTransactionalProducer fromProduct(Product product) {
            return TransactionalProducer$LiveTransactionalProducer$.MODULE$.fromProduct(product);
        }

        public static LiveTransactionalProducer unapply(LiveTransactionalProducer liveTransactionalProducer) {
            return TransactionalProducer$LiveTransactionalProducer$.MODULE$.unapply(liveTransactionalProducer);
        }

        public LiveTransactionalProducer(Producer.Live live, Semaphore semaphore) {
            this.live = live;
            this.semaphore = semaphore;
            this.abortTransaction = ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$1 -> live.p().abortTransaction(), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.abortTransaction(TransactionalProducer.scala:25)");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LiveTransactionalProducer)) return false;
            LiveTransactionalProducer liveTransactionalProducer = (LiveTransactionalProducer)object;
            Producer.Live live = this.live();
            Producer.Live live2 = liveTransactionalProducer.live();
            if (live == null) {
                if (live2 != null) {
                    return false;
                }
            } else if (!((Object)live).equals(live2)) return false;
            Semaphore semaphore = this.semaphore();
            Semaphore semaphore2 = liveTransactionalProducer.semaphore();
            if (semaphore == null) {
                if (semaphore2 == null) return true;
                return false;
            } else {
                if (!semaphore.equals(semaphore2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LiveTransactionalProducer;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LiveTransactionalProducer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "live";
            }
            if (1 == n2) {
                return "semaphore";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Producer.Live live() {
            return this.live;
        }

        public Semaphore semaphore() {
            return this.semaphore;
        }

        public ZIO<Object, Throwable, BoxedUnit> abortTransaction() {
            return this.abortTransaction;
        }

        public ZIO<Object, Throwable, BoxedUnit> commitTransactionWithOffsets(OffsetBatch offsetBatch) {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$2 -> this.live().p().sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsetBatch.offsets().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    TopicPartition topicPartition2 = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition2, (Object)new OffsetAndMetadata(offset + 1L));
                }
                throw new MatchError((Object)tuple2);
            })).asJava(), (ConsumerGroupMetadata)offsetBatch.consumerGroupMetadata().getOrElse(this::commitTransactionWithOffsets$$anonfun$1$$anonfun$2)), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:40)").unless(() -> this.commitTransactionWithOffsets$$anonfun$2(offsetBatch), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:41)").$times$greater(this::commitTransactionWithOffsets$$anonfun$3, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:42)");
        }

        public ZIO<Object, Nothing$, BoxedUnit> commitOrAbort(TransactionImpl transaction, Exit<Object, Object> exit) {
            Exit<Object, Object> exit2 = exit;
            if (exit2 instanceof Exit.Success) {
                Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit2);
                Object object = success._1();
                return transaction.offsetBatchRef().get((Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:46)").flatMap((Function1 & Serializable)offsetBatch -> this.commitTransactionWithOffsets((OffsetBatch)offsetBatch).retryN(this::commitOrAbort$$anonfun$1$$anonfun$1, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:47)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:47)"), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:47)");
            }
            if (exit2 instanceof Exit.Failure) {
                Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit2);
                Cause cause = failure._1();
                if (cause instanceof Cause.Fail) {
                    Cause.Fail fail = Cause.Fail$.MODULE$.unapply((Cause.Fail)cause);
                    Object object = fail._1();
                    StackTrace stackTrace = fail._2();
                    if (TransactionalProducer$UserInitiatedAbort$.MODULE$.equals(object)) {
                        return this.abortTransaction().retryN(this::commitOrAbort$$anonfun$2, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:48)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:48)");
                    }
                }
                return this.abortTransaction().retryN(this::commitOrAbort$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:49)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitOrAbort(TransactionalProducer.scala:49)");
            }
            throw new MatchError(exit2);
        }

        @Override
        public ZIO<Scope, Throwable, Transaction> createTransaction() {
            return this.semaphore().withPermitScoped((Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:53)").$times$greater(this::createTransaction$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:61)");
        }

        public LiveTransactionalProducer copy(Producer.Live live, Semaphore semaphore) {
            return new LiveTransactionalProducer(live, semaphore);
        }

        public Producer.Live copy$default$1() {
            return this.live();
        }

        public Semaphore copy$default$2() {
            return this.semaphore();
        }

        public Producer.Live _1() {
            return this.live();
        }

        public Semaphore _2() {
            return this.semaphore();
        }

        private final ConsumerGroupMetadata commitTransactionWithOffsets$$anonfun$1$$anonfun$2() {
            throw new InvalidGroupIdException("To use the group management or offset commit APIs, you must provide a valid group.id in the consumer configuration.");
        }

        private final boolean commitTransactionWithOffsets$$anonfun$2(OffsetBatch offsetBatch$2) {
            return offsetBatch$2.offsets().isEmpty();
        }

        private final ZIO commitTransactionWithOffsets$$anonfun$3() {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$3 -> this.live().p().commitTransaction(), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.commitTransactionWithOffsets(TransactionalProducer.scala:42)");
        }

        private final int commitOrAbort$$anonfun$1$$anonfun$1() {
            return 5;
        }

        private final int commitOrAbort$$anonfun$2() {
            return 5;
        }

        private final int commitOrAbort$$anonfun$3() {
            return 5;
        }

        private final OffsetBatch createTransaction$$anonfun$1$$anonfun$1$$anonfun$1() {
            return OffsetBatch$.MODULE$.empty();
        }

        private final boolean createTransaction$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
            return false;
        }

        private final ZIO createTransaction$$anonfun$1$$anonfun$1() {
            return Ref$.MODULE$.make(this::createTransaction$$anonfun$1$$anonfun$1$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:56)").flatMap((Function1 & Serializable)offsetBatchRef -> Ref$.MODULE$.make(this::createTransaction$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:57)").flatMap((Function1 & Serializable)closedRef -> ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$4 -> this.live().p().beginTransaction(), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:58)").map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return new TransactionImpl(this.live(), (Ref<OffsetBatch>)offsetBatchRef, (Ref<Object>)closedRef);
            }, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:59)"), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:59)"), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:59)");
        }

        private final ZIO createTransaction$$anonfun$1$$anonfun$2$$anonfun$1(TransactionImpl transaction$1, Exit exit$1) {
            return this.commitOrAbort(transaction$1, (Exit<Object, Object>)exit$1);
        }

        private final ZIO createTransaction$$anonfun$1() {
            return ZIO$.MODULE$.acquireReleaseExit(this::createTransaction$$anonfun$1$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
                TransactionImpl transactionImpl;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null && (transactionImpl = (TransactionImpl)tuple2._1()) != null) {
                    TransactionImpl transaction = transactionImpl;
                    Exit exit = (Exit)tuple2._2();
                    return transaction.markAsClosed().$times$greater(() -> this.createTransaction$$anonfun$1$$anonfun$2$$anonfun$1(transaction, exit), (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:60)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.producer.TransactionalProducer.LiveTransactionalProducer.createTransaction(TransactionalProducer.scala:60)");
        }
    }

    public static final class TransactionLeaked
    extends Throwable
    implements Product {
        private final OffsetBatch offsetBatch;

        public static TransactionLeaked apply(OffsetBatch offsetBatch) {
            return TransactionalProducer$TransactionLeaked$.MODULE$.apply(offsetBatch);
        }

        public static TransactionLeaked fromProduct(Product product) {
            return TransactionalProducer$TransactionLeaked$.MODULE$.fromProduct(product);
        }

        public static TransactionLeaked unapply(TransactionLeaked transactionLeaked) {
            return TransactionalProducer$TransactionLeaked$.MODULE$.unapply(transactionLeaked);
        }

        public TransactionLeaked(OffsetBatch offsetBatch) {
            this.offsetBatch = offsetBatch;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TransactionLeaked)) return false;
            TransactionLeaked transactionLeaked = (TransactionLeaked)object;
            OffsetBatch offsetBatch = this.offsetBatch();
            OffsetBatch offsetBatch2 = transactionLeaked.offsetBatch();
            if (offsetBatch != null) {
                if (!offsetBatch.equals(offsetBatch2)) return false;
                return true;
            }
            if (offsetBatch2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof TransactionLeaked;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TransactionLeaked";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offsetBatch";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OffsetBatch offsetBatch() {
            return this.offsetBatch;
        }

        public TransactionLeaked copy(OffsetBatch offsetBatch) {
            return new TransactionLeaked(offsetBatch);
        }

        public OffsetBatch copy$default$1() {
            return this.offsetBatch();
        }

        public OffsetBatch _1() {
            return this.offsetBatch();
        }
    }
}

