/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer;

import java.io.Serializable;
import java.time.Duration;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.DurationSyntax$;
import zio.ZIO;
import zio.kafka.consumer.Consumer;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Auto$;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Manual$;
import zio.kafka.consumer.ConsumerSettings$;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.fetch.FetchStrategy;
import zio.kafka.consumer.fetch.QueueSizeBasedFetchStrategy;
import zio.kafka.consumer.fetch.QueueSizeBasedFetchStrategy$;
import zio.kafka.security.KafkaCredentialStore;
import zio.package$;

public final class ConsumerSettings
implements Product,
Serializable {
    private final Map properties;
    private final Duration closeTimeout;
    private final Duration pollTimeout;
    private final Duration commitTimeout;
    private final Consumer.OffsetRetrieval offsetRetrieval;
    private final RebalanceListener rebalanceListener;
    private final boolean restartStreamOnRebalancing;
    private final boolean rebalanceSafeCommits;
    private final Option maxRebalanceDuration;
    private final FetchStrategy fetchStrategy;

    public static ConsumerSettings apply(List<String> list) {
        return ConsumerSettings$.MODULE$.apply(list);
    }

    public static ConsumerSettings apply(Map<String, Object> map, Duration duration, Duration duration2, Duration duration3, Consumer.OffsetRetrieval offsetRetrieval, RebalanceListener rebalanceListener, boolean bl, boolean bl2, Option<Duration> option, FetchStrategy fetchStrategy) {
        return ConsumerSettings$.MODULE$.apply(map, duration, duration2, duration3, offsetRetrieval, rebalanceListener, bl, bl2, option, fetchStrategy);
    }

    public static Duration defaultCommitTimeout() {
        return ConsumerSettings$.MODULE$.defaultCommitTimeout();
    }

    public static ConsumerSettings fromProduct(Product product) {
        return ConsumerSettings$.MODULE$.fromProduct(product);
    }

    public static ConsumerSettings unapply(ConsumerSettings consumerSettings) {
        return ConsumerSettings$.MODULE$.unapply(consumerSettings);
    }

    public static Map<String, Object> $lessinit$greater$default$1() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$1();
    }

    public static Duration $lessinit$greater$default$2() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$2();
    }

    public static Duration $lessinit$greater$default$3() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$3();
    }

    public static Duration $lessinit$greater$default$4() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$4();
    }

    public static Consumer.OffsetRetrieval $lessinit$greater$default$5() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$5();
    }

    public static RebalanceListener $lessinit$greater$default$6() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$8() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Duration> $lessinit$greater$default$9() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$9();
    }

    public static FetchStrategy $lessinit$greater$default$10() {
        return ConsumerSettings$.MODULE$.$lessinit$greater$default$10();
    }

    public ConsumerSettings(Map<String, Object> properties, Duration closeTimeout, Duration pollTimeout, Duration commitTimeout, Consumer.OffsetRetrieval offsetRetrieval, RebalanceListener rebalanceListener, boolean restartStreamOnRebalancing, boolean rebalanceSafeCommits, Option<Duration> maxRebalanceDuration, FetchStrategy fetchStrategy) {
        this.properties = properties;
        this.closeTimeout = closeTimeout;
        this.pollTimeout = pollTimeout;
        this.commitTimeout = commitTimeout;
        this.offsetRetrieval = offsetRetrieval;
        this.rebalanceListener = rebalanceListener;
        this.restartStreamOnRebalancing = restartStreamOnRebalancing;
        this.rebalanceSafeCommits = rebalanceSafeCommits;
        this.maxRebalanceDuration = maxRebalanceDuration;
        this.fetchStrategy = fetchStrategy;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pollTimeout()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commitTimeout()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.offsetRetrieval()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rebalanceListener()));
        n = Statics.mix((int)n, (int)(this.restartStreamOnRebalancing() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.rebalanceSafeCommits() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxRebalanceDuration()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fetchStrategy()));
        return Statics.finalizeHash((int)n, (int)10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConsumerSettings)) return false;
        ConsumerSettings consumerSettings = (ConsumerSettings)object;
        if (this.restartStreamOnRebalancing() != consumerSettings.restartStreamOnRebalancing()) return false;
        if (this.rebalanceSafeCommits() != consumerSettings.rebalanceSafeCommits()) return false;
        Map<String, Object> map = this.properties();
        Map<String, Object> map2 = consumerSettings.properties();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Duration duration = this.closeTimeout();
        Duration duration2 = consumerSettings.closeTimeout();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!((Object)duration).equals(duration2)) return false;
        Duration duration3 = this.pollTimeout();
        Duration duration4 = consumerSettings.pollTimeout();
        if (duration3 == null) {
            if (duration4 != null) {
                return false;
            }
        } else if (!((Object)duration3).equals(duration4)) return false;
        Duration duration5 = this.commitTimeout();
        Duration duration6 = consumerSettings.commitTimeout();
        if (duration5 == null) {
            if (duration6 != null) {
                return false;
            }
        } else if (!((Object)duration5).equals(duration6)) return false;
        Consumer.OffsetRetrieval offsetRetrieval = this.offsetRetrieval();
        Consumer.OffsetRetrieval offsetRetrieval2 = consumerSettings.offsetRetrieval();
        if (offsetRetrieval == null) {
            if (offsetRetrieval2 != null) {
                return false;
            }
        } else if (!offsetRetrieval.equals(offsetRetrieval2)) return false;
        RebalanceListener rebalanceListener = this.rebalanceListener();
        RebalanceListener rebalanceListener2 = consumerSettings.rebalanceListener();
        if (rebalanceListener == null) {
            if (rebalanceListener2 != null) {
                return false;
            }
        } else if (!((Object)rebalanceListener).equals(rebalanceListener2)) return false;
        Option<Duration> option = this.maxRebalanceDuration();
        Option<Duration> option2 = consumerSettings.maxRebalanceDuration();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        FetchStrategy fetchStrategy = this.fetchStrategy();
        FetchStrategy fetchStrategy2 = consumerSettings.fetchStrategy();
        if (fetchStrategy == null) {
            if (fetchStrategy2 == null) return true;
            return false;
        } else {
            if (!fetchStrategy.equals(fetchStrategy2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ConsumerSettings;
    }

    public int productArity() {
        return 10;
    }

    public String productPrefix() {
        return "ConsumerSettings";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this._7());
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this._8());
            }
            case 8: {
                return this._9();
            }
            case 9: {
                return this._10();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "properties";
            }
            case 1: {
                return "closeTimeout";
            }
            case 2: {
                return "pollTimeout";
            }
            case 3: {
                return "commitTimeout";
            }
            case 4: {
                return "offsetRetrieval";
            }
            case 5: {
                return "rebalanceListener";
            }
            case 6: {
                return "restartStreamOnRebalancing";
            }
            case 7: {
                return "rebalanceSafeCommits";
            }
            case 8: {
                return "maxRebalanceDuration";
            }
            case 9: {
                return "fetchStrategy";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    public Duration pollTimeout() {
        return this.pollTimeout;
    }

    public Duration commitTimeout() {
        return this.commitTimeout;
    }

    public Consumer.OffsetRetrieval offsetRetrieval() {
        return this.offsetRetrieval;
    }

    public RebalanceListener rebalanceListener() {
        return this.rebalanceListener;
    }

    public boolean restartStreamOnRebalancing() {
        return this.restartStreamOnRebalancing;
    }

    public boolean rebalanceSafeCommits() {
        return this.rebalanceSafeCommits;
    }

    public Option<Duration> maxRebalanceDuration() {
        return this.maxRebalanceDuration;
    }

    public FetchStrategy fetchStrategy() {
        return this.fetchStrategy;
    }

    public ConsumerSettings tuneForHighThroughput() {
        return this.withPollTimeout(DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationInt(500))).withMaxPollRecords(2000).withFetchStrategy(QueueSizeBasedFetchStrategy$.MODULE$.apply(4096));
    }

    public ConsumerSettings tuneForLowLatency() {
        return this.withPollTimeout(DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationInt(50))).withMaxPollRecords(100).withFetchStrategy(QueueSizeBasedFetchStrategy$.MODULE$.apply(512));
    }

    public Map<String, Object> driverSettings() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"enable.auto.commit");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"false");
        return (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus(this.properties());
    }

    public ConsumerSettings withBootstrapServers(List<String> servers) {
        return this.withProperty("bootstrap.servers", servers.mkString(","));
    }

    public ConsumerSettings withCloseTimeout(Duration timeout) {
        return this.copy(this.copy$default$1(), timeout, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withCommitTimeout(Duration timeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), timeout, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withClientId(String clientId) {
        return this.withProperty("client.id", clientId);
    }

    public ConsumerSettings withGroupId(String groupId) {
        return this.withProperty("group.id", groupId);
    }

    public boolean hasGroupId() {
        return this.properties().contains((Object)"group.id");
    }

    public ConsumerSettings withGroupInstanceId(String groupInstanceId) {
        return this.withProperty("group.instance.id", groupInstanceId);
    }

    public ConsumerSettings withOffsetRetrieval(Consumer.OffsetRetrieval retrieval) {
        Consumer.AutoOffsetStrategy autoOffsetStrategy;
        Consumer.OffsetRetrieval offsetRetrieval = retrieval;
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Auto) {
            Consumer.AutoOffsetStrategy autoOffsetStrategy2;
            Consumer.AutoOffsetStrategy reset;
            Consumer.OffsetRetrieval.Auto auto = Consumer$OffsetRetrieval$Auto$.MODULE$.unapply((Consumer.OffsetRetrieval.Auto)offsetRetrieval);
            autoOffsetStrategy = reset = (autoOffsetStrategy2 = auto._1());
        } else if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Manual) {
            Consumer.AutoOffsetStrategy autoOffsetStrategy3;
            Consumer.AutoOffsetStrategy defaultStrategy;
            Consumer.OffsetRetrieval.Manual manual = Consumer$OffsetRetrieval$Manual$.MODULE$.unapply((Consumer.OffsetRetrieval.Manual)offsetRetrieval);
            Function1<Set<TopicPartition>, ZIO<Object, Throwable, Map<TopicPartition, Object>>> function1 = manual._1();
            autoOffsetStrategy = defaultStrategy = (autoOffsetStrategy3 = manual._2());
        } else {
            throw new MatchError((Object)offsetRetrieval);
        }
        Consumer.AutoOffsetStrategy resetStrategy = autoOffsetStrategy;
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), retrieval, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10()).withProperty("auto.offset.reset", resetStrategy.toConfig());
    }

    public ConsumerSettings withPollTimeout(Duration timeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), timeout, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withMaxPollInterval(Duration maxPollInterval) {
        return this.withProperty("max.poll.interval.ms", BoxesRunTime.boxToLong((long)maxPollInterval.toMillis()).toString());
    }

    public ConsumerSettings withMaxPollRecords(int maxPollRecords) {
        return this.withProperty("max.poll.records", BoxesRunTime.boxToInteger((int)maxPollRecords).toString());
    }

    public ConsumerSettings withProperty(String key, Object value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        return this.copy((Map<String, Object>)((Map)this.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value))), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withProperties(Seq<Tuple2<String, Object>> kvs) {
        return this.withProperties((Map<String, Object>)kvs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ConsumerSettings withProperties(Map<String, Object> kvs) {
        return this.copy((Map<String, Object>)((Map)this.properties().$plus$plus(kvs)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withRebalanceListener(RebalanceListener listener) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), listener, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withRestartStreamOnRebalancing(boolean value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), value, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withRebalanceSafeCommits(boolean value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), value, this.copy$default$9(), this.copy$default$10());
    }

    public ConsumerSettings withMaxRebalanceDuration(Duration value) {
        Some some = Some$.MODULE$.apply((Object)value);
        Map<String, Object> map = this.copy$default$1();
        Duration duration = this.copy$default$2();
        Duration duration2 = this.copy$default$3();
        Duration duration3 = this.copy$default$4();
        Consumer.OffsetRetrieval offsetRetrieval = this.copy$default$5();
        RebalanceListener rebalanceListener = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        FetchStrategy fetchStrategy = this.copy$default$10();
        return this.copy(map, duration, duration2, duration3, offsetRetrieval, rebalanceListener, bl, bl2, (Option<Duration>)some, fetchStrategy);
    }

    public ConsumerSettings withCredentials(KafkaCredentialStore credentialsStore) {
        return this.withProperties(credentialsStore.properties());
    }

    public ConsumerSettings withPartitionPreFetchBufferLimit(int partitionPreFetchBufferLimit) {
        QueueSizeBasedFetchStrategy queueSizeBasedFetchStrategy = QueueSizeBasedFetchStrategy$.MODULE$.apply(partitionPreFetchBufferLimit);
        Map<String, Object> map = this.copy$default$1();
        Duration duration = this.copy$default$2();
        Duration duration2 = this.copy$default$3();
        Duration duration3 = this.copy$default$4();
        Consumer.OffsetRetrieval offsetRetrieval = this.copy$default$5();
        RebalanceListener rebalanceListener = this.copy$default$6();
        boolean bl = this.copy$default$7();
        boolean bl2 = this.copy$default$8();
        Option<Duration> option = this.copy$default$9();
        return this.copy(map, duration, duration2, duration3, offsetRetrieval, rebalanceListener, bl, bl2, option, queueSizeBasedFetchStrategy);
    }

    public ConsumerSettings withoutPartitionPreFetching() {
        return this.withPartitionPreFetchBufferLimit(0);
    }

    public ConsumerSettings withMaxPartitionQueueSize(int partitionPreFetchBufferLimit) {
        return this.withPartitionPreFetchBufferLimit(partitionPreFetchBufferLimit);
    }

    public ConsumerSettings withFetchStrategy(FetchStrategy fetchStrategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), fetchStrategy);
    }

    public ConsumerSettings copy(Map<String, Object> properties, Duration closeTimeout, Duration pollTimeout, Duration commitTimeout, Consumer.OffsetRetrieval offsetRetrieval, RebalanceListener rebalanceListener, boolean restartStreamOnRebalancing, boolean rebalanceSafeCommits, Option<Duration> maxRebalanceDuration, FetchStrategy fetchStrategy) {
        return new ConsumerSettings(properties, closeTimeout, pollTimeout, commitTimeout, offsetRetrieval, rebalanceListener, restartStreamOnRebalancing, rebalanceSafeCommits, maxRebalanceDuration, fetchStrategy);
    }

    public Map<String, Object> copy$default$1() {
        return this.properties();
    }

    public Duration copy$default$2() {
        return this.closeTimeout();
    }

    public Duration copy$default$3() {
        return this.pollTimeout();
    }

    public Duration copy$default$4() {
        return this.commitTimeout();
    }

    public Consumer.OffsetRetrieval copy$default$5() {
        return this.offsetRetrieval();
    }

    public RebalanceListener copy$default$6() {
        return this.rebalanceListener();
    }

    public boolean copy$default$7() {
        return this.restartStreamOnRebalancing();
    }

    public boolean copy$default$8() {
        return this.rebalanceSafeCommits();
    }

    public Option<Duration> copy$default$9() {
        return this.maxRebalanceDuration();
    }

    public FetchStrategy copy$default$10() {
        return this.fetchStrategy();
    }

    public Map<String, Object> _1() {
        return this.properties();
    }

    public Duration _2() {
        return this.closeTimeout();
    }

    public Duration _3() {
        return this.pollTimeout();
    }

    public Duration _4() {
        return this.commitTimeout();
    }

    public Consumer.OffsetRetrieval _5() {
        return this.offsetRetrieval();
    }

    public RebalanceListener _6() {
        return this.rebalanceListener();
    }

    public boolean _7() {
        return this.restartStreamOnRebalancing();
    }

    public boolean _8() {
        return this.rebalanceSafeCommits();
    }

    public Option<Duration> _9() {
        return this.maxRebalanceDuration();
    }

    public FetchStrategy _10() {
        return this.fetchStrategy();
    }
}

