/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.time.Duration;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NoStackTrace;
import zio.Chunk;
import zio.Clock$;
import zio.Exit;
import zio.IsSubtypeOfOutput$;
import zio.LogAnnotation;
import zio.LogAnnotation$;
import zio.Promise;
import zio.Queue;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.PartitionStream;
import zio.kafka.consumer.internal.PartitionStreamControl$;
import zio.kafka.consumer.internal.PartitionStreamControl$QueueInfo$;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;

public final class PartitionStreamControl
extends PartitionStream {
    private final TopicPartition tp;
    private final Queue<Exit> dataQueue;
    private final Promise<Throwable, BoxedUnit> interruptionPromise;
    private final Promise completedPromise;
    private final Ref<QueueInfo> queueInfoRef;
    private final Duration maxPollInterval;
    private final long maxPollIntervalNanos;
    private final ZIO.LogAnnotate logAnnotate;
    private final Tuple2 tpStream;

    public static ZIO<Object, Nothing$, PartitionStreamControl> newPartitionStream(TopicPartition topicPartition, Queue<RunloopCommand> queue, Diagnostics diagnostics, Duration duration) {
        return PartitionStreamControl$.MODULE$.newPartitionStream(topicPartition, queue, diagnostics, duration);
    }

    public PartitionStreamControl(TopicPartition tp, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>> stream, Queue<Exit> dataQueue, Promise<Throwable, BoxedUnit> interruptionPromise, Promise<Nothing$, Option<Offset>> completedPromise, Ref<QueueInfo> queueInfoRef, Duration maxPollInterval) {
        this.tp = tp;
        this.dataQueue = dataQueue;
        this.interruptionPromise = interruptionPromise;
        this.completedPromise = completedPromise;
        this.queueInfoRef = queueInfoRef;
        this.maxPollInterval = maxPollInterval;
        this.maxPollIntervalNanos = maxPollInterval.toNanos();
        this.logAnnotate = ZIO$.MODULE$.logAnnotate(() -> PartitionStreamControl.$init$$$anonfun$1(tp), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogAnnotation[]{LogAnnotation$.MODULE$.apply("partition", BoxesRunTime.boxToInteger((int)tp.partition()).toString())}));
        this.tpStream = Tuple2$.MODULE$.apply((Object)tp, stream);
    }

    @Override
    public TopicPartition tp() {
        return this.tp;
    }

    public Promise<Nothing$, Option<Offset>> completedPromise() {
        return this.completedPromise;
    }

    public ZIO<Object, Nothing$, BoxedUnit> offerRecords(Chunk<CommittableRecord<byte[], byte[]>> data) {
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:56)").map((Function1 & Serializable)now -> this.offerRecords$$anonfun$1(BoxesRunTime.unboxToLong((Object)now)), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:57)").flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                long now = tuple2._1$mcJ$sp();
                long newPullDeadline = tuple2._2$mcJ$sp();
                return this.queueInfoRef.update((Function1 & Serializable)_$1 -> _$1.withOffer(newPullDeadline, data.size()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:58)").flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.dataQueue.offer((Object)new Take(Take$.MODULE$.chunk(data)), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:59)").map((Function1 & Serializable)v1 -> {
                        bl = BoxesRunTime.unboxToBoolean((Object)v1);
                        return BoxedUnit.UNIT;
                    }, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:60)");
                }, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:60)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.offerRecords(PartitionStreamControl.scala:60)");
    }

    @Override
    public ZIO<Object, Nothing$, Object> queueSize() {
        return this.queueInfoRef.get((Object)"zio.kafka.consumer.internal.PartitionStreamControl.queueSize(PartitionStreamControl.scala:62)").map((Function1 & Serializable)_$2 -> _$2.size(), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.queueSize(PartitionStreamControl.scala:62)");
    }

    public ZIO<Object, Nothing$, Object> maxPollIntervalExceeded(long now) {
        return this.queueInfoRef.get((Object)"zio.kafka.consumer.internal.PartitionStreamControl.maxPollIntervalExceeded(PartitionStreamControl.scala:72)").map((Function1 & Serializable)_$3 -> _$3.deadlineExceeded(now), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.maxPollIntervalExceeded(PartitionStreamControl.scala:72)");
    }

    public ZIO<Object, Nothing$, Object> lost() {
        NoStackTrace lostException = new NoStackTrace(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new StringBuilder(19).append("Partition ").append($outer.tp().toString()).append(" was lost").toString());
                NoStackTrace.$init$((NoStackTrace)this);
            }

            public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }
        };
        return this.interruptionPromise.fail((Object)lostException, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.lost(PartitionStreamControl.scala:77)");
    }

    public ZIO<Object, Nothing$, Object> halt() {
        String timeOutMessage = new StringBuilder(175).append("No records were polled for more than ").append(this.maxPollInterval).append(" for topic partition ").append(this.tp()).append(". ").append("Use ConsumerSettings.withMaxPollInterval to set a longer interval if processing a batch of records ").append("needs more time.").toString();
        NoStackTrace consumeTimeout = new NoStackTrace(timeOutMessage){
            {
                NoStackTrace.$init$((NoStackTrace)this);
            }

            public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }
        };
        return this.interruptionPromise.fail((Object)consumeTimeout, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.halt(PartitionStreamControl.scala:86)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> end() {
        return this.logAnnotate.apply(ZIO$.MODULE$.logDebug(this::end$$anonfun$1, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:92)").$times$greater(this::end$$anonfun$2, (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:93)"), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:94)");
    }

    public ZIO<Object, Nothing$, Object> isCompleted() {
        return this.completedPromise().isDone((Object)"zio.kafka.consumer.internal.PartitionStreamControl.isCompleted(PartitionStreamControl.scala:98)");
    }

    public ZIO<Object, Nothing$, Object> isRunning() {
        return this.isCompleted().negate(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.isRunning(PartitionStreamControl.scala:102)");
    }

    public Tuple2<TopicPartition, ZStream<Object, Throwable, CommittableRecord<byte[], byte[]>>> tpStream() {
        return this.tpStream;
    }

    private static final LogAnnotation $init$$$anonfun$1(TopicPartition tp$1) {
        return LogAnnotation$.MODULE$.apply("topic", tp$1.topic());
    }

    private final /* synthetic */ Tuple2 offerRecords$$anonfun$1(long now) {
        long newPullDeadline = now + this.maxPollIntervalNanos;
        return new Tuple2.mcJJ.sp(now, newPullDeadline);
    }

    private final String end$$anonfun$1() {
        return new StringBuilder(17).append("Partition ").append(this.tp().toString()).append(" ending").toString();
    }

    private final ZIO end$$anonfun$2() {
        return this.dataQueue.offer((Object)new Take(Take$.MODULE$.end()), (Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:93)").unit((Object)"zio.kafka.consumer.internal.PartitionStreamControl.end(PartitionStreamControl.scala:93)");
    }

    public static final class QueueInfo
    implements Product,
    Serializable {
        private final long pullDeadline;
        private final int size;
        private final Option lastPulledOffset;

        public static QueueInfo apply(long l, int n, Option<Offset> option) {
            return PartitionStreamControl$QueueInfo$.MODULE$.apply(l, n, option);
        }

        public static QueueInfo fromProduct(Product product) {
            return PartitionStreamControl$QueueInfo$.MODULE$.fromProduct(product);
        }

        public static QueueInfo unapply(QueueInfo queueInfo) {
            return PartitionStreamControl$QueueInfo$.MODULE$.unapply(queueInfo);
        }

        public QueueInfo(long pullDeadline, int size, Option<Offset> lastPulledOffset) {
            this.pullDeadline = pullDeadline;
            this.size = size;
            this.lastPulledOffset = lastPulledOffset;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.pullDeadline()));
            n = Statics.mix((int)n, (int)this.size());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastPulledOffset()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueueInfo)) return false;
            QueueInfo queueInfo = (QueueInfo)object;
            if (this.size() != queueInfo.size()) return false;
            if (this.pullDeadline() != queueInfo.pullDeadline()) return false;
            Option<Offset> option = this.lastPulledOffset();
            Option<Offset> option2 = queueInfo.lastPulledOffset();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueueInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "QueueInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pullDeadline";
                }
                case 1: {
                    return "size";
                }
                case 2: {
                    return "lastPulledOffset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long pullDeadline() {
            return this.pullDeadline;
        }

        public int size() {
            return this.size;
        }

        public Option<Offset> lastPulledOffset() {
            return this.lastPulledOffset;
        }

        public QueueInfo withOffer(long newPullDeadline, int recordCount) {
            return PartitionStreamControl$QueueInfo$.MODULE$.apply(this.size() <= 0 ? newPullDeadline : this.pullDeadline(), this.size() + recordCount, this.lastPulledOffset());
        }

        public QueueInfo withPull(long newPullDeadline, Chunk<CommittableRecord<byte[], byte[]>> records) {
            return PartitionStreamControl$QueueInfo$.MODULE$.apply(newPullDeadline, this.size() - records.size(), (Option<Offset>)records.lastOption().map((Function1 & Serializable)_$5 -> _$5.offset()).orElse(this::withPull$$anonfun$2));
        }

        public boolean deadlineExceeded(long now) {
            return this.size() > 0 && this.pullDeadline() <= now;
        }

        public QueueInfo copy(long pullDeadline, int size, Option<Offset> lastPulledOffset) {
            return new QueueInfo(pullDeadline, size, lastPulledOffset);
        }

        public long copy$default$1() {
            return this.pullDeadline();
        }

        public int copy$default$2() {
            return this.size();
        }

        public Option<Offset> copy$default$3() {
            return this.lastPulledOffset();
        }

        public long _1() {
            return this.pullDeadline();
        }

        public int _2() {
            return this.size();
        }

        public Option<Offset> _3() {
            return this.lastPulledOffset();
        }

        private final Option withPull$$anonfun$2() {
            return this.lastPulledOffset();
        }
    }
}

