/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.utils;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestHeader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.DurationSyntax$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.utils.SslHelper;
import zio.kafka.utils.SslHelper$ConnectionError$;
import zio.kafka.utils.SslHelper$ZIOTypeOps$;
import zio.package$;

public final class SslHelper$
implements Serializable {
    private static final SslHelper$ConnectionError$ ConnectionError;
    private static final SslHelper$ZIOTypeOps$ ZIOTypeOps;
    public static final SslHelper$ MODULE$;

    private SslHelper$() {
    }

    static {
        MODULE$ = new SslHelper$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SslHelper$.class);
    }

    public ZIO<Object, KafkaException, BoxedUnit> validateEndpoint(Map<String, Object> props) {
        return this.doValidateEndpoint((Function1<InetSocketAddress, SocketChannel>)(Function1 & Serializable)x$0 -> SocketChannel.open(x$0), props);
    }

    public ZIO<Object, KafkaException, BoxedUnit> doValidateEndpoint(Function1<InetSocketAddress, SocketChannel> unsafeOpenSocket, Map<String, Object> props) {
        List list;
        Option option = props.get((Object)"bootstrap.servers");
        if (option instanceof Some) {
            Object config = ((Some)option).value();
            list = Predef$.MODULE$.wrapRefArray((Object[])config.toString().split(",")).toList();
        } else if (None$.MODULE$.equals(option)) {
            list = scala.package$.MODULE$.List().empty();
        } else {
            throw new MatchError((Object)option);
        }
        List bootstrapServers = list;
        if (bootstrapServers.isEmpty()) {
            return ZIO$.MODULE$.fail(this::doValidateEndpoint$$anonfun$1, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:64)");
        }
        return ZIO$.MODULE$.unless(() -> this.doValidateEndpoint$$anonfun$2(props), () -> this.doValidateEndpoint$$anonfun$3(unsafeOpenSocket, props, bootstrapServers), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:99)").unit((Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:100)").mapError((Function1 & Serializable)e -> this.kafkaException((Throwable)e), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:101)");
    }

    private KafkaException kafkaException(Throwable e) {
        return new KafkaException("Failed to create new KafkaAdminClient", e);
    }

    private ZIO<Object, Throwable, BoxedUnit> validateSslConfigOf(Function1<InetSocketAddress, SocketChannel> unsafeOpenSocket, Duration socketTimeout, InetSocketAddress address) {
        return ZIO$.MODULE$.attemptBlockingInterrupt(() -> this.validateSslConfigOf$$anonfun$1(unsafeOpenSocket, address), (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf(SslHelper.scala:196)").timeoutFail(() -> this.validateSslConfigOf$$anonfun$2(address), () -> this.validateSslConfigOf$$anonfun$3(socketTimeout), (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf(SslHelper.scala:197)").flatMap((Function1 & Serializable)isTLS -> this.validateSslConfigOf$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)isTLS)), (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf(SslHelper.scala:198)");
    }

    private void unsafeSendTestRequest(SocketChannel channel) {
        TransferableChannel transferableChannel = new TransferableChannel(channel){
            private final SocketChannel channel$1;
            {
                this.channel$1 = channel$2;
            }

            public boolean hasPendingWrites() {
                return false;
            }

            public long transferFrom(FileChannel fileChannel, long position, long count) {
                throw new UnsupportedOperationException();
            }

            public long write(ByteBuffer[] srcs, int offset, int length) {
                return this.channel$1.write(srcs, offset, length);
            }

            public long write(ByteBuffer[] srcs) {
                return this.channel$1.write(srcs);
            }

            public int write(ByteBuffer src) {
                return this.channel$1.write(src);
            }

            public boolean isOpen() {
                return this.channel$1.isOpen();
            }

            public void close() {
                this.channel$1.close();
            }
        };
        Send send = new ApiVersionsRequest.Builder().build(ApiKeys.API_VERSIONS.latestVersion()).toSend(new RequestHeader(ApiKeys.API_VERSIONS, ApiKeys.API_VERSIONS.latestVersion(), null, 0));
        send.writeTo(transferableChannel);
    }

    private ByteBuffer unsafeReadAnswerFromTestRequest(SocketChannel channel) {
        ByteBuffer buf = ByteBuffer.allocate(5);
        channel.read(buf);
        buf.position(0);
        return buf;
    }

    private boolean isTls(ByteBuffer buf) {
        byte tlsMessageType;
        byte by = tlsMessageType = buf.get();
        switch (by) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 255: {
                return true;
            }
        }
        return tlsMessageType >= 128;
    }

    private final ZIO$ ZIOTypeOps(ZIO$ dummy) {
        return dummy;
    }

    private final Duration request$u002Etimeout$u002Ems$1(Map props$1) {
        Duration defaultValue = DurationSyntax$.MODULE$.seconds$extension(package$.MODULE$.durationInt(30));
        Option option = props$1.get((Object)"request.timeout.ms");
        if (None$.MODULE$.equals(option)) {
            return defaultValue;
        }
        if (option instanceof Some) {
            Duration duration;
            Object raw = ((Some)option).value();
            try {
                long v = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(raw.toString()));
                duration = v <= 0L ? defaultValue : DurationSyntax$.MODULE$.millis$extension(package$.MODULE$.durationLong(v));
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option2.get();
                    duration = defaultValue;
                }
                throw throwable;
            }
            return duration;
        }
        throw new MatchError((Object)option);
    }

    private final KafkaException doValidateEndpoint$$anonfun$1() {
        return this.kafkaException(new IllegalArgumentException("Empty bootstrapServers list"));
    }

    private final boolean doValidateEndpoint$$anonfun$2(Map props$2) {
        return props$2.get((Object)"security.protocol").exists((Function1 & Serializable)x$1 -> {
            String x;
            Object object = x$1;
            return object instanceof String && (x = (String)object).toUpperCase().contains("SSL");
        });
    }

    private final Throwable doValidateEndpoint$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2(Throwable head$1) {
        return head$1;
    }

    private final Throwable doValidateEndpoint$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$3(Throwable head$2) {
        return ((SslHelper.ConnectionError)head$2).cause();
    }

    private final ZIO doValidateEndpoint$$anonfun$3$$anonfun$1(Function1 unsafeOpenSocket$2, Map props$4, List bootstrapServers$2) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> CollectionConverters$.MODULE$.ListHasAsScala(ClientUtils.parseAndValidateAddresses((java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bootstrapServers$2).asJava(), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS)).asScala().toList(), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:82)").flatMap((Function1 & Serializable)addresses -> {
            Duration duration = this.request$u002Etimeout$u002Ems$1(props$4);
            return SslHelper$ZIOTypeOps$.MODULE$.collectAllFailuresPar$extension(this.ZIOTypeOps(ZIO$.MODULE$), addresses.map((Function1 & Serializable)address -> this.validateSslConfigOf((Function1<InetSocketAddress, SocketChannel>)unsafeOpenSocket$2, duration, (InetSocketAddress)address)), BuildFrom$.MODULE$.buildFromIterableOps(), "zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:85)").map((Function1 & Serializable)errors -> {
                boolean atLeastOneBootstrapServerIsUp = errors.size() < addresses.size();
                return Tuple2$.MODULE$.apply(errors, (Object)BoxesRunTime.boxToBoolean((boolean)atLeastOneBootstrapServerIsUp));
            }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:86)").flatMap((Function1 & Serializable)x$12 -> {
                ZIO zIO;
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                List errors = (List)tuple2._1();
                boolean atLeastOneBootstrapServerIsUp = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                Tuple2 tuple22 = errors.partition((Function1 & Serializable)_$1 -> _$1 instanceof SslHelper.ConnectionError);
                if (tuple22 != null) {
                    List list = (List)tuple22._2();
                    if (list instanceof .colon.colon) {
                        List list2 = ((.colon.colon)list).next$access$1();
                        Throwable head = (Throwable)((.colon.colon)list).head();
                        zIO = ZIO$.MODULE$.fail(() -> this.doValidateEndpoint$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2(head), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:89)");
                        return zIO.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:97)");
                    }
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    Object object = tuple22._1();
                    if (!(nil$ != null ? !nil$.equals(object) : object != null)) {
                        Nil$ nil$2 = scala.package$.MODULE$.Nil();
                        List list3 = list;
                        if (!(nil$2 != null ? !nil$2.equals(list3) : list3 != null)) {
                            zIO = ZIO$.MODULE$.unit();
                            return zIO.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:97)");
                        }
                    }
                }
                if (atLeastOneBootstrapServerIsUp) {
                    zIO = ZIO$.MODULE$.unit();
                    return zIO.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:97)");
                }
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                List list = (List)tuple22._1();
                if (!(list instanceof .colon.colon)) throw new MatchError((Object)tuple22);
                List list4 = ((.colon.colon)list).next$access$1();
                Throwable head = (Throwable)((.colon.colon)list).head();
                zIO = ZIO$.MODULE$.fail(() -> this.doValidateEndpoint$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$3(head), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:95)");
                return zIO.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:97)");
            }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:97)");
        }, (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:97)");
    }

    private final ZIO doValidateEndpoint$$anonfun$3(Function1 unsafeOpenSocket$1, Map props$3, List bootstrapServers$1) {
        return ZIO$.MODULE$.blocking(() -> this.doValidateEndpoint$$anonfun$3$$anonfun$1(unsafeOpenSocket$1, props$3, bootstrapServers$1), (Object)"zio.kafka.utils.SslHelper.doValidateEndpoint(SslHelper.scala:98)");
    }

    private final IllegalArgumentException unexpectedSslPacketError$1$$anonfun$1() {
        return new IllegalArgumentException("Received an unexpected SSL packet from the server. Please ensure the client is properly configured with SSL enabled");
    }

    private final ZIO unexpectedSslPacketError$1() {
        return ZIO$.MODULE$.fail(this::unexpectedSslPacketError$1$$anonfun$1, (Object)"zio.kafka.utils.SslHelper.validateSslConfigOf.unexpectedSslPacketError(SslHelper.scala:175)");
    }

    private final SslHelper.ConnectionError timeoutException$1(InetSocketAddress address$1) {
        return SslHelper$ConnectionError$.MODULE$.apply(new TimeoutException(new StringBuilder(18).append("Failed to contact ").append(address$1).toString()));
    }

    private final boolean validateSslConfigOf$$anonfun$1(Function1 unsafeOpenSocket$5, InetSocketAddress address$2) {
        boolean bl;
        SocketChannel socketChannel;
        try {
            socketChannel = (SocketChannel)unsafeOpenSocket$5.apply((Object)address$2);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw SslHelper$ConnectionError$.MODULE$.apply(e);
            }
            throw throwable;
        }
        try (SocketChannel channel = socketChannel;){
            this.unsafeSendTestRequest(channel);
            ByteBuffer buffer = this.unsafeReadAnswerFromTestRequest(channel);
            bl = this.isTls(buffer);
        }
        return bl;
    }

    private final Throwable validateSslConfigOf$$anonfun$2(InetSocketAddress address$3) {
        return this.timeoutException$1(address$3);
    }

    private final Duration validateSslConfigOf$$anonfun$3(Duration socketTimeout$2) {
        return socketTimeout$2;
    }

    private final /* synthetic */ ZIO validateSslConfigOf$$anonfun$4(boolean isTLS) {
        if (isTLS) {
            return this.unexpectedSslPacketError$1();
        }
        return ZIO$.MODULE$.unit();
    }
}

