/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.NotGiven$;
import scala.util.matching.Regex;
import zio.CanFail$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.Clock$;
import zio.Dequeue;
import zio.DurationSyntax$;
import zio.Executor;
import zio.Exit;
import zio.Exit$;
import zio.Hub;
import zio.IsSubtypeOfError$;
import zio.IsSubtypeOfOutput$;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Ref;
import zio.Runtime;
import zio.Schedule;
import zio.Scope;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.CommittableRecord;
import zio.kafka.consumer.CommittableRecord$;
import zio.kafka.consumer.Consumer;
import zio.kafka.consumer.Consumer$CommitTimeout$;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Auto$;
import zio.kafka.consumer.Consumer$OffsetRetrieval$Manual$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.InvalidSubscriptionUnion;
import zio.kafka.consumer.InvalidSubscriptionUnion$;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.RebalanceListener$;
import zio.kafka.consumer.Subscription;
import zio.kafka.consumer.Subscription$;
import zio.kafka.consumer.Subscription$Manual$;
import zio.kafka.consumer.Subscription$Pattern$;
import zio.kafka.consumer.Subscription$Topics$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Failure$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Started$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$Success$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Poll$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Rebalance$;
import zio.kafka.consumer.diagnostics.Diagnostics;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.PartitionStreamControl$;
import zio.kafka.consumer.internal.Runloop$;
import zio.kafka.consumer.internal.Runloop$Commit$;
import zio.kafka.consumer.internal.Runloop$CommitOffsets$;
import zio.kafka.consumer.internal.Runloop$FulfillResult$;
import zio.kafka.consumer.internal.Runloop$PollResult$;
import zio.kafka.consumer.internal.Runloop$RebalanceEvent$;
import zio.kafka.consumer.internal.Runloop$RevokeResult$;
import zio.kafka.consumer.internal.Runloop$State$;
import zio.kafka.consumer.internal.Runloop$StreamOps$;
import zio.kafka.consumer.internal.RunloopCommand;
import zio.kafka.consumer.internal.RunloopCommand$AddSubscription$;
import zio.kafka.consumer.internal.RunloopCommand$CommitAvailable$;
import zio.kafka.consumer.internal.RunloopCommand$Poll$;
import zio.kafka.consumer.internal.RunloopCommand$RemoveAllSubscriptions$;
import zio.kafka.consumer.internal.RunloopCommand$RemoveSubscription$;
import zio.kafka.consumer.internal.RunloopCommand$StopAllStreams$;
import zio.kafka.consumer.internal.RunloopCommand$StopRunloop$;
import zio.kafka.consumer.internal.SubscriptionState;
import zio.kafka.consumer.internal.SubscriptionState$NotSubscribed$;
import zio.kafka.consumer.internal.SubscriptionState$Subscribed$;
import zio.kafka.consumer.internal.ZioConsumerMetrics;
import zio.kafka.consumer.internal.package$;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Runloop {
    private final ConsumerSettings settings;
    private final Executor topLevelExecutor;
    public final Runtime<Object> zio$kafka$consumer$internal$Runloop$$sameThreadRuntime;
    private final ConsumerAccess consumer;
    private final Duration maxPollInterval;
    private final Queue<Commit> commitQueue;
    private final Queue<RunloopCommand> commandQueue;
    private final Ref.Synchronized<RebalanceEvent> lastRebalanceEvent;
    private final Hub<Exit> partitionsHub;
    private final Diagnostics diagnostics;
    private final Duration maxRebalanceDuration;
    private final Ref<State> currentStateRef;
    private final Ref<CommitOffsets> committedOffsetsRef;
    private final Duration commitTimeout;
    private final long commitTimeoutNanos;
    private final boolean restartStreamsOnRebalancing;
    private final boolean rebalanceSafeCommits;
    private final ZioConsumerMetrics consumerMetrics;
    private final Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commit;
    private final ZIO<Object, Nothing$, Option<ConsumerGroupMetadata>> getConsumerGroupMetadataIfAny;

    public static ZIO<Scope, Nothing$, Runloop> make(ConsumerSettings consumerSettings, Duration duration, Duration duration2, Diagnostics diagnostics, ConsumerAccess consumerAccess, Hub<Exit> hub) {
        return Runloop$.MODULE$.make(consumerSettings, duration, duration2, diagnostics, consumerAccess, hub);
    }

    public Runloop(ConsumerSettings settings, Executor topLevelExecutor, Runtime<Object> sameThreadRuntime, ConsumerAccess consumer, Duration maxPollInterval, Queue<Commit> commitQueue, Queue<RunloopCommand> commandQueue, Ref.Synchronized<RebalanceEvent> lastRebalanceEvent, Hub<Exit> partitionsHub, Diagnostics diagnostics, Duration maxRebalanceDuration, Ref<State> currentStateRef, Ref<CommitOffsets> committedOffsetsRef) {
        this.settings = settings;
        this.topLevelExecutor = topLevelExecutor;
        this.zio$kafka$consumer$internal$Runloop$$sameThreadRuntime = sameThreadRuntime;
        this.consumer = consumer;
        this.maxPollInterval = maxPollInterval;
        this.commitQueue = commitQueue;
        this.commandQueue = commandQueue;
        this.lastRebalanceEvent = lastRebalanceEvent;
        this.partitionsHub = partitionsHub;
        this.diagnostics = diagnostics;
        this.maxRebalanceDuration = maxRebalanceDuration;
        this.currentStateRef = currentStateRef;
        this.committedOffsetsRef = committedOffsetsRef;
        this.commitTimeout = settings.commitTimeout();
        this.commitTimeoutNanos = settings.commitTimeout().toNanos();
        this.restartStreamsOnRebalancing = settings.restartStreamOnRebalancing();
        this.rebalanceSafeCommits = settings.rebalanceSafeCommits();
        this.consumerMetrics = new ZioConsumerMetrics(settings.metricLabels());
        this.commit = (Function1 & Serializable)offsets -> Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:258)").map((Function1 & Serializable)p -> {
            long startTime = System.nanoTime();
            return Tuple2$.MODULE$.apply(p, (Object)BoxesRunTime.boxToLong((long)startTime));
        }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:259)").flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Promise p = (Promise)tuple2._1();
                long startTime = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return commitQueue.offer((Object)Runloop$Commit$.MODULE$.apply(System.nanoTime(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, (Promise<Throwable, BoxedUnit>)p), (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:260)").flatMap((Function1 & Serializable)x$1 -> this.$init$$$anonfun$1$$anonfun$2$$anonfun$1((Queue)commandQueue, diagnostics, (scala.collection.immutable.Map)offsets, p, startTime, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:267)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:267)");
        this.getConsumerGroupMetadataIfAny = settings.hasGroupId() ? consumer.runloopAccess((Function1 & Serializable)c -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$7 -> c.groupMetadata(), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:413)")).fold((Function1 & Serializable)_$13 -> None$.MODULE$, (Function1 & Serializable)_$14 -> Some$.MODULE$.apply(_$14), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.getConsumerGroupMetadataIfAny(Runloop.scala:413)") : ZIO$.MODULE$.none();
    }

    private ZIO<Object, Nothing$, PartitionStreamControl> newPartitionStream(TopicPartition tp) {
        return PartitionStreamControl$.MODULE$.newPartitionStream(tp, this.commandQueue, this.diagnostics, this.maxPollInterval);
    }

    public ZIO<Object, Nothing$, BoxedUnit> stopConsumption() {
        return ZIO$.MODULE$.logDebug(Runloop::stopConsumption$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:50)").$times$greater(this::stopConsumption$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:51)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> shutdown() {
        return ZIO$.MODULE$.logDebug(Runloop::shutdown$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:54)").$times$greater(this::shutdown$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:63)");
    }

    public ZIO<Object, InvalidSubscriptionUnion, BoxedUnit> addSubscription(Subscription subscription) {
        return ZIO$.MODULE$.logDebug(() -> Runloop.addSubscription$$anonfun$1(subscription), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:67)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Promise$.MODULE$.make((Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:68)").flatMap((Function1 & Serializable)promise -> this.commandQueue.offer((Object)RunloopCommand$AddSubscription$.MODULE$.apply(subscription, (Promise<InvalidSubscriptionUnion, BoxedUnit>)promise), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:69)").flatMap((Function1 & Serializable)x$1 -> Runloop.addSubscription$$anonfun$2$$anonfun$1$$anonfun$1(subscription, promise, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:73)"), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:73)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:73)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> removeSubscription(Subscription subscription) {
        return this.commandQueue.offer((Object)RunloopCommand$RemoveSubscription$.MODULE$.apply(subscription), (Object)"zio.kafka.consumer.internal.Runloop.removeSubscription(Runloop.scala:76)").unit((Object)"zio.kafka.consumer.internal.Runloop.removeSubscription(Runloop.scala:76)");
    }

    private ConsumerRebalanceListener makeRebalanceListener() {
        Duration commitQueuePollInterval = DurationSyntax$.MODULE$.millis$extension(zio.package$.MODULE$.durationInt(100));
        RebalanceListener recordRebalanceRebalancingListener = RebalanceListener$.MODULE$.apply((Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)assignedTps -> this.lastRebalanceEvent.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:206)").flatMap((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug(() -> Runloop.$anonfun$4$$anonfun$1$$anonfun$1(rebalanceEvent, assignedTps), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:210)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.currentStateRef.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:211)").map((Function1 & Serializable)state -> {
                Chunk<PartitionStreamControl> streamsToEnd = this.restartStreamsOnRebalancing && !rebalanceEvent.wasInvoked() ? state.assignedStreams() : Chunk$.MODULE$.empty();
                return Tuple2$.MODULE$.apply(state, streamsToEnd);
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:213)").flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    State state = (State)tuple2._1();
                    Chunk streamsToEnd = (Chunk)tuple2._2();
                    return this.endStreams$1(commitQueuePollInterval, state, streamsToEnd).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.lastRebalanceEvent.set((Object)rebalanceEvent.onAssigned((scala.collection.immutable.Set<TopicPartition>)assignedTps, (Chunk<PartitionStreamControl>)streamsToEnd), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:215)").flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return ZIO$.MODULE$.logTrace(Runloop::$anonfun$4$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:216)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:217)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:217)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:217)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:217)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:217)"), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:217)"), (Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)revokedTps -> this.lastRebalanceEvent.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:220)").flatMap((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug(() -> Runloop.$anonfun$5$$anonfun$1$$anonfun$1(rebalanceEvent, revokedTps), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:224)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.currentStateRef.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:225)").map((Function1 & Serializable)state -> {
                Chunk streamsToEnd = this.restartStreamsOnRebalancing && !rebalanceEvent.wasInvoked() ? state.assignedStreams() : state.assignedStreams().filter((Function1 & Serializable)control -> revokedTps.contains((Object)control.tp()));
                return Tuple2$.MODULE$.apply(state, (Object)streamsToEnd);
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:227)").flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    State state = (State)tuple2._1();
                    Chunk streamsToEnd = (Chunk)tuple2._2();
                    return this.endStreams$1(commitQueuePollInterval, state, streamsToEnd).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.lastRebalanceEvent.set((Object)rebalanceEvent.onRevoked((scala.collection.immutable.Set<TopicPartition>)revokedTps, (Chunk<PartitionStreamControl>)streamsToEnd), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:229)").flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return ZIO$.MODULE$.logTrace(Runloop::$anonfun$5$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:230)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:231)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:231)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:231)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:231)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:231)"), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:231)"), (Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)lostTps -> ZIO$.MODULE$.logDebug(() -> Runloop.$anonfun$7$$anonfun$1(lostTps), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:234)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.lastRebalanceEvent.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:235)").flatMap((Function1 & Serializable)rebalanceEvent -> this.currentStateRef.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:236)").map((Function1 & Serializable)state -> {
                Chunk lostStreams = state.assignedStreams().filter((Function1 & Serializable)control -> lostTps.contains((Object)control.tp()));
                return Tuple2$.MODULE$.apply(state, (Object)lostStreams);
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:237)").flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    State state = (State)tuple2._1();
                    Chunk lostStreams = (Chunk)tuple2._2();
                    return ZIO$.MODULE$.foreachDiscard(() -> Runloop.$anonfun$7$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(lostStreams), (Function1 & Serializable)_$9 -> _$9.lost(), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:238)").flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.lastRebalanceEvent.set((Object)rebalanceEvent.onLost((scala.collection.immutable.Set<TopicPartition>)lostTps), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:239)").flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return ZIO$.MODULE$.logTrace(Runloop::$anonfun$7$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:240)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:241)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:241)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:241)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:241)"), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:241)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.recordRebalanceRebalancingListener(Runloop.scala:241)"));
        RebalanceListener rebalanceListener = this.settings.rebalanceListener();
        RebalanceListener rebalanceListener2 = RebalanceListener$.MODULE$.noop();
        RebalanceListener rebalanceListener3 = rebalanceListener;
        RebalanceListener userRebalanceListener = !(rebalanceListener2 != null ? !((Object)rebalanceListener2).equals(rebalanceListener3) : rebalanceListener3 != null) ? RebalanceListener$.MODULE$.noop() : this.settings.rebalanceListener().runOnExecutor(this.topLevelExecutor);
        return RebalanceListener$.MODULE$.toKafka(recordRebalanceRebalancingListener.$plus$plus(userRebalanceListener), this.zio$kafka$consumer$internal$Runloop$$sameThreadRuntime);
    }

    private Tuple3<java.util.Map<TopicPartition, OffsetAndMetadata>, OffsetCommitCallback, Function1<Throwable, ZIO<Object, Nothing$, BoxedUnit>>> asyncCommitParameters(Chunk<Commit> commits) {
        scala.collection.immutable.Map offsets = ((IterableOnceOps)commits.foldLeft(Map$.MODULE$.empty(), (Function2 & Serializable)(x$12, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                scala.collection.mutable.Map acc = (scala.collection.mutable.Map)tuple2._1();
                Commit commit = (Commit)tuple2._2();
                commit.offsets().foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                        TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                        return (scala.collection.mutable.Map)acc.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, acc.get((Object)tp).map((Function1 & Serializable)current -> {
                            if (current.offset() > offset.offset()) {
                                return current;
                            }
                            return offset;
                        }).getOrElse(() -> Runloop.$anonfun$9$$anonfun$1$$anonfun$2(offset))));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return acc;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map offsetsWithMetaData = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)new OffsetAndMetadata(offset.offset() + 1L, offset.leaderEpoch(), offset.metadata()));
            }
            throw new MatchError((Object)tuple2);
        });
        Function1 & Serializable cont = (Function1 & Serializable)e -> ZIO$.MODULE$.foreachDiscard(() -> Runloop.$anonfun$11$$anonfun$1(commits), (Function1 & Serializable)_$10 -> _$10.cont().done(e, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.cont(Runloop.scala:287)"), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.cont(Runloop.scala:287)");
        long startTime = System.nanoTime();
        long endTime = System.nanoTime();
        Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(zio.package$.MODULE$.durationLong(endTime - startTime));
        ZIO onSuccess = this.committedOffsetsRef.modify((Function1 & Serializable)_$11 -> _$11.addCommits(commits), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onSuccess(Runloop.scala:294)").flatMap((Function1 & Serializable)offsetIncrease -> this.$anonfun$13(latency, commits, cont, offsetsWithMetaData, BoxesRunTime.unboxToLong((Object)offsetIncrease)), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onSuccess(Runloop.scala:298)");
        Function1 & Serializable onFailure = (Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof RebalanceInProgressException) {
                return ZIO$.MODULE$.logDebug(() -> Runloop.$anonfun$14$$anonfun$1(offsets), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:303)").flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.commitQueue.offerAll((Iterable)commits, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:304)").flatMap((Function1 & Serializable)x$1 -> {
                        Chunk chunk = x$1;
                        return this.commandQueue.offer((Object)RunloopCommand$CommitAvailable$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:305)").map((Function1 & Serializable)v1 -> {
                            bl = BoxesRunTime.unboxToBoolean((Object)v1);
                            return BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:306)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:306)");
                }, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:306)");
            }
            if (throwable != null) {
                Throwable err = throwable;
                return ((ZIO)cont.apply((Object)Exit$.MODULE$.fail((Object)err))).$less$times(() -> this.$anonfun$14$$anonfun$3(offsetsWithMetaData, err), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onFailure(Runloop.scala:308)");
            }
            throw new MatchError((Object)throwable);
        };
        OffsetCommitCallback callback = new OffsetCommitCallback(onSuccess, onFailure, this){
            private final ZIO onSuccess$1;
            private final Function1 onFailure$2;
            private final /* synthetic */ Runloop $outer;
            {
                this.onSuccess$1 = onSuccess$2;
                this.onFailure$2 = onFailure$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onComplete(java.util.Map offsets, Exception exception) {
                Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> this.$outer.zio$kafka$consumer$internal$Runloop$$sameThreadRuntime.unsafe().run(exception == null ? this.onSuccess$1 : (ZIO)this.onFailure$2.apply((Object)exception), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.callback.$anon.onComplete(Runloop.scala:316)", u).getOrThrowFiberFailure(u));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onComplete$$anonfun$1(java.lang.Exception zio.Unsafe )}, serializedLambda);
            }
        };
        return Tuple3$.MODULE$.apply((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)offsetsWithMetaData).asJava(), (Object)callback, (Object)onFailure);
    }

    private ZIO<Object, Nothing$, State> handleCommits(State state, Chunk<Commit> commits) {
        if (commits.isEmpty()) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> state, (Object)"zio.kafka.consumer.internal.Runloop.handleCommits(Runloop.scala:325)");
        }
        Tuple3<java.util.Map<TopicPartition, OffsetAndMetadata>, OffsetCommitCallback, Function1<Throwable, ZIO<Object, Nothing$, BoxedUnit>>> tuple3 = this.asyncCommitParameters(commits);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        java.util.Map offsets = (java.util.Map)tuple3._1();
        OffsetCommitCallback callback = (OffsetCommitCallback)tuple3._2();
        Function1 onFailure = (Function1)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)offsets, (Object)callback, (Object)onFailure);
        java.util.Map offsets2 = (java.util.Map)tuple32._1();
        OffsetCommitCallback callback2 = (OffsetCommitCallback)tuple32._2();
        Function1 onFailure2 = (Function1)tuple32._3();
        State newState = state.addPendingCommits(commits);
        return this.consumer.runloopAccess((Function1 & Serializable)c -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$5 -> c.commitAsync(offsets2, callback2), (Object)"zio.kafka.consumer.internal.Runloop.handleCommits(Runloop.scala:332)")).catchAll(onFailure2, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommits(Runloop.scala:334)").as(() -> Runloop.handleCommits$$anonfun$3(newState), (Object)"zio.kafka.consumer.internal.Runloop.handleCommits(Runloop.scala:335)");
    }

    private ZIO<Object, Nothing$, RevokeResult> endRevokedPartitions(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams, Function1<TopicPartition, Object> isRevoked) {
        Tuple2 tuple2 = assignedStreams.partition((Function1 & Serializable)control -> BoxesRunTime.unboxToBoolean((Object)isRevoked.apply((Object)control.tp())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Chunk revokedStreams = (Chunk)tuple2._1();
        Chunk newAssignedStreams = (Chunk)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)revokedStreams, (Object)newAssignedStreams);
        Chunk revokedStreams2 = (Chunk)tuple22._1();
        Chunk newAssignedStreams2 = (Chunk)tuple22._2();
        return ZIO$.MODULE$.foreachDiscard(() -> Runloop.endRevokedPartitions$$anonfun$1(revokedStreams2), (Function1 & Serializable)_$12 -> _$12.end(), (Object)"zio.kafka.consumer.internal.Runloop.endRevokedPartitions(Runloop.scala:353)").as(() -> Runloop.endRevokedPartitions$$anonfun$3(pendingRequests, isRevoked, newAssignedStreams2), (Object)"zio.kafka.consumer.internal.Runloop.endRevokedPartitions(Runloop.scala:359)");
    }

    private ZIO<Object, Nothing$, FulfillResult> offerRecordsToStreams(Chunk<PartitionStreamControl> partitionStreams, Chunk<RunloopCommand.Request> pendingRequests, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, ConsumerRecords<byte[], byte[]> polledRecords) {
        Chunk streams;
        scala.collection.immutable.Set tps = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(polledRecords.partitions()).asScala().toSet().$minus$minus(ignoreRecordsForTps);
        FulfillResult fulfillResult = Runloop$FulfillResult$.MODULE$.apply((Chunk<RunloopCommand.Request>)pendingRequests.filter((Function1 & Serializable)req -> !tps.contains((Object)req.tp())));
        Chunk chunk = streams = tps.isEmpty() ? Chunk$.MODULE$.empty() : partitionStreams.filter((Function1 & Serializable)streamControl -> tps.contains((Object)streamControl.tp()));
        if (streams.isEmpty()) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> fulfillResult, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:384)");
        }
        return this.getConsumerGroupMetadataIfAny.flatMap((Function1 & Serializable)consumerGroupMetadata -> ZIO$.MODULE$.foreachParDiscard(() -> Runloop.offerRecordsToStreams$$anonfun$2$$anonfun$1(streams), (Function1 & Serializable)streamControl -> {
            TopicPartition tp = streamControl.tp();
            List records = polledRecords.records(tp);
            if (records.isEmpty()) {
                return streamControl.offerRecords((Chunk<CommittableRecord<byte[], byte[]>>)Chunk$.MODULE$.empty());
            }
            ChunkBuilder builder = ChunkBuilder$.MODULE$.make(records.size());
            for (ConsumerRecord consumerRecord : records) {
                builder.$plus$eq(CommittableRecord$.MODULE$.apply(consumerRecord, this.commit, (Option<ConsumerGroupMetadata>)consumerGroupMetadata));
            }
            return streamControl.offerRecords((Chunk<CommittableRecord<byte[], byte[]>>)((Chunk)builder.result()));
        }, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:407)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return fulfillResult;
        }, (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:408)"), (Object)"zio.kafka.consumer.internal.Runloop.offerRecordsToStreams(Runloop.scala:408)");
    }

    private ZIO<Object, Throwable, scala.collection.immutable.Set<TopicPartition>> doSeekForNewPartitions(Consumer<byte[], byte[]> c, scala.collection.immutable.Set<TopicPartition> tps) {
        Consumer.OffsetRetrieval offsetRetrieval = this.settings.offsetRetrieval();
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Auto) {
            Consumer.OffsetRetrieval.Auto auto = Consumer$OffsetRetrieval$Auto$.MODULE$.unapply((Consumer.OffsetRetrieval.Auto)offsetRetrieval);
            Consumer.AutoOffsetStrategy autoOffsetStrategy = auto._1();
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> Predef$.MODULE$.Set().empty(), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:419)");
        }
        if (offsetRetrieval instanceof Consumer.OffsetRetrieval.Manual) {
            Consumer.OffsetRetrieval.Manual manual = Consumer$OffsetRetrieval$Manual$.MODULE$.unapply((Consumer.OffsetRetrieval.Manual)offsetRetrieval);
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>>> function1 = manual._1();
            Consumer.AutoOffsetStrategy autoOffsetStrategy = manual._2();
            Function1<scala.collection.immutable.Set<TopicPartition>, ZIO<Object, Throwable, scala.collection.immutable.Map<TopicPartition, Object>>> getOffsets = function1;
            if (tps.isEmpty()) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$9 -> Predef$.MODULE$.Set().empty(), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:421)");
            }
            return ((ZIO)getOffsets.apply(tps)).flatMap((Function1 & Serializable)offsets -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$10 -> offsets.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    c.seek(tp, offset);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:425)").as(() -> Runloop.doSeekForNewPartitions$$anonfun$3$$anonfun$2(offsets), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:426)"), (Object)"zio.kafka.consumer.internal.Runloop.doSeekForNewPartitions(Runloop.scala:427)");
        }
        throw new MatchError((Object)offsetRetrieval);
    }

    private ZIO<Object, Throwable, Tuple2<Object, Object>> resumeAndPausePartitions(Consumer<byte[], byte[]> c, scala.collection.immutable.Set<TopicPartition> requestedPartitions) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$11 -> {
            scala.collection.immutable.Set assignment = CollectionConverters$.MODULE$.SetHasAsScala(c.assignment()).asScala().toSet();
            scala.collection.immutable.Set toResume = (scala.collection.immutable.Set)assignment.intersect((Set)requestedPartitions);
            scala.collection.immutable.Set toPause = (scala.collection.immutable.Set)assignment.$minus$minus((IterableOnce)requestedPartitions);
            if (toResume.nonEmpty()) {
                c.resume((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)toResume).asJava());
            }
            if (toPause.nonEmpty()) {
                c.pause((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)toPause).asJava());
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)toResume.size()), (Object)BoxesRunTime.boxToInteger((int)toPause.size()));
        }, (Object)"zio.kafka.consumer.internal.Runloop.resumeAndPausePartitions(Runloop.scala:445)");
    }

    private ZIO<Object, Throwable, ConsumerRecords<byte[], byte[]>> doPoll(Consumer<byte[], byte[]> c) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$12 -> {
            ConsumerRecords recordsOrNull = c.poll(this.settings.pollTimeout());
            if (recordsOrNull == null) {
                return ConsumerRecords.empty();
            }
            return recordsOrNull;
        }, (Object)"zio.kafka.consumer.internal.Runloop.doPoll(Runloop.scala:452)");
    }

    private ZIO<Object, Throwable, State> handlePoll(State state) {
        return this.settings.fetchStrategy().selectPartitionsToFetch(state.assignedStreams()).flatMap((Function1 & Serializable)partitionsToFetch -> ZIO$.MODULE$.logDebug(() -> Runloop.handlePoll$$anonfun$1$$anonfun$1(state, partitionsToFetch), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:461)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.currentStateRef.set((Object)state, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:462)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.consumer.runloopAccess((Function1 & Serializable)c -> this.resumeAndPausePartitions((Consumer<byte[], byte[]>)c, (scala.collection.immutable.Set<TopicPartition>)partitionsToFetch).map((Function1 & Serializable)resumeAndPauseCounts -> {
                    Tuple2 tuple2 = resumeAndPauseCounts;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int toResumeCount = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    int toPauseCount = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Tuple2 $5$ = tuple2;
                    Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$5$, (Object)BoxesRunTime.boxToInteger((int)toResumeCount), (Object)BoxesRunTime.boxToInteger((int)toPauseCount));
                    Tuple2 $5$2 = (Tuple2)tuple3._1();
                    int toResumeCount2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    int toPauseCount2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                    return Tuple2$.MODULE$.apply(resumeAndPauseCounts, (Object)$5$2);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:467)").flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Tuple2 resumeAndPauseCounts = (Tuple2)tuple2._1();
                        if (tuple22 != null) {
                            int toResumeCount = tuple22._1$mcI$sp();
                            int toPauseCount = tuple22._2$mcI$sp();
                            return this.doPoll((Consumer<byte[], byte[]>)c).timed((Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:469)").map((Function1 & Serializable)pullDurationAndRecords -> {
                                Tuple2 tuple2 = pullDurationAndRecords;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Duration pollDuration = (Duration)tuple2._1();
                                ConsumerRecords polledRecords = (ConsumerRecords)tuple2._2();
                                Tuple2 $7$ = tuple2;
                                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$7$, (Object)pollDuration, (Object)polledRecords);
                                Tuple2 $7$2 = (Tuple2)tuple3._1();
                                Duration pollDuration2 = (Duration)tuple3._2();
                                ConsumerRecords polledRecords2 = (ConsumerRecords)tuple3._3();
                                return Tuple2$.MODULE$.apply(pullDurationAndRecords, (Object)$7$2);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:470)").flatMap((Function1 & Serializable)x$12 -> {
                                Tuple2 tuple2 = x$12;
                                if (tuple2 != null) {
                                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                                    Tuple2 pullDurationAndRecords = (Tuple2)tuple2._1();
                                    if (tuple22 != null) {
                                        Duration pollDuration = (Duration)tuple22._1();
                                        ConsumerRecords polledRecords = (ConsumerRecords)tuple22._2();
                                        return this.consumerMetrics.observePoll(toResumeCount, toPauseCount, pollDuration, polledRecords.count()).$times$greater(() -> this.handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(polledRecords, state), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:482)").flatMap((Function1 & Serializable)x$1 -> {
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return this.lastRebalanceEvent.getAndSet((Object)Runloop$RebalanceEvent$.MODULE$.None(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:483)").flatMap((Function1 & Serializable)x$12 -> {
                                                RebalanceEvent rebalanceEvent = x$12;
                                                if (rebalanceEvent != null) {
                                                    RebalanceEvent rebalanceEvent2 = Runloop$RebalanceEvent$.MODULE$.unapply(rebalanceEvent);
                                                    boolean bl = rebalanceEvent2._1();
                                                    scala.collection.immutable.Set<TopicPartition> set = rebalanceEvent2._2();
                                                    scala.collection.immutable.Set<TopicPartition> set2 = rebalanceEvent2._3();
                                                    scala.collection.immutable.Set<TopicPartition> set3 = rebalanceEvent2._4();
                                                    Chunk<PartitionStreamControl> chunk = rebalanceEvent2._5();
                                                    if (!bl) {
                                                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$13 -> Runloop$PollResult$.MODULE$.apply((ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), state.pendingRequests(), state.assignedStreams()), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:494)");
                                                    }
                                                    if (bl) {
                                                        scala.collection.immutable.Set<TopicPartition> assignedTps = set;
                                                        scala.collection.immutable.Set<TopicPartition> revokedTps = set2;
                                                        scala.collection.immutable.Set<TopicPartition> lostTps = set3;
                                                        Chunk<PartitionStreamControl> endedStreams = chunk;
                                                        scala.collection.immutable.Set currentAssigned = CollectionConverters$.MODULE$.SetHasAsScala(c.assignment()).asScala().toSet();
                                                        scala.collection.immutable.Set endedTps = endedStreams.map((Function1 & Serializable)_$16 -> _$16.tp()).toSet();
                                                        return this.doSeekForNewPartitions((Consumer<byte[], byte[]>)c, assignedTps).map((Function1 & Serializable)ignoreRecordsForTps -> {
                                                            scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)assignedTps.$plus$plus((IterableOnce)currentAssigned.intersect((Set)endedTps));
                                                            return Tuple2$.MODULE$.apply(ignoreRecordsForTps, (Object)startingTps);
                                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:510)").flatMap((Function1 & Serializable)x$1 -> {
                                                            Tuple2 tuple2 = x$1;
                                                            if (tuple2 != null) {
                                                                scala.collection.immutable.Set ignoreRecordsForTps = (scala.collection.immutable.Set)tuple2._1();
                                                                scala.collection.immutable.Set startingTps = (scala.collection.immutable.Set)tuple2._2();
                                                                return ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable((Iterable)startingTps), (Function1 & Serializable)tp -> this.newPartitionStream((TopicPartition)tp), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:513)").tap((Function1 & Serializable)newStreams -> ZIO$.MODULE$.logDebug(() -> Runloop.handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(startingTps), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:514)").$times$greater(() -> this.handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2(newStreams), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:517)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:518)").map((Function1 & Serializable)startingStreams -> {
                                                                    Chunk updatedAssignedStreams = state.assignedStreams().filter((Function1 & Serializable)s -> !endedTps.contains((Object)s.tp())).$plus$plus(startingStreams);
                                                                    Chunk updatedPendingRequests = state.pendingRequests().filter((Function1 & Serializable)pendingRequest -> {
                                                                        TopicPartition tp = pendingRequest.tp();
                                                                        return !lostTps.contains((Object)tp) && !revokedTps.contains((Object)tp) && !endedStreams.exists((Function1 & Serializable)_$18 -> {
                                                                            TopicPartition topicPartition = _$18.tp();
                                                                            TopicPartition topicPartition2 = tp;
                                                                            return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
                                                                        });
                                                                    });
                                                                    return Tuple3$.MODULE$.apply(startingStreams, (Object)updatedAssignedStreams, (Object)updatedPendingRequests);
                                                                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:532)").flatMap((Function1 & Serializable)x$12 -> {
                                                                    Tuple3 tuple3 = x$12;
                                                                    if (tuple3 != null) {
                                                                        Chunk startingStreams = (Chunk)tuple3._1();
                                                                        Chunk updatedAssignedStreams = (Chunk)tuple3._2();
                                                                        Chunk updatedPendingRequests = (Chunk)tuple3._3();
                                                                        return this.committedOffsetsRef.update((Function1 & Serializable)_$19 -> _$19.keepPartitions((scala.collection.immutable.Set<TopicPartition>)updatedAssignedStreams.map((Function1 & Serializable)_$20 -> _$20.tp()).toSet()), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:538)").flatMap((Function1 & Serializable)x$1 -> {
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            return this.consumerMetrics.observeRebalance(currentAssigned.size(), assignedTps.size(), revokedTps.size(), lostTps.size()).flatMap((Function1 & Serializable)x$12 -> {
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(revokedTps, assignedTps, lostTps, endedStreams))).map((Function1 & Serializable)x$1 -> {
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    return Runloop$PollResult$.MODULE$.apply((ConsumerRecords<byte[], byte[]>)polledRecords, (scala.collection.immutable.Set<TopicPartition>)ignoreRecordsForTps, (Chunk<RunloopCommand.Request>)updatedPendingRequests, (Chunk<PartitionStreamControl>)updatedAssignedStreams);
                                                                                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:559)");
                                                                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:559)");
                                                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:559)");
                                                                    }
                                                                    throw new MatchError((Object)tuple3);
                                                                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:559)");
                                                            }
                                                            throw new MatchError((Object)tuple2);
                                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:559)");
                                                    }
                                                }
                                                throw new MatchError((Object)rebalanceEvent);
                                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:560)").map((Function1 & Serializable)pollresult -> pollresult, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:561)");
                                        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:561)");
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:561)");
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:561)")).flatMap((Function1 & Serializable)pollResult -> this.offerRecordsToStreams(pollResult.assignedStreams(), pollResult.pendingRequests(), pollResult.ignoreRecordsForTps(), pollResult.records()).flatMap((Function1 & Serializable)fulfillResult -> ZIO$.MODULE$.filter(state.pendingCommits(), (Function1 & Serializable)_$22 -> _$22.isPending(), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:569)").flatMap((Function1 & Serializable)updatedPendingCommits -> this.checkStreamPollInterval(pollResult.assignedStreams()).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return state.copy(fulfillResult.pendingRequests(), (Chunk<Commit>)updatedPendingCommits, pollResult.assignedStreams(), state.copy$default$4());
                }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)"), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:575)");
    }

    private ZIO<Object, Nothing$, BoxedUnit> checkStreamPollInterval(Chunk<PartitionStreamControl> streams) {
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:584)").flatMap((Function1 & Serializable)now -> this.checkStreamPollInterval$$anonfun$1(streams, BoxesRunTime.unboxToLong((Object)now)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:592)");
    }

    private ZIO<Object, Throwable, State> handleCommand(State state, RunloopCommand.StreamCommand cmd) {
        RunloopCommand.StreamCommand streamCommand = cmd;
        if (streamCommand instanceof RunloopCommand.Request) {
            RunloopCommand.Request req = (RunloopCommand.Request)streamCommand;
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$15 -> {
                if (state.assignedStreams().exists((Function1 & Serializable)_$25 -> {
                    TopicPartition topicPartition = _$25.tp();
                    TopicPartition topicPartition2 = req.tp();
                    return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
                })) {
                    return state.addRequest(req);
                }
                return state;
            }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:622)");
        }
        if (streamCommand instanceof RunloopCommand.AddSubscription) {
            RunloopCommand.AddSubscription addSubscription = (RunloopCommand.AddSubscription)streamCommand;
            RunloopCommand.AddSubscription addSubscription2 = RunloopCommand$AddSubscription$.MODULE$.unapply(addSubscription);
            Subscription subscription = addSubscription2._1();
            Promise<InvalidSubscriptionUnion, BoxedUnit> promise = addSubscription2._2();
            Subscription newSubscription = subscription;
            RunloopCommand.AddSubscription cmd2 = addSubscription;
            SubscriptionState subscriptionState = state.subscriptionState();
            if (SubscriptionState$NotSubscribed$.MODULE$.equals(subscriptionState)) {
                SubscriptionState.Subscribed newSubState = SubscriptionState$Subscribed$.MODULE$.apply((scala.collection.immutable.Set<Subscription>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscription[]{newSubscription}))), newSubscription);
                return cmd2.succeed().$times$greater(() -> this.handleCommand$$anonfun$2(newSubState, state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:628)");
            }
            if (subscriptionState instanceof SubscriptionState.Subscribed) {
                SubscriptionState.Subscribed subscribed = SubscriptionState$Subscribed$.MODULE$.unapply((SubscriptionState.Subscribed)subscriptionState);
                scala.collection.immutable.Set<Subscription> set = subscribed._1();
                Subscription subscription2 = subscribed._2();
                scala.collection.immutable.Set<Subscription> existingSubscriptions = set;
                NonEmptyChunk subs2 = NonEmptyChunk$.MODULE$.fromIterable((Object)newSubscription, existingSubscriptions);
                Option<Subscription> option = Subscription$.MODULE$.unionAll((NonEmptyChunk<Subscription>)subs2);
                if (None$.MODULE$.equals(option)) {
                    return cmd2.fail(InvalidSubscriptionUnion$.MODULE$.apply((Chunk<Subscription>)NonEmptyChunk$.MODULE$.toChunk(subs2))).as(() -> Runloop.handleCommand$$anonfun$3(state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:633)");
                }
                if (option instanceof Some) {
                    Subscription union = (Subscription)((Some)option).value();
                    SubscriptionState.Subscribed newSubState = SubscriptionState$Subscribed$.MODULE$.apply((scala.collection.immutable.Set<Subscription>)((scala.collection.immutable.Set)existingSubscriptions.$plus((Object)newSubscription)), union);
                    return cmd2.succeed().$times$greater(() -> this.handleCommand$$anonfun$4(newSubState, state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:640)");
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)subscriptionState);
        }
        if (streamCommand instanceof RunloopCommand.RemoveSubscription) {
            Subscription subscription;
            RunloopCommand.RemoveSubscription removeSubscription = RunloopCommand$RemoveSubscription$.MODULE$.unapply((RunloopCommand.RemoveSubscription)streamCommand);
            Subscription subscription3 = subscription = removeSubscription._1();
            SubscriptionState subscriptionState = state.subscriptionState();
            if (SubscriptionState$NotSubscribed$.MODULE$.equals(subscriptionState)) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$16 -> state, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:645)");
            }
            if (subscriptionState instanceof SubscriptionState.Subscribed) {
                Tuple2 tuple2;
                SubscriptionState.Subscribed subscribed = SubscriptionState$Subscribed$.MODULE$.unapply((SubscriptionState.Subscribed)subscriptionState);
                scala.collection.immutable.Set<Subscription> set = subscribed._1();
                Subscription subscription4 = subscribed._2();
                scala.collection.immutable.Set<Subscription> existingSubscriptions = set;
                Option newUnion = NonEmptyChunk$.MODULE$.fromIterableOption((Iterable)existingSubscriptions.$minus((Object)subscription3)).flatMap((Function1 & Serializable)subs -> Subscription$.MODULE$.unionAll((NonEmptyChunk<Subscription>)subs).map((Function1 & Serializable)_$26 -> {
                    Subscription subscription = (Subscription)Predef$.MODULE$.ArrowAssoc(_$26);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)subscription, subs);
                }));
                Option option = newUnion;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Subscription union = (Subscription)tuple2._1();
                    NonEmptyChunk newSubscriptions = (NonEmptyChunk)tuple2._2();
                    SubscriptionState.Subscribed newSubState = SubscriptionState$Subscribed$.MODULE$.apply((scala.collection.immutable.Set<Subscription>)NonEmptyChunk$.MODULE$.toChunk(newSubscriptions).toSet(), union);
                    return this.doChangeSubscription$1(state, newSubState);
                }
                if (None$.MODULE$.equals(option)) {
                    return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$6, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:658)").$times$greater(() -> this.handleCommand$$anonfun$7(state), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:659)");
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)subscriptionState);
        }
        if (RunloopCommand$RemoveAllSubscriptions$.MODULE$.equals(streamCommand)) {
            return this.doChangeSubscription$1(state, SubscriptionState$NotSubscribed$.MODULE$);
        }
        if (RunloopCommand$StopAllStreams$.MODULE$.equals(streamCommand)) {
            return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$8, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:665)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.foreachDiscard(() -> Runloop.handleCommand$$anonfun$9$$anonfun$1(state), (Function1 & Serializable)_$27 -> _$27.end(), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:666)").flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.partitionsHub.publish((Object)new Take(Take$.MODULE$.end()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:667)").flatMap((Function1 & Serializable)x$1 -> Runloop.handleCommand$$anonfun$9$$anonfun$3$$anonfun$1(state, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:669)");
                }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:669)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:669)");
        }
        throw new MatchError((Object)streamCommand);
    }

    private ZIO<Object, Throwable, Chunk<PartitionStreamControl>> applyNewSubscriptionState(SubscriptionState newSubscriptionState) {
        return this.consumer.runloopAccess((Function1 & Serializable)c -> {
            SubscriptionState subscriptionState = newSubscriptionState;
            if (SubscriptionState$NotSubscribed$.MODULE$.equals(subscriptionState)) {
                return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$17 -> c.unsubscribe(), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:680)").as(Runloop::applyNewSubscriptionState$$anonfun$1$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:681)");
            }
            if (subscriptionState instanceof SubscriptionState.Subscribed) {
                SubscriptionState.Subscribed subscribed = SubscriptionState$Subscribed$.MODULE$.unapply((SubscriptionState.Subscribed)subscriptionState);
                scala.collection.immutable.Set<Subscription> set = subscribed._1();
                Subscription subscription = subscribed._2();
                if (subscription instanceof Subscription.Pattern) {
                    Regex regex;
                    Subscription.Pattern pattern = Subscription$Pattern$.MODULE$.unapply((Subscription.Pattern)subscription);
                    Regex pattern2 = regex = pattern._1();
                    ConsumerRebalanceListener rebalanceListener = this.makeRebalanceListener();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$18 -> c.subscribe(pattern2.pattern(), rebalanceListener), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:685)").as(Runloop::applyNewSubscriptionState$$anonfun$1$$anonfun$4, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:686)");
                }
                if (subscription instanceof Subscription.Topics) {
                    scala.collection.immutable.Set<String> set2;
                    Subscription.Topics topics = Subscription$Topics$.MODULE$.unapply((Subscription.Topics)subscription);
                    scala.collection.immutable.Set<String> topics2 = set2 = topics._1();
                    ConsumerRebalanceListener rebalanceListener = this.makeRebalanceListener();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$19 -> c.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topics2).asJava(), rebalanceListener), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:690)").as(Runloop::applyNewSubscriptionState$$anonfun$1$$anonfun$6, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:691)");
                }
                if (subscription instanceof Subscription.Manual) {
                    scala.collection.immutable.Set<TopicPartition> set3;
                    Subscription.Manual manual = Subscription$Manual$.MODULE$.unapply((Subscription.Manual)subscription);
                    scala.collection.immutable.Set<TopicPartition> topicPartitions = set3 = manual._1();
                    return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$20 -> c.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topicPartitions).asJava()), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:695)").flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.doSeekForNewPartitions((Consumer<byte[], byte[]>)c, topicPartitions).flatMap((Function1 & Serializable)x$1 -> {
                            scala.collection.immutable.Set set = x$1;
                            return ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable((Iterable)topicPartitions), (Function1 & Serializable)tp -> this.newPartitionStream((TopicPartition)tp), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:697)").flatMap((Function1 & Serializable)partitionStreams -> this.partitionsHub.publish((Object)new Take(Take$.MODULE$.chunk(partitionStreams.map((Function1 & Serializable)_$28 -> _$28.tpStream()))), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:698)").map((Function1 & Serializable)x$1 -> Runloop.applyNewSubscriptionState$$anonfun$1$$anonfun$8$$anonfun$1$$anonfun$2$$anonfun$2(partitionStreams, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:699)"), (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:699)");
                        }, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:699)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.applyNewSubscriptionState(Runloop.scala:699)");
                }
            }
            throw new MatchError((Object)subscriptionState);
        });
    }

    public ZIO<Scope, Throwable, Object> zio$kafka$consumer$internal$Runloop$$run(State initialState) {
        ZStream zStream = Runloop$.MODULE$.zio$kafka$consumer$internal$Runloop$$$StreamOps(ZStream$.MODULE$.fromQueue(this::run$$anonfun$1, Runloop::run$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:719)").takeWhile((Function1 & Serializable)_$29 -> {
            RunloopCommand runloopCommand = _$29;
            RunloopCommand$StopRunloop$ runloopCommand$StopRunloop$ = RunloopCommand$StopRunloop$.MODULE$;
            return runloopCommand == null ? runloopCommand$StopRunloop$ != null : !runloopCommand.equals(runloopCommand$StopRunloop$);
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:720)"));
        return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(zStream, initialState, (Function2 & Serializable)(state, commands) -> this.commitQueue.takeAll((Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:723)").flatMap((Function1 & Serializable)commitCommands -> ZIO$.MODULE$.logDebug(() -> Runloop.run$$anonfun$4$$anonfun$1$$anonfun$1(commitCommands, commands), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:727)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.handleCommits((State)state, (Chunk<Commit>)commitCommands).map((Function1 & Serializable)stateAfterCommits -> {
                Chunk streamCommands = commands.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(RunloopCommand x) {
                        RunloopCommand runloopCommand = x;
                        if (runloopCommand instanceof RunloopCommand.StreamCommand) {
                            RunloopCommand.StreamCommand cmd = (RunloopCommand.StreamCommand)runloopCommand;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(RunloopCommand x, Function1 function1) {
                        RunloopCommand runloopCommand = x;
                        if (runloopCommand instanceof RunloopCommand.StreamCommand) {
                            RunloopCommand.StreamCommand cmd = (RunloopCommand.StreamCommand)runloopCommand;
                            return cmd;
                        }
                        return function1.apply((Object)x);
                    }
                });
                return Tuple2$.MODULE$.apply(stateAfterCommits, (Object)streamCommands);
            }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:729)").flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    State stateAfterCommits = (State)tuple2._1();
                    Chunk streamCommands = (Chunk)tuple2._2();
                    return ZIO$.MODULE$.foldLeft(() -> Runloop.run$$anonfun$4$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(streamCommands), () -> Runloop.run$$anonfun$4$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(stateAfterCommits), (Function2 & Serializable)(state, cmd) -> this.handleCommand((State)state, (RunloopCommand.StreamCommand)cmd), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:730)").flatMap((Function1 & Serializable)stateAfterCommands -> (stateAfterCommands.shouldPoll() ? this.handlePoll((State)stateAfterCommands) : ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$21 -> stateAfterCommands, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:733)")).flatMap((Function1 & Serializable)updatedStateAfterPoll -> (updatedStateAfterPoll.shouldPoll() ? this.commandQueue.offer((Object)RunloopCommand$Poll$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:735)") : ZIO$.MODULE$.unit()).flatMap((Function1 & Serializable)x$12 -> {
                        Object object = x$12;
                        return this.currentStateRef.set(updatedStateAfterPoll, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:737)").map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return updatedStateAfterPoll;
                        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)");
                    }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:738)")).tapErrorCause((Function1 & Serializable)cause -> ZIO$.MODULE$.logErrorCause(Runloop::run$$anonfun$5$$anonfun$1, () -> Runloop.run$$anonfun$5$$anonfun$2(cause), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:740)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:740)").onError((Function1 & Serializable)cause -> this.partitionsHub.offer((Object)new Take(Take$.MODULE$.failCause(cause)), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:741)"), (Object)"zio.kafka.consumer.internal.Runloop.run(Runloop.scala:741)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> zio$kafka$consumer$internal$Runloop$$observeRunloopMetrics(Schedule<Object, BoxedUnit, Object> runloopMetricsSchedule) {
        ZIO observe = this.currentStateRef.get((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:746)").flatMap((Function1 & Serializable)currentState -> this.commandQueue.size((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:747)").flatMap((Function1 & Serializable)commandQueueSize -> this.$anonfun$23$$anonfun$1((State)currentState, BoxesRunTime.unboxToInt((Object)commandQueueSize)), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:751)"), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:751)");
        return observe.repeat(() -> Runloop.observeRunloopMetrics$$anonfun$1(runloopMetricsSchedule), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics(Runloop.scala:754)").unit((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics(Runloop.scala:755)");
    }

    private static final DiagnosticEvent $init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(scala.collection.immutable.Map offsets$4) {
        return DiagnosticEvent$Commit$Started$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$4);
    }

    private static final Throwable $init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        return Consumer$CommitTimeout$.MODULE$;
    }

    private final Duration $init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2() {
        return this.commitTimeout;
    }

    private final /* synthetic */ ZIO $init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Diagnostics diagnostics$4, scala.collection.immutable.Map offsets$3, Promise p$2, long startTime$2, boolean x$1) {
        boolean bl = x$1;
        return diagnostics$4.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(offsets$3))).flatMap((Function1 & Serializable)x$13 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return p$2.await((Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:263)").timeoutFail(Runloop::$init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1, this::$init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:263)").map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit;
                BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
                long endTime = System.nanoTime();
                Duration latency = DurationSyntax$.MODULE$.nanoseconds$extension(zio.package$.MODULE$.durationLong(endTime - startTime$2));
                return Tuple3$.MODULE$.apply((Object)$2$, (Object)BoxesRunTime.boxToLong((long)endTime), (Object)latency);
            }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:265)").flatMap((Function1 & Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 != null) {
                    long endTime = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    Duration latency = (Duration)tuple3._3();
                    return this.consumerMetrics.observeCommit(latency).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:267)");
                }
                throw new MatchError((Object)tuple3);
            }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:267)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:267)");
    }

    private final /* synthetic */ ZIO $init$$$anonfun$1$$anonfun$2$$anonfun$1(Queue commandQueue$3, Diagnostics diagnostics$3, scala.collection.immutable.Map offsets$2, Promise p$1, long startTime$1, boolean x$12) {
        boolean bl = x$12;
        return commandQueue$3.offer((Object)RunloopCommand$CommitAvailable$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:261)").flatMap((Function1 & Serializable)x$1 -> this.$init$$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(diagnostics$3, offsets$2, p$1, startTime$1, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.kafka.consumer.internal.Runloop.commit(Runloop.scala:267)");
    }

    private static final String stopConsumption$$anonfun$1() {
        return "stopConsumption called";
    }

    private final ZIO stopConsumption$$anonfun$2() {
        return this.commandQueue.offer((Object)RunloopCommand$StopAllStreams$.MODULE$, (Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:51)").unit((Object)"zio.kafka.consumer.internal.Runloop.stopConsumption(Runloop.scala:51)");
    }

    private static final String shutdown$$anonfun$1() {
        return "Shutting down runloop initiated";
    }

    private final ZIO shutdown$$anonfun$2() {
        return this.commandQueue.offerAll((Iterable)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RunloopCommand[]{RunloopCommand$RemoveAllSubscriptions$.MODULE$, RunloopCommand$StopAllStreams$.MODULE$, RunloopCommand$StopRunloop$.MODULE$})), (Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:62)").unit((Object)"zio.kafka.consumer.internal.Runloop.shutdown(Runloop.scala:63)");
    }

    private static final String addSubscription$$anonfun$1(Subscription subscription$1) {
        return new StringBuilder(17).append("Add subscription ").append(subscription$1).toString();
    }

    private static final String addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Subscription subscription$5) {
        return new StringBuilder(25).append("Waiting for subscription ").append(subscription$5).toString();
    }

    private static final String addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Subscription subscription$8) {
        return new StringBuilder(22).append("Done for subscription ").append(subscription$8).toString();
    }

    private static final /* synthetic */ ZIO addSubscription$$anonfun$2$$anonfun$1$$anonfun$1(Subscription subscription$4, Promise promise$1, boolean x$12) {
        boolean bl = x$12;
        return ZIO$.MODULE$.logDebug(() -> Runloop.addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(subscription$4), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:70)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return promise$1.await((Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:71)").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.logDebug(() -> Runloop.addSubscription$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(subscription$4), (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:72)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:73)");
            }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:73)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.addSubscription(Runloop.scala:73)");
    }

    private static final Iterable endStreams$1$$anonfun$1(Chunk streamsToEnd$1) {
        return streamsToEnd$1;
    }

    private final ZIO endStreams$1(Duration commitQueuePollInterval$12, State state, Chunk streamsToEnd) {
        if (streamsToEnd.isEmpty()) {
            return ZIO$.MODULE$.unit();
        }
        return ZIO$.MODULE$.foreachDiscard(() -> Runloop.endStreams$1$$anonfun$1(streamsToEnd), (Function1 & Serializable)_$1 -> _$1.end(), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.endStreams(Runloop.scala:95)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (this.rebalanceSafeCommits ? this.consumer.rebalanceListenerAccess((Function1 & Serializable)_$2 -> this.doAwaitStreamCommits$1(commitQueuePollInterval$12, (Consumer)_$2, state, streamsToEnd)) : ZIO$.MODULE$.unit()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.endStreams(Runloop.scala:99)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.endStreams(Runloop.scala:99)");
    }

    private static final Chunk commitsOfEndingStreams$1(scala.collection.immutable.Set endingTps$1, Chunk commits) {
        return commits.filter((Function1 & Serializable)commit -> commit.offsets().keySet().intersect((Set)endingTps$1).nonEmpty());
    }

    private static final Chunk previousPendingCommits$lzyINIT1$1(LazyRef previousPendingCommits$lzy1$1, State state$3, scala.collection.immutable.Set endingTps$3) {
        Chunk chunk;
        LazyRef lazyRef = previousPendingCommits$lzy1$1;
        synchronized (lazyRef) {
            chunk = (Chunk)(previousPendingCommits$lzy1$1.initialized() ? previousPendingCommits$lzy1$1.value() : previousPendingCommits$lzy1$1.initialize((Object)Runloop.commitsOfEndingStreams$1(endingTps$3, state$3.pendingCommits())));
        }
        return chunk;
    }

    private static final Chunk previousPendingCommits$1(LazyRef previousPendingCommits$lzy1$2, State state$4, scala.collection.immutable.Set endingTps$4) {
        return (Chunk)(previousPendingCommits$lzy1$2.initialized() ? previousPendingCommits$lzy1$2.value() : Runloop.previousPendingCommits$lzyINIT1$1(previousPendingCommits$lzy1$2, state$4, endingTps$4));
    }

    private static final String commitAsync$1$$anonfun$1(java.util.Map offsets$5, Chunk commits$1) {
        return new StringBuilder(37).append("Async commit of ").append(offsets$5.size()).append(" offsets for ").append(commits$1.size()).append(" commits").toString();
    }

    private static final ZIO commitAsync$1$$anonfun$2(Consumer consumer$2, java.util.Map offsets$6, OffsetCommitCallback callback$1, Function1 onFailure$1) {
        return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> consumer$2.commitAsync(offsets$6, callback$1), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitAsync(Runloop.scala:121)").catchAll(onFailure$1, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitAsync(Runloop.scala:121)");
    }

    private final ZIO commitAsync$1(Consumer consumer$1, Chunk commits) {
        if (commits.nonEmpty()) {
            Tuple3<java.util.Map<TopicPartition, OffsetAndMetadata>, OffsetCommitCallback, Function1<Throwable, ZIO<Object, Nothing$, BoxedUnit>>> tuple3 = this.asyncCommitParameters((Chunk<Commit>)commits);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            java.util.Map offsets = (java.util.Map)tuple3._1();
            OffsetCommitCallback callback = (OffsetCommitCallback)tuple3._2();
            Function1 onFailure = (Function1)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)offsets, (Object)callback, (Object)onFailure);
            java.util.Map offsets2 = (java.util.Map)tuple32._1();
            OffsetCommitCallback callback2 = (OffsetCommitCallback)tuple32._2();
            Function1 onFailure2 = (Function1)tuple32._3();
            return ZIO$.MODULE$.logDebug(() -> Runloop.commitAsync$1$$anonfun$1(offsets2, commits), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitAsync(Runloop.scala:120)").$times$greater(() -> Runloop.commitAsync$1$$anonfun$2(consumer$1, offsets2, callback2, onFailure2), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitAsync(Runloop.scala:121)");
        }
        return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$2 -> consumer$1.commitAsync(Collections.emptyMap(), null), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitAsync(Runloop.scala:125)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitAsync(Runloop.scala:125)");
    }

    private static final /* synthetic */ ZIO endingStreamsCompletedAndCommitsExist$1$$anonfun$1$$anonfun$1(PartitionStreamControl stream$1, boolean isDone) {
        return (isDone ? stream$1.completedPromise().await((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:134)") : ZIO$.MODULE$.none()).map((Function1 & Serializable)endOffset -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)isDone), endOffset), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:135)");
    }

    private static final boolean endOffsetWasCommitted$1(CommitOffsets committedOffsets$2, TopicPartition tp$1, long offset$1) {
        return committedOffsets$2.contains(tp$1, offset$1);
    }

    private static final boolean endOffsetCommitIsPending$1(Chunk allPendingCommits$2, TopicPartition tp$2, long offset$2) {
        return allPendingCommits$2.exists((Function1 & Serializable)pendingCommit -> pendingCommit.offsets().get((Object)tp$2).exists((Function1 & Serializable)pendingOffset -> pendingOffset.offset() >= offset$2));
    }

    private static final /* synthetic */ boolean endingStreamsCompletedAndCommitsExist$1$$anonfun$2$$anonfun$1$$anonfun$1(CommitOffsets committedOffsets$1, Chunk allPendingCommits$1, Offset endOffset) {
        long offset;
        TopicPartition tp = endOffset.topicPartition();
        return Runloop.endOffsetWasCommitted$1(committedOffsets$1, tp, offset = endOffset.offset()) || Runloop.endOffsetCommitIsPending$1(allPendingCommits$1, tp, offset);
    }

    private final ZIO endingStreamsCompletedAndCommitsExist$1(Chunk streamsToEnd$4, LazyRef previousPendingCommits$lzy1$3, State state$5, scala.collection.immutable.Set endingTps$5, Chunk newCommits) {
        return ZIO$.MODULE$.foreach((Iterable)streamsToEnd$4, (Function1 & Serializable)stream -> stream.completedPromise().isDone((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:133)").flatMap((Function1 & Serializable)isDone -> Runloop.endingStreamsCompletedAndCommitsExist$1$$anonfun$1$$anonfun$1(stream, BoxesRunTime.unboxToBoolean((Object)isDone)), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:135)"), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:136)").flatMap((Function1 & Serializable)streamResults -> this.committedOffsetsRef.get((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:137)").map((Function1 & Serializable)committedOffsets -> {
            Chunk allPendingCommits;
            Chunk endOffsets;
            boolean allStreamsCompleted = streamResults.forall((Function1 & Serializable)_$4 -> BoxesRunTime.unboxToBoolean((Object)_$4._1()));
            return allStreamsCompleted && (endOffsets = streamResults.flatMap((Function1 & Serializable)_$5 -> (IterableOnce)_$5._2())).forall(arg_0 -> Runloop.endingStreamsCompletedAndCommitsExist$1$$anonfun$2$$anonfun$1$$anonfun$1(committedOffsets, allPendingCommits = Runloop.previousPendingCommits$1(previousPendingCommits$lzy1$3, state$5, endingTps$5).$plus$plus(Runloop.commitsOfEndingStreams$1(endingTps$5, newCommits)), arg_0));
        }, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:155)"), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(Runloop.scala:155)");
    }

    private final ZIO commitSync$1(Consumer consumer$5) {
        return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$3 -> consumer$5.commitSync(Collections.emptyMap(), this.commitTimeout), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits.commitSync(Runloop.scala:158)");
    }

    private static final String doAwaitStreamCommits$1$$anonfun$1(Chunk streamsToEnd$5) {
        return new StringBuilder(27).append("Waiting for ").append(streamsToEnd$5.size()).append(" streams to end").toString();
    }

    private final ZIO doAwaitStreamCommits$1$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.commitQueue.takeAll((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:178)");
    }

    private final ZIO doAwaitStreamCommits$1$$anonfun$2$$anonfun$1(Duration commitQueuePollInterval$5) {
        return package$.MODULE$.blockingSleep(commitQueuePollInterval$5).$times$greater(this::doAwaitStreamCommits$1$$anonfun$2$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:178)");
    }

    private static final Chunk doAwaitStreamCommits$1$$anonfun$2$$anonfun$4() {
        return Chunk$.MODULE$.empty();
    }

    private final ZIO doAwaitStreamCommits$1$$anonfun$2(Duration commitQueuePollInterval$4, long deadline$1, Consumer consumer$7, Chunk streamsToEnd$6, LazyRef previousPendingCommits$lzy1$6, State state$8, scala.collection.immutable.Set endingTps$8) {
        return ZStream$.MODULE$.fromZIO(() -> this.doAwaitStreamCommits$1$$anonfun$2$$anonfun$1(commitQueuePollInterval$4), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:178)").tap((Function1 & Serializable)commits -> this.commitAsync$1(consumer$7, (Chunk)commits), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:179)").forever((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:180)").takeWhile((Function1 & Serializable)_$6 -> System.nanoTime() <= deadline$1, (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:181)").scan(Runloop::doAwaitStreamCommits$1$$anonfun$2$$anonfun$4, (Function2 & Serializable)(_$7, _$8) -> _$7.$plus$plus(_$8), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:182)").takeUntilZIO((Function1 & Serializable)newCommits -> this.endingStreamsCompletedAndCommitsExist$1(streamsToEnd$6, previousPendingCommits$lzy1$6, state$8, endingTps$8, (Chunk)newCommits), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:183)").runDrain((Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:184)");
    }

    private final ZIO doAwaitStreamCommits$1$$anonfun$3(Consumer consumer$17) {
        return this.commitSync$1(consumer$17);
    }

    private static final String doAwaitStreamCommits$1$$anonfun$4$$anonfun$1(Chunk streamsToEnd$8) {
        return new StringBuilder(32).append("Done waiting for ").append(streamsToEnd$8.size()).append(" streams to end").toString();
    }

    private static final ZIO doAwaitStreamCommits$1$$anonfun$4(Chunk streamsToEnd$7) {
        return ZIO$.MODULE$.logDebug(() -> Runloop.doAwaitStreamCommits$1$$anonfun$4$$anonfun$1(streamsToEnd$7), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:186)");
    }

    private final ZIO doAwaitStreamCommits$1(Duration commitQueuePollInterval$3, Consumer consumer, State state, Chunk streamsToEnd) {
        LazyRef lazyRef = new LazyRef();
        long deadline = System.nanoTime() + this.maxRebalanceDuration.toNanos() - this.commitTimeoutNanos;
        scala.collection.immutable.Set endingTps = streamsToEnd.map((Function1 & Serializable)_$3 -> _$3.tp()).toSet();
        return ZIO$.MODULE$.logDebug(() -> Runloop.doAwaitStreamCommits$1$$anonfun$1(streamsToEnd), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:176)").$times$greater(() -> this.doAwaitStreamCommits$1$$anonfun$2(commitQueuePollInterval$3, deadline, consumer, streamsToEnd, lazyRef, state, endingTps), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:184)").$times$greater(() -> this.doAwaitStreamCommits$1$$anonfun$3(consumer), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:185)").$times$greater(() -> Runloop.doAwaitStreamCommits$1$$anonfun$4(streamsToEnd), (Object)"zio.kafka.consumer.internal.Runloop.makeRebalanceListener.doAwaitStreamCommits(Runloop.scala:186)");
    }

    private static final String $anonfun$4$$anonfun$1$$anonfun$1(RebalanceEvent rebalanceEvent$1, scala.collection.immutable.Set assignedTps$4) {
        String sameRebalance = rebalanceEvent$1.wasInvoked() ? " in same rebalance" : "";
        return new StringBuilder(24).append(assignedTps$4.size()).append(" partitions are assigned").append(sameRebalance).toString();
    }

    private static final String $anonfun$4$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "onAssigned done";
    }

    private static final String $anonfun$5$$anonfun$1$$anonfun$1(RebalanceEvent rebalanceEvent$6, scala.collection.immutable.Set revokedTps$4) {
        String sameRebalance = rebalanceEvent$6.wasInvoked() ? " in same rebalance" : "";
        return new StringBuilder(23).append(revokedTps$4.size()).append(" partitions are revoked").append(sameRebalance).toString();
    }

    private static final String $anonfun$5$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "onRevoked done";
    }

    private static final String $anonfun$7$$anonfun$1(scala.collection.immutable.Set lostTps$4) {
        return new StringBuilder(20).append(lostTps$4.size()).append(" partitions are lost").toString();
    }

    private static final Iterable $anonfun$7$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(Chunk lostStreams$1) {
        return lostStreams$1;
    }

    private static final String $anonfun$7$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1() {
        return "onLost done";
    }

    private static final OffsetAndMetadata $anonfun$9$$anonfun$1$$anonfun$2(OffsetAndMetadata offset$6) {
        return offset$6;
    }

    private static final Iterable $anonfun$11$$anonfun$1(Chunk commits$3) {
        return commits$3;
    }

    private static final boolean $anonfun$13$$anonfun$1(Chunk commits$6) {
        return commits$6.nonEmpty();
    }

    private static final DiagnosticEvent $anonfun$13$$anonfun$2$$anonfun$1$$anonfun$1(scala.collection.immutable.Map offsetsWithMetaData$4) {
        return DiagnosticEvent$Commit$Success$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$4);
    }

    private final /* synthetic */ ZIO $anonfun$13(Duration latency$1, Chunk commits$5, Function1 cont$1, scala.collection.immutable.Map offsetsWithMetaData$1, long offsetIncrease) {
        return this.consumerMetrics.observeAggregatedCommit(latency$1, offsetIncrease).when(() -> Runloop.$anonfun$13$$anonfun$1(commits$5), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onSuccess(Runloop.scala:295)").flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            return ((ZIO)cont$1.apply((Object)Exit$.MODULE$.unit())).flatMap((Function1 & Serializable)result -> this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$13$$anonfun$2$$anonfun$1$$anonfun$1(offsetsWithMetaData$1))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onSuccess(Runloop.scala:298)"), (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onSuccess(Runloop.scala:298)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.asyncCommitParameters.onSuccess(Runloop.scala:298)");
    }

    private static final String $anonfun$14$$anonfun$1(scala.collection.immutable.Map offsets$9) {
        return new StringBuilder(58).append("Rebalance in progress, commit for offsets ").append(offsets$9).append(" will be retried").toString();
    }

    private static final DiagnosticEvent $anonfun$14$$anonfun$3$$anonfun$1(scala.collection.immutable.Map offsetsWithMetaData$7, Throwable err$2) {
        return DiagnosticEvent$Commit$Failure$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetsWithMetaData$7, err$2);
    }

    private final ZIO $anonfun$14$$anonfun$3(scala.collection.immutable.Map offsetsWithMetaData$6, Throwable err$1) {
        return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.$anonfun$14$$anonfun$3$$anonfun$1(offsetsWithMetaData$6, err$1)));
    }

    private static final State handleCommits$$anonfun$3(State newState$1) {
        return newState$1;
    }

    private static final Iterable endRevokedPartitions$$anonfun$1(Chunk revokedStreams$1) {
        return revokedStreams$1;
    }

    private static final RevokeResult endRevokedPartitions$$anonfun$3(Chunk pendingRequests$3, Function1 isRevoked$2, Chunk newAssignedStreams$1) {
        return Runloop$RevokeResult$.MODULE$.apply((Chunk<RunloopCommand.Request>)pendingRequests$3.filter((Function1 & Serializable)req -> !BoxesRunTime.unboxToBoolean((Object)isRevoked$2.apply((Object)req.tp()))), (Chunk<PartitionStreamControl>)newAssignedStreams$1);
    }

    private static final Iterable offerRecordsToStreams$$anonfun$2$$anonfun$1(Chunk streams$2) {
        return streams$2;
    }

    private static final scala.collection.immutable.Set doSeekForNewPartitions$$anonfun$3$$anonfun$2(scala.collection.immutable.Map offsets$13) {
        return offsets$13.keySet();
    }

    private static final String handlePoll$$anonfun$1$$anonfun$1(State state$11, scala.collection.immutable.Set partitionsToFetch$1) {
        return new StringBuilder(40).append("Starting poll with ").append(state$11.pendingRequests().size()).append(" pending requests and").append(new StringBuilder(18).append(" ").append(state$11.pendingCommits().size()).append(" pending commits,").toString()).append(new StringBuilder(21).append(" resuming ").append(partitionsToFetch$1).append(" partitions").toString()).toString();
    }

    private static final DiagnosticEvent handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(ConsumerRecords polledRecords$4, State state$18) {
        scala.collection.immutable.Set providedTps = CollectionConverters$.MODULE$.SetHasAsScala(polledRecords$4.partitions()).asScala().toSet();
        scala.collection.immutable.Set requestedPartitions = state$18.pendingRequests().map((Function1 & Serializable)_$15 -> _$15.tp()).toSet();
        return DiagnosticEvent$Poll$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)requestedPartitions, (scala.collection.immutable.Set<TopicPartition>)providedTps, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)requestedPartitions.$minus$minus((IterableOnce)providedTps)));
    }

    private final ZIO handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(ConsumerRecords polledRecords$3, State state$17) {
        return this.diagnostics.emit((Function0<DiagnosticEvent>)((Function0 & Serializable)() -> Runloop.handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(polledRecords$3, state$17)));
    }

    private static final String handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1(scala.collection.immutable.Set startingTps$2) {
        return new StringBuilder(30).append("Offering partition assignment ").append(startingTps$2).toString();
    }

    private final ZIO handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2(Chunk newStreams$1) {
        return this.partitionsHub.publish((Object)new Take(Take$.MODULE$.chunk(newStreams$1.map((Function1 & Serializable)_$17 -> _$17.tpStream()))), (Object)"zio.kafka.consumer.internal.Runloop.handlePoll(Runloop.scala:517)");
    }

    private static final DiagnosticEvent handlePoll$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1(scala.collection.immutable.Set revokedTps$17, scala.collection.immutable.Set assignedTps$14, scala.collection.immutable.Set lostTps$17, Chunk endedStreams$10) {
        return DiagnosticEvent$Rebalance$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)revokedTps$17, (scala.collection.immutable.Set<TopicPartition>)assignedTps$14, (scala.collection.immutable.Set<TopicPartition>)lostTps$17, (scala.collection.immutable.Set<TopicPartition>)endedStreams$10.map((Function1 & Serializable)_$21 -> _$21.tp()).toSet());
    }

    private static final Iterable checkStreamPollInterval$$anonfun$1$$anonfun$1(Chunk streams$4) {
        return streams$4;
    }

    private static final boolean checkStreamPollInterval$$anonfun$1$$anonfun$2() {
        return false;
    }

    private static final /* synthetic */ ZIO checkStreamPollInterval$$anonfun$1$$anonfun$3$$anonfun$1(PartitionStreamControl stream$2, boolean exceeded) {
        if (exceeded) {
            return stream$2.halt();
        }
        return ZIO$.MODULE$.unit();
    }

    private static final /* synthetic */ boolean checkStreamPollInterval$$anonfun$1$$anonfun$3$$anonfun$2(boolean acc$2, boolean _$23) {
        return acc$2 || _$23;
    }

    private static final /* synthetic */ ZIO checkStreamPollInterval$$anonfun$1$$anonfun$3(long now$1, boolean x$1, PartitionStreamControl x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)x$1), (Object)x$2);
        if (tuple2 != null) {
            boolean acc = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
            PartitionStreamControl stream = (PartitionStreamControl)tuple2._2();
            return stream.maxPollIntervalExceeded(now$1).tap((Function1 & Serializable)exceeded -> Runloop.checkStreamPollInterval$$anonfun$1$$anonfun$3$$anonfun$1(stream, BoxesRunTime.unboxToBoolean((Object)exceeded)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:588)").map((Function1 & Serializable)_$23 -> Runloop.checkStreamPollInterval$$anonfun$1$$anonfun$3$$anonfun$2(acc, BoxesRunTime.unboxToBoolean((Object)_$23)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:589)");
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean checkStreamPollInterval$$anonfun$1$$anonfun$4$$anonfun$1(boolean anyExceeded$1) {
        return anyExceeded$1;
    }

    private final /* synthetic */ ZIO checkStreamPollInterval$$anonfun$1$$anonfun$4(boolean anyExceeded) {
        return this.shutdown().when(() -> Runloop.checkStreamPollInterval$$anonfun$1$$anonfun$4$$anonfun$1(anyExceeded), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:591)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Option option = x$1;
        }, (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:592)");
    }

    private final /* synthetic */ ZIO checkStreamPollInterval$$anonfun$1(Chunk streams$3, long now) {
        return ZIO$.MODULE$.foldLeft(() -> Runloop.checkStreamPollInterval$$anonfun$1$$anonfun$1(streams$3), Runloop::checkStreamPollInterval$$anonfun$1$$anonfun$2, (Function2 & Serializable)(x$1, x$2) -> Runloop.checkStreamPollInterval$$anonfun$1$$anonfun$3(now, BoxesRunTime.unboxToBoolean((Object)x$1), (PartitionStreamControl)x$2), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:590)").flatMap((Function1 & Serializable)anyExceeded -> this.checkStreamPollInterval$$anonfun$1$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)anyExceeded)), (Object)"zio.kafka.consumer.internal.Runloop.checkStreamPollInterval(Runloop.scala:592)");
    }

    private final ZIO doChangeSubscription$1(State state$28, SubscriptionState newSubscriptionState) {
        return this.applyNewSubscriptionState(newSubscriptionState).flatMap((Function1 & Serializable)newAssignedStreams -> {
            Chunk chunk = state$28.assignedStreams().$plus$plus(newAssignedStreams);
            Chunk<RunloopCommand.Request> chunk2 = state$28.copy$default$1();
            Chunk<Commit> chunk3 = state$28.copy$default$2();
            State newState = state$28.copy(chunk2, chunk3, (Chunk<PartitionStreamControl>)chunk, newSubscriptionState);
            if (newSubscriptionState.isSubscribed()) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$14 -> newState, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand.doChangeSubscription(Runloop.scala:601)");
            }
            return this.endRevokedPartitions(newState.pendingRequests(), newState.assignedStreams(), (Function1<TopicPartition, Object>)(Function1 & Serializable)_$24 -> true).map((Function1 & Serializable)revokeResult -> newState.copy(revokeResult.pendingRequests(), newState.copy$default$2(), revokeResult.assignedStreams(), newState.copy$default$4()), (Object)"zio.kafka.consumer.internal.Runloop.handleCommand.doChangeSubscription(Runloop.scala:613)");
        }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand.doChangeSubscription(Runloop.scala:614)");
    }

    private final ZIO handleCommand$$anonfun$2(SubscriptionState.Subscribed newSubState$1, State state$31) {
        return this.doChangeSubscription$1(state$31, newSubState$1);
    }

    private static final State handleCommand$$anonfun$3(State state$32) {
        return state$32;
    }

    private final ZIO handleCommand$$anonfun$4(SubscriptionState.Subscribed newSubState$2, State state$33) {
        return this.doChangeSubscription$1(state$33, newSubState$2);
    }

    private static final String handleCommand$$anonfun$6() {
        return "Unsubscribing kafka consumer";
    }

    private final ZIO handleCommand$$anonfun$7(State state$43) {
        return this.doChangeSubscription$1(state$43, SubscriptionState$NotSubscribed$.MODULE$);
    }

    private static final String handleCommand$$anonfun$8() {
        return "Stop all streams initiated";
    }

    private static final Iterable handleCommand$$anonfun$9$$anonfun$1(State state$36) {
        return state$36.assignedStreams();
    }

    private static final String handleCommand$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1() {
        return "Stop all streams done";
    }

    private static final /* synthetic */ ZIO handleCommand$$anonfun$9$$anonfun$3$$anonfun$1(State state$38, boolean x$12) {
        boolean bl = x$12;
        return ZIO$.MODULE$.logDebug(Runloop::handleCommand$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:668)").map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return state$38.copy((Chunk<RunloopCommand.Request>)Chunk$.MODULE$.empty(), state$38.copy$default$2(), state$38.copy$default$3(), state$38.copy$default$4());
        }, (Object)"zio.kafka.consumer.internal.Runloop.handleCommand(Runloop.scala:669)");
    }

    private static final Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$2() {
        return Chunk$.MODULE$.empty();
    }

    private static final Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$4() {
        return Chunk$.MODULE$.empty();
    }

    private static final Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$6() {
        return Chunk$.MODULE$.empty();
    }

    private static final /* synthetic */ Chunk applyNewSubscriptionState$$anonfun$1$$anonfun$8$$anonfun$1$$anonfun$2$$anonfun$2(Chunk partitionStreams$1, boolean x$1) {
        boolean bl = x$1;
        return partitionStreams$1;
    }

    private final Dequeue run$$anonfun$1() {
        return this.commandQueue;
    }

    private static final int run$$anonfun$2() {
        return ZStream$.MODULE$.fromQueue$default$2();
    }

    private static final String run$$anonfun$4$$anonfun$1$$anonfun$1(Chunk commitCommands$1, Chunk commands$1) {
        return new StringBuilder(20).append("Processing ").append(commitCommands$1.size()).append(" commits,").append(new StringBuilder(12).append(" ").append(commands$1.size()).append(" commands: ").append(commands$1.mkString(",")).toString()).toString();
    }

    private static final Iterable run$$anonfun$4$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Chunk streamCommands$1) {
        return streamCommands$1;
    }

    private static final State run$$anonfun$4$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(State stateAfterCommits$1) {
        return stateAfterCommits$1;
    }

    private static final String run$$anonfun$5$$anonfun$1() {
        return "Error in Runloop";
    }

    private static final Cause run$$anonfun$5$$anonfun$2(Cause cause$1) {
        return cause$1;
    }

    private final /* synthetic */ ZIO $anonfun$23$$anonfun$1$$anonfun$1(State currentState$2, int commandQueueSize$1, int commitQueueSize) {
        return this.consumerMetrics.observeRunloopMetrics(currentState$2, commandQueueSize$1, commitQueueSize).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:751)");
    }

    private final /* synthetic */ ZIO $anonfun$23$$anonfun$1(State currentState$1, int commandQueueSize) {
        return this.commitQueue.size((Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:748)").flatMap((Function1 & Serializable)commitQueueSize -> this.$anonfun$23$$anonfun$1$$anonfun$1(currentState$1, commandQueueSize, BoxesRunTime.unboxToInt((Object)commitQueueSize)), (Object)"zio.kafka.consumer.internal.Runloop.observeRunloopMetrics.observe(Runloop.scala:751)");
    }

    private static final Schedule observeRunloopMetrics$$anonfun$1(Schedule runloopMetricsSchedule$1) {
        return runloopMetricsSchedule$1;
    }

    public static final class Commit
    implements Product,
    Serializable {
        private final long createdAt;
        private final scala.collection.immutable.Map offsets;
        private final Promise cont;

        public static Commit apply(long l, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map, Promise<Throwable, BoxedUnit> promise) {
            return Runloop$Commit$.MODULE$.apply(l, map, promise);
        }

        public static Commit fromProduct(Product product) {
            return Runloop$Commit$.MODULE$.fromProduct(product);
        }

        public static Commit unapply(Commit commit) {
            return Runloop$Commit$.MODULE$.unapply(commit);
        }

        public Commit(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            this.createdAt = createdAt;
            this.offsets = offsets;
            this.cont = cont;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.createdAt()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offsets()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.cont()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Commit)) return false;
            Commit commit = (Commit)object;
            if (this.createdAt() != commit.createdAt()) return false;
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = this.offsets();
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map2 = commit.offsets();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Promise<Throwable, BoxedUnit> promise = this.cont();
            Promise<Throwable, BoxedUnit> promise2 = commit.cont();
            if (promise == null) {
                if (promise2 == null) return true;
                return false;
            } else {
                if (!promise.equals(promise2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Commit;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Commit";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "createdAt";
                }
                case 1: {
                    return "offsets";
                }
                case 2: {
                    return "cont";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long createdAt() {
            return this.createdAt;
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets() {
            return this.offsets;
        }

        public Promise<Throwable, BoxedUnit> cont() {
            return this.cont;
        }

        public ZIO<Object, Nothing$, Object> isDone() {
            return this.cont().isDone((Object)"zio.kafka.consumer.internal.Runloop.Commit.isDone(Runloop.scala:837)");
        }

        public ZIO<Object, Nothing$, Object> isPending() {
            return this.isDone().negate(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.consumer.internal.Runloop.Commit.isPending(Runloop.scala:838)");
        }

        public Commit copy(long createdAt, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Promise<Throwable, BoxedUnit> cont) {
            return new Commit(createdAt, offsets, cont);
        }

        public long copy$default$1() {
            return this.createdAt();
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> copy$default$2() {
            return this.offsets();
        }

        public Promise<Throwable, BoxedUnit> copy$default$3() {
            return this.cont();
        }

        public long _1() {
            return this.createdAt();
        }

        public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> _2() {
            return this.offsets();
        }

        public Promise<Throwable, BoxedUnit> _3() {
            return this.cont();
        }
    }

    public static final class CommitOffsets
    implements Product,
    Serializable {
        private final scala.collection.immutable.Map offsets;

        public static CommitOffsets apply(scala.collection.immutable.Map<TopicPartition, Object> map) {
            return Runloop$CommitOffsets$.MODULE$.apply(map);
        }

        public static CommitOffsets empty() {
            return Runloop$CommitOffsets$.MODULE$.empty();
        }

        public static CommitOffsets fromProduct(Product product) {
            return Runloop$CommitOffsets$.MODULE$.fromProduct(product);
        }

        public static CommitOffsets unapply(CommitOffsets commitOffsets) {
            return Runloop$CommitOffsets$.MODULE$.unapply(commitOffsets);
        }

        public CommitOffsets(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
            this.offsets = offsets;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommitOffsets)) return false;
            CommitOffsets commitOffsets = (CommitOffsets)object;
            scala.collection.immutable.Map<TopicPartition, Object> map = this.offsets();
            scala.collection.immutable.Map<TopicPartition, Object> map2 = commitOffsets.offsets();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommitOffsets;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CommitOffsets";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offsets";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Map<TopicPartition, Object> offsets() {
            return this.offsets;
        }

        public Tuple2<Object, CommitOffsets> addCommits(Chunk<Commit> c) {
            scala.collection.mutable.Map updatedOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            updatedOffsets.sizeHint(this.offsets().size());
            updatedOffsets.$plus$plus$eq(this.offsets());
            LongRef offsetIncrease = LongRef.create((long)0L);
            c.foreach((Function1)(JProcedure1 & Serializable)commit -> commit.offsets().foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long l;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    OffsetAndMetadata offsetAndMeta = (OffsetAndMetadata)tuple2._2();
                    long offset = offsetAndMeta.offset();
                    Option option = updatedOffsets.get((Object)tp);
                    if (option instanceof Some) {
                        long l2;
                        long existingOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                        offsetIncrease$2.elem = l2 = offsetIncrease$2.elem + Math.max(0L, offset - existingOffset);
                        l = Math.max(existingOffset, offset);
                    } else if (None$.MODULE$.equals(option)) {
                        l = offset;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    long maxOffset = l;
                    TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)tp);
                    return (scala.collection.mutable.Map)updatedOffsets.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)maxOffset)));
                }
                throw new MatchError((Object)tuple2);
            }));
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offsetIncrease.elem), (Object)Runloop$CommitOffsets$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, Object>)updatedOffsets.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        }

        public CommitOffsets keepPartitions(scala.collection.immutable.Set<TopicPartition> tps) {
            return Runloop$CommitOffsets$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.offsets().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    return tps.contains((Object)tp);
                }
                throw new MatchError((Object)tuple2);
            })));
        }

        public boolean contains(TopicPartition tp, long offset) {
            return this.offsets().get((Object)tp).exists((Function1)(JFunction1.mcZJ.sp & Serializable)_$33 -> _$33 >= offset);
        }

        public CommitOffsets copy(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
            return new CommitOffsets(offsets);
        }

        public scala.collection.immutable.Map<TopicPartition, Object> copy$default$1() {
            return this.offsets();
        }

        public scala.collection.immutable.Map<TopicPartition, Object> _1() {
            return this.offsets();
        }
    }

    public static final class FulfillResult
    implements Product,
    Serializable {
        private final Chunk pendingRequests;

        public static FulfillResult apply(Chunk<RunloopCommand.Request> chunk) {
            return Runloop$FulfillResult$.MODULE$.apply(chunk);
        }

        public static FulfillResult fromProduct(Product product) {
            return Runloop$FulfillResult$.MODULE$.fromProduct(product);
        }

        public static FulfillResult unapply(FulfillResult fulfillResult) {
            return Runloop$FulfillResult$.MODULE$.unapply(fulfillResult);
        }

        public FulfillResult(Chunk<RunloopCommand.Request> pendingRequests) {
            this.pendingRequests = pendingRequests;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FulfillResult)) return false;
            FulfillResult fulfillResult = (FulfillResult)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = fulfillResult.pendingRequests();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FulfillResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FulfillResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public FulfillResult copy(Chunk<RunloopCommand.Request> pendingRequests) {
            return new FulfillResult(pendingRequests);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }
    }

    public static final class PollResult
    implements Product,
    Serializable {
        private final ConsumerRecords records;
        private final scala.collection.immutable.Set ignoreRecordsForTps;
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;

        public static PollResult apply(ConsumerRecords<byte[], byte[]> consumerRecords, scala.collection.immutable.Set<TopicPartition> set, Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2) {
            return Runloop$PollResult$.MODULE$.apply(consumerRecords, set, chunk, chunk2);
        }

        public static PollResult fromProduct(Product product) {
            return Runloop$PollResult$.MODULE$.fromProduct(product);
        }

        public static PollResult unapply(PollResult pollResult) {
            return Runloop$PollResult$.MODULE$.unapply(pollResult);
        }

        public PollResult(ConsumerRecords<byte[], byte[]> records, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            this.records = records;
            this.ignoreRecordsForTps = ignoreRecordsForTps;
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PollResult)) return false;
            PollResult pollResult = (PollResult)object;
            ConsumerRecords<byte[], byte[]> consumerRecords = this.records();
            ConsumerRecords<byte[], byte[]> consumerRecords2 = pollResult.records();
            if (consumerRecords == null) {
                if (consumerRecords2 != null) {
                    return false;
                }
            } else if (!consumerRecords.equals(consumerRecords2)) return false;
            scala.collection.immutable.Set<TopicPartition> set = this.ignoreRecordsForTps();
            scala.collection.immutable.Set<TopicPartition> set2 = pollResult.ignoreRecordsForTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = pollResult.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = pollResult.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 == null) return true;
                return false;
            } else {
                if (!chunk3.equals(chunk4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PollResult;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PollResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "records";
                }
                case 1: {
                    return "ignoreRecordsForTps";
                }
                case 2: {
                    return "pendingRequests";
                }
                case 3: {
                    return "assignedStreams";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ConsumerRecords<byte[], byte[]> records() {
            return this.records;
        }

        public scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps() {
            return this.ignoreRecordsForTps;
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public PollResult copy(ConsumerRecords<byte[], byte[]> records, scala.collection.immutable.Set<TopicPartition> ignoreRecordsForTps, Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            return new PollResult(records, ignoreRecordsForTps, pendingRequests, assignedStreams);
        }

        public ConsumerRecords<byte[], byte[]> copy$default$1() {
            return this.records();
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$2() {
            return this.ignoreRecordsForTps();
        }

        public Chunk<RunloopCommand.Request> copy$default$3() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$4() {
            return this.assignedStreams();
        }

        public ConsumerRecords<byte[], byte[]> _1() {
            return this.records();
        }

        public scala.collection.immutable.Set<TopicPartition> _2() {
            return this.ignoreRecordsForTps();
        }

        public Chunk<RunloopCommand.Request> _3() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _4() {
            return this.assignedStreams();
        }
    }

    public static final class RebalanceEvent
    implements Product,
    Serializable {
        private final boolean wasInvoked;
        private final scala.collection.immutable.Set assignedTps;
        private final scala.collection.immutable.Set revokedTps;
        private final scala.collection.immutable.Set lostTps;
        private final Chunk endedStreams;

        public static RebalanceEvent None() {
            return Runloop$RebalanceEvent$.MODULE$.None();
        }

        public static RebalanceEvent apply(boolean bl, scala.collection.immutable.Set<TopicPartition> set, scala.collection.immutable.Set<TopicPartition> set2, scala.collection.immutable.Set<TopicPartition> set3, Chunk<PartitionStreamControl> chunk) {
            return Runloop$RebalanceEvent$.MODULE$.apply(bl, set, set2, set3, chunk);
        }

        public static RebalanceEvent fromProduct(Product product) {
            return Runloop$RebalanceEvent$.MODULE$.fromProduct(product);
        }

        public static RebalanceEvent unapply(RebalanceEvent rebalanceEvent) {
            return Runloop$RebalanceEvent$.MODULE$.unapply(rebalanceEvent);
        }

        public RebalanceEvent(boolean wasInvoked, scala.collection.immutable.Set<TopicPartition> assignedTps, scala.collection.immutable.Set<TopicPartition> revokedTps, scala.collection.immutable.Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            this.wasInvoked = wasInvoked;
            this.assignedTps = assignedTps;
            this.revokedTps = revokedTps;
            this.lostTps = lostTps;
            this.endedStreams = endedStreams;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.wasInvoked() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.assignedTps()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.revokedTps()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lostTps()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.endedStreams()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RebalanceEvent)) return false;
            RebalanceEvent rebalanceEvent = (RebalanceEvent)object;
            if (this.wasInvoked() != rebalanceEvent.wasInvoked()) return false;
            scala.collection.immutable.Set<TopicPartition> set = this.assignedTps();
            scala.collection.immutable.Set<TopicPartition> set2 = rebalanceEvent.assignedTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            scala.collection.immutable.Set<TopicPartition> set3 = this.revokedTps();
            scala.collection.immutable.Set<TopicPartition> set4 = rebalanceEvent.revokedTps();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            scala.collection.immutable.Set<TopicPartition> set5 = this.lostTps();
            scala.collection.immutable.Set<TopicPartition> set6 = rebalanceEvent.lostTps();
            if (set5 == null) {
                if (set6 != null) {
                    return false;
                }
            } else if (!set5.equals(set6)) return false;
            Chunk<PartitionStreamControl> chunk = this.endedStreams();
            Chunk<PartitionStreamControl> chunk2 = rebalanceEvent.endedStreams();
            if (chunk == null) {
                if (chunk2 == null) return true;
                return false;
            } else {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RebalanceEvent;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "RebalanceEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "wasInvoked";
                }
                case 1: {
                    return "assignedTps";
                }
                case 2: {
                    return "revokedTps";
                }
                case 3: {
                    return "lostTps";
                }
                case 4: {
                    return "endedStreams";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean wasInvoked() {
            return this.wasInvoked;
        }

        public scala.collection.immutable.Set<TopicPartition> assignedTps() {
            return this.assignedTps;
        }

        public scala.collection.immutable.Set<TopicPartition> revokedTps() {
            return this.revokedTps;
        }

        public scala.collection.immutable.Set<TopicPartition> lostTps() {
            return this.lostTps;
        }

        public Chunk<PartitionStreamControl> endedStreams() {
            return this.endedStreams;
        }

        public RebalanceEvent onAssigned(scala.collection.immutable.Set<TopicPartition> assigned, Chunk<PartitionStreamControl> endedStreams) {
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)this.assignedTps().$plus$plus(assigned);
            Chunk chunk = this.endedStreams().$plus$plus(endedStreams);
            scala.collection.immutable.Set<TopicPartition> set2 = this.copy$default$3();
            scala.collection.immutable.Set<TopicPartition> set3 = this.copy$default$4();
            return this.copy(true, (scala.collection.immutable.Set<TopicPartition>)set, set2, set3, (Chunk<PartitionStreamControl>)chunk);
        }

        public RebalanceEvent onRevoked(scala.collection.immutable.Set<TopicPartition> revoked, Chunk<PartitionStreamControl> endedStreams) {
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)this.revokedTps().$plus$plus(revoked);
            Chunk chunk = this.endedStreams().$plus$plus(endedStreams);
            scala.collection.immutable.Set<TopicPartition> set2 = this.copy$default$2();
            scala.collection.immutable.Set<TopicPartition> set3 = this.copy$default$4();
            return this.copy(true, set2, (scala.collection.immutable.Set<TopicPartition>)set, set3, (Chunk<PartitionStreamControl>)chunk);
        }

        public RebalanceEvent onLost(scala.collection.immutable.Set<TopicPartition> lost) {
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)this.lostTps().$plus$plus(lost);
            scala.collection.immutable.Set<TopicPartition> set2 = this.copy$default$2();
            scala.collection.immutable.Set<TopicPartition> set3 = this.copy$default$3();
            Chunk<PartitionStreamControl> chunk = this.copy$default$5();
            return this.copy(true, set2, set3, (scala.collection.immutable.Set<TopicPartition>)set, chunk);
        }

        public RebalanceEvent copy(boolean wasInvoked, scala.collection.immutable.Set<TopicPartition> assignedTps, scala.collection.immutable.Set<TopicPartition> revokedTps, scala.collection.immutable.Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            return new RebalanceEvent(wasInvoked, assignedTps, revokedTps, lostTps, endedStreams);
        }

        public boolean copy$default$1() {
            return this.wasInvoked();
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$2() {
            return this.assignedTps();
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$3() {
            return this.revokedTps();
        }

        public scala.collection.immutable.Set<TopicPartition> copy$default$4() {
            return this.lostTps();
        }

        public Chunk<PartitionStreamControl> copy$default$5() {
            return this.endedStreams();
        }

        public boolean _1() {
            return this.wasInvoked();
        }

        public scala.collection.immutable.Set<TopicPartition> _2() {
            return this.assignedTps();
        }

        public scala.collection.immutable.Set<TopicPartition> _3() {
            return this.revokedTps();
        }

        public scala.collection.immutable.Set<TopicPartition> _4() {
            return this.lostTps();
        }

        public Chunk<PartitionStreamControl> _5() {
            return this.endedStreams();
        }
    }

    public static final class RevokeResult
    implements Product,
    Serializable {
        private final Chunk pendingRequests;
        private final Chunk assignedStreams;

        public static RevokeResult apply(Chunk<RunloopCommand.Request> chunk, Chunk<PartitionStreamControl> chunk2) {
            return Runloop$RevokeResult$.MODULE$.apply(chunk, chunk2);
        }

        public static RevokeResult fromProduct(Product product) {
            return Runloop$RevokeResult$.MODULE$.fromProduct(product);
        }

        public static RevokeResult unapply(RevokeResult revokeResult) {
            return Runloop$RevokeResult$.MODULE$.unapply(revokeResult);
        }

        public RevokeResult(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            this.pendingRequests = pendingRequests;
            this.assignedStreams = assignedStreams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokeResult)) return false;
            RevokeResult revokeResult = (RevokeResult)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = revokeResult.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<PartitionStreamControl> chunk3 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk4 = revokeResult.assignedStreams();
            if (chunk3 == null) {
                if (chunk4 == null) return true;
                return false;
            } else {
                if (!chunk3.equals(chunk4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokeResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokeResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingRequests";
            }
            if (1 == n2) {
                return "assignedStreams";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public RevokeResult copy(Chunk<RunloopCommand.Request> pendingRequests, Chunk<PartitionStreamControl> assignedStreams) {
            return new RevokeResult(pendingRequests, assignedStreams);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> copy$default$2() {
            return this.assignedStreams();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }

        public Chunk<PartitionStreamControl> _2() {
            return this.assignedStreams();
        }
    }

    public static final class State
    implements Product,
    Serializable {
        private final Chunk pendingRequests;
        private final Chunk pendingCommits;
        private final Chunk assignedStreams;
        private final SubscriptionState subscriptionState;

        public static State apply(Chunk<RunloopCommand.Request> chunk, Chunk<Commit> chunk2, Chunk<PartitionStreamControl> chunk3, SubscriptionState subscriptionState) {
            return Runloop$State$.MODULE$.apply(chunk, chunk2, chunk3, subscriptionState);
        }

        public static State fromProduct(Product product) {
            return Runloop$State$.MODULE$.fromProduct(product);
        }

        public static State initial() {
            return Runloop$State$.MODULE$.initial();
        }

        public static State unapply(State state) {
            return Runloop$State$.MODULE$.unapply(state);
        }

        public State(Chunk<RunloopCommand.Request> pendingRequests, Chunk<Commit> pendingCommits, Chunk<PartitionStreamControl> assignedStreams, SubscriptionState subscriptionState) {
            this.pendingRequests = pendingRequests;
            this.pendingCommits = pendingCommits;
            this.assignedStreams = assignedStreams;
            this.subscriptionState = subscriptionState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            Chunk<RunloopCommand.Request> chunk = this.pendingRequests();
            Chunk<RunloopCommand.Request> chunk2 = state.pendingRequests();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Chunk<Commit> chunk3 = this.pendingCommits();
            Chunk<Commit> chunk4 = state.pendingCommits();
            if (chunk3 == null) {
                if (chunk4 != null) {
                    return false;
                }
            } else if (!chunk3.equals(chunk4)) return false;
            Chunk<PartitionStreamControl> chunk5 = this.assignedStreams();
            Chunk<PartitionStreamControl> chunk6 = state.assignedStreams();
            if (chunk5 == null) {
                if (chunk6 != null) {
                    return false;
                }
            } else if (!chunk5.equals(chunk6)) return false;
            SubscriptionState subscriptionState = this.subscriptionState();
            SubscriptionState subscriptionState2 = state.subscriptionState();
            if (subscriptionState == null) {
                if (subscriptionState2 == null) return true;
                return false;
            } else {
                if (!subscriptionState.equals(subscriptionState2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pendingRequests";
                }
                case 1: {
                    return "pendingCommits";
                }
                case 2: {
                    return "assignedStreams";
                }
                case 3: {
                    return "subscriptionState";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RunloopCommand.Request> pendingRequests() {
            return this.pendingRequests;
        }

        public Chunk<Commit> pendingCommits() {
            return this.pendingCommits;
        }

        public Chunk<PartitionStreamControl> assignedStreams() {
            return this.assignedStreams;
        }

        public SubscriptionState subscriptionState() {
            return this.subscriptionState;
        }

        public State addPendingCommits(Chunk<Commit> c) {
            Chunk chunk = this.pendingCommits().$plus$plus(c);
            Chunk<RunloopCommand.Request> chunk2 = this.copy$default$1();
            Chunk<PartitionStreamControl> chunk3 = this.copy$default$3();
            SubscriptionState subscriptionState = this.copy$default$4();
            return this.copy(chunk2, (Chunk<Commit>)chunk, chunk3, subscriptionState);
        }

        public State addRequest(RunloopCommand.Request r) {
            return this.copy((Chunk<RunloopCommand.Request>)((Chunk)this.pendingRequests().$colon$plus((Object)r)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public boolean shouldPoll() {
            return this.subscriptionState().isSubscribed() && (this.pendingRequests().nonEmpty() || this.pendingCommits().nonEmpty() || this.assignedStreams().isEmpty());
        }

        public State copy(Chunk<RunloopCommand.Request> pendingRequests, Chunk<Commit> pendingCommits, Chunk<PartitionStreamControl> assignedStreams, SubscriptionState subscriptionState) {
            return new State(pendingRequests, pendingCommits, assignedStreams, subscriptionState);
        }

        public Chunk<RunloopCommand.Request> copy$default$1() {
            return this.pendingRequests();
        }

        public Chunk<Commit> copy$default$2() {
            return this.pendingCommits();
        }

        public Chunk<PartitionStreamControl> copy$default$3() {
            return this.assignedStreams();
        }

        public SubscriptionState copy$default$4() {
            return this.subscriptionState();
        }

        public Chunk<RunloopCommand.Request> _1() {
            return this.pendingRequests();
        }

        public Chunk<Commit> _2() {
            return this.pendingCommits();
        }

        public Chunk<PartitionStreamControl> _3() {
            return this.assignedStreams();
        }

        public SubscriptionState _4() {
            return this.subscriptionState();
        }
    }

    public static final class StreamOps<R, E, A> {
        private final ZStream stream;

        public static <R, E, A> boolean equals$extension(ZStream zStream, Object object) {
            return Runloop$StreamOps$.MODULE$.equals$extension(zStream, object);
        }

        public static <R, E, A> int hashCode$extension(ZStream zStream) {
            return Runloop$StreamOps$.MODULE$.hashCode$extension(zStream);
        }

        public static <R1 extends R, E1, S, R, E, A> ZIO<R1, E1, BoxedUnit> runFoldChunksDiscardZIO$extension(ZStream zStream, S s, Function2<S, Chunk<A>, ZIO<R1, E1, S>> function2) {
            return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(zStream, s, function2);
        }

        public StreamOps(ZStream<R, E, A> stream) {
            this.stream = stream;
        }

        public int hashCode() {
            return Runloop$StreamOps$.MODULE$.hashCode$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream());
        }

        public boolean equals(Object x$0) {
            return Runloop$StreamOps$.MODULE$.equals$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream(), x$0);
        }

        public ZStream<R, E, A> zio$kafka$consumer$internal$Runloop$StreamOps$$stream() {
            return this.stream;
        }

        public <R1 extends R, E1, S> ZIO<R1, E1, BoxedUnit> runFoldChunksDiscardZIO(S s, Function2<S, Chunk<A>, ZIO<R1, E1, S>> f) {
            return Runloop$StreamOps$.MODULE$.runFoldChunksDiscardZIO$extension(this.zio$kafka$consumer$internal$Runloop$StreamOps$$stream(), s, f);
        }
    }
}

