/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZIOAspect;
import zio.kafka.consumer.internal.ConsumerMetrics;
import zio.kafka.consumer.internal.Runloop;
import zio.kafka.consumer.internal.SubscriptionState;
import zio.metrics.Metric;
import zio.metrics.Metric$;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricLabel;
import zio.metrics.MetricState;

public class ZioConsumerMetrics
implements ConsumerMetrics {
    private final Set<MetricLabel> metricLabels;
    private final MetricKeyType.Histogram.Boundaries pollLatencyBoundaries;
    private final MetricKeyType.Histogram.Boundaries pollSizeBoundaries;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> pollCounter;
    private final Metric<MetricKeyType$Gauge$, Object, MetricState.Gauge> partitionsResumedInLatestPollGauge;
    private final Metric<MetricKeyType$Gauge$, Object, MetricState.Gauge> partitionsPausedInLatestPollGauge;
    private final Metric<MetricKeyType.Histogram, Duration, MetricState.Histogram> pollLatencyHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> pollSizeHistogram;
    private final MetricKeyType.Histogram.Boundaries commitLatencyBoundaries;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> commitCounter;
    private final Metric<MetricKeyType.Histogram, Duration, MetricState.Histogram> commitLatencyHistogram;
    private final MetricKeyType.Histogram.Boundaries aggregatedCommitLatencyBoundaries;
    private final MetricKeyType.Histogram.Boundaries aggregatedCommitSizeBoundaries;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> aggregatedCommitCounter;
    private final Metric<MetricKeyType.Histogram, Duration, MetricState.Histogram> aggregatedCommitLatencyHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> aggregatedCommitSizeHistogram;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> rebalanceCounter;
    private final Metric<MetricKeyType$Gauge$, Object, MetricState.Gauge> partitionsCurrentlyAssignedGauge;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> partitionsAssignedCounter;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> partitionsRevokedCounter;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> partitionsLostCounter;
    private final MetricKeyType.Histogram.Boundaries streamCountBoundaries;
    private final MetricKeyType.Histogram.Boundaries streamSizeBoundaries;
    private final MetricKeyType.Histogram.Boundaries queuePollSizeBoundaries;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> pendingRequestsHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> pendingCommitsHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> queueSizeHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> queuePollsHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> allQueueSizeHistogram;
    private final Metric<MetricKeyType$Gauge$, SubscriptionState, MetricState.Gauge> subscriptionStateGauge;
    private final MetricKeyType.Histogram.Boundaries commandAndCommitQueueSizeBoundaries;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> commandQueueSizeHistogram;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> commitQueueSizeHistogram;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> pollAuthErrorCounter;

    public ZioConsumerMetrics(Set<MetricLabel> metricLabels) {
        this.metricLabels = metricLabels;
        this.pollLatencyBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)0.01), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$1 -> _$1 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)d -> Math.ceil(d * 100.0) / 100.0));
        this.pollSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)1.0), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$2 -> _$2 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0)));
        this.pollCounter = Metric$.MODULE$.counterInt("ziokafka_consumer_polls", "The number of polls.").tagged(metricLabels);
        this.partitionsResumedInLatestPollGauge = Metric$.MODULE$.gauge("ziokafka_consumer_partitions_resumed_in_latest_poll", "The number of partitions resumed in the latest poll call.").contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$3 -> _$3).tagged(metricLabels);
        this.partitionsPausedInLatestPollGauge = Metric$.MODULE$.gauge("ziokafka_consumer_partitions_paused_in_latest_poll", "The number of partitions paused in the latest poll call (because of backpressure).").contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$4 -> _$4).tagged(metricLabels);
        this.pollLatencyHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_poll_latency_seconds", "The duration of a single poll in seconds.", this.pollLatencyBoundaries()).contramap((Function1 & Serializable)_$5 -> (double)_$5.toNanos() / 1.0E9).tagged(metricLabels);
        this.pollSizeHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_poll_size", "The number of records fetched by a single poll.", this.pollSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$6 -> _$6).tagged(metricLabels);
        this.commitLatencyBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)0.01), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$7 -> _$7 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)d -> Math.ceil(d * 100.0) / 100.0));
        this.commitCounter = Metric$.MODULE$.counterInt("ziokafka_consumer_commits", "The number of commits.").tagged(metricLabels);
        this.commitLatencyHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_commit_latency_seconds", "The duration of a commit in seconds.", this.commitLatencyBoundaries()).contramap((Function1 & Serializable)_$8 -> (double)_$8.toNanos() / 1.0E9).tagged(metricLabels);
        this.aggregatedCommitLatencyBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)0.01), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$9 -> _$9 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)d -> Math.ceil(d * 100.0) / 100.0));
        this.aggregatedCommitSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)1.0), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$10 -> _$10 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0)));
        this.aggregatedCommitCounter = Metric$.MODULE$.counterInt("ziokafka_consumer_aggregated_commits", "The number of aggregated commits.").tagged(metricLabels);
        this.aggregatedCommitLatencyHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_aggregated_commit_latency_seconds", "The duration of an aggregated commit in seconds.", this.aggregatedCommitLatencyBoundaries()).contramap((Function1 & Serializable)_$11 -> (double)_$11.toNanos() / 1.0E9).tagged(metricLabels);
        this.aggregatedCommitSizeHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_aggregated_commit_size", "An approximation of the number of records (offsets) per aggregated commit.", this.aggregatedCommitSizeBoundaries()).contramap((Function1)(JFunction1.mcDJ.sp & Serializable)_$12 -> _$12).tagged(metricLabels);
        this.rebalanceCounter = Metric$.MODULE$.counterInt("ziokafka_consumer_rebalances", "The number of rebalances.").tagged(metricLabels);
        this.partitionsCurrentlyAssignedGauge = Metric$.MODULE$.gauge("ziokafka_consumer_partitions_currently_assigned", "The number of partitions currently assigned to the consumer.").contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$13 -> _$13).tagged(metricLabels);
        this.partitionsAssignedCounter = this.partitionsToStateCounter("assigned");
        this.partitionsRevokedCounter = this.partitionsToStateCounter("revoked");
        this.partitionsLostCounter = this.partitionsToStateCounter("lost");
        this.streamCountBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0})).$plus$plus(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)1.0), 9, (Function1)(JFunction1.mcDD.sp & Serializable)_$14 -> _$14 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0))));
        this.streamSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0})).$plus$plus(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)100.0), 9, (Function1)(JFunction1.mcDD.sp & Serializable)_$15 -> _$15 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0))));
        this.queuePollSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0})));
        this.pendingRequestsHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_pending_requests", "The number of partitions that ran out of records (the queue is empty).", this.streamCountBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$16 -> _$16).tagged(metricLabels);
        this.pendingCommitsHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_pending_commits", "The number of commits that are awaiting completion.", this.streamCountBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$17 -> _$17).tagged(metricLabels);
        this.queueSizeHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_queue_size", "The number of records queued for a partition.", this.streamSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$18 -> _$18).tagged(metricLabels);
        this.queuePollsHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_queue_polls", "The number of polls during which records are idling in a queue.", this.queuePollSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$19 -> _$19).tagged(metricLabels);
        this.allQueueSizeHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_all_queue_size", "The total number of records queued for all partitions.", this.streamSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$20 -> _$20).tagged(metricLabels);
        this.subscriptionStateGauge = Metric$.MODULE$.gauge("ziokafka_consumer_subscription_state", "Whether the consumer is subscribed (1) or not (0).").contramap((Function1 & Serializable)s -> {
            if (s.isSubscribed()) {
                return 1.0;
            }
            return 0.0;
        }).tagged(metricLabels);
        this.commandAndCommitQueueSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0})).$plus$plus(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)1.0), 9, (Function1)(JFunction1.mcDD.sp & Serializable)_$21 -> _$21 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0))));
        this.commandQueueSizeHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_command_queue_size", "The number of commands queued in the consumer.", this.commandAndCommitQueueSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$22 -> _$22).tagged(metricLabels);
        this.commitQueueSizeHistogram = Metric$.MODULE$.histogram("ziokafka_consumer_commit_queue_size", "The number of commits queued in the consumer.", this.commandAndCommitQueueSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$23 -> _$23).tagged(metricLabels);
        this.pollAuthErrorCounter = Metric$.MODULE$.counterInt("ziokafka_consumer_poll_auth_errors", "The number of polls that ended with an authentication or authorization error.").tagged(metricLabels);
    }

    public MetricKeyType.Histogram.Boundaries pollLatencyBoundaries() {
        return this.pollLatencyBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries pollSizeBoundaries() {
        return this.pollSizeBoundaries;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observePoll(int resumedCount, int pausedCount, Duration latency, int pollSize) {
        return Metric$.MODULE$.CounterSyntax(this.pollCounter).increment((Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.partitionsResumedInLatestPollGauge.update(() -> ZioConsumerMetrics.observePoll$$anonfun$1$$anonfun$1(resumedCount), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:99)").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.partitionsPausedInLatestPollGauge.update(() -> ZioConsumerMetrics.observePoll$$anonfun$1$$anonfun$2$$anonfun$1(pausedCount), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:100)").flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.pollLatencyHistogram.update(() -> ZioConsumerMetrics.observePoll$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(latency), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:101)").flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.pollSizeHistogram.update(() -> ZioConsumerMetrics.observePoll$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(pollSize), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:102)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:103)");
                    }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:103)");
                }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:103)");
            }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:103)");
        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observePoll(ConsumerMetrics.scala:103)");
    }

    public MetricKeyType.Histogram.Boundaries commitLatencyBoundaries() {
        return this.commitLatencyBoundaries;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeCommit(Duration latency) {
        return Metric$.MODULE$.CounterSyntax(this.commitCounter).increment((Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.commitLatencyHistogram.update(() -> ZioConsumerMetrics.observeCommit$$anonfun$1$$anonfun$1(latency), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeCommit(ConsumerMetrics.scala:135)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeCommit(ConsumerMetrics.scala:136)");
        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeCommit(ConsumerMetrics.scala:136)");
    }

    public MetricKeyType.Histogram.Boundaries aggregatedCommitLatencyBoundaries() {
        return this.aggregatedCommitLatencyBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries aggregatedCommitSizeBoundaries() {
        return this.aggregatedCommitSizeBoundaries;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeAggregatedCommit(Duration latency, long commitSize) {
        return Metric$.MODULE$.CounterSyntax(this.aggregatedCommitCounter).increment((Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.aggregatedCommitLatencyHistogram.update(() -> ZioConsumerMetrics.observeAggregatedCommit$$anonfun$1$$anonfun$1(latency), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeAggregatedCommit(ConsumerMetrics.scala:185)").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.aggregatedCommitSizeHistogram.update(() -> ZioConsumerMetrics.observeAggregatedCommit$$anonfun$1$$anonfun$2$$anonfun$1(commitSize), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeAggregatedCommit(ConsumerMetrics.scala:186)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeAggregatedCommit(ConsumerMetrics.scala:187)");
            }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeAggregatedCommit(ConsumerMetrics.scala:187)");
        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeAggregatedCommit(ConsumerMetrics.scala:187)");
    }

    private Metric<MetricKeyType$Counter$, Object, MetricState.Counter> partitionsToStateCounter(String state) {
        return Metric$.MODULE$.counterInt(new StringBuilder(29).append("ziokafka_consumer_partitions_").append(state).toString(), new StringBuilder(42).append("The number of partitions ").append(state).append(" to the consumer.").toString()).tagged(this.metricLabels);
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeRebalance(int currentlyAssignedCount, int assignedCount, int revokedCount, int lostCount) {
        return Metric$.MODULE$.CounterSyntax(this.rebalanceCounter).increment((Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.partitionsCurrentlyAssignedGauge.update(() -> ZioConsumerMetrics.observeRebalance$$anonfun$1$$anonfun$1(currentlyAssignedCount), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRebalance(ConsumerMetrics.scala:228)").flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Metric$.MODULE$.CounterSyntax(this.partitionsAssignedCounter).incrementBy(() -> ZioConsumerMetrics.observeRebalance$$anonfun$1$$anonfun$2$$anonfun$1(assignedCount), (Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Metric$.MODULE$.CounterSyntax(this.partitionsRevokedCounter).incrementBy(() -> ZioConsumerMetrics.observeRebalance$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(revokedCount), (Numeric)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Metric$.MODULE$.CounterSyntax(this.partitionsLostCounter).incrementBy(() -> ZioConsumerMetrics.observeRebalance$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(lostCount), (Numeric)Numeric.IntIsIntegral$.MODULE$).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRebalance(ConsumerMetrics.scala:232)");
                    }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRebalance(ConsumerMetrics.scala:232)");
                }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRebalance(ConsumerMetrics.scala:232)");
            }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRebalance(ConsumerMetrics.scala:232)");
        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRebalance(ConsumerMetrics.scala:232)");
    }

    public MetricKeyType.Histogram.Boundaries streamCountBoundaries() {
        return this.streamCountBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries streamSizeBoundaries() {
        return this.streamSizeBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries queuePollSizeBoundaries() {
        return this.queuePollSizeBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries commandAndCommitQueueSizeBoundaries() {
        return this.commandAndCommitQueueSizeBoundaries;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeRunloopMetrics(Runloop.State state, int commandQueueSize, int commitQueueSize) {
        return ZIO$.MODULE$.foreachDiscard(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$1(state), (Function1 & Serializable)_$24 -> _$24.outstandingPolls().$at$at(this::observeRunloopMetrics$$anonfun$2$$anonfun$1, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:335)"), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:335)").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ZIO$.MODULE$.foreach(state.assignedStreams(), (Function1 & Serializable)_$25 -> _$25.queueSize(), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:336)").flatMap((Function1 & Serializable)queueSizes -> ZIO$.MODULE$.foreachDiscard(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$1(queueSizes), (Function1 & Serializable)qs -> this.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$2(BoxesRunTime.unboxToInt((Object)qs)), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:337)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.allQueueSizeHistogram.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1(queueSizes), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:338)").flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.pendingRequestsHistogram.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(state), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:339)").flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.pendingCommitsHistogram.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(state), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:340)").flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.subscriptionStateGauge.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(state), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:341)").flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return this.commandQueueSizeHistogram.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(commandQueueSize), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:342)").flatMap((Function1 & Serializable)x$12 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return this.commitQueueSizeHistogram.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(commitQueueSize), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:343)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
                                }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
                            }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
                        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
                    }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
                }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
            }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)"), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
        }, (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:344)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observePollAuthError() {
        return Metric$.MODULE$.CounterSyntax(this.pollAuthErrorCounter).increment((Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    private static final int observePoll$$anonfun$1$$anonfun$1(int resumedCount$2) {
        return resumedCount$2;
    }

    private static final int observePoll$$anonfun$1$$anonfun$2$$anonfun$1(int pausedCount$3) {
        return pausedCount$3;
    }

    private static final Duration observePoll$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Duration latency$4) {
        return latency$4;
    }

    private static final int observePoll$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(int pollSize$5) {
        return pollSize$5;
    }

    private static final Duration observeCommit$$anonfun$1$$anonfun$1(Duration latency$6) {
        return latency$6;
    }

    private static final Duration observeAggregatedCommit$$anonfun$1$$anonfun$1(Duration latency$8) {
        return latency$8;
    }

    private static final long observeAggregatedCommit$$anonfun$1$$anonfun$2$$anonfun$1(long commitSize$3) {
        return commitSize$3;
    }

    private static final int observeRebalance$$anonfun$1$$anonfun$1(int currentlyAssignedCount$2) {
        return currentlyAssignedCount$2;
    }

    private static final int observeRebalance$$anonfun$1$$anonfun$2$$anonfun$1(int assignedCount$3) {
        return assignedCount$3;
    }

    private static final int observeRebalance$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(int revokedCount$4) {
        return revokedCount$4;
    }

    private static final int observeRebalance$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(int lostCount$5) {
        return lostCount$5;
    }

    private static final Iterable observeRunloopMetrics$$anonfun$1(Runloop.State state$1) {
        return state$1.assignedStreams();
    }

    private final ZIOAspect observeRunloopMetrics$$anonfun$2$$anonfun$1() {
        return this.queuePollsHistogram;
    }

    private static final Iterable observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$1(Chunk queueSizes$1) {
        return queueSizes$1;
    }

    private static final int observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(int qs$1) {
        return qs$1;
    }

    private final /* synthetic */ ZIO observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$2(int qs) {
        return this.queueSizeHistogram.update(() -> ZioConsumerMetrics.observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(qs), (Object)"zio.kafka.consumer.internal.ZioConsumerMetrics.observeRunloopMetrics(ConsumerMetrics.scala:337)");
    }

    private static final int observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$1(Chunk queueSizes$3) {
        return BoxesRunTime.unboxToInt((Object)queueSizes$3.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private static final int observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(Runloop.State state$6) {
        return state$6.pendingRequests().size();
    }

    private static final int observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(Runloop.State state$8) {
        return state$8.pendingCommits().size();
    }

    private static final SubscriptionState observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Runloop.State state$10) {
        return state$10.subscriptionState();
    }

    private static final int observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(int commandQueueSize$8) {
        return commandQueueSize$8;
    }

    private static final int observeRunloopMetrics$$anonfun$3$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(int commitQueueSize$9) {
        return commitQueueSize$9;
    }
}

