/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.ZIO;
import zio.kafka.consumer.internal.Committer$;
import zio.kafka.consumer.internal.Committer$CommitOffsets$;
import zio.kafka.consumer.internal.LiveCommitter;

public interface Committer {
    public Function1<Map<TopicPartition, OffsetAndMetadata>, ZIO<Object, Throwable, BoxedUnit>> commit();

    public ZIO<Object, Throwable, BoxedUnit> processQueuedCommits(Consumer<byte[], byte[]> var1, boolean var2);

    public static boolean processQueuedCommits$default$2$(Committer $this) {
        return $this.processQueuedCommits$default$2();
    }

    default public boolean processQueuedCommits$default$2() {
        return false;
    }

    public ZIO<Object, Nothing$, Object> queueSize();

    public ZIO<Object, Nothing$, Object> pendingCommitCount();

    public ZIO<Object, Nothing$, CommitOffsets> getPendingCommits();

    public ZIO<Object, Nothing$, BoxedUnit> cleanupPendingCommits();

    public ZIO<Object, Nothing$, BoxedUnit> keepCommitsForPartitions(Set<TopicPartition> var1);

    public ZIO<Object, Nothing$, CommitOffsets> getCommittedOffsets();

    public static final class CommitOffsets
    implements Product,
    Serializable {
        private final Map offsets;

        public static CommitOffsets apply(Map<TopicPartition, Object> map) {
            return Committer$CommitOffsets$.MODULE$.apply(map);
        }

        public static CommitOffsets empty() {
            return Committer$CommitOffsets$.MODULE$.empty();
        }

        public static CommitOffsets fromProduct(Product product) {
            return Committer$CommitOffsets$.MODULE$.fromProduct(product);
        }

        public static CommitOffsets unapply(CommitOffsets commitOffsets) {
            return Committer$CommitOffsets$.MODULE$.unapply(commitOffsets);
        }

        public CommitOffsets(Map<TopicPartition, Object> offsets) {
            this.offsets = offsets;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommitOffsets)) return false;
            CommitOffsets commitOffsets = (CommitOffsets)object;
            Map<TopicPartition, Object> map = this.offsets();
            Map<TopicPartition, Object> map2 = commitOffsets.offsets();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommitOffsets;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CommitOffsets";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offsets";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<TopicPartition, Object> offsets() {
            return this.offsets;
        }

        public Tuple2<Object, CommitOffsets> addCommits(Chunk<LiveCommitter.Commit> c) {
            scala.collection.mutable.Map updatedOffsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            updatedOffsets.sizeHint(this.offsets().size());
            updatedOffsets.$plus$plus$eq(this.offsets());
            LongRef offsetIncrease = LongRef.create((long)0L);
            c.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Committer$.zio$kafka$consumer$internal$Committer$CommitOffsets$$_$addCommits$$anonfun$1(updatedOffsets, offsetIncrease, arg_0)));
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offsetIncrease.elem), (Object)Committer$CommitOffsets$.MODULE$.apply((Map<TopicPartition, Object>)updatedOffsets.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        }

        public CommitOffsets keepPartitions(Set<TopicPartition> tps) {
            return Committer$CommitOffsets$.MODULE$.apply((Map<TopicPartition, Object>)((Map)this.offsets().filter(arg_0 -> Committer$.zio$kafka$consumer$internal$Committer$CommitOffsets$$_$keepPartitions$$anonfun$1(tps, arg_0))));
        }

        public boolean contains(TopicPartition tp, long offset) {
            return this.offsets().get((Object)tp).exists((Function1)((JFunction1.mcZJ.sp & Serializable)arg_0 -> Committer$.zio$kafka$consumer$internal$Committer$CommitOffsets$$_$contains$$anonfun$1(offset, arg_0)));
        }

        public Option<Object> get(TopicPartition tp) {
            return this.offsets().get((Object)tp);
        }

        public CommitOffsets copy(Map<TopicPartition, Object> offsets) {
            return new CommitOffsets(offsets);
        }

        public Map<TopicPartition, Object> copy$default$1() {
            return this.offsets();
        }

        public Map<TopicPartition, Object> _1() {
            return this.offsets();
        }
    }
}

