/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.diagnostics;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import scala.Product;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Commit$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Poll$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Rebalance$;
import zio.kafka.consumer.diagnostics.DiagnosticEvent$Request$;

public interface DiagnosticEvent {
    public static int ordinal(DiagnosticEvent diagnosticEvent) {
        return DiagnosticEvent$.MODULE$.ordinal(diagnosticEvent);
    }

    public static interface Commit
    extends DiagnosticEvent {
        public static int ordinal(Commit commit) {
            return DiagnosticEvent$Commit$.MODULE$.ordinal(commit);
        }
    }

    public static final class Poll
    implements DiagnosticEvent,
    Product,
    Serializable {
        private final Set tpRequested;
        private final Set tpWithData;
        private final Set tpWithoutData;

        public static Poll apply(Set<TopicPartition> set, Set<TopicPartition> set2, Set<TopicPartition> set3) {
            return DiagnosticEvent$Poll$.MODULE$.apply(set, set2, set3);
        }

        public static Poll fromProduct(Product product) {
            return DiagnosticEvent$Poll$.MODULE$.fromProduct(product);
        }

        public static Poll unapply(Poll poll) {
            return DiagnosticEvent$Poll$.MODULE$.unapply(poll);
        }

        public Poll(Set<TopicPartition> tpRequested, Set<TopicPartition> tpWithData, Set<TopicPartition> tpWithoutData) {
            this.tpRequested = tpRequested;
            this.tpWithData = tpWithData;
            this.tpWithoutData = tpWithoutData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Poll)) return false;
            Poll poll = (Poll)object;
            Set<TopicPartition> set = this.tpRequested();
            Set<TopicPartition> set2 = poll.tpRequested();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<TopicPartition> set3 = this.tpWithData();
            Set<TopicPartition> set4 = poll.tpWithData();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            Set<TopicPartition> set5 = this.tpWithoutData();
            Set<TopicPartition> set6 = poll.tpWithoutData();
            if (set5 == null) {
                if (set6 == null) return true;
                return false;
            } else {
                if (!set5.equals(set6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Poll;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Poll";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tpRequested";
                }
                case 1: {
                    return "tpWithData";
                }
                case 2: {
                    return "tpWithoutData";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<TopicPartition> tpRequested() {
            return this.tpRequested;
        }

        public Set<TopicPartition> tpWithData() {
            return this.tpWithData;
        }

        public Set<TopicPartition> tpWithoutData() {
            return this.tpWithoutData;
        }

        public Poll copy(Set<TopicPartition> tpRequested, Set<TopicPartition> tpWithData, Set<TopicPartition> tpWithoutData) {
            return new Poll(tpRequested, tpWithData, tpWithoutData);
        }

        public Set<TopicPartition> copy$default$1() {
            return this.tpRequested();
        }

        public Set<TopicPartition> copy$default$2() {
            return this.tpWithData();
        }

        public Set<TopicPartition> copy$default$3() {
            return this.tpWithoutData();
        }

        public Set<TopicPartition> _1() {
            return this.tpRequested();
        }

        public Set<TopicPartition> _2() {
            return this.tpWithData();
        }

        public Set<TopicPartition> _3() {
            return this.tpWithoutData();
        }
    }

    public static final class Rebalance
    implements DiagnosticEvent,
    Product,
    Serializable {
        private final Set revoked;
        private final Set assigned;
        private final Set lost;
        private final Set ended;

        public static Rebalance apply(Set<TopicPartition> set, Set<TopicPartition> set2, Set<TopicPartition> set3, Set<TopicPartition> set4) {
            return DiagnosticEvent$Rebalance$.MODULE$.apply(set, set2, set3, set4);
        }

        public static Rebalance fromProduct(Product product) {
            return DiagnosticEvent$Rebalance$.MODULE$.fromProduct(product);
        }

        public static Rebalance unapply(Rebalance rebalance) {
            return DiagnosticEvent$Rebalance$.MODULE$.unapply(rebalance);
        }

        public Rebalance(Set<TopicPartition> revoked, Set<TopicPartition> assigned, Set<TopicPartition> lost, Set<TopicPartition> ended) {
            this.revoked = revoked;
            this.assigned = assigned;
            this.lost = lost;
            this.ended = ended;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Rebalance)) return false;
            Rebalance rebalance = (Rebalance)object;
            Set<TopicPartition> set = this.revoked();
            Set<TopicPartition> set2 = rebalance.revoked();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<TopicPartition> set3 = this.assigned();
            Set<TopicPartition> set4 = rebalance.assigned();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            Set<TopicPartition> set5 = this.lost();
            Set<TopicPartition> set6 = rebalance.lost();
            if (set5 == null) {
                if (set6 != null) {
                    return false;
                }
            } else if (!set5.equals(set6)) return false;
            Set<TopicPartition> set7 = this.ended();
            Set<TopicPartition> set8 = rebalance.ended();
            if (set7 == null) {
                if (set8 == null) return true;
                return false;
            } else {
                if (!set7.equals(set8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Rebalance;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Rebalance";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "revoked";
                }
                case 1: {
                    return "assigned";
                }
                case 2: {
                    return "lost";
                }
                case 3: {
                    return "ended";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<TopicPartition> revoked() {
            return this.revoked;
        }

        public Set<TopicPartition> assigned() {
            return this.assigned;
        }

        public Set<TopicPartition> lost() {
            return this.lost;
        }

        public Set<TopicPartition> ended() {
            return this.ended;
        }

        public Rebalance copy(Set<TopicPartition> revoked, Set<TopicPartition> assigned, Set<TopicPartition> lost, Set<TopicPartition> ended) {
            return new Rebalance(revoked, assigned, lost, ended);
        }

        public Set<TopicPartition> copy$default$1() {
            return this.revoked();
        }

        public Set<TopicPartition> copy$default$2() {
            return this.assigned();
        }

        public Set<TopicPartition> copy$default$3() {
            return this.lost();
        }

        public Set<TopicPartition> copy$default$4() {
            return this.ended();
        }

        public Set<TopicPartition> _1() {
            return this.revoked();
        }

        public Set<TopicPartition> _2() {
            return this.assigned();
        }

        public Set<TopicPartition> _3() {
            return this.lost();
        }

        public Set<TopicPartition> _4() {
            return this.ended();
        }
    }

    public static final class Request
    implements DiagnosticEvent,
    Product,
    Serializable {
        private final TopicPartition partition;

        public static Request apply(TopicPartition topicPartition) {
            return DiagnosticEvent$Request$.MODULE$.apply(topicPartition);
        }

        public static Request fromProduct(Product product) {
            return DiagnosticEvent$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return DiagnosticEvent$Request$.MODULE$.unapply(request);
        }

        public Request(TopicPartition partition) {
            this.partition = partition;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            TopicPartition topicPartition = this.partition();
            TopicPartition topicPartition2 = request.partition();
            if (topicPartition != null) {
                if (!topicPartition.equals(topicPartition2)) return false;
                return true;
            }
            if (topicPartition2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partition";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TopicPartition partition() {
            return this.partition;
        }

        public Request copy(TopicPartition partition) {
            return new Request(partition);
        }

        public TopicPartition copy$default$1() {
            return this.partition();
        }

        public TopicPartition _1() {
            return this.partition();
        }
    }
}

