/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.consumer.internal;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import zio.Chunk;
import zio.Chunk$;
import zio.DurationSyntax$;
import zio.Ref;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.consumer.ConsumerSettings;
import zio.kafka.consumer.Offset;
import zio.kafka.consumer.RebalanceListener;
import zio.kafka.consumer.RebalanceListener$;
import zio.kafka.consumer.internal.Committer;
import zio.kafka.consumer.internal.ConsumerAccess;
import zio.kafka.consumer.internal.PartitionStreamControl;
import zio.kafka.consumer.internal.RebalanceCoordinator$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetCommitPending$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetCommitted$;
import zio.kafka.consumer.internal.RebalanceCoordinator$EndOffsetNotCommitted$;
import zio.kafka.consumer.internal.RebalanceCoordinator$RebalanceCallback$;
import zio.kafka.consumer.internal.RebalanceCoordinator$RebalanceEvent$;
import zio.kafka.consumer.internal.RebalanceCoordinator$StreamCompletionStatus$;
import zio.kafka.consumer.internal.package$;
import zio.stream.ZStream$;

public class RebalanceCoordinator {
    private final Ref.Synchronized<RebalanceEvent> lastRebalanceEvent;
    private final ConsumerAccess consumer;
    private final Duration maxRebalanceDuration;
    private final ZIO<Object, Nothing$, Chunk<PartitionStreamControl>> getCurrentAssignedStreams;
    private final Committer committer;
    private final long commitTimeoutNanos;
    private final boolean rebalanceSafeCommits;
    private final Duration commitTimeout;
    private final Duration commitQueuePollInterval;

    public RebalanceCoordinator(Ref.Synchronized<RebalanceEvent> lastRebalanceEvent, ConsumerSettings settings, ConsumerAccess consumer, Duration maxRebalanceDuration, ZIO<Object, Nothing$, Chunk<PartitionStreamControl>> getCurrentAssignedStreams, Committer committer) {
        this.lastRebalanceEvent = lastRebalanceEvent;
        this.consumer = consumer;
        this.maxRebalanceDuration = maxRebalanceDuration;
        this.getCurrentAssignedStreams = getCurrentAssignedStreams;
        this.committer = committer;
        this.commitTimeoutNanos = settings.commitTimeout().toNanos();
        this.rebalanceSafeCommits = settings.rebalanceSafeCommits();
        this.commitTimeout = settings.commitTimeout();
        this.commitQueuePollInterval = DurationSyntax$.MODULE$.millis$extension(zio.package$.MODULE$.durationInt(100));
    }

    public ZIO<Object, Nothing$, RebalanceEvent> getAndResetLastEvent() {
        return this.lastRebalanceEvent.getAndSet((Object)RebalanceCoordinator$RebalanceEvent$.MODULE$.None(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.getAndResetLastEvent(RebalanceCoordinator.scala:41)");
    }

    private ZIO<Object, Throwable, Object> endStreams(Chunk<PartitionStreamControl> streamsToEnd) {
        return ZIO$.MODULE$.unless(() -> RebalanceCoordinator.endStreams$$anonfun$1(streamsToEnd), () -> this.endStreams$$anonfun$2(streamsToEnd), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:51)");
    }

    private ZIO<Object, Throwable, BoxedUnit> doAwaitStreamCommits(Consumer<byte[], byte[]> consumer, Chunk<PartitionStreamControl> streamsToEnd) {
        long deadline = System.nanoTime() + this.maxRebalanceDuration.toNanos() - this.commitTimeoutNanos;
        return this.logInitialStreamCompletionStatuses$1(streamsToEnd, deadline).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ZStream$.MODULE$.fromZIO(this::doAwaitStreamCommits$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:155)").forever((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:156)").tap((Function1 & Serializable)_$6 -> this.committer.processQueuedCommits(consumer, true), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:160)").takeWhile((Function1 & Serializable)_$7 -> System.nanoTime() <= deadline, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:161)").mapZIO((Function1 & Serializable)_$8 -> this.endingStreamsCompletedAndCommitsExist$1(streamsToEnd, deadline), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:162)").takeUntil((Function1 & Serializable)completed -> BoxesRunTime.unboxToBoolean((Object)completed), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:163)").runLast((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:164)").map((Function1 & Serializable)_$9 -> BoxesRunTime.unboxToBoolean((Object)_$9.getOrElse(RebalanceCoordinator::doAwaitStreamCommits$$anonfun$1$$anonfun$6$$anonfun$1)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:165)").flatMap((Function1 & Serializable)completed -> this.doAwaitStreamCommits$$anonfun$1$$anonfun$7(streamsToEnd, consumer, BoxesRunTime.unboxToBoolean((Object)completed)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:169)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:169)");
    }

    public RebalanceListener toRebalanceListener() {
        return RebalanceListener$.MODULE$.apply((Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)assignedTps -> this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug(() -> RebalanceCoordinator.toRebalanceListener$$anonfun$1$$anonfun$1$$anonfun$1(rebalanceEvent, assignedTps), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:192)").as(() -> RebalanceCoordinator.toRebalanceListener$$anonfun$1$$anonfun$1$$anonfun$2(rebalanceEvent, assignedTps), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:194)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:195)"), (Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)revokedTps -> this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug(() -> RebalanceCoordinator.toRebalanceListener$$anonfun$2$$anonfun$1$$anonfun$1(rebalanceEvent, revokedTps), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:202)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.getCurrentAssignedStreams.map((Function1 & Serializable)assignedStreams -> {
                Chunk streamsToEnd = assignedStreams.filter((Function1 & Serializable)control -> revokedTps.contains((Object)control.tp()));
                return Tuple2$.MODULE$.apply(assignedStreams, (Object)streamsToEnd);
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:204)").flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Chunk assignedStreams = (Chunk)tuple2._1();
                    Chunk streamsToEnd = (Chunk)tuple2._2();
                    return this.endStreams((Chunk<PartitionStreamControl>)streamsToEnd).flatMap((Function1 & Serializable)x$12 -> {
                        Object object = x$12;
                        return ZIO$.MODULE$.logTrace(RebalanceCoordinator::toRebalanceListener$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:206)").map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return rebalanceEvent.addCallback(RebalanceCoordinator$RebalanceCallback$.MODULE$.apply((Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)revokedTps, (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Chunk<PartitionStreamControl>)streamsToEnd));
                        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:207)");
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:207)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:207)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:207)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:208)"), (Function1<Set<TopicPartition>, ZIO<Object, Throwable, BoxedUnit>>)(Function1 & Serializable)lostTps -> this.lastRebalanceEvent.updateZIO((Function1 & Serializable)rebalanceEvent -> ZIO$.MODULE$.logDebug(() -> RebalanceCoordinator.toRebalanceListener$$anonfun$3$$anonfun$1$$anonfun$1(lostTps), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:212)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.getCurrentAssignedStreams.map((Function1 & Serializable)assignedStreams -> {
                Chunk lostStreams = assignedStreams.filter((Function1 & Serializable)control -> lostTps.contains((Object)control.tp()));
                return Tuple2$.MODULE$.apply(assignedStreams, (Object)lostStreams);
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:214)").flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Chunk assignedStreams = (Chunk)tuple2._1();
                    Chunk lostStreams = (Chunk)tuple2._2();
                    return ZIO$.MODULE$.foreachDiscard(() -> RebalanceCoordinator.toRebalanceListener$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(lostStreams), (Function1 & Serializable)_$10 -> _$10.lost(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:215)").flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return ZIO$.MODULE$.logTrace(RebalanceCoordinator::toRebalanceListener$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:216)").map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return rebalanceEvent.addCallback(RebalanceCoordinator$RebalanceCallback$.MODULE$.apply((Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)lostTps, (Chunk<PartitionStreamControl>)lostStreams));
                        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:217)");
                    }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:217)");
                }
                throw new MatchError((Object)tuple2);
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:217)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:217)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.toRebalanceListener(RebalanceCoordinator.scala:218)"));
    }

    private static final boolean endStreams$$anonfun$1(Chunk streamsToEnd$1) {
        return streamsToEnd$1.isEmpty();
    }

    private static final Iterable endStreams$$anonfun$2$$anonfun$1(Chunk streamsToEnd$3) {
        return streamsToEnd$3;
    }

    private final boolean endStreams$$anonfun$2$$anonfun$3$$anonfun$2() {
        return this.rebalanceSafeCommits;
    }

    private final ZIO endStreams$$anonfun$2(Chunk streamsToEnd$2) {
        return ZIO$.MODULE$.foreachDiscard(() -> RebalanceCoordinator.endStreams$$anonfun$2$$anonfun$1(streamsToEnd$2), (Function1 & Serializable)_$1 -> _$1.end(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:48)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.consumer.rebalanceListenerAccess((Function1 & Serializable)_$2 -> this.doAwaitStreamCommits((Consumer<byte[], byte[]>)_$2, (Chunk<PartitionStreamControl>)streamsToEnd$2)).when(this::endStreams$$anonfun$2$$anonfun$3$$anonfun$2, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:49)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Option option = x$1;
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:50)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.endStreams(RebalanceCoordinator.scala:50)");
    }

    private static final long timeToDeadlineMillis$1(long deadline$1) {
        return (deadline$1 - System.nanoTime()) / 1000000L;
    }

    private static final String completionStatusesAsString$1(Chunk completionStatuses) {
        return new StringBuilder(20).append("Revoked partitions: ").append(completionStatuses.map((Function1 & Serializable)_$3 -> _$3.toString()).mkString("; ")).toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final /* synthetic */ Tuple2 getStreamCompletionStatuses$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Committer.CommitOffsets committedOffsets$5, PartitionStreamControl stream$3, Map latestPendingCommitOffsets$4, Option endOffset) {
        var5_4 = endOffset;
        if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
        endOffset = var6_5 = (Offset)((Some)var5_4).value();
        if (committedOffsets$5.contains(stream$3.tp(), endOffset.offset())) {
            v0 /* !! */  = RebalanceCoordinator$EndOffsetCommitted$.MODULE$;
        } else {
            endOffset = var6_5;
            if (latestPendingCommitOffsets$4.get((Object)stream$3.tp()).contains((Object)BoxesRunTime.boxToLong((long)endOffset.offset()))) {
                v0 /* !! */  = RebalanceCoordinator$EndOffsetCommitPending$.MODULE$;
            } else lbl-1000:
            // 2 sources

            {
                v0 /* !! */  = RebalanceCoordinator$EndOffsetNotCommitted$.MODULE$;
            }
        }
        endOffsetCommitStatus = v0 /* !! */ ;
        return Tuple2$.MODULE$.apply((Object)endOffset, (Object)endOffsetCommitStatus);
    }

    private static final /* synthetic */ ZIO getStreamCompletionStatuses$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(PartitionStreamControl stream$1, Committer.CommitOffsets committedOffsets$2, Map latestPendingCommitOffsets$1, boolean isDone) {
        return stream$1.lastPulledOffset().flatMap((Function1 & Serializable)lastPulledOffset -> (isDone ? stream$1.completedPromise().await((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:73)") : ZIO$.MODULE$.none()).map(arg_0 -> RebalanceCoordinator.getStreamCompletionStatuses$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(committedOffsets$2, stream$1, latestPendingCommitOffsets$1, arg_0), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:82)").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option endOffset = (Option)tuple2._1();
                EndOffsetCommitStatus endOffsetCommitStatus = (EndOffsetCommitStatus)tuple2._2();
                return RebalanceCoordinator$StreamCompletionStatus$.MODULE$.apply(stream$1.tp(), isDone, (Option<Object>)lastPulledOffset.map((Function1 & Serializable)_$5 -> _$5.offset()), committedOffsets$2.get(stream$1.tp()), endOffsetCommitStatus);
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:89)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:89)");
    }

    private final ZIO getStreamCompletionStatuses$1(Chunk streamsToEnd$6) {
        return this.committer.getCommittedOffsets().flatMap((Function1 & Serializable)committedOffsets -> this.committer.getPendingCommits().map((Function1 & Serializable)_$4 -> _$4.offsets(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:67)").flatMap((Function1 & Serializable)latestPendingCommitOffsets -> ZIO$.MODULE$.foreach((Iterable)streamsToEnd$6, (Function1 & Serializable)stream -> stream.completedPromise().isDone((Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:71)").flatMap((Function1 & Serializable)isDone -> RebalanceCoordinator.getStreamCompletionStatuses$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(stream, committedOffsets, latestPendingCommitOffsets, BoxesRunTime.unboxToBoolean((Object)isDone)), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:89)"), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:90)").map((Function1 & Serializable)streamResults -> streamResults, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:91)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:91)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.getStreamCompletionStatuses(RebalanceCoordinator.scala:91)");
    }

    private static final String logStreamCompletionStatuses$1$$anonfun$1(Chunk streamsToEnd$10, String statusStrings$1, long deadline$3) {
        return new StringBuilder(73).append("Delaying rebalance until ").append(streamsToEnd$10.size()).append(" streams (of revoked partitions) have committed ").append(new StringBuilder(58).append("the offsets of the records they consumed. Deadline in ").append(RebalanceCoordinator.timeToDeadlineMillis$1(deadline$3)).append("ms. ").append(statusStrings$1).toString()).toString();
    }

    private static final ZIO logStreamCompletionStatuses$1(Chunk streamsToEnd$9, long deadline$2, Chunk completionStatuses) {
        String statusStrings = RebalanceCoordinator.completionStatusesAsString$1(completionStatuses);
        return ZIO$.MODULE$.logDebug(() -> RebalanceCoordinator.logStreamCompletionStatuses$1$$anonfun$1(streamsToEnd$9, statusStrings, deadline$2), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logStreamCompletionStatuses(RebalanceCoordinator.scala:99)");
    }

    private final ZIO logInitialStreamCompletionStatuses$1(Chunk streamsToEnd$18, long deadline$6) {
        return this.getStreamCompletionStatuses$1(streamsToEnd$18).flatMap((Function1 & Serializable)completionStatuses -> RebalanceCoordinator.logStreamCompletionStatuses$1(streamsToEnd$18, deadline$6, completionStatuses).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logInitialStreamCompletionStatuses(RebalanceCoordinator.scala:106)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logInitialStreamCompletionStatuses(RebalanceCoordinator.scala:106)");
    }

    private final ZIO endingStreamsCompletedAndCommitsExist$1(Chunk streamsToEnd$20, long deadline$8) {
        return this.getStreamCompletionStatuses$1(streamsToEnd$20).flatMap((Function1 & Serializable)completionStatuses -> RebalanceCoordinator.logStreamCompletionStatuses$1(streamsToEnd$20, deadline$8, completionStatuses).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return completionStatuses.forall((Function1 & Serializable)status -> {
                if (status.lastPulledOffset().isEmpty()) return true;
                if (!status.streamEnded()) return false;
                EndOffsetCommitStatus endOffsetCommitStatus = status.endOffsetCommitStatus();
                RebalanceCoordinator$EndOffsetNotCommitted$ rebalanceCoordinator$EndOffsetNotCommitted$ = RebalanceCoordinator$EndOffsetNotCommitted$.MODULE$;
                if (endOffsetCommitStatus == null) {
                    if (rebalanceCoordinator$EndOffsetNotCommitted$ == null) return false;
                    return true;
                } else if (endOffsetCommitStatus.equals(rebalanceCoordinator$EndOffsetNotCommitted$)) return false;
                return true;
            });
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(RebalanceCoordinator.scala:115)"), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.endingStreamsCompletedAndCommitsExist(RebalanceCoordinator.scala:115)");
    }

    private static final String logFinalStreamCompletionStatuses$1$$anonfun$1() {
        return "Continuing rebalance, all offsets of consumed records in the revoked partitions were committed.";
    }

    private static final String logFinalStreamCompletionStatuses$1$$anonfun$3$$anonfun$1(String statusStrings$2) {
        return new StringBuilder(143).append("Exceeded deadline waiting for streams (of revoked partitions) to commit the offsets of ").append("the records they consumed; the rebalance will continue. ").append(new StringBuilder(65).append("This might cause another consumer to process some records again. ").append(statusStrings$2).toString()).toString();
    }

    private final ZIO logFinalStreamCompletionStatuses$1(Chunk streamsToEnd$22, boolean completed) {
        if (completed) {
            return ZIO$.MODULE$.logInfo(RebalanceCoordinator::logFinalStreamCompletionStatuses$1$$anonfun$1, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:119)");
        }
        return this.getStreamCompletionStatuses$1(streamsToEnd$22).map((Function1 & Serializable)completionStatuses -> {
            String statusStrings = RebalanceCoordinator.completionStatusesAsString$1(completionStatuses);
            return Tuple2$.MODULE$.apply(completionStatuses, (Object)statusStrings);
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:123)").flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Chunk completionStatuses = (Chunk)tuple2._1();
                String statusStrings = (String)tuple2._2();
                return ZIO$.MODULE$.logWarning(() -> RebalanceCoordinator.logFinalStreamCompletionStatuses$1$$anonfun$3$$anonfun$1(statusStrings), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:129)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:130)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.logFinalStreamCompletionStatuses(RebalanceCoordinator.scala:130)");
    }

    private final ZIO commitSync$1(Consumer consumer$1) {
        return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> consumer$1.commitSync(Collections.emptyMap(), this.commitTimeout), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits.commitSync(RebalanceCoordinator.scala:133)");
    }

    private final ZIO doAwaitStreamCommits$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.blockingSleep(this.commitQueuePollInterval);
    }

    private static final boolean doAwaitStreamCommits$$anonfun$1$$anonfun$6$$anonfun$1() {
        return false;
    }

    private static final String doAwaitStreamCommits$$anonfun$1$$anonfun$7$$anonfun$1$$anonfun$1$$anonfun$1(Chunk streamsToEnd$15) {
        return new StringBuilder(32).append("Done waiting for ").append(streamsToEnd$15.size()).append(" streams to end").toString();
    }

    private final /* synthetic */ ZIO doAwaitStreamCommits$$anonfun$1$$anonfun$7(Chunk streamsToEnd$12, Consumer consumer$5, boolean completed) {
        return this.logFinalStreamCompletionStatuses$1(streamsToEnd$12, completed).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.commitSync$1(consumer$5).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.logDebug(() -> RebalanceCoordinator.doAwaitStreamCommits$$anonfun$1$$anonfun$7$$anonfun$1$$anonfun$1$$anonfun$1(streamsToEnd$12), (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:168)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:169)");
            }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:169)");
        }, (Object)"zio.kafka.consumer.internal.RebalanceCoordinator.doAwaitStreamCommits(RebalanceCoordinator.scala:169)");
    }

    private static final String toRebalanceListener$$anonfun$1$$anonfun$1$$anonfun$1(RebalanceEvent rebalanceEvent$1, Set assignedTps$1) {
        String sameRebalance = rebalanceEvent$1.wasInvoked() ? " in same rebalance" : "";
        return new StringBuilder(24).append(assignedTps$1.size()).append(" partitions are assigned").append(sameRebalance).toString();
    }

    private static final RebalanceEvent toRebalanceListener$$anonfun$1$$anonfun$1$$anonfun$2(RebalanceEvent rebalanceEvent$2, Set assignedTps$3) {
        return rebalanceEvent$2.addCallback(RebalanceCoordinator$RebalanceCallback$.MODULE$.apply((Set<TopicPartition>)assignedTps$3, (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), (Chunk<PartitionStreamControl>)Chunk$.MODULE$.empty()));
    }

    private static final String toRebalanceListener$$anonfun$2$$anonfun$1$$anonfun$1(RebalanceEvent rebalanceEvent$3, Set revokedTps$1) {
        String sameRebalance = rebalanceEvent$3.wasInvoked() ? " in same rebalance" : "";
        return new StringBuilder(23).append(revokedTps$1.size()).append(" partitions are revoked").append(sameRebalance).toString();
    }

    private static final String toRebalanceListener$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "onRevoked done";
    }

    private static final String toRebalanceListener$$anonfun$3$$anonfun$1$$anonfun$1(Set lostTps$2) {
        return new StringBuilder(20).append(lostTps$2.size()).append(" partitions are lost").toString();
    }

    private static final Iterable toRebalanceListener$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Chunk lostStreams$1) {
        return lostStreams$1;
    }

    private static final String toRebalanceListener$$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1() {
        return "onLost done";
    }

    public static interface EndOffsetCommitStatus {
    }

    public static final class RebalanceCallback
    implements Product,
    Serializable {
        private final Set assignedTps;
        private final Set revokedTps;
        private final Set lostTps;
        private final Chunk endedStreams;

        public static RebalanceCallback apply(Set<TopicPartition> set, Set<TopicPartition> set2, Set<TopicPartition> set3, Chunk<PartitionStreamControl> chunk) {
            return RebalanceCoordinator$RebalanceCallback$.MODULE$.apply(set, set2, set3, chunk);
        }

        public static RebalanceCallback fromProduct(Product product) {
            return RebalanceCoordinator$RebalanceCallback$.MODULE$.fromProduct(product);
        }

        public static RebalanceCallback unapply(RebalanceCallback rebalanceCallback) {
            return RebalanceCoordinator$RebalanceCallback$.MODULE$.unapply(rebalanceCallback);
        }

        public RebalanceCallback(Set<TopicPartition> assignedTps, Set<TopicPartition> revokedTps, Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            this.assignedTps = assignedTps;
            this.revokedTps = revokedTps;
            this.lostTps = lostTps;
            this.endedStreams = endedStreams;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RebalanceCallback)) return false;
            RebalanceCallback rebalanceCallback = (RebalanceCallback)object;
            Set<TopicPartition> set = this.assignedTps();
            Set<TopicPartition> set2 = rebalanceCallback.assignedTps();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<TopicPartition> set3 = this.revokedTps();
            Set<TopicPartition> set4 = rebalanceCallback.revokedTps();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            Set<TopicPartition> set5 = this.lostTps();
            Set<TopicPartition> set6 = rebalanceCallback.lostTps();
            if (set5 == null) {
                if (set6 != null) {
                    return false;
                }
            } else if (!set5.equals(set6)) return false;
            Chunk<PartitionStreamControl> chunk = this.endedStreams();
            Chunk<PartitionStreamControl> chunk2 = rebalanceCallback.endedStreams();
            if (chunk == null) {
                if (chunk2 == null) return true;
                return false;
            } else {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RebalanceCallback;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "RebalanceCallback";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "assignedTps";
                }
                case 1: {
                    return "revokedTps";
                }
                case 2: {
                    return "lostTps";
                }
                case 3: {
                    return "endedStreams";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<TopicPartition> assignedTps() {
            return this.assignedTps;
        }

        public Set<TopicPartition> revokedTps() {
            return this.revokedTps;
        }

        public Set<TopicPartition> lostTps() {
            return this.lostTps;
        }

        public Chunk<PartitionStreamControl> endedStreams() {
            return this.endedStreams;
        }

        public RebalanceCallback append(RebalanceCallback other) {
            return RebalanceCoordinator$RebalanceCallback$.MODULE$.apply((Set<TopicPartition>)((Set)((SetOps)this.assignedTps().$plus$plus(other.assignedTps())).$minus$minus(other.revokedTps()).$minus$minus(other.lostTps())), (Set<TopicPartition>)((Set)this.revokedTps().$plus$plus(other.revokedTps())), (Set<TopicPartition>)((Set)this.lostTps().$plus$plus(other.lostTps())), (Chunk<PartitionStreamControl>)this.endedStreams().$plus$plus(other.endedStreams()));
        }

        public RebalanceCallback copy(Set<TopicPartition> assignedTps, Set<TopicPartition> revokedTps, Set<TopicPartition> lostTps, Chunk<PartitionStreamControl> endedStreams) {
            return new RebalanceCallback(assignedTps, revokedTps, lostTps, endedStreams);
        }

        public Set<TopicPartition> copy$default$1() {
            return this.assignedTps();
        }

        public Set<TopicPartition> copy$default$2() {
            return this.revokedTps();
        }

        public Set<TopicPartition> copy$default$3() {
            return this.lostTps();
        }

        public Chunk<PartitionStreamControl> copy$default$4() {
            return this.endedStreams();
        }

        public Set<TopicPartition> _1() {
            return this.assignedTps();
        }

        public Set<TopicPartition> _2() {
            return this.revokedTps();
        }

        public Set<TopicPartition> _3() {
            return this.lostTps();
        }

        public Chunk<PartitionStreamControl> _4() {
            return this.endedStreams();
        }
    }

    public static final class RebalanceEvent
    implements Product,
    Serializable {
        private final Chunk rebalanceCallbacks;

        public static RebalanceEvent None() {
            return RebalanceCoordinator$RebalanceEvent$.MODULE$.None();
        }

        public static RebalanceEvent apply(Chunk<RebalanceCallback> chunk) {
            return RebalanceCoordinator$RebalanceEvent$.MODULE$.apply(chunk);
        }

        public static RebalanceEvent fromProduct(Product product) {
            return RebalanceCoordinator$RebalanceEvent$.MODULE$.fromProduct(product);
        }

        public static RebalanceEvent unapply(RebalanceEvent rebalanceEvent) {
            return RebalanceCoordinator$RebalanceEvent$.MODULE$.unapply(rebalanceEvent);
        }

        public RebalanceEvent(Chunk<RebalanceCallback> rebalanceCallbacks) {
            this.rebalanceCallbacks = rebalanceCallbacks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RebalanceEvent)) return false;
            RebalanceEvent rebalanceEvent = (RebalanceEvent)object;
            Chunk<RebalanceCallback> chunk = this.rebalanceCallbacks();
            Chunk<RebalanceCallback> chunk2 = rebalanceEvent.rebalanceCallbacks();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RebalanceEvent;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RebalanceEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "rebalanceCallbacks";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<RebalanceCallback> rebalanceCallbacks() {
            return this.rebalanceCallbacks;
        }

        public boolean wasInvoked() {
            return this.rebalanceCallbacks().nonEmpty();
        }

        public RebalanceEvent addCallback(RebalanceCallback callback) {
            return this.copy((Chunk<RebalanceCallback>)((Chunk)this.rebalanceCallbacks().$colon$plus((Object)callback)));
        }

        public RebalanceEvent copy(Chunk<RebalanceCallback> rebalanceCallbacks) {
            return new RebalanceEvent(rebalanceCallbacks);
        }

        public Chunk<RebalanceCallback> copy$default$1() {
            return this.rebalanceCallbacks();
        }

        public Chunk<RebalanceCallback> _1() {
            return this.rebalanceCallbacks();
        }
    }

    public static final class StreamCompletionStatus
    implements Product,
    Serializable {
        private final TopicPartition tp;
        private final boolean streamEnded;
        private final Option lastPulledOffset;
        private final Option lastCommittedOffset;
        private final EndOffsetCommitStatus endOffsetCommitStatus;

        public static StreamCompletionStatus apply(TopicPartition topicPartition, boolean bl, Option<Object> option, Option<Object> option2, EndOffsetCommitStatus endOffsetCommitStatus) {
            return RebalanceCoordinator$StreamCompletionStatus$.MODULE$.apply(topicPartition, bl, option, option2, endOffsetCommitStatus);
        }

        public static StreamCompletionStatus fromProduct(Product product) {
            return RebalanceCoordinator$StreamCompletionStatus$.MODULE$.fromProduct(product);
        }

        public static StreamCompletionStatus unapply(StreamCompletionStatus streamCompletionStatus) {
            return RebalanceCoordinator$StreamCompletionStatus$.MODULE$.unapply(streamCompletionStatus);
        }

        public StreamCompletionStatus(TopicPartition tp, boolean streamEnded, Option<Object> lastPulledOffset, Option<Object> lastCommittedOffset, EndOffsetCommitStatus endOffsetCommitStatus) {
            this.tp = tp;
            this.streamEnded = streamEnded;
            this.lastPulledOffset = lastPulledOffset;
            this.lastCommittedOffset = lastCommittedOffset;
            this.endOffsetCommitStatus = endOffsetCommitStatus;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tp()));
            n = Statics.mix((int)n, (int)(this.streamEnded() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastPulledOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastCommittedOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.endOffsetCommitStatus()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StreamCompletionStatus)) return false;
            StreamCompletionStatus streamCompletionStatus = (StreamCompletionStatus)object;
            if (this.streamEnded() != streamCompletionStatus.streamEnded()) return false;
            TopicPartition topicPartition = this.tp();
            TopicPartition topicPartition2 = streamCompletionStatus.tp();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            Option<Object> option = this.lastPulledOffset();
            Option<Object> option2 = streamCompletionStatus.lastPulledOffset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.lastCommittedOffset();
            Option<Object> option4 = streamCompletionStatus.lastCommittedOffset();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            EndOffsetCommitStatus endOffsetCommitStatus = this.endOffsetCommitStatus();
            EndOffsetCommitStatus endOffsetCommitStatus2 = streamCompletionStatus.endOffsetCommitStatus();
            if (endOffsetCommitStatus == null) {
                if (endOffsetCommitStatus2 == null) return true;
                return false;
            } else {
                if (!endOffsetCommitStatus.equals(endOffsetCommitStatus2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof StreamCompletionStatus;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "StreamCompletionStatus";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tp";
                }
                case 1: {
                    return "streamEnded";
                }
                case 2: {
                    return "lastPulledOffset";
                }
                case 3: {
                    return "lastCommittedOffset";
                }
                case 4: {
                    return "endOffsetCommitStatus";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TopicPartition tp() {
            return this.tp;
        }

        public boolean streamEnded() {
            return this.streamEnded;
        }

        public Option<Object> lastPulledOffset() {
            return this.lastPulledOffset;
        }

        public Option<Object> lastCommittedOffset() {
            return this.lastCommittedOffset;
        }

        public EndOffsetCommitStatus endOffsetCommitStatus() {
            return this.endOffsetCommitStatus;
        }

        public String toString() {
            return new StringBuilder(2).append(this.tp()).append(": ").append(new StringBuilder(2).append(this.streamEnded() ? "stream ended" : "stream is running").append(", ").toString()).append(new StringBuilder(21).append("last pulled offset=").append(this.lastPulledOffset().getOrElse(RebalanceCoordinator$::zio$kafka$consumer$internal$RebalanceCoordinator$StreamCompletionStatus$$_$toString$$anonfun$1)).append(", ").toString()).append(new StringBuilder(24).append("last committed offset=").append(this.lastCommittedOffset().getOrElse(RebalanceCoordinator$::zio$kafka$consumer$internal$RebalanceCoordinator$StreamCompletionStatus$$_$toString$$anonfun$2)).append(", ").toString()).append(this.endOffsetCommitStatus()).toString();
        }

        public StreamCompletionStatus copy(TopicPartition tp, boolean streamEnded, Option<Object> lastPulledOffset, Option<Object> lastCommittedOffset, EndOffsetCommitStatus endOffsetCommitStatus) {
            return new StreamCompletionStatus(tp, streamEnded, lastPulledOffset, lastCommittedOffset, endOffsetCommitStatus);
        }

        public TopicPartition copy$default$1() {
            return this.tp();
        }

        public boolean copy$default$2() {
            return this.streamEnded();
        }

        public Option<Object> copy$default$3() {
            return this.lastPulledOffset();
        }

        public Option<Object> copy$default$4() {
            return this.lastCommittedOffset();
        }

        public EndOffsetCommitStatus copy$default$5() {
            return this.endOffsetCommitStatus();
        }

        public TopicPartition _1() {
            return this.tp();
        }

        public boolean _2() {
            return this.streamEnded();
        }

        public Option<Object> _3() {
            return this.lastPulledOffset();
        }

        public Option<Object> _4() {
            return this.lastCommittedOffset();
        }

        public EndOffsetCommitStatus _5() {
            return this.endOffsetCommitStatus();
        }
    }
}

