/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.CanFail;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Clock$;
import zio.Dequeue;
import zio.DurationSyntax$;
import zio.Exit;
import zio.IsSubtypeOfOutput$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Runtime;
import zio.Schedule;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.diagnostics.Diagnostics;
import zio.kafka.producer.DiagnosticsEmitter;
import zio.kafka.producer.DiagnosticsEmitterMaker;
import zio.kafka.producer.EmptyDiagnosticsEmitterMaker$;
import zio.kafka.producer.Producer;
import zio.kafka.producer.Producer$;
import zio.kafka.producer.Producer$PublishOmittedException$;
import zio.kafka.producer.ProducerEvent;
import zio.kafka.producer.ProducerEvent$ProducedRecord$;
import zio.kafka.producer.ProducerEvent$RecordsOffered$;
import zio.kafka.producer.ProducerEvent$RecordsSent$;
import zio.kafka.producer.ProducerLive$;
import zio.kafka.producer.ProducerSettings;
import zio.kafka.producer.internal.ProducerMetrics;
import zio.kafka.serde.Serializer;
import zio.package$;
import zio.stream.ZStream$;

public final class ProducerLive
implements Producer {
    private final ProducerSettings settings;
    public final Diagnostics<ProducerEvent> zio$kafka$producer$ProducerLive$$diagnostics;
    private final org.apache.kafka.clients.producer.Producer p;
    private final Runtime<Object> runtime;
    private final Queue<Tuple3<Chunk<ProducerRecord<byte[], byte[]>>, Object, Function1<Chunk<Either<Throwable, RecordMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>>> sendQueue;
    private final ProducerMetrics producerMetrics;
    private final DiagnosticsEmitterMaker diagnosticsEmitterMaker;
    private final ZIO sendFromQueue;

    public ProducerLive(ProducerSettings settings, Diagnostics<ProducerEvent> diagnostics, org.apache.kafka.clients.producer.Producer<byte[], byte[]> p, Runtime<Object> runtime, Queue<Tuple3<Chunk<ProducerRecord<byte[], byte[]>>, Object, Function1<Chunk<Either<Throwable, RecordMetadata>>, ZIO<Object, Nothing$, BoxedUnit>>>> sendQueue, ProducerMetrics producerMetrics) {
        this.settings = settings;
        this.zio$kafka$producer$ProducerLive$$diagnostics = diagnostics;
        this.p = p;
        this.runtime = runtime;
        this.sendQueue = sendQueue;
        this.producerMetrics = producerMetrics;
        this.diagnosticsEmitterMaker = diagnostics == Producer$.MODULE$.NoDiagnostics() ? EmptyDiagnosticsEmitterMaker$.MODULE$ : new BatchDiagnosticsEmitterMaker();
        this.sendFromQueue = ZStream$.MODULE$.fromQueueWithShutdown(() -> ProducerLive.$init$$$anonfun$2(sendQueue), ProducerLive::$init$$$anonfun$3, (Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:539)").mapZIO((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Chunk serializedRecords = (Chunk)tuple3._1();
                long startNanos = BoxesRunTime.unboxToLong((Object)tuple3._2());
                Function1 continuation = (Function1)tuple3._3();
                return this.observeTake(startNanos).as((Function0 & Serializable)() -> {
                    ProducerLive.$init$$$anonfun$4$$anonfun$1(serializedRecords, runtime, continuation, p);
                    return BoxedUnit.UNIT;
                }, (Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:599)");
            }
            throw new MatchError((Object)tuple3);
        }, (Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:600)").runDrain((Object)"zio.kafka.producer.ProducerLive.sendFromQueue(Producer.scala:601)");
    }

    public org.apache.kafka.clients.producer.Producer<byte[], byte[]> p() {
        return this.p;
    }

    @Override
    public ZIO<Object, Throwable, RecordMetadata> produce(ProducerRecord<byte[], byte[]> record) {
        return this.produceAsync(record).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produce(Producer.scala:307)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(ProducerRecord<K, V> record, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produceAsync(record, keySerializer, valueSerializer).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produce(Producer.scala:314)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, RecordMetadata> produce(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produce(new ProducerRecord(topic, key, value), keySerializer, valueSerializer);
    }

    @Override
    public ZIO<Object, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(ProducerRecord<byte[], byte[]> record) {
        return ZIO$.MODULE$.suspendSucceed(() -> this.produceAsync$$anonfun$1(record), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:365)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(ProducerRecord<K, V> record2, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.serialize(record2, keySerializer, valueSerializer).flatMap((Function1 & Serializable)record -> this.produceAsync((ProducerRecord<byte[], byte[]>)record), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:372)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, RecordMetadata>> produceAsync(String topic, K key, V value, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produceAsync(new ProducerRecord(topic, key, value), keySerializer, valueSerializer);
    }

    @Override
    public ZIO<Object, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<byte[], byte[]>> records) {
        return this.produceChunkAsync(records).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produceChunk(Producer.scala:384)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, Chunk<RecordMetadata>> produceChunk(Chunk<ProducerRecord<K, V>> records, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return this.produceChunkAsync(records, keySerializer, valueSerializer).flatten(IsSubtypeOfOutput$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.produceChunk(Producer.scala:391)");
    }

    @Override
    public ZIO<Object, Throwable, ZIO<Object, Throwable, Chunk<RecordMetadata>>> produceChunkAsync(Chunk<ProducerRecord<byte[], byte[]>> records) {
        return this.produceChunkAsyncWithFailures(records).map((Function1 & Serializable)_$3 -> _$3.flatMap((Function1 & Serializable)chunkResults -> {
            Tuple2 tuple2 = chunkResults.partitionMap((Function1 & Serializable)x -> (Either)Predef$.MODULE$.identity(x));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Chunk errors = (Chunk)tuple2._1();
            Chunk success = (Chunk)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)errors, (Object)success);
            Chunk errors2 = (Chunk)tuple22._1();
            Chunk success2 = (Chunk)tuple22._2();
            Option option = errors2.headOption();
            if (option instanceof Some) {
                Throwable error = (Throwable)((Some)option).value();
                return ZIO$.MODULE$.fail(() -> ProducerLive.produceChunkAsync$$anonfun$1$$anonfun$1$$anonfun$1(error), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:400)");
            }
            if (None$.MODULE$.equals(option)) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:401)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return success2;
                });
            }
            throw new MatchError((Object)option);
        }, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:403)"), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:403)");
    }

    @Override
    public <R, K, V> ZIO<R, Throwable, ZIO<Object, Throwable, Chunk<RecordMetadata>>> produceChunkAsync(Chunk<ProducerRecord<K, V>> records2, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return ZIO$.MODULE$.foreach(records2, (Function1 & Serializable)_$4 -> this.serialize((ProducerRecord)_$4, keySerializer, valueSerializer), BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:411)").flatMap((Function1 & Serializable)records -> this.produceChunkAsync((Chunk<ProducerRecord<byte[], byte[]>>)records), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsync(Producer.scala:412)");
    }

    @Override
    public ZIO<Object, Nothing$, ZIO<Object, Nothing$, Chunk<Either<Throwable, RecordMetadata>>>> produceChunkAsyncWithFailures(Chunk<ProducerRecord<byte[], byte[]>> records) {
        if (records.isEmpty()) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:418)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:418)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return Chunk$.MODULE$.empty();
                });
            });
        }
        LazyRef lazyRef = new LazyRef();
        int totalRecordCount = records.size();
        DiagnosticsEmitter diagEm = this.diagnosticsEmitterMaker.makeDiagnosticsEmitter(records);
        return ZIO$.MODULE$.suspendSucceed(() -> this.produceChunkAsyncWithFailures$$anonfun$2(totalRecordCount, diagEm, records, lazyRef), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:517)");
    }

    @Override
    public ZIO<Object, Throwable, Chunk<PartitionInfo>> partitionsFor(String topic) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$7 -> Chunk$.MODULE$.fromJavaIterable((java.lang.Iterable)this.p().partitionsFor(topic)), (Object)"zio.kafka.producer.ProducerLive.partitionsFor(Producer.scala:521)");
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> flush() {
        return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$8 -> this.p().flush(), (Object)"zio.kafka.producer.ProducerLive.flush(Producer.scala:523)");
    }

    @Override
    public ZIO<Object, Throwable, Map<MetricName, Metric>> metrics() {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$9 -> CollectionConverters$.MODULE$.MapHasAsScala(this.p().metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)"zio.kafka.producer.ProducerLive.metrics(Producer.scala:525)");
    }

    private ZIO<Object, Nothing$, BoxedUnit> observeTake(long startNanos) {
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.producer.ProducerLive.observeTake(Producer.scala:529)").flatMap((Function1 & Serializable)now -> this.observeTake$$anonfun$1(startNanos, BoxesRunTime.unboxToLong((Object)now)), (Object)"zio.kafka.producer.ProducerLive.observeTake(Producer.scala:531)");
    }

    public ZIO<Object, Nothing$, Object> sendFromQueue() {
        return this.sendFromQueue;
    }

    private <R, K, V> ZIO<R, Throwable, ProducerRecord<byte[], byte[]>> serialize(ProducerRecord<K, V> r, Serializer<R, K> keySerializer, Serializer<R, V> valueSerializer) {
        return keySerializer.serialize(r.topic(), r.headers(), r.key()).flatMap((Function1 & Serializable)key -> valueSerializer.serialize(r.topic(), r.headers(), r.value()).map((Function1 & Serializable)value -> new ProducerRecord(r.topic(), r.partition(), r.timestamp(), key, value, (java.lang.Iterable)r.headers()), (Object)"zio.kafka.producer.ProducerLive.serialize(Producer.scala:611)"), (Object)"zio.kafka.producer.ProducerLive.serialize(Producer.scala:611)");
    }

    private static final Dequeue $init$$$anonfun$2(Queue sendQueue$1) {
        return sendQueue$1;
    }

    private static final int $init$$$anonfun$3() {
        return ZStream$.MODULE$.fromQueueWithShutdown$default$2();
    }

    private static final void insertSentResult$1(Either[] sentResults$1, AtomicInteger sentRecordsCounter$1, int recordsLength$1, Runtime runtime$3, Function1 continuation$2, int resultIndex, Either sentResult) {
        sentResults$1[resultIndex] = sentResult;
        if (sentRecordsCounter$1.incrementAndGet() == recordsLength$1) {
            Chunk sentResultsChunk = Chunk$.MODULE$.fromArray((Object)sentResults$1);
            Unsafe$.MODULE$.unsafe((Function1)(JProcedure1 & Serializable)u -> {
                Exit exit = runtime$3.unsafe().run((ZIO)continuation$2.apply((Object)sentResultsChunk), (Object)"zio.kafka.producer.ProducerLive.sendFromQueue.insertSentResult(Producer.scala:559)", u);
            });
            return;
        }
    }

    private static final void $init$$$anonfun$4$$anonfun$1(Chunk serializedRecords$1, Runtime runtime$2, Function1 continuation$1, org.apache.kafka.clients.producer.Producer p$2) {
        int recordsLength = serializedRecords$1.length();
        AtomicInteger sentRecordsCounter = new AtomicInteger(0);
        Iterator recordsIterator = serializedRecords$1.iterator().zipWithIndex();
        Either[] sentResults = new Either[recordsLength];
        VolatileBooleanRef previousSendCallsSucceed = VolatileBooleanRef.create((boolean)true);
        recordsIterator.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ProducerRecord producerRecord = (ProducerRecord)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (producerRecord != null) {
                    ProducerRecord record = producerRecord;
                    if (true) {
                        int recordIndex = n;
                        if (previousSendCallsSucceed$1.elem) {
                            try {
                                Future future = p$2.send(record, (metadata, err) -> {
                                    Right right;
                                    if (err == null) {
                                        right = scala.package$.MODULE$.Right().apply((Object)metadata);
                                    } else {
                                        previousSendCallsSucceed$2.elem = false;
                                        right = scala.package$.MODULE$.Left().apply((Object)err);
                                    }
                                    Right sendResult = right;
                                    ProducerLive.insertSentResult$1(sentResults, sentRecordsCounter, recordsLength, runtime$2, continuation$1, recordIndex, (Either)sendResult);
                                });
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable err2 = throwable3 = (Throwable)option.get();
                                    previousSendCallsSucceed$1.elem = false;
                                    ProducerLive.insertSentResult$1(sentResults, sentRecordsCounter, recordsLength, runtime$2, continuation$1, recordIndex, (Either)scala.package$.MODULE$.Left().apply((Object)err2));
                                }
                                throw throwable;
                            }
                            return;
                        }
                        ProducerLive.insertSentResult$1(sentResults, sentRecordsCounter, recordsLength, runtime$2, continuation$1, recordIndex, (Either)scala.package$.MODULE$.Left().apply((Object)Producer$PublishOmittedException$.MODULE$));
                        return;
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final /* synthetic */ ZIO $anonfun$1$$anonfun$1(long startNanos$2, DiagnosticsEmitter diagEm$2, Promise done$2, RecordMetadata recordMetaData$1, long end) {
        return this.producerMetrics.observeProduce(DurationSyntax$.MODULE$.nanos$extension(package$.MODULE$.durationLong(end - startNanos$2)), 1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return diagEm$2.emitSuccess().flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return done$2.succeed((Object)recordMetaData$1, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:342)").map((Function1 & Serializable)v1 -> {
                    bl = BoxesRunTime.unboxToBoolean((Object)v1);
                    return BoxedUnit.UNIT;
                }, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:343)");
            }, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:343)");
        }, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:343)");
    }

    private static final ZIO $anonfun$1$$anonfun$2$$anonfun$1(Promise done$6, ApiException error$2) {
        return done$6.fail((Object)error$2, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:348)").unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:348)");
    }

    private static final ZIO $anonfun$1$$anonfun$4(Promise done$8, Throwable error$3) {
        return done$8.fail((Object)error$3, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:352)").unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:352)");
    }

    private final ZIO loop$1(DiagnosticsEmitter diagEm$3, ProducerRecord record$3, long startNanos, Promise done, Schedule.Driver driver) {
        Function1 & Serializable continuation = (Function1 & Serializable)results -> {
            Either either = (Either)results.head();
            if (either instanceof Right) {
                RecordMetadata recordMetaData = (RecordMetadata)((Right)either).value();
                return Clock$.MODULE$.nanoTime((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:339)").flatMap((Function1 & Serializable)end -> this.$anonfun$1$$anonfun$1(startNanos, diagEm$3, done, recordMetaData, BoxesRunTime.unboxToLong((Object)end)), (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:343)");
            }
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (throwable instanceof AuthorizationException || throwable instanceof AuthenticationException) {
                    ApiException error = (ApiException)throwable;
                    return ((ZIO)driver.next().apply((Object)ProducerLive$.zio$kafka$producer$ProducerLive$$$retryAfterAuthException)).foldZIO((Function1 & Serializable)_$1 -> diagEm$3.emitSingleFailure().$times$greater(() -> ProducerLive.$anonfun$1$$anonfun$2$$anonfun$1(done, error), (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:348)"), (Function1 & Serializable)_$2 -> this.loop$1(diagEm$3, record$3, startNanos, done, driver).unit((Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:349)"), (CanFail)CanFail$.MODULE$, (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:350)");
                }
                Throwable error = throwable;
                return diagEm$3.emitSingleFailure().$times$greater(() -> ProducerLive.$anonfun$1$$anonfun$4(done, error), (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop.continuation(Producer.scala:352)");
            }
            throw new MatchError((Object)either);
        };
        return this.sendQueue.offer((Object)Tuple3$.MODULE$.apply((Object)Chunk$.MODULE$.single((Object)record$3), (Object)BoxesRunTime.boxToLong((long)startNanos), (Object)continuation), (Object)"zio.kafka.producer.ProducerLive.produceAsync.loop(Producer.scala:356)");
    }

    private final /* synthetic */ ZIO produceAsync$$anonfun$1$$anonfun$1(DiagnosticsEmitter diagEm$7, ProducerRecord record$5, long start) {
        return diagEm$7.emitOffer().flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Promise$.MODULE$.make((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:362)").flatMap((Function1 & Serializable)done -> this.settings.authErrorRetrySchedule().driver((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:363)").flatMap((Function1 & Serializable)d -> this.loop$1(diagEm$7, record$5, start, (Promise)done, (Schedule.Driver)d), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:363)").map((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                return done.await((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:364)");
            }, (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:364)"), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:364)");
        }, (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:364)");
    }

    private final ZIO produceAsync$$anonfun$1(ProducerRecord record$1) {
        DiagnosticsEmitter diagEm = this.diagnosticsEmitterMaker.makeDiagnosticsEmitter((ProducerRecord<byte[], byte[]>)record$1);
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:360)").flatMap((Function1 & Serializable)start -> this.produceAsync$$anonfun$1$$anonfun$1(diagEm, record$1, BoxesRunTime.unboxToLong((Object)start)), (Object)"zio.kafka.producer.ProducerLive.produceAsync(Producer.scala:364)");
    }

    private static final Throwable produceChunkAsync$$anonfun$1$$anonfun$1$$anonfun$1(Throwable error$4) {
        return error$4;
    }

    private static final Either finalResults$lzyINIT1$1$$anonfun$1() {
        return ProducerLive$.zio$kafka$producer$ProducerLive$$$leftPublishOmitted;
    }

    private static final Either[] finalResults$lzyINIT1$1(LazyRef finalResults$lzy1$1, int totalRecordCount$1) {
        Either[] eitherArray;
        LazyRef lazyRef = finalResults$lzy1$1;
        synchronized (lazyRef) {
            eitherArray = (Either[])(finalResults$lzy1$1.initialized() ? finalResults$lzy1$1.value() : finalResults$lzy1$1.initialize((Object)((Either[])Array$.MODULE$.fill(totalRecordCount$1, ProducerLive::finalResults$lzyINIT1$1$$anonfun$1, ClassTag$.MODULE$.apply(Either.class)))));
        }
        return eitherArray;
    }

    private static final Either[] finalResults$1(LazyRef finalResults$lzy1$2, int totalRecordCount$2) {
        return finalResults$lzy1$2.initialized() ? finalResults$lzy1$2.value() : ProducerLive.finalResults$lzyINIT1$1(finalResults$lzy1$2, totalRecordCount$2);
    }

    private static final /* synthetic */ void storeResults$1$$anonfun$1(LazyRef finalResults$lzy1$19, int totalRecordCount$21, int x$1, Either x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            Either result;
            int index = BoxesRunTime.unboxToInt((Object)tuple2._1());
            ProducerLive.finalResults$1((LazyRef)finalResults$lzy1$19, (int)totalRecordCount$21)[index] = result = (Either)tuple2._2();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void storeResults$1(LazyRef finalResults$lzy1$18, int totalRecordCount$20, Seq recordIndices, Chunk results) {
        recordIndices.lazyZip((Iterable)results).foreach((Function2 & Serializable)(v1, v2) -> {
            ProducerLive.storeResults$1$$anonfun$1(finalResults$lzy1$18, totalRecordCount$20, BoxesRunTime.unboxToInt((Object)v1), (Either)v2);
            return BoxedUnit.UNIT;
        });
    }

    private static final ZIO complete$1(LazyRef finalResults$lzy1$21, int totalRecordCount$23, Promise done) {
        return done.succeed((Object)Chunk$.MODULE$.fromArray((Object)ProducerLive.finalResults$1(finalResults$lzy1$21, totalRecordCount$23)), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.complete(Producer.scala:432)").unit((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.complete(Producer.scala:432)");
    }

    private static final /* synthetic */ Iterable $anonfun$3(Either x$1, int x$2, ProducerRecord x$3) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2), (Object)x$3);
        if (tuple3 != null) {
            Either either = (Either)tuple3._1();
            if (either instanceof Right) {
                return Chunk$.MODULE$.empty();
            }
            if (either instanceof Left) {
                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                ProducerRecord record = (ProducerRecord)tuple3._3();
                return Chunk$.MODULE$.single((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)record));
            }
        }
        throw new MatchError((Object)tuple3);
    }

    private static final String retryFailedRecords$1$$anonfun$1(Chunk retryRecords$1, Chunk records$2) {
        return new StringBuilder(84).append("Retrying publish ").append(retryRecords$1.size()).append(" (of ").append(records$2.size()).append(") records after AuthorizationException/AuthenticationException").toString();
    }

    private final ZIO retryFailedRecords$1$$anonfun$2(long startNanos$5, Chunk retryIndices$1, Chunk retryRecords$2, Promise done$12, Schedule.Driver driver$4, int totalRecordCount$4, DiagnosticsEmitter diagEm$12, LazyRef finalResults$lzy1$4) {
        return this.loop$2(totalRecordCount$4, diagEm$12, finalResults$lzy1$4, startNanos$5, (Seq)retryIndices$1, retryRecords$2, done$12, driver$4);
    }

    private final ZIO retryFailedRecords$1(Seq recordIndices$1, Chunk records$1, long startNanos$4, Promise done$11, Schedule.Driver driver$3, int totalRecordCount$3, DiagnosticsEmitter diagEm$11, LazyRef finalResults$lzy1$3, Chunk results) {
        Chunk toRetry = (Chunk)results.lazyZip((Iterable)recordIndices$1).lazyZip((Iterable)records$1).flatMap((Function3 & Serializable)(x$1, x$2, x$3) -> ProducerLive.$anonfun$3((Either)x$1, BoxesRunTime.unboxToInt((Object)x$2), (ProducerRecord)x$3), BuildFrom$.MODULE$.buildFromIterableOps());
        Tuple2 tuple2 = toRetry.unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Chunk retryIndices = (Chunk)tuple2._1();
        Chunk retryRecords = (Chunk)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)retryIndices, (Object)retryRecords);
        Chunk retryIndices2 = (Chunk)tuple22._1();
        Chunk retryRecords2 = (Chunk)tuple22._2();
        return ZIO$.MODULE$.logInfo(() -> ProducerLive.retryFailedRecords$1$$anonfun$1(retryRecords2, records$1), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.retryFailedRecords(Producer.scala:452)").$times$greater(() -> this.retryFailedRecords$1$$anonfun$2(startNanos$4, retryIndices2, retryRecords2, done$11, driver$3, totalRecordCount$3, diagEm$11, finalResults$lzy1$3), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.retryFailedRecords(Producer.scala:453)");
    }

    private final /* synthetic */ ZIO observeProduce$1$$anonfun$1(long startNanos$6, int totalRecordCount$5, long now) {
        return this.producerMetrics.observeProduce(DurationSyntax$.MODULE$.nanos$extension(package$.MODULE$.durationLong(now - startNanos$6)), totalRecordCount$5).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.observeProduce(Producer.scala:460)");
    }

    private final ZIO observeProduce$1(int totalRecordCount$8, long startNanos) {
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.observeProduce(Producer.scala:458)").flatMap((Function1 & Serializable)now -> this.observeProduce$1$$anonfun$1(startNanos, totalRecordCount$8, BoxesRunTime.unboxToLong((Object)now)), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.observeProduce(Producer.scala:460)");
    }

    private static final ZIO $anonfun$4$$anonfun$2(DiagnosticsEmitter diagEm$16) {
        return diagEm$16.emitSuccess();
    }

    private static final ZIO $anonfun$4$$anonfun$3(Seq recordIndices$3, int totalRecordCount$10, Promise done$14, Chunk results$1, LazyRef finalResults$lzy1$8) {
        if (recordIndices$3.size() == totalRecordCount$10) {
            return done$14.succeed((Object)results$1, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:469)").unit((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:469)");
        }
        ProducerLive.storeResults$1(finalResults$lzy1$8, totalRecordCount$10, recordIndices$3, results$1);
        return ProducerLive.complete$1(finalResults$lzy1$8, totalRecordCount$10, done$14);
    }

    private static final ZIO $anonfun$4$$anonfun$4(Promise done$15, LazyRef finalResults$lzy1$9, int totalRecordCount$11) {
        return ProducerLive.complete$1(finalResults$lzy1$9, totalRecordCount$11, done$15);
    }

    private static final ZIO $anonfun$4$$anonfun$6$$anonfun$1$$anonfun$1(Promise done$18, LazyRef finalResults$lzy1$12, int totalRecordCount$14) {
        return ProducerLive.complete$1(finalResults$lzy1$12, totalRecordCount$14, done$18);
    }

    private final ZIO $anonfun$4$$anonfun$6(Schedule.Driver driver$6, DiagnosticsEmitter diagEm$17, Promise done$16, Chunk results$2, LazyRef finalResults$lzy1$10, int totalRecordCount$12, Seq recordIndices$4, Chunk records$5, long startNanos$8) {
        return ((ZIO)driver$6.next().apply((Object)ProducerLive$.zio$kafka$producer$ProducerLive$$$retryAfterAuthException)).foldZIO((Function1 & Serializable)_$6 -> diagEm$17.emitFailures(ProducerLive.finalResults$1(finalResults$lzy1$10, totalRecordCount$12)).$times$greater(() -> ProducerLive.$anonfun$4$$anonfun$6$$anonfun$1$$anonfun$1(done$16, finalResults$lzy1$10, totalRecordCount$12), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:500)"), (Function1 & Serializable)_$7 -> this.retryFailedRecords$1(recordIndices$4, records$5, startNanos$8, done$16, driver$6, totalRecordCount$12, diagEm$17, finalResults$lzy1$10, results$2), (CanFail)CanFail$.MODULE$, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:502)");
    }

    private final ZIO loop$2(int totalRecordCount$7, DiagnosticsEmitter diagEm$14, LazyRef finalResults$lzy1$6, long startNanos, Seq recordIndices, Chunk records, Promise done, Schedule.Driver driver) {
        Function1 & Serializable continuation = (Function1 & Serializable)results -> {
            if (results.forall((Function1 & Serializable)_$5 -> _$5.isRight())) {
                return this.observeProduce$1(totalRecordCount$7, startNanos).$times$greater(() -> ProducerLive.$anonfun$4$$anonfun$2(diagEm$14), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:466)").$times$greater(() -> ProducerLive.$anonfun$4$$anonfun$3(recordIndices, totalRecordCount$7, done, results, finalResults$lzy1$6), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:475)");
            }
            ProducerLive.storeResults$1(finalResults$lzy1$6, totalRecordCount$7, recordIndices, results);
            boolean hasFatalError = results.exists((Function1 & Serializable)x$1 -> {
                Throwable throwable;
                Either either = x$1;
                return !(either instanceof Right) && (!(either instanceof Left) || !((throwable = (Throwable)((Left)either).value()) instanceof AuthorizationException) && !(throwable instanceof AuthenticationException) && !Producer$PublishOmittedException$.MODULE$.equals(throwable));
                {
                }
            });
            if (hasFatalError) {
                return diagEm$14.emitFailures(ProducerLive.finalResults$1(finalResults$lzy1$6, totalRecordCount$7)).$times$greater(() -> ProducerLive.$anonfun$4$$anonfun$4(done, finalResults$lzy1$6, totalRecordCount$7), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:488)");
            }
            return this.producerMetrics.observeSendAuthError(results.count((Function1 & Serializable)x$1 -> {
                Throwable throwable;
                Either either = x$1;
                return either instanceof Left && ((throwable = (Throwable)((Left)either).value()) instanceof AuthorizationException || throwable instanceof AuthenticationException);
                {
                }
            })).$times$greater(() -> this.$anonfun$4$$anonfun$6(driver, diagEm$14, done, results, finalResults$lzy1$6, totalRecordCount$7, recordIndices, records, startNanos), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop.continuation(Producer.scala:502)");
        };
        return this.sendQueue.offer((Object)Tuple3$.MODULE$.apply((Object)records, (Object)BoxesRunTime.boxToLong((long)startNanos), (Object)continuation), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop(Producer.scala:507)").unit((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures.loop(Producer.scala:507)");
    }

    private final /* synthetic */ ZIO produceChunkAsyncWithFailures$$anonfun$2$$anonfun$1(DiagnosticsEmitter diagEm$20, Chunk records$7, int totalRecordCount$16, LazyRef finalResults$lzy1$14, long startNanos) {
        return diagEm$20.emitOffer().flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Promise$.MODULE$.make((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:513)").flatMap((Function1 & Serializable)done -> this.settings.authErrorRetrySchedule().driver((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:514)").flatMap((Function1 & Serializable)d -> this.loop$2(totalRecordCount$16, diagEm$20, finalResults$lzy1$14, startNanos, (Seq)records$7.indices(), records$7, (Promise)done, (Schedule.Driver)d).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return done.await((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:516)");
            }, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:516)"), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:516)"), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:516)");
        }, (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:516)");
    }

    private final ZIO produceChunkAsyncWithFailures$$anonfun$2(int totalRecordCount$6, DiagnosticsEmitter diagEm$13, Chunk records$3, LazyRef finalResults$lzy1$5) {
        return Clock$.MODULE$.nanoTime((Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:511)").flatMap((Function1 & Serializable)startNanos -> this.produceChunkAsyncWithFailures$$anonfun$2$$anonfun$1(diagEm$13, records$3, totalRecordCount$6, finalResults$lzy1$5, BoxesRunTime.unboxToLong((Object)startNanos)), (Object)"zio.kafka.producer.ProducerLive.produceChunkAsyncWithFailures(Producer.scala:516)");
    }

    private final /* synthetic */ ZIO observeTake$$anonfun$1(long startNanos$13, long now) {
        return this.producerMetrics.observeSendQueueTake(DurationSyntax$.MODULE$.nanos$extension(package$.MODULE$.durationLong(startNanos$13 - now))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Object)"zio.kafka.producer.ProducerLive.observeTake(Producer.scala:531)");
    }

    public static final /* synthetic */ ProducerEvent.ProducedRecord zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitterMaker$$_$_$$anonfun$6(ProducerRecord record) {
        return ProducerEvent$ProducedRecord$.MODULE$.apply(record.topic(), Predef$.MODULE$.Integer2int(record.partition()), ((byte[])record.value()).length);
    }

    public static final /* synthetic */ boolean zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$_$_$$anonfun$7(Tuple2 _$8) {
        return ((Either)_$8._1()).isLeft();
    }

    public static final /* synthetic */ int zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$_$_$$anonfun$8(Tuple2 _$9) {
        return BoxesRunTime.unboxToInt((Object)_$9._2());
    }

    public static final ProducerEvent zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$_$emitFailures$$anonfun$1(ProducerEvent.RecordsSent recordSent$1) {
        return recordSent$1;
    }

    public class BatchDiagnosticsEmitter
    extends DiagnosticsEmitter {
        private final long batchId;
        private final Chunk<ProducerEvent.ProducedRecord> producedRecords;
        private final /* synthetic */ ProducerLive $outer;

        public BatchDiagnosticsEmitter(ProducerLive $outer, long batchId, Chunk<ProducerEvent.ProducedRecord> producedRecords) {
            this.batchId = batchId;
            this.producedRecords = producedRecords;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> emitOffer() {
            return this.$outer.zio$kafka$producer$ProducerLive$$diagnostics.emit((Function0<ProducerEvent>)((Function0 & Serializable)this::emitOffer$$anonfun$1));
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> emitSuccess() {
            return this.$outer.zio$kafka$producer$ProducerLive$$diagnostics.emit((Function0<ProducerEvent>)((Function0 & Serializable)this::emitSuccess$$anonfun$1));
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> emitSingleFailure() {
            return this.$outer.zio$kafka$producer$ProducerLive$$diagnostics.emit((Function0<ProducerEvent>)((Function0 & Serializable)this::emitSingleFailure$$anonfun$1));
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> emitFailures(Either<?, ?>[] finalResults) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])finalResults);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, ProducerLive::zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$_$_$$anonfun$7));
            BitSet failed = (BitSet)BitSet$.MODULE$.empty().$plus$plus((IterableOnce)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object3, ProducerLive::zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$_$_$$anonfun$8, ClassTag$.MODULE$.apply(Integer.TYPE))));
            ProducerEvent.RecordsSent recordSent = ProducerEvent$RecordsSent$.MODULE$.apply(this.batchId, this.producedRecords, (Set<Object>)failed);
            return this.$outer.zio$kafka$producer$ProducerLive$$diagnostics.emit((Function0<ProducerEvent>)((Function0 & Serializable)() -> ProducerLive.zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$_$emitFailures$$anonfun$1(recordSent)));
        }

        public final /* synthetic */ ProducerLive zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitter$$$outer() {
            return this.$outer;
        }

        private final ProducerEvent emitOffer$$anonfun$1() {
            return ProducerEvent$RecordsOffered$.MODULE$.apply(this.batchId, this.producedRecords);
        }

        private final ProducerEvent emitSuccess$$anonfun$1() {
            return ProducerEvent$RecordsSent$.MODULE$.apply(this.batchId, this.producedRecords, (Set<Object>)Predef$.MODULE$.Set().empty());
        }

        private final ProducerEvent emitSingleFailure$$anonfun$1() {
            return ProducerEvent$RecordsSent$.MODULE$.apply(this.batchId, this.producedRecords, ProducerLive$.zio$kafka$producer$ProducerLive$$$set0);
        }
    }

    public class BatchDiagnosticsEmitterMaker
    extends DiagnosticsEmitterMaker {
        private final AtomicLong batchIds;

        public BatchDiagnosticsEmitterMaker() {
            if (ProducerLive.this == null) {
                throw new NullPointerException();
            }
            this.batchIds = new AtomicLong(0L);
        }

        @Override
        public DiagnosticsEmitter makeDiagnosticsEmitter(ProducerRecord<byte[], byte[]> record) {
            return this.makeDiagnosticsEmitter((Chunk<ProducerRecord<byte[], byte[]>>)Chunk$.MODULE$.single(record));
        }

        @Override
        public DiagnosticsEmitter makeDiagnosticsEmitter(Chunk<ProducerRecord<byte[], byte[]>> records) {
            long batchId = this.batchIds.getAndIncrement();
            Chunk producedRecords = records.map(ProducerLive::zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitterMaker$$_$_$$anonfun$6);
            return new BatchDiagnosticsEmitter(ProducerLive.this, batchId, (Chunk<ProducerEvent.ProducedRecord>)producedRecords);
        }

        public final /* synthetic */ ProducerLive zio$kafka$producer$ProducerLive$BatchDiagnosticsEmitterMaker$$$outer() {
            return ProducerLive.this;
        }
    }
}

