/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer;

import java.io.Serializable;
import java.time.Duration;
import scala.;
import scala.$less$colon$less$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Schedule;
import zio.kafka.diagnostics.Diagnostics;
import zio.kafka.producer.ProducerCompression;
import zio.kafka.producer.ProducerEvent;
import zio.kafka.producer.ProducerSettings$;
import zio.kafka.security.KafkaCredentialStore;
import zio.metrics.MetricLabel;

public final class ProducerSettings
implements Product,
Serializable {
    private final Duration closeTimeout;
    private final int sendBufferSize;
    private final Schedule authErrorRetrySchedule;
    private final Map properties;
    private final Diagnostics diagnostics;
    private final Set metricLabels;

    public static ProducerSettings apply(Duration duration, int n, Schedule<Object, Throwable, Object> schedule, Map<String, Object> map, Diagnostics<ProducerEvent> diagnostics, Set<MetricLabel> set) {
        return ProducerSettings$.MODULE$.apply(duration, n, schedule, map, diagnostics, set);
    }

    public static ProducerSettings apply(List<String> list) {
        return ProducerSettings$.MODULE$.apply(list);
    }

    public static ProducerSettings fromProduct(Product product) {
        return ProducerSettings$.MODULE$.fromProduct(product);
    }

    public static ProducerSettings unapply(ProducerSettings producerSettings) {
        return ProducerSettings$.MODULE$.unapply(producerSettings);
    }

    public static Duration $lessinit$greater$default$1() {
        return ProducerSettings$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return ProducerSettings$.MODULE$.$lessinit$greater$default$2();
    }

    public static Schedule<Object, Throwable, Object> $lessinit$greater$default$3() {
        return ProducerSettings$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<String, Object> $lessinit$greater$default$4() {
        return ProducerSettings$.MODULE$.$lessinit$greater$default$4();
    }

    public static Diagnostics<ProducerEvent> $lessinit$greater$default$5() {
        return ProducerSettings$.MODULE$.$lessinit$greater$default$5();
    }

    public static Set<MetricLabel> $lessinit$greater$default$6() {
        return ProducerSettings$.MODULE$.$lessinit$greater$default$6();
    }

    public ProducerSettings(Duration closeTimeout, int sendBufferSize, Schedule<Object, Throwable, Object> authErrorRetrySchedule, Map<String, Object> properties, Diagnostics<ProducerEvent> diagnostics, Set<MetricLabel> metricLabels) {
        this.closeTimeout = closeTimeout;
        this.sendBufferSize = sendBufferSize;
        this.authErrorRetrySchedule = authErrorRetrySchedule;
        this.properties = properties;
        this.diagnostics = diagnostics;
        this.metricLabels = metricLabels;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
        n = Statics.mix((int)n, (int)this.sendBufferSize());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.authErrorRetrySchedule()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.diagnostics()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.metricLabels()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ProducerSettings)) return false;
        ProducerSettings producerSettings = (ProducerSettings)object;
        if (this.sendBufferSize() != producerSettings.sendBufferSize()) return false;
        Duration duration = this.closeTimeout();
        Duration duration2 = producerSettings.closeTimeout();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!((Object)duration).equals(duration2)) return false;
        Schedule<Object, Throwable, Object> schedule = this.authErrorRetrySchedule();
        Schedule<Object, Throwable, Object> schedule2 = producerSettings.authErrorRetrySchedule();
        if (schedule == null) {
            if (schedule2 != null) {
                return false;
            }
        } else if (!schedule.equals(schedule2)) return false;
        Map<String, Object> map = this.properties();
        Map<String, Object> map2 = producerSettings.properties();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Diagnostics<ProducerEvent> diagnostics = this.diagnostics();
        Diagnostics<ProducerEvent> diagnostics2 = producerSettings.diagnostics();
        if (diagnostics == null) {
            if (diagnostics2 != null) {
                return false;
            }
        } else if (!diagnostics.equals(diagnostics2)) return false;
        Set<MetricLabel> set = this.metricLabels();
        Set<MetricLabel> set2 = producerSettings.metricLabels();
        if (set == null) {
            if (set2 == null) return true;
            return false;
        } else {
            if (!set.equals(set2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ProducerSettings;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "ProducerSettings";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "closeTimeout";
            }
            case 1: {
                return "sendBufferSize";
            }
            case 2: {
                return "authErrorRetrySchedule";
            }
            case 3: {
                return "properties";
            }
            case 4: {
                return "diagnostics";
            }
            case 5: {
                return "metricLabels";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public Schedule<Object, Throwable, Object> authErrorRetrySchedule() {
        return this.authErrorRetrySchedule;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public Diagnostics<ProducerEvent> diagnostics() {
        return this.diagnostics;
    }

    public Set<MetricLabel> metricLabels() {
        return this.metricLabels;
    }

    public Map<String, Object> driverSettings() {
        return this.properties();
    }

    public ProducerSettings withBootstrapServers(List<String> servers) {
        return this.withProperty("bootstrap.servers", servers.mkString(","));
    }

    public ProducerSettings withClientId(String clientId) {
        return this.withProperty("client.id", clientId);
    }

    public ProducerSettings withCloseTimeout(Duration duration) {
        return this.copy(duration, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ProducerSettings withProperty(String key, Object value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        Map map = (Map)this.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value));
        Duration duration = this.copy$default$1();
        int n = this.copy$default$2();
        Schedule<Object, Throwable, Object> schedule = this.copy$default$3();
        Diagnostics<ProducerEvent> diagnostics = this.copy$default$5();
        Set<MetricLabel> set = this.copy$default$6();
        return this.copy(duration, n, schedule, (Map<String, Object>)map, diagnostics, set);
    }

    public ProducerSettings withProperties(Seq<Tuple2<String, Object>> kvs) {
        return this.withProperties((Map<String, Object>)kvs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ProducerSettings withProperties(Map<String, Object> kvs) {
        Map map = (Map)this.properties().$plus$plus(kvs);
        Duration duration = this.copy$default$1();
        int n = this.copy$default$2();
        Schedule<Object, Throwable, Object> schedule = this.copy$default$3();
        Diagnostics<ProducerEvent> diagnostics = this.copy$default$5();
        Set<MetricLabel> set = this.copy$default$6();
        return this.copy(duration, n, schedule, (Map<String, Object>)map, diagnostics, set);
    }

    public ProducerSettings withCredentials(KafkaCredentialStore credentialsStore) {
        return this.withProperties(credentialsStore.properties());
    }

    public ProducerSettings withLinger(Duration lingerDuration) {
        return this.withProperty("linger.ms", BoxesRunTime.boxToLong((long)lingerDuration.toMillis()).toString());
    }

    public ProducerSettings withCompression(ProducerCompression compression) {
        return this.withProperties(compression.properties());
    }

    public ProducerSettings withSendBufferSize(int sendBufferSize) {
        return this.copy(this.copy$default$1(), sendBufferSize, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ProducerSettings withAuthErrorRetrySchedule(Schedule<Object, Throwable, Object> authErrorRetrySchedule) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), authErrorRetrySchedule, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ProducerSettings withDiagnostics(Diagnostics<ProducerEvent> diagnostics) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), diagnostics, this.copy$default$6());
    }

    public ProducerSettings withMetricsLabels(Set<MetricLabel> metricLabels) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), metricLabels);
    }

    public ProducerSettings copy(Duration closeTimeout, int sendBufferSize, Schedule<Object, Throwable, Object> authErrorRetrySchedule, Map<String, Object> properties, Diagnostics<ProducerEvent> diagnostics, Set<MetricLabel> metricLabels) {
        return new ProducerSettings(closeTimeout, sendBufferSize, authErrorRetrySchedule, properties, diagnostics, metricLabels);
    }

    public Duration copy$default$1() {
        return this.closeTimeout();
    }

    public int copy$default$2() {
        return this.sendBufferSize();
    }

    public Schedule<Object, Throwable, Object> copy$default$3() {
        return this.authErrorRetrySchedule();
    }

    public Map<String, Object> copy$default$4() {
        return this.properties();
    }

    public Diagnostics<ProducerEvent> copy$default$5() {
        return this.diagnostics();
    }

    public Set<MetricLabel> copy$default$6() {
        return this.metricLabels();
    }

    public Duration _1() {
        return this.closeTimeout();
    }

    public int _2() {
        return this.sendBufferSize();
    }

    public Schedule<Object, Throwable, Object> _3() {
        return this.authErrorRetrySchedule();
    }

    public Map<String, Object> _4() {
        return this.properties();
    }

    public Diagnostics<ProducerEvent> _5() {
        return this.diagnostics();
    }

    public Set<MetricLabel> _6() {
        return this.metricLabels();
    }
}

