/*
 * Decompiled with CFR 0.152.
 */
package zio.kafka.producer.internal;

import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk$;
import zio.ZIO;
import zio.kafka.producer.internal.ProducerMetrics;
import zio.metrics.Metric;
import zio.metrics.Metric$;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricLabel;
import zio.metrics.MetricState;

public class ZioProducerMetrics
implements ProducerMetrics {
    private final MetricKeyType.Histogram.Boundaries produceLatencyBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)0.01), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$1 -> _$1 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)d -> Math.ceil(d * 100.0) / 100.0));
    private final MetricKeyType.Histogram.Boundaries batchSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)1.0), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$2 -> _$2 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0)));
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> produceCounter;
    private final Metric<MetricKeyType.Histogram, Duration, MetricState.Histogram> produceLatencyHistogram;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> produceRecordCounter;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> produceBatchSizeHistogram;
    private final MetricKeyType.Histogram.Boundaries sendQueueSizeBoundaries;
    private final MetricKeyType.Histogram.Boundaries queueLatencyBoundaries;
    private final Metric<MetricKeyType.Histogram, Object, MetricState.Histogram> sendQueueSizeHistogram;
    private final Metric<MetricKeyType.Histogram, Duration, MetricState.Histogram> sendQueueLatencyHistogram;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> sendAuthErrorCounter;

    public ZioProducerMetrics(Set<MetricLabel> metricLabels) {
        this.produceCounter = Metric$.MODULE$.counter("ziokafka_producer_calls", "The number of times a produce method is invoked.").tagged(metricLabels);
        this.produceLatencyHistogram = Metric$.MODULE$.histogram("ziokafka_producer_latency_seconds", "The duration of a single produce, from after serialization to acknowledged, in seconds.", this.produceLatencyBoundaries()).contramap((Function1 & Serializable)_$3 -> (double)_$3.toNanos() / 1.0E9).tagged(metricLabels);
        this.produceRecordCounter = Metric$.MODULE$.counter("ziokafka_producer_records", "The number of records produced.").tagged(metricLabels);
        this.produceBatchSizeHistogram = Metric$.MODULE$.histogram("ziokafka_producer_batch_size", "The number of records per produce call.", this.batchSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$4 -> _$4).tagged(metricLabels);
        this.sendQueueSizeBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0})).$plus$plus(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)10.0), 9, (Function1)(JFunction1.mcDD.sp & Serializable)_$5 -> _$5 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> Math.ceil(x$0))));
        this.queueLatencyBoundaries = MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.iterate((Object)BoxesRunTime.boxToDouble((double)0.001), 10, (Function1)(JFunction1.mcDD.sp & Serializable)_$6 -> _$6 * Math.E).map((Function1)(JFunction1.mcDD.sp & Serializable)d -> Math.ceil(d * 1000.0) / 1000.0));
        this.sendQueueSizeHistogram = Metric$.MODULE$.histogram("ziokafka_producer_send_queue_size", "The number of records in the zio-kafka send queue.", this.sendQueueSizeBoundaries()).contramap((Function1)(JFunction1.mcDI.sp & Serializable)_$7 -> _$7).tagged(metricLabels);
        this.sendQueueLatencyHistogram = Metric$.MODULE$.histogram("ziokafka_producer_send_queue_latency_seconds", "Time in send queue, including waiting for capacity, in seconds.", this.queueLatencyBoundaries()).contramap((Function1 & Serializable)_$8 -> (double)_$8.toNanos() / 1.0E9).tagged(metricLabels);
        this.sendAuthErrorCounter = Metric$.MODULE$.counterInt("ziokafka_producer_auth_errors", "The number of record sends that resulted in an authentication or authorization error.").tagged(metricLabels);
    }

    public MetricKeyType.Histogram.Boundaries produceLatencyBoundaries() {
        return this.produceLatencyBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries batchSizeBoundaries() {
        return this.batchSizeBoundaries;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeProduce(Duration latency, int batchSize) {
        return Metric$.MODULE$.CounterSyntax(this.produceCounter).increment((Numeric)Numeric.LongIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.produceLatencyHistogram.update(() -> ZioProducerMetrics.observeProduce$$anonfun$1$$anonfun$1(latency), (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeProduce(ProducerMetrics.scala:84)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Metric$.MODULE$.CounterSyntax(this.produceRecordCounter).incrementBy(() -> ZioProducerMetrics.observeProduce$$anonfun$1$$anonfun$2$$anonfun$1(batchSize), (Numeric)Numeric.LongIsIntegral$.MODULE$).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.produceBatchSizeHistogram.update(() -> ZioProducerMetrics.observeProduce$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(batchSize), (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeProduce(ProducerMetrics.scala:86)").map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeProduce(ProducerMetrics.scala:87)");
                }, (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeProduce(ProducerMetrics.scala:87)");
            }, (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeProduce(ProducerMetrics.scala:87)");
        }, (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeProduce(ProducerMetrics.scala:87)");
    }

    public MetricKeyType.Histogram.Boundaries sendQueueSizeBoundaries() {
        return this.sendQueueSizeBoundaries;
    }

    public MetricKeyType.Histogram.Boundaries queueLatencyBoundaries() {
        return this.queueLatencyBoundaries;
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeSendQueueSize(int size) {
        return this.sendQueueSizeHistogram.update(() -> ZioProducerMetrics.observeSendQueueSize$$anonfun$1(size), (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeSendQueueSize(ProducerMetrics.scala:126)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeSendQueueTake(Duration latency) {
        return this.sendQueueLatencyHistogram.update(() -> ZioProducerMetrics.observeSendQueueTake$$anonfun$1(latency), (Object)"zio.kafka.producer.internal.ZioProducerMetrics.observeSendQueueTake(ProducerMetrics.scala:129)");
    }

    @Override
    public ZIO<Object, Nothing$, BoxedUnit> observeSendAuthError(int errorCount) {
        return Metric$.MODULE$.CounterSyntax(this.sendAuthErrorCounter).incrementBy(() -> ZioProducerMetrics.observeSendAuthError$$anonfun$1(errorCount), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    private static final Duration observeProduce$$anonfun$1$$anonfun$1(Duration latency$2) {
        return latency$2;
    }

    private static final long observeProduce$$anonfun$1$$anonfun$2$$anonfun$1(int batchSize$3) {
        return batchSize$3;
    }

    private static final int observeProduce$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(int batchSize$5) {
        return batchSize$5;
    }

    private static final int observeSendQueueSize$$anonfun$1(int size$1) {
        return size$1;
    }

    private static final Duration observeSendQueueTake$$anonfun$1(Duration latency$3) {
        return latency$3;
    }

    private static final int observeSendAuthError$$anonfun$1(int errorCount$1) {
        return errorCount$1;
    }
}

