/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.Cause;
import zio.Exit;
import zio.Fiber;
import zio.FiberId;
import zio.FiberRef;
import zio.FiberRef$;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogLevel$;
import zio.LogSpan;
import zio.Queue;
import zio.Queue$;
import zio.Runtime$;
import zio.Scope;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZIOAspect;
import zio.ZIOAspect$;
import zio.ZLayer;
import zio.ZLayer$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogContext;
import zio.logging.LogContext$;
import zio.logging.LogFilter;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$;
import zio.logging.internal.FileWriter;
import zio.logging.package$;
import zio.logging.package$$anonfun$4$;
import zio.metrics.Metric;
import zio.metrics.Metric$;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricLabel;
import zio.metrics.MetricState;
import zio.package;

public final class package$ {
    public static final package$ MODULE$;
    private final FiberRef<LogContext> logContext;
    private final String loggerNameAnnotationKey;
    private final String logLevelMetricLabel;
    private final Metric<MetricKeyType$Counter$, Object, MetricState.Counter> loggedTotalMetric;
    private final ZLayer<Object, Nothing$, BoxedUnit> removeDefaultLoggers;
    private final ZLayer<Object, Nothing$, BoxedUnit> logMetrics;

    static {
        new package$();
    }

    public FiberRef<LogContext> logContext() {
        return this.logContext;
    }

    public String loggerNameAnnotationKey() {
        return this.loggerNameAnnotationKey;
    }

    public String logLevelMetricLabel() {
        return this.logLevelMetricLabel;
    }

    public Metric<MetricKeyType$Counter$, Object, MetricState.Counter> loggedTotalMetric() {
        return this.loggedTotalMetric;
    }

    public ZIOAspect<Nothing$, Object, Nothing$, Object, Nothing$, Object> loggerName(String value) {
        return ZIOAspect$.MODULE$.annotated(this.loggerNameAnnotationKey(), value);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> console(LogFormat format, LogLevel logLevel2) {
        return this.console(format, LogFilter$.MODULE$.logLevel(logLevel2));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> console(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toLogger(), System.out, logFilter);
    }

    public LogFormat console$default$1() {
        return LogFormat$.MODULE$.colored();
    }

    public LogLevel console$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleJson(LogFormat format, LogLevel logLevel2) {
        return this.consoleJson(format, LogFilter$.MODULE$.logLevel(logLevel2));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleJson(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toJsonLogger(), System.out, logFilter);
    }

    public LogFormat consoleJson$default$1() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel consoleJson$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErr(LogFormat format, LogLevel logLevel2) {
        return this.consoleErr(format, LogFilter$.MODULE$.logLevel(logLevel2));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErr(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toLogger(), System.err, logFilter);
    }

    public LogFormat consoleErr$default$1() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel consoleErr$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErrJson(LogFormat format, LogLevel logLevel2) {
        return this.consoleErrJson(format, LogFilter$.MODULE$.logLevel(logLevel2));
    }

    public ZLayer<Object, Nothing$, BoxedUnit> consoleErrJson(LogFormat format, LogFilter<String> logFilter) {
        return this.makeConsole(format.toJsonLogger(), System.err, logFilter);
    }

    public LogFormat consoleErrJson$default$1() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel consoleErrJson$default$2() {
        return LogLevel$.MODULE$.Info();
    }

    public ZLayer<Object, Nothing$, BoxedUnit> file(Path destination, LogFormat format, LogLevel logLevel2, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.file(destination, format, LogFilter$.MODULE$.logLevel(logLevel2), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> file(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return Runtime$.MODULE$.addLogger(this.makeStringLogger(destination, format.toLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize), (Object)"zio.logging.package.file(package.scala:132)");
    }

    public LogFormat file$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel file$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset file$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int file$default$5() {
        return 1;
    }

    public Option<Object> file$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileJson(Path destination, LogFormat format, LogLevel logLevel2, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.fileJson(destination, format, LogFilter$.MODULE$.logLevel(logLevel2), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileJson(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return Runtime$.MODULE$.addLogger(this.makeStringLogger(destination, format.toJsonLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize), (Object)"zio.logging.package.fileJson(package.scala:161)");
    }

    public LogFormat fileJson$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel fileJson$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset fileJson$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int fileJson$default$5() {
        return 1;
    }

    public Option<Object> fileJson$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsync(Path destination, LogFormat format, LogLevel logLevel2, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.fileAsync(destination, format, LogFilter$.MODULE$.logLevel(logLevel2), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsync(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.makeFileAsync(destination, format.toLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize);
    }

    public LogFormat fileAsync$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel fileAsync$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset fileAsync$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int fileAsync$default$5() {
        return 1;
    }

    public Option<Object> fileAsync$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsyncJson(Path destination, LogFormat format, LogLevel logLevel2, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.fileAsyncJson(destination, format, LogFilter$.MODULE$.logLevel(logLevel2), charset, autoFlushBatchSize, bufferedIOSize);
    }

    public ZLayer<Object, Nothing$, BoxedUnit> fileAsyncJson(Path destination, LogFormat format, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return this.makeFileAsync(destination, format.toJsonLogger(), logFilter, charset, autoFlushBatchSize, bufferedIOSize);
    }

    public LogFormat fileAsyncJson$default$2() {
        return LogFormat$.MODULE$.default();
    }

    public LogLevel fileAsyncJson$default$3() {
        return LogLevel$.MODULE$.Info();
    }

    public Charset fileAsyncJson$default$4() {
        return StandardCharsets.UTF_8;
    }

    public int fileAsyncJson$default$5() {
        return 1;
    }

    public Option<Object> fileAsyncJson$default$6() {
        return None$.MODULE$;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> removeDefaultLoggers() {
        return this.removeDefaultLoggers;
    }

    private ZLayer<Object, Nothing$, BoxedUnit> makeConsole(ZLogger<String, String> logger, PrintStream stream, LogFilter<String> logFilter) {
        ZLogger stringLogger = logFilter.filter(logger.map((Function1)new Serializable(stream){
            public static final long serialVersionUID = 0L;
            private final PrintStream stream$1;

            /*
             * Loose catch block
             */
            public final void apply(String line) {
                try {
                    this.stream$1.println(line);
                }
                catch (Throwable throwable) {}
                return;
                catch (VirtualMachineError virtualMachineError) {
                    throw virtualMachineError;
                }
            }
            {
                this.stream$1 = stream$1;
            }
        }));
        return Runtime$.MODULE$.addLogger(stringLogger, (Object)"zio.logging.package.makeConsole(package.scala:256)");
    }

    private ZLogger<String, Object> makeStringLogger(Path destination, ZLogger<String, String> logger, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        FileWriter logWriter = new FileWriter(destination, charset, autoFlushBatchSize, bufferedIOSize);
        ZLogger stringLogger = logFilter.filter(logger.map((Function1)new Serializable(logWriter){
            public static final long serialVersionUID = 0L;
            private final FileWriter logWriter$1;

            /*
             * Loose catch block
             */
            public final void apply(String line) {
                try {
                    this.logWriter$1.writeln(line);
                }
                catch (Throwable throwable) {}
                return;
                catch (VirtualMachineError virtualMachineError) {
                    throw virtualMachineError;
                }
            }
            {
                this.logWriter$1 = logWriter$1;
            }
        }));
        return stringLogger;
    }

    private ZLayer<Object, Nothing$, BoxedUnit> makeFileAsync(Path destination, ZLogger<String, String> logger, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize) {
        return ZLayer.ScopedPartiallyApplied$.MODULE$.apply$extension(ZLayer$.MODULE$.scoped(), (Function0)new Serializable(destination, logger, logFilter, charset, autoFlushBatchSize, bufferedIOSize){
            public static final long serialVersionUID = 0L;
            public final Path destination$1;
            public final ZLogger logger$1;
            public final LogFilter logFilter$1;
            public final Charset charset$1;
            public final int autoFlushBatchSize$1;
            public final Option bufferedIOSize$1;

            public final ZIO<Scope, Nothing$, BoxedUnit> apply() {
                return Queue$.MODULE$.bounded((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 1000;
                    }
                }, (Object)"zio.logging.package.makeFileAsync(package.scala:290)").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.makeFileAsync.1 $outer;

                    public final Tuple2<Queue<ZIO<Object, Nothing$, Object>>, ZLogger<String, Object>> apply(Queue<ZIO<Object, Nothing$, Object>> queue) {
                        ZLogger<String, Object> stringLogger = package$.MODULE$.zio$logging$package$$makeAsyncStringLogger(this.$outer.destination$1, (ZLogger<String, String>)this.$outer.logger$1, this.$outer.logFilter$1, this.$outer.charset$1, this.$outer.autoFlushBatchSize$1, (Option<Object>)this.$outer.bufferedIOSize$1, queue);
                        return new Tuple2(queue, stringLogger);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Object)"zio.logging.package.makeFileAsync(package.scala:290)").flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ZIO<Scope, Nothing$, BoxedUnit> apply(Tuple2<Queue<ZIO<Object, Nothing$, Object>>, ZLogger<String, Object>> x$2) {
                        Tuple2<Queue<ZIO<Object, Nothing$, Object>>, ZLogger<String, Object>> tuple2 = x$2;
                        if (tuple2 != null) {
                            Queue queue = (Queue)tuple2._1();
                            ZLogger stringLogger = (ZLogger)tuple2._2();
                            ZIO zIO = FiberRef$.MODULE$.currentLoggers().locallyScopedWith((Function1)new Serializable(this, stringLogger){
                                public static final long serialVersionUID = 0L;
                                private final ZLogger stringLogger$1;

                                public final Set<ZLogger<String, Object>> apply(Set<ZLogger<String, Object>> x$1) {
                                    return (Set)x$1.$plus((Object)this.stringLogger$1);
                                }
                                {
                                    this.stringLogger$1 = stringLogger$1;
                                }
                            }, (Object)"zio.logging.package.makeFileAsync(package.scala:293)").flatMap((Function1)new Serializable(this, queue){
                                public static final long serialVersionUID = 0L;
                                private final Queue queue$2;

                                public final ZIO<Object, Nothing$, BoxedUnit> apply(BoxedUnit _) {
                                    return this.queue$2.take((Object)"zio.logging.package.makeFileAsync(package.scala:294)").flatMap((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final ZIO<Object, Nothing$, BoxedUnit> apply(ZIO<Object, Nothing$, Object> task) {
                                            return task.ignore((Object)"zio.logging.package.makeFileAsync(package.scala:294)");
                                        }
                                    }, (Object)"zio.logging.package.makeFileAsync(package.scala:294)").forever((Object)"zio.logging.package.makeFileAsync(package.scala:294)").forkScoped((Object)"zio.logging.package.makeFileAsync(package.scala:294)").map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(Fiber.Runtime<Nothing$, Nothing$> _) {
                                        }
                                    }, (Object)"zio.logging.package.makeFileAsync(package.scala:294)");
                                }
                                {
                                    this.queue$2 = queue$2;
                                }
                            }, (Object)"zio.logging.package.makeFileAsync(package.scala:293)");
                            return zIO;
                        }
                        throw new MatchError(tuple2);
                    }
                }, (Object)"zio.logging.package.makeFileAsync(package.scala:290)");
            }
            {
                this.destination$1 = destination$1;
                this.logger$1 = logger$1;
                this.logFilter$1 = logFilter$1;
                this.charset$1 = charset$1;
                this.autoFlushBatchSize$1 = autoFlushBatchSize$1;
                this.bufferedIOSize$1 = bufferedIOSize$1;
            }
        }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(BoxedUnit.class, LightTypeTag$.MODULE$.parse(1191865462, "\u0004\u0000\u0001\nscala.Unit\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 21))), (Object)"zio.logging.package.makeFileAsync(package.scala:288)");
    }

    public ZLogger<String, Object> zio$logging$package$$makeAsyncStringLogger(Path destination, ZLogger<String, String> logger, LogFilter<String> logFilter, Charset charset, int autoFlushBatchSize, Option<Object> bufferedIOSize, Queue<ZIO<Object, Nothing$, Object>> queue) {
        FileWriter logWriter = new FileWriter(destination, charset, autoFlushBatchSize, bufferedIOSize);
        ZLogger stringLogger = logFilter.filter(logger.map((Function1)new Serializable(queue, logWriter){
            public static final long serialVersionUID = 0L;
            public final Queue queue$1;
            public final FileWriter logWriter$2;

            public final Exit<Nothing$, Object> apply(String line) {
                return (Exit)Unsafe$.MODULE$.unsafe((Function1)new Serializable(this, line){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;
                    public final String line$1;

                    public final Exit<Nothing$, Object> apply(Unsafe u) {
                        return Runtime$.MODULE$.default().unsafe().run(this.$outer.queue$1.offer((Object)ZIO$.MODULE$.succeed((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$4$$anonfun$apply$9 $outer;

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object apply() {
                                BoxedUnit boxedUnit;
                                try {
                                    this.$outer.zio$logging$package$$anonfun$$anonfun$$$outer().logWriter$2.writeln(this.$outer.line$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                    return boxedUnit;
                                }
                                catch (Throwable throwable) {
                                    boxedUnit = BoxedUnit.UNIT;
                                    return boxedUnit;
                                }
                                catch (VirtualMachineError virtualMachineError) {
                                    throw virtualMachineError;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, (Object)"zio.logging.package.makeAsyncStringLogger.stringLogger(package.scala:311)"), (Object)"zio.logging.package.makeAsyncStringLogger.stringLogger(package.scala:311)"), (Object)"zio.logging.package.makeAsyncStringLogger.stringLogger(package.scala:311)", u);
                    }

                    public /* synthetic */ anonfun.4 zio$logging$package$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.line$1 = line$1;
                    }
                });
            }
            {
                this.queue$1 = queue$1;
                this.logWriter$2 = logWriter$2;
            }
        }));
        return stringLogger;
    }

    private Object metricLogger(Metric<MetricKeyType$Counter$, Object, MetricState.Counter> counter, String logLevelLabel) {
        return new ZLogger<String, BoxedUnit>(counter, logLevelLabel){
            private final Metric counter$1;
            private final String logLevelLabel$1;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.class.$plus$plus((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.class.$plus$greater((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.class.$less$plus((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.class.contramap((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.class.filterLogLevel((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.class.map((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.class.test((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel2, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans2, Map<String, String> annotations2) {
                Set tags = (Set)context.get(FiberRef$.MODULE$.currentTags()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<MetricLabel> apply() {
                        return Predef$.MODULE$.Set().empty();
                    }
                });
                this.counter$1.unsafe().update((Object)BoxesRunTime.boxToLong((long)1L), (Set)tags.$plus((Object)new MetricLabel(this.logLevelLabel$1, logLevel2.label().toLowerCase())), Unsafe$.MODULE$.unsafe());
            }
            {
                this.counter$1 = counter$1;
                this.logLevelLabel$1 = logLevelLabel$1;
                ZLogger.class.$init$((ZLogger)this);
            }
        };
    }

    public ZLayer<Object, Nothing$, BoxedUnit> logMetrics() {
        return this.logMetrics;
    }

    public ZLayer<Object, Nothing$, BoxedUnit> logMetricsWith(String name, String logLevelLabel) {
        return Runtime$.MODULE$.addLogger(this.metricLogger(Metric$.MODULE$.counter(name), logLevelLabel), (Object)"zio.logging.package.logMetricsWith(package.scala:344)");
    }

    private package$() {
        MODULE$ = this;
        this.logContext = (FiberRef)Unsafe$.MODULE$.unsafe((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FiberRef<LogContext> apply(Unsafe u) {
                return FiberRef.unsafe$.MODULE$.make((Object)LogContext$.MODULE$.empty(), ZIO$.MODULE$.identityFn(), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LogContext apply(LogContext old, LogContext newV) {
                        return old.$plus$plus(newV);
                    }
                }, u);
            }
        });
        this.loggerNameAnnotationKey = "logger_name";
        this.logLevelMetricLabel = "level";
        this.loggedTotalMetric = Metric$.MODULE$.counter("zio_log_total");
        this.removeDefaultLoggers = Runtime$.MODULE$.removeDefaultLoggers();
        this.logMetrics = Runtime$.MODULE$.addLogger(this.metricLogger(this.loggedTotalMetric(), this.logLevelMetricLabel()), (Object)"zio.logging.package.logMetrics(package.scala:341)");
    }
}

