/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Trace$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogAnnotation;
import zio.logging.LogColor;
import zio.logging.LogColor$;
import zio.logging.LogContext;
import zio.logging.LogFilter;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$Pattern$;
import zio.logging.LoggerNameExtractor;
import zio.logging.internal.LogAppender;
import zio.logging.package$;
import zio.parser.Parser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LogFormat$ {
    public static LogFormat$ MODULE$;
    private final String NL;
    private final Config<LogFormat> config;
    private final LogFormat bracketStart;
    private final LogFormat bracketEnd;
    private final LogFormat empty;
    private final LogFormat enclosingClass;
    private final LogFormat fiberId;
    private final LogFormat level;
    private final LogFormat levelSyslog;
    private final LogFormat line;
    private final LogFormat traceLine;
    private final LogFormat cause;
    private final LogFormat newLine;
    private final LogFormat space;
    private final LogFormat quote;
    private final LogFormat timestamp;
    private final LogFormat default;
    private final LogFormat colored;

    static {
        new LogFormat$();
    }

    private String NL() {
        return this.NL;
    }

    public Config<LogFormat> config() {
        return this.config;
    }

    public LogFormat make(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> format) {
        return new LogFormat(format){
            private final Function9 format$1;

            public final LogFormat $plus(LogFormat other) {
                return LogFormat.$plus$(this, other);
            }

            public final LogFormat $bar$minus$bar(LogFormat other) {
                return LogFormat.$bar$minus$bar$(this, other);
            }

            public final LogFormat color(String color) {
                return LogFormat.color$(this, color);
            }

            public final LogFormat concat(LogFormat other) {
                return LogFormat.concat$(this, other);
            }

            public final <M> LogFormat filter(LogFilter<M> filter) {
                return LogFormat.filter$(this, filter);
            }

            public final LogFormat fixed(int size) {
                return LogFormat.fixed$(this, size);
            }

            public final LogFormat highlight(Function1<LogLevel, LogColor> fn) {
                return LogFormat.highlight$(this, fn);
            }

            public final LogFormat highlight() {
                return LogFormat.highlight$(this);
            }

            public final LogFormat spaced(LogFormat other) {
                return LogFormat.spaced$(this, other);
            }

            public final ZLogger<String, String> toJsonLogger() {
                return LogFormat.toJsonLogger$(this);
            }

            public final ZLogger<String, String> toLogger() {
                return LogFormat.toLogger$(this);
            }

            public final ZLogger<String, BoxedUnit> unsafeFormat(LogAppender builder) {
                return LogFormat$.zio$logging$LogFormat$$$anonfun$make$1(builder, this.format$1);
            }
            {
                this.format$1 = format$1;
                LogFormat.$init$(this);
            }
        };
    }

    public LogFormat loggerName(LoggerNameExtractor loggerNameExtractor, String loggerNameDefault) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$15, x$16, x$17, x$18, context, x$19, annotations) -> {
            LogFormat$.$anonfun$loggerName$1(loggerNameExtractor, loggerNameDefault, builder, trace, x$15, x$16, x$17, x$18, context, x$19, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public String loggerName$default$2() {
        return "zio-logger";
    }

    public LogFormat annotation(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$20, x$21, x$22, x$23, x$24, x$25, x$26, annotations) -> {
            LogFormat$.$anonfun$annotation$1(name, builder, x$20, x$21, x$22, x$23, x$24, x$25, x$26, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat logAnnotation(LogAnnotation<A> ann) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$27, x$28, x$29, x$30, x$31, fiberRefs, x$32, x$33) -> {
            LogFormat$.$anonfun$logAnnotation$1(ann, builder, x$27, x$28, x$29, x$30, x$31, fiberRefs, x$32, x$33);
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat annotation(LogAnnotation<A> ann) {
        return this.logAnnotation(ann);
    }

    public LogFormat anyAnnotation(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$34, x$35, x$36, x$37, x$38, fiberRefs, x$39, annotations) -> {
            LogFormat$.$anonfun$anyAnnotation$1(name, builder, x$34, x$35, x$36, x$37, x$38, fiberRefs, x$39, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat annotations() {
        return this.annotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat annotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$41, x$42, x$43, x$44, x$45, x$46, x$47, annotations) -> {
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)annotations.filterNot((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)excludeKeys$1.contains(kv._1()))));
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat logAnnotations() {
        return this.logAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat logAnnotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$48, x$49, x$50, x$51, x$52, fiberRefs, x$53, x$54) -> {
            LogFormat$.$anonfun$logAnnotations$1(excludeKeys, builder, x$48, x$49, x$50, x$51, x$52, fiberRefs, x$53, x$54);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat allAnnotations() {
        return this.allAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat allAnnotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$55, x$56, x$57, x$58, x$59, fiberRefs, x$60, annotations) -> {
            LogFormat$.$anonfun$allAnnotations$1(excludeKeys, builder, x$55, x$56, x$57, x$58, x$59, fiberRefs, x$60, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat bracketed(LogFormat inner) {
        return this.bracketStart().$plus(inner).$plus(this.bracketEnd());
    }

    public LogFormat bracketStart() {
        return this.bracketStart;
    }

    public LogFormat bracketEnd() {
        return this.bracketEnd;
    }

    public LogFormat empty() {
        return this.empty;
    }

    public LogFormat enclosingClass() {
        return this.enclosingClass;
    }

    public LogFormat fiberId() {
        return this.fiberId;
    }

    public LogFormat level() {
        return this.level;
    }

    public LogFormat levelSyslog() {
        return this.levelSyslog;
    }

    public LogFormat line() {
        return this.line;
    }

    public LogFormat traceLine() {
        return this.traceLine;
    }

    public LogFormat cause() {
        return this.cause;
    }

    public LogFormat ifCauseNonEmpty(LogFormat format) {
        return format.filter(LogFilter$.MODULE$.causeNonEmpty());
    }

    public LogFormat label(Function0<String> label, LogFormat value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, fiberId, logLevel, message, cause, context, spans, annotations) -> {
            Object object;
            builder.openKey();
            try {
                builder.appendText((String)label.apply());
            }
            finally {
                builder.closeKeyOpenValue();
            }
            try {
                object = value.unsafeFormat((LogAppender)builder).apply(trace, fiberId, logLevel, message, cause, context, spans, annotations);
            }
            finally {
                builder.closeValue();
            }
            return object;
        });
    }

    public LogFormat newLine() {
        return this.newLine;
    }

    public LogFormat space() {
        return this.space;
    }

    public LogFormat quote() {
        return this.quote;
    }

    public LogFormat quoted(LogFormat inner) {
        return this.quote().$plus(inner).$plus(this.quote());
    }

    public LogFormat span(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$119, x$120, x$121, x$122, x$123, x$124, spans, x$125) -> {
            LogFormat$.$anonfun$span$1(name, builder, x$119, x$120, x$121, x$122, x$123, x$124, spans, x$125);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat spans() {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$127, x$128, x$129, x$130, x$131, x$132, spans, x$133) -> {
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)((Iterable)spans.map((Function1 & Serializable & scala.Serializable)span -> {
                String duration = Long.toString(System.currentTimeMillis() - span.startTime());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)span.label()), (Object)new StringBuilder(2).append(duration).append("ms").toString());
            }, List$.MODULE$.canBuildFrom())));
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat text(Function0<String> value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141) -> {
            builder.appendText((String)value.apply());
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat timestamp() {
        return this.timestamp;
    }

    public LogFormat timestamp(Function0<DateTimeFormatter> formatter) {
        return this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            ZonedDateTime now = ZonedDateTime.now();
            return ((DateTimeFormatter)formatter.apply()).format(now);
        });
    }

    public LogFormat default() {
        return this.default;
    }

    public LogFormat colored() {
        return this.colored;
    }

    public static final /* synthetic */ ZLogger zio$logging$LogFormat$$$anonfun$make$1(LogAppender builder, Function9 format$1) {
        return new ZLogger<String, BoxedUnit>(format$1, builder){
            private final Function9 format$1;
            private final LogAppender builder$3;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.$plus$plus$((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.$plus$greater$((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.$less$plus$((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.contramap$((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.filterLogLevel$((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.map$((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.test$((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
                this.format$1.apply((Object)this.builder$3, trace, (Object)fiberId, (Object)logLevel, message, cause, (Object)context, spans, annotations);
            }
            {
                this.format$1 = format$1;
                this.builder$3 = builder$3;
                ZLogger.$init$((ZLogger)this);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$loggerName$1(LoggerNameExtractor loggerNameExtractor$1, String loggerNameDefault$1, LogAppender builder, Object trace, FiberId x$15, LogLevel x$16, Function0 x$17, Cause x$18, FiberRefs context, List x$19, Map annotations) {
        String loggerName = (String)loggerNameExtractor$1.apply(trace, context, (Map<String, String>)annotations).getOrElse((Function0 & Serializable & scala.Serializable)() -> loggerNameDefault$1);
        builder.appendText(loggerName);
    }

    public static final /* synthetic */ void $anonfun$annotation$1(String name$1, LogAppender builder, Object x$20, FiberId x$21, LogLevel x$22, Function0 x$23, Cause x$24, FiberRefs x$25, List x$26, Map annotations) {
        annotations.get((Object)name$1).foreach((Function1 & Serializable & scala.Serializable)value -> {
            builder.appendKeyValue(name$1, value);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotation$2(LogAnnotation ann$1, LogAppender builder$5, LogContext context) {
        context.get(ann$1).foreach((Function1 & Serializable & scala.Serializable)value -> {
            builder$5.appendKeyValue(ann$1.name(), (String)ann$1.render().apply(value));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotation$1(LogAnnotation ann$1, LogAppender builder, Object x$27, FiberId x$28, LogLevel x$29, Function0 x$30, Cause x$31, FiberRefs fiberRefs, List x$32, Map x$33) {
        fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1 & Serializable & scala.Serializable)context -> {
            LogFormat$.$anonfun$logAnnotation$2(ann$1, builder, context);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$anyAnnotation$1(String name$2, LogAppender builder, Object x$34, FiberId x$35, LogLevel x$36, Function0 x$37, Cause x$38, FiberRefs fiberRefs, List x$39, Map annotations) {
        annotations.get((Object)name$2).orElse((Function0 & Serializable & scala.Serializable)() -> fiberRefs.get(package$.MODULE$.logContext()).flatMap((Function1 & Serializable & scala.Serializable)x$40 -> x$40.get(name$2))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            builder.appendKeyValue(name$2, value);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$1(Set excludeKeys$2, LogAppender builder, Object x$48, FiberId x$49, LogLevel x$50, Function0 x$51, Cause x$52, FiberRefs fiberRefs, List x$53, Map x$54) {
        fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1 & Serializable & scala.Serializable)context -> {
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)context.asMap().filterNot((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)excludeKeys$2.contains(kv._1()))));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$allAnnotations$1(Set excludeKeys$3, LogAppender builder, Object x$55, FiberId x$56, LogLevel x$57, Function0 x$58, Cause x$59, FiberRefs fiberRefs, List x$60, Map annotations) {
        List keyValues = (List)annotations.filterNot((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)excludeKeys$3.contains(kv._1()))).toList().$plus$plus((GenTraversableOnce)fiberRefs.get(package$.MODULE$.logContext()).map((Function1 & Serializable & scala.Serializable)context -> context.asMap().filterNot((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)excludeKeys$3.contains(kv._1()))).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), List$.MODULE$.canBuildFrom());
        builder.appendKeyValues((Iterable<Tuple2<String, String>>)keyValues);
    }

    public static final /* synthetic */ void $anonfun$empty$1(LogAppender x$61, Object x$62, FiberId x$63, LogLevel x$64, Function0 x$65, Cause x$66, FiberRefs x$67, List x$68, Map x$69) {
    }

    public static final /* synthetic */ boolean $anonfun$span$2(String name$3, LogSpan x$126) {
        String string = x$126.label();
        return !(string != null ? !string.equals(name$3) : name$3 != null);
    }

    public static final /* synthetic */ void $anonfun$span$3(LogAppender builder$8, String name$3, LogSpan span) {
        String duration = Long.toString(System.currentTimeMillis() - span.startTime());
        builder$8.appendKeyValue(name$3, new StringBuilder(2).append(duration).append("ms").toString());
    }

    public static final /* synthetic */ void $anonfun$span$1(String name$3, LogAppender builder, Object x$119, FiberId x$120, LogLevel x$121, Function0 x$122, Cause x$123, FiberRefs x$124, List spans, Map x$125) {
        spans.find((Function1 & Serializable & scala.Serializable)x$126 -> BoxesRunTime.boxToBoolean((boolean)LogFormat$.$anonfun$span$2(name$3, x$126))).foreach((Function1 & Serializable & scala.Serializable)span -> {
            LogFormat$.$anonfun$span$3(builder, name$3, span);
            return BoxedUnit.UNIT;
        });
    }

    private LogFormat$() {
        MODULE$ = this;
        this.NL = System.lineSeparator();
        this.config = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)value -> {
            Either<Parser.ParserError<String>, LogFormat.Pattern> either = LogFormat$Pattern$.MODULE$.parse((String)value);
            if (either instanceof Right) {
                LogFormat.Pattern p = (LogFormat.Pattern)((Right)either).value();
                return scala.package$.MODULE$.Right().apply((Object)p.toLogFormat());
            }
            if (either instanceof Left) {
                return scala.package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(32).append("Expected a LogFormat, but found ").append((String)value).toString()));
            }
            throw new MatchError(either);
        });
        this.bracketStart = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[");
        this.bracketEnd = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "]");
        this.empty = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69) -> {
            LogFormat$.$anonfun$empty$1(x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69);
            return BoxedUnit.UNIT;
        });
        this.enclosingClass = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$70, x$71, x$72, x$73, x$74, x$75, x$76) -> {
            Object object;
            Option option;
            Option option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace);
            if (!option2.isEmpty() && !(option = Trace$.MODULE$.unapply(object = option2.get())).isEmpty()) {
                String file = (String)((Tuple3)option.get())._2();
                builder.appendText(file);
                return BoxedUnit.UNIT;
            }
            builder.appendText("not-available");
            return BoxedUnit.UNIT;
        });
        this.fiberId = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$77, fiberId, x$78, x$79, x$80, x$81, x$82, x$83) -> {
            builder.appendText(fiberId.threadName());
            return BoxedUnit.UNIT;
        });
        this.level = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$84, x$85, level, x$86, x$87, x$88, x$89, x$90) -> {
            builder.appendText(level.label());
            return BoxedUnit.UNIT;
        });
        this.levelSyslog = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$91, x$92, level, x$93, x$94, x$95, x$96, x$97) -> {
            builder.appendText(Integer.toString(level.syslog()));
            return BoxedUnit.UNIT;
        });
        this.line = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$98, x$99, x$100, line, x$101, x$102, x$103, x$104) -> {
            builder.appendText((String)line.apply());
            return BoxedUnit.UNIT;
        });
        this.traceLine = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$105, x$106, x$107, x$108, x$109, x$110, x$111) -> {
            Object object;
            Option option;
            Option option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace);
            if (!option2.isEmpty() && !(option = Trace$.MODULE$.unapply(object = option2.get())).isEmpty()) {
                int line = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3());
                builder.appendNumeric(BoxesRunTime.boxToInteger((int)line));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.cause = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$112, x$113, x$114, x$115, cause, x$116, x$117, x$118) -> {
            if (!cause.isEmpty()) {
                builder.appendCause((Cause<Object>)cause);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.newLine = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.NL());
        this.space = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> " ");
        this.quote = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "\"");
        this.timestamp = this.timestamp((Function0<DateTimeFormatter>)(Function0 & Serializable & scala.Serializable)() -> DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.default = this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timestamp", this.timestamp().fixed(32)).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "level", this.level())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "thread", this.fiberId())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "message", this.quoted(this.line())).$plus(this.space().$plus(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "cause", this.cause())).filter(LogFilter$.MODULE$.causeNonEmpty())));
        this.colored = this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timestamp", this.timestamp().fixed(32)).color(LogColor$.MODULE$.BLUE()).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "level", this.level()).highlight()).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "thread", this.fiberId()).color(LogColor$.MODULE$.WHITE())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "message", this.quoted(this.line())).highlight().$plus(this.space().$plus(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "cause", this.cause()).highlight()).filter(LogFilter$.MODULE$.causeNonEmpty())));
    }
}

