/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Trace$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogAnnotation;
import zio.logging.LogColor$;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$Pattern$;
import zio.logging.LoggerNameExtractor;
import zio.logging.internal.LogAppender;
import zio.parser.Parser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LogFormat$ {
    public static LogFormat$ MODULE$;
    private final String NL;
    private final Config<LogFormat> config;
    private final LogFormat annotations;
    private final LogFormat logAnnotations;
    private final LogFormat allAnnotations;
    private final LogFormat bracketStart;
    private final LogFormat bracketEnd;
    private final LogFormat empty;
    private final LogFormat enclosingClass;
    private final LogFormat fiberId;
    private final LogFormat level;
    private final LogFormat levelSyslog;
    private final LogFormat line;
    private final LogFormat traceLine;
    private final LogFormat cause;
    private final LogFormat newLine;
    private final LogFormat space;
    private final LogFormat quote;
    private final LogFormat spans;
    private final LogFormat timestamp;
    private final LogFormat default;
    private final LogFormat colored;

    static {
        new LogFormat$();
    }

    public ZLogger<String, BoxedUnit> makeLogger(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> fn, LogAppender builder) {
        return new ZLogger<String, BoxedUnit>(fn, builder){
            private final Function9 fn$1;
            private final LogAppender builder$3;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.$plus$plus$((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.$plus$greater$((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.$less$plus$((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.contramap$((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.filterLogLevel$((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.map$((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.test$((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
                this.fn$1.apply((Object)this.builder$3, trace, (Object)fiberId, (Object)logLevel, message, cause, (Object)context, spans, annotations);
            }
            {
                this.fn$1 = fn$1;
                this.builder$3 = builder$3;
                ZLogger.$init$((ZLogger)this);
            }
        };
    }

    private String NL() {
        return this.NL;
    }

    public Config<LogFormat> config() {
        return this.config;
    }

    public LogFormat make(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> format) {
        return new LogFormat.FnFormat(format);
    }

    public LogFormat loggerName(LoggerNameExtractor loggerNameExtractor, String loggerNameDefault) {
        return new LogFormat.LoggerNameFormat(loggerNameExtractor, loggerNameDefault);
    }

    public String loggerName$default$2() {
        return "zio-logger";
    }

    public LogFormat annotation(String name) {
        return new LogFormat.AnnotationFormat(name);
    }

    public <A> LogFormat logAnnotation(LogAnnotation<A> ann) {
        return new LogFormat.LogAnnotationFormat<A>(ann);
    }

    public <A> LogFormat annotation(LogAnnotation<A> ann) {
        return this.logAnnotation(ann);
    }

    public LogFormat anyAnnotation(String name) {
        return new LogFormat.AnyAnnotationFormat(name);
    }

    public LogFormat annotations() {
        return this.annotations;
    }

    public LogFormat annotations(Set<String> excludeKeys) {
        return new LogFormat.AnnotationsFormat(excludeKeys);
    }

    public LogFormat logAnnotations() {
        return this.logAnnotations;
    }

    public LogFormat logAnnotations(Set<String> excludeKeys) {
        return new LogFormat.LogAnnotationsFormat(excludeKeys);
    }

    public LogFormat allAnnotations() {
        return this.allAnnotations;
    }

    public LogFormat allAnnotations(Set<String> excludeKeys) {
        return new LogFormat.AllAnnotationsFormat(excludeKeys);
    }

    public LogFormat bracketed(LogFormat inner) {
        return this.bracketStart().$plus(inner).$plus(this.bracketEnd());
    }

    public LogFormat bracketStart() {
        return this.bracketStart;
    }

    public LogFormat bracketEnd() {
        return this.bracketEnd;
    }

    public LogFormat empty() {
        return this.empty;
    }

    public LogFormat enclosingClass() {
        return this.enclosingClass;
    }

    public LogFormat fiberId() {
        return this.fiberId;
    }

    public LogFormat level() {
        return this.level;
    }

    public LogFormat levelSyslog() {
        return this.levelSyslog;
    }

    public LogFormat line() {
        return this.line;
    }

    public LogFormat traceLine() {
        return this.traceLine;
    }

    public LogFormat cause() {
        return this.cause;
    }

    public LogFormat label(Function0<String> label, LogFormat value) {
        return new LogFormat.LabelFormat((String)label.apply(), value);
    }

    public LogFormat newLine() {
        return this.newLine;
    }

    public LogFormat space() {
        return this.space;
    }

    public LogFormat quote() {
        return this.quote;
    }

    public LogFormat quoted(LogFormat inner) {
        return this.quote().$plus(inner).$plus(this.quote());
    }

    public LogFormat span(String name) {
        return new LogFormat.SpanFormat(name);
    }

    public LogFormat spans() {
        return this.spans;
    }

    public LogFormat text(Function0<String> value) {
        return new LogFormat.TextFormat((String)value.apply());
    }

    public LogFormat timestamp() {
        return this.timestamp;
    }

    public LogFormat timestamp(Function0<DateTimeFormatter> formatter) {
        return new LogFormat.TimestampFormat((DateTimeFormatter)formatter.apply());
    }

    public LogFormat default() {
        return this.default;
    }

    public LogFormat colored() {
        return this.colored;
    }

    public static final /* synthetic */ void $anonfun$empty$1(LogAppender x$85, Object x$86, FiberId x$87, LogLevel x$88, Function0 x$89, Cause x$90, FiberRefs x$91, List x$92, Map x$93) {
    }

    private LogFormat$() {
        MODULE$ = this;
        this.NL = System.lineSeparator();
        this.config = Config$.MODULE$.string().mapOrFail((Function1 & Serializable & scala.Serializable)value -> {
            Either<Parser.ParserError<String>, LogFormat.Pattern> either = LogFormat$Pattern$.MODULE$.parse((String)value);
            if (either instanceof Right) {
                LogFormat.Pattern p = (LogFormat.Pattern)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)p.toLogFormat());
            }
            if (either instanceof Left) {
                return package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(32).append("Expected a LogFormat, but found ").append((String)value).toString()));
            }
            throw new MatchError(either);
        });
        this.annotations = this.annotations((Set<String>)Predef$.MODULE$.Set().empty());
        this.logAnnotations = this.logAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
        this.allAnnotations = this.allAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
        this.bracketStart = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[");
        this.bracketEnd = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "]");
        this.empty = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93) -> {
            LogFormat$.$anonfun$empty$1(x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93);
            return BoxedUnit.UNIT;
        });
        this.enclosingClass = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$94, x$95, x$96, x$97, x$98, x$99, x$100) -> {
            Object object;
            Option option;
            Option option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace);
            if (!option2.isEmpty() && !(option = Trace$.MODULE$.unapply(object = option2.get())).isEmpty()) {
                String file = (String)((Tuple3)option.get())._2();
                builder.appendText(file);
                return BoxedUnit.UNIT;
            }
            builder.appendText("not-available");
            return BoxedUnit.UNIT;
        });
        this.fiberId = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$101, fiberId, x$102, x$103, x$104, x$105, x$106, x$107) -> {
            builder.appendText(fiberId.threadName());
            return BoxedUnit.UNIT;
        });
        this.level = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$108, x$109, level, x$110, x$111, x$112, x$113, x$114) -> {
            builder.appendText(level.label());
            return BoxedUnit.UNIT;
        });
        this.levelSyslog = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$115, x$116, level, x$117, x$118, x$119, x$120, x$121) -> {
            builder.appendText(Integer.toString(level.syslog()));
            return BoxedUnit.UNIT;
        });
        this.line = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$122, x$123, x$124, line, x$125, x$126, x$127, x$128) -> {
            builder.appendText((String)line.apply());
            return BoxedUnit.UNIT;
        });
        this.traceLine = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, trace, x$129, x$130, x$131, x$132, x$133, x$134, x$135) -> {
            Object object;
            Option option;
            Option option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace);
            if (!option2.isEmpty() && !(option = Trace$.MODULE$.unapply(object = option2.get())).isEmpty()) {
                int line = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3());
                builder.appendNumeric(BoxesRunTime.boxToInteger((int)line));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.cause = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$136, x$137, x$138, x$139, cause, x$140, x$141, x$142) -> {
            if (!cause.isEmpty()) {
                builder.appendCause((Cause<Object>)cause);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.newLine = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.NL());
        this.space = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> " ");
        this.quote = this.text((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "\"");
        this.spans = this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable & scala.Serializable)(builder, x$143, x$144, x$145, x$146, x$147, x$148, spans, x$149) -> {
            builder.appendKeyValues((Iterable<Tuple2<String, String>>)((Iterable)spans.map((Function1 & Serializable & scala.Serializable)span -> {
                String duration = Long.toString(System.currentTimeMillis() - span.startTime());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)span.label()), (Object)new StringBuilder(2).append(duration).append("ms").toString());
            }, List$.MODULE$.canBuildFrom())));
            return BoxedUnit.UNIT;
        });
        this.timestamp = this.timestamp((Function0<DateTimeFormatter>)(Function0 & Serializable & scala.Serializable)() -> DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.default = this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timestamp", this.timestamp().fixed(32)).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "level", this.level())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "thread", this.fiberId())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "message", this.quoted(this.line())).$plus(this.space().$plus(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "cause", this.cause())).filter(LogFilter$.MODULE$.causeNonEmpty())));
        this.colored = this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timestamp", this.timestamp().fixed(32)).color(LogColor$.MODULE$.BLUE()).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "level", this.level()).highlight()).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "thread", this.fiberId()).color(LogColor$.MODULE$.WHITE())).$bar$minus$bar(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "message", this.quoted(this.line())).highlight().$plus(this.space().$plus(this.label((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "cause", this.cause()).highlight()).filter(LogFilter$.MODULE$.causeNonEmpty())));
    }
}

