/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import zio.Cause;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Trace$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogAnnotation;
import zio.logging.LogColor;
import zio.logging.LogColor$;
import zio.logging.LogContext;
import zio.logging.LogFilter;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LoggerNameExtractor;
import zio.logging.internal.LogAppender;
import zio.logging.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LogFormat$ {
    public static final LogFormat$ MODULE$ = new LogFormat$();
    private static final String NL = System.lineSeparator();
    private static final LogFormat bracketStart = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> "[");
    private static final LogFormat bracketEnd = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> "]");
    private static final LogFormat enclosingClass = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, x$37, x$38, x$39, x$40, x$41, x$42, x$43) -> {
        Option option;
        Object object;
        Option option2;
        if (trace != null && !(option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace)).isEmpty() && (object = option2.get()) != null && !(option = Trace$.MODULE$.unapply(object)).isEmpty()) {
            String file = (String)((Tuple3)option.get())._2();
            builder.appendText(file);
            return BoxedUnit.UNIT;
        }
        builder.appendText("not-available");
        return BoxedUnit.UNIT;
    });
    private static final LogFormat fiberId = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$44, fiberId, x$45, x$46, x$47, x$48, x$49, x$50) -> {
        builder.appendText(fiberId.threadName());
        return BoxedUnit.UNIT;
    });
    private static final LogFormat level = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$51, x$52, level, x$53, x$54, x$55, x$56, x$57) -> {
        builder.appendText(level.label());
        return BoxedUnit.UNIT;
    });
    private static final LogFormat levelSyslog = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$58, x$59, level, x$60, x$61, x$62, x$63, x$64) -> {
        builder.appendText(Integer.toString(level.syslog()));
        return BoxedUnit.UNIT;
    });
    private static final LogFormat line = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$65, x$66, x$67, line, x$68, x$69, x$70, x$71) -> {
        builder.appendText((String)line.apply());
        return BoxedUnit.UNIT;
    });
    private static final LogFormat traceLine = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, x$72, x$73, x$74, x$75, x$76, x$77, x$78) -> {
        Option option;
        Object object;
        Option option2;
        if (trace != null && !(option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace)).isEmpty() && (object = option2.get()) != null && !(option = Trace$.MODULE$.unapply(object)).isEmpty()) {
            int line = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3());
            builder.appendNumeric(BoxesRunTime.boxToInteger((int)line));
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    });
    private static final LogFormat cause = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$79, x$80, x$81, x$82, cause, x$83, x$84, x$85) -> {
        if (!cause.isEmpty()) {
            builder.appendCause((Cause<Object>)cause);
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    });
    private static final LogFormat newLine = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> MODULE$.NL());
    private static final LogFormat space = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> " ");
    private static final LogFormat quote = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> "\"");
    private static final LogFormat timestamp = MODULE$.timestamp((Function0<DateTimeFormatter>)(Function0 & Serializable)() -> DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    private static final LogFormat default = MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "timestamp", MODULE$.timestamp().fixed(32)).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "level", MODULE$.level())).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "thread", MODULE$.fiberId())).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "message", MODULE$.quoted(MODULE$.line())).$plus(MODULE$.space().$plus(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "cause", MODULE$.cause())).filter(LogFilter$.MODULE$.causeNonEmpty())));
    private static final LogFormat colored = MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "timestamp", MODULE$.timestamp().fixed(32)).color(LogColor$.MODULE$.BLUE()).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "level", MODULE$.level()).highlight()).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "thread", MODULE$.fiberId()).color(LogColor$.MODULE$.WHITE())).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "message", MODULE$.quoted(MODULE$.line())).highlight().$plus(MODULE$.space().$plus(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "cause", MODULE$.cause()).highlight()).filter(LogFilter$.MODULE$.causeNonEmpty())));

    private String NL() {
        return NL;
    }

    public LogFormat make(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> format) {
        return new LogFormat(format){
            private final Function9 format$1;

            public final LogFormat $plus(LogFormat other) {
                return LogFormat.$plus$(this, other);
            }

            public final LogFormat $bar$minus$bar(LogFormat other) {
                return LogFormat.$bar$minus$bar$(this, other);
            }

            public final LogFormat color(String color) {
                return LogFormat.color$(this, color);
            }

            public final LogFormat concat(LogFormat other) {
                return LogFormat.concat$(this, other);
            }

            public final <M> LogFormat filter(LogFilter<M> filter) {
                return LogFormat.filter$(this, filter);
            }

            public final LogFormat fixed(int size) {
                return LogFormat.fixed$(this, size);
            }

            public final LogFormat highlight(Function1<LogLevel, LogColor> fn) {
                return LogFormat.highlight$(this, fn);
            }

            public final LogFormat highlight() {
                return LogFormat.highlight$(this);
            }

            public final LogFormat spaced(LogFormat other) {
                return LogFormat.spaced$(this, other);
            }

            public final ZLogger<String, String> toJsonLogger() {
                return LogFormat.toJsonLogger$(this);
            }

            public final ZLogger<String, String> toLogger() {
                return LogFormat.toLogger$(this);
            }

            public final ZLogger<String, BoxedUnit> unsafeFormat(LogAppender builder) {
                return LogFormat$.zio$logging$LogFormat$$$anonfun$make$1(builder, this.format$1);
            }
            {
                this.format$1 = format$1;
                LogFormat.$init$(this);
            }
        };
    }

    public LogFormat loggerName(LoggerNameExtractor loggerNameExtractor, String loggerNameDefault) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, x$4, x$5, x$6, x$7, context, x$8, annotations) -> {
            LogFormat$.$anonfun$loggerName$1(loggerNameExtractor, loggerNameDefault, builder, trace, x$4, x$5, x$6, x$7, context, x$8, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public String loggerName$default$2() {
        return "zio-logger";
    }

    public LogFormat annotation(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$9, x$10, x$11, x$12, x$13, x$14, x$15, annotations) -> {
            LogFormat$.$anonfun$annotation$1(name, builder, x$9, x$10, x$11, x$12, x$13, x$14, x$15, annotations);
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat logAnnotation(LogAnnotation<A> ann) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$16, x$17, x$18, x$19, x$20, fiberRefs, x$21, x$22) -> {
            LogFormat$.$anonfun$logAnnotation$1(ann, builder, x$16, x$17, x$18, x$19, x$20, fiberRefs, x$21, x$22);
            return BoxedUnit.UNIT;
        });
    }

    public <A> LogFormat annotation(LogAnnotation<A> ann) {
        return this.logAnnotation(ann);
    }

    public LogFormat annotations() {
        return this.annotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat annotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$23, x$24, x$25, x$26, x$27, x$28, x$29, annotations) -> {
            annotations.foreach((Function1 & Serializable)x0$1 -> {
                LogFormat$.$anonfun$annotations$2(excludeKeys$1, builder, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat logAnnotations() {
        return this.logAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat logAnnotations(Set<String> excludeKeys) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$30, x$31, x$32, x$33, x$34, fiberRefs, x$35, x$36) -> {
            LogFormat$.$anonfun$logAnnotations$1(excludeKeys, builder, x$30, x$31, x$32, x$33, x$34, fiberRefs, x$35, x$36);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat allAnnotations() {
        return this.allAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    }

    public LogFormat allAnnotations(Set<String> excludeKeys) {
        return this.annotations(excludeKeys).$plus(this.logAnnotations(excludeKeys));
    }

    public LogFormat bracketed(LogFormat inner) {
        return this.bracketStart().$plus(inner).$plus(this.bracketEnd());
    }

    public LogFormat bracketStart() {
        return bracketStart;
    }

    public LogFormat bracketEnd() {
        return bracketEnd;
    }

    public LogFormat enclosingClass() {
        return enclosingClass;
    }

    public LogFormat fiberId() {
        return fiberId;
    }

    public LogFormat level() {
        return level;
    }

    public LogFormat levelSyslog() {
        return levelSyslog;
    }

    public LogFormat line() {
        return line;
    }

    public LogFormat traceLine() {
        return traceLine;
    }

    public LogFormat cause() {
        return cause;
    }

    public LogFormat ifCauseNonEmpty(LogFormat format) {
        return format.filter(LogFilter$.MODULE$.causeNonEmpty());
    }

    public LogFormat label(Function0<String> label, LogFormat value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, fiberId, logLevel, message, cause, context, spans, annotations) -> {
            Object object;
            builder.openKey();
            try {
                builder.appendText((String)label.apply());
            }
            finally {
                builder.closeKeyOpenValue();
            }
            try {
                object = value.unsafeFormat((LogAppender)builder).apply(trace, fiberId, logLevel, message, cause, context, spans, annotations);
            }
            finally {
                builder.closeValue();
            }
            return object;
        });
    }

    public LogFormat newLine() {
        return newLine;
    }

    public LogFormat space() {
        return space;
    }

    public LogFormat quote() {
        return quote;
    }

    public LogFormat quoted(LogFormat inner) {
        return this.quote().$plus(inner).$plus(this.quote());
    }

    public LogFormat span(String name) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$86, x$87, x$88, x$89, x$90, x$91, spans, x$92) -> {
            LogFormat$.$anonfun$span$1(name, builder, x$86, x$87, x$88, x$89, x$90, x$91, spans, x$92);
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat spans() {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$94, x$95, x$96, x$97, x$98, x$99, spans, x$100) -> {
            spans.foreach((Function1 & Serializable)span -> {
                LogFormat$.$anonfun$spans$2(builder, span);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat text(Function0<String> value) {
        return this.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108) -> {
            builder.appendText((String)value.apply());
            return BoxedUnit.UNIT;
        });
    }

    public LogFormat timestamp() {
        return timestamp;
    }

    public LogFormat timestamp(Function0<DateTimeFormatter> formatter) {
        return this.text((Function0<String>)(Function0 & Serializable)() -> {
            ZonedDateTime now = ZonedDateTime.now();
            return ((DateTimeFormatter)formatter.apply()).format(now);
        });
    }

    public LogFormat default() {
        return default;
    }

    public LogFormat colored() {
        return colored;
    }

    public static final /* synthetic */ ZLogger zio$logging$LogFormat$$$anonfun$make$1(LogAppender builder, Function9 format$1) {
        return new ZLogger<String, BoxedUnit>(format$1, builder){
            private final Function9 format$1;
            private final LogAppender builder$3;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.$plus$plus$((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.$plus$greater$((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.$less$plus$((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.contramap$((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.filterLogLevel$((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.map$((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.test$((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
                this.format$1.apply((Object)this.builder$3, trace, (Object)fiberId, (Object)logLevel, message, cause, (Object)context, spans, annotations);
            }
            {
                this.format$1 = format$1;
                this.builder$3 = builder$3;
                ZLogger.$init$((ZLogger)this);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$loggerName$1(LoggerNameExtractor loggerNameExtractor$1, String loggerNameDefault$1, LogAppender builder, Object trace, FiberId x$4, LogLevel x$5, Function0 x$6, Cause x$7, FiberRefs context, List x$8, Map annotations) {
        String loggerName = (String)loggerNameExtractor$1.apply(trace, context, (Map<String, String>)annotations).getOrElse((Function0 & Serializable)() -> loggerNameDefault$1);
        builder.appendText(loggerName);
    }

    public static final /* synthetic */ void $anonfun$annotation$1(String name$1, LogAppender builder, Object x$9, FiberId x$10, LogLevel x$11, Function0 x$12, Cause x$13, FiberRefs x$14, List x$15, Map annotations) {
        annotations.get((Object)name$1).foreach((Function1 & Serializable)value -> {
            builder.appendKeyValue(name$1, value);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotation$2(LogAnnotation ann$1, LogAppender builder$5, LogContext context) {
        context.get(ann$1).foreach((Function1 & Serializable)value -> {
            builder$5.appendKeyValue(ann$1.name(), (String)ann$1.render().apply(value));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotation$1(LogAnnotation ann$1, LogAppender builder, Object x$16, FiberId x$17, LogLevel x$18, Function0 x$19, Cause x$20, FiberRefs fiberRefs, List x$21, Map x$22) {
        fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1 & Serializable)context -> {
            LogFormat$.$anonfun$logAnnotation$2(ann$1, builder, context);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$annotations$2(Set excludeKeys$1, LogAppender builder$6, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            if (!excludeKeys$1.contains((Object)key)) {
                builder$6.appendKeyValue(key, value);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$3(Set excludeKeys$2, LogAppender builder$7, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            if (!excludeKeys$2.contains((Object)key)) {
                builder$7.appendKeyValue(key, value);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$2(Set excludeKeys$2, LogAppender builder$7, LogContext context) {
        context.asMap().foreach((Function1 & Serializable)x0$1 -> {
            LogFormat$.$anonfun$logAnnotations$3(excludeKeys$2, builder$7, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logAnnotations$1(Set excludeKeys$2, LogAppender builder, Object x$30, FiberId x$31, LogLevel x$32, Function0 x$33, Cause x$34, FiberRefs fiberRefs, List x$35, Map x$36) {
        fiberRefs.get(package$.MODULE$.logContext()).foreach((Function1 & Serializable)context -> {
            LogFormat$.$anonfun$logAnnotations$2(excludeKeys$2, builder, context);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$span$2(String name$2, LogSpan x$93) {
        String string = x$93.label();
        return !(string != null ? !string.equals(name$2) : name$2 != null);
    }

    public static final /* synthetic */ void $anonfun$span$3(LogAppender builder$8, String name$2, LogSpan span) {
        String duration = Long.toString(System.currentTimeMillis() - span.startTime());
        builder$8.appendKeyValue(name$2, duration);
    }

    public static final /* synthetic */ void $anonfun$span$1(String name$2, LogAppender builder, Object x$86, FiberId x$87, LogLevel x$88, Function0 x$89, Cause x$90, FiberRefs x$91, List spans, Map x$92) {
        spans.find((Function1 & Serializable)x$93 -> BoxesRunTime.boxToBoolean((boolean)LogFormat$.$anonfun$span$2(name$2, x$93))).foreach((Function1 & Serializable)span -> {
            LogFormat$.$anonfun$span$3(builder, name$2, span);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$spans$2(LogAppender builder$9, LogSpan span) {
        String duration = Long.toString(System.currentTimeMillis() - span.startTime());
        builder$9.appendKeyValue(span.label(), new StringBuilder(2).append(duration).append("ms").toString());
    }

    private LogFormat$() {
    }
}

