/*
 * Decompiled with CFR 0.152.
 */
package zio.logging;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Function9;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk$;
import zio.Config;
import zio.Config$;
import zio.FiberId;
import zio.FiberRefs;
import zio.LogLevel;
import zio.LogSpan;
import zio.Trace$;
import zio.ZLogger;
import zio.Zippable;
import zio.logging.LogAnnotation;
import zio.logging.LogColor$;
import zio.logging.LogFilter$;
import zio.logging.LogFormat;
import zio.logging.LogFormat$Pattern$;
import zio.logging.LoggerNameExtractor;
import zio.logging.internal.LogAppender;
import zio.parser.Parser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LogFormat$ {
    public static final LogFormat$ MODULE$ = new LogFormat$();
    private static final String NL = System.lineSeparator();
    private static final Config<LogFormat> config = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)value -> {
        Either<Parser.ParserError<String>, LogFormat.Pattern> either = LogFormat$Pattern$.MODULE$.parse((String)value);
        if (either instanceof Right) {
            LogFormat.Pattern p = (LogFormat.Pattern)((Right)either).value();
            return package$.MODULE$.Right().apply((Object)p.toLogFormat());
        }
        if (either instanceof Left) {
            return package$.MODULE$.Left().apply((Object)new Config.Error$.InvalidData(Chunk$.MODULE$.empty(), new StringBuilder(32).append("Expected a LogFormat, but found ").append((String)value).toString()));
        }
        throw new MatchError(either);
    });
    private static final LogFormat annotations = MODULE$.annotations((Set<String>)Predef$.MODULE$.Set().empty());
    private static final LogFormat logAnnotations = MODULE$.logAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    private static final LogFormat allAnnotations = MODULE$.allAnnotations((Set<String>)Predef$.MODULE$.Set().empty());
    private static final LogFormat bracketStart = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> "[");
    private static final LogFormat bracketEnd = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> "]");
    private static final LogFormat empty = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92) -> {
        LogFormat$.$anonfun$empty$1(x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92);
        return BoxedUnit.UNIT;
    });
    private static final LogFormat enclosingClass = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, x$93, x$94, x$95, x$96, x$97, x$98, x$99) -> {
        Option option;
        Object object;
        Option option2;
        if (trace != null && !(option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace)).isEmpty() && (object = option2.get()) != null && !(option = Trace$.MODULE$.unapply(object)).isEmpty()) {
            String file = (String)((Tuple3)option.get())._2();
            builder.appendText(file);
            return BoxedUnit.UNIT;
        }
        builder.appendText("not-available");
        return BoxedUnit.UNIT;
    });
    private static final LogFormat fiberId = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$100, fiberId, x$101, x$102, x$103, x$104, x$105, x$106) -> {
        builder.appendText(fiberId.threadName());
        return BoxedUnit.UNIT;
    });
    private static final LogFormat level = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$107, x$108, level, x$109, x$110, x$111, x$112, x$113) -> {
        builder.appendText(level.label());
        return BoxedUnit.UNIT;
    });
    private static final LogFormat levelSyslog = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$114, x$115, level, x$116, x$117, x$118, x$119, x$120) -> {
        builder.appendText(Integer.toString(level.syslog()));
        return BoxedUnit.UNIT;
    });
    private static final LogFormat line = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$121, x$122, x$123, line, x$124, x$125, x$126, x$127) -> {
        builder.appendText((String)line.apply());
        return BoxedUnit.UNIT;
    });
    private static final LogFormat traceLine = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, trace, x$128, x$129, x$130, x$131, x$132, x$133, x$134) -> {
        Option option;
        Object object;
        Option option2;
        if (trace != null && !(option2 = ClassTag$.MODULE$.apply(Object.class).unapply(trace)).isEmpty() && (object = option2.get()) != null && !(option = Trace$.MODULE$.unapply(object)).isEmpty()) {
            int line = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3());
            builder.appendNumeric(BoxesRunTime.boxToInteger((int)line));
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    });
    private static final LogFormat cause = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$135, x$136, x$137, x$138, cause, x$139, x$140, x$141) -> {
        if (!cause.isEmpty()) {
            builder.appendCause((Cause<Object>)cause);
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    });
    private static final LogFormat newLine = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> MODULE$.NL());
    private static final LogFormat space = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> " ");
    private static final LogFormat quote = MODULE$.text((Function0<String>)(Function0 & Serializable)() -> "\"");
    private static final LogFormat spans = MODULE$.make((Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object>)(Function9 & Serializable)(builder, x$142, x$143, x$144, x$145, x$146, x$147, spans, x$148) -> {
        builder.appendKeyValues((Iterable<Tuple2<String, String>>)spans.map((Function1 & Serializable)span -> {
            String duration = Long.toString(System.currentTimeMillis() - span.startTime());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)span.label()), (Object)new StringBuilder(2).append(duration).append("ms").toString());
        }));
        return BoxedUnit.UNIT;
    });
    private static final LogFormat timestamp = MODULE$.timestamp((Function0<DateTimeFormatter>)(Function0 & Serializable)() -> DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    private static final LogFormat default = MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "timestamp", MODULE$.timestamp().fixed(32)).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "level", MODULE$.level())).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "thread", MODULE$.fiberId())).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "message", MODULE$.quoted(MODULE$.line())).$plus(MODULE$.space().$plus(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "cause", MODULE$.cause())).filter(LogFilter$.MODULE$.causeNonEmpty())));
    private static final LogFormat colored = MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "timestamp", MODULE$.timestamp().fixed(32)).color(LogColor$.MODULE$.BLUE()).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "level", MODULE$.level()).highlight()).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "thread", MODULE$.fiberId()).color(LogColor$.MODULE$.WHITE())).$bar$minus$bar(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "message", MODULE$.quoted(MODULE$.line())).highlight().$plus(MODULE$.space().$plus(MODULE$.label((Function0<String>)(Function0 & Serializable)() -> "cause", MODULE$.cause()).highlight()).filter(LogFilter$.MODULE$.causeNonEmpty())));

    public ZLogger<String, BoxedUnit> makeLogger(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> fn, LogAppender builder) {
        return new ZLogger<String, BoxedUnit>(fn, builder){
            private final Function9 fn$1;
            private final LogAppender builder$3;

            public <M extends String, O> ZLogger<M, Object> $plus$plus(ZLogger<M, O> that, Zippable<BoxedUnit, O> zippable) {
                return ZLogger.$plus$plus$((ZLogger)this, that, zippable);
            }

            public <M extends String, O> ZLogger<M, O> $plus$greater(ZLogger<M, O> that) {
                return ZLogger.$plus$greater$((ZLogger)this, that);
            }

            public <M extends String> ZLogger<M, BoxedUnit> $less$plus(ZLogger<M, Object> that) {
                return ZLogger.$less$plus$((ZLogger)this, that);
            }

            public final <Message1> ZLogger<Message1, BoxedUnit> contramap(Function1<Message1, String> f) {
                return ZLogger.contramap$((ZLogger)this, f);
            }

            public final ZLogger<String, Option<BoxedUnit>> filterLogLevel(Function1<LogLevel, Object> f) {
                return ZLogger.filterLogLevel$((ZLogger)this, f);
            }

            public final <B> ZLogger<String, B> map(Function1<BoxedUnit, B> f) {
                return ZLogger.map$((ZLogger)this, f);
            }

            public final Object test(Function0 input) {
                return ZLogger.test$((ZLogger)this, (Function0)input);
            }

            public void apply(Object trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Cause<Object> cause, FiberRefs context, List<LogSpan> spans, Map<String, String> annotations) {
                this.fn$1.apply((Object)this.builder$3, trace, (Object)fiberId, (Object)logLevel, message, cause, (Object)context, spans, annotations);
            }
            {
                this.fn$1 = fn$1;
                this.builder$3 = builder$3;
                ZLogger.$init$((ZLogger)this);
            }
        };
    }

    private String NL() {
        return NL;
    }

    public Config<LogFormat> config() {
        return config;
    }

    public LogFormat make(Function9<LogAppender, Object, FiberId, LogLevel, Function0<String>, Cause<Object>, FiberRefs, List<LogSpan>, Map<String, String>, Object> format) {
        return new LogFormat.FnFormat(format);
    }

    public LogFormat loggerName(LoggerNameExtractor loggerNameExtractor, String loggerNameDefault) {
        return new LogFormat.LoggerNameFormat(loggerNameExtractor, loggerNameDefault);
    }

    public String loggerName$default$2() {
        return "zio-logger";
    }

    public LogFormat annotation(String name) {
        return new LogFormat.AnnotationFormat(name);
    }

    public <A> LogFormat logAnnotation(LogAnnotation<A> ann) {
        return new LogFormat.LogAnnotationFormat<A>(ann);
    }

    public <A> LogFormat annotation(LogAnnotation<A> ann) {
        return this.logAnnotation(ann);
    }

    public LogFormat anyAnnotation(String name) {
        return new LogFormat.AnyAnnotationFormat(name);
    }

    public LogFormat annotations() {
        return annotations;
    }

    public LogFormat annotations(Set<String> excludeKeys) {
        return new LogFormat.AnnotationsFormat(excludeKeys);
    }

    public LogFormat logAnnotations() {
        return logAnnotations;
    }

    public LogFormat logAnnotations(Set<String> excludeKeys) {
        return new LogFormat.LogAnnotationsFormat(excludeKeys);
    }

    public LogFormat allAnnotations() {
        return allAnnotations;
    }

    public LogFormat allAnnotations(Set<String> excludeKeys) {
        return new LogFormat.AllAnnotationsFormat(excludeKeys);
    }

    public LogFormat bracketed(LogFormat inner) {
        return this.bracketStart().$plus(inner).$plus(this.bracketEnd());
    }

    public LogFormat bracketStart() {
        return bracketStart;
    }

    public LogFormat bracketEnd() {
        return bracketEnd;
    }

    public LogFormat empty() {
        return empty;
    }

    public LogFormat enclosingClass() {
        return enclosingClass;
    }

    public LogFormat fiberId() {
        return fiberId;
    }

    public LogFormat level() {
        return level;
    }

    public LogFormat levelSyslog() {
        return levelSyslog;
    }

    public LogFormat line() {
        return line;
    }

    public LogFormat traceLine() {
        return traceLine;
    }

    public LogFormat cause() {
        return cause;
    }

    public LogFormat label(Function0<String> label, LogFormat value) {
        return new LogFormat.LabelFormat((String)label.apply(), value);
    }

    public LogFormat newLine() {
        return newLine;
    }

    public LogFormat space() {
        return space;
    }

    public LogFormat quote() {
        return quote;
    }

    public LogFormat quoted(LogFormat inner) {
        return this.quote().$plus(inner).$plus(this.quote());
    }

    public LogFormat span(String name) {
        return new LogFormat.SpanFormat(name);
    }

    public LogFormat spans() {
        return spans;
    }

    public LogFormat text(Function0<String> value) {
        return new LogFormat.TextFormat((String)value.apply());
    }

    public LogFormat timestamp() {
        return timestamp;
    }

    public LogFormat timestamp(Function0<DateTimeFormatter> formatter) {
        return new LogFormat.TimestampFormat((DateTimeFormatter)formatter.apply());
    }

    public LogFormat default() {
        return default;
    }

    public LogFormat colored() {
        return colored;
    }

    public static final /* synthetic */ void $anonfun$empty$1(LogAppender x$84, Object x$85, FiberId x$86, LogLevel x$87, Function0 x$88, Cause x$89, FiberRefs x$90, List x$91, Map x$92) {
    }

    private LogFormat$() {
    }
}

